/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.skins.GaugeSkinBase;
import eu.hansolo.medusa.tools.Helper;
import java.util.List;
import java.util.Locale;
import javafx.beans.InvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;

public class SimpleSkin
extends GaugeSkinBase {
    private double START_ANGLE = 315.0;
    private double ANGLE_RANGE = 270.0;
    private double size;
    private Pane pane;
    private Canvas sectionsCanvas;
    private GraphicsContext sectionsCtx;
    private Path needle;
    private MoveTo needleMoveTo1;
    private CubicCurveTo needleCubicCurveTo2;
    private CubicCurveTo needleCubicCurveTo3;
    private CubicCurveTo needleCubicCurveTo4;
    private LineTo needleLineTo5;
    private LineTo needleLineTo6;
    private CubicCurveTo needleCubicCurveTo7;
    private ClosePath needleClosePath8;
    private Rotate needleRotate;
    private Text valueText;
    private Text titleText;
    private Text subTitleText;
    private double angleStep;
    private String formatString;
    private Locale locale;
    private List<Section> sections;
    private boolean highlightSections;
    private double minValue;
    private double maxValue;
    private ListChangeListener<Section> sectionListener;
    private InvalidationListener currentValueListener;

    public SimpleSkin(Gauge gauge) {
        super(gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.angleStep = this.ANGLE_RANGE / (gauge.getMaxValue() - gauge.getMinValue());
        this.formatString = "%." + Integer.toString(gauge.getDecimals()) + "f";
        this.locale = gauge.getLocale();
        this.sections = gauge.getSections();
        this.highlightSections = gauge.isHighlightSections();
        this.minValue = gauge.getMinValue();
        this.maxValue = gauge.getMaxValue();
        this.sectionListener = c -> this.handleEvents("RESIZE");
        this.currentValueListener = o -> this.rotateNeedle(gauge.getCurrentValue());
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.gauge.getPrefWidth(), 0.0) <= 0 || Double.compare(this.gauge.getPrefHeight(), 0.0) <= 0 || Double.compare(this.gauge.getWidth(), 0.0) <= 0 || Double.compare(this.gauge.getHeight(), 0.0) <= 0) {
            if (this.gauge.getPrefWidth() > 0.0 && this.gauge.getPrefHeight() > 0.0) {
                this.gauge.setPrefSize(this.gauge.getPrefWidth(), this.gauge.getPrefHeight());
            } else {
                this.gauge.setPrefSize(250.0, 250.0);
            }
        }
        this.sectionsCanvas = new Canvas(250.0, 250.0);
        this.sectionsCtx = this.sectionsCanvas.getGraphicsContext2D();
        this.needleRotate = new Rotate(180.0 - this.START_ANGLE);
        this.angleStep = this.ANGLE_RANGE / this.gauge.getRange();
        double targetAngle = 180.0 - this.START_ANGLE + (this.gauge.getValue() - this.gauge.getMinValue()) * this.angleStep;
        this.needleRotate.setAngle(Helper.clamp(180.0 - this.START_ANGLE, 180.0 - this.START_ANGLE + this.ANGLE_RANGE, targetAngle));
        this.needleMoveTo1 = new MoveTo();
        this.needleCubicCurveTo2 = new CubicCurveTo();
        this.needleCubicCurveTo3 = new CubicCurveTo();
        this.needleCubicCurveTo4 = new CubicCurveTo();
        this.needleLineTo5 = new LineTo();
        this.needleLineTo6 = new LineTo();
        this.needleCubicCurveTo7 = new CubicCurveTo();
        this.needleClosePath8 = new ClosePath();
        this.needle = new Path(new PathElement[]{this.needleMoveTo1, this.needleCubicCurveTo2, this.needleCubicCurveTo3, this.needleCubicCurveTo4, this.needleLineTo5, this.needleLineTo6, this.needleCubicCurveTo7, this.needleClosePath8});
        this.needle.setFillRule(FillRule.EVEN_ODD);
        this.needle.getTransforms().setAll((Object[])new Transform[]{this.needleRotate});
        this.needle.setFill((Paint)this.gauge.getNeedleColor());
        this.needle.setStroke(this.gauge.getBorderPaint());
        this.needle.setStrokeLineCap(StrokeLineCap.ROUND);
        this.needle.setStrokeLineJoin(StrokeLineJoin.BEVEL);
        this.valueText = new Text(String.format(this.locale, this.formatString, this.gauge.getMinValue()) + this.gauge.getUnit());
        this.valueText.setMouseTransparent(true);
        this.valueText.setTextOrigin(VPos.CENTER);
        this.valueText.setFill((Paint)this.gauge.getValueColor());
        Helper.enableNode((Node)this.valueText, this.gauge.isValueVisible());
        this.titleText = new Text(this.gauge.getTitle());
        this.titleText.setTextOrigin(VPos.CENTER);
        this.titleText.setFill((Paint)this.gauge.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.gauge.getTitle().isEmpty());
        this.subTitleText = new Text(this.gauge.getSubTitle());
        this.subTitleText.setTextOrigin(VPos.CENTER);
        this.subTitleText.setFill((Paint)this.gauge.getSubTitleColor());
        Helper.enableNode((Node)this.subTitleText, !this.gauge.getSubTitle().isEmpty());
        this.pane = new Pane(new Node[]{this.sectionsCanvas, this.needle, this.valueText, this.titleText, this.subTitleText});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.gauge.getSections().addListener(this.sectionListener);
        this.gauge.currentValueProperty().addListener(this.currentValueListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("FINISHED".equals(EVENT_TYPE)) {
            if (this.gauge.getCheckSectionsForValue()) {
                double currentValue = this.gauge.getCurrentValue();
                int listSize = this.sections.size();
                for (int i = 0; i < listSize; ++i) {
                    this.sections.get(i).checkForValue(currentValue);
                }
            }
            if (this.highlightSections) {
                this.drawSections();
            }
        } else if ("RECALC".equals(EVENT_TYPE)) {
            this.minValue = this.gauge.getMinValue();
            this.maxValue = this.gauge.getMaxValue();
            this.angleStep = this.ANGLE_RANGE / this.gauge.getRange();
            this.needleRotate.setAngle(180.0 - this.START_ANGLE + (this.gauge.getValue() - this.gauge.getMinValue()) * this.angleStep);
            this.resize();
            this.rotateNeedle(this.gauge.getCurrentValue());
        } else if ("SECTION".equals(EVENT_TYPE)) {
            this.sections = this.gauge.getSections();
            this.highlightSections = this.gauge.isHighlightSections();
            this.resize();
            this.redraw();
        } else if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.valueText, this.gauge.isValueVisible());
            Helper.enableNode((Node)this.titleText, !this.gauge.getTitle().isEmpty());
            Helper.enableNode((Node)this.subTitleText, !this.gauge.getSubTitle().isEmpty());
        }
    }

    @Override
    public void dispose() {
        this.gauge.getSections().removeListener(this.sectionListener);
        this.gauge.currentValueProperty().removeListener(this.currentValueListener);
        super.dispose();
    }

    private void rotateNeedle(double VALUE) {
        double targetAngle = 180.0 - this.START_ANGLE + (VALUE - this.gauge.getMinValue()) * this.angleStep;
        this.needleRotate.setAngle(Helper.clamp(180.0 - this.START_ANGLE, 180.0 - this.START_ANGLE + this.ANGLE_RANGE, targetAngle));
        this.valueText.setText(String.format(this.locale, this.formatString, VALUE) + this.gauge.getUnit());
        this.valueText.setTranslateX((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5);
        if (this.valueText.getLayoutBounds().getWidth() > 0.395 * this.size) {
            this.resizeText();
        }
    }

    private void drawSections() {
        this.sectionsCtx.clearRect(0.0, 0.0, this.size, this.size);
        double value = this.gauge.getCurrentValue();
        boolean sectionTextVisible = this.gauge.isSectionTextVisible();
        boolean sectionIconVisible = this.gauge.getSectionIconsVisible();
        double offset = this.START_ANGLE - 90.0;
        int listSize = this.sections.size();
        double xy = this.size * 0.015;
        double wh = this.size - this.size * 0.03;
        double sectionXY = this.size * 0.1375;
        double sectionWH = this.size - this.size * 0.275;
        this.angleStep = this.ANGLE_RANGE / this.gauge.getRange();
        this.sectionsCtx.setLineWidth(this.size * 0.27);
        this.sectionsCtx.setLineCap(StrokeLineCap.BUTT);
        for (int i = 0; i < listSize; ++i) {
            Image icon;
            double cosValue;
            double sinValue;
            Section section = this.sections.get(i);
            if (section.getStart() > this.maxValue || section.getStop() < this.minValue) continue;
            double SECTION_START_ANGLE = section.getStart() < this.minValue && section.getStop() < this.maxValue ? 0.0 : (section.getStart() - this.minValue) * this.angleStep;
            double SECTION_ANGLE_EXTEND = Double.compare(section.getStop(), this.maxValue) > 0 ? (this.maxValue - section.getStart()) * this.angleStep : (Double.compare(section.getStart(), this.minValue) < 0 ? (section.getStop() - this.minValue) * this.angleStep : (section.getStop() - section.getStart()) * this.angleStep);
            this.sectionsCtx.save();
            if (this.highlightSections) {
                this.sectionsCtx.setStroke((Paint)(section.contains(value) ? section.getHighlightColor() : section.getColor()));
            } else {
                this.sectionsCtx.setStroke((Paint)section.getColor());
            }
            this.sectionsCtx.strokeArc(sectionXY, sectionXY, sectionWH, sectionWH, offset - SECTION_START_ANGLE, -SECTION_ANGLE_EXTEND, ArcType.OPEN);
            if (sectionTextVisible) {
                sinValue = -Math.sin(Math.toRadians(offset - 90.0 - SECTION_START_ANGLE - SECTION_ANGLE_EXTEND * 0.5));
                cosValue = -Math.cos(Math.toRadians(offset - 90.0 - SECTION_START_ANGLE - SECTION_ANGLE_EXTEND * 0.5));
                Point2D textPoint = new Point2D(this.size * 0.5 + this.size * 0.365 * sinValue, this.size * 0.5 + this.size * 0.365 * cosValue);
                this.sectionsCtx.setFont(Fonts.robotoMedium(0.08 * this.size));
                this.sectionsCtx.setTextAlign(TextAlignment.CENTER);
                this.sectionsCtx.setTextBaseline(VPos.CENTER);
                this.sectionsCtx.setFill((Paint)section.getTextColor());
                this.sectionsCtx.fillText(section.getText(), textPoint.getX(), textPoint.getY(), 0.2 * this.size);
            } else if (this.size > 0.0 && sectionIconVisible && null != (icon = section.getImage())) {
                sinValue = -Math.sin(Math.toRadians(offset - 90.0 - SECTION_START_ANGLE - SECTION_ANGLE_EXTEND * 0.5));
                cosValue = -Math.cos(Math.toRadians(offset - 90.0 - SECTION_START_ANGLE - SECTION_ANGLE_EXTEND * 0.5));
                Point2D iconPoint = new Point2D(this.size * 0.5 + this.size * 0.365 * sinValue, this.size * 0.5 + this.size * 0.365 * cosValue);
                this.sectionsCtx.drawImage(icon, iconPoint.getX() - this.size * 0.06, iconPoint.getY() - this.size * 0.06, this.size * 0.12, this.size * 0.12);
            }
            this.sectionsCtx.restore();
        }
        this.sectionsCtx.setStroke(this.gauge.getBorderPaint());
        this.sectionsCtx.setLineWidth(this.size * 0.025);
        this.sectionsCtx.strokeArc(xy, xy, wh, wh, offset + 90.0, this.ANGLE_RANGE, ArcType.ROUND);
        if (this.gauge.getTickLabelsVisible()) {
            this.sectionsCtx.setFont(Fonts.robotoRegular(this.size * 0.1));
            this.sectionsCtx.setFill((Paint)this.gauge.getTickLabelColor());
            this.sectionsCtx.setTextBaseline(VPos.TOP);
            this.sectionsCtx.setTextAlign(TextAlignment.LEFT);
            this.sectionsCtx.fillText(String.format(this.locale, "%." + this.gauge.getTickLabelDecimals() + "f", this.gauge.getMinValue()), this.size * 0.15075377, this.size * 0.86180905, this.size * 0.3);
            this.sectionsCtx.setTextAlign(TextAlignment.RIGHT);
            this.sectionsCtx.fillText(String.format(this.locale, "%." + this.gauge.getTickLabelDecimals() + "f", this.gauge.getMaxValue()), this.size * 0.84924623, this.size * 0.86180905, this.size * 0.3);
        }
    }

    private void resizeText() {
        double fontSize = this.size * 0.25;
        double maxWidth = 0.35 * this.size;
        this.valueText.setFont(Fonts.robotoMedium(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
        this.valueText.setTranslateX((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5);
        this.valueText.setTranslateY(this.size * (this.titleText.getText().isEmpty() ? 0.5 : 0.46));
        fontSize = this.size * 0.075;
        maxWidth = this.size * 0.3;
        this.titleText.setFont(Fonts.robotoMedium(fontSize));
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        this.titleText.setTranslateX((this.size - this.titleText.getLayoutBounds().getWidth()) * 0.5);
        this.titleText.setTranslateY(this.size * 0.5 + this.valueText.getFont().getSize() * 0.45);
        maxWidth = this.size * 0.45;
        this.subTitleText.setFont(Fonts.robotoMedium(fontSize));
        if (this.subTitleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.subTitleText, maxWidth, fontSize);
        }
        this.subTitleText.setTranslateX((this.size - this.subTitleText.getLayoutBounds().getWidth()) * 0.5);
        this.subTitleText.setTranslateY(this.size * 0.8);
    }

    @Override
    protected void resize() {
        double height;
        double width = this.gauge.getWidth() - this.gauge.getInsets().getLeft() - this.gauge.getInsets().getRight();
        double d = this.size = width < (height = this.gauge.getHeight() - this.gauge.getInsets().getTop() - this.gauge.getInsets().getBottom()) ? width : height;
        if (this.size > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((this.gauge.getWidth() - this.size) * 0.5, (this.gauge.getHeight() - this.size) * 0.5);
            this.sectionsCanvas.setCache(false);
            this.sectionsCanvas.setWidth(this.size);
            this.sectionsCanvas.setHeight(this.size);
            this.drawSections();
            this.sectionsCanvas.setCache(true);
            this.sectionsCanvas.setCacheHint(CacheHint.QUALITY);
            this.needle.setCache(false);
            this.needleMoveTo1.setX(0.275 * this.size);
            this.needleMoveTo1.setY(0.5 * this.size);
            this.needleCubicCurveTo2.setControlX1(0.275 * this.size);
            this.needleCubicCurveTo2.setControlY1(0.62426575 * this.size);
            this.needleCubicCurveTo2.setControlX2(0.37573425 * this.size);
            this.needleCubicCurveTo2.setControlY2(0.725 * this.size);
            this.needleCubicCurveTo2.setX(0.5 * this.size);
            this.needleCubicCurveTo2.setY(0.725 * this.size);
            this.needleCubicCurveTo3.setControlX1(0.62426575 * this.size);
            this.needleCubicCurveTo3.setControlY1(0.725 * this.size);
            this.needleCubicCurveTo3.setControlX2(0.725 * this.size);
            this.needleCubicCurveTo3.setControlY2(0.62426575 * this.size);
            this.needleCubicCurveTo3.setX(0.725 * this.size);
            this.needleCubicCurveTo3.setY(0.5 * this.size);
            this.needleCubicCurveTo4.setControlX1(0.725 * this.size);
            this.needleCubicCurveTo4.setControlY1(0.3891265 * this.size);
            this.needleCubicCurveTo4.setControlX2(0.6448105 * this.size);
            this.needleCubicCurveTo4.setControlY2(0.296985 * this.size);
            this.needleCubicCurveTo4.setX(0.5392625 * this.size);
            this.needleCubicCurveTo4.setY(0.2784125 * this.size);
            this.needleLineTo5.setX(0.5 * this.size);
            this.needleLineTo5.setY(0.004 * this.size);
            this.needleLineTo6.setX(0.4607375 * this.size);
            this.needleLineTo6.setY(0.2784125 * this.size);
            this.needleCubicCurveTo7.setControlX1(0.3551895 * this.size);
            this.needleCubicCurveTo7.setControlY1(0.296985 * this.size);
            this.needleCubicCurveTo7.setControlX2(0.275 * this.size);
            this.needleCubicCurveTo7.setControlY2(0.3891265 * this.size);
            this.needleCubicCurveTo7.setX(0.275 * this.size);
            this.needleCubicCurveTo7.setY(0.5 * this.size);
            this.needle.setCache(true);
            this.needle.setCacheHint(CacheHint.ROTATE);
            this.needle.setStrokeWidth(this.size * 0.025);
            this.needle.relocate(this.needle.getLayoutBounds().getMinX(), this.needle.getLayoutBounds().getMinY());
            this.needleRotate.setPivotX(this.size * 0.5);
            this.needleRotate.setPivotY(this.size * 0.5);
            double currentValue = (this.needleRotate.getAngle() + this.START_ANGLE - 180.0) / this.angleStep + this.gauge.getMinValue();
            this.valueText.setText(String.format(this.locale, "%." + this.gauge.getDecimals() + "f", currentValue) + this.gauge.getUnit());
            this.valueText.setVisible(this.gauge.isValueVisible());
            this.titleText.setText(this.gauge.getTitle());
            this.resizeText();
        }
    }

    @Override
    protected void redraw() {
        Helper.enableNode((Node)this.sectionsCanvas, this.gauge.getSectionsVisible());
        this.needle.setFill((Paint)this.gauge.getNeedleColor());
        this.needle.setStroke((Paint)this.gauge.getNeedleBorderColor());
        this.titleText.setFill((Paint)this.gauge.getTitleColor());
        this.subTitleText.setFill((Paint)this.gauge.getSubTitleColor());
        this.valueText.setFill((Paint)this.gauge.getValueColor());
        this.locale = this.gauge.getLocale();
        this.formatString = "%." + Integer.toString(this.gauge.getDecimals()) + "f";
        this.titleText.setText(this.gauge.getTitle());
        this.resizeText();
    }
}

