/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.skins.GaugeSkinBase;
import eu.hansolo.medusa.tools.Helper;
import java.util.Locale;
import javafx.beans.InvalidationListener;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Text;

public class WhiteSkin
extends GaugeSkinBase {
    private static final double ANGLE_RANGE = 360.0;
    private double size;
    private double center;
    private DropShadow shadow;
    private DropShadow textShadow;
    private Arc backgroundRing;
    private Arc barBackground;
    private Arc bar;
    private Text valueText;
    private Text unitText;
    private Pane pane;
    private double minValue;
    private double range;
    private double angleStep;
    private String formatString;
    private Locale locale;
    private InvalidationListener currentValueListener;

    public WhiteSkin(Gauge gauge) {
        super(gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.minValue = gauge.getMinValue();
        this.range = gauge.getRange();
        this.angleStep = 360.0 / this.range;
        this.formatString = "%." + Integer.toString(gauge.getDecimals()) + "f";
        this.locale = gauge.getLocale();
        this.currentValueListener = o -> this.setBar(gauge.getCurrentValue());
        this.initGraphics();
        this.registerListeners();
        this.setBar(gauge.getCurrentValue());
    }

    private void initGraphics() {
        if (Double.compare(this.gauge.getPrefWidth(), 0.0) <= 0 || Double.compare(this.gauge.getPrefHeight(), 0.0) <= 0 || Double.compare(this.gauge.getWidth(), 0.0) <= 0 || Double.compare(this.gauge.getHeight(), 0.0) <= 0) {
            if (this.gauge.getPrefWidth() > 0.0 && this.gauge.getPrefHeight() > 0.0) {
                this.gauge.setPrefSize(this.gauge.getPrefWidth(), this.gauge.getPrefHeight());
            } else {
                this.gauge.setPrefSize(250.0, 250.0);
            }
        }
        this.shadow = new DropShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 12.0, 0.0, 3.0, 3.0);
        this.textShadow = new DropShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 4.0, 0.0, 2.0, 2.0);
        this.valueText = new Text(String.format(Locale.US, "%.0f", this.gauge.getValue()));
        this.valueText.setFill((Paint)Color.WHITE);
        this.valueText.setFont(Fonts.robotoBold(51.5625));
        this.valueText.setTextOrigin(VPos.CENTER);
        this.valueText.relocate(125.0, 117.1875);
        this.valueText.setEffect((Effect)this.textShadow);
        Helper.enableNode((Node)this.valueText, this.gauge.isValueVisible());
        this.unitText = new Text(this.gauge.getUnit());
        this.unitText.setFill((Paint)Color.WHITE);
        this.unitText.setFont(Fonts.robotoBold(21.875));
        this.unitText.setTextOrigin(VPos.CENTER);
        this.unitText.relocate(125.0, 164.0625);
        this.unitText.setEffect((Effect)this.textShadow);
        Helper.enableNode((Node)this.unitText, !this.gauge.getUnit().isEmpty());
        this.backgroundRing = new Arc(125.0, 125.0, 107.8125, 107.8125, 0.0, 360.0);
        this.backgroundRing.setFill(null);
        this.backgroundRing.setStroke((Paint)Color.rgb((int)255, (int)255, (int)255, (double)0.9));
        this.backgroundRing.setStrokeLineCap(StrokeLineCap.BUTT);
        this.backgroundRing.setStrokeWidth(34.375);
        this.backgroundRing.setEffect((Effect)this.shadow);
        this.barBackground = new Arc(125.0, 125.0, 107.8125, 107.8125, 0.0, 360.0);
        this.barBackground.setFill(null);
        this.barBackground.setStroke((Paint)Color.rgb((int)255, (int)255, (int)255, (double)0.4));
        this.barBackground.setStrokeLineCap(StrokeLineCap.BUTT);
        this.barBackground.setStrokeWidth(34.375);
        this.bar = new Arc(125.0, 125.0, 107.8125, 107.8125, 90.0, -this.gauge.getAngleStep() * this.gauge.getValue());
        this.bar.setFill(null);
        this.bar.setStroke((Paint)Color.WHITE);
        this.bar.setStrokeWidth(34.375);
        this.bar.setStrokeLineCap(StrokeLineCap.BUTT);
        this.pane = new Pane(new Node[]{this.valueText, this.unitText, this.backgroundRing, this.barBackground, this.bar});
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.gauge.getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.gauge.getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.gauge.getBorderWidth()))}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.gauge.currentValueProperty().addListener(this.currentValueListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
            this.redraw();
        } else if ("REDRAW".equals(EVENT_TYPE)) {
            this.redraw();
        } else if ("RECALC".equals(EVENT_TYPE)) {
            this.minValue = this.gauge.getMinValue();
            this.range = this.gauge.getRange();
            this.angleStep = 360.0 / this.range;
            this.redraw();
            this.setBar(this.gauge.getCurrentValue());
        } else if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.valueText, this.gauge.isValueVisible());
            Helper.enableNode((Node)this.unitText, !this.gauge.getUnit().isEmpty());
        }
    }

    private void setBar(double VALUE) {
        if (this.minValue > 0.0) {
            this.bar.setLength((this.minValue - VALUE) * this.angleStep);
        } else {
            this.bar.setLength(-VALUE * this.angleStep);
        }
        this.valueText.setText(String.format(this.locale, this.formatString, VALUE));
        this.resizeValueText();
    }

    @Override
    public void dispose() {
        this.gauge.currentValueProperty().removeListener(this.currentValueListener);
        super.dispose();
    }

    private void resizeValueText() {
        double maxWidth = 0.5 * this.size;
        double fontSize = 0.20625 * this.size;
        this.valueText.setFont(Fonts.robotoBold(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
        this.valueText.relocate((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5, (this.size - this.valueText.getLayoutBounds().getHeight()) * (this.unitText.getText().isEmpty() ? 0.5 : 0.42));
    }

    private void resizeUnitText() {
        double maxWidth = 0.56667 * this.size;
        double fontSize = 0.0875 * this.size;
        this.unitText.setFont(Fonts.robotoBold(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        this.unitText.relocate((this.size - this.unitText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.66);
    }

    @Override
    protected void resize() {
        double height;
        double width = this.gauge.getWidth() - this.gauge.getInsets().getLeft() - this.gauge.getInsets().getRight();
        double d = this.size = width < (height = this.gauge.getHeight() - this.gauge.getInsets().getTop() - this.gauge.getInsets().getBottom()) ? width : height;
        if (width > 0.0 && height > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((width - this.size) * 0.5, (height - this.size) * 0.5);
            this.shadow.setRadius(this.size * 0.06);
            this.shadow.setOffsetX(this.size * 0.02);
            this.shadow.setOffsetY(this.size * 0.02);
            this.textShadow.setRadius(this.size * 0.0125);
            this.textShadow.setOffsetX(this.size * 0.00625);
            this.textShadow.setOffsetY(this.size * 0.00625);
            this.center = this.size * 0.5;
            this.valueText.setFont(Fonts.robotoBold(this.size * 0.20625));
            this.unitText.setFont(Fonts.robotoBold(this.size * 0.0875));
            Arc outerRing = new Arc(this.size * 0.5, this.size * 0.5, this.size * 0.43125, this.size * 0.43125, 0.0, 360.0);
            outerRing.setFill(null);
            outerRing.setStroke((Paint)Color.WHITE);
            outerRing.setStrokeLineCap(StrokeLineCap.BUTT);
            outerRing.setStrokeWidth(this.size * 0.3);
            Arc innerRing = new Arc(this.size * 0.5, this.size * 0.5, this.size * 0.43125, this.size * 0.43125, 0.0, 360.0);
            innerRing.setFill(null);
            innerRing.setStroke((Paint)Color.WHITE);
            innerRing.setStrokeLineCap(StrokeLineCap.BUTT);
            innerRing.setStrokeWidth(this.size * 0.1375);
            Shape shape = Shape.subtract((Shape)outerRing, (Shape)innerRing);
            this.backgroundRing.setCenterX(this.center);
            this.backgroundRing.setCenterY(this.center);
            this.backgroundRing.setRadiusX(this.size * 0.43125);
            this.backgroundRing.setRadiusY(this.size * 0.43125);
            this.backgroundRing.setStrokeWidth(this.size * 0.1375);
            this.backgroundRing.setClip((Node)shape);
            this.barBackground.setCenterX(this.center);
            this.barBackground.setCenterY(this.center);
            this.barBackground.setRadiusX(this.size * 0.43125);
            this.barBackground.setRadiusY(this.size * 0.43125);
            this.barBackground.setStrokeWidth(this.size * 0.1375);
            this.bar.setCenterX(this.center);
            this.bar.setCenterY(this.center);
            this.bar.setRadiusX(this.size * 0.43125);
            this.bar.setRadiusY(this.size * 0.43125);
            this.bar.setStrokeWidth(this.size * 0.1375);
            this.resizeValueText();
            this.resizeUnitText();
        }
    }

    @Override
    protected void redraw() {
        this.locale = this.gauge.getLocale();
        this.formatString = "%." + Integer.toString(this.gauge.getDecimals()) + "f";
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.gauge.getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.gauge.getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.gauge.getBorderWidth() / 250.0 * this.size))}));
        this.valueText.setFill((Paint)this.gauge.getValueColor());
        this.unitText.setFill((Paint)this.gauge.getUnitColor());
        this.unitText.setText(this.gauge.getUnit());
        this.resizeUnitText();
    }
}

