/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Clock;
import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.skins.ClockSkinBase;
import eu.hansolo.medusa.tools.Helper;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.Circle;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Text;

public class SlimClockSkin
extends ClockSkinBase {
    private static final DateTimeFormatter DATE_TEXT_FORMATTER = DateTimeFormatter.ofPattern("cccc");
    private static final DateTimeFormatter HOUR_FORMATTER = DateTimeFormatter.ofPattern("HH");
    private static final DateTimeFormatter MINUTE_FORMATTER = DateTimeFormatter.ofPattern("mm");
    private DateTimeFormatter dateNumberFormatter;
    private double size;
    private Circle secondBackgroundCircle;
    private Text dateText;
    private Text dateNumbers;
    private Text hour;
    private Text minute;
    private Arc secondArc;
    private Pane pane;

    public SlimClockSkin(Clock clock) {
        super(clock);
        this.dateNumberFormatter = Helper.getLocalizedDateFormat(clock.getLocale());
        this.initGraphics();
        this.registerListeners();
    }

    @Override
    protected void initGraphics() {
        if (Double.compare(this.clock.getPrefWidth(), 0.0) <= 0 || Double.compare(this.clock.getPrefHeight(), 0.0) <= 0 || Double.compare(this.clock.getWidth(), 0.0) <= 0 || Double.compare(this.clock.getHeight(), 0.0) <= 0) {
            if (this.clock.getPrefWidth() > 0.0 && this.clock.getPrefHeight() > 0.0) {
                this.clock.setPrefSize(this.clock.getPrefWidth(), this.clock.getPrefHeight());
            } else {
                this.clock.setPrefSize(250.0, 250.0);
            }
        }
        ZonedDateTime time = this.clock.getTime();
        this.secondBackgroundCircle = new Circle(125.0, 125.0, 120.0);
        this.secondBackgroundCircle.setStrokeWidth(2.0);
        this.secondBackgroundCircle.setStrokeType(StrokeType.CENTERED);
        this.secondBackgroundCircle.setStrokeLineCap(StrokeLineCap.ROUND);
        this.secondBackgroundCircle.setFill(null);
        this.secondBackgroundCircle.setStroke((Paint)Helper.getTranslucentColorFrom(this.clock.getSecondColor(), 0.2));
        this.secondBackgroundCircle.setVisible(this.clock.isSecondsVisible());
        this.secondBackgroundCircle.setManaged(this.clock.isSecondsVisible());
        this.dateText = new Text(DATE_TEXT_FORMATTER.format(time));
        this.dateText.setVisible(this.clock.isDateVisible());
        this.dateText.setManaged(this.clock.isDateVisible());
        this.dateNumbers = new Text(this.dateNumberFormatter.format(time));
        this.dateNumbers.setVisible(this.clock.isDateVisible());
        this.dateNumbers.setManaged(this.clock.isDateVisible());
        this.hour = new Text(HOUR_FORMATTER.format(time));
        this.hour.setFill((Paint)this.clock.getHourColor());
        this.minute = new Text(MINUTE_FORMATTER.format(time));
        this.minute.setFill((Paint)this.clock.getMinuteColor());
        this.secondArc = new Arc(125.0, 125.0, 240.0, 120.0, 90.0, (double)(-6 * this.clock.getTime().getSecond()));
        this.secondArc.setStrokeWidth(2.0);
        this.secondArc.setStrokeType(StrokeType.CENTERED);
        this.secondArc.setStrokeLineCap(StrokeLineCap.ROUND);
        this.secondArc.setFill(null);
        this.secondArc.setStroke((Paint)this.clock.getSecondColor());
        this.secondArc.setVisible(this.clock.isSecondsVisible());
        this.secondArc.setManaged(this.clock.isSecondsVisible());
        this.pane = new Pane(new Node[]{this.secondBackgroundCircle, this.dateText, this.dateNumbers, this.hour, this.minute, this.secondArc});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.clock.getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.clock.getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.clock.getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            boolean isDateVisible = this.clock.isDateVisible();
            this.dateText.setVisible(isDateVisible);
            this.dateText.setManaged(isDateVisible);
            this.dateNumbers.setVisible(isDateVisible);
            this.dateNumbers.setManaged(isDateVisible);
            boolean isSecondsVisible = this.clock.isSecondsVisible();
            this.secondBackgroundCircle.setVisible(isSecondsVisible);
            this.secondBackgroundCircle.setManaged(isSecondsVisible);
            this.secondArc.setVisible(isSecondsVisible);
            this.secondArc.setManaged(isSecondsVisible);
        } else if ("FINISHED".equals(EVENT_TYPE)) {
            // empty if block
        }
    }

    @Override
    public void updateTime(ZonedDateTime TIME) {
        if (this.dateText.isVisible()) {
            this.dateText.setText(DATE_TEXT_FORMATTER.format(TIME));
            Helper.adjustTextSize(this.dateText, 0.6 * this.size, this.size * 0.08);
            this.dateText.relocate((this.size - this.dateText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.22180451);
            this.dateNumbers.setText(this.dateNumberFormatter.format(TIME));
            Helper.adjustTextSize(this.dateNumbers, 0.6 * this.size, this.size * 0.08);
            this.dateNumbers.relocate((this.size - this.dateNumbers.getLayoutBounds().getWidth()) * 0.5, this.size * 0.68984962);
        }
        this.hour.setText(HOUR_FORMATTER.format(TIME));
        Helper.adjustTextSize(this.hour, 0.4 * this.size, 0.328 * this.size);
        this.hour.relocate(0.136 * this.size, (this.size - this.hour.getLayoutBounds().getHeight()) * 0.5);
        this.minute.setText(MINUTE_FORMATTER.format(TIME));
        Helper.adjustTextSize(this.minute, 0.4 * this.size, 0.328 * this.size);
        this.minute.relocate(0.544 * this.size, (this.size - this.minute.getLayoutBounds().getHeight()) * 0.5);
        if (this.secondBackgroundCircle.isVisible()) {
            this.secondArc.setLength((double)(-6 * TIME.getSecond()));
            if (this.clock.isDiscreteSeconds()) {
                this.secondArc.setLength((double)(-6 * TIME.getSecond()));
            } else {
                this.secondArc.setLength((double)(-6 * TIME.getSecond()) - (double)TIME.get(ChronoField.MILLI_OF_SECOND) * 0.006);
            }
        }
    }

    @Override
    public void updateAlarms() {
    }

    @Override
    protected void resize() {
        double height;
        double width = this.clock.getWidth() - this.clock.getInsets().getLeft() - this.clock.getInsets().getRight();
        double d = this.size = width < (height = this.clock.getHeight() - this.clock.getInsets().getTop() - this.clock.getInsets().getBottom()) ? width : height;
        if (this.size > 0.0) {
            double center = this.size * 0.5;
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((this.clock.getWidth() - this.size) * 0.5, (this.clock.getHeight() - this.size) * 0.5);
            this.secondBackgroundCircle.setCenterX(center);
            this.secondBackgroundCircle.setCenterY(center);
            this.secondBackgroundCircle.setRadius(this.size * 0.48590226);
            this.secondBackgroundCircle.setStrokeWidth(this.size * 0.02819549);
            this.secondArc.setCenterX(center);
            this.secondArc.setCenterY(center);
            this.secondArc.setRadiusX(this.size * 0.48590226);
            this.secondArc.setRadiusY(this.size * 0.48590226);
            this.secondArc.setStrokeWidth(this.size * 0.02819549);
            this.dateText.setFont(Fonts.robotoLight(this.size * 0.08082707));
            this.dateNumbers.setFont(Fonts.robotoLight(this.size * 0.08082707));
            this.hour.setFont(Fonts.robotoMedium(this.size * 0.328));
            this.minute.setFont(Fonts.robotoThin(this.size * 0.328));
        }
    }

    @Override
    protected void redraw() {
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.clock.getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.clock.getBorderWidth() / 250.0 * this.size))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.clock.getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.secondBackgroundCircle.setStroke((Paint)Helper.getTranslucentColorFrom(this.clock.getSecondColor(), 0.2));
        this.secondArc.setStroke((Paint)this.clock.getSecondColor());
        this.hour.setFill((Paint)this.clock.getHourColor());
        this.minute.setFill((Paint)this.clock.getMinuteColor());
        this.dateText.setFill((Paint)this.clock.getDateColor());
        this.dateNumbers.setFill((Paint)this.clock.getDateColor());
        this.hour.setFill((Paint)this.clock.getHourColor());
        this.minute.setFill((Paint)this.clock.getMinuteColor());
        ZonedDateTime time = this.clock.getTime();
        this.updateTime(time);
    }
}

