/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.skins.GaugeSkinBase;
import eu.hansolo.medusa.tools.Helper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javafx.beans.InvalidationListener;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;

public class IndicatorSkin
extends GaugeSkinBase {
    protected static final double PREFERRED_WIDTH = 250.0;
    protected static final double PREFERRED_HEIGHT = 165.0;
    protected static final double MINIMUM_WIDTH = 50.0;
    protected static final double MINIMUM_HEIGHT = 50.0;
    protected static final double MAXIMUM_WIDTH = 1024.0;
    protected static final double MAXIMUM_HEIGHT = 1024.0;
    private static final double ASPECT_RATIO = 0.59375;
    private double width;
    private double height;
    private double oldValue;
    private Arc barBackground;
    private Pane sectionLayer;
    private Arc bar;
    private Path needle;
    private MoveTo needleMoveTo1;
    private CubicCurveTo needleCubicCurveTo2;
    private CubicCurveTo needleCubicCurveTo3;
    private CubicCurveTo needleCubicCurveTo4;
    private CubicCurveTo needleCubicCurveTo5;
    private CubicCurveTo needleCubicCurveTo6;
    private CubicCurveTo needleCubicCurveTo7;
    private ClosePath needleClosePath8;
    private Rotate needleRotate;
    private Text minValueText;
    private Text maxValueText;
    private Text titleText;
    private Pane pane;
    private double angleRange;
    private double minValue;
    private double range;
    private double angleStep;
    private double startAngle;
    private boolean colorGradientEnabled;
    private int noOfGradientStops;
    private boolean sectionsAlwaysVisible;
    private boolean sectionsVisible;
    private List<Section> sections;
    private Tooltip needleTooltip;
    private String formatString;
    private Locale locale;
    private Color barColor;
    private Tooltip barTooltip;
    private InvalidationListener currentValueListener;
    private InvalidationListener sectionAlwaysVisibleListener;

    public IndicatorSkin(Gauge gauge) {
        super(gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.angleRange = Helper.clamp(90.0, 180.0, gauge.getAngleRange());
        this.startAngle = this.getStartAngle();
        this.oldValue = gauge.getValue();
        this.minValue = gauge.getMinValue();
        this.range = gauge.getRange();
        this.angleStep = this.angleRange / this.range;
        this.colorGradientEnabled = gauge.isGradientBarEnabled();
        this.noOfGradientStops = gauge.getGradientBarStops().size();
        this.sectionsAlwaysVisible = gauge.getSectionsAlwaysVisible();
        this.sectionsVisible = gauge.getSectionsVisible();
        this.sections = gauge.getSections();
        this.formatString = "%." + Integer.toString(gauge.getDecimals()) + "f";
        this.locale = gauge.getLocale();
        this.barColor = gauge.getBarColor();
        this.currentValueListener = o -> this.rotateNeedle(gauge.getCurrentValue());
        this.sectionAlwaysVisibleListener = o -> this.bar.setVisible(!gauge.getSectionsAlwaysVisible());
        this.initGraphics();
        this.registerListeners();
        this.rotateNeedle(gauge.getCurrentValue());
    }

    private void initGraphics() {
        if (Double.compare(this.gauge.getPrefWidth(), 0.0) <= 0 || Double.compare(this.gauge.getPrefHeight(), 0.0) <= 0 || Double.compare(this.gauge.getWidth(), 0.0) <= 0 || Double.compare(this.gauge.getHeight(), 0.0) <= 0) {
            if (this.gauge.getPrefWidth() > 0.0 && this.gauge.getPrefHeight() > 0.0) {
                this.gauge.setPrefSize(this.gauge.getPrefWidth(), this.gauge.getPrefHeight());
            } else {
                this.gauge.setPrefSize(250.0, 165.0);
            }
        }
        this.barBackground = new Arc(125.0, 114.83999999999999, 68.75, 68.75, this.angleRange * 0.5 + 90.0, -this.angleRange);
        this.barBackground.setType(ArcType.OPEN);
        this.barBackground.setStroke((Paint)this.gauge.getBarBackgroundColor());
        this.barBackground.setStrokeWidth(14.097745);
        this.barBackground.setStrokeLineCap(StrokeLineCap.BUTT);
        this.barBackground.setFill(null);
        this.sectionLayer = new Pane();
        this.sectionLayer.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.bar = new Arc(125.0, 114.83999999999999, 68.75, 68.75, this.angleRange * 0.5 + 90.0, 0.0);
        this.bar.setType(ArcType.OPEN);
        this.bar.setStroke((Paint)this.gauge.getBarColor());
        this.bar.setStrokeWidth(14.097745);
        this.bar.setStrokeLineCap(StrokeLineCap.BUTT);
        this.bar.setFill(null);
        this.bar.setVisible(!this.sectionsAlwaysVisible);
        this.needleRotate = new Rotate((this.gauge.getValue() - this.oldValue - this.minValue) * this.angleStep);
        this.needleMoveTo1 = new MoveTo();
        this.needleCubicCurveTo2 = new CubicCurveTo();
        this.needleCubicCurveTo3 = new CubicCurveTo();
        this.needleCubicCurveTo4 = new CubicCurveTo();
        this.needleCubicCurveTo5 = new CubicCurveTo();
        this.needleCubicCurveTo6 = new CubicCurveTo();
        this.needleCubicCurveTo7 = new CubicCurveTo();
        this.needleClosePath8 = new ClosePath();
        this.needle = new Path(new PathElement[]{this.needleMoveTo1, this.needleCubicCurveTo2, this.needleCubicCurveTo3, this.needleCubicCurveTo4, this.needleCubicCurveTo5, this.needleCubicCurveTo6, this.needleCubicCurveTo7, this.needleClosePath8});
        this.needle.setFillRule(FillRule.EVEN_ODD);
        this.needle.getTransforms().setAll((Object[])new Transform[]{this.needleRotate});
        this.needle.setFill((Paint)this.gauge.getNeedleColor());
        this.needle.setPickOnBounds(false);
        this.needle.setStrokeType(StrokeType.INSIDE);
        this.needle.setStrokeWidth(1.0);
        this.needle.setStroke(this.gauge.getBackgroundPaint());
        this.needleTooltip = new Tooltip(String.format(this.locale, this.formatString, this.gauge.getValue()));
        this.needleTooltip.setTextAlignment(TextAlignment.CENTER);
        Tooltip.install((Node)this.needle, (Tooltip)this.needleTooltip);
        this.minValueText = new Text(String.format(this.locale, "%." + this.gauge.getTickLabelDecimals() + "f", this.gauge.getMinValue()));
        this.minValueText.setFill((Paint)this.gauge.getTitleColor());
        Helper.enableNode((Node)this.minValueText, this.gauge.getTickLabelsVisible());
        this.maxValueText = new Text(String.format(this.locale, "%." + this.gauge.getTickLabelDecimals() + "f", this.gauge.getMaxValue()));
        this.maxValueText.setFill((Paint)this.gauge.getTitleColor());
        Helper.enableNode((Node)this.maxValueText, this.gauge.getTickLabelsVisible());
        this.titleText = new Text(this.gauge.getTitle());
        this.titleText.setFill((Paint)this.gauge.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.gauge.getTitle().isEmpty());
        if (!this.sections.isEmpty() && this.sectionsVisible && !this.sectionsAlwaysVisible) {
            this.barTooltip = new Tooltip();
            this.barTooltip.setTextAlignment(TextAlignment.CENTER);
            Tooltip.install((Node)this.bar, (Tooltip)this.barTooltip);
        }
        this.pane = new Pane(new Node[]{this.barBackground, this.sectionLayer, this.bar, this.needle, this.minValueText, this.maxValueText, this.titleText});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.gauge.getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(this.gauge.getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.gauge.getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.gauge.currentValueProperty().addListener(this.currentValueListener);
        this.gauge.sectionsAlwaysVisibleProperty().addListener(this.sectionAlwaysVisibleListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("RECALC".equals(EVENT_TYPE)) {
            this.angleRange = Helper.clamp(90.0, 180.0, this.gauge.getAngleRange());
            this.startAngle = this.getStartAngle();
            this.minValue = this.gauge.getMinValue();
            this.range = this.gauge.getRange();
            this.sections = this.gauge.getSections();
            this.angleStep = this.angleRange / this.range;
            this.redraw();
            this.rotateNeedle(this.gauge.getCurrentValue());
        } else if ("FINISHED".equals(EVENT_TYPE)) {
            this.needleTooltip.setText(String.format(this.locale, this.formatString, this.gauge.getValue()));
            double value = this.gauge.getValue();
            if (this.gauge.isValueVisible()) {
                Bounds bounds = this.pane.localToScreen(this.pane.getBoundsInLocal());
                double xFactor = value > this.gauge.getRange() * 0.8 ? 0.0 : 0.25;
                double tooltipAngle = value * this.angleStep;
                double sinValue = Math.sin(Math.toRadians(180.0 + this.angleRange * 0.5 - tooltipAngle));
                double cosValue = Math.cos(Math.toRadians(180.0 + this.angleRange * 0.5 - tooltipAngle));
                double needleTipX = bounds.getMinX() + bounds.getWidth() * 0.5 + bounds.getHeight() * sinValue;
                double needleTipY = bounds.getMinY() + bounds.getHeight() * 0.72 + bounds.getHeight() * cosValue;
                this.needleTooltip.show((Node)this.needle, needleTipX, needleTipY);
                this.needleTooltip.setAnchorX(this.needleTooltip.getX() - this.needleTooltip.getWidth() * xFactor);
            }
            if (this.sections.isEmpty() || this.sectionsAlwaysVisible) {
                return;
            }
            for (Section section : this.sections) {
                if (!section.contains(value)) continue;
                this.barTooltip.setText(section.getText());
                break;
            }
        } else if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.gauge.getTitle().isEmpty());
        }
    }

    private double getStartAngle() {
        Gauge.ScaleDirection scaleDirection = this.gauge.getScaleDirection();
        switch (scaleDirection) {
            default: 
        }
        return 180.0 + this.angleRange * 0.5;
    }

    private void rotateNeedle(double VALUE) {
        double needleStartAngle = this.angleRange * 0.5;
        double targetAngle = (VALUE - this.minValue) * this.angleStep - needleStartAngle;
        targetAngle = Helper.clamp(-needleStartAngle, -needleStartAngle + this.angleRange, targetAngle);
        this.needleRotate.setAngle(targetAngle);
        this.bar.setLength(-(this.gauge.getCurrentValue() - this.minValue) * this.angleStep);
        this.setBarColor(VALUE);
    }

    private void setBarColor(double VALUE) {
        if (!this.sectionsVisible && !this.colorGradientEnabled) {
            this.bar.setStroke((Paint)this.barColor);
        } else if (this.colorGradientEnabled && this.noOfGradientStops > 1) {
            this.bar.setStroke((Paint)this.gauge.getGradientLookup().getColorAt((VALUE - this.minValue) / this.range));
        } else {
            this.bar.setStroke((Paint)this.barColor);
            for (Section section : this.sections) {
                if (!section.contains(VALUE)) continue;
                this.bar.setStroke((Paint)section.getColor());
                break;
            }
        }
    }

    @Override
    public void dispose() {
        this.gauge.currentValueProperty().removeListener(this.currentValueListener);
        this.gauge.sectionsAlwaysVisibleProperty().removeListener(this.sectionAlwaysVisibleListener);
        super.dispose();
    }

    private void resizeStaticText() {
        double maxWidth = this.width * 0.28472222;
        double fontSize = this.height * 0.12631579;
        this.minValueText.setFont(Fonts.latoRegular(fontSize));
        if (this.minValueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.minValueText, maxWidth, fontSize);
        }
        this.minValueText.relocate(this.width * 0.28472222 - this.minValueText.getLayoutBounds().getWidth(), this.height * 0.885);
        this.maxValueText.setFont(Fonts.latoRegular(fontSize));
        if (this.maxValueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.maxValueText, maxWidth, fontSize);
        }
        this.maxValueText.relocate(this.width * 0.71527778, this.height * 0.885);
        maxWidth = this.width * 0.9;
        this.titleText.setFont(Fonts.latoRegular(fontSize));
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.height * 0.95);
    }

    @Override
    protected void resize() {
        this.width = this.gauge.getWidth() - this.gauge.getInsets().getLeft() - this.gauge.getInsets().getRight();
        this.height = this.gauge.getHeight() - this.gauge.getInsets().getTop() - this.gauge.getInsets().getBottom();
        if (0.59375 * this.width > this.height) {
            this.width = 1.0 / (0.59375 / this.height);
        } else if (1.0 / (0.59375 / this.height) > this.width) {
            this.height = 0.59375 * this.width;
        }
        if (this.width > 0.0 && this.height > 0.0) {
            double centerX = this.width * 0.5;
            double centerY = this.height * 0.85;
            double barRadius = this.height * 0.54210526;
            double barWidth = this.width * 0.28472222;
            this.pane.setMaxSize(this.width, this.height);
            this.pane.relocate((this.gauge.getWidth() - this.width) * 0.5, (this.gauge.getHeight() - this.height) * 0.5);
            this.barBackground.setCenterX(centerX);
            this.barBackground.setCenterY(centerY);
            this.barBackground.setRadiusX(barRadius);
            this.barBackground.setRadiusY(barRadius);
            this.barBackground.setStrokeWidth(barWidth);
            this.barBackground.setStartAngle(this.angleRange * 0.5 + 90.0);
            this.barBackground.setLength(-this.angleRange);
            if (this.sectionsVisible && this.sectionsAlwaysVisible) {
                this.sectionLayer.setPrefSize(this.width, this.height);
                this.drawSections();
            }
            this.bar.setCenterX(centerX);
            this.bar.setCenterY(centerY);
            this.bar.setRadiusX(barRadius);
            this.bar.setRadiusY(barRadius);
            this.bar.setStrokeWidth(barWidth);
            this.bar.setStartAngle(this.angleRange * 0.5 + 90.0);
            this.bar.setLength(-(this.gauge.getCurrentValue() - this.minValue) * this.angleStep);
            double needleWidth = this.height * 0.13157895;
            double needleHeight = this.height * 0.91315789;
            this.needle.setCache(true);
            this.needleMoveTo1.setX(0.0);
            this.needleMoveTo1.setY(0.927953890489914 * needleHeight);
            this.needleCubicCurveTo2.setControlX1(0.0);
            this.needleCubicCurveTo2.setControlY1(0.968299711815562 * needleHeight);
            this.needleCubicCurveTo2.setControlX2(0.22 * needleWidth);
            this.needleCubicCurveTo2.setControlY2(needleHeight);
            this.needleCubicCurveTo2.setX(0.5 * needleWidth);
            this.needleCubicCurveTo2.setY(needleHeight);
            this.needleCubicCurveTo3.setControlX1(0.78 * needleWidth);
            this.needleCubicCurveTo3.setControlY1(needleHeight);
            this.needleCubicCurveTo3.setControlX2(needleWidth);
            this.needleCubicCurveTo3.setControlY2(0.968299711815562 * needleHeight);
            this.needleCubicCurveTo3.setX(needleWidth);
            this.needleCubicCurveTo3.setY(0.927953890489914 * needleHeight);
            this.needleCubicCurveTo4.setControlX1(needleWidth);
            this.needleCubicCurveTo4.setControlY1(0.92507204610951 * needleHeight);
            this.needleCubicCurveTo4.setControlX2(0.6 * needleWidth);
            this.needleCubicCurveTo4.setControlY2(0.0144092219020173 * needleHeight);
            this.needleCubicCurveTo4.setX(0.6 * needleWidth);
            this.needleCubicCurveTo4.setY(0.0144092219020173 * needleHeight);
            this.needleCubicCurveTo5.setControlX1(0.6 * needleWidth);
            this.needleCubicCurveTo5.setControlY1(0.0144092219020173 * needleHeight);
            this.needleCubicCurveTo5.setControlX2(0.58 * needleWidth);
            this.needleCubicCurveTo5.setControlY2(0.0);
            this.needleCubicCurveTo5.setX(0.5 * needleWidth);
            this.needleCubicCurveTo5.setY(0.0);
            this.needleCubicCurveTo6.setControlX1(0.42 * needleWidth);
            this.needleCubicCurveTo6.setControlY1(0.0);
            this.needleCubicCurveTo6.setControlX2(0.4 * needleWidth);
            this.needleCubicCurveTo6.setControlY2(0.0144092219020173 * needleHeight);
            this.needleCubicCurveTo6.setX(0.4 * needleWidth);
            this.needleCubicCurveTo6.setY(0.0144092219020173 * needleHeight);
            this.needleCubicCurveTo7.setControlX1(0.4 * needleWidth);
            this.needleCubicCurveTo7.setControlY1(0.0144092219020173 * needleHeight);
            this.needleCubicCurveTo7.setControlX2(0.0);
            this.needleCubicCurveTo7.setControlY2(0.92507204610951 * needleHeight);
            this.needleCubicCurveTo7.setX(0.0);
            this.needleCubicCurveTo7.setY(0.927953890489914 * needleHeight);
            this.needle.setCache(true);
            this.needle.setCacheHint(CacheHint.ROTATE);
            this.needle.relocate((this.width - this.needle.getLayoutBounds().getWidth()) * 0.5, centerY - this.needle.getLayoutBounds().getHeight() + this.needle.getLayoutBounds().getWidth() * 0.5);
            this.needleRotate.setPivotX(this.needle.getLayoutBounds().getWidth() * 0.5);
            this.needleRotate.setPivotY(this.needle.getLayoutBounds().getHeight() - this.needle.getLayoutBounds().getWidth() * 0.5);
            this.resizeStaticText();
        }
    }

    @Override
    protected void redraw() {
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.gauge.getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(this.gauge.getBorderWidth() / 165.0 * this.height))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.gauge.getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.barColor = this.gauge.getBarColor();
        this.locale = this.gauge.getLocale();
        this.formatString = "%." + Integer.toString(this.gauge.getDecimals()) + "f";
        this.colorGradientEnabled = this.gauge.isGradientBarEnabled();
        this.noOfGradientStops = this.gauge.getGradientBarStops().size();
        this.sectionsVisible = this.gauge.getSectionsVisible();
        this.minValueText.setText(String.format(this.locale, "%." + this.gauge.getTickLabelDecimals() + "f", this.gauge.getMinValue()));
        this.maxValueText.setText(String.format(this.locale, "%." + this.gauge.getTickLabelDecimals() + "f", this.gauge.getMaxValue()));
        this.resizeStaticText();
        this.barBackground.setStroke((Paint)this.gauge.getBarBackgroundColor());
        this.bar.setStroke((Paint)this.gauge.getBarColor());
        this.needle.setFill((Paint)this.gauge.getNeedleColor());
        this.minValueText.setVisible(this.gauge.getTickLabelsVisible());
        this.maxValueText.setVisible(this.gauge.getTickLabelsVisible());
        this.minValueText.setFill((Paint)this.gauge.getTitleColor());
        this.maxValueText.setFill((Paint)this.gauge.getTitleColor());
        this.titleText.setFill((Paint)this.gauge.getTitleColor());
    }

    private void drawSections() {
        if (this.sections.isEmpty()) {
            return;
        }
        this.sectionLayer.getChildren().clear();
        double centerX = this.width * 0.5;
        double centerY = this.height * 0.85;
        double barRadius = this.height * 0.54210526;
        double barWidth = this.width * 0.28472222;
        ArrayList<Arc> sectionBars = new ArrayList<Arc>(this.sections.size());
        for (Section section : this.sections) {
            Arc sectionBar = new Arc(centerX, centerY, barRadius, barRadius, this.angleRange * 0.5 + 90.0 - section.getStart() * this.angleStep, -(section.getStop() - section.getStart() - this.minValue) * this.angleStep);
            sectionBar.setType(ArcType.OPEN);
            sectionBar.setStroke((Paint)section.getColor());
            sectionBar.setStrokeWidth(barWidth);
            sectionBar.setStrokeLineCap(StrokeLineCap.BUTT);
            sectionBar.setFill(null);
            Tooltip sectionTooltip = new Tooltip(section.getText() + "\n" + String.format(Locale.US, "%.2f", section.getStart()) + " - " + String.format(Locale.US, "%.2f", section.getStop()));
            sectionTooltip.setTextAlignment(TextAlignment.CENTER);
            Tooltip.install((Node)sectionBar, (Tooltip)sectionTooltip);
            sectionBars.add(sectionBar);
        }
        this.sectionLayer.getChildren().addAll(sectionBars);
    }
}

