/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.skins.GaugeSkinBase;
import eu.hansolo.medusa.tools.Helper;
import java.util.List;
import java.util.Locale;
import javafx.beans.InvalidationListener;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class DashboardSkin
extends GaugeSkinBase {
    protected static final double PREFERRED_WIDTH = 200.0;
    protected static final double PREFERRED_HEIGHT = 148.0;
    protected static final double MINIMUM_WIDTH = 50.0;
    protected static final double MINIMUM_HEIGHT = 50.0;
    protected static final double MAXIMUM_WIDTH = 1024.0;
    protected static final double MAXIMUM_HEIGHT = 1024.0;
    private static final double ASPECT_RATIO = 0.74;
    private static final double ANGLE_RANGE = 180.0;
    private double size;
    private double width;
    private double height;
    private double centerX;
    private double currentValueAngle;
    private Pane pane;
    private Text unitText;
    private Text titleText;
    private Text valueText;
    private Text minText;
    private Text maxText;
    private Path barBackground;
    private MoveTo barBackgroundStart;
    private ArcTo barBackgroundOuterArc;
    private LineTo barBackgroundLineToInnerArc;
    private ArcTo barBackgroundInnerArc;
    private Path dataBar;
    private MoveTo dataBarStart;
    private ArcTo dataBarOuterArc;
    private LineTo dataBarLineToInnerArc;
    private ArcTo dataBarInnerArc;
    private Line threshold;
    private Text thresholdText;
    private InnerShadow innerShadow;
    private Font smallFont;
    private Font bigFont;
    private double range;
    private double angleStep;
    private boolean colorGradientEnabled;
    private int noOfGradientStops;
    private boolean sectionsVisible;
    private List<Section> sections;
    private String formatString;
    private String otherFormatString;
    private Locale locale;
    private double minValue;
    private InvalidationListener currentValueListener;

    public DashboardSkin(Gauge gauge) {
        super(gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.range = gauge.getRange();
        this.angleStep = 180.0 / this.range;
        this.colorGradientEnabled = gauge.isGradientBarEnabled();
        this.noOfGradientStops = gauge.getGradientBarStops().size();
        this.sectionsVisible = gauge.getSectionsVisible();
        this.sections = gauge.getSections();
        this.currentValueAngle = 0.0;
        this.formatString = "%." + Integer.toString(gauge.getDecimals()) + "f";
        this.otherFormatString = "%." + Integer.toString(gauge.getTickLabelDecimals()) + "f";
        this.locale = gauge.getLocale();
        this.currentValueListener = o -> this.setBar(gauge.getCurrentValue());
        this.initGraphics();
        this.registerListeners();
        this.setBar(gauge.getValue());
    }

    private void initGraphics() {
        if (Double.compare(this.gauge.getPrefWidth(), 0.0) <= 0 || Double.compare(this.gauge.getPrefHeight(), 0.0) <= 0 || Double.compare(this.gauge.getWidth(), 0.0) <= 0 || Double.compare(this.gauge.getHeight(), 0.0) <= 0) {
            if (this.gauge.getPrefWidth() > 0.0 && this.gauge.getPrefHeight() > 0.0) {
                this.gauge.setPrefSize(this.gauge.getPrefWidth(), this.gauge.getPrefHeight());
            } else {
                this.gauge.setPrefSize(200.0, 148.0);
            }
        }
        this.unitText = new Text(this.gauge.getUnit());
        this.unitText.setTextOrigin(VPos.CENTER);
        this.unitText.setFill((Paint)this.gauge.getUnitColor());
        Helper.enableNode((Node)this.unitText, !this.gauge.getUnit().isEmpty());
        this.titleText = new Text(this.gauge.getTitle());
        this.titleText.setTextOrigin(VPos.CENTER);
        this.titleText.setFill((Paint)this.gauge.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.gauge.getTitle().isEmpty());
        this.valueText = new Text(String.format(this.locale, this.formatString, this.gauge.getValue()));
        this.valueText.setTextOrigin(VPos.CENTER);
        this.valueText.setFill((Paint)this.gauge.getValueColor());
        Helper.enableNode((Node)this.valueText, this.gauge.isValueVisible());
        this.minValue = this.gauge.getMinValue();
        this.minText = new Text(String.format(this.locale, this.otherFormatString, this.minValue));
        this.minText.setTextOrigin(VPos.CENTER);
        this.minText.setFill((Paint)this.gauge.getValueColor());
        this.maxText = new Text(String.format(this.locale, this.otherFormatString, this.gauge.getMaxValue()));
        this.maxText.setTextOrigin(VPos.CENTER);
        this.maxText.setFill((Paint)this.gauge.getValueColor());
        boolean tickLabelsVisible = this.gauge.getTickLabelsVisible();
        Helper.enableNode((Node)this.minText, tickLabelsVisible);
        Helper.enableNode((Node)this.maxText, tickLabelsVisible);
        this.innerShadow = new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.3), 30.0, 0.0, 0.0, 10.0);
        this.barBackgroundStart = new MoveTo(0.0, 99.9);
        this.barBackgroundOuterArc = new ArcTo(99.9, 99.9, 0.0, 200.0, 99.9, true, true);
        this.barBackgroundLineToInnerArc = new LineTo(144.444, 99.9);
        this.barBackgroundInnerArc = new ArcTo(44.4, 44.4, 0.0, 55.556000000000004, 99.9, false, false);
        this.barBackground = new Path();
        this.barBackground.setFillRule(FillRule.EVEN_ODD);
        this.barBackground.getElements().add((Object)this.barBackgroundStart);
        this.barBackground.getElements().add((Object)this.barBackgroundOuterArc);
        this.barBackground.getElements().add((Object)this.barBackgroundLineToInnerArc);
        this.barBackground.getElements().add((Object)this.barBackgroundInnerArc);
        this.barBackground.getElements().add((Object)new ClosePath());
        this.barBackground.setFill((Paint)this.gauge.getBarBackgroundColor());
        this.barBackground.setStroke(this.gauge.getBorderPaint());
        this.barBackground.setEffect((Effect)(this.gauge.isShadowsEnabled() ? this.innerShadow : null));
        this.dataBarStart = new MoveTo(0.0, 99.9);
        this.dataBarOuterArc = new ArcTo(99.9, 99.9, 0.0, 0.0, 0.0, false, true);
        this.dataBarLineToInnerArc = new LineTo(55.556000000000004, 99.9);
        this.dataBarInnerArc = new ArcTo(44.4, 44.4, 0.0, 0.0, 0.0, false, false);
        this.dataBar = new Path();
        this.dataBar.setFillRule(FillRule.EVEN_ODD);
        this.dataBar.getElements().add((Object)this.dataBarStart);
        this.dataBar.getElements().add((Object)this.dataBarOuterArc);
        this.dataBar.getElements().add((Object)this.dataBarLineToInnerArc);
        this.dataBar.getElements().add((Object)this.dataBarInnerArc);
        this.dataBar.getElements().add((Object)new ClosePath());
        this.dataBar.setFill((Paint)this.gauge.getBarColor());
        this.dataBar.setStroke(this.gauge.getBorderPaint());
        this.dataBar.setEffect((Effect)(this.gauge.isShadowsEnabled() ? this.innerShadow : null));
        this.threshold = new Line();
        this.threshold.setStrokeLineCap(StrokeLineCap.BUTT);
        Helper.enableNode((Node)this.threshold, this.gauge.isThresholdVisible());
        this.thresholdText = new Text(String.format(this.locale, this.formatString, this.gauge.getThreshold()));
        Helper.enableNode((Node)this.thresholdText, this.gauge.isThresholdVisible());
        this.pane = new Pane(new Node[]{this.unitText, this.titleText, this.valueText, this.minText, this.maxText, this.barBackground, this.dataBar, this.threshold, this.thresholdText});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.gauge.getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(this.gauge.getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.gauge.getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.gauge.currentValueProperty().addListener(this.currentValueListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("RECALC".equals(EVENT_TYPE)) {
            this.range = this.gauge.getRange();
            this.angleStep = 180.0 / this.range;
            this.minValue = this.gauge.getMinValue();
            this.sections = this.gauge.getSections();
            this.resize();
            this.redraw();
            this.setBar(this.gauge.getCurrentValue());
        } else if ("VISBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.gauge.getTitle().isEmpty());
            Helper.enableNode((Node)this.unitText, !this.gauge.getUnit().isEmpty());
            Helper.enableNode((Node)this.valueText, this.gauge.isValueVisible());
            boolean tickLabelsVisible = this.gauge.getTickLabelsVisible();
            Helper.enableNode((Node)this.minText, tickLabelsVisible);
            Helper.enableNode((Node)this.maxText, tickLabelsVisible);
            boolean thresholdVisible = this.gauge.isThresholdVisible();
            Helper.enableNode((Node)this.threshold, thresholdVisible);
            Helper.enableNode((Node)this.thresholdText, thresholdVisible);
            this.redraw();
        }
    }

    @Override
    public void dispose() {
        this.gauge.currentValueProperty().removeListener(this.currentValueListener);
        super.dispose();
    }

    private void setBar(double VALUE) {
        this.currentValueAngle = Helper.clamp(90.0, 270.0, (VALUE - this.minValue) * this.angleStep + 90.0);
        this.dataBarOuterArc.setX(this.centerX + 0.675 * this.height * Math.sin(-Math.toRadians(this.currentValueAngle)));
        this.dataBarOuterArc.setY(this.centerX + 0.675 * this.height * Math.cos(-Math.toRadians(this.currentValueAngle)));
        this.dataBarLineToInnerArc.setX(this.centerX + 0.3 * this.height * Math.sin(-Math.toRadians(this.currentValueAngle)));
        this.dataBarLineToInnerArc.setY(this.centerX + 0.3 * this.height * Math.cos(-Math.toRadians(this.currentValueAngle)));
        this.setBarColor(VALUE);
        this.valueText.setText(String.format(this.locale, this.formatString, VALUE));
        if (this.valueText.getLayoutBounds().getWidth() > 0.28 * this.width) {
            Helper.adjustTextSize(this.valueText, 0.28 * this.width, this.size * 0.24);
        }
        this.valueText.relocate((this.width - this.valueText.getLayoutBounds().getWidth()) * 0.5, 0.615 * this.height + (0.3 * this.height - this.valueText.getLayoutBounds().getHeight()) * 0.5);
    }

    private void setBarColor(double VALUE) {
        if (!this.sectionsVisible && !this.colorGradientEnabled) {
            this.dataBar.setFill((Paint)this.gauge.getBarColor());
        } else if (this.colorGradientEnabled && this.noOfGradientStops > 1) {
            this.dataBar.setFill((Paint)this.gauge.getGradientLookup().getColorAt((VALUE - this.minValue) / this.range));
        } else {
            for (Section section : this.sections) {
                if (!section.contains(VALUE)) continue;
                this.dataBar.setFill((Paint)section.getColor());
                break;
            }
        }
    }

    @Override
    protected void resize() {
        this.width = this.gauge.getWidth() - this.gauge.getInsets().getLeft() - this.gauge.getInsets().getRight();
        this.height = this.gauge.getHeight() - this.gauge.getInsets().getTop() - this.gauge.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (0.74 * this.width > this.height) {
            this.width = 1.0 / (0.74 / this.height);
        } else if (1.0 / (0.74 / this.height) > this.width) {
            this.height = 0.74 * this.width;
        }
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.relocate((this.gauge.getWidth() - this.width) * 0.5, (this.gauge.getHeight() - this.height) * 0.5);
            this.centerX = this.width * 0.5;
            this.smallFont = Fonts.robotoThin(0.12 * this.height);
            this.bigFont = Fonts.robotoRegular(0.24 * this.height);
            this.unitText.setFont(this.smallFont);
            this.unitText.relocate((this.width - this.unitText.getLayoutBounds().getWidth()) * 0.5, 0.5 * this.height);
            double maxWidth = 0.95 * this.width;
            this.titleText.setFont(this.smallFont);
            if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
                Helper.adjustTextSize(this.titleText, maxWidth, this.size * 0.12);
            }
            this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, 0.88 * this.height);
            maxWidth = 0.28 * this.width;
            this.valueText.setFont(this.bigFont);
            if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
                Helper.adjustTextSize(this.valueText, maxWidth, this.size * 0.24);
            }
            this.valueText.relocate((this.width - this.valueText.getLayoutBounds().getWidth()) * 0.5, 0.615 * this.height + (0.3 * this.height - this.valueText.getLayoutBounds().getHeight()) * 0.5);
            maxWidth = 0.27 * this.width;
            this.minText.setText(String.format(this.locale, this.otherFormatString, this.minValue));
            this.minText.setFont(this.smallFont);
            if (this.minText.getLayoutBounds().getWidth() > maxWidth) {
                Helper.adjustTextSize(this.minText, maxWidth, this.size * 0.12);
            }
            this.minText.relocate((0.27778 * this.width - this.minText.getLayoutBounds().getWidth()) * 0.5, 0.7 * this.height);
            this.maxText.setText(String.format(this.locale, this.otherFormatString, this.gauge.getMaxValue()));
            this.maxText.setFont(this.smallFont);
            if (this.maxText.getLayoutBounds().getWidth() > maxWidth) {
                Helper.adjustTextSize(this.maxText, maxWidth, this.size * 0.12);
            }
            this.maxText.relocate((0.27778 * this.width - this.maxText.getLayoutBounds().getWidth()) * 0.5 + 0.72222 * this.width, 0.7 * this.height);
            if (this.gauge.isShadowsEnabled()) {
                this.innerShadow.setRadius(0.075 * this.height);
                this.innerShadow.setOffsetY(0.025 * this.height);
            }
            this.barBackgroundStart.setX(0.0);
            this.barBackgroundStart.setY(0.675 * this.height);
            this.barBackgroundOuterArc.setRadiusX(0.675 * this.height);
            this.barBackgroundOuterArc.setRadiusY(0.675 * this.height);
            this.barBackgroundOuterArc.setX(this.width);
            this.barBackgroundOuterArc.setY(0.675 * this.height);
            this.barBackgroundLineToInnerArc.setX(0.72222 * this.width);
            this.barBackgroundLineToInnerArc.setY(0.675 * this.height);
            this.barBackgroundInnerArc.setRadiusX(0.3 * this.height);
            this.barBackgroundInnerArc.setRadiusY(0.3 * this.height);
            this.barBackgroundInnerArc.setX(0.27778 * this.width);
            this.barBackgroundInnerArc.setY(0.675 * this.height);
            this.currentValueAngle = Helper.clamp(90.0, 270.0, (this.gauge.getCurrentValue() - this.minValue) * this.angleStep + 90.0);
            this.dataBarStart.setX(0.0);
            this.dataBarStart.setY(0.675 * this.height);
            this.dataBarOuterArc.setRadiusX(0.675 * this.height);
            this.dataBarOuterArc.setRadiusY(0.675 * this.height);
            this.dataBarOuterArc.setX(this.centerX + 0.675 * this.height * Math.sin(-Math.toRadians(this.currentValueAngle)));
            this.dataBarOuterArc.setY(this.centerX + 0.675 * this.height * Math.cos(-Math.toRadians(this.currentValueAngle)));
            this.dataBarLineToInnerArc.setX(this.centerX + 0.3 * this.height * Math.sin(-Math.toRadians(this.currentValueAngle)));
            this.dataBarLineToInnerArc.setY(this.centerX + 0.3 * this.height * Math.cos(-Math.toRadians(this.currentValueAngle)));
            this.dataBarInnerArc.setRadiusX(0.3 * this.height);
            this.dataBarInnerArc.setRadiusY(0.3 * this.height);
            this.dataBarInnerArc.setX(0.27778 * this.width);
            this.dataBarInnerArc.setY(0.675 * this.height);
            this.threshold.setStroke((Paint)this.gauge.getThresholdColor());
            this.threshold.setStrokeWidth(Helper.clamp(1.0, 2.0, 0.00675676 * this.height));
            double thresholdInnerRadius = 0.3 * this.height;
            double thresholdOuterRadius = 0.675 * this.height;
            double thresholdAngle = Helper.clamp(90.0, 270.0, (this.gauge.getThreshold() - this.minValue) * this.angleStep + 90.0);
            this.threshold.setStartX(this.centerX + thresholdInnerRadius * Math.sin(-Math.toRadians(thresholdAngle)));
            this.threshold.setStartY(this.centerX + thresholdInnerRadius * Math.cos(-Math.toRadians(thresholdAngle)));
            this.threshold.setEndX(this.centerX + thresholdOuterRadius * Math.sin(-Math.toRadians(thresholdAngle)));
            this.threshold.setEndY(this.centerX + thresholdOuterRadius * Math.cos(-Math.toRadians(thresholdAngle)));
            double thresholdTextRadius = 0.26 * this.height;
            this.thresholdText.setFill((Paint)this.gauge.getValueColor());
            this.thresholdText.setText(String.format(this.locale, this.formatString, this.gauge.getThreshold()));
            this.thresholdText.setFont(Fonts.robotoBold(this.size * 0.047));
            this.thresholdText.setRotate(thresholdAngle + 180.0);
            this.thresholdText.relocate(this.centerX - this.thresholdText.getLayoutBounds().getWidth() * 0.5 + thresholdTextRadius * Math.sin(-Math.toRadians(thresholdAngle)), this.centerX - this.thresholdText.getLayoutBounds().getWidth() * 0.5 + thresholdTextRadius * Math.cos(-Math.toRadians(thresholdAngle)));
        }
    }

    @Override
    protected void redraw() {
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.gauge.getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(this.gauge.getBorderWidth() / 250.0 * this.size))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.gauge.getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.colorGradientEnabled = this.gauge.isGradientBarEnabled();
        this.noOfGradientStops = this.gauge.getGradientBarStops().size();
        this.sectionsVisible = this.gauge.getSectionsVisible();
        this.barBackground.setFill((Paint)this.gauge.getBarBackgroundColor());
        this.barBackground.setEffect((Effect)(this.gauge.isShadowsEnabled() ? this.innerShadow : null));
        this.setBarColor(this.gauge.getCurrentValue());
        this.dataBar.setEffect((Effect)(this.gauge.isShadowsEnabled() ? this.innerShadow : null));
        this.threshold.setStroke((Paint)this.gauge.getThresholdColor());
        double thresholdInnerRadius = 0.3 * this.height;
        double thresholdOuterRadius = 0.675 * this.height;
        double thresholdAngle = Helper.clamp(90.0, 270.0, (this.gauge.getThreshold() - this.minValue) * this.angleStep + 90.0);
        this.threshold.setStartX(this.centerX + thresholdInnerRadius * Math.sin(-Math.toRadians(thresholdAngle)));
        this.threshold.setStartY(this.centerX + thresholdInnerRadius * Math.cos(-Math.toRadians(thresholdAngle)));
        this.threshold.setEndX(this.centerX + thresholdOuterRadius * Math.sin(-Math.toRadians(thresholdAngle)));
        this.threshold.setEndY(this.centerX + thresholdOuterRadius * Math.cos(-Math.toRadians(thresholdAngle)));
        this.redrawText();
    }

    private void redrawText() {
        this.locale = this.gauge.getLocale();
        this.formatString = "%." + Integer.toString(this.gauge.getDecimals()) + "f";
        this.otherFormatString = "%." + Integer.toString(this.gauge.getTickLabelDecimals()) + "f";
        this.titleText.setFill((Paint)this.gauge.getTitleColor());
        this.titleText.setText(this.gauge.getTitle());
        this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, 0.88 * this.height);
        this.valueText.setFill((Paint)this.gauge.getValueColor());
        this.valueText.setText(String.format(this.locale, this.formatString, this.gauge.getCurrentValue()));
        this.valueText.relocate((this.width - this.valueText.getLayoutBounds().getWidth()) * 0.5, 0.615 * this.height + (0.3 * this.height - this.valueText.getLayoutBounds().getHeight()) * 0.5);
        this.minText.setFill((Paint)this.gauge.getValueColor());
        this.minText.setText(String.format(this.locale, this.otherFormatString, this.gauge.getMinValue()));
        this.minText.relocate((0.27778 * this.width - this.minText.getLayoutBounds().getWidth()) * 0.5, 0.7 * this.height);
        this.maxText.setFill((Paint)this.gauge.getValueColor());
        this.maxText.setText(String.format(this.locale, this.otherFormatString, this.gauge.getMaxValue()));
        this.maxText.relocate((0.27778 * this.width - this.maxText.getLayoutBounds().getWidth()) * 0.5 + 0.72222 * this.width, 0.7 * this.height);
        this.unitText.setFill((Paint)this.gauge.getUnitColor());
        this.unitText.setText(this.gauge.getUnit());
        this.unitText.relocate((this.width - this.unitText.getLayoutBounds().getWidth()) * 0.5, 0.5 * this.height);
        double thresholdAngle = Helper.clamp(90.0, 270.0, (this.gauge.getThreshold() - this.minValue) * this.angleStep + 90.0);
        double thresholdTextRadius = 0.26 * this.height;
        this.thresholdText.setFill((Paint)this.gauge.getValueColor());
        this.thresholdText.setText(String.format(this.locale, this.formatString, this.gauge.getThreshold()));
        this.thresholdText.setFont(Fonts.robotoBold(this.size * 0.047));
        this.thresholdText.setRotate(thresholdAngle + 180.0);
        this.thresholdText.relocate(this.centerX - this.thresholdText.getLayoutBounds().getWidth() * 0.5 + thresholdTextRadius * Math.sin(-Math.toRadians(thresholdAngle)), this.centerX - this.thresholdText.getLayoutBounds().getWidth() * 0.5 + thresholdTextRadius * Math.cos(-Math.toRadians(thresholdAngle)));
    }
}

