/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Clock;
import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.tools.Helper;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Text;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;

public class TileClockSkin
extends SkinBase<Clock>
implements Skin<Clock> {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final DateTimeFormatter DATE_FORMATER = DateTimeFormatter.ofPattern("EE d");
    private static final double CLOCK_SCALE_FACTOR = 0.75;
    private double size;
    private double clockSize;
    private Path minuteTickMarks;
    private Path hourTickMarks;
    private Rectangle hour;
    private Rectangle minute;
    private Rectangle second;
    private Circle knob;
    private Text title;
    private Text amPmText;
    private Text dateText;
    private Text text;
    private Pane pane;
    private Rotate hourRotate;
    private Rotate minuteRotate = new Rotate();
    private Rotate secondRotate;
    private Group shadowGroupHour;
    private Group shadowGroupMinute;
    private Group shadowGroupSecond;
    private DropShadow dropShadow;

    public TileClockSkin(Clock gauge) {
        super((Control)gauge);
        this.hourRotate = new Rotate();
        this.secondRotate = new Rotate();
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(((Clock)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((Clock)this.getSkinnable()).getPrefWidth() > 0.0 && ((Clock)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((Clock)this.getSkinnable()).setPrefSize(((Clock)this.getSkinnable()).getPrefWidth(), ((Clock)this.getSkinnable()).getPrefHeight());
            } else {
                ((Clock)this.getSkinnable()).setPrefSize(250.0, 250.0);
            }
        }
        this.minuteTickMarks = new Path();
        this.minuteTickMarks.setFillRule(FillRule.EVEN_ODD);
        this.minuteTickMarks.setFill(null);
        this.minuteTickMarks.setStroke((Paint)((Clock)this.getSkinnable()).getMinuteColor());
        this.minuteTickMarks.setStrokeLineCap(StrokeLineCap.ROUND);
        this.hourTickMarks = new Path();
        this.hourTickMarks.setFillRule(FillRule.EVEN_ODD);
        this.hourTickMarks.setFill(null);
        this.hourTickMarks.setStroke((Paint)((Clock)this.getSkinnable()).getHourColor());
        this.hourTickMarks.setStrokeLineCap(StrokeLineCap.ROUND);
        this.hour = new Rectangle(3.0, 60.0);
        this.hour.setArcHeight(3.0);
        this.hour.setArcWidth(3.0);
        this.hour.setStroke((Paint)((Clock)this.getSkinnable()).getHourColor());
        this.hour.getTransforms().setAll((Object[])new Transform[]{this.hourRotate});
        this.minute = new Rectangle(3.0, 96.0);
        this.minute.setArcHeight(3.0);
        this.minute.setArcWidth(3.0);
        this.minute.setStroke((Paint)((Clock)this.getSkinnable()).getMinuteColor());
        this.minute.getTransforms().setAll((Object[])new Transform[]{this.minuteRotate});
        this.second = new Rectangle(1.0, 96.0);
        this.second.setArcHeight(1.0);
        this.second.setArcWidth(1.0);
        this.second.setStroke((Paint)((Clock)this.getSkinnable()).getSecondColor());
        this.second.getTransforms().setAll((Object[])new Transform[]{this.secondRotate});
        this.second.setVisible(((Clock)this.getSkinnable()).isSecondsVisible());
        this.second.setManaged(((Clock)this.getSkinnable()).isSecondsVisible());
        this.knob = new Circle(125.0, 125.0, 4.5);
        this.knob.setStroke((Paint)Color.web((String)"#282a3280"));
        this.dropShadow = new DropShadow();
        this.dropShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.25));
        this.dropShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.dropShadow.setRadius(3.75);
        this.dropShadow.setOffsetY(3.75);
        this.shadowGroupHour = new Group(new Node[]{this.hour});
        this.shadowGroupMinute = new Group(new Node[]{this.minute});
        this.shadowGroupSecond = new Group(new Node[]{this.second, this.knob});
        this.shadowGroupHour.setEffect((Effect)(((Clock)this.getSkinnable()).getShadowsEnabled() ? this.dropShadow : null));
        this.shadowGroupMinute.setEffect((Effect)(((Clock)this.getSkinnable()).getShadowsEnabled() ? this.dropShadow : null));
        this.shadowGroupSecond.setEffect((Effect)(((Clock)this.getSkinnable()).getShadowsEnabled() ? this.dropShadow : null));
        this.title = new Text("");
        this.title.setTextOrigin(VPos.TOP);
        Helper.enableNode((Node)this.title, ((Clock)this.getSkinnable()).isTitleVisible());
        this.amPmText = new Text(((Clock)this.getSkinnable()).getTime().get(ChronoField.AMPM_OF_DAY) == 0 ? "AM" : "PM");
        this.dateText = new Text("");
        Helper.enableNode((Node)this.dateText, ((Clock)this.getSkinnable()).isDateVisible());
        this.text = new Text("");
        Helper.enableNode((Node)this.text, ((Clock)this.getSkinnable()).isTextVisible());
        this.pane = new Pane(new Node[]{this.hourTickMarks, this.minuteTickMarks, this.title, this.amPmText, this.dateText, this.text, this.shadowGroupHour, this.shadowGroupMinute, this.shadowGroupSecond});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Clock)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(6.25), new BorderWidths(((Clock)this.getSkinnable()).getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Clock)this.getSkinnable()).getBackgroundPaint(), new CornerRadii(6.25), Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((Clock)this.getSkinnable()).widthProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Clock)this.getSkinnable()).heightProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Clock)this.getSkinnable()).setOnUpdate(e -> this.handleEvents(e.eventType.name()));
        if (((Clock)this.getSkinnable()).isAnimated()) {
            ((Clock)this.getSkinnable()).currentTimeProperty().addListener(o -> this.updateTime(ZonedDateTime.ofInstant(Instant.ofEpochSecond(((Clock)this.getSkinnable()).getCurrentTime()), ZoneId.of(ZoneId.systemDefault().getId()))));
        } else {
            ((Clock)this.getSkinnable()).timeProperty().addListener(o -> this.updateTime(((Clock)this.getSkinnable()).getTime()));
        }
    }

    protected double computeMinWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return super.computePrefWidth(HEIGHT, TOP, RIGHT, BOTTOM, LEFT);
    }

    protected double computePrefHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return super.computePrefHeight(WIDTH, TOP, RIGHT, BOTTOM, LEFT);
    }

    protected double computeMaxWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 1024.0;
    }

    protected double computeMaxHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 1024.0;
    }

    private void handleEvents(String EVENT_TYPE) {
        if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
            this.redraw();
        } else if ("REDRAW".equals(EVENT_TYPE)) {
            this.redraw();
        } else if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.title, ((Clock)this.getSkinnable()).isTitleVisible());
            Helper.enableNode((Node)this.text, ((Clock)this.getSkinnable()).isTextVisible());
            Helper.enableNode((Node)this.dateText, ((Clock)this.getSkinnable()).isDateVisible());
            Helper.enableNode((Node)this.second, ((Clock)this.getSkinnable()).isSecondsVisible());
        } else if ("FINISHED".equals(EVENT_TYPE)) {
            // empty if block
        }
    }

    private void drawTicks() {
        this.minuteTickMarks.setCache(false);
        this.hourTickMarks.setCache(false);
        this.minuteTickMarks.getElements().clear();
        this.hourTickMarks.getElements().clear();
        double startAngle = 180.0;
        double angleStep = 6.0;
        Point2D center = new Point2D(this.clockSize * 0.5, this.clockSize * 0.5);
        boolean hourTickMarksVisible = ((Clock)this.getSkinnable()).isHourTickMarksVisible();
        boolean minuteTickMarksVisible = ((Clock)this.getSkinnable()).isMinuteTickMarksVisible();
        double angle = 0.0;
        double counter = 0.0;
        while (Double.compare(counter, 59.0) <= 0) {
            double sinValue = Math.sin(Math.toRadians(angle + startAngle));
            double cosValue = Math.cos(Math.toRadians(angle + startAngle));
            Point2D innerPoint = new Point2D(center.getX() + this.clockSize * 0.405 * sinValue, center.getY() + this.clockSize * 0.405 * cosValue);
            Point2D innerMinutePoint = new Point2D(center.getX() + this.clockSize * 0.435 * sinValue, center.getY() + this.clockSize * 0.435 * cosValue);
            Point2D outerPoint = new Point2D(center.getX() + this.clockSize * 0.465 * sinValue, center.getY() + this.clockSize * 0.465 * cosValue);
            if (counter % 5.0 == 0.0) {
                if (hourTickMarksVisible) {
                    this.hourTickMarks.setStrokeWidth(this.clockSize * 0.01);
                    this.hourTickMarks.getElements().add((Object)new MoveTo(innerPoint.getX(), innerPoint.getY()));
                    this.hourTickMarks.getElements().add((Object)new LineTo(outerPoint.getX(), outerPoint.getY()));
                } else if (minuteTickMarksVisible) {
                    this.minuteTickMarks.setStrokeWidth(this.clockSize * 0.005);
                    this.minuteTickMarks.getElements().add((Object)new MoveTo(innerMinutePoint.getX(), innerMinutePoint.getY()));
                    this.minuteTickMarks.getElements().add((Object)new LineTo(outerPoint.getX(), outerPoint.getY()));
                }
            } else if (counter % 1.0 == 0.0 && minuteTickMarksVisible) {
                this.minuteTickMarks.setStrokeWidth(this.clockSize * 0.005);
                this.minuteTickMarks.getElements().add((Object)new MoveTo(innerMinutePoint.getX(), innerMinutePoint.getY()));
                this.minuteTickMarks.getElements().add((Object)new LineTo(outerPoint.getX(), outerPoint.getY()));
            }
            angle -= angleStep;
            counter += 1.0;
        }
        this.minuteTickMarks.setCache(true);
        this.minuteTickMarks.setCacheHint(CacheHint.QUALITY);
        this.hourTickMarks.setCache(true);
        this.hourTickMarks.setCacheHint(CacheHint.QUALITY);
    }

    public void updateTime(ZonedDateTime TIME) {
        if (((Clock)this.getSkinnable()).isDiscreteHours()) {
            this.hourRotate.setAngle((double)(TIME.getHour() * 30));
        } else {
            this.hourRotate.setAngle(0.5 * (double)(60 * TIME.getHour() + TIME.getMinute()));
        }
        if (((Clock)this.getSkinnable()).isDiscreteMinutes()) {
            this.minuteRotate.setAngle((double)(TIME.getMinute() * 6));
        } else {
            this.minuteRotate.setAngle((double)(TIME.getMinute() * 6) + (double)TIME.getSecond() * 0.1);
        }
        if (this.second.isVisible()) {
            if (((Clock)this.getSkinnable()).isDiscreteSeconds()) {
                this.secondRotate.setAngle((double)(TIME.getSecond() * 6));
            } else {
                this.secondRotate.setAngle((double)(TIME.getSecond() * 6) + (double)TIME.get(ChronoField.MILLI_OF_SECOND) * 0.006);
            }
        }
        this.amPmText.setText(((Clock)this.getSkinnable()).getTime().get(ChronoField.AMPM_OF_DAY) == 0 ? "AM" : "PM");
        Helper.adjustTextSize(this.amPmText, 0.2 * this.size, this.size * 0.05);
        this.amPmText.setX((this.size - this.amPmText.getLayoutBounds().getWidth()) * 0.5);
        this.amPmText.setY(this.size * 0.4);
        this.dateText.setText(DATE_FORMATER.format(TIME).toUpperCase());
        Helper.adjustTextSize(this.dateText, 0.3 * this.size, this.size * 0.05);
        this.dateText.setX((this.size - this.dateText.getLayoutBounds().getWidth()) * 0.5);
        this.dateText.setY(this.size * 0.65);
    }

    private void resizeText() {
        double maxWidth = this.size * 0.9;
        double fontSize = this.size * 0.06;
        this.title.setFont(Fonts.latoRegular(fontSize));
        this.title.setText(((Clock)this.getSkinnable()).getTitle());
        if (this.title.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.title, maxWidth, fontSize);
        }
        this.title.setX(this.size * 0.05);
        this.title.setY(this.size * 0.05);
        maxWidth = this.size * 0.2;
        fontSize = this.size * 0.05;
        this.amPmText.setText(((Clock)this.getSkinnable()).getTime().get(ChronoField.AMPM_OF_DAY) == 0 ? "AM" : "PM");
        Helper.adjustTextSize(this.amPmText, maxWidth, fontSize);
        this.amPmText.setX((this.size - this.amPmText.getLayoutBounds().getWidth()) * 0.5);
        this.amPmText.setY(this.size * 0.4);
        maxWidth = this.size * 0.6;
        this.dateText.setFont(Fonts.latoRegular(fontSize));
        if (this.dateText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.dateText, maxWidth, fontSize);
        }
        this.dateText.setX((this.size - this.dateText.getLayoutBounds().getWidth()) * 0.5);
        this.dateText.setY(this.size * 0.65);
        maxWidth = this.size * 0.9;
        fontSize = this.size * 0.05;
        this.text.setText(((Clock)this.getSkinnable()).getText());
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        this.text.setX(this.size * 0.05);
        this.text.setY(this.size * 0.95);
    }

    private void resize() {
        double height;
        double width = ((Clock)this.getSkinnable()).getWidth() - ((Clock)this.getSkinnable()).getInsets().getLeft() - ((Clock)this.getSkinnable()).getInsets().getRight();
        this.size = width < (height = ((Clock)this.getSkinnable()).getHeight() - ((Clock)this.getSkinnable()).getInsets().getTop() - ((Clock)this.getSkinnable()).getInsets().getBottom()) ? width : height;
        this.clockSize = this.size * 0.75;
        if (this.size > 0.0) {
            double center = this.size * 0.5;
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((((Clock)this.getSkinnable()).getWidth() - this.size) * 0.5, (((Clock)this.getSkinnable()).getHeight() - this.size) * 0.5);
            this.dropShadow.setRadius(0.008 * this.size);
            this.dropShadow.setOffsetY(0.008 * this.size);
            this.drawTicks();
            this.hourTickMarks.relocate((this.size - this.hourTickMarks.getLayoutBounds().getWidth()) * 0.5, (this.size - this.hourTickMarks.getLayoutBounds().getHeight()) * 0.5);
            this.minuteTickMarks.relocate((this.size - this.minuteTickMarks.getLayoutBounds().getWidth()) * 0.5, (this.size - this.minuteTickMarks.getLayoutBounds().getHeight()) * 0.5);
            this.hour.setFill((Paint)((Clock)this.getSkinnable()).getHourColor());
            this.hour.setCache(false);
            this.hour.setWidth(this.clockSize * 0.015);
            this.hour.setHeight(this.clockSize * 0.29);
            this.hour.setArcWidth(this.clockSize * 0.015);
            this.hour.setArcHeight(this.clockSize * 0.015);
            this.hour.setCache(true);
            this.hour.setCacheHint(CacheHint.ROTATE);
            this.hour.relocate((this.size - this.hour.getWidth()) * 0.5, this.size * 0.21 / 0.75);
            this.minute.setFill((Paint)((Clock)this.getSkinnable()).getMinuteColor());
            this.minute.setCache(false);
            this.minute.setWidth(this.clockSize * 0.015);
            this.minute.setHeight(this.clockSize * 0.47);
            this.minute.setArcWidth(this.clockSize * 0.015);
            this.minute.setArcHeight(this.clockSize * 0.015);
            this.minute.setCache(true);
            this.minute.setCacheHint(CacheHint.ROTATE);
            this.minute.relocate((this.size - this.minute.getWidth()) * 0.5, this.size * 0.11 / 0.75);
            this.second.setFill((Paint)((Clock)this.getSkinnable()).getSecondColor());
            this.second.setCache(false);
            this.second.setWidth(this.clockSize * 0.005);
            this.second.setHeight(this.clockSize * 0.47);
            this.second.setArcWidth(this.clockSize * 0.015);
            this.second.setArcHeight(this.clockSize * 0.015);
            this.second.setCache(true);
            this.second.setCacheHint(CacheHint.ROTATE);
            this.second.relocate((this.size - this.second.getWidth()) * 0.5, this.size * 0.11 / 0.75);
            this.knob.setFill((Paint)((Clock)this.getSkinnable()).getKnobColor());
            this.knob.setRadius(this.clockSize * 0.0225);
            this.knob.setCenterX(center);
            this.knob.setCenterY(center);
            this.resizeText();
            this.minuteRotate.setPivotX(this.minute.getWidth() * 0.5);
            this.minuteRotate.setPivotY(this.minute.getHeight());
            this.hourRotate.setPivotX(this.hour.getWidth() * 0.5);
            this.hourRotate.setPivotY(this.hour.getHeight());
            this.secondRotate.setPivotX(this.second.getWidth() * 0.5);
            this.secondRotate.setPivotY(this.second.getHeight());
        }
    }

    private void redraw() {
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Clock)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(this.size * 0.025), new BorderWidths(((Clock)this.getSkinnable()).getBorderWidth() / 250.0 * this.size))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Clock)this.getSkinnable()).getBackgroundPaint(), new CornerRadii(this.size * 0.025), Insets.EMPTY)}));
        this.shadowGroupHour.setEffect((Effect)(((Clock)this.getSkinnable()).getShadowsEnabled() ? this.dropShadow : null));
        this.shadowGroupMinute.setEffect((Effect)(((Clock)this.getSkinnable()).getShadowsEnabled() ? this.dropShadow : null));
        this.shadowGroupSecond.setEffect((Effect)(((Clock)this.getSkinnable()).getShadowsEnabled() ? this.dropShadow : null));
        this.minuteTickMarks.setStroke((Paint)((Clock)this.getSkinnable()).getMinuteColor());
        this.hourTickMarks.setStroke((Paint)((Clock)this.getSkinnable()).getHourColor());
        ZonedDateTime time = ((Clock)this.getSkinnable()).getTime();
        this.updateTime(time);
        this.resizeText();
        this.title.setFill((Paint)((Clock)this.getSkinnable()).getTitleColor());
        this.dateText.setFill((Paint)((Clock)this.getSkinnable()).getDateColor());
        this.text.setFill((Paint)((Clock)this.getSkinnable()).getTextColor());
        this.amPmText.setFill((Paint)((Clock)this.getSkinnable()).getTextColor());
    }
}

