/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.tools.Helper;
import java.util.List;
import java.util.Locale;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.image.Image;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;

public class SectionSkin
extends SkinBase<Gauge>
implements Skin<Gauge> {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double START_ANGLE = 300.0;
    private double ANGLE_RANGE = 240.0;
    private double size;
    private Pane pane;
    private Path ring;
    private Canvas sectionsCanvas;
    private GraphicsContext sectionsCtx;
    private Circle mask;
    private Circle knob;
    private Path needle;
    private Rotate needleRotate;
    private Text valueText;
    private Text titleText;
    private double angleStep;
    private String formatString;
    private Locale locale;
    private List<Section> sections;
    private boolean highlightSections;
    private boolean sectionsVisible;
    private double minValue;
    private double maxValue;

    public SectionSkin(Gauge gauge) {
        super((Control)gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.angleStep = this.ANGLE_RANGE / (gauge.getMaxValue() - gauge.getMinValue());
        this.formatString = "%." + Integer.toString(gauge.getDecimals()) + "f";
        this.locale = gauge.getLocale();
        this.sections = gauge.getSections();
        this.highlightSections = gauge.isHighlightSections();
        this.sectionsVisible = gauge.getSectionsVisible();
        this.minValue = gauge.getMinValue();
        this.maxValue = gauge.getMaxValue();
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(((Gauge)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((Gauge)this.getSkinnable()).getPrefWidth() > 0.0 && ((Gauge)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((Gauge)this.getSkinnable()).setPrefSize(((Gauge)this.getSkinnable()).getPrefWidth(), ((Gauge)this.getSkinnable()).getPrefHeight());
            } else {
                ((Gauge)this.getSkinnable()).setPrefSize(250.0, 250.0);
            }
        }
        this.ring = new Path();
        this.ring.setFillRule(FillRule.EVEN_ODD);
        this.ring.setStroke(null);
        this.ring.setFill((Paint)Gauge.DARK_COLOR);
        this.ring.setEffect((Effect)new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)255, (int)255, (int)255, (double)0.35), 1.0, 0.0, 0.0, 1.0));
        this.sectionsCanvas = new Canvas(250.0, 250.0);
        this.sectionsCtx = this.sectionsCanvas.getGraphicsContext2D();
        this.mask = new Circle();
        this.mask.setStroke(null);
        this.mask.setFill(((Gauge)this.getSkinnable()).getBackgroundPaint());
        this.knob = new Circle();
        this.knob.setStroke(null);
        this.knob.setFill((Paint)((Gauge)this.getSkinnable()).getKnobColor());
        this.angleStep = this.ANGLE_RANGE / ((Gauge)this.getSkinnable()).getRange();
        double targetAngle = 180.0 - this.START_ANGLE + (((Gauge)this.getSkinnable()).getValue() - ((Gauge)this.getSkinnable()).getMinValue()) * this.angleStep;
        this.needleRotate = new Rotate(180.0 - this.START_ANGLE);
        this.needleRotate.setAngle(Helper.clamp(180.0 - this.START_ANGLE, 180.0 - this.START_ANGLE + this.ANGLE_RANGE, targetAngle));
        this.needle = new Path();
        this.needle.setFillRule(FillRule.EVEN_ODD);
        this.needle.setStroke(null);
        this.needle.getTransforms().setAll((Object[])new Transform[]{this.needleRotate});
        this.valueText = new Text(String.format(this.locale, this.formatString, ((Gauge)this.getSkinnable()).getMinValue()) + ((Gauge)this.getSkinnable()).getUnit());
        this.valueText.setMouseTransparent(true);
        this.valueText.setTextOrigin(VPos.CENTER);
        this.valueText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        Helper.enableNode((Node)this.valueText, ((Gauge)this.getSkinnable()).isValueVisible());
        this.titleText = new Text(((Gauge)this.getSkinnable()).getTitle());
        this.titleText.setTextOrigin(VPos.CENTER);
        this.titleText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        Helper.enableNode((Node)this.titleText, !((Gauge)this.getSkinnable()).getTitle().isEmpty());
        this.pane = new Pane(new Node[]{this.ring, this.sectionsCanvas, this.mask, this.knob, this.needle, this.valueText, this.titleText});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((Gauge)this.getSkinnable()).widthProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).heightProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).getSections().addListener(change -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).setOnUpdate(event -> this.handleEvents(event.eventType.name()));
        ((Gauge)this.getSkinnable()).currentValueProperty().addListener(e -> this.rotateNeedle(((Gauge)this.getSkinnable()).getCurrentValue()));
    }

    protected double computeMinWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return super.computePrefWidth(HEIGHT, TOP, RIGHT, BOTTOM, LEFT);
    }

    protected double computePrefHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return super.computePrefHeight(WIDTH, TOP, RIGHT, BOTTOM, LEFT);
    }

    protected double computeMaxWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 1024.0;
    }

    protected double computeMaxHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 1024.0;
    }

    protected void handleEvents(String EVENT_TYPE) {
        if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
            this.redraw();
        } else if ("REDRAW".equals(EVENT_TYPE)) {
            this.redraw();
        } else if ("FINISHED".equals(EVENT_TYPE)) {
            if (((Gauge)this.getSkinnable()).getCheckSectionsForValue()) {
                double currentValue = ((Gauge)this.getSkinnable()).getCurrentValue();
                int listSize = this.sections.size();
                for (int i = 0; i < listSize; ++i) {
                    this.sections.get(i).checkForValue(currentValue);
                }
            }
            if (this.highlightSections) {
                this.drawSections();
            }
        } else if ("RECALC".equals(EVENT_TYPE)) {
            this.minValue = ((Gauge)this.getSkinnable()).getMinValue();
            this.maxValue = ((Gauge)this.getSkinnable()).getMaxValue();
            this.angleStep = this.ANGLE_RANGE / ((Gauge)this.getSkinnable()).getRange();
            this.needleRotate.setAngle(180.0 - this.START_ANGLE + (((Gauge)this.getSkinnable()).getValue() - ((Gauge)this.getSkinnable()).getMinValue()) * this.angleStep);
            this.resize();
            this.rotateNeedle(((Gauge)this.getSkinnable()).getCurrentValue());
        } else if ("SECTION".equals(EVENT_TYPE)) {
            this.sections = ((Gauge)this.getSkinnable()).getSections();
            this.highlightSections = ((Gauge)this.getSkinnable()).isHighlightSections();
            this.resize();
            this.redraw();
        } else if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.valueText, ((Gauge)this.getSkinnable()).isValueVisible());
            Helper.enableNode((Node)this.titleText, !((Gauge)this.getSkinnable()).getTitle().isEmpty());
        }
    }

    private void rotateNeedle(double VALUE) {
        double targetAngle = 180.0 - this.START_ANGLE + (VALUE - ((Gauge)this.getSkinnable()).getMinValue()) * this.angleStep;
        this.needleRotate.setAngle(Helper.clamp(180.0 - this.START_ANGLE, 180.0 - this.START_ANGLE + this.ANGLE_RANGE, targetAngle));
        this.valueText.setText(String.format(this.locale, this.formatString, VALUE) + ((Gauge)this.getSkinnable()).getUnit());
        this.valueText.setTranslateX((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5);
        if (this.valueText.getLayoutBounds().getWidth() > 0.395 * this.size) {
            this.resizeText();
        }
    }

    private void createNeedle() {
        double needleWidth = this.size * 0.04;
        double needleHeight = this.size * 0.4675;
        this.needle.getElements().clear();
        this.needle.getElements().add((Object)new MoveTo(0.3125 * needleWidth, 0.015957446808510637 * needleHeight));
        this.needle.getElements().add((Object)new CubicCurveTo(0.3125 * needleWidth, 0.005319148936170213 * needleHeight, 0.4375 * needleWidth, 0.0, 0.5 * needleWidth, 0.0));
        this.needle.getElements().add((Object)new CubicCurveTo(0.5625 * needleWidth, 0.0, 0.6875 * needleWidth, 0.005319148936170213 * needleHeight, 0.6875 * needleWidth, 0.015957446808510637 * needleHeight));
        this.needle.getElements().add((Object)new CubicCurveTo(0.6875 * needleWidth, 0.015957446808510637 * needleHeight, needleWidth, 0.9946808510638298 * needleHeight, needleWidth, 0.9946808510638298 * needleHeight));
        this.needle.getElements().add((Object)new LineTo(0.0, 0.9946808510638298 * needleHeight));
        this.needle.getElements().add((Object)new CubicCurveTo(0.0, 0.9946808510638298 * needleHeight, 0.3125 * needleWidth, 0.015957446808510637 * needleHeight, 0.3125 * needleWidth, 0.015957446808510637 * needleHeight));
        this.needle.getElements().add((Object)new ClosePath());
        this.needle.setFill((Paint)new LinearGradient(this.needle.getLayoutBounds().getMinX(), 0.0, this.needle.getLayoutBounds().getMaxX(), 0.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, ((Gauge)this.getSkinnable()).getNeedleColor().darker()), new Stop(0.5, ((Gauge)this.getSkinnable()).getNeedleColor()), new Stop(1.0, ((Gauge)this.getSkinnable()).getNeedleColor().darker())}));
    }

    private void drawSections() {
        this.sectionsCtx.clearRect(0.0, 0.0, this.size, this.size);
        if (!this.sectionsVisible | this.sections.isEmpty()) {
            return;
        }
        double value = ((Gauge)this.getSkinnable()).getCurrentValue();
        boolean sectionTextVisible = ((Gauge)this.getSkinnable()).isSectionTextVisible();
        boolean sectionIconVisible = ((Gauge)this.getSkinnable()).getSectionIconsVisible();
        double offset = this.START_ANGLE - 90.0;
        int listSize = this.sections.size();
        double xy = this.size * 0.0325;
        double wh = this.size - this.size * 0.065;
        double center = this.size * 0.5;
        this.angleStep = this.ANGLE_RANGE / ((Gauge)this.getSkinnable()).getRange();
        this.sectionsCtx.setFont(Fonts.robotoCondensedLight(0.05 * this.size));
        this.sectionsCtx.setTextAlign(TextAlignment.CENTER);
        this.sectionsCtx.setTextBaseline(VPos.CENTER);
        for (int i = 0; i < listSize; ++i) {
            Image icon;
            double cosValue;
            double sinValue;
            Section section = this.sections.get(i);
            if (section.getStart() > this.maxValue || section.getStop() < this.minValue) continue;
            double SECTION_START_ANGLE = section.getStart() < this.minValue && section.getStop() < this.maxValue ? 0.0 : (section.getStart() - this.minValue) * this.angleStep;
            double SECTION_ANGLE_EXTEND = Double.compare(section.getStop(), this.maxValue) > 0 ? (this.maxValue - section.getStart()) * this.angleStep : (Double.compare(section.getStart(), this.minValue) < 0 ? (section.getStop() - this.minValue) * this.angleStep : (section.getStop() - section.getStart()) * this.angleStep);
            this.sectionsCtx.save();
            if (this.highlightSections) {
                this.sectionsCtx.setFill((Paint)(section.contains(value) ? section.getHighlightColor() : section.getColor()));
            } else {
                this.sectionsCtx.setFill((Paint)section.getColor());
            }
            this.sectionsCtx.fillArc(xy, xy, wh, wh, offset - SECTION_START_ANGLE, -SECTION_ANGLE_EXTEND, ArcType.ROUND);
            this.sectionsCtx.setStroke((Paint)Gauge.DARK_COLOR);
            this.sectionsCtx.setLineWidth(this.size * 0.005);
            this.sectionsCtx.strokeArc(xy, xy, wh, wh, offset - SECTION_START_ANGLE, -SECTION_ANGLE_EXTEND, ArcType.ROUND);
            if (sectionTextVisible) {
                double angle = offset - 90.0 - SECTION_START_ANGLE - SECTION_ANGLE_EXTEND * 0.5;
                sinValue = -Math.sin(Math.toRadians(angle));
                cosValue = -Math.cos(Math.toRadians(angle));
                double textPointX = center + this.size * 0.4 * sinValue;
                double textPointY = center + this.size * 0.4 * cosValue;
                this.sectionsCtx.save();
                this.sectionsCtx.translate(textPointX, textPointY);
                this.sectionsCtx.rotate(-angle);
                this.sectionsCtx.translate(-textPointX, -textPointY);
                this.sectionsCtx.setFill((Paint)section.getTextColor());
                this.sectionsCtx.fillText(section.getText(), textPointX, textPointY, 0.2 * this.size);
                this.sectionsCtx.restore();
            } else if (this.size > 0.0 && sectionIconVisible && null != (icon = section.getImage())) {
                sinValue = -Math.sin(Math.toRadians(offset - 90.0 - SECTION_START_ANGLE - SECTION_ANGLE_EXTEND * 0.5));
                cosValue = -Math.cos(Math.toRadians(offset - 90.0 - SECTION_START_ANGLE - SECTION_ANGLE_EXTEND * 0.5));
                Point2D iconPoint = new Point2D(center + this.size * 0.365 * sinValue, this.size * 0.5 + this.size * 0.365 * cosValue);
                this.sectionsCtx.drawImage(icon, iconPoint.getX() - this.size * 0.06, iconPoint.getY() - this.size * 0.06, this.size * 0.12, this.size * 0.12);
            }
            this.sectionsCtx.restore();
        }
    }

    private void resizeText() {
        double fontSize = this.size * 0.1;
        this.valueText.setFont(Fonts.robotoMedium(fontSize));
        double maxWidth = 0.395 * this.size;
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
        this.valueText.setTranslateX((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5);
        this.valueText.setTranslateY(this.size * 0.68);
        fontSize = this.size * 0.11;
        this.titleText.setFont(Fonts.robotoMedium(fontSize));
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        this.titleText.setTranslateX((this.size - this.titleText.getLayoutBounds().getWidth()) * 0.5);
        this.titleText.setTranslateY(this.size * 0.85);
    }

    private void resize() {
        double height;
        double width = ((Gauge)this.getSkinnable()).getWidth() - ((Gauge)this.getSkinnable()).getInsets().getLeft() - ((Gauge)this.getSkinnable()).getInsets().getRight();
        double d = this.size = width < (height = ((Gauge)this.getSkinnable()).getHeight() - ((Gauge)this.getSkinnable()).getInsets().getTop() - ((Gauge)this.getSkinnable()).getInsets().getBottom()) ? width : height;
        if (this.size > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((((Gauge)this.getSkinnable()).getWidth() - this.size) * 0.5, (((Gauge)this.getSkinnable()).getHeight() - this.size) * 0.5);
            this.ring.getElements().clear();
            this.ring.getElements().add((Object)new MoveTo(0.5 * this.size, 0.03 * this.size));
            this.ring.getElements().add((Object)new CubicCurveTo(0.76 * this.size, 0.03 * this.size, 0.97 * this.size, 0.24 * this.size, 0.97 * this.size, 0.5 * this.size));
            this.ring.getElements().add((Object)new CubicCurveTo(0.97 * this.size, 0.76 * this.size, 0.76 * this.size, 0.97 * this.size, 0.5 * this.size, 0.97 * this.size));
            this.ring.getElements().add((Object)new CubicCurveTo(0.24 * this.size, 0.97 * this.size, 0.03 * this.size, 0.76 * this.size, 0.03 * this.size, 0.5 * this.size));
            this.ring.getElements().add((Object)new CubicCurveTo(0.03 * this.size, 0.24 * this.size, 0.24 * this.size, 0.03 * this.size, 0.5 * this.size, 0.03 * this.size));
            this.ring.getElements().add((Object)new ClosePath());
            this.ring.getElements().add((Object)new MoveTo(0.5 * this.size, 0.2125 * this.size));
            this.ring.getElements().add((Object)new CubicCurveTo(0.6575 * this.size, 0.2125 * this.size, 0.7875 * this.size, 0.3425 * this.size, 0.7875 * this.size, 0.5 * this.size));
            this.ring.getElements().add((Object)new CubicCurveTo(0.7875 * this.size, 0.6575 * this.size, 0.6575 * this.size, 0.7875 * this.size, 0.5 * this.size, 0.7875 * this.size));
            this.ring.getElements().add((Object)new CubicCurveTo(0.3425 * this.size, 0.7875 * this.size, 0.2125 * this.size, 0.6575 * this.size, 0.2125 * this.size, 0.5 * this.size));
            this.ring.getElements().add((Object)new CubicCurveTo(0.2125 * this.size, 0.3425 * this.size, 0.3425 * this.size, 0.2125 * this.size, 0.5 * this.size, 0.2125 * this.size));
            this.ring.getElements().add((Object)new ClosePath());
            this.sectionsCanvas.setCache(false);
            this.sectionsCanvas.setWidth(this.size);
            this.sectionsCanvas.setHeight(this.size);
            this.drawSections();
            this.sectionsCanvas.setCache(true);
            this.sectionsCanvas.setCacheHint(CacheHint.QUALITY);
            this.mask.setCenterX(this.size * 0.5);
            this.mask.setCenterY(this.size * 0.5);
            this.mask.setRadius(this.size * 0.2855);
            this.knob.setCenterX(this.size * 0.5);
            this.knob.setCenterY(this.size * 0.5);
            this.knob.setRadius(this.size * 0.10375);
            this.needle.setCache(false);
            this.createNeedle();
            this.needle.setCache(true);
            this.needle.setCacheHint(CacheHint.ROTATE);
            this.needle.relocate((this.size - this.needle.getLayoutBounds().getWidth()) * 0.5, this.size * 0.5 - this.needle.getLayoutBounds().getHeight());
            this.needleRotate.setPivotX(this.needle.getLayoutBounds().getWidth() * 0.5);
            this.needleRotate.setPivotY(this.needle.getLayoutBounds().getMaxY());
            double currentValue = (this.needleRotate.getAngle() + this.START_ANGLE - 180.0) / this.angleStep + ((Gauge)this.getSkinnable()).getMinValue();
            this.valueText.setText(String.format(this.locale, "%." + ((Gauge)this.getSkinnable()).getDecimals() + "f", currentValue) + ((Gauge)this.getSkinnable()).getUnit());
            this.valueText.setVisible(((Gauge)this.getSkinnable()).isValueVisible());
            this.titleText.setText(((Gauge)this.getSkinnable()).getTitle());
            this.resizeText();
        }
    }

    private void redraw() {
        this.sectionsVisible = ((Gauge)this.getSkinnable()).getSectionsVisible();
        this.drawSections();
        this.needle.setFill((Paint)new LinearGradient(this.needle.getLayoutBounds().getMinX(), 0.0, this.needle.getLayoutBounds().getMaxX(), 0.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, ((Gauge)this.getSkinnable()).getNeedleColor().darker()), new Stop(0.5, ((Gauge)this.getSkinnable()).getNeedleColor()), new Stop(1.0, ((Gauge)this.getSkinnable()).getNeedleColor().darker())}));
        this.titleText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.valueText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        this.mask.setFill(((Gauge)this.getSkinnable()).getBackgroundPaint());
        this.knob.setFill((Paint)((Gauge)this.getSkinnable()).getKnobColor());
        this.locale = ((Gauge)this.getSkinnable()).getLocale();
        this.formatString = "%." + Integer.toString(((Gauge)this.getSkinnable()).getDecimals()) + "f";
        this.titleText.setText(((Gauge)this.getSkinnable()).getTitle());
        this.resizeText();
    }
}

