/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Clock;
import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.LcdDesign;
import eu.hansolo.medusa.LcdFont;
import eu.hansolo.medusa.tools.Helper;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.util.Locale;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class LcdClockSkin
extends SkinBase<Clock>
implements Skin<Clock> {
    private static final double PREFERRED_WIDTH = 220.0;
    private static final double PREFERRED_HEIGHT = 100.0;
    private static final double MINIMUM_WIDTH = 5.0;
    private static final double MINIMUM_HEIGHT = 5.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final Color DARK_NOISE_COLOR = Color.rgb((int)100, (int)100, (int)100, (double)0.1);
    private static final Color BRIGHT_NOISE_COLOR = Color.rgb((int)200, (int)200, (int)200, (double)0.05);
    private static final DropShadow FOREGROUND_SHADOW = new DropShadow();
    private static final double ASPECT_RATIO = 0.52631579;
    private double width;
    private double height;
    private Pane pane;
    private Paint lcdPaint;
    private Paint lcdFramePaint;
    private ImageView crystalOverlay;
    private Image crystalImage;
    private Rectangle crystalClip;
    private InnerShadow mainInnerShadow0;
    private InnerShadow mainInnerShadow1;
    private Text timeText;
    private Text backgroundTimeText;
    private Text secondText;
    private Text backgroundSecondText;
    private Text title;
    private Text dateText;
    private Text dayOfWeekText;
    private Path alarm;
    private DateTimeFormatter dateFormat;
    private double valueOffsetRight = 0.0;
    private double digitalFontSizeFactor = 1.0;
    private Font timeFont;
    private Font secondFont;
    private Font titleFont;
    private Font smallFont;
    private StringBuilder backgroundTextBuilder = new StringBuilder();
    private Group shadowGroup;

    public LcdClockSkin(Clock clock) {
        super((Control)clock);
        FOREGROUND_SHADOW.setOffsetX(0.0);
        FOREGROUND_SHADOW.setOffsetY(1.0);
        FOREGROUND_SHADOW.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.5));
        FOREGROUND_SHADOW.setBlurType(BlurType.TWO_PASS_BOX);
        FOREGROUND_SHADOW.setRadius(2.0);
        this.adjustDateFormat();
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(((Clock)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((Clock)this.getSkinnable()).getPrefWidth() > 0.0 && ((Clock)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((Clock)this.getSkinnable()).setPrefSize(((Clock)this.getSkinnable()).getPrefWidth(), ((Clock)this.getSkinnable()).getPrefHeight());
            } else {
                ((Clock)this.getSkinnable()).setPrefSize(220.0, 100.0);
            }
        }
        this.mainInnerShadow0 = new InnerShadow();
        this.mainInnerShadow0.setOffsetX(0.0);
        this.mainInnerShadow0.setOffsetY(0.0);
        this.mainInnerShadow0.setRadius(5.0);
        this.mainInnerShadow0.setColor(Color.rgb((int)255, (int)255, (int)255, (double)0.5));
        this.mainInnerShadow0.setBlurType(BlurType.TWO_PASS_BOX);
        this.mainInnerShadow1 = new InnerShadow();
        this.mainInnerShadow1.setOffsetX(0.0);
        this.mainInnerShadow1.setOffsetY(1.0);
        this.mainInnerShadow1.setRadius(3.3333333333333335);
        this.mainInnerShadow1.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.65));
        this.mainInnerShadow1.setBlurType(BlurType.TWO_PASS_BOX);
        this.mainInnerShadow1.setInput((Effect)this.mainInnerShadow0);
        this.crystalClip = new Rectangle(0.0, 0.0, 220.0, 100.0);
        this.crystalClip.setArcWidth(5.0);
        this.crystalClip.setArcHeight(5.0);
        this.crystalImage = Helper.createNoiseImage(220.0, 100.0, DARK_NOISE_COLOR, BRIGHT_NOISE_COLOR, 8.0);
        this.crystalOverlay = new ImageView(this.crystalImage);
        this.crystalOverlay.setClip((Node)this.crystalClip);
        boolean crystalEnabled = ((Clock)this.getSkinnable()).isLcdCrystalEnabled();
        this.crystalOverlay.setManaged(crystalEnabled);
        this.crystalOverlay.setVisible(crystalEnabled);
        boolean secondsVisible = ((Clock)this.getSkinnable()).isSecondsVisible();
        this.backgroundTimeText = new Text("");
        this.backgroundTimeText.setFill((Paint)((Clock)this.getSkinnable()).getLcdDesign().lcdBackgroundColor);
        this.backgroundTimeText.setOpacity(LcdFont.LCD == ((Clock)this.getSkinnable()).getLcdFont() || LcdFont.ELEKTRA == ((Clock)this.getSkinnable()).getLcdFont() ? 1.0 : 0.0);
        this.backgroundSecondText = new Text("");
        this.backgroundSecondText.setFill((Paint)((Clock)this.getSkinnable()).getLcdDesign().lcdBackgroundColor);
        this.backgroundSecondText.setOpacity(LcdFont.LCD == ((Clock)this.getSkinnable()).getLcdFont() || LcdFont.ELEKTRA == ((Clock)this.getSkinnable()).getLcdFont() ? 1.0 : 0.0);
        this.backgroundSecondText.setManaged(secondsVisible);
        this.backgroundSecondText.setVisible(secondsVisible);
        this.timeText = new Text("");
        this.timeText.setFill((Paint)((Clock)this.getSkinnable()).getLcdDesign().lcdForegroundColor);
        this.secondText = new Text("");
        this.secondText.setFill((Paint)((Clock)this.getSkinnable()).getLcdDesign().lcdForegroundColor);
        this.secondText.setManaged(secondsVisible);
        this.secondText.setVisible(secondsVisible);
        this.title = new Text(((Clock)this.getSkinnable()).getTitle());
        this.title.setFill((Paint)((Clock)this.getSkinnable()).getLcdDesign().lcdForegroundColor);
        boolean titleVisible = ((Clock)this.getSkinnable()).isTitleVisible();
        this.title.setManaged(titleVisible);
        this.title.setVisible(titleVisible);
        this.dateText = new Text(this.dateFormat.format(((Clock)this.getSkinnable()).getTime()));
        this.dateText.setFill((Paint)((Clock)this.getSkinnable()).getLcdDesign().lcdForegroundColor);
        boolean dateVisible = ((Clock)this.getSkinnable()).isDateVisible();
        this.dateText.setManaged(dateVisible);
        this.dateText.setVisible(dateVisible);
        this.dayOfWeekText = new Text("");
        this.dayOfWeekText.setFill((Paint)((Clock)this.getSkinnable()).getLcdDesign().lcdForegroundColor);
        this.dayOfWeekText.setManaged(dateVisible);
        this.dayOfWeekText.setVisible(dateVisible);
        this.alarm = new Path();
        this.alarm.setFillRule(FillRule.EVEN_ODD);
        this.alarm.setStroke(null);
        boolean alarmVisible = ((Clock)this.getSkinnable()).getAlarms().size() > 0;
        this.alarm.setManaged(alarmVisible);
        this.alarm.setVisible(alarmVisible);
        this.shadowGroup = new Group();
        this.shadowGroup.setEffect((Effect)(((Clock)this.getSkinnable()).getShadowsEnabled() ? FOREGROUND_SHADOW : null));
        this.shadowGroup.getChildren().setAll((Object[])new Node[]{this.timeText, this.secondText, this.title, this.dateText, this.dayOfWeekText, this.alarm});
        this.pane = new Pane();
        this.pane.setEffect((Effect)(((Clock)this.getSkinnable()).getShadowsEnabled() ? this.mainInnerShadow1 : null));
        this.pane.getChildren().setAll((Object[])new Node[]{this.crystalOverlay, this.backgroundTimeText, this.backgroundSecondText, this.shadowGroup});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((Clock)this.getSkinnable()).widthProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Clock)this.getSkinnable()).heightProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Clock)this.getSkinnable()).setOnUpdate(e -> this.handleEvents(e.eventType.name()));
        ((Clock)this.getSkinnable()).timeProperty().addListener(e -> this.updateLcd(((Clock)this.getSkinnable()).getTime()));
    }

    protected double computeMinWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 5.0;
    }

    protected double computeMinHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 5.0;
    }

    protected double computePrefWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return super.computePrefWidth(HEIGHT, TOP, RIGHT, BOTTOM, LEFT);
    }

    protected double computePrefHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return super.computePrefHeight(WIDTH, TOP, RIGHT, BOTTOM, LEFT);
    }

    protected double computeMaxWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 1024.0;
    }

    protected double computeMaxHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 1024.0;
    }

    protected void handleEvents(String EVENT_TYPE) {
        if ("REDRAW".equals(EVENT_TYPE)) {
            this.pane.setEffect((Effect)(((Clock)this.getSkinnable()).getShadowsEnabled() ? this.mainInnerShadow1 : null));
            this.shadowGroup.setEffect((Effect)(((Clock)this.getSkinnable()).getShadowsEnabled() ? FOREGROUND_SHADOW : null));
            this.updateLcdDesign(this.height);
            this.redraw();
        } else if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
            this.redraw();
        } else if ("LCD".equals(EVENT_TYPE)) {
            this.updateLcdDesign(this.height);
        } else if ("VISIBILITY".equals(EVENT_TYPE)) {
            boolean crystalEnable = ((Clock)this.getSkinnable()).isLcdCrystalEnabled();
            this.crystalOverlay.setManaged(crystalEnable);
            this.crystalOverlay.setVisible(crystalEnable);
            boolean secondsVisible = ((Clock)this.getSkinnable()).isSecondsVisible();
            this.backgroundSecondText.setManaged(secondsVisible);
            this.backgroundSecondText.setVisible(secondsVisible);
            this.secondText.setManaged(secondsVisible);
            this.secondText.setVisible(secondsVisible);
            boolean dateVisible = ((Clock)this.getSkinnable()).isDateVisible();
            this.dateText.setManaged(dateVisible);
            this.dateText.setVisible(dateVisible);
            this.dayOfWeekText.setManaged(dateVisible);
            this.dayOfWeekText.setVisible(dateVisible);
            boolean titleVisible = ((Clock)this.getSkinnable()).isTitleVisible();
            this.title.setManaged(titleVisible);
            this.title.setVisible(titleVisible);
            boolean alarmVisible = ((Clock)this.getSkinnable()).getAlarms().size() > 0;
            this.alarm.setManaged(alarmVisible);
            this.alarm.setVisible(alarmVisible);
            this.resize();
            this.redraw();
        } else if ("RECALC".equals(EVENT_TYPE)) {
            this.adjustDateFormat();
            this.redraw();
        }
    }

    private String ensureTwoDigits(int NUMBER) {
        if (NUMBER < 10) {
            return "0" + NUMBER;
        }
        return Integer.toString(NUMBER);
    }

    private void updateLcdDesign(double HEIGHT) {
        LcdDesign lcdDesign = ((Clock)this.getSkinnable()).getLcdDesign();
        Color[] lcdColors = lcdDesign.getColors();
        this.lcdPaint = new LinearGradient(0.0, 1.0, 0.0, HEIGHT - 1.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, lcdColors[0]), new Stop(0.03, lcdColors[1]), new Stop(0.5, lcdColors[2]), new Stop(0.5, lcdColors[3]), new Stop(1.0, lcdColors[4])});
        if (lcdDesign.name().startsWith("FLAT")) {
            this.lcdFramePaint = ((Clock)this.getSkinnable()).getBorderPaint();
            this.lcdPaint = ((Clock)this.getSkinnable()).getBackgroundPaint();
            Color lcdForegroundColor = (Color)((Clock)this.getSkinnable()).getForegroundPaint();
            this.backgroundTimeText.setFill((Paint)Color.color((double)lcdForegroundColor.getRed(), (double)lcdForegroundColor.getGreen(), (double)lcdForegroundColor.getBlue(), (double)0.1));
            this.backgroundSecondText.setFill((Paint)Color.color((double)lcdForegroundColor.getRed(), (double)lcdForegroundColor.getGreen(), (double)lcdForegroundColor.getBlue(), (double)0.1));
            this.timeText.setFill((Paint)lcdForegroundColor);
            this.secondText.setFill((Paint)lcdForegroundColor);
            this.title.setFill((Paint)lcdForegroundColor);
            this.dateText.setFill((Paint)lcdForegroundColor);
            this.dayOfWeekText.setFill((Paint)lcdForegroundColor);
            this.alarm.setFill((Paint)lcdForegroundColor);
        } else {
            this.lcdFramePaint = new LinearGradient(0.0, 0.02083333 * this.height, 0.0, HEIGHT - 0.02083333 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)26, (int)26, (int)26)), new Stop(0.015, Color.rgb((int)77, (int)77, (int)77)), new Stop(0.985, Color.rgb((int)77, (int)77, (int)77)), new Stop(1.0, Color.rgb((int)221, (int)221, (int)221))});
            this.lcdPaint = new LinearGradient(0.0, 1.0, 0.0, HEIGHT - 1.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, lcdColors[0]), new Stop(0.03, lcdColors[1]), new Stop(0.5, lcdColors[2]), new Stop(0.5, lcdColors[3]), new Stop(1.0, lcdColors[4])});
            this.backgroundTimeText.setFill((Paint)lcdDesign.lcdBackgroundColor);
            this.backgroundSecondText.setFill((Paint)lcdDesign.lcdBackgroundColor);
            this.timeText.setFill((Paint)lcdDesign.lcdForegroundColor);
            this.secondText.setFill((Paint)lcdDesign.lcdForegroundColor);
            this.title.setFill((Paint)lcdDesign.lcdForegroundColor);
            this.dateText.setFill((Paint)lcdDesign.lcdForegroundColor);
            this.dayOfWeekText.setFill((Paint)lcdDesign.lcdForegroundColor);
            this.alarm.setFill((Paint)lcdDesign.lcdForegroundColor);
        }
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.lcdPaint, new CornerRadii(0.10416667 * HEIGHT), Insets.EMPTY)}));
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.lcdFramePaint, BorderStrokeStyle.SOLID, new CornerRadii(0.05 * HEIGHT), new BorderWidths(0.02083333 * HEIGHT))}));
    }

    private void adjustDateFormat() {
        Locale locale = ((Clock)this.getSkinnable()).getLocale();
        this.dateFormat = Locale.US == locale ? DateTimeFormatter.ofPattern("MM/dd/YYYY") : (Locale.CHINA == locale ? DateTimeFormatter.ofPattern("YYYY.MM.dd") : DateTimeFormatter.ofPattern("dd.MM.YYYY"));
    }

    private void updateFonts() {
        this.digitalFontSizeFactor = 1.0;
        switch (((Clock)this.getSkinnable()).getLcdFont()) {
            case LCD: {
                this.digitalFontSizeFactor = 1.05;
                this.timeFont = Fonts.digital(0.675 * this.height);
                this.secondFont = Fonts.digital(0.2 * this.height);
                break;
            }
            case DIGITAL: {
                this.digitalFontSizeFactor = 0.7;
                this.timeFont = Fonts.digitalReadout(0.7 * this.height);
                this.secondFont = Fonts.digitalReadout(0.2 * this.height);
                break;
            }
            case DIGITAL_BOLD: {
                this.digitalFontSizeFactor = 0.7;
                this.timeFont = Fonts.digitalReadoutBold(0.7 * this.height);
                this.secondFont = Fonts.digitalReadoutBold(0.2 * this.height);
                break;
            }
            case ELEKTRA: {
                this.digitalFontSizeFactor = 0.8;
                this.timeFont = Fonts.elektra(0.7 * this.height);
                this.secondFont = Fonts.elektra(0.186 * this.height);
                break;
            }
            default: {
                this.digitalFontSizeFactor = 0.7;
                this.timeFont = Fonts.robotoMedium(0.6 * this.height);
                this.secondFont = Fonts.robotoMedium(0.2 * this.height);
            }
        }
        this.backgroundTimeText.setFont(this.timeFont);
        this.backgroundTimeText.setOpacity(LcdFont.LCD == ((Clock)this.getSkinnable()).getLcdFont() || LcdFont.DIGITAL == ((Clock)this.getSkinnable()).getLcdFont() || LcdFont.DIGITAL_BOLD == ((Clock)this.getSkinnable()).getLcdFont() || LcdFont.ELEKTRA == ((Clock)this.getSkinnable()).getLcdFont() ? 1.0 : 0.0);
        this.backgroundSecondText.setFont(this.secondFont);
        this.backgroundSecondText.setOpacity(LcdFont.LCD == ((Clock)this.getSkinnable()).getLcdFont() || LcdFont.DIGITAL == ((Clock)this.getSkinnable()).getLcdFont() || LcdFont.DIGITAL_BOLD == ((Clock)this.getSkinnable()).getLcdFont() || LcdFont.ELEKTRA == ((Clock)this.getSkinnable()).getLcdFont() ? 1.0 : 0.0);
        this.timeText.setFont(this.timeFont);
        this.titleFont = Fonts.latoBold(0.16 * this.height);
        this.smallFont = Fonts.latoBold(0.12 * this.height);
    }

    private void updateBackgroundText() {
        this.backgroundTimeText.setTextOrigin(VPos.BASELINE);
        this.backgroundTimeText.setTextAlignment(TextAlignment.RIGHT);
        this.backgroundSecondText.setTextOrigin(VPos.BASELINE);
        this.backgroundSecondText.setTextAlignment(TextAlignment.RIGHT);
        String backgroundSegment = "_";
        switch (((Clock)this.getSkinnable()).getLcdFont()) {
            case LCD: {
                backgroundSegment = "8";
                break;
            }
            case DIGITAL: 
            case DIGITAL_BOLD: 
            case ELEKTRA: {
                backgroundSegment = "_";
            }
        }
        this.backgroundTextBuilder.setLength(0);
        this.backgroundTextBuilder.append(backgroundSegment);
        this.backgroundTextBuilder.append(backgroundSegment);
        this.backgroundTextBuilder.append(":");
        this.backgroundTextBuilder.append(backgroundSegment);
        this.backgroundTextBuilder.append(backgroundSegment);
        this.backgroundTimeText.setText(this.backgroundTextBuilder.toString());
        this.backgroundSecondText.setText(backgroundSegment + backgroundSegment);
    }

    private void updateLcd(ZonedDateTime TIME) {
        this.timeText.setText(this.ensureTwoDigits(TIME.getHour()) + ":" + this.ensureTwoDigits(TIME.getMinute()));
        this.secondText.setText(this.ensureTwoDigits(TIME.getSecond()));
        this.updateBackgroundText();
        this.backgroundTimeText.setX(this.width - 2.0 - this.backgroundTimeText.getLayoutBounds().getWidth() - this.valueOffsetRight);
        this.backgroundTimeText.setY(this.height - this.backgroundTimeText.getLayoutBounds().getHeight() * this.digitalFontSizeFactor * 0.5);
        this.timeText.setX(this.width - 2.0 - this.timeText.getLayoutBounds().getWidth() - this.valueOffsetRight);
        this.title.setText(((Clock)this.getSkinnable()).getTitle());
        this.title.setX((this.width - this.title.getLayoutBounds().getWidth()) * 0.5);
        this.dayOfWeekText.setText(TIME.getDayOfWeek().getDisplayName(TextStyle.FULL_STANDALONE, ((Clock)this.getSkinnable()).getLocale()));
        this.dayOfWeekText.setX(0.0416666667 * this.height);
        this.dateText.setText(this.dateFormat.format(TIME));
        this.dateText.setX(this.width - this.dateText.getLayoutBounds().getWidth() - 0.0416666667 * this.height);
        this.dateText.setY(this.pane.getLayoutBounds().getMinY() + this.height - 3.0 - 0.0416666667 * this.height);
    }

    private void createAlarmIcon(boolean ENABLED) {
        double iconSize = 0.16 * this.height;
        this.alarm.getElements().clear();
        if (ENABLED) {
            this.alarm.getElements().add((Object)new MoveTo(0.65625 * iconSize, 0.875 * iconSize));
            this.alarm.getElements().add((Object)new CubicCurveTo(0.6328125 * iconSize, 0.9453125 * iconSize, 0.5703125 * iconSize, iconSize, 0.5 * iconSize, iconSize));
            this.alarm.getElements().add((Object)new CubicCurveTo(0.4296875 * iconSize, iconSize, 0.3671875 * iconSize, 0.9453125 * iconSize, 0.34375 * iconSize, 0.875 * iconSize));
            this.alarm.getElements().add((Object)new CubicCurveTo(0.34375 * iconSize, 0.875 * iconSize, 0.65625 * iconSize, 0.875 * iconSize, 0.65625 * iconSize, 0.875 * iconSize));
            this.alarm.getElements().add((Object)new ClosePath());
            this.alarm.getElements().add((Object)new MoveTo(0.9921875 * iconSize, 0.7578125 * iconSize));
            this.alarm.getElements().add((Object)new CubicCurveTo(0.65625 * iconSize, 0.53125 * iconSize, 0.90625 * iconSize, 0.0, 0.5 * iconSize, 0.0));
            this.alarm.getElements().add((Object)new CubicCurveTo(0.5 * iconSize, 0.0, 0.5 * iconSize, 0.0, 0.5 * iconSize, 0.0));
            this.alarm.getElements().add((Object)new CubicCurveTo(0.5 * iconSize, 0.0, 0.5 * iconSize, 0.0, 0.5 * iconSize, 0.0));
            this.alarm.getElements().add((Object)new CubicCurveTo(0.09375 * iconSize, 0.0, 0.34375 * iconSize, 0.53125 * iconSize, 0.0078125 * iconSize, 0.7578125 * iconSize));
            this.alarm.getElements().add((Object)new CubicCurveTo(0.0, 0.765625 * iconSize, 0.0, 0.7734375 * iconSize, 0.0, 0.78125 * iconSize));
            this.alarm.getElements().add((Object)new CubicCurveTo(0.0, 0.78125 * iconSize, 0.0, 0.7890625 * iconSize, 0.0, 0.7890625 * iconSize));
            this.alarm.getElements().add((Object)new CubicCurveTo(0.0078125 * iconSize, 0.8046875 * iconSize, 0.015625 * iconSize, 0.8125 * iconSize, 0.03125 * iconSize, 0.8125 * iconSize));
            this.alarm.getElements().add((Object)new CubicCurveTo(0.03125 * iconSize, 0.8125 * iconSize, 0.5 * iconSize, 0.8125 * iconSize, 0.5 * iconSize, 0.8125 * iconSize));
            this.alarm.getElements().add((Object)new CubicCurveTo(0.5 * iconSize, 0.8125 * iconSize, 0.96875 * iconSize, 0.8125 * iconSize, 0.96875 * iconSize, 0.8125 * iconSize));
            this.alarm.getElements().add((Object)new CubicCurveTo(0.984375 * iconSize, 0.8125 * iconSize, 0.9921875 * iconSize, 0.8046875 * iconSize, iconSize, 0.7890625 * iconSize));
            this.alarm.getElements().add((Object)new CubicCurveTo(iconSize, 0.7890625 * iconSize, iconSize, 0.78125 * iconSize, iconSize, 0.78125 * iconSize));
            this.alarm.getElements().add((Object)new CubicCurveTo(iconSize, 0.7734375 * iconSize, iconSize, 0.765625 * iconSize, 0.9921875 * iconSize, 0.7578125 * iconSize));
            this.alarm.getElements().add((Object)new ClosePath());
        } else {
            this.alarm.getElements().add((Object)new MoveTo(0.0703125 * iconSize, 0.015625 * iconSize));
            this.alarm.getElements().add((Object)new LineTo(0.015625 * iconSize, 0.0703125 * iconSize));
            this.alarm.getElements().add((Object)new LineTo(0.9296875 * iconSize, 0.984375 * iconSize));
            this.alarm.getElements().add((Object)new LineTo(0.984375 * iconSize, 0.9296875 * iconSize));
            this.alarm.getElements().add((Object)new LineTo(0.0703125 * iconSize, 0.015625 * iconSize));
            this.alarm.getElements().add((Object)new ClosePath());
            this.alarm.getElements().add((Object)new MoveTo(0.65625 * iconSize, 0.875 * iconSize));
            this.alarm.getElements().add((Object)new CubicCurveTo(0.65625 * iconSize, 0.875 * iconSize, 0.34375 * iconSize, 0.875 * iconSize, 0.34375 * iconSize, 0.875 * iconSize));
            this.alarm.getElements().add((Object)new CubicCurveTo(0.3671875 * iconSize, 0.9453125 * iconSize, 0.4296875 * iconSize, iconSize, 0.5 * iconSize, iconSize));
            this.alarm.getElements().add((Object)new CubicCurveTo(0.5703125 * iconSize, iconSize, 0.6328125 * iconSize, 0.9453125 * iconSize, 0.65625 * iconSize, 0.875 * iconSize));
            this.alarm.getElements().add((Object)new ClosePath());
            this.alarm.getElements().add((Object)new MoveTo(0.2265625 * iconSize, 0.3125 * iconSize));
            this.alarm.getElements().add((Object)new CubicCurveTo(0.1953125 * iconSize, 0.46875 * iconSize, 0.171875 * iconSize, 0.6484375 * iconSize, 0.0078125 * iconSize, 0.7578125 * iconSize));
            this.alarm.getElements().add((Object)new CubicCurveTo(0.0, 0.765625 * iconSize, 0.0, 0.7734375 * iconSize, 0.0, 0.78125 * iconSize));
            this.alarm.getElements().add((Object)new CubicCurveTo(0.0, 0.78125 * iconSize, 0.0, 0.7890625 * iconSize, 0.0, 0.7890625 * iconSize));
            this.alarm.getElements().add((Object)new CubicCurveTo(0.0078125 * iconSize, 0.8046875 * iconSize, 0.015625 * iconSize, 0.8125 * iconSize, 0.03125 * iconSize, 0.8125 * iconSize));
            this.alarm.getElements().add((Object)new CubicCurveTo(0.03125 * iconSize, 0.8125 * iconSize, 0.5 * iconSize, 0.8125 * iconSize, 0.5 * iconSize, 0.8125 * iconSize));
            this.alarm.getElements().add((Object)new LineTo(0.7265625 * iconSize, 0.8125 * iconSize));
            this.alarm.getElements().add((Object)new CubicCurveTo(0.7265625 * iconSize, 0.8125 * iconSize, 0.2265625 * iconSize, 0.3125 * iconSize, 0.2265625 * iconSize, 0.3125 * iconSize));
            this.alarm.getElements().add((Object)new ClosePath());
            this.alarm.getElements().add((Object)new MoveTo(0.9921875 * iconSize, 0.7578125 * iconSize));
            this.alarm.getElements().add((Object)new CubicCurveTo(0.65625 * iconSize, 0.53125 * iconSize, 0.90625 * iconSize, 0.0, 0.5 * iconSize, 0.0));
            this.alarm.getElements().add((Object)new CubicCurveTo(0.3515625 * iconSize, 0.0, 0.2890625 * iconSize, 0.0703125 * iconSize, 0.2578125 * iconSize, 0.171875 * iconSize));
            this.alarm.getElements().add((Object)new CubicCurveTo(0.2578125 * iconSize, 0.171875 * iconSize, 0.8984375 * iconSize, 0.8125 * iconSize, 0.8984375 * iconSize, 0.8125 * iconSize));
            this.alarm.getElements().add((Object)new CubicCurveTo(0.8984375 * iconSize, 0.8125 * iconSize, 0.96875 * iconSize, 0.8125 * iconSize, 0.96875 * iconSize, 0.8125 * iconSize));
            this.alarm.getElements().add((Object)new CubicCurveTo(0.984375 * iconSize, 0.8125 * iconSize, 0.9921875 * iconSize, 0.8046875 * iconSize, iconSize, 0.7890625 * iconSize));
            this.alarm.getElements().add((Object)new CubicCurveTo(iconSize, 0.7890625 * iconSize, iconSize, 0.78125 * iconSize, iconSize, 0.78125 * iconSize));
            this.alarm.getElements().add((Object)new CubicCurveTo(iconSize, 0.7734375 * iconSize, iconSize, 0.765625 * iconSize, 0.9921875 * iconSize, 0.7578125 * iconSize));
            this.alarm.getElements().add((Object)new ClosePath());
        }
    }

    private void resize() {
        this.width = ((Clock)this.getSkinnable()).getWidth() - ((Clock)this.getSkinnable()).getInsets().getLeft() - ((Clock)this.getSkinnable()).getInsets().getRight();
        this.height = ((Clock)this.getSkinnable()).getHeight() - ((Clock)this.getSkinnable()).getInsets().getTop() - ((Clock)this.getSkinnable()).getInsets().getBottom();
        if (0.52631579 * this.width > this.height) {
            this.width = 1.0 / (0.52631579 / this.height);
        } else if (1.0 / (0.52631579 / this.height) > this.width) {
            this.height = 0.52631579 * this.width;
        }
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.relocate((((Clock)this.getSkinnable()).getWidth() - this.width) * 0.5, (((Clock)this.getSkinnable()).getHeight() - this.height) * 0.5);
            this.updateLcdDesign(this.height);
            this.mainInnerShadow0.setRadius(0.0625 * this.height);
            this.mainInnerShadow1.setRadius(0.04166667 * this.height);
            ZonedDateTime time = ((Clock)this.getSkinnable()).getTime();
            if (this.crystalOverlay.isVisible()) {
                this.crystalClip.setWidth(this.width);
                this.crystalClip.setHeight(this.height);
                this.crystalOverlay.setImage(Helper.createNoiseImage(this.width, this.height, DARK_NOISE_COLOR, BRIGHT_NOISE_COLOR, 8.0));
                this.crystalOverlay.setCache(true);
            }
            this.updateFonts();
            this.updateBackgroundText();
            this.backgroundTimeText.setX(this.width - 2.0 - this.backgroundTimeText.getLayoutBounds().getWidth() - this.valueOffsetRight);
            this.backgroundTimeText.setY(this.height - this.backgroundTimeText.getLayoutBounds().getHeight() * this.digitalFontSizeFactor * 0.5);
            this.backgroundSecondText.setX(this.width - 3.0 - this.secondText.getLayoutBounds().getWidth() - this.height * 0.04);
            this.backgroundSecondText.setY(this.height - this.timeText.getLayoutBounds().getHeight() * this.digitalFontSizeFactor * 0.5);
            this.secondText.setFont(this.secondFont);
            this.secondText.setTextOrigin(VPos.BASELINE);
            this.secondText.setTextAlignment(TextAlignment.RIGHT);
            this.secondText.setX(this.width - 3.0 - this.secondText.getLayoutBounds().getWidth() - this.height * 0.04);
            this.secondText.setY(this.height - this.timeText.getLayoutBounds().getHeight() * this.digitalFontSizeFactor * 0.5);
            this.valueOffsetRight = this.secondText.getLayoutBounds().getWidth() + this.height * 0.0833333333;
            this.timeText.setX(this.width - 2.0 - this.timeText.getLayoutBounds().getWidth() - this.valueOffsetRight);
            this.timeText.setY(this.height - this.timeText.getLayoutBounds().getHeight() * this.digitalFontSizeFactor * 0.5);
            this.title.setFont(this.titleFont);
            this.title.setTextOrigin(VPos.BASELINE);
            this.title.setTextAlignment(TextAlignment.CENTER);
            this.title.setText(time.getDayOfWeek().name());
            this.title.setX((this.width - this.title.getLayoutBounds().getWidth()) * 0.5);
            this.title.setY(this.pane.getLayoutBounds().getMinY() + this.title.getLayoutBounds().getHeight() - 0.04 * this.height + 2.0);
            this.dateText.setFont(this.smallFont);
            this.dateText.setTextOrigin(VPos.BASELINE);
            this.dateText.setTextAlignment(TextAlignment.RIGHT);
            this.dateText.setText(this.dateFormat.format(time));
            this.dateText.setX(this.width - this.dateText.getLayoutBounds().getWidth() - 0.0416666667 * this.height);
            this.dateText.setY(this.pane.getLayoutBounds().getMinY() + this.height - 3.0 - 0.0416666667 * this.height);
            this.dayOfWeekText.setFont(this.smallFont);
            this.dayOfWeekText.setTextOrigin(VPos.BASELINE);
            this.dayOfWeekText.setTextAlignment(TextAlignment.LEFT);
            this.dayOfWeekText.setX(0.0416666667 * this.height);
            this.dayOfWeekText.setY(this.pane.getLayoutBounds().getMinY() + this.height - 3.0 - 0.0416666667 * this.height);
        }
    }

    private void redraw() {
        this.updateBackgroundText();
        this.backgroundTimeText.setX(this.width - 2.0 - this.backgroundTimeText.getLayoutBounds().getWidth() - this.valueOffsetRight);
        this.backgroundTimeText.setY(this.height - this.backgroundTimeText.getLayoutBounds().getHeight() * this.digitalFontSizeFactor * 0.5);
        this.backgroundSecondText.setX(this.width - 3.0 - this.secondText.getLayoutBounds().getWidth() - this.height * 0.04);
        this.backgroundSecondText.setY(this.height - this.timeText.getLayoutBounds().getHeight() * this.digitalFontSizeFactor * 0.5);
        ZonedDateTime time = ((Clock)this.getSkinnable()).getTime();
        this.timeText.setText(this.ensureTwoDigits(time.getHour()) + ":" + this.ensureTwoDigits(time.getMinute()));
        this.timeText.setX(this.width - 2.0 - this.timeText.getLayoutBounds().getWidth() - this.valueOffsetRight);
        this.secondText.setText(this.ensureTwoDigits(time.getSecond()));
        this.secondText.setX(this.width - 3.0 - this.secondText.getLayoutBounds().getWidth() - this.height * 0.04);
        this.title.setText(((Clock)this.getSkinnable()).getTitle());
        this.title.setX((this.width - this.title.getLayoutBounds().getWidth()) * 0.5);
        this.dateText.setText(this.dateFormat.format(time));
        this.dateText.setX(this.width - this.dateText.getLayoutBounds().getWidth() - 0.0416666667 * this.height);
        this.dateText.setY(this.pane.getLayoutBounds().getMinY() + this.height - 3.0 - 0.0416666667 * this.height);
        this.dayOfWeekText.setText(time.getDayOfWeek().getDisplayName(TextStyle.FULL_STANDALONE, ((Clock)this.getSkinnable()).getLocale()));
        this.dayOfWeekText.setX(0.0416666667 * this.height);
        this.dayOfWeekText.setY(this.pane.getLayoutBounds().getMinY() + this.height - 3.0 - 0.0416666667 * this.height);
        this.createAlarmIcon(((Clock)this.getSkinnable()).isAlarmsEnabled());
        this.alarm.relocate(this.width * 0.885, this.height * 0.28);
    }
}

