/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.tools.Helper;
import java.util.List;
import java.util.Locale;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;

public class TileTextKpiSkin
extends SkinBase<Gauge>
implements Skin<Gauge> {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double size;
    private Region barBackground;
    private Rectangle barClip;
    private Rectangle bar;
    private Text titleText;
    private Text valueText;
    private Text unitText;
    private Text percentageText;
    private Text percentageUnitText;
    private Rectangle maxValueRect;
    private Text maxValueText;
    private Pane pane;
    private double minValue;
    private double range;
    private double stepSize;
    private String formatString;
    private Locale locale;
    private List<Section> sections;
    private boolean sectionsVisible;
    private Color barColor;

    public TileTextKpiSkin(Gauge gauge) {
        super((Control)gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.minValue = gauge.getMinValue();
        this.range = gauge.getRange();
        this.stepSize = 250.0 / this.range;
        this.formatString = "%." + Integer.toString(gauge.getDecimals()) + "f";
        this.locale = gauge.getLocale();
        this.sections = gauge.getSections();
        this.sectionsVisible = gauge.getSectionsVisible();
        this.barColor = gauge.getBarColor();
        this.initGraphics();
        this.registerListeners();
        this.setBar(gauge.getCurrentValue());
    }

    private void initGraphics() {
        if (Double.compare(((Gauge)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((Gauge)this.getSkinnable()).getPrefWidth() > 0.0 && ((Gauge)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((Gauge)this.getSkinnable()).setPrefSize(((Gauge)this.getSkinnable()).getPrefWidth(), ((Gauge)this.getSkinnable()).getPrefHeight());
            } else {
                ((Gauge)this.getSkinnable()).setPrefSize(250.0, 250.0);
            }
        }
        this.barBackground = new Region();
        this.barBackground.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)((Gauge)this.getSkinnable()).getBarBackgroundColor(), new CornerRadii(0.0, 0.0, 0.025, 0.025, true), Insets.EMPTY)}));
        this.barClip = new Rectangle();
        this.bar = new Rectangle();
        this.bar.setFill((Paint)((Gauge)this.getSkinnable()).getBarColor());
        this.bar.setStroke(null);
        this.bar.setClip((Node)this.barClip);
        this.titleText = new Text();
        this.titleText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        Helper.enableNode((Node)this.titleText, !((Gauge)this.getSkinnable()).getTitle().isEmpty());
        this.valueText = new Text();
        this.valueText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        Helper.enableNode((Node)this.valueText, ((Gauge)this.getSkinnable()).isValueVisible());
        this.unitText = new Text(((Gauge)this.getSkinnable()).getUnit());
        this.unitText.setFill((Paint)((Gauge)this.getSkinnable()).getUnitColor());
        Helper.enableNode((Node)this.unitText, !((Gauge)this.getSkinnable()).getUnit().isEmpty());
        this.percentageText = new Text();
        this.percentageText.setFill((Paint)((Gauge)this.getSkinnable()).getBarColor());
        this.percentageUnitText = new Text("%");
        this.percentageUnitText.setFill((Paint)((Gauge)this.getSkinnable()).getBarColor());
        this.maxValueRect = new Rectangle();
        this.maxValueRect.setFill((Paint)((Gauge)this.getSkinnable()).getThresholdColor());
        this.maxValueText = new Text();
        this.maxValueText.setFill(((Gauge)this.getSkinnable()).getBackgroundPaint());
        this.pane = new Pane(new Node[]{this.barBackground, this.bar, this.titleText, this.valueText, this.unitText, this.percentageText, this.percentageUnitText, this.maxValueRect, this.maxValueText});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Gauge)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(((Gauge)this.getSkinnable()).getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((Gauge)this.getSkinnable()).widthProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).heightProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).setOnUpdate(e -> this.handleEvents(e.eventType.name()));
        ((Gauge)this.getSkinnable()).currentValueProperty().addListener(o -> this.setBar(((Gauge)this.getSkinnable()).getCurrentValue()));
    }

    protected double computeMinWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return super.computePrefWidth(HEIGHT, TOP, RIGHT, BOTTOM, LEFT);
    }

    protected double computePrefHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return super.computePrefHeight(WIDTH, TOP, RIGHT, BOTTOM, LEFT);
    }

    protected double computeMaxWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 1024.0;
    }

    protected double computeMaxHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 1024.0;
    }

    private void handleEvents(String EVENT_TYPE) {
        if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
            this.redraw();
        } else if ("REDRAW".equals(EVENT_TYPE)) {
            this.redraw();
        } else if ("RECALC".equals(EVENT_TYPE)) {
            this.minValue = ((Gauge)this.getSkinnable()).getMinValue();
            this.range = ((Gauge)this.getSkinnable()).getRange();
            this.stepSize = this.size / this.range;
            this.redraw();
        } else if ("VISIBLITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !((Gauge)this.getSkinnable()).getTitle().isEmpty());
            Helper.enableNode((Node)this.valueText, ((Gauge)this.getSkinnable()).isValueVisible());
            Helper.enableNode((Node)this.unitText, !((Gauge)this.getSkinnable()).getUnit().isEmpty());
        } else if ("SECTION".equals(EVENT_TYPE)) {
            this.sections = ((Gauge)this.getSkinnable()).getSections();
        }
    }

    private void setBar(double VALUE) {
        double targetValue = (VALUE - this.minValue) * this.stepSize;
        this.bar.setWidth(targetValue);
        this.valueText.setText(String.format(this.locale, this.formatString, VALUE));
        this.percentageText.setText(String.format(this.locale, this.formatString, (VALUE - this.minValue) / this.range * 100.0));
        this.resizeDynamicText();
        if (this.sectionsVisible && !this.sections.isEmpty()) {
            this.setBarColor(VALUE);
        }
    }

    private void setBarColor(double VALUE) {
        Color color = this.barColor;
        for (Section section : this.sections) {
            if (!section.contains(VALUE)) continue;
            color = section.getColor();
            break;
        }
        this.bar.setFill((Paint)color);
        this.percentageText.setFill((Paint)color);
        this.percentageUnitText.setFill((Paint)color);
    }

    private void resizeDynamicText() {
        double maxWidth = this.unitText.isVisible() ? this.size * 0.725 : this.size * 0.9;
        double fontSize = 0.24 * this.size;
        this.valueText.setFont(Fonts.latoRegular(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
        if (this.unitText.isVisible()) {
            this.valueText.relocate(this.size * 0.925 - this.valueText.getLayoutBounds().getWidth() - this.unitText.getLayoutBounds().getWidth(), this.size * 0.15);
        } else {
            this.valueText.relocate(this.size * 0.95 - this.valueText.getLayoutBounds().getWidth(), this.size * 0.15);
        }
        this.percentageUnitText.relocate(this.percentageText.getLayoutBounds().getMaxX() + this.size * 0.075, this.size * 0.765);
    }

    private void resizeStaticText() {
        double maxWidth = this.size * 0.9;
        double fontSize = this.size * 0.06;
        this.titleText.setFont(Fonts.latoRegular(fontSize));
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        this.titleText.relocate(this.size * 0.05, this.size * 0.05);
        maxWidth = this.size * 0.15;
        this.unitText.setFont(Fonts.latoRegular(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        this.unitText.relocate(this.size * 0.95 - this.unitText.getLayoutBounds().getWidth(), this.size * 0.3275);
        maxWidth = this.size * 0.45;
        fontSize = this.size * 0.18;
        this.percentageText.setFont(Fonts.latoRegular(fontSize));
        if (this.percentageText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.percentageText, maxWidth, fontSize);
        }
        this.percentageText.relocate(this.size * 0.05, this.size * 0.705);
        maxWidth = this.size * 0.1;
        fontSize = this.size * 0.12;
        this.percentageUnitText.setFont(Fonts.latoRegular(fontSize));
        if (this.percentageUnitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.percentageUnitText, maxWidth, fontSize);
        }
        this.percentageUnitText.relocate(this.percentageText.getLayoutBounds().getMaxX() + this.size * 0.075, this.size * 0.765);
        maxWidth = this.size * 0.45;
        fontSize = this.size * 0.09;
        this.maxValueText.setFont(Fonts.latoRegular(fontSize));
        if (this.maxValueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.maxValueText, maxWidth, fontSize);
        }
        this.maxValueText.setX(this.size * 0.925 - this.maxValueText.getLayoutBounds().getWidth());
        this.maxValueText.setY(this.size * 0.865);
    }

    private void resize() {
        double height;
        double width = ((Gauge)this.getSkinnable()).getWidth() - ((Gauge)this.getSkinnable()).getInsets().getLeft() - ((Gauge)this.getSkinnable()).getInsets().getRight();
        this.size = width < (height = ((Gauge)this.getSkinnable()).getHeight() - ((Gauge)this.getSkinnable()).getInsets().getTop() - ((Gauge)this.getSkinnable()).getInsets().getBottom()) ? width : height;
        this.stepSize = this.size / this.range;
        if (width > 0.0 && height > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((width - this.size) * 0.5, (height - this.size) * 0.5);
            this.barBackground.setPrefSize(this.size, this.size * 0.035);
            this.barBackground.relocate(0.0, this.size * 0.965);
            this.barClip.setX(0.0);
            this.barClip.setY(this.size * 0.95);
            this.barClip.setWidth(this.size);
            this.barClip.setHeight(this.size * 0.05);
            this.barClip.setArcWidth(this.size * 0.025);
            this.barClip.setArcHeight(this.size * 0.025);
            this.bar.setX(0.0);
            this.bar.setY(this.size * 0.965);
            this.bar.setWidth(((Gauge)this.getSkinnable()).getValue() * this.stepSize);
            this.bar.setHeight(this.size * 0.035);
            this.resizeStaticText();
            this.resizeDynamicText();
            this.maxValueRect.setWidth(this.maxValueText.getLayoutBounds().getWidth() + this.size * 0.05);
            this.maxValueRect.setHeight(this.maxValueText.getLayoutBounds().getHeight());
            this.maxValueRect.setX(this.size * 0.95 - this.maxValueRect.getWidth());
            this.maxValueRect.setY(this.size * 0.7775);
            this.maxValueRect.setArcWidth(this.size * 0.025);
            this.maxValueRect.setArcHeight(this.size * 0.025);
        }
    }

    private void redraw() {
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Gauge)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(((Gauge)this.getSkinnable()).getBorderWidth() / 250.0 * this.size))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), new CornerRadii(this.size * 0.025), Insets.EMPTY)}));
        this.locale = ((Gauge)this.getSkinnable()).getLocale();
        this.formatString = "%." + Integer.toString(((Gauge)this.getSkinnable()).getDecimals()) + "f";
        this.titleText.setText(((Gauge)this.getSkinnable()).getTitle());
        this.percentageText.setText(String.format(this.locale, "%." + ((Gauge)this.getSkinnable()).getTickLabelDecimals() + "f", ((Gauge)this.getSkinnable()).getValue() / this.range * 100.0));
        this.maxValueText.setText(String.format(this.locale, "%." + ((Gauge)this.getSkinnable()).getTickLabelDecimals() + "f", ((Gauge)this.getSkinnable()).getMaxValue()));
        this.resizeStaticText();
        this.barBackground.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)((Gauge)this.getSkinnable()).getBarBackgroundColor().brighter().brighter(), new CornerRadii(0.0, 0.0, this.size * 0.025, this.size * 0.025, false), Insets.EMPTY)}));
        this.barColor = ((Gauge)this.getSkinnable()).getBarColor();
        if (this.sectionsVisible && !this.sections.isEmpty()) {
            this.setBarColor(((Gauge)this.getSkinnable()).getValue());
        } else {
            this.bar.setFill((Paint)this.barColor);
        }
        this.titleText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.maxValueText.setFill(((Gauge)this.getSkinnable()).getBackgroundPaint());
        this.valueText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        this.unitText.setFill((Paint)((Gauge)this.getSkinnable()).getUnitColor());
    }
}

