/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.tools.Helper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.Line;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;

public class TileKpiSkin
extends SkinBase<Gauge>
implements Skin<Gauge> {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double size;
    private double oldValue;
    private Arc barBackground;
    private Arc thresholdBar;
    private Rectangle needleRect;
    private Path needle;
    private Rotate needleRotate;
    private Rotate needleRectRotate;
    private Text titleText;
    private Text valueText;
    private Text unitText;
    private Text minValueText;
    private Text maxValueText;
    private Rectangle thresholdRect;
    private Text thresholdText;
    private Pane sectionPane;
    private Path alertIcon;
    private Tooltip alertTooltip;
    private Pane pane;
    private double angleRange;
    private double minValue;
    private double range;
    private double angleStep;
    private String formatString;
    private Locale locale;
    private boolean sectionsVisible;
    private boolean highlightSections;
    private List<Section> sections;
    private Map<Section, Arc> sectionMap;

    public TileKpiSkin(Gauge gauge) {
        super((Control)gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.angleRange = Helper.clamp(90.0, 180.0, gauge.getAngleRange());
        this.oldValue = gauge.getValue();
        this.minValue = gauge.getMinValue();
        this.range = gauge.getRange();
        this.angleStep = this.angleRange / this.range;
        this.formatString = "%." + Integer.toString(gauge.getDecimals()) + "f";
        this.locale = gauge.getLocale();
        this.sectionsVisible = gauge.getSectionsVisible();
        this.highlightSections = gauge.isHighlightSections();
        this.sections = gauge.getSections();
        this.sectionMap = new HashMap<Section, Arc>(this.sections.size());
        for (Section section : this.sections) {
            this.sectionMap.put(section, new Arc());
        }
        this.initGraphics();
        this.registerListeners();
        this.rotateNeedle(gauge.getCurrentValue());
    }

    private void initGraphics() {
        if (Double.compare(((Gauge)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((Gauge)this.getSkinnable()).getPrefWidth() > 0.0 && ((Gauge)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((Gauge)this.getSkinnable()).setPrefSize(((Gauge)this.getSkinnable()).getPrefWidth(), ((Gauge)this.getSkinnable()).getPrefHeight());
            } else {
                ((Gauge)this.getSkinnable()).setPrefSize(250.0, 250.0);
            }
        }
        this.barBackground = new Arc(125.0, 174.0, 68.75, 68.75, this.angleRange * 0.5 + 90.0, -this.angleRange);
        this.barBackground.setType(ArcType.OPEN);
        this.barBackground.setStroke((Paint)((Gauge)this.getSkinnable()).getBarColor());
        this.barBackground.setStrokeWidth(14.097745);
        this.barBackground.setStrokeLineCap(StrokeLineCap.BUTT);
        this.barBackground.setFill(null);
        this.thresholdBar = new Arc(125.0, 174.0, 68.75, 68.75, -this.angleRange * 0.5 + 90.0, 0.0);
        this.thresholdBar.setType(ArcType.OPEN);
        this.thresholdBar.setStroke((Paint)((Gauge)this.getSkinnable()).getThresholdColor());
        this.thresholdBar.setStrokeWidth(14.097745);
        this.thresholdBar.setStrokeLineCap(StrokeLineCap.BUTT);
        this.thresholdBar.setFill(null);
        Helper.enableNode((Node)this.thresholdBar, !((Gauge)this.getSkinnable()).getSectionsVisible());
        this.sectionPane = new Pane();
        Helper.enableNode((Node)this.sectionPane, ((Gauge)this.getSkinnable()).getSectionsVisible());
        if (this.sectionsVisible) {
            this.drawSections();
        }
        this.alertIcon = new Path();
        this.alertIcon.setFillRule(FillRule.EVEN_ODD);
        this.alertIcon.setFill((Paint)Color.YELLOW);
        this.alertIcon.setStroke(null);
        Helper.enableNode((Node)this.alertIcon, ((Gauge)this.getSkinnable()).isAlert());
        this.alertTooltip = new Tooltip(((Gauge)this.getSkinnable()).getAlertMessage());
        Tooltip.install((Node)this.alertIcon, (Tooltip)this.alertTooltip);
        this.needleRotate = new Rotate((((Gauge)this.getSkinnable()).getValue() - this.oldValue - this.minValue) * this.angleStep);
        this.needleRectRotate = new Rotate((((Gauge)this.getSkinnable()).getValue() - this.oldValue - this.minValue) * this.angleStep);
        this.needleRect = new Rectangle();
        this.needleRect.setFill(((Gauge)this.getSkinnable()).getBackgroundPaint());
        this.needleRect.getTransforms().setAll((Object[])new Transform[]{this.needleRectRotate});
        this.needle = new Path();
        this.needle.setFillRule(FillRule.EVEN_ODD);
        this.needle.getTransforms().setAll((Object[])new Transform[]{this.needleRotate});
        this.needle.setFill((Paint)((Gauge)this.getSkinnable()).getNeedleColor());
        this.needle.setStrokeWidth(0.0);
        this.needle.setStroke((Paint)Color.TRANSPARENT);
        this.titleText = new Text(((Gauge)this.getSkinnable()).getTitle());
        this.titleText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        Helper.enableNode((Node)this.titleText, !((Gauge)this.getSkinnable()).getTitle().isEmpty());
        this.valueText = new Text(String.format(this.locale, this.formatString, ((Gauge)this.getSkinnable()).getCurrentValue()));
        this.valueText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        Helper.enableNode((Node)this.valueText, ((Gauge)this.getSkinnable()).isValueVisible() && !((Gauge)this.getSkinnable()).isAlert());
        this.unitText = new Text(((Gauge)this.getSkinnable()).getUnit());
        this.unitText.setFill((Paint)((Gauge)this.getSkinnable()).getUnitColor());
        Helper.enableNode((Node)this.unitText, ((Gauge)this.getSkinnable()).isValueVisible() && !((Gauge)this.getSkinnable()).isAlert());
        this.minValueText = new Text(String.format(this.locale, "%." + ((Gauge)this.getSkinnable()).getTickLabelDecimals() + "f", ((Gauge)this.getSkinnable()).getMinValue()));
        this.minValueText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.maxValueText = new Text(String.format(this.locale, "%." + ((Gauge)this.getSkinnable()).getTickLabelDecimals() + "f", ((Gauge)this.getSkinnable()).getMaxValue()));
        this.maxValueText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.thresholdRect = new Rectangle();
        this.thresholdRect.setFill((Paint)(this.sectionsVisible ? ((Gauge)this.getSkinnable()).getBackgroundPaint() : ((Gauge)this.getSkinnable()).getThresholdColor()));
        Helper.enableNode((Node)this.thresholdRect, ((Gauge)this.getSkinnable()).isThresholdVisible());
        this.thresholdText = new Text(String.format(this.locale, "%." + ((Gauge)this.getSkinnable()).getTickLabelDecimals() + "f", ((Gauge)this.getSkinnable()).getThreshold()));
        this.thresholdText.setFill((Paint)(this.sectionsVisible ? Color.TRANSPARENT : ((Gauge)this.getSkinnable()).getBackgroundPaint()));
        Helper.enableNode((Node)this.thresholdText, ((Gauge)this.getSkinnable()).isThresholdVisible());
        this.pane = new Pane(new Node[]{this.barBackground, this.thresholdBar, this.sectionPane, this.alertIcon, this.needleRect, this.needle, this.titleText, this.valueText, this.unitText, this.minValueText, this.maxValueText, this.thresholdRect, this.thresholdText});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Gauge)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(((Gauge)this.getSkinnable()).getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((Gauge)this.getSkinnable()).widthProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).heightProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).setOnUpdate(e -> this.handleEvents(e.eventType.name()));
        ((Gauge)this.getSkinnable()).currentValueProperty().addListener(o -> this.rotateNeedle(((Gauge)this.getSkinnable()).getCurrentValue()));
    }

    protected double computeMinWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return super.computePrefWidth(HEIGHT, TOP, RIGHT, BOTTOM, LEFT);
    }

    protected double computePrefHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return super.computePrefHeight(WIDTH, TOP, RIGHT, BOTTOM, LEFT);
    }

    protected double computeMaxWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 1024.0;
    }

    protected double computeMaxHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 1024.0;
    }

    private void handleEvents(String EVENT_TYPE) {
        if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
            this.redraw();
        } else if ("REDRAW".equals(EVENT_TYPE)) {
            this.redraw();
        } else if ("RECALC".equals(EVENT_TYPE)) {
            this.angleRange = Helper.clamp(90.0, 180.0, ((Gauge)this.getSkinnable()).getAngleRange());
            this.minValue = ((Gauge)this.getSkinnable()).getMinValue();
            this.range = ((Gauge)this.getSkinnable()).getRange();
            this.angleStep = this.angleRange / this.range;
            this.highlightSections = ((Gauge)this.getSkinnable()).isHighlightSections();
            this.redraw();
        } else if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !((Gauge)this.getSkinnable()).getTitle().isEmpty());
            Helper.enableNode((Node)this.valueText, ((Gauge)this.getSkinnable()).isValueVisible());
            Helper.enableNode((Node)this.sectionPane, ((Gauge)this.getSkinnable()).getSectionsVisible());
            Helper.enableNode((Node)this.thresholdRect, ((Gauge)this.getSkinnable()).isThresholdVisible());
            Helper.enableNode((Node)this.thresholdText, ((Gauge)this.getSkinnable()).isThresholdVisible());
            Helper.enableNode((Node)this.unitText, !((Gauge)this.getSkinnable()).getUnit().isEmpty());
            this.sectionsVisible = ((Gauge)this.getSkinnable()).getSectionsVisible();
        } else if ("SECTION".equals(EVENT_TYPE)) {
            this.sections = ((Gauge)this.getSkinnable()).getSections();
            this.sectionMap.clear();
            for (Section section : this.sections) {
                this.sectionMap.put(section, new Arc());
            }
        } else if ("ALERT".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.valueText, ((Gauge)this.getSkinnable()).isValueVisible() && !((Gauge)this.getSkinnable()).isAlert());
            Helper.enableNode((Node)this.unitText, ((Gauge)this.getSkinnable()).isValueVisible() && !((Gauge)this.getSkinnable()).isAlert());
            Helper.enableNode((Node)this.alertIcon, ((Gauge)this.getSkinnable()).isAlert());
            this.alertTooltip.setText(((Gauge)this.getSkinnable()).getAlertMessage());
        }
    }

    private void rotateNeedle(double VALUE) {
        double needleStartAngle = this.angleRange * 0.5;
        double targetAngle = (VALUE - this.minValue) * this.angleStep - needleStartAngle;
        targetAngle = Helper.clamp(-needleStartAngle, -needleStartAngle + this.angleRange, targetAngle);
        this.needleRotate.setAngle(targetAngle);
        this.needleRectRotate.setAngle(targetAngle);
        this.valueText.setText(String.format(this.locale, this.formatString, VALUE));
        this.resizeDynamicText();
        this.highlightSections(VALUE);
    }

    private void highlightSections(double VALUE) {
        if (!this.sectionsVisible || this.sections.isEmpty()) {
            return;
        }
        if (this.highlightSections) {
            this.sections.forEach(section -> this.sectionMap.get(section).setVisible(section.contains(VALUE)));
        } else {
            this.sections.forEach(section -> this.sectionMap.get(section).setOpacity(section.contains(VALUE) ? 1.0 : 0.25));
        }
    }

    private void drawSections() {
        if (!this.sectionsVisible || this.sections.isEmpty()) {
            return;
        }
        this.sectionPane.getChildren().clear();
        double centerX = this.size * 0.5;
        double centerY = this.size * 0.7825;
        double innerRadius = this.size * 0.2775;
        double outerRadius = this.size * 0.3225;
        int noOfSections = this.sections.size();
        ArrayList<Line> sectionLines = new ArrayList<Line>(noOfSections);
        for (int i = 0; i < noOfSections - 1; ++i) {
            Section section = this.sections.get(i);
            double angle = Helper.clamp(90.0, 270.0, (section.getStop() - this.minValue) * this.angleStep + 90.0);
            Line line = new Line(centerX + innerRadius * Math.sin(-Math.toRadians(angle)), centerY + innerRadius * Math.cos(-Math.toRadians(angle)), centerX + outerRadius * Math.sin(-Math.toRadians(angle)), centerY + outerRadius * Math.cos(-Math.toRadians(angle)));
            line.setStroke(((Gauge)this.getSkinnable()).getBackgroundPaint());
            sectionLines.add(line);
        }
        this.sectionPane.getChildren().addAll(sectionLines);
        double barRadius = this.size * 0.3;
        double barWidth = this.size * 0.045;
        double maxValue = ((Gauge)this.getSkinnable()).getMaxValue();
        for (Section section : this.sections) {
            double startAngle = (section.getStart() - this.minValue) * this.angleStep - this.angleRange;
            double length = section.getStop() > maxValue ? (maxValue - section.getStart()) * this.angleStep : (Double.compare(section.getStart(), this.minValue) < 0 ? (section.getStop() - this.minValue) * this.angleStep : (section.getStop() - section.getStart()) * this.angleStep);
            Arc sectionArc = new Arc(centerX, centerY, barRadius, barRadius, -startAngle, -length);
            sectionArc.setType(ArcType.OPEN);
            sectionArc.setStroke((Paint)section.getColor());
            sectionArc.setStrokeWidth(barWidth);
            sectionArc.setStrokeLineCap(StrokeLineCap.BUTT);
            sectionArc.setFill(null);
            sectionArc.setVisible(!this.highlightSections);
            sectionArc.setOpacity(this.highlightSections ? 1.0 : 0.25);
            Tooltip sectionTooltip = new Tooltip(section.getText());
            sectionTooltip.setTextAlignment(TextAlignment.CENTER);
            Tooltip.install((Node)sectionArc, (Tooltip)sectionTooltip);
            this.sectionMap.put(section, sectionArc);
        }
        this.sectionPane.getChildren().addAll(this.sectionMap.values());
    }

    private void drawNeedle() {
        double needleWidth = this.size * 0.05;
        double needleHeight = this.size * 0.3325;
        this.needle.setCache(false);
        this.needle.getElements().clear();
        this.needle.getElements().add((Object)new MoveTo(0.25 * needleWidth, 0.924812030075188 * needleHeight));
        this.needle.getElements().add((Object)new CubicCurveTo(0.25 * needleWidth, 0.9022556390977443 * needleHeight, 0.35 * needleWidth, 0.8872180451127819 * needleHeight, 0.5 * needleWidth, 0.8872180451127819 * needleHeight));
        this.needle.getElements().add((Object)new CubicCurveTo(0.65 * needleWidth, 0.8872180451127819 * needleHeight, 0.75 * needleWidth, 0.9022556390977443 * needleHeight, 0.75 * needleWidth, 0.924812030075188 * needleHeight));
        this.needle.getElements().add((Object)new CubicCurveTo(0.75 * needleWidth, 0.9473684210526315 * needleHeight, 0.65 * needleWidth, 0.9624060150375939 * needleHeight, 0.5 * needleWidth, 0.9624060150375939 * needleHeight));
        this.needle.getElements().add((Object)new CubicCurveTo(0.35 * needleWidth, 0.9624060150375939 * needleHeight, 0.25 * needleWidth, 0.9473684210526315 * needleHeight, 0.25 * needleWidth, 0.924812030075188 * needleHeight));
        this.needle.getElements().add((Object)new ClosePath());
        this.needle.getElements().add((Object)new MoveTo(0.0, 0.924812030075188 * needleHeight));
        this.needle.getElements().add((Object)new CubicCurveTo(0.0, 0.9699248120300752 * needleHeight, 0.2 * needleWidth, needleHeight, 0.5 * needleWidth, needleHeight));
        this.needle.getElements().add((Object)new CubicCurveTo(0.8 * needleWidth, needleHeight, needleWidth, 0.9699248120300752 * needleHeight, needleWidth, 0.924812030075188 * needleHeight));
        this.needle.getElements().add((Object)new CubicCurveTo(needleWidth, 0.8947368421052632 * needleHeight, 0.85 * needleWidth, 0.8646616541353384 * needleHeight, 0.65 * needleWidth, 0.849624060150376 * needleHeight));
        this.needle.getElements().add((Object)new CubicCurveTo(0.65 * needleWidth, 0.849624060150376 * needleHeight, 0.65 * needleWidth, 0.022556390977443608 * needleHeight, 0.65 * needleWidth, 0.022556390977443608 * needleHeight));
        this.needle.getElements().add((Object)new CubicCurveTo(0.65 * needleWidth, 0.007518796992481203 * needleHeight, 0.6 * needleWidth, 0.0, 0.5 * needleWidth, 0.0));
        this.needle.getElements().add((Object)new CubicCurveTo(0.4 * needleWidth, 0.0, 0.35 * needleWidth, 0.007518796992481203 * needleHeight, 0.35 * needleWidth, 0.022556390977443608 * needleHeight));
        this.needle.getElements().add((Object)new CubicCurveTo(0.35 * needleWidth, 0.022556390977443608 * needleHeight, 0.35 * needleWidth, 0.849624060150376 * needleHeight, 0.35 * needleWidth, 0.849624060150376 * needleHeight));
        this.needle.getElements().add((Object)new CubicCurveTo(0.15 * needleWidth, 0.8646616541353384 * needleHeight, 0.0, 0.8947368421052632 * needleHeight, 0.0, 0.924812030075188 * needleHeight));
        this.needle.getElements().add((Object)new ClosePath());
        this.needle.setCache(true);
        this.needle.setCacheHint(CacheHint.ROTATE);
    }

    private void drawAlertIcon() {
        this.alertIcon.setCache(false);
        double iconWidth = this.size * 0.155;
        double iconHeight = this.size * 0.135;
        this.alertIcon.getElements().clear();
        this.alertIcon.getElements().add((Object)new MoveTo(0.4411764705882353 * iconWidth, 0.3380952380952381 * iconHeight));
        this.alertIcon.getElements().add((Object)new CubicCurveTo(0.4411764705882353 * iconWidth, 0.3 * iconHeight, 0.4684873949579832 * iconWidth, 0.2714285714285714 * iconHeight, 0.5 * iconWidth, 0.2714285714285714 * iconHeight));
        this.alertIcon.getElements().add((Object)new CubicCurveTo(0.5315126050420168 * iconWidth, 0.2714285714285714 * iconHeight, 0.5588235294117647 * iconWidth, 0.3 * iconHeight, 0.5588235294117647 * iconWidth, 0.3380952380952381 * iconHeight));
        this.alertIcon.getElements().add((Object)new CubicCurveTo(0.5588235294117647 * iconWidth, 0.3380952380952381 * iconHeight, 0.5588235294117647 * iconWidth, 0.6 * iconHeight, 0.5588235294117647 * iconWidth, 0.6 * iconHeight));
        this.alertIcon.getElements().add((Object)new CubicCurveTo(0.5588235294117647 * iconWidth, 0.6357142857142857 * iconHeight, 0.5315126050420168 * iconWidth, 0.6666666666666666 * iconHeight, 0.5 * iconWidth, 0.6666666666666666 * iconHeight));
        this.alertIcon.getElements().add((Object)new CubicCurveTo(0.4684873949579832 * iconWidth, 0.6666666666666666 * iconHeight, 0.4411764705882353 * iconWidth, 0.6357142857142857 * iconHeight, 0.4411764705882353 * iconWidth, 0.6 * iconHeight));
        this.alertIcon.getElements().add((Object)new CubicCurveTo(0.4411764705882353 * iconWidth, 0.6 * iconHeight, 0.4411764705882353 * iconWidth, 0.3380952380952381 * iconHeight, 0.4411764705882353 * iconWidth, 0.3380952380952381 * iconHeight));
        this.alertIcon.getElements().add((Object)new ClosePath());
        this.alertIcon.getElements().add((Object)new MoveTo(0.4411764705882353 * iconWidth, 0.8 * iconHeight));
        this.alertIcon.getElements().add((Object)new CubicCurveTo(0.4411764705882353 * iconWidth, 0.7642857142857142 * iconHeight, 0.4684873949579832 * iconWidth, 0.7333333333333333 * iconHeight, 0.5 * iconWidth, 0.7333333333333333 * iconHeight));
        this.alertIcon.getElements().add((Object)new CubicCurveTo(0.5315126050420168 * iconWidth, 0.7333333333333333 * iconHeight, 0.5588235294117647 * iconWidth, 0.7642857142857142 * iconHeight, 0.5588235294117647 * iconWidth, 0.8 * iconHeight));
        this.alertIcon.getElements().add((Object)new CubicCurveTo(0.5588235294117647 * iconWidth, 0.8380952380952381 * iconHeight, 0.5315126050420168 * iconWidth, 0.8666666666666667 * iconHeight, 0.5 * iconWidth, 0.8666666666666667 * iconHeight));
        this.alertIcon.getElements().add((Object)new CubicCurveTo(0.4684873949579832 * iconWidth, 0.8666666666666667 * iconHeight, 0.4411764705882353 * iconWidth, 0.8380952380952381 * iconHeight, 0.4411764705882353 * iconWidth, 0.8 * iconHeight));
        this.alertIcon.getElements().add((Object)new ClosePath());
        this.alertIcon.getElements().add((Object)new MoveTo(0.5504201680672269 * iconWidth, 0.04285714285714286 * iconHeight));
        this.alertIcon.getElements().add((Object)new CubicCurveTo(0.523109243697479 * iconWidth, -0.011904761904761904 * iconHeight, 0.47689075630252103 * iconWidth, -0.011904761904761904 * iconHeight, 0.4495798319327731 * iconWidth, 0.04285714285714286 * iconHeight));
        this.alertIcon.getElements().add((Object)new CubicCurveTo(0.4495798319327731 * iconWidth, 0.04285714285714286 * iconHeight, 0.012605042016806723 * iconWidth, 0.9 * iconHeight, 0.012605042016806723 * iconWidth, 0.9 * iconHeight));
        this.alertIcon.getElements().add((Object)new CubicCurveTo(-0.014705882352941176 * iconWidth, 0.9547619047619048 * iconHeight, 0.0063025210084033615 * iconWidth, iconHeight, 0.06302521008403361 * iconWidth, iconHeight));
        this.alertIcon.getElements().add((Object)new CubicCurveTo(0.06302521008403361 * iconWidth, iconHeight, 0.9369747899159664 * iconWidth, iconHeight, 0.9369747899159664 * iconWidth, iconHeight));
        this.alertIcon.getElements().add((Object)new CubicCurveTo(0.9936974789915967 * iconWidth, iconHeight, 1.0147058823529411 * iconWidth, 0.9547619047619048 * iconHeight, 0.9873949579831933 * iconWidth, 0.9 * iconHeight));
        this.alertIcon.getElements().add((Object)new CubicCurveTo(0.9873949579831933 * iconWidth, 0.9 * iconHeight, 0.5504201680672269 * iconWidth, 0.04285714285714286 * iconHeight, 0.5504201680672269 * iconWidth, 0.04285714285714286 * iconHeight));
        this.alertIcon.getElements().add((Object)new ClosePath());
        this.alertIcon.setCache(true);
        this.alertIcon.setCacheHint(CacheHint.SPEED);
    }

    private void resizeDynamicText() {
        double maxWidth = this.unitText.isManaged() ? this.size * 0.725 : this.size * 0.9;
        double fontSize = this.size * 0.24;
        this.valueText.setFont(Fonts.latoRegular(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
        maxWidth = this.size * 0.15;
        fontSize = this.size * 0.06;
        this.unitText.setFont(Fonts.latoRegular(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        if (this.unitText.isVisible()) {
            this.valueText.relocate((this.size - this.valueText.getLayoutBounds().getWidth() - this.unitText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.15);
            this.unitText.relocate(this.valueText.getLayoutX() + this.valueText.getLayoutBounds().getWidth() + this.size * 0.025, this.size * 0.3275);
        } else {
            this.valueText.relocate((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.15);
        }
        if (this.sectionsVisible) {
            fontSize = this.size * 0.09;
            this.thresholdText.setFont(Fonts.latoRegular(fontSize));
            this.thresholdText.setTextOrigin(VPos.CENTER);
            if (this.thresholdText.getLayoutBounds().getWidth() > maxWidth) {
                Helper.adjustTextSize(this.thresholdText, maxWidth, fontSize);
            }
            this.thresholdText.setX((this.size - this.thresholdText.getLayoutBounds().getWidth()) * 0.5);
            this.thresholdText.setY(this.thresholdRect.getLayoutBounds().getMinY() + this.thresholdRect.getHeight() * 0.5);
        }
    }

    private void resizeStaticText() {
        double maxWidth = this.size * 0.9;
        double fontSize = this.size * 0.06;
        this.titleText.setFont(Fonts.latoRegular(fontSize));
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        this.titleText.relocate(this.size * 0.05, this.size * 0.05);
        maxWidth = this.size * 0.15;
        fontSize = this.size * 0.07;
        this.maxValueText.setFont(Fonts.latoRegular(fontSize));
        if (this.maxValueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.maxValueText, maxWidth, fontSize);
        }
        double textRadius = this.size * 0.3;
        double sinValue = Math.sin(Math.toRadians(90.0 + (180.0 - this.angleRange) * 0.5));
        double cosValue = Math.cos(Math.toRadians(90.0 + (180.0 - this.angleRange) * 0.5));
        double textX = this.size * 0.5 + textRadius * sinValue;
        double textY = this.size * 0.83 + textRadius * cosValue;
        this.maxValueText.setTranslateX(-this.maxValueText.getLayoutBounds().getWidth() * 0.5);
        this.maxValueText.setTranslateY(-this.maxValueText.getLayoutBounds().getHeight() * 0.5);
        this.maxValueText.relocate(textX, textY);
        this.minValueText.setFont(Fonts.latoRegular(this.maxValueText.getFont().getSize()));
        if (this.minValueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.minValueText, maxWidth, fontSize);
        }
        sinValue = Math.sin(Math.toRadians(-90.0 - (180.0 - this.angleRange) * 0.5));
        cosValue = Math.cos(Math.toRadians(-90.0 - (180.0 - this.angleRange) * 0.5));
        textX = this.size * 0.5 + textRadius * sinValue;
        textY = this.size * 0.83 + textRadius * cosValue;
        this.minValueText.setTranslateX(-this.minValueText.getLayoutBounds().getWidth() * 0.5);
        this.minValueText.setTranslateY(-this.minValueText.getLayoutBounds().getHeight() * 0.5);
        this.minValueText.relocate(textX, textY);
        if (!this.sectionsVisible) {
            fontSize = this.size * 0.09;
            this.thresholdText.setFont(Fonts.latoRegular(fontSize));
            this.thresholdText.setTextOrigin(VPos.CENTER);
            if (this.thresholdText.getLayoutBounds().getWidth() > maxWidth) {
                Helper.adjustTextSize(this.thresholdText, maxWidth, fontSize);
            }
            this.thresholdText.setX((this.size - this.thresholdText.getLayoutBounds().getWidth()) * 0.5);
            this.thresholdText.setY(this.thresholdRect.getLayoutBounds().getMinY() + this.thresholdRect.getHeight() * 0.5);
        }
    }

    private void resize() {
        double height;
        double width = ((Gauge)this.getSkinnable()).getWidth() - ((Gauge)this.getSkinnable()).getInsets().getLeft() - ((Gauge)this.getSkinnable()).getInsets().getRight();
        double d = this.size = width < (height = ((Gauge)this.getSkinnable()).getHeight() - ((Gauge)this.getSkinnable()).getInsets().getTop() - ((Gauge)this.getSkinnable()).getInsets().getBottom()) ? width : height;
        if (width > 0.0 && height > 0.0) {
            double centerX = this.size * 0.5;
            double centerY = this.size * 0.7825;
            double barRadius = this.size * 0.3;
            double barWidth = this.size * 0.045;
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((width - this.size) * 0.5, (height - this.size) * 0.5);
            this.sectionPane.setMaxSize(this.size, this.size);
            this.barBackground.setCenterX(centerX);
            this.barBackground.setCenterY(centerY);
            this.barBackground.setRadiusX(barRadius);
            this.barBackground.setRadiusY(barRadius);
            this.barBackground.setStrokeWidth(barWidth);
            this.barBackground.setStartAngle(this.angleRange * 0.5 + 90.0);
            this.barBackground.setLength(-this.angleRange);
            this.thresholdBar.setCenterX(centerX);
            this.thresholdBar.setCenterY(centerY);
            this.thresholdBar.setRadiusX(barRadius);
            this.thresholdBar.setRadiusY(barRadius);
            this.thresholdBar.setStrokeWidth(barWidth);
            this.thresholdBar.setStartAngle(90.0 - this.angleRange * 0.5);
            this.thresholdBar.setLength((((Gauge)this.getSkinnable()).getMaxValue() - ((Gauge)this.getSkinnable()).getThreshold()) * this.angleStep);
            if (this.sectionsVisible) {
                this.drawSections();
            }
            this.drawAlertIcon();
            this.alertIcon.relocate((this.size - this.alertIcon.getLayoutBounds().getWidth()) * 0.5, this.size * 0.244);
            this.needleRect.setWidth(this.size * 0.035);
            this.needleRect.setHeight(this.size * 0.05);
            this.needleRect.relocate((this.size - this.needleRect.getWidth()) * 0.5, this.size * 0.4575);
            this.needleRectRotate.setPivotX(this.needleRect.getLayoutBounds().getWidth() * 0.5);
            this.needleRectRotate.setPivotY(this.size * 0.325);
            this.drawNeedle();
            this.needle.relocate((this.size - this.needle.getLayoutBounds().getWidth()) * 0.5, this.size * 0.475);
            this.needleRotate.setPivotX(this.needle.getLayoutBounds().getWidth() * 0.5);
            this.needleRotate.setPivotY(this.needle.getLayoutBounds().getHeight() - this.needle.getLayoutBounds().getWidth() * 0.5);
            this.resizeStaticText();
            this.resizeDynamicText();
            this.thresholdRect.setWidth(this.thresholdText.getLayoutBounds().getWidth() + this.size * 0.05);
            this.thresholdRect.setHeight(this.thresholdText.getLayoutBounds().getHeight());
            this.thresholdRect.setX((this.size - this.thresholdRect.getWidth()) * 0.5);
            this.thresholdRect.setY(this.size * 0.845);
            this.thresholdRect.setArcWidth(this.size * 0.025);
            this.thresholdRect.setArcHeight(this.size * 0.025);
        }
    }

    private void redraw() {
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Gauge)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(((Gauge)this.getSkinnable()).getBorderWidth() / 250.0 * this.size))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), new CornerRadii(this.size * 0.025), Insets.EMPTY)}));
        this.locale = ((Gauge)this.getSkinnable()).getLocale();
        this.formatString = "%." + Integer.toString(((Gauge)this.getSkinnable()).getDecimals()) + "f";
        this.titleText.setText(((Gauge)this.getSkinnable()).getTitle());
        this.unitText.setText(((Gauge)this.getSkinnable()).getUnit());
        this.minValueText.setText(String.format(this.locale, "%." + ((Gauge)this.getSkinnable()).getTickLabelDecimals() + "f", ((Gauge)this.getSkinnable()).getMinValue()));
        this.maxValueText.setText(String.format(this.locale, "%." + ((Gauge)this.getSkinnable()).getTickLabelDecimals() + "f", ((Gauge)this.getSkinnable()).getMaxValue()));
        this.thresholdText.setText(String.format(this.locale, "%." + ((Gauge)this.getSkinnable()).getTickLabelDecimals() + "f", ((Gauge)this.getSkinnable()).getThreshold()));
        this.resizeStaticText();
        this.barBackground.setStroke((Paint)((Gauge)this.getSkinnable()).getBarColor());
        this.thresholdBar.setStroke((Paint)((Gauge)this.getSkinnable()).getThresholdColor());
        this.needleRect.setFill(((Gauge)this.getSkinnable()).getBackgroundPaint());
        this.needle.setFill((Paint)((Gauge)this.getSkinnable()).getNeedleColor());
        this.titleText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.minValueText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.maxValueText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.thresholdRect.setFill((Paint)(this.sectionsVisible ? Color.TRANSPARENT : ((Gauge)this.getSkinnable()).getThresholdColor()));
        this.thresholdText.setFill((Paint)(this.sectionsVisible ? Color.TRANSPARENT : ((Gauge)this.getSkinnable()).getBackgroundPaint()));
        this.valueText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        this.highlightSections(((Gauge)this.getSkinnable()).getValue());
    }
}

