/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Alarm;
import eu.hansolo.medusa.Clock;
import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.TimeSection;
import eu.hansolo.medusa.tools.Helper;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Text;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;

public class ClockSkin
extends SkinBase<Clock>
implements Skin<Clock> {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("EEEE\ndd.MM.YYYY\nHH:mm:ss");
    private static final DateTimeFormatter DATE_FORMATER = DateTimeFormatter.ofPattern("EE d");
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm");
    private Map<Alarm, Circle> alarmMap = new ConcurrentHashMap<Alarm, Circle>();
    private double size;
    private Canvas sectionsAndAreasCanvas;
    private GraphicsContext sectionsAndAreasCtx;
    private Canvas tickCanvas;
    private GraphicsContext tickCtx;
    private Rectangle hour;
    private Rectangle minute;
    private Rectangle second;
    private Circle knob;
    private Text title;
    private Text dateText;
    private Text text;
    private Pane alarmPane;
    private Pane pane;
    private Rotate hourRotate;
    private Rotate minuteRotate = new Rotate();
    private Rotate secondRotate;
    private Group shadowGroupHour;
    private Group shadowGroupMinute;
    private Group shadowGroupSecond;
    private DropShadow dropShadow;
    private List<TimeSection> sections;
    private List<TimeSection> areas;
    private boolean sectionsVisible;
    private boolean highlightSections;
    private boolean areasVisible;
    private boolean highlightAreas;

    public ClockSkin(Clock clock) {
        super((Control)clock);
        this.hourRotate = new Rotate();
        this.secondRotate = new Rotate();
        this.sections = clock.getSections();
        this.highlightSections = clock.isHighlightSections();
        this.sectionsVisible = clock.getSectionsVisible();
        this.areas = clock.getAreas();
        this.highlightAreas = clock.isHighlightAreas();
        this.areasVisible = clock.getAreasVisible();
        this.updateAlarms();
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(((Clock)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((Clock)this.getSkinnable()).getPrefWidth() > 0.0 && ((Clock)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((Clock)this.getSkinnable()).setPrefSize(((Clock)this.getSkinnable()).getPrefWidth(), ((Clock)this.getSkinnable()).getPrefHeight());
            } else {
                ((Clock)this.getSkinnable()).setPrefSize(250.0, 250.0);
            }
        }
        this.sectionsAndAreasCanvas = new Canvas(250.0, 250.0);
        this.sectionsAndAreasCtx = this.sectionsAndAreasCanvas.getGraphicsContext2D();
        this.tickCanvas = new Canvas(250.0, 250.0);
        this.tickCtx = this.tickCanvas.getGraphicsContext2D();
        this.alarmPane = new Pane();
        this.hour = new Rectangle(3.0, 60.0);
        this.hour.setArcHeight(3.0);
        this.hour.setArcWidth(3.0);
        this.hour.setStroke((Paint)((Clock)this.getSkinnable()).getHourColor());
        this.hour.getTransforms().setAll((Object[])new Transform[]{this.hourRotate});
        this.minute = new Rectangle(3.0, 96.0);
        this.minute.setArcHeight(3.0);
        this.minute.setArcWidth(3.0);
        this.minute.setStroke((Paint)((Clock)this.getSkinnable()).getMinuteColor());
        this.minute.getTransforms().setAll((Object[])new Transform[]{this.minuteRotate});
        this.second = new Rectangle(1.0, 96.0);
        this.second.setArcHeight(1.0);
        this.second.setArcWidth(1.0);
        this.second.setStroke((Paint)((Clock)this.getSkinnable()).getSecondColor());
        this.second.getTransforms().setAll((Object[])new Transform[]{this.secondRotate});
        this.second.setVisible(((Clock)this.getSkinnable()).isSecondsVisible());
        this.second.setManaged(((Clock)this.getSkinnable()).isSecondsVisible());
        this.knob = new Circle(125.0, 125.0, 4.5);
        this.knob.setStroke((Paint)Color.web((String)"#282a3280"));
        this.dropShadow = new DropShadow();
        this.dropShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.25));
        this.dropShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.dropShadow.setRadius(3.75);
        this.dropShadow.setOffsetY(3.75);
        this.shadowGroupHour = new Group(new Node[]{this.hour});
        this.shadowGroupMinute = new Group(new Node[]{this.minute});
        this.shadowGroupSecond = new Group(new Node[]{this.second, this.knob});
        this.shadowGroupHour.setEffect((Effect)(((Clock)this.getSkinnable()).getShadowsEnabled() ? this.dropShadow : null));
        this.shadowGroupMinute.setEffect((Effect)(((Clock)this.getSkinnable()).getShadowsEnabled() ? this.dropShadow : null));
        this.shadowGroupSecond.setEffect((Effect)(((Clock)this.getSkinnable()).getShadowsEnabled() ? this.dropShadow : null));
        this.title = new Text("");
        this.title.setVisible(((Clock)this.getSkinnable()).isTitleVisible());
        this.title.setManaged(((Clock)this.getSkinnable()).isTitleVisible());
        this.dateText = new Text("");
        this.dateText.setVisible(((Clock)this.getSkinnable()).isDateVisible());
        this.dateText.setManaged(((Clock)this.getSkinnable()).isDateVisible());
        this.text = new Text("");
        this.text.setVisible(((Clock)this.getSkinnable()).isTextVisible());
        this.text.setManaged(((Clock)this.getSkinnable()).isTextVisible());
        this.pane = new Pane(new Node[]{this.sectionsAndAreasCanvas, this.tickCanvas, this.alarmPane, this.title, this.dateText, this.text, this.shadowGroupHour, this.shadowGroupMinute, this.shadowGroupSecond});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Clock)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(((Clock)this.getSkinnable()).getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Clock)this.getSkinnable()).getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((Clock)this.getSkinnable()).widthProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Clock)this.getSkinnable()).heightProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Clock)this.getSkinnable()).setOnUpdate(e -> this.handleEvents(e.eventType.name()));
        if (((Clock)this.getSkinnable()).isAnimated()) {
            ((Clock)this.getSkinnable()).currentTimeProperty().addListener(o -> this.updateTime(ZonedDateTime.ofInstant(Instant.ofEpochSecond(((Clock)this.getSkinnable()).getCurrentTime()), ZoneId.of(ZoneId.systemDefault().getId()))));
        } else {
            ((Clock)this.getSkinnable()).timeProperty().addListener(o -> this.updateTime(((Clock)this.getSkinnable()).getTime()));
        }
        ((Clock)this.getSkinnable()).getAlarms().addListener(c -> {
            this.updateAlarms();
            this.redraw();
        });
    }

    protected double computeMinWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return super.computePrefWidth(HEIGHT, TOP, RIGHT, BOTTOM, LEFT);
    }

    protected double computePrefHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return super.computePrefHeight(WIDTH, TOP, RIGHT, BOTTOM, LEFT);
    }

    protected double computeMaxWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 1024.0;
    }

    protected double computeMaxHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 1024.0;
    }

    private void handleEvents(String EVENT_TYPE) {
        if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
            this.redraw();
        } else if ("REDRAW".equals(EVENT_TYPE)) {
            this.redraw();
        } else if ("VISIBILITY".equals(EVENT_TYPE)) {
            this.title.setVisible(((Clock)this.getSkinnable()).isTitleVisible());
            this.title.setManaged(((Clock)this.getSkinnable()).isTitleVisible());
            this.text.setVisible(((Clock)this.getSkinnable()).isTextVisible());
            this.text.setManaged(((Clock)this.getSkinnable()).isTextVisible());
            this.dateText.setVisible(((Clock)this.getSkinnable()).isDateVisible());
            this.dateText.setManaged(((Clock)this.getSkinnable()).isDateVisible());
            this.second.setVisible(((Clock)this.getSkinnable()).isSecondsVisible());
            this.second.setManaged(((Clock)this.getSkinnable()).isSecondsVisible());
            boolean alarmsVisible = ((Clock)this.getSkinnable()).isAlarmsVisible();
            for (Shape shape : this.alarmMap.values()) {
                shape.setManaged(alarmsVisible);
                shape.setVisible(alarmsVisible);
            }
        } else if ("SECTION".equals(EVENT_TYPE)) {
            this.sections = ((Clock)this.getSkinnable()).getSections();
            this.highlightSections = ((Clock)this.getSkinnable()).isHighlightSections();
            this.sectionsVisible = ((Clock)this.getSkinnable()).getSectionsVisible();
            this.areas = ((Clock)this.getSkinnable()).getAreas();
            this.highlightAreas = ((Clock)this.getSkinnable()).isHighlightAreas();
            this.areasVisible = ((Clock)this.getSkinnable()).getAreasVisible();
            this.redraw();
        } else if ("FINISHED".equals(EVENT_TYPE)) {
            // empty if block
        }
    }

    private void drawTicks() {
        double startAngle = 180.0;
        double angleStep = 6.0;
        Point2D center = new Point2D(this.size * 0.5, this.size * 0.5);
        Color hourTickMarkColor = ((Clock)this.getSkinnable()).getHourTickMarkColor();
        Color minuteTickMarkColor = ((Clock)this.getSkinnable()).getMinuteTickMarkColor();
        boolean hourTickMarksVisible = ((Clock)this.getSkinnable()).isHourTickMarksVisible();
        boolean minuteTickMarksVisible = ((Clock)this.getSkinnable()).isMinuteTickMarksVisible();
        this.tickCtx.clearRect(0.0, 0.0, this.size, this.size);
        this.tickCtx.setLineCap(StrokeLineCap.ROUND);
        double angle = 0.0;
        double counter = 0.0;
        while (Double.compare(counter, 59.0) <= 0) {
            double sinValue = Math.sin(Math.toRadians(angle + startAngle));
            double cosValue = Math.cos(Math.toRadians(angle + startAngle));
            Point2D innerPoint = new Point2D(center.getX() + this.size * 0.405 * sinValue, center.getY() + this.size * 0.405 * cosValue);
            Point2D innerMinutePoint = new Point2D(center.getX() + this.size * 0.435 * sinValue, center.getY() + this.size * 0.435 * cosValue);
            Point2D outerPoint = new Point2D(center.getX() + this.size * 0.465 * sinValue, center.getY() + this.size * 0.465 * cosValue);
            if (counter % 5.0 == 0.0) {
                this.tickCtx.setStroke((Paint)hourTickMarkColor);
                if (hourTickMarksVisible) {
                    this.tickCtx.setLineWidth(this.size * 0.01);
                    this.tickCtx.strokeLine(innerPoint.getX(), innerPoint.getY(), outerPoint.getX(), outerPoint.getY());
                } else if (minuteTickMarksVisible) {
                    this.tickCtx.setLineWidth(this.size * 0.005);
                    this.tickCtx.strokeLine(innerMinutePoint.getX(), innerMinutePoint.getY(), outerPoint.getX(), outerPoint.getY());
                }
            } else if (counter % 1.0 == 0.0 && minuteTickMarksVisible) {
                this.tickCtx.setLineWidth(this.size * 0.005);
                this.tickCtx.setStroke((Paint)minuteTickMarkColor);
                this.tickCtx.strokeLine(innerMinutePoint.getX(), innerMinutePoint.getY(), outerPoint.getX(), outerPoint.getY());
            }
            angle -= angleStep;
            counter += 1.0;
        }
    }

    private void updateAlarms() {
        this.alarmMap.clear();
        for (Alarm alarm : ((Clock)this.getSkinnable()).getAlarms()) {
            this.alarmMap.put(alarm, new Circle());
        }
    }

    public void updateTime(ZonedDateTime TIME) {
        if (((Clock)this.getSkinnable()).isDiscreteHours()) {
            this.hourRotate.setAngle((double)(TIME.getHour() * 30));
        } else {
            this.hourRotate.setAngle(0.5 * (double)(60 * TIME.getHour() + TIME.getMinute()));
        }
        if (((Clock)this.getSkinnable()).isDiscreteMinutes()) {
            this.minuteRotate.setAngle((double)(TIME.getMinute() * 6));
        } else {
            this.minuteRotate.setAngle((double)(TIME.getMinute() * 6) + (double)TIME.getSecond() * 0.1);
        }
        if (this.second.isVisible()) {
            if (((Clock)this.getSkinnable()).isDiscreteSeconds()) {
                this.secondRotate.setAngle((double)(TIME.getSecond() * 6));
            } else {
                this.secondRotate.setAngle((double)(TIME.getSecond() * 6) + (double)TIME.get(ChronoField.MILLI_OF_SECOND) * 0.006);
            }
        }
        if (this.text.isVisible()) {
            this.text.setText(TIME_FORMATTER.format(TIME));
            Helper.adjustTextSize(this.text, 0.6 * this.size, this.size * 0.12);
            this.text.relocate((this.size - this.text.getLayoutBounds().getWidth()) * 0.5, this.size * 0.6);
        }
        if (this.dateText.isVisible()) {
            this.dateText.setText(DATE_FORMATER.format(TIME).toUpperCase());
            Helper.adjustTextSize(this.dateText, 0.3 * this.size, this.size * 0.05);
            this.dateText.relocate((this.size * 0.5 - this.dateText.getLayoutBounds().getWidth()) * 0.5 + this.size * 0.45, (this.size - this.dateText.getLayoutBounds().getHeight()) * 0.5);
        }
        if (TIME.getMinute() == 0 && TIME.getSecond() == 0) {
            Helper.drawAlarms((Clock)this.getSkinnable(), this.size, 0.02, 0.45, this.alarmMap, DATE_TIME_FORMATTER, TIME);
        }
        if (this.highlightAreas | this.highlightSections) {
            this.sectionsAndAreasCtx.clearRect(0.0, 0.0, this.size, this.size);
            if (this.areasVisible) {
                Helper.drawTimeAreas((Clock)this.getSkinnable(), this.sectionsAndAreasCtx, this.areas, this.size, 0.03, 0.03, 0.94, 0.94);
            }
            if (this.sectionsVisible) {
                Helper.drawTimeSections((Clock)this.getSkinnable(), this.sectionsAndAreasCtx, this.sections, this.size, 0.065, 0.065, 0.87, 0.87, 0.07);
            }
        }
    }

    private void resize() {
        double height;
        double width = ((Clock)this.getSkinnable()).getWidth() - ((Clock)this.getSkinnable()).getInsets().getLeft() - ((Clock)this.getSkinnable()).getInsets().getRight();
        double d = this.size = width < (height = ((Clock)this.getSkinnable()).getHeight() - ((Clock)this.getSkinnable()).getInsets().getTop() - ((Clock)this.getSkinnable()).getInsets().getBottom()) ? width : height;
        if (this.size > 0.0) {
            double center = this.size * 0.5;
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((((Clock)this.getSkinnable()).getWidth() - this.size) * 0.5, (((Clock)this.getSkinnable()).getHeight() - this.size) * 0.5);
            this.dropShadow.setRadius(0.008 * this.size);
            this.dropShadow.setOffsetY(0.008 * this.size);
            this.sectionsAndAreasCanvas.setWidth(this.size);
            this.sectionsAndAreasCanvas.setHeight(this.size);
            this.tickCanvas.setWidth(this.size);
            this.tickCanvas.setHeight(this.size);
            this.alarmPane.setMaxSize(this.size, this.size);
            this.hour.setFill((Paint)((Clock)this.getSkinnable()).getHourColor());
            this.hour.setCache(false);
            this.hour.setWidth(this.size * 0.015);
            this.hour.setHeight(this.size * 0.29);
            this.hour.setArcWidth(this.size * 0.015);
            this.hour.setArcHeight(this.size * 0.015);
            this.hour.setCache(true);
            this.hour.setCacheHint(CacheHint.ROTATE);
            this.hour.relocate((this.size - this.hour.getWidth()) * 0.5, this.size * 0.21);
            this.minute.setFill((Paint)((Clock)this.getSkinnable()).getMinuteColor());
            this.minute.setCache(false);
            this.minute.setWidth(this.size * 0.015);
            this.minute.setHeight(this.size * 0.47);
            this.minute.setArcWidth(this.size * 0.015);
            this.minute.setArcHeight(this.size * 0.015);
            this.minute.setCache(true);
            this.minute.setCacheHint(CacheHint.ROTATE);
            this.minute.relocate((this.size - this.minute.getWidth()) * 0.5, this.size * 0.03);
            this.second.setFill((Paint)((Clock)this.getSkinnable()).getSecondColor());
            this.second.setCache(false);
            this.second.setWidth(this.size * 0.005);
            this.second.setHeight(this.size * 0.47);
            this.second.setArcWidth(this.size * 0.015);
            this.second.setArcHeight(this.size * 0.015);
            this.second.setCache(true);
            this.second.setCacheHint(CacheHint.ROTATE);
            this.second.relocate((this.size - this.second.getWidth()) * 0.5, this.size * 0.03);
            this.knob.setFill((Paint)((Clock)this.getSkinnable()).getKnobColor());
            this.knob.setRadius(this.size * 0.0225);
            this.knob.setCenterX(center);
            this.knob.setCenterY(center);
            this.title.setFill((Paint)((Clock)this.getSkinnable()).getTextColor());
            this.title.setFont(Fonts.latoLight(this.size * 0.12));
            this.title.relocate((this.size - this.title.getLayoutBounds().getWidth()) * 0.5, this.size * 0.25);
            this.dateText.setFill((Paint)((Clock)this.getSkinnable()).getDateColor());
            this.dateText.setFont(Fonts.latoLight(this.size * 0.05));
            this.dateText.relocate((center - this.dateText.getLayoutBounds().getWidth()) * 0.5 + this.size * 0.45, (this.size - this.dateText.getLayoutBounds().getHeight()) * 0.5);
            this.text.setFill((Paint)((Clock)this.getSkinnable()).getTextColor());
            this.text.setFont(Fonts.latoLight(this.size * 0.12));
            this.text.relocate((this.size - this.text.getLayoutBounds().getWidth()) * 0.5, this.size * 0.6);
            this.minuteRotate.setPivotX(this.minute.getWidth() * 0.5);
            this.minuteRotate.setPivotY(this.minute.getHeight());
            this.hourRotate.setPivotX(this.hour.getWidth() * 0.5);
            this.hourRotate.setPivotY(this.hour.getHeight());
            this.secondRotate.setPivotX(this.second.getWidth() * 0.5);
            this.secondRotate.setPivotY(this.second.getHeight());
        }
    }

    private void redraw() {
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Clock)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(((Clock)this.getSkinnable()).getBorderWidth() / 250.0 * this.size))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Clock)this.getSkinnable()).getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.shadowGroupHour.setEffect((Effect)(((Clock)this.getSkinnable()).getShadowsEnabled() ? this.dropShadow : null));
        this.shadowGroupMinute.setEffect((Effect)(((Clock)this.getSkinnable()).getShadowsEnabled() ? this.dropShadow : null));
        this.shadowGroupSecond.setEffect((Effect)(((Clock)this.getSkinnable()).getShadowsEnabled() ? this.dropShadow : null));
        this.sectionsAndAreasCtx.clearRect(0.0, 0.0, this.size, this.size);
        if (this.areasVisible) {
            Helper.drawTimeAreas((Clock)this.getSkinnable(), this.sectionsAndAreasCtx, this.areas, this.size, 0.03, 0.03, 0.94, 0.94);
        }
        if (this.sectionsVisible) {
            Helper.drawTimeSections((Clock)this.getSkinnable(), this.sectionsAndAreasCtx, this.sections, this.size, 0.065, 0.065, 0.87, 0.87, 0.07);
        }
        this.tickCanvas.setCache(false);
        this.drawTicks();
        this.tickCanvas.setCache(true);
        this.tickCanvas.setCacheHint(CacheHint.QUALITY);
        ZonedDateTime time = ((Clock)this.getSkinnable()).getTime();
        this.updateTime(time);
        this.title.setText(((Clock)this.getSkinnable()).getTitle());
        Helper.adjustTextSize(this.title, 0.6 * this.size, this.size * 0.12);
        this.title.relocate((this.size - this.title.getLayoutBounds().getWidth()) * 0.5, this.size * 0.25);
        this.text.setText(TIME_FORMATTER.format(time));
        Helper.adjustTextSize(this.text, 0.6 * this.size, this.size * 0.12);
        this.text.relocate((this.size - this.text.getLayoutBounds().getWidth()) * 0.5, this.size * 0.6);
        this.dateText.setText(DATE_FORMATER.format(time).toUpperCase());
        Helper.adjustTextSize(this.dateText, 0.3 * this.size, this.size * 0.05);
        this.dateText.relocate((this.size * 0.5 - this.dateText.getLayoutBounds().getWidth()) * 0.5 + this.size * 0.45, (this.size - this.dateText.getLayoutBounds().getHeight()) * 0.5);
        this.alarmPane.getChildren().setAll(this.alarmMap.values());
        Helper.drawAlarms((Clock)this.getSkinnable(), this.size, 0.02, 0.45, this.alarmMap, DATE_TIME_FORMATTER, time);
    }
}

