/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Clock;
import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.tools.Helper;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.Circle;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class MinimalClockSkin
extends SkinBase<Clock>
implements Skin<Clock> {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final DateTimeFormatter DATE_TEXT_FORMATTER = DateTimeFormatter.ofPattern("ccc., dd. MMM.");
    private static final DateTimeFormatter HOUR_FORMATTER = DateTimeFormatter.ofPattern("HH");
    private static final DateTimeFormatter MINUTE_FORMATTER = DateTimeFormatter.ofPattern("mm");
    private double size;
    private Circle secondBackgroundCircle;
    private Text dateText;
    private Text hour;
    private Text minute;
    private Circle minuteCircle;
    private Arc secondArc;
    private Pane pane;
    private DoubleProperty minuteAngle;
    private Timeline timeline;

    public MinimalClockSkin(final Clock clock) {
        super((Control)clock);
        this.minuteAngle = new DoublePropertyBase(-1.0){

            public Object getBean() {
                return clock;
            }

            public String getName() {
                return "minuteAngle";
            }
        };
        this.timeline = new Timeline();
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(((Clock)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((Clock)this.getSkinnable()).getPrefWidth() > 0.0 && ((Clock)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((Clock)this.getSkinnable()).setPrefSize(((Clock)this.getSkinnable()).getPrefWidth(), ((Clock)this.getSkinnable()).getPrefHeight());
            } else {
                ((Clock)this.getSkinnable()).setPrefSize(250.0, 250.0);
            }
        }
        ZonedDateTime time = ((Clock)this.getSkinnable()).getTime();
        this.secondBackgroundCircle = new Circle(125.0, 125.0, 120.0);
        this.secondBackgroundCircle.setStrokeWidth(2.0);
        this.secondBackgroundCircle.setStrokeType(StrokeType.CENTERED);
        this.secondBackgroundCircle.setStrokeLineCap(StrokeLineCap.ROUND);
        this.secondBackgroundCircle.setFill(null);
        this.secondBackgroundCircle.setStroke((Paint)Helper.getTranslucentColorFrom(((Clock)this.getSkinnable()).getSecondColor(), 0.2));
        this.secondBackgroundCircle.setVisible(((Clock)this.getSkinnable()).isSecondsVisible());
        this.secondBackgroundCircle.setManaged(((Clock)this.getSkinnable()).isSecondsVisible());
        this.dateText = new Text(DATE_TEXT_FORMATTER.format(time));
        this.dateText.setVisible(((Clock)this.getSkinnable()).isDateVisible());
        this.dateText.setManaged(((Clock)this.getSkinnable()).isDateVisible());
        this.hour = new Text(HOUR_FORMATTER.format(time));
        this.hour.setFill((Paint)((Clock)this.getSkinnable()).getHourColor());
        this.minute = new Text(MINUTE_FORMATTER.format(time));
        this.minute.setFill((Paint)((Clock)this.getSkinnable()).getMinuteColor());
        this.minuteCircle = new Circle(18.75);
        this.secondArc = new Arc(125.0, 125.0, 240.0, 120.0, 90.0, (double)(-6 * ((Clock)this.getSkinnable()).getTime().getSecond()));
        this.secondArc.setStrokeWidth(2.0);
        this.secondArc.setStrokeType(StrokeType.CENTERED);
        this.secondArc.setStrokeLineCap(StrokeLineCap.BUTT);
        this.secondArc.setFill(null);
        this.secondArc.setStroke((Paint)((Clock)this.getSkinnable()).getSecondColor());
        this.secondArc.setVisible(((Clock)this.getSkinnable()).isSecondsVisible());
        this.secondArc.setManaged(((Clock)this.getSkinnable()).isSecondsVisible());
        this.pane = new Pane(new Node[]{this.secondBackgroundCircle, this.dateText, this.hour, this.secondArc, this.minuteCircle, this.minute});
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Clock)this.getSkinnable()).getBackgroundPaint(), new CornerRadii(1024.0), new Insets(10.0))}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((Clock)this.getSkinnable()).widthProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Clock)this.getSkinnable()).heightProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Clock)this.getSkinnable()).setOnUpdate(e -> this.handleEvents(e.eventType.name()));
        if (((Clock)this.getSkinnable()).isAnimated()) {
            ((Clock)this.getSkinnable()).currentTimeProperty().addListener(o -> this.updateTime(ZonedDateTime.ofInstant(Instant.ofEpochSecond(((Clock)this.getSkinnable()).getCurrentTime()), ZoneId.of(ZoneId.systemDefault().getId()))));
        } else {
            ((Clock)this.getSkinnable()).timeProperty().addListener(o -> this.updateTime(((Clock)this.getSkinnable()).getTime()));
        }
        this.minuteAngle.addListener(o -> this.moveMinute(this.minuteAngle.get()));
    }

    protected double computeMinWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return super.computePrefWidth(HEIGHT, TOP, RIGHT, BOTTOM, LEFT);
    }

    protected double computePrefHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return super.computePrefHeight(WIDTH, TOP, RIGHT, BOTTOM, LEFT);
    }

    protected double computeMaxWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 1024.0;
    }

    protected double computeMaxHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 1024.0;
    }

    private void handleEvents(String EVENT_TYPE) {
        if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
            this.redraw();
        } else if ("REDRAW".equals(EVENT_TYPE)) {
            this.redraw();
        } else if ("VISIBILITY".equals(EVENT_TYPE)) {
            boolean isDateVisible = ((Clock)this.getSkinnable()).isDateVisible();
            this.dateText.setVisible(isDateVisible);
            this.dateText.setManaged(isDateVisible);
            boolean isSecondsVisible = ((Clock)this.getSkinnable()).isSecondsVisible();
            this.secondBackgroundCircle.setVisible(isSecondsVisible);
            this.secondBackgroundCircle.setManaged(isSecondsVisible);
            this.secondArc.setVisible(isSecondsVisible);
            this.secondArc.setManaged(isSecondsVisible);
        } else if ("FINISHED".equals(EVENT_TYPE)) {
            // empty if block
        }
    }

    public void updateTime(ZonedDateTime TIME) {
        if (this.dateText.isVisible()) {
            this.dateText.setText(DATE_TEXT_FORMATTER.format(TIME));
            Helper.adjustTextSize(this.dateText, 0.6 * this.size, this.size * 0.08);
            this.dateText.relocate((this.size - this.dateText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.22180451);
        }
        this.hour.setText(HOUR_FORMATTER.format(TIME));
        Helper.adjustTextSize(this.hour, 0.6 * this.size, 0.6 * this.size);
        this.hour.relocate((this.size - this.hour.getLayoutBounds().getWidth()) * 0.5, (this.size - this.hour.getLayoutBounds().getHeight()) * 0.65);
        this.minute.setText(MINUTE_FORMATTER.format(TIME));
        Helper.adjustTextSize(this.minute, 0.1 * this.size, 0.075 * this.size);
        if (this.minuteAngle.get() == -1.0) {
            this.moveMinute(6 * TIME.getMinute());
        }
        KeyValue kv1 = new KeyValue((WritableValue)this.minuteAngle, (Object)this.minuteAngle.get());
        KeyValue kv2 = new KeyValue((WritableValue)this.minuteAngle, (Object)(6 * TIME.getMinute()));
        KeyFrame kf1 = new KeyFrame(Duration.ZERO, new KeyValue[]{kv1});
        KeyFrame kf2 = new KeyFrame(Duration.millis((double)100.0), new KeyValue[]{kv2});
        this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{kf1, kf2});
        this.timeline.play();
        if (this.secondBackgroundCircle.isVisible()) {
            this.secondArc.setLength((double)(-6 * TIME.getSecond()));
            if (((Clock)this.getSkinnable()).isDiscreteSeconds()) {
                this.secondArc.setLength((double)(-6 * TIME.getSecond()));
            } else {
                this.secondArc.setLength((double)(-6 * TIME.getSecond()) - (double)TIME.get(ChronoField.MILLI_OF_SECOND) * 0.006);
            }
        }
    }

    private void moveMinute(double ANGLE) {
        double center = this.size * 0.5;
        double sinValue = Math.sin(Math.toRadians(-ANGLE + 180.0));
        double cosValue = Math.cos(Math.toRadians(-ANGLE + 180.0));
        this.minuteCircle.setCenterX(center + this.size * 0.45 * sinValue);
        this.minuteCircle.setCenterY(center + this.size * 0.45 * cosValue);
        this.minute.relocate(this.minuteCircle.getCenterX() - this.minute.getLayoutBounds().getWidth() * 0.5, this.minuteCircle.getCenterY() - this.minute.getLayoutBounds().getHeight() * 0.5);
    }

    private void resize() {
        double height;
        double width = ((Clock)this.getSkinnable()).getWidth() - ((Clock)this.getSkinnable()).getInsets().getLeft() - ((Clock)this.getSkinnable()).getInsets().getRight();
        double d = this.size = width < (height = ((Clock)this.getSkinnable()).getHeight() - ((Clock)this.getSkinnable()).getInsets().getTop() - ((Clock)this.getSkinnable()).getInsets().getBottom()) ? width : height;
        if (this.size > 0.0) {
            double center = this.size * 0.5;
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((((Clock)this.getSkinnable()).getWidth() - this.size) * 0.5, (((Clock)this.getSkinnable()).getHeight() - this.size) * 0.5);
            this.secondBackgroundCircle.setCenterX(center);
            this.secondBackgroundCircle.setCenterY(center);
            this.secondBackgroundCircle.setRadius(this.size * 0.45);
            this.secondBackgroundCircle.setStrokeWidth(this.size * 0.02819549);
            this.secondArc.setCenterX(center);
            this.secondArc.setCenterY(center);
            this.secondArc.setRadiusX(this.size * 0.45);
            this.secondArc.setRadiusY(this.size * 0.45);
            this.secondArc.setStrokeWidth(this.size * 0.02819549);
            this.dateText.setFont(Fonts.robotoLight(this.size * 0.08082707));
            this.hour.setFont(Fonts.robotoThin(this.size * 0.6));
            this.minute.setFont(Fonts.robotoRegular(this.size * 0.075));
            this.minuteCircle.setRadius(this.size * 0.075);
        }
    }

    private void redraw() {
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Clock)this.getSkinnable()).getBackgroundPaint(), new CornerRadii(1024.0), new Insets(this.size * 0.035))}));
        this.secondBackgroundCircle.setStroke((Paint)Helper.getTranslucentColorFrom(((Clock)this.getSkinnable()).getSecondColor(), 0.6));
        this.secondArc.setStroke((Paint)((Clock)this.getSkinnable()).getSecondColor());
        this.dateText.setFill((Paint)((Clock)this.getSkinnable()).getTextColor());
        this.hour.setFill((Paint)((Clock)this.getSkinnable()).getTextColor());
        this.minuteCircle.setFill((Paint)((Clock)this.getSkinnable()).getMinuteColor());
        this.minute.setFill((Paint)((Clock)this.getSkinnable()).getTextColor());
        ZonedDateTime time = ((Clock)this.getSkinnable()).getTime();
        this.updateTime(time);
    }
}

