/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.tools.Helper;
import eu.hansolo.medusa.tools.Statistics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.text.Text;

public class TileSparklineSkin
extends SkinBase<Gauge>
implements Skin<Gauge> {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double size;
    private Text titleText;
    private Text valueText;
    private Text unitText;
    private Text averageText;
    private Text highText;
    private Text lowText;
    private Rectangle graphBounds;
    private List<PathElement> pathElements;
    private Path sparkLine;
    private Circle dot;
    private Rectangle stdDeviationArea;
    private Line averageLine;
    private Pane pane;
    private double low;
    private double high;
    private double range;
    private double stdDeviation;
    private String formatString;
    private Locale locale;
    private int noOfDatapoints;
    private List<Double> dataList;

    public TileSparklineSkin(Gauge gauge) {
        super((Control)gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.low = gauge.getMaxValue();
        this.high = gauge.getMinValue();
        this.range = gauge.getRange();
        this.stdDeviation = 0.0;
        this.formatString = "%." + Integer.toString(gauge.getDecimals()) + "f";
        this.locale = gauge.getLocale();
        this.noOfDatapoints = gauge.getAveragingPeriod();
        this.dataList = new LinkedList<Double>();
        for (int i = 0; i < this.noOfDatapoints; ++i) {
            this.dataList.add(gauge.getMinValue());
        }
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(((Gauge)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((Gauge)this.getSkinnable()).getPrefWidth() > 0.0 && ((Gauge)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((Gauge)this.getSkinnable()).setPrefSize(((Gauge)this.getSkinnable()).getPrefWidth(), ((Gauge)this.getSkinnable()).getPrefHeight());
            } else {
                ((Gauge)this.getSkinnable()).setPrefSize(250.0, 250.0);
            }
        }
        this.graphBounds = new Rectangle(12.5, 125.0, 225.0, 112.5);
        this.titleText = new Text(((Gauge)this.getSkinnable()).getTitle());
        this.titleText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        Helper.enableNode((Node)this.titleText, !((Gauge)this.getSkinnable()).getTitle().isEmpty());
        this.valueText = new Text(String.format(this.locale, this.formatString, ((Gauge)this.getSkinnable()).getValue()));
        this.valueText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        Helper.enableNode((Node)this.valueText, ((Gauge)this.getSkinnable()).isValueVisible());
        this.unitText = new Text(((Gauge)this.getSkinnable()).getUnit());
        this.unitText.setFill((Paint)((Gauge)this.getSkinnable()).getUnitColor());
        Helper.enableNode((Node)this.unitText, !((Gauge)this.getSkinnable()).getUnit().isEmpty());
        this.averageText = new Text(String.format(this.locale, this.formatString, ((Gauge)this.getSkinnable()).getAverage()));
        this.averageText.setFill((Paint)((Gauge)this.getSkinnable()).getAverageColor());
        Helper.enableNode((Node)this.averageText, ((Gauge)this.getSkinnable()).isAverageVisible());
        this.highText = new Text();
        this.highText.setTextOrigin(VPos.BOTTOM);
        this.highText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        this.lowText = new Text();
        this.lowText.setTextOrigin(VPos.TOP);
        this.lowText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        this.stdDeviationArea = new Rectangle();
        Helper.enableNode((Node)this.stdDeviationArea, ((Gauge)this.getSkinnable()).isAverageVisible());
        this.averageLine = new Line();
        this.averageLine.setStroke((Paint)((Gauge)this.getSkinnable()).getAverageColor());
        this.averageLine.getStrokeDashArray().addAll((Object[])new Double[]{1.25, 1.25});
        Helper.enableNode((Node)this.averageLine, ((Gauge)this.getSkinnable()).isAverageVisible());
        this.pathElements = new ArrayList<PathElement>(this.noOfDatapoints);
        this.pathElements.add(0, (PathElement)new MoveTo());
        for (int i = 1; i < this.noOfDatapoints; ++i) {
            this.pathElements.add(i, (PathElement)new LineTo());
        }
        this.sparkLine = new Path();
        this.sparkLine.getElements().addAll(this.pathElements);
        this.sparkLine.setFill(null);
        this.sparkLine.setStroke((Paint)((Gauge)this.getSkinnable()).getBarColor());
        this.sparkLine.setStrokeWidth(1.875);
        this.sparkLine.setStrokeLineCap(StrokeLineCap.ROUND);
        this.sparkLine.setStrokeLineJoin(StrokeLineJoin.ROUND);
        this.dot = new Circle();
        this.dot.setFill((Paint)((Gauge)this.getSkinnable()).getBarColor());
        this.pane = new Pane(new Node[]{this.titleText, this.valueText, this.unitText, this.stdDeviationArea, this.averageLine, this.sparkLine, this.dot, this.averageText, this.highText, this.lowText});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Gauge)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(((Gauge)this.getSkinnable()).getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((Gauge)this.getSkinnable()).widthProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).heightProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).setOnUpdate(e -> this.handleEvents(e.eventType.name()));
        ((Gauge)this.getSkinnable()).currentValueProperty().addListener(o -> this.handleEvents("VALUE"));
    }

    protected double computeMinWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return super.computePrefWidth(HEIGHT, TOP, RIGHT, BOTTOM, LEFT);
    }

    protected double computePrefHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return super.computePrefHeight(WIDTH, TOP, RIGHT, BOTTOM, LEFT);
    }

    protected double computeMaxWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 1024.0;
    }

    protected double computeMaxHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 1024.0;
    }

    private void handleEvents(String EVENT_TYPE) {
        if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
            this.redraw();
        } else if ("REDRAW".equals(EVENT_TYPE)) {
            this.noOfDatapoints = ((Gauge)this.getSkinnable()).getAveragingPeriod();
            this.dataList.clear();
            for (int i = 0; i < this.noOfDatapoints; ++i) {
                this.dataList.add(0.0);
            }
            this.redraw();
        } else if ("RECALC".equals(EVENT_TYPE)) {
            this.range = ((Gauge)this.getSkinnable()).getRange();
            this.redraw();
        } else if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !((Gauge)this.getSkinnable()).getTitle().isEmpty());
            Helper.enableNode((Node)this.valueText, ((Gauge)this.getSkinnable()).isValueVisible());
            Helper.enableNode((Node)this.unitText, !((Gauge)this.getSkinnable()).getUnit().isEmpty());
            Helper.enableNode((Node)this.averageLine, ((Gauge)this.getSkinnable()).isAverageVisible());
            Helper.enableNode((Node)this.averageText, ((Gauge)this.getSkinnable()).isAverageVisible());
            Helper.enableNode((Node)this.stdDeviationArea, ((Gauge)this.getSkinnable()).isAverageVisible());
        } else if (!"SECTION".equals(EVENT_TYPE) && !"ALERT".equals(EVENT_TYPE) && "VALUE".equals(EVENT_TYPE)) {
            if (((Gauge)this.getSkinnable()).isAnimated()) {
                ((Gauge)this.getSkinnable()).setAnimated(false);
            }
            if (!((Gauge)this.getSkinnable()).isAveragingEnabled()) {
                ((Gauge)this.getSkinnable()).setAveragingEnabled(true);
            }
            double value = ((Gauge)this.getSkinnable()).getValue();
            this.addData(value);
            this.drawChart(value);
        }
    }

    private void addData(double VALUE) {
        if (this.dataList.size() <= this.noOfDatapoints) {
            Collections.rotate(this.dataList, -1);
            this.dataList.set(this.noOfDatapoints - 1, VALUE);
        } else {
            this.dataList.add(VALUE);
        }
        this.stdDeviation = Statistics.getStdDev(this.dataList);
    }

    private void drawChart(double VALUE) {
        this.low = Statistics.getMin(this.dataList);
        this.high = Statistics.getMax(this.dataList);
        if (Double.compare(this.low, this.high) == 0) {
            this.low = ((Gauge)this.getSkinnable()).getMinValue();
            this.high = ((Gauge)this.getSkinnable()).getMaxValue();
        }
        this.range = this.high - this.low;
        double minX = this.graphBounds.getX();
        double maxX = minX + this.graphBounds.getWidth();
        double minY = this.graphBounds.getY();
        double maxY = minY + this.graphBounds.getHeight();
        double stepX = this.graphBounds.getWidth() / (double)(this.noOfDatapoints - 1);
        double stepY = this.graphBounds.getHeight() / this.range;
        MoveTo begin = (MoveTo)this.pathElements.get(0);
        begin.setX(minX);
        begin.setY(maxY - Math.abs(this.low - this.dataList.get(0)) * stepY);
        for (int i = 1; i < this.noOfDatapoints - 1; ++i) {
            LineTo lineTo = (LineTo)this.pathElements.get(i);
            lineTo.setX(minX + (double)i * stepX);
            lineTo.setY(maxY - Math.abs(this.low - this.dataList.get(i)) * stepY);
        }
        LineTo end = (LineTo)this.pathElements.get(this.noOfDatapoints - 1);
        end.setX(maxX);
        end.setY(maxY - Math.abs(this.low - this.dataList.get(this.noOfDatapoints - 1)) * stepY);
        this.dot.setCenterX(maxX);
        this.dot.setCenterY(end.getY());
        double average = ((Gauge)this.getSkinnable()).getAverage();
        this.averageLine.setStartX(minX);
        this.averageLine.setEndX(maxX);
        this.averageLine.setStartY(maxY - Math.abs(this.low - average) * stepY);
        this.averageLine.setEndY(maxY - Math.abs(this.low - average) * stepY);
        this.stdDeviationArea.setY(this.averageLine.getStartY() - this.stdDeviation * 0.5 * stepY);
        this.stdDeviationArea.setHeight(this.stdDeviation * stepY);
        this.valueText.setText(String.format(this.locale, this.formatString, VALUE));
        this.averageText.setText(String.format(this.locale, this.formatString, average));
        this.highText.setText(String.format(this.locale, this.formatString, this.high));
        this.lowText.setText(String.format(this.locale, this.formatString, this.low));
        this.resizeDynamicText();
    }

    private void resizeDynamicText() {
        double maxWidth = 0.9 * this.size;
        double fontSize = 0.24 * this.size;
        this.valueText.setFont(Fonts.latoRegular(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
        this.valueText.relocate(this.size * 0.95 - this.valueText.getLayoutBounds().getWidth(), this.size * 0.12);
        fontSize = this.size * 0.05;
        this.averageText.setFont(Fonts.latoRegular(fontSize));
        if (this.averageText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.averageText, maxWidth, fontSize);
        }
        if (this.averageLine.getStartY() < this.graphBounds.getY() + this.graphBounds.getHeight() * 0.5) {
            this.averageText.setY(this.averageLine.getStartY() + this.size * 0.0425);
        } else {
            this.averageText.setY(this.averageLine.getStartY() - this.size * 0.0075);
        }
        this.highText.setFont(Fonts.latoRegular(fontSize));
        if (this.highText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.highText, maxWidth, fontSize);
        }
        this.highText.setY(this.graphBounds.getY() - this.size * 0.0125);
        this.lowText.setFont(Fonts.latoRegular(fontSize));
        if (this.lowText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.lowText, maxWidth, fontSize);
        }
        this.lowText.setY(this.size * 0.9);
    }

    private void resizeStaticText() {
        double maxWidth = 0.98 * this.size;
        double fontSize = this.size * 0.06;
        this.titleText.setFont(Fonts.latoRegular(fontSize));
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        this.titleText.relocate(this.size * 0.05, this.size * 0.05);
        this.unitText.setFont(Fonts.latoRegular(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        this.unitText.relocate(this.size * 0.95 - this.unitText.getLayoutBounds().getWidth(), this.size * 0.4);
        this.averageText.setX(this.size * 0.05);
        this.highText.setX(this.size * 0.05);
        this.lowText.setX(this.size * 0.05);
    }

    private void resize() {
        double height;
        double width = ((Gauge)this.getSkinnable()).getWidth() - ((Gauge)this.getSkinnable()).getInsets().getLeft() - ((Gauge)this.getSkinnable()).getInsets().getRight();
        double d = this.size = width < (height = ((Gauge)this.getSkinnable()).getHeight() - ((Gauge)this.getSkinnable()).getInsets().getTop() - ((Gauge)this.getSkinnable()).getInsets().getBottom()) ? width : height;
        if (width > 0.0 && height > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((width - this.size) * 0.5, (height - this.size) * 0.5);
            this.graphBounds = new Rectangle(this.size * 0.05, this.size * 0.5, this.size * 0.9, this.size * 0.39);
            this.stdDeviationArea.setX(this.graphBounds.getX());
            this.stdDeviationArea.setWidth(this.graphBounds.getWidth());
            this.averageLine.getStrokeDashArray().setAll((Object[])new Double[]{this.graphBounds.getWidth() * 0.01, this.graphBounds.getWidth() * 0.01});
            this.drawChart(((Gauge)this.getSkinnable()).getValue());
            this.sparkLine.setStrokeWidth(this.size * 0.01);
            this.dot.setRadius(this.size * 0.014);
            this.resizeStaticText();
            this.resizeDynamicText();
        }
    }

    private void redraw() {
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Gauge)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(((Gauge)this.getSkinnable()).getBorderWidth() / 250.0 * this.size))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), new CornerRadii(this.size * 0.025), Insets.EMPTY)}));
        this.locale = ((Gauge)this.getSkinnable()).getLocale();
        this.formatString = "%." + Integer.toString(((Gauge)this.getSkinnable()).getDecimals()) + "f";
        this.titleText.setText(((Gauge)this.getSkinnable()).getTitle());
        this.resizeStaticText();
        this.titleText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.valueText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        this.averageText.setFill((Paint)((Gauge)this.getSkinnable()).getAverageColor());
        this.highText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        this.lowText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        this.sparkLine.setStroke((Paint)((Gauge)this.getSkinnable()).getBarColor());
        this.stdDeviationArea.setFill((Paint)Helper.getTranslucentColorFrom(((Gauge)this.getSkinnable()).getAverageColor(), 0.1));
        this.averageLine.setStroke((Paint)((Gauge)this.getSkinnable()).getAverageColor());
        this.dot.setFill((Paint)((Gauge)this.getSkinnable()).getBarColor());
    }
}

