/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.LcdDesign;
import eu.hansolo.medusa.Marker;
import eu.hansolo.medusa.Needle;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.TickLabelLocation;
import eu.hansolo.medusa.TickLabelOrientation;
import eu.hansolo.medusa.TickMarkType;
import eu.hansolo.medusa.tools.AngleConicalGradient;
import eu.hansolo.medusa.tools.Helper;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;

public class QuarterSkin
extends SkinBase<Gauge>
implements Skin<Gauge> {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final double ANGLE_RANGE = 90.0;
    private Map<Marker, Shape> markerMap = new ConcurrentHashMap<Marker, Shape>();
    private double oldValue;
    private double size;
    private double centerX;
    private double centerY;
    private Pane pane;
    private InnerShadow backgroundInnerShadow;
    private Canvas sectionsAndAreasCanvas;
    private GraphicsContext sectionsAndAreasCtx;
    private Canvas tickMarkCanvas;
    private GraphicsContext tickMarkCtx;
    private double ledSize;
    private InnerShadow ledOnShadow;
    private InnerShadow ledOffShadow;
    private Paint ledFramePaint;
    private Paint ledOnPaint;
    private Paint ledOffPaint;
    private Paint ledHighlightPaint;
    private Canvas ledCanvas;
    private GraphicsContext ledCtx;
    private Pane markerPane;
    private Path threshold;
    private Rectangle lcd;
    private Path needle;
    private Rotate needleRotate;
    private Paint needlePaint;
    private Canvas knobCanvas;
    private GraphicsContext knobCtx;
    private Group shadowGroup;
    private DropShadow dropShadow;
    private Text titleText;
    private Text subTitleText;
    private Text unitText;
    private Text valueText;
    private double startAngle;
    private double angleStep;
    private EventHandler<MouseEvent> mouseHandler;
    private Tooltip buttonTooltip;
    private Tooltip thresholdTooltip;
    private String formatString;
    private Locale locale;
    private double minValue;
    private double maxValue;
    private List<Section> sections;
    private boolean highlightSections;
    private boolean sectionsVisible;
    private List<Section> areas;
    private boolean highlightAreas;
    private boolean areasVisible;
    private TickLabelLocation tickLabelLocation;
    private Gauge.ScaleDirection scaleDirection;

    public QuarterSkin(Gauge gauge) {
        super((Control)gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.startAngle = this.getStartAngle();
        this.angleStep = 90.0 / gauge.getRange();
        this.oldValue = gauge.getValue();
        this.minValue = gauge.getMinValue();
        this.maxValue = gauge.getMaxValue();
        this.formatString = "%." + Integer.toString(gauge.getDecimals()) + "f";
        this.locale = gauge.getLocale();
        this.sections = gauge.getSections();
        this.highlightSections = gauge.isHighlightSections();
        this.sectionsVisible = gauge.getSectionsVisible();
        this.areas = gauge.getAreas();
        this.highlightAreas = gauge.isHighlightAreas();
        this.areasVisible = gauge.getAreasVisible();
        this.tickLabelLocation = gauge.getTickLabelLocation();
        this.scaleDirection = gauge.getScaleDirection();
        this.mouseHandler = event -> this.handleMouseEvent((MouseEvent)event);
        this.updateMarkers();
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(((Gauge)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((Gauge)this.getSkinnable()).getPrefWidth() > 0.0 && ((Gauge)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((Gauge)this.getSkinnable()).setPrefSize(((Gauge)this.getSkinnable()).getPrefWidth(), ((Gauge)this.getSkinnable()).getPrefHeight());
            } else {
                ((Gauge)this.getSkinnable()).setPrefSize(250.0, 250.0);
            }
        }
        this.backgroundInnerShadow = new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)10, (int)10, (int)10, (double)0.45), 8.0, 0.0, 8.0, 0.0);
        this.sectionsAndAreasCanvas = new Canvas();
        this.sectionsAndAreasCtx = this.sectionsAndAreasCanvas.getGraphicsContext2D();
        Helper.enableNode((Node)this.sectionsAndAreasCanvas, this.areasVisible | this.sectionsVisible);
        this.tickMarkCanvas = new Canvas();
        this.tickMarkCtx = this.tickMarkCanvas.getGraphicsContext2D();
        this.ledCanvas = new Canvas();
        this.ledCtx = this.ledCanvas.getGraphicsContext2D();
        Helper.enableNode((Node)this.ledCanvas, ((Gauge)this.getSkinnable()).isLedVisible());
        this.thresholdTooltip = new Tooltip("Threshold\n(" + String.format(this.locale, this.formatString, ((Gauge)this.getSkinnable()).getThreshold()) + ")");
        this.thresholdTooltip.setTextAlignment(TextAlignment.CENTER);
        this.threshold = new Path();
        Helper.enableNode((Node)this.threshold, ((Gauge)this.getSkinnable()).isThresholdVisible());
        Tooltip.install((Node)this.threshold, (Tooltip)this.thresholdTooltip);
        this.markerPane = new Pane();
        this.lcd = new Rectangle(75.0, 3.5);
        this.lcd.setArcWidth(3.125);
        this.lcd.setArcHeight(3.125);
        this.lcd.relocate((250.0 - this.lcd.getWidth()) * 0.5, 110.0);
        this.lcd.setManaged(((Gauge)this.getSkinnable()).isLcdVisible());
        this.lcd.setVisible(((Gauge)this.getSkinnable()).isLcdVisible());
        Helper.enableNode((Node)this.lcd, ((Gauge)this.getSkinnable()).isLcdVisible() && ((Gauge)this.getSkinnable()).isValueVisible());
        this.needleRotate = new Rotate(180.0 - this.startAngle);
        this.needleRotate.setAngle(this.needleRotate.getAngle() + (((Gauge)this.getSkinnable()).getValue() - this.oldValue - this.minValue) * this.angleStep);
        this.needle = new Path();
        this.needle.setFillRule(FillRule.EVEN_ODD);
        this.needle.getTransforms().setAll((Object[])new Transform[]{this.needleRotate});
        this.needle.setStrokeType(StrokeType.INSIDE);
        this.needle.setStroke((Paint)Color.TRANSPARENT);
        this.buttonTooltip = new Tooltip();
        this.buttonTooltip.setTextAlignment(TextAlignment.CENTER);
        this.knobCanvas = new Canvas();
        this.knobCtx = this.knobCanvas.getGraphicsContext2D();
        this.knobCanvas.setPickOnBounds(false);
        Helper.enableNode((Node)this.knobCanvas, ((Gauge)this.getSkinnable()).isKnobVisible());
        this.dropShadow = new DropShadow();
        this.dropShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.25));
        this.dropShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.dropShadow.setRadius(3.75);
        this.dropShadow.setOffsetY(3.75);
        this.shadowGroup = new Group(new Node[]{this.needle, this.knobCanvas});
        this.shadowGroup.setEffect((Effect)(((Gauge)this.getSkinnable()).isShadowsEnabled() ? this.dropShadow : null));
        this.titleText = new Text(((Gauge)this.getSkinnable()).getTitle());
        this.titleText.setTextOrigin(VPos.CENTER);
        this.titleText.setMouseTransparent(true);
        Helper.enableNode((Node)this.titleText, !((Gauge)this.getSkinnable()).getTitle().isEmpty());
        this.subTitleText = new Text(((Gauge)this.getSkinnable()).getSubTitle());
        this.subTitleText.setTextOrigin(VPos.CENTER);
        this.subTitleText.setMouseTransparent(true);
        Helper.enableNode((Node)this.subTitleText, !((Gauge)this.getSkinnable()).getSubTitle().isEmpty());
        this.unitText = new Text(((Gauge)this.getSkinnable()).getUnit());
        this.unitText.setMouseTransparent(true);
        this.unitText.setTextOrigin(VPos.CENTER);
        this.unitText.setMouseTransparent(true);
        Helper.enableNode((Node)this.unitText, !((Gauge)this.getSkinnable()).getUnit().isEmpty());
        this.valueText = new Text(String.format(this.locale, this.formatString, ((Gauge)this.getSkinnable()).getValue()));
        this.valueText.setMouseTransparent(true);
        this.valueText.setTextOrigin(VPos.CENTER);
        this.valueText.setMouseTransparent(true);
        Helper.enableNode((Node)this.valueText, ((Gauge)this.getSkinnable()).isValueVisible());
        double targetAngle = 180.0 - this.startAngle + (((Gauge)this.getSkinnable()).getCurrentValue() - this.minValue) * this.angleStep;
        targetAngle = Helper.clamp(180.0 - this.startAngle, 180.0 - this.startAngle + 90.0, targetAngle);
        this.needleRotate.setAngle(targetAngle);
        this.pane = new Pane(new Node[]{this.sectionsAndAreasCanvas, this.tickMarkCanvas, this.markerPane, this.ledCanvas, this.lcd, this.titleText, this.subTitleText, this.unitText, this.valueText, this.shadowGroup});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Gauge)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(((Gauge)this.getSkinnable()).getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((Gauge)this.getSkinnable()).widthProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).heightProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).getMarkers().addListener(c -> {
            this.updateMarkers();
            this.redraw();
        });
        ((Gauge)this.getSkinnable()).setOnUpdate(e -> this.handleEvents(e.eventType.name()));
        ((Gauge)this.getSkinnable()).currentValueProperty().addListener(e -> this.rotateNeedle(((Gauge)this.getSkinnable()).getCurrentValue()));
        this.handleEvents("INTERACTIVITY");
        this.handleEvents("VISIBILITY");
    }

    protected double computeMinWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return super.computePrefWidth(HEIGHT, TOP, RIGHT, BOTTOM, LEFT);
    }

    protected double computePrefHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return super.computePrefHeight(WIDTH, TOP, RIGHT, BOTTOM, LEFT);
    }

    protected double computeMaxWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 1024.0;
    }

    protected double computeMaxHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 1024.0;
    }

    protected void handleEvents(String EVENT_TYPE) {
        if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
            this.redraw();
        } else if ("FINISHED".equals(EVENT_TYPE)) {
            int i;
            int listSize;
            double currentValue = ((Gauge)this.getSkinnable()).getCurrentValue();
            if (((Gauge)this.getSkinnable()).getCheckSectionsForValue()) {
                listSize = this.sections.size();
                for (i = 0; i < listSize; ++i) {
                    this.sections.get(i).checkForValue(currentValue);
                }
            }
            if (((Gauge)this.getSkinnable()).getCheckAreasForValue()) {
                listSize = this.areas.size();
                for (i = 0; i < listSize; ++i) {
                    this.areas.get(i).checkForValue(currentValue);
                }
            }
            if (this.highlightSections | this.highlightAreas) {
                this.sectionsAndAreasCtx.clearRect(0.0, 0.0, this.size * 1.9, this.size * 1.9);
                this.drawAreasAndSections(this.sectionsAndAreasCtx);
            }
        } else if ("REDRAW".equals(EVENT_TYPE)) {
            this.redraw();
        } else if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.ledCanvas, ((Gauge)this.getSkinnable()).isLedVisible());
            Helper.enableNode((Node)this.titleText, !((Gauge)this.getSkinnable()).getTitle().isEmpty());
            Helper.enableNode((Node)this.subTitleText, !((Gauge)this.getSkinnable()).getSubTitle().isEmpty());
            Helper.enableNode((Node)this.unitText, !((Gauge)this.getSkinnable()).getUnit().isEmpty());
            Helper.enableNode((Node)this.valueText, ((Gauge)this.getSkinnable()).isValueVisible());
            Helper.enableNode((Node)this.lcd, ((Gauge)this.getSkinnable()).isLcdVisible() && ((Gauge)this.getSkinnable()).isValueVisible());
            Helper.enableNode((Node)this.knobCanvas, ((Gauge)this.getSkinnable()).isKnobVisible());
            Helper.enableNode((Node)this.threshold, ((Gauge)this.getSkinnable()).isThresholdVisible());
            Helper.enableNode((Node)this.sectionsAndAreasCanvas, this.areasVisible | this.sectionsVisible);
            boolean markersVisible = ((Gauge)this.getSkinnable()).getMarkersVisible();
            for (Shape shape : this.markerMap.values()) {
                Helper.enableNode((Node)shape, markersVisible);
            }
            this.redraw();
        } else if ("LED".equals(EVENT_TYPE)) {
            if (((Gauge)this.getSkinnable()).isLedVisible()) {
                this.drawLed();
            }
        } else if ("LCD".equals(EVENT_TYPE)) {
            if (((Gauge)this.getSkinnable()).isLcdVisible()) {
                this.redraw();
            }
        } else if ("RECALC".equals(EVENT_TYPE)) {
            this.startAngle = this.getStartAngle();
            if (((Gauge)this.getSkinnable()).isAutoScale()) {
                ((Gauge)this.getSkinnable()).calcAutoScale();
            }
            this.minValue = ((Gauge)this.getSkinnable()).getMinValue();
            this.maxValue = ((Gauge)this.getSkinnable()).getMaxValue();
            this.angleStep = 90.0 / ((Gauge)this.getSkinnable()).getRange();
            this.needleRotate.setAngle(180.0 - this.startAngle + (((Gauge)this.getSkinnable()).getValue() - this.minValue) * this.angleStep);
            if (((Gauge)this.getSkinnable()).getValue() < this.minValue) {
                ((Gauge)this.getSkinnable()).setValue(this.minValue);
                this.oldValue = this.minValue;
            }
            if (((Gauge)this.getSkinnable()).getValue() > this.maxValue) {
                ((Gauge)this.getSkinnable()).setValue(this.maxValue);
                this.oldValue = this.maxValue;
            }
            this.resize();
            this.redraw();
        } else if ("SECTION".equals(EVENT_TYPE)) {
            this.sections = ((Gauge)this.getSkinnable()).getSections();
            this.highlightSections = ((Gauge)this.getSkinnable()).isHighlightSections();
            this.sectionsVisible = ((Gauge)this.getSkinnable()).getSectionsVisible();
            this.areas = ((Gauge)this.getSkinnable()).getAreas();
            this.highlightAreas = ((Gauge)this.getSkinnable()).isHighlightAreas();
            this.areasVisible = ((Gauge)this.getSkinnable()).getAreasVisible();
            this.resize();
            this.redraw();
        } else if ("INTERACTIVITY".equals(EVENT_TYPE)) {
            if (((Gauge)this.getSkinnable()).isInteractive()) {
                this.knobCanvas.setOnMousePressed(this.mouseHandler);
                this.knobCanvas.setOnMouseReleased(this.mouseHandler);
                if (!((Gauge)this.getSkinnable()).getButtonTooltipText().isEmpty()) {
                    this.buttonTooltip.setText(((Gauge)this.getSkinnable()).getButtonTooltipText());
                    Tooltip.install((Node)this.knobCanvas, (Tooltip)this.buttonTooltip);
                }
            } else {
                this.knobCanvas.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
                this.knobCanvas.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseHandler);
                Tooltip.uninstall((Node)this.knobCanvas, (Tooltip)this.buttonTooltip);
            }
        }
    }

    public void handleMouseEvent(MouseEvent EVENT) {
        if (((Gauge)this.getSkinnable()).isDisabled()) {
            return;
        }
        EventType TYPE = EVENT.getEventType();
        if (MouseEvent.MOUSE_PRESSED == TYPE) {
            ((Gauge)this.getSkinnable()).fireEvent(((Gauge)this.getSkinnable()).BTN_PRESSED_EVENT);
            this.drawKnob(true);
        } else if (MouseEvent.MOUSE_RELEASED == TYPE) {
            ((Gauge)this.getSkinnable()).fireEvent(((Gauge)this.getSkinnable()).BTN_RELEASED_EVENT);
            this.drawKnob(false);
        }
    }

    private double getStartAngle() {
        Gauge.ScaleDirection scaleDirection = ((Gauge)this.getSkinnable()).getScaleDirection();
        Pos knobPosition = ((Gauge)this.getSkinnable()).getKnobPosition();
        switch (knobPosition) {
            case BOTTOM_LEFT: {
                return Gauge.ScaleDirection.CLOCKWISE == scaleDirection ? 180.0 : 90.0;
            }
            case TOP_LEFT: {
                return Gauge.ScaleDirection.CLOCKWISE == scaleDirection ? 90.0 : 0.0;
            }
            case TOP_RIGHT: {
                return Gauge.ScaleDirection.CLOCKWISE == scaleDirection ? 0.0 : 270.0;
            }
        }
        return Gauge.ScaleDirection.CLOCKWISE == scaleDirection ? 270.0 : 180.0;
    }

    private void rotateNeedle(double VALUE) {
        double targetAngle;
        double startOffsetAngle = 180.0 - this.startAngle;
        if (Gauge.ScaleDirection.CLOCKWISE == ((Gauge)this.getSkinnable()).getScaleDirection()) {
            targetAngle = startOffsetAngle + (VALUE - this.minValue) * this.angleStep;
            targetAngle = Helper.clamp(startOffsetAngle, startOffsetAngle + 90.0, targetAngle);
        } else {
            targetAngle = startOffsetAngle - (VALUE - this.minValue) * this.angleStep;
            targetAngle = Helper.clamp(startOffsetAngle - 90.0, startOffsetAngle, targetAngle);
        }
        this.needleRotate.setAngle(targetAngle);
        this.valueText.setText(String.format(this.locale, this.formatString, VALUE));
        this.resizeValueText();
    }

    private void drawTickMarks() {
        double minorHalfDotSize;
        double minorDotSize;
        double mediumHalfDotSize;
        double mediumDotSize;
        double majorHalfDotSize;
        double majorDotSize;
        double orthTextFactor;
        double textDisplacementFactor;
        List<String> customTickLabels;
        this.tickMarkCtx.setLineCap(StrokeLineCap.BUTT);
        double scaledSize = this.size * 1.95;
        int tickLabelDecimals = ((Gauge)this.getSkinnable()).getTickLabelDecimals();
        String tickLabelFormatString = "%." + tickLabelDecimals + "f";
        double minorTickSpace = ((Gauge)this.getSkinnable()).getMinorTickSpace();
        double tmpAngleStep = this.angleStep * minorTickSpace;
        TickLabelOrientation tickLabelOrientation = ((Gauge)this.getSkinnable()).getTickLabelOrientation();
        TickLabelLocation tickLabelLocation = ((Gauge)this.getSkinnable()).getTickLabelLocation();
        BigDecimal minorTickSpaceBD = BigDecimal.valueOf(minorTickSpace);
        BigDecimal majorTickSpaceBD = BigDecimal.valueOf(((Gauge)this.getSkinnable()).getMajorTickSpace());
        BigDecimal mediumCheck2 = BigDecimal.valueOf(2.0 * minorTickSpace);
        BigDecimal mediumCheck5 = BigDecimal.valueOf(5.0 * minorTickSpace);
        BigDecimal counterBD = BigDecimal.valueOf(this.minValue);
        double counter = this.minValue;
        ObservableList<Section> tickMarkSections = ((Gauge)this.getSkinnable()).getTickMarkSections();
        ObservableList<Section> tickLabelSections = ((Gauge)this.getSkinnable()).getTickLabelSections();
        Color tickMarkColor = ((Gauge)this.getSkinnable()).getTickMarkColor();
        Color majorTickMarkColor = ((Gauge)this.getSkinnable()).getMajorTickMarkColor().equals((Object)tickMarkColor) ? tickMarkColor : ((Gauge)this.getSkinnable()).getMajorTickMarkColor();
        Color mediumTickMarkColor = ((Gauge)this.getSkinnable()).getMediumTickMarkColor().equals((Object)tickMarkColor) ? tickMarkColor : ((Gauge)this.getSkinnable()).getMediumTickMarkColor();
        Color minorTickMarkColor = ((Gauge)this.getSkinnable()).getMinorTickMarkColor().equals((Object)tickMarkColor) ? tickMarkColor : ((Gauge)this.getSkinnable()).getMinorTickMarkColor();
        Color tickLabelColor = ((Gauge)this.getSkinnable()).getTickLabelColor();
        Color zeroColor = ((Gauge)this.getSkinnable()).getZeroColor();
        boolean isNotZero = true;
        TickMarkType majorTickMarkType = ((Gauge)this.getSkinnable()).getMajorTickMarkType();
        TickMarkType mediumTickMarkType = ((Gauge)this.getSkinnable()).getMediumTickMarkType();
        TickMarkType minorTickMarkType = ((Gauge)this.getSkinnable()).getMinorTickMarkType();
        boolean tickMarkSectionsVisible = ((Gauge)this.getSkinnable()).getTickMarkSectionsVisible();
        boolean tickLabelSectionsVisible = ((Gauge)this.getSkinnable()).getTickLabelSectionsVisible();
        boolean majorTickMarksVisible = ((Gauge)this.getSkinnable()).getMajorTickMarksVisible();
        boolean mediumTickMarksVisible = ((Gauge)this.getSkinnable()).getMediumTickMarksVisible();
        boolean minorTickMarksVisible = ((Gauge)this.getSkinnable()).getMinorTickMarksVisible();
        boolean tickLabelsVisible = ((Gauge)this.getSkinnable()).getTickLabelsVisible();
        boolean onlyFirstAndLastLabelVisible = ((Gauge)this.getSkinnable()).isOnlyFirstAndLastTickLabelVisible();
        boolean customTickLabelsEnabled = ((Gauge)this.getSkinnable()).getCustomTickLabelsEnabled();
        List<String> list = customTickLabels = customTickLabelsEnabled ? ((Gauge)this.getSkinnable()).getCustomTickLabels() : null;
        double d = majorTickMarkType == TickMarkType.DOT ? (TickLabelLocation.OUTSIDE == tickLabelLocation ? 0.95 : 1.05) : (textDisplacementFactor = 1.0);
        if (TickLabelLocation.OUTSIDE == tickLabelLocation) {
            orthTextFactor = 0.45 * textDisplacementFactor;
            majorDotSize = 0.02 * this.size;
            majorHalfDotSize = majorDotSize * 0.5;
            mediumDotSize = 0.01375 * this.size;
            mediumHalfDotSize = mediumDotSize * 0.5;
            minorDotSize = 0.0075 * this.size;
            minorHalfDotSize = minorDotSize * 0.5;
        } else {
            orthTextFactor = TickLabelOrientation.ORTHOGONAL == tickLabelOrientation ? 0.4 * textDisplacementFactor : 0.39 * textDisplacementFactor;
            majorDotSize = 0.025 * this.size;
            majorHalfDotSize = majorDotSize * 0.5;
            mediumDotSize = 0.01875 * this.size;
            mediumHalfDotSize = mediumDotSize * 0.5;
            minorDotSize = 0.0125 * this.size;
            minorHalfDotSize = minorDotSize * 0.5;
        }
        boolean fullRange = this.minValue < 0.0 && this.maxValue > 0.0;
        double tickLabelFontSize = tickLabelDecimals == 0 ? 0.074 * this.size : 0.071 * this.size;
        double tickMarkFontSize = tickLabelDecimals == 0 ? 0.067 * this.size : 0.064 * this.size;
        double tickLabelOrientationFactor = TickLabelOrientation.HORIZONTAL == tickLabelOrientation ? 0.9 : 1.0;
        Font tickLabelFont = Fonts.robotoCondensedRegular(tickLabelFontSize * tickLabelOrientationFactor);
        Font tickMarkFont = Fonts.robotoCondensedRegular(tickMarkFontSize * tickLabelOrientationFactor);
        Font tickLabelZeroFont = fullRange ? Fonts.robotoCondensedBold(tickLabelFontSize * tickLabelOrientationFactor) : tickLabelFont;
        Font tickMarkZeroFont = fullRange ? Fonts.robotoCondensedBold(tickMarkFontSize * tickLabelOrientationFactor) : tickMarkFont;
        Gauge.ScaleDirection scaleDirection = ((Gauge)this.getSkinnable()).getScaleDirection();
        if (((Gauge)this.getSkinnable()).isTickMarkRingVisible()) {
            Pos knobPosition = ((Gauge)this.getSkinnable()).getKnobPosition();
            double xy = TickLabelLocation.INSIDE == tickLabelLocation ? scaledSize * 0.0125 : scaledSize * 0.1285;
            double wh = TickLabelLocation.INSIDE == tickLabelLocation ? scaledSize * 0.948 : scaledSize * 0.716;
            double offset = -90.0 + this.startAngle;
            this.tickMarkCtx.setLineWidth(scaledSize * 0.004);
            this.tickMarkCtx.setLineCap(StrokeLineCap.SQUARE);
            this.tickMarkCtx.save();
            this.tickMarkCtx.setStroke((Paint)tickMarkColor);
            switch (knobPosition) {
                case BOTTOM_LEFT: {
                    this.tickMarkCtx.strokeArc(-scaledSize * 0.46 + xy, xy, wh, wh, offset, -90.0, ArcType.OPEN);
                    break;
                }
                case TOP_LEFT: {
                    this.tickMarkCtx.strokeArc(-scaledSize * 0.46 + xy, -scaledSize * 0.46 + xy, wh, wh, offset, -90.0, ArcType.OPEN);
                    break;
                }
                case TOP_RIGHT: {
                    this.tickMarkCtx.strokeArc(xy, -scaledSize * 0.46 + xy, wh, wh, offset, -90.0, ArcType.OPEN);
                    break;
                }
                default: {
                    this.tickMarkCtx.strokeArc(xy, xy, wh, wh, offset, -90.0, ArcType.OPEN);
                }
            }
            this.tickMarkCtx.restore();
            if (tickMarkSections.size() > 0) {
                this.tickMarkCtx.setLineCap(StrokeLineCap.BUTT);
                int listSize = tickMarkSections.size();
                for (int i = 0; i < listSize; ++i) {
                    double sectionStartAngle;
                    Section section = (Section)tickMarkSections.get(i);
                    if (Double.compare(section.getStart(), this.minValue) < 0 && Double.compare(section.getStop(), this.maxValue) < 0) {
                        sectionStartAngle = 0.0;
                    } else {
                        double d2 = sectionStartAngle = Gauge.ScaleDirection.CLOCKWISE == scaleDirection ? (section.getStart() - this.minValue) * this.angleStep : -(section.getStart() - this.minValue) * this.angleStep;
                    }
                    double sectionAngleExtend = Double.compare(section.getStop(), this.maxValue) > 0 ? (Gauge.ScaleDirection.CLOCKWISE == scaleDirection ? (this.maxValue - section.getStart()) * this.angleStep : -(this.maxValue - section.getStart()) * this.angleStep) : (Gauge.ScaleDirection.CLOCKWISE == scaleDirection ? (section.getStop() - section.getStart()) * this.angleStep : -(section.getStop() - section.getStart()) * this.angleStep);
                    this.tickMarkCtx.save();
                    this.tickMarkCtx.setStroke((Paint)section.getColor());
                    switch (knobPosition) {
                        case BOTTOM_LEFT: {
                            this.tickMarkCtx.strokeArc(-scaledSize * 0.46 + xy, xy, wh, wh, offset - sectionStartAngle, -sectionAngleExtend, ArcType.OPEN);
                            break;
                        }
                        case TOP_LEFT: {
                            this.tickMarkCtx.strokeArc(-scaledSize * 0.46 + xy, -scaledSize * 0.46 + xy, wh, wh, offset - sectionStartAngle, -sectionAngleExtend, ArcType.OPEN);
                            break;
                        }
                        case TOP_RIGHT: {
                            this.tickMarkCtx.strokeArc(xy, -scaledSize * 0.46 + xy, wh, wh, offset - sectionStartAngle, -sectionAngleExtend, ArcType.OPEN);
                            break;
                        }
                        default: {
                            this.tickMarkCtx.strokeArc(xy, xy, wh, wh, offset - sectionStartAngle, -sectionAngleExtend, ArcType.OPEN);
                        }
                    }
                    this.tickMarkCtx.restore();
                }
            }
        }
        BigDecimal tmpStepBD = new BigDecimal(tmpAngleStep);
        tmpStepBD = tmpStepBD.setScale(3, 4);
        double tmpStep = tmpStepBD.doubleValue();
        double angle = 0.0;
        int customTickLabelCounter = 0;
        double i = 0.0;
        while (Double.compare(-90.0 - tmpStep, i) <= 0) {
            double trapezoidMinorOuterPoint2Y;
            double trapezoidMinorOuterPoint2X;
            double trapezoidMinorOuterPoint1Y;
            double trapezoidMinorOuterPoint1X;
            double trapezoidMinorInnerPoint2Y;
            double trapezoidMinorInnerPoint2X;
            double trapezoidMinorInnerPoint1Y;
            double trapezoidMinorInnerPoint1X;
            double trapezoidMediumOuterPoint2Y;
            double trapezoidMediumOuterPoint2X;
            double trapezoidMediumOuterPoint1Y;
            double trapezoidMediumOuterPoint1X;
            double trapezoidMediumInnerPoint2Y;
            double trapezoidMediumInnerPoint2X;
            double trapezoidMediumInnerPoint1Y;
            double trapezoidMediumInnerPoint1X;
            double trapezoidMajorOuterPoint2Y;
            double trapezoidMajorOuterPoint2X;
            double trapezoidMajorOuterPoint1Y;
            double trapezoidMajorOuterPoint1X;
            double trapezoidMajorInnerPoint2Y;
            double trapezoidMajorInnerPoint2X;
            double trapezoidMajorInnerPoint1Y;
            double trapezoidMajorInnerPoint1X;
            double tickLabelTickMarkY;
            double tickLabelTickMarkX;
            double dotMinorCenterY;
            double dotMinorCenterX;
            double dotMediumCenterY;
            double dotMediumCenterX;
            double dotCenterY;
            double dotCenterX;
            double textPointY;
            double textPointX;
            double outerMinorPointY;
            double outerMinorPointX;
            double outerMediumPointY;
            double outerMediumPointX;
            double outerPointY;
            double outerPointX;
            double innerMinorPointY;
            double innerMinorPointX;
            double innerMediumPointY;
            double innerMediumPointX;
            double innerPointY;
            double innerPointX;
            double sinValue = Math.sin(Math.toRadians(angle + this.startAngle));
            double cosValue = Math.cos(Math.toRadians(angle + this.startAngle));
            switch (tickLabelLocation) {
                case OUTSIDE: {
                    innerPointX = this.centerX + scaledSize * 0.3585 * sinValue;
                    innerPointY = this.centerY + scaledSize * 0.3585 * cosValue;
                    innerMediumPointX = this.centerX + scaledSize * 0.3585 * sinValue;
                    innerMediumPointY = this.centerY + scaledSize * 0.3585 * cosValue;
                    innerMinorPointX = this.centerX + scaledSize * 0.3585 * sinValue;
                    innerMinorPointY = this.centerY + scaledSize * 0.3585 * cosValue;
                    outerPointX = this.centerX + scaledSize * 0.4105 * sinValue;
                    outerPointY = this.centerY + scaledSize * 0.4105 * cosValue;
                    outerMediumPointX = this.centerX + scaledSize * 0.4045 * sinValue;
                    outerMediumPointY = this.centerY + scaledSize * 0.4045 * cosValue;
                    outerMinorPointX = this.centerX + scaledSize * 0.3975 * sinValue;
                    outerMinorPointY = this.centerY + scaledSize * 0.3975 * cosValue;
                    textPointX = this.centerX + scaledSize * orthTextFactor * sinValue;
                    textPointY = this.centerY + scaledSize * orthTextFactor * cosValue;
                    dotCenterX = this.centerX + scaledSize * 0.3685 * sinValue;
                    dotCenterY = this.centerY + scaledSize * 0.3685 * cosValue;
                    dotMediumCenterX = this.centerX + scaledSize * 0.365375 * sinValue;
                    dotMediumCenterY = this.centerY + scaledSize * 0.365375 * cosValue;
                    dotMinorCenterX = this.centerX + scaledSize * 0.36225 * sinValue;
                    dotMinorCenterY = this.centerY + scaledSize * 0.36225 * cosValue;
                    tickLabelTickMarkX = this.centerX + scaledSize * 0.3805 * sinValue;
                    tickLabelTickMarkY = this.centerY + scaledSize * 0.3805 * cosValue;
                    double trapezoidMajorInnerAngle1 = Math.toRadians(angle - 1.2 + this.startAngle);
                    double trapezoidMajorInnerAngle2 = Math.toRadians(angle + 1.2 + this.startAngle);
                    double trapezoidMajorOuterAngle1 = Math.toRadians(angle - 0.8 + this.startAngle);
                    double trapezoidMajorOuterAngle2 = Math.toRadians(angle + 0.8 + this.startAngle);
                    trapezoidMajorInnerPoint1X = this.centerX + scaledSize * 0.3585 * Math.sin(trapezoidMajorInnerAngle1);
                    trapezoidMajorInnerPoint1Y = this.centerY + scaledSize * 0.3585 * Math.cos(trapezoidMajorInnerAngle1);
                    trapezoidMajorInnerPoint2X = this.centerX + scaledSize * 0.3585 * Math.sin(trapezoidMajorInnerAngle2);
                    trapezoidMajorInnerPoint2Y = this.centerY + scaledSize * 0.3585 * Math.cos(trapezoidMajorInnerAngle2);
                    trapezoidMajorOuterPoint1X = this.centerX + scaledSize * 0.4105 * Math.sin(trapezoidMajorOuterAngle1);
                    trapezoidMajorOuterPoint1Y = this.centerY + scaledSize * 0.4105 * Math.cos(trapezoidMajorOuterAngle1);
                    trapezoidMajorOuterPoint2X = this.centerX + scaledSize * 0.4105 * Math.sin(trapezoidMajorOuterAngle2);
                    trapezoidMajorOuterPoint2Y = this.centerY + scaledSize * 0.4105 * Math.cos(trapezoidMajorOuterAngle2);
                    double trapezoidMediumInnerAngle1 = Math.toRadians(angle - 1.0 + this.startAngle);
                    double trapezoidMediumInnerAngle2 = Math.toRadians(angle + 1.0 + this.startAngle);
                    double trapezoidMediumOuterAngle1 = Math.toRadians(angle - 0.7 + this.startAngle);
                    double trapezoidMediumOuterAngle2 = Math.toRadians(angle + 0.7 + this.startAngle);
                    trapezoidMediumInnerPoint1X = this.centerX + scaledSize * 0.3585 * Math.sin(trapezoidMediumInnerAngle1);
                    trapezoidMediumInnerPoint1Y = this.centerY + scaledSize * 0.3585 * Math.cos(trapezoidMediumInnerAngle1);
                    trapezoidMediumInnerPoint2X = this.centerX + scaledSize * 0.3585 * Math.sin(trapezoidMediumInnerAngle2);
                    trapezoidMediumInnerPoint2Y = this.centerY + scaledSize * 0.3585 * Math.cos(trapezoidMediumInnerAngle2);
                    trapezoidMediumOuterPoint1X = this.centerX + scaledSize * 0.3985 * Math.sin(trapezoidMajorOuterAngle1);
                    trapezoidMediumOuterPoint1Y = this.centerY + scaledSize * 0.3985 * Math.cos(trapezoidMediumOuterAngle1);
                    trapezoidMediumOuterPoint2X = this.centerX + scaledSize * 0.3985 * Math.sin(trapezoidMediumOuterAngle2);
                    trapezoidMediumOuterPoint2Y = this.centerY + scaledSize * 0.3985 * Math.cos(trapezoidMediumOuterAngle2);
                    double trapezoidMinorInnerAngle1 = Math.toRadians(angle - 0.8 + this.startAngle);
                    double trapezoidMinorInnerAngle2 = Math.toRadians(angle + 0.8 + this.startAngle);
                    double trapezoidMinorOuterAngle1 = Math.toRadians(angle - 0.6 + this.startAngle);
                    double trapezoidMinorOuterAngle2 = Math.toRadians(angle + 0.6 + this.startAngle);
                    trapezoidMinorInnerPoint1X = this.centerX + scaledSize * 0.3585 * Math.sin(trapezoidMinorInnerAngle1);
                    trapezoidMinorInnerPoint1Y = this.centerY + scaledSize * 0.3585 * Math.cos(trapezoidMinorInnerAngle1);
                    trapezoidMinorInnerPoint2X = this.centerX + scaledSize * 0.3585 * Math.sin(trapezoidMinorInnerAngle2);
                    trapezoidMinorInnerPoint2Y = this.centerY + scaledSize * 0.3585 * Math.cos(trapezoidMinorInnerAngle2);
                    trapezoidMinorOuterPoint1X = this.centerX + scaledSize * 0.3975 * Math.sin(trapezoidMinorOuterAngle1);
                    trapezoidMinorOuterPoint1Y = this.centerY + scaledSize * 0.3975 * Math.cos(trapezoidMinorOuterAngle1);
                    trapezoidMinorOuterPoint2X = this.centerX + scaledSize * 0.3975 * Math.sin(trapezoidMinorOuterAngle2);
                    trapezoidMinorOuterPoint2Y = this.centerY + scaledSize * 0.3975 * Math.cos(trapezoidMinorOuterAngle2);
                    break;
                }
                default: {
                    innerPointX = this.centerX + scaledSize * 0.423 * sinValue;
                    innerPointY = this.centerY + scaledSize * 0.423 * cosValue;
                    innerMediumPointX = this.centerX + scaledSize * 0.43 * sinValue;
                    innerMediumPointY = this.centerY + scaledSize * 0.43 * cosValue;
                    innerMinorPointX = this.centerX + scaledSize * 0.436 * sinValue;
                    innerMinorPointY = this.centerY + scaledSize * 0.436 * cosValue;
                    outerPointX = this.centerX + scaledSize * 0.475 * sinValue;
                    outerPointY = this.centerY + scaledSize * 0.475 * cosValue;
                    outerMediumPointX = this.centerX + scaledSize * 0.475 * sinValue;
                    outerMediumPointY = this.centerY + scaledSize * 0.475 * cosValue;
                    outerMinorPointX = this.centerX + scaledSize * 0.475 * sinValue;
                    outerMinorPointY = this.centerY + scaledSize * 0.475 * cosValue;
                    textPointX = this.centerX + scaledSize * orthTextFactor * sinValue;
                    textPointY = this.centerY + scaledSize * orthTextFactor * cosValue;
                    dotCenterX = this.centerX + scaledSize * 0.4625 * sinValue;
                    dotCenterY = this.centerY + scaledSize * 0.4625 * cosValue;
                    dotMediumCenterX = this.centerX + scaledSize * 0.465625 * sinValue;
                    dotMediumCenterY = this.centerY + scaledSize * 0.465625 * cosValue;
                    dotMinorCenterX = this.centerX + scaledSize * 0.46875 * sinValue;
                    dotMinorCenterY = this.centerY + scaledSize * 0.46875 * cosValue;
                    tickLabelTickMarkX = this.centerX + scaledSize * 0.445 * sinValue;
                    tickLabelTickMarkY = this.centerY + scaledSize * 0.445 * cosValue;
                    double trapezoidMajorInnerAngle1 = Math.toRadians(angle - 0.8 + this.startAngle);
                    double trapezoidMajorInnerAngle2 = Math.toRadians(angle + 0.8 + this.startAngle);
                    double trapezoidMajorOuterAngle1 = Math.toRadians(angle - 1.2 + this.startAngle);
                    double trapezoidMajorOuterAngle2 = Math.toRadians(angle + 1.2 + this.startAngle);
                    trapezoidMajorInnerPoint1X = this.centerX + scaledSize * 0.423 * Math.sin(trapezoidMajorInnerAngle1);
                    trapezoidMajorInnerPoint1Y = this.centerY + scaledSize * 0.423 * Math.cos(trapezoidMajorInnerAngle1);
                    trapezoidMajorInnerPoint2X = this.centerX + scaledSize * 0.423 * Math.sin(trapezoidMajorInnerAngle2);
                    trapezoidMajorInnerPoint2Y = this.centerY + scaledSize * 0.423 * Math.cos(trapezoidMajorInnerAngle2);
                    trapezoidMajorOuterPoint1X = this.centerX + scaledSize * 0.475 * Math.sin(trapezoidMajorOuterAngle1);
                    trapezoidMajorOuterPoint1Y = this.centerY + scaledSize * 0.475 * Math.cos(trapezoidMajorOuterAngle1);
                    trapezoidMajorOuterPoint2X = this.centerX + scaledSize * 0.475 * Math.sin(trapezoidMajorOuterAngle2);
                    trapezoidMajorOuterPoint2Y = this.centerY + scaledSize * 0.475 * Math.cos(trapezoidMajorOuterAngle2);
                    double trapezoidMediumInnerAngle1 = Math.toRadians(angle - 0.7 + this.startAngle);
                    double trapezoidMediumInnerAngle2 = Math.toRadians(angle + 0.7 + this.startAngle);
                    double trapezoidMediumOuterAngle1 = Math.toRadians(angle - 1.0 + this.startAngle);
                    double trapezoidMediumOuterAngle2 = Math.toRadians(angle + 1.0 + this.startAngle);
                    trapezoidMediumInnerPoint1X = this.centerX + scaledSize * 0.435 * Math.sin(trapezoidMediumInnerAngle1);
                    trapezoidMediumInnerPoint1Y = this.centerY + scaledSize * 0.435 * Math.cos(trapezoidMediumInnerAngle1);
                    trapezoidMediumInnerPoint2X = this.centerX + scaledSize * 0.435 * Math.sin(trapezoidMediumInnerAngle2);
                    trapezoidMediumInnerPoint2Y = this.centerY + scaledSize * 0.435 * Math.cos(trapezoidMediumInnerAngle2);
                    trapezoidMediumOuterPoint1X = this.centerX + scaledSize * 0.475 * Math.sin(trapezoidMajorOuterAngle1);
                    trapezoidMediumOuterPoint1Y = this.centerY + scaledSize * 0.475 * Math.cos(trapezoidMediumOuterAngle1);
                    trapezoidMediumOuterPoint2X = this.centerX + scaledSize * 0.475 * Math.sin(trapezoidMediumOuterAngle2);
                    trapezoidMediumOuterPoint2Y = this.centerY + scaledSize * 0.475 * Math.cos(trapezoidMediumOuterAngle2);
                    double trapezoidMinorInnerAngle1 = Math.toRadians(angle - 0.6 + this.startAngle);
                    double trapezoidMinorInnerAngle2 = Math.toRadians(angle + 0.6 + this.startAngle);
                    double trapezoidMinorOuterAngle1 = Math.toRadians(angle - 0.8 + this.startAngle);
                    double trapezoidMinorOuterAngle2 = Math.toRadians(angle + 0.8 + this.startAngle);
                    trapezoidMinorInnerPoint1X = this.centerX + scaledSize * 0.44 * Math.sin(trapezoidMinorInnerAngle1);
                    trapezoidMinorInnerPoint1Y = this.centerY + scaledSize * 0.44 * Math.cos(trapezoidMinorInnerAngle1);
                    trapezoidMinorInnerPoint2X = this.centerX + scaledSize * 0.44 * Math.sin(trapezoidMinorInnerAngle2);
                    trapezoidMinorInnerPoint2Y = this.centerY + scaledSize * 0.44 * Math.cos(trapezoidMinorInnerAngle2);
                    trapezoidMinorOuterPoint1X = this.centerX + scaledSize * 0.475 * Math.sin(trapezoidMinorOuterAngle1);
                    trapezoidMinorOuterPoint1Y = this.centerY + scaledSize * 0.475 * Math.cos(trapezoidMinorOuterAngle1);
                    trapezoidMinorOuterPoint2X = this.centerX + scaledSize * 0.475 * Math.sin(trapezoidMinorOuterAngle2);
                    trapezoidMinorOuterPoint2Y = this.centerY + scaledSize * 0.475 * Math.cos(trapezoidMinorOuterAngle2);
                }
            }
            this.tickMarkCtx.setStroke((Paint)tickMarkColor);
            this.tickMarkCtx.setFill((Paint)tickMarkColor);
            if (Double.compare(counterBD.remainder(majorTickSpaceBD).doubleValue(), 0.0) == 0) {
                isNotZero = Double.compare(0.0, counter) != 0;
                TickMarkType tickMarkType = TickMarkType.LINE;
                if (majorTickMarksVisible) {
                    tickMarkType = majorTickMarkType;
                    this.tickMarkCtx.setFill((Paint)(tickMarkSectionsVisible ? Helper.getColorOfSection(tickMarkSections, counter, majorTickMarkColor) : majorTickMarkColor));
                    this.tickMarkCtx.setStroke((Paint)(tickMarkSectionsVisible ? Helper.getColorOfSection(tickMarkSections, counter, majorTickMarkColor) : majorTickMarkColor));
                    this.tickMarkCtx.setLineWidth(this.size * (TickMarkType.BOX == tickMarkType ? 0.016 : 0.0055));
                } else if (minorTickMarksVisible) {
                    tickMarkType = minorTickMarkType;
                    this.tickMarkCtx.setFill((Paint)(tickMarkSectionsVisible ? Helper.getColorOfSection(tickMarkSections, counter, minorTickMarkColor) : minorTickMarkColor));
                    this.tickMarkCtx.setStroke((Paint)(tickMarkSectionsVisible ? Helper.getColorOfSection(tickMarkSections, counter, minorTickMarkColor) : minorTickMarkColor));
                    this.tickMarkCtx.setLineWidth(this.size * (TickMarkType.BOX == tickMarkType ? 0.007 : 0.00225));
                }
                if (fullRange && !isNotZero) {
                    this.tickMarkCtx.setFill((Paint)zeroColor);
                    this.tickMarkCtx.setStroke((Paint)zeroColor);
                }
                switch (tickMarkType) {
                    case TRAPEZOID: {
                        if (majorTickMarksVisible) {
                            Helper.drawTrapezoid(this.tickMarkCtx, trapezoidMajorInnerPoint1X, trapezoidMajorInnerPoint1Y, trapezoidMajorInnerPoint2X, trapezoidMajorInnerPoint2Y, trapezoidMajorOuterPoint1X, trapezoidMajorOuterPoint1Y, trapezoidMajorOuterPoint2X, trapezoidMajorOuterPoint2Y);
                            break;
                        }
                        if (!minorTickMarksVisible) break;
                        Helper.drawTrapezoid(this.tickMarkCtx, trapezoidMinorInnerPoint1X, trapezoidMinorInnerPoint1Y, trapezoidMinorInnerPoint2X, trapezoidMinorInnerPoint2Y, trapezoidMinorOuterPoint1X, trapezoidMinorOuterPoint1Y, trapezoidMinorOuterPoint2X, trapezoidMinorOuterPoint2Y);
                        break;
                    }
                    case TRIANGLE: {
                        if (majorTickMarksVisible) {
                            if (TickLabelLocation.INSIDE == tickLabelLocation) {
                                Helper.drawTriangle(this.tickMarkCtx, innerPointX, innerPointY, trapezoidMajorOuterPoint1X, trapezoidMajorOuterPoint1Y, trapezoidMajorOuterPoint2X, trapezoidMajorOuterPoint2Y);
                                break;
                            }
                            Helper.drawTriangle(this.tickMarkCtx, outerPointX, outerPointY, trapezoidMajorInnerPoint1X, trapezoidMajorInnerPoint1Y, trapezoidMajorInnerPoint2X, trapezoidMajorInnerPoint2Y);
                            break;
                        }
                        if (!minorTickMarksVisible) break;
                        if (TickLabelLocation.INSIDE == tickLabelLocation) {
                            Helper.drawTriangle(this.tickMarkCtx, innerMinorPointX, innerMinorPointY, trapezoidMinorOuterPoint1X, trapezoidMinorOuterPoint1Y, trapezoidMinorOuterPoint2X, trapezoidMinorOuterPoint2Y);
                            break;
                        }
                        Helper.drawTriangle(this.tickMarkCtx, outerMinorPointX, outerMinorPointY, trapezoidMinorInnerPoint1X, trapezoidMinorInnerPoint1Y, trapezoidMinorInnerPoint2X, trapezoidMinorInnerPoint2Y);
                        break;
                    }
                    case DOT: {
                        if (majorTickMarksVisible) {
                            Helper.drawDot(this.tickMarkCtx, dotCenterX - majorHalfDotSize, dotCenterY - majorHalfDotSize, majorDotSize);
                            break;
                        }
                        if (!minorTickMarksVisible) break;
                        Helper.drawDot(this.tickMarkCtx, dotMinorCenterX - minorHalfDotSize, dotMinorCenterY - minorHalfDotSize, minorDotSize);
                        break;
                    }
                    case TICK_LABEL: {
                        if (!majorTickMarksVisible) break;
                        this.tickMarkCtx.save();
                        this.tickMarkCtx.translate(tickLabelTickMarkX, tickLabelTickMarkY);
                        Helper.rotateContextForText(this.tickMarkCtx, this.startAngle, angle, tickLabelOrientation);
                        this.tickMarkCtx.setFont(isNotZero ? tickMarkFont : tickMarkZeroFont);
                        this.tickMarkCtx.setTextAlign(TextAlignment.CENTER);
                        this.tickMarkCtx.setTextBaseline(VPos.CENTER);
                        this.tickMarkCtx.fillText(String.format(this.locale, tickLabelFormatString, counter), 0.0, 0.0);
                        this.tickMarkCtx.restore();
                        break;
                    }
                    default: {
                        if (majorTickMarksVisible) {
                            Helper.drawLine(this.tickMarkCtx, innerPointX, innerPointY, outerPointX, outerPointY);
                            break;
                        }
                        if (!minorTickMarksVisible) break;
                        if (TickLabelLocation.OUTSIDE == tickLabelLocation) {
                            Helper.drawLine(this.tickMarkCtx, innerPointX, innerPointY, outerMinorPointX, outerMinorPointY);
                            break;
                        }
                        Helper.drawLine(this.tickMarkCtx, innerMinorPointX, innerMinorPointY, outerPointX, outerPointY);
                    }
                }
                if (tickLabelsVisible) {
                    this.tickMarkCtx.save();
                    this.tickMarkCtx.translate(textPointX, textPointY);
                    Helper.rotateContextForText(this.tickMarkCtx, this.startAngle, angle, tickLabelOrientation);
                    this.tickMarkCtx.setFont(isNotZero ? tickLabelFont : tickLabelZeroFont);
                    this.tickMarkCtx.setTextAlign(TextAlignment.CENTER);
                    this.tickMarkCtx.setTextBaseline(VPos.CENTER);
                    if (!onlyFirstAndLastLabelVisible) {
                        if (isNotZero) {
                            this.tickMarkCtx.setFill((Paint)(tickLabelSectionsVisible ? Helper.getColorOfSection(tickLabelSections, counter, tickLabelColor) : tickLabelColor));
                        } else {
                            this.tickMarkCtx.setFill((Paint)(tickLabelSectionsVisible ? Helper.getColorOfSection(tickLabelSections, counter, tickLabelColor) : (fullRange ? zeroColor : tickLabelColor)));
                        }
                    } else if (Double.compare(counter, this.minValue) == 0 || Double.compare(counter, this.maxValue) == 0) {
                        if (isNotZero) {
                            this.tickMarkCtx.setFill((Paint)(tickLabelSectionsVisible ? Helper.getColorOfSection(tickLabelSections, counter, tickLabelColor) : tickLabelColor));
                        } else {
                            this.tickMarkCtx.setFill((Paint)(tickLabelSectionsVisible ? Helper.getColorOfSection(tickLabelSections, counter, tickLabelColor) : (fullRange ? zeroColor : tickLabelColor)));
                        }
                    } else {
                        this.tickMarkCtx.setFill((Paint)Color.TRANSPARENT);
                    }
                    if (customTickLabelsEnabled) {
                        if (customTickLabelCounter >= 0) {
                            this.tickMarkCtx.fillText(customTickLabels.get(customTickLabelCounter), 0.0, 0.0);
                            ++customTickLabelCounter;
                        }
                        if (customTickLabelCounter > customTickLabels.size() - 1) {
                            customTickLabelCounter = -1;
                        }
                    } else {
                        this.tickMarkCtx.fillText(String.format(this.locale, tickLabelFormatString, counter), 0.0, 0.0);
                    }
                    this.tickMarkCtx.restore();
                }
            } else if (mediumTickMarksVisible && (double)Double.compare(minorTickSpaceBD.remainder(mediumCheck2).doubleValue(), 0.0) != 0.0 && (double)Double.compare(counterBD.remainder(mediumCheck5).doubleValue(), 0.0) == 0.0) {
                this.tickMarkCtx.setFill((Paint)(tickMarkSectionsVisible ? Helper.getColorOfSection(tickMarkSections, counter, mediumTickMarkColor) : mediumTickMarkColor));
                this.tickMarkCtx.setStroke((Paint)(tickMarkSectionsVisible ? Helper.getColorOfSection(tickMarkSections, counter, mediumTickMarkColor) : mediumTickMarkColor));
                switch (mediumTickMarkType) {
                    case TRAPEZOID: {
                        Helper.drawTrapezoid(this.tickMarkCtx, trapezoidMediumInnerPoint1X, trapezoidMediumInnerPoint1Y, trapezoidMediumInnerPoint2X, trapezoidMediumInnerPoint2Y, trapezoidMediumOuterPoint1X, trapezoidMediumOuterPoint1Y, trapezoidMediumOuterPoint2X, trapezoidMediumOuterPoint2Y);
                        break;
                    }
                    case TRIANGLE: {
                        if (TickLabelLocation.INSIDE == tickLabelLocation) {
                            Helper.drawTriangle(this.tickMarkCtx, innerMediumPointX, innerMediumPointY, trapezoidMediumOuterPoint1X, trapezoidMediumOuterPoint1Y, trapezoidMediumOuterPoint2X, trapezoidMediumOuterPoint2Y);
                            break;
                        }
                        Helper.drawTriangle(this.tickMarkCtx, outerMediumPointX, outerMediumPointY, trapezoidMediumInnerPoint1X, trapezoidMediumInnerPoint1Y, trapezoidMediumInnerPoint2X, trapezoidMediumInnerPoint2Y);
                        break;
                    }
                    case DOT: {
                        Helper.drawDot(this.tickMarkCtx, dotMediumCenterX - mediumHalfDotSize, dotMediumCenterY - mediumHalfDotSize, mediumDotSize);
                        break;
                    }
                    case BOX: {
                        this.tickMarkCtx.setLineWidth(this.size * 0.009);
                        if (TickLabelLocation.OUTSIDE == tickLabelLocation) {
                            Helper.drawLine(this.tickMarkCtx, innerPointX, innerPointY, outerMediumPointX, outerMediumPointY);
                            break;
                        }
                        Helper.drawLine(this.tickMarkCtx, innerMediumPointX, innerMediumPointY, outerPointX, outerPointY);
                        break;
                    }
                    default: {
                        this.tickMarkCtx.setLineWidth(this.size * 0.0035);
                        if (TickLabelLocation.OUTSIDE == tickLabelLocation) {
                            Helper.drawLine(this.tickMarkCtx, innerPointX, innerPointY, outerMediumPointX, outerMediumPointY);
                            break;
                        }
                        Helper.drawLine(this.tickMarkCtx, innerMediumPointX, innerMediumPointY, outerPointX, outerPointY);
                        break;
                    }
                }
            } else if (minorTickMarksVisible && Double.compare(counterBD.remainder(minorTickSpaceBD).doubleValue(), 0.0) == 0 && TickMarkType.TICK_LABEL != majorTickMarkType) {
                this.tickMarkCtx.setFill((Paint)(tickMarkSectionsVisible ? Helper.getColorOfSection(tickMarkSections, counter, minorTickMarkColor) : minorTickMarkColor));
                this.tickMarkCtx.setStroke((Paint)(tickMarkSectionsVisible ? Helper.getColorOfSection(tickMarkSections, counter, minorTickMarkColor) : minorTickMarkColor));
                switch (minorTickMarkType) {
                    case TRAPEZOID: {
                        Helper.drawTrapezoid(this.tickMarkCtx, trapezoidMinorInnerPoint1X, trapezoidMinorInnerPoint1Y, trapezoidMinorInnerPoint2X, trapezoidMinorInnerPoint2Y, trapezoidMinorOuterPoint1X, trapezoidMinorOuterPoint1Y, trapezoidMinorOuterPoint2X, trapezoidMinorOuterPoint2Y);
                        break;
                    }
                    case TRIANGLE: {
                        if (TickLabelLocation.INSIDE == tickLabelLocation) {
                            Helper.drawTriangle(this.tickMarkCtx, innerMinorPointX, innerMinorPointY, trapezoidMinorOuterPoint1X, trapezoidMinorOuterPoint1Y, trapezoidMinorOuterPoint2X, trapezoidMinorOuterPoint2Y);
                            break;
                        }
                        Helper.drawTriangle(this.tickMarkCtx, outerMinorPointX, outerMinorPointY, trapezoidMinorInnerPoint1X, trapezoidMinorInnerPoint1Y, trapezoidMinorInnerPoint2X, trapezoidMinorInnerPoint2Y);
                        break;
                    }
                    case DOT: {
                        Helper.drawDot(this.tickMarkCtx, dotMinorCenterX - minorHalfDotSize, dotMinorCenterY - minorHalfDotSize, minorDotSize);
                        break;
                    }
                    case BOX: {
                        this.tickMarkCtx.setLineWidth(this.size * 0.007);
                        if (TickLabelLocation.OUTSIDE == tickLabelLocation) {
                            Helper.drawLine(this.tickMarkCtx, innerPointX, innerPointY, outerMinorPointX, outerMinorPointY);
                            break;
                        }
                        Helper.drawLine(this.tickMarkCtx, innerMinorPointX, innerMinorPointY, outerPointX, outerPointY);
                        break;
                    }
                    default: {
                        this.tickMarkCtx.setLineWidth(this.size * 0.00225);
                        if (TickLabelLocation.OUTSIDE == tickLabelLocation) {
                            Helper.drawLine(this.tickMarkCtx, innerPointX, innerPointY, outerMinorPointX, outerMinorPointY);
                            break;
                        }
                        Helper.drawLine(this.tickMarkCtx, innerMinorPointX, innerMinorPointY, outerPointX, outerPointY);
                    }
                }
            }
            counterBD = counterBD.add(minorTickSpaceBD);
            counter = counterBD.doubleValue();
            if (counter > this.maxValue) break;
            angle = Gauge.ScaleDirection.CLOCKWISE == scaleDirection ? angle - tmpAngleStep : angle + tmpAngleStep;
            i -= tmpStep;
        }
    }

    private void drawGradientBar() {
        Pos knobPosition = ((Gauge)this.getSkinnable()).getKnobPosition();
        TickLabelLocation tickLabelLocation = ((Gauge)this.getSkinnable()).getTickLabelLocation();
        double scaledSize = this.size * 1.9;
        double xy = TickLabelLocation.OUTSIDE == tickLabelLocation ? 0.105 * scaledSize : 0.03875 * scaledSize;
        double wh = TickLabelLocation.OUTSIDE == tickLabelLocation ? scaledSize * 0.79 : scaledSize * 0.925;
        double offsetX = Pos.TOP_LEFT == knobPosition || Pos.BOTTOM_LEFT == knobPosition ? -scaledSize * 0.475 : 0.0;
        double offsetY = Pos.TOP_LEFT == knobPosition || Pos.TOP_RIGHT == knobPosition ? -scaledSize * 0.475 : 0.0;
        double offset = 90.0 - this.startAngle;
        Gauge.ScaleDirection scaleDirection = ((Gauge)this.getSkinnable()).getScaleDirection();
        List<Stop> stops = ((Gauge)this.getSkinnable()).getGradientBarStops();
        HashMap<Double, Color> stopAngleMap = new HashMap<Double, Color>(stops.size());
        for (Stop stop : stops) {
            stopAngleMap.put(stop.getOffset() * 90.0, stop.getColor());
        }
        double offsetFactor = Gauge.ScaleDirection.CLOCKWISE == scaleDirection ? (Pos.TOP_LEFT == knobPosition || Pos.BOTTOM_RIGHT == knobPosition ? this.startAngle : 180.0 - this.startAngle) : this.startAngle + 180.0;
        AngleConicalGradient gradient = new AngleConicalGradient(scaledSize * 0.5, scaledSize * 0.5, offsetFactor, stopAngleMap, ((Gauge)this.getSkinnable()).getScaleDirection());
        double barStartAngle = Gauge.ScaleDirection.CLOCKWISE == scaleDirection ? -this.minValue * this.angleStep : this.minValue * this.angleStep;
        double barAngleExtend = Gauge.ScaleDirection.CLOCKWISE == scaleDirection ? ((Gauge)this.getSkinnable()).getRange() * this.angleStep : -((Gauge)this.getSkinnable()).getRange() * this.angleStep;
        this.tickMarkCtx.save();
        this.tickMarkCtx.setStroke((Paint)gradient.getImagePattern(new Rectangle(xy - 0.026 * scaledSize + offsetX, xy - 0.026 * scaledSize + offsetY, wh + 0.052 * scaledSize, wh + 0.052 * scaledSize)));
        this.tickMarkCtx.setLineWidth(scaledSize * 0.052);
        this.tickMarkCtx.setLineCap(StrokeLineCap.BUTT);
        this.tickMarkCtx.strokeArc(xy + offsetX, xy + offsetY, wh, wh, -(offset + barStartAngle), -barAngleExtend, ArcType.OPEN);
        this.tickMarkCtx.restore();
    }

    private void drawAreasAndSections(GraphicsContext CTX) {
        int i;
        int listSize;
        double offsetY;
        double offsetX;
        double wh;
        double xy;
        if (this.areas.isEmpty() && this.sections.isEmpty()) {
            return;
        }
        double value = ((Gauge)this.getSkinnable()).getCurrentValue();
        Pos knobPosition = ((Gauge)this.getSkinnable()).getKnobPosition();
        double scaledSize = this.size * 1.9;
        double offset = 90.0 - this.startAngle;
        if (this.areasVisible && !this.areas.isEmpty()) {
            xy = TickLabelLocation.OUTSIDE == this.tickLabelLocation ? 0.078 * scaledSize : 0.0125 * scaledSize;
            wh = TickLabelLocation.OUTSIDE == this.tickLabelLocation ? scaledSize * 0.846 : scaledSize * 0.97;
            offsetX = Pos.BOTTOM_RIGHT == knobPosition || Pos.TOP_RIGHT == knobPosition ? 0.0 : -scaledSize * 0.475;
            offsetY = Pos.TOP_LEFT == knobPosition || Pos.TOP_RIGHT == knobPosition ? -scaledSize * 0.475 : 0.0;
            listSize = this.areas.size();
            for (i = 0; i < listSize; ++i) {
                double areaStartAngle;
                Section area = this.areas.get(i);
                if (Double.compare(area.getStart(), this.maxValue) > 0 || Double.compare(area.getStop(), this.minValue) < 0) continue;
                if (area.getStart() < this.minValue && area.getStop() < this.maxValue) {
                    areaStartAngle = 0.0;
                } else {
                    double d = areaStartAngle = Gauge.ScaleDirection.CLOCKWISE == this.scaleDirection ? (area.getStart() - this.minValue) * this.angleStep : -(area.getStart() - this.minValue) * this.angleStep;
                }
                double areaAngleExtend = area.getStop() > this.maxValue ? (Gauge.ScaleDirection.CLOCKWISE == this.scaleDirection ? (this.maxValue - area.getStart()) * this.angleStep : -(this.maxValue - area.getStart()) * this.angleStep) : (Double.compare(area.getStart(), this.minValue) < 0 ? (Gauge.ScaleDirection.CLOCKWISE == this.scaleDirection ? (area.getStop() - this.minValue) * this.angleStep : -(area.getStop() - this.minValue) * this.angleStep) : (Gauge.ScaleDirection.CLOCKWISE == this.scaleDirection ? (area.getStop() - area.getStart()) * this.angleStep : -(area.getStop() - area.getStart()) * this.angleStep));
                CTX.save();
                if (this.highlightAreas) {
                    CTX.setFill((Paint)(area.contains(value) ? area.getHighlightColor() : area.getColor()));
                } else {
                    CTX.setFill((Paint)area.getColor());
                }
                CTX.fillArc(xy + offsetX, xy + offsetY, wh, wh, -(offset + areaStartAngle), -areaAngleExtend, ArcType.ROUND);
                CTX.restore();
            }
        }
        if (this.sectionsVisible && !this.sections.isEmpty()) {
            xy = TickLabelLocation.OUTSIDE == this.tickLabelLocation ? 0.105 * scaledSize : 0.03875 * scaledSize;
            wh = TickLabelLocation.OUTSIDE == this.tickLabelLocation ? scaledSize * 0.79 : scaledSize * 0.925;
            offsetX = Pos.BOTTOM_RIGHT == knobPosition || Pos.TOP_RIGHT == knobPosition ? 0.0 : -scaledSize * 0.4765;
            offsetY = Pos.TOP_LEFT == knobPosition || Pos.TOP_RIGHT == knobPosition ? -scaledSize * 0.475 : 0.0;
            listSize = this.sections.size();
            CTX.setLineWidth(scaledSize * 0.052);
            CTX.setLineCap(StrokeLineCap.BUTT);
            for (i = 0; i < listSize; ++i) {
                double sectionStartAngle;
                Section section = this.sections.get(i);
                if (Double.compare(section.getStart(), this.maxValue) > 0 || Double.compare(section.getStop(), this.minValue) < 0) continue;
                if (Double.compare(section.getStart(), this.minValue) < 0 && Double.compare(section.getStop(), this.maxValue) < 0) {
                    sectionStartAngle = 0.0;
                } else {
                    double d = sectionStartAngle = Gauge.ScaleDirection.CLOCKWISE == this.scaleDirection ? (section.getStart() - this.minValue) * this.angleStep : -(section.getStart() - this.minValue) * this.angleStep;
                }
                double sectionAngleExtend = Double.compare(section.getStop(), this.maxValue) > 0 ? (Gauge.ScaleDirection.CLOCKWISE == this.scaleDirection ? (this.maxValue - section.getStart()) * this.angleStep : -(this.maxValue - section.getStart()) * this.angleStep) : (Double.compare(section.getStart(), this.minValue) < 0 ? (Gauge.ScaleDirection.CLOCKWISE == this.scaleDirection ? (section.getStop() - this.minValue) * this.angleStep : -(section.getStop() - this.minValue) * this.angleStep) : (Gauge.ScaleDirection.CLOCKWISE == this.scaleDirection ? (section.getStop() - section.getStart()) * this.angleStep : -(section.getStop() - section.getStart()) * this.angleStep));
                CTX.save();
                if (this.highlightSections) {
                    CTX.setStroke((Paint)(section.contains(value) ? section.getHighlightColor() : section.getColor()));
                } else {
                    CTX.setStroke((Paint)section.getColor());
                }
                CTX.strokeArc(xy + offsetX, xy + offsetY, wh, wh, -(offset + sectionStartAngle), -sectionAngleExtend, ArcType.OPEN);
                CTX.restore();
            }
        }
    }

    private void drawLed() {
        boolean isFlatLed;
        this.ledCtx.clearRect(0.0, 0.0, this.ledSize, this.ledSize);
        boolean bl = isFlatLed = Gauge.LedType.FLAT == ((Gauge)this.getSkinnable()).getLedType();
        if (!isFlatLed) {
            this.ledCtx.setFill(this.ledFramePaint);
            this.ledCtx.fillOval(0.0, 0.0, this.ledSize, this.ledSize);
        } else {
            double lineWidth = 0.0037037 * this.size;
            this.ledCtx.setStroke(this.ledFramePaint);
            this.ledCtx.setLineWidth(lineWidth);
            this.ledCtx.strokeOval(lineWidth, lineWidth, this.ledSize - 2.0 * lineWidth, this.ledSize - 2.0 * lineWidth);
        }
        this.ledCtx.save();
        if (((Gauge)this.getSkinnable()).isLedOn()) {
            this.ledCtx.setEffect((Effect)this.ledOnShadow);
            this.ledCtx.setFill(this.ledOnPaint);
        } else {
            this.ledCtx.setEffect((Effect)this.ledOffShadow);
            this.ledCtx.setFill(this.ledOffPaint);
        }
        if (isFlatLed) {
            this.ledCtx.fillOval(0.2 * this.ledSize, 0.2 * this.ledSize, 0.6 * this.ledSize, 0.6 * this.ledSize);
        } else {
            this.ledCtx.fillOval(0.14 * this.ledSize, 0.14 * this.ledSize, 0.72 * this.ledSize, 0.72 * this.ledSize);
        }
        this.ledCtx.restore();
        this.ledCtx.setFill(this.ledHighlightPaint);
        this.ledCtx.fillOval(0.21 * this.ledSize, 0.21 * this.ledSize, 0.58 * this.ledSize, 0.58 * this.ledSize);
    }

    private void drawMarkers() {
        this.markerPane.getChildren().setAll(this.markerMap.values());
        this.markerPane.getChildren().add((Object)this.threshold);
        TickLabelLocation tickLabelLocation = ((Gauge)this.getSkinnable()).getTickLabelLocation();
        double scaledSize = this.size * 1.95;
        double markerSize = TickLabelLocation.OUTSIDE == tickLabelLocation ? 0.0125 * this.size : 0.015 * this.size;
        double pathHalf = markerSize * 0.3;
        Gauge.ScaleDirection scaleDirection = ((Gauge)this.getSkinnable()).getScaleDirection();
        if (((Gauge)this.getSkinnable()).getMarkersVisible()) {
            for (Map.Entry<Marker, Shape> entry : this.markerMap.entrySet()) {
                Marker marker = entry.getKey();
                Shape shape = entry.getValue();
                double valueAngle = Gauge.ScaleDirection.CLOCKWISE == scaleDirection ? this.startAngle - (marker.getValue() - this.minValue) * this.angleStep : this.startAngle + (marker.getValue() - this.minValue) * this.angleStep;
                double sinValue = Math.sin(Math.toRadians(valueAngle));
                double cosValue = Math.cos(Math.toRadians(valueAngle));
                block0 : switch (marker.getMarkerType()) {
                    case TRIANGLE: {
                        Path trapezoid = (Path)shape;
                        trapezoid.getElements().clear();
                        switch (tickLabelLocation) {
                            case OUTSIDE: {
                                trapezoid.getElements().add((Object)new MoveTo(this.centerX + scaledSize * 0.38 * sinValue, this.centerY + scaledSize * 0.38 * cosValue));
                                sinValue = Math.sin(Math.toRadians(valueAngle - pathHalf));
                                cosValue = Math.cos(Math.toRadians(valueAngle - pathHalf));
                                trapezoid.getElements().add((Object)new LineTo(this.centerX + scaledSize * 0.4075 * sinValue, this.centerY + scaledSize * 0.4075 * cosValue));
                                sinValue = Math.sin(Math.toRadians(valueAngle + pathHalf));
                                cosValue = Math.cos(Math.toRadians(valueAngle + pathHalf));
                                trapezoid.getElements().add((Object)new LineTo(this.centerX + scaledSize * 0.4075 * sinValue, this.centerY + scaledSize * 0.4075 * cosValue));
                                trapezoid.getElements().add((Object)new ClosePath());
                                break block0;
                            }
                        }
                        trapezoid.getElements().add((Object)new MoveTo(this.centerX + scaledSize * 0.465 * sinValue, this.centerY + scaledSize * 0.465 * cosValue));
                        sinValue = Math.sin(Math.toRadians(valueAngle - pathHalf));
                        cosValue = Math.cos(Math.toRadians(valueAngle - pathHalf));
                        trapezoid.getElements().add((Object)new LineTo(this.centerX + scaledSize * 0.436 * sinValue, this.centerY + scaledSize * 0.436 * cosValue));
                        sinValue = Math.sin(Math.toRadians(valueAngle + pathHalf));
                        cosValue = Math.cos(Math.toRadians(valueAngle + pathHalf));
                        trapezoid.getElements().add((Object)new LineTo(this.centerX + scaledSize * 0.436 * sinValue, this.centerY + scaledSize * 0.436 * cosValue));
                        trapezoid.getElements().add((Object)new ClosePath());
                        break;
                    }
                    case DOT: {
                        Circle dot = (Circle)shape;
                        dot.setRadius(markerSize);
                        switch (tickLabelLocation) {
                            case OUTSIDE: {
                                dot.setCenterX(this.centerX + scaledSize * 0.3945 * sinValue);
                                dot.setCenterY(this.centerY + scaledSize * 0.3945 * cosValue);
                                break block0;
                            }
                        }
                        dot.setCenterX(this.centerX + scaledSize * 0.449 * sinValue);
                        dot.setCenterY(this.centerY + scaledSize * 0.449 * cosValue);
                        break;
                    }
                    default: {
                        Path standard = (Path)shape;
                        standard.getElements().clear();
                        switch (tickLabelLocation) {
                            case OUTSIDE: {
                                standard.getElements().add((Object)new MoveTo(this.centerX + scaledSize * 0.38 * sinValue, this.centerY + scaledSize * 0.38 * cosValue));
                                sinValue = Math.sin(Math.toRadians(valueAngle - pathHalf));
                                cosValue = Math.cos(Math.toRadians(valueAngle - pathHalf));
                                standard.getElements().add((Object)new LineTo(this.centerX + scaledSize * 0.4075 * sinValue, this.centerY + scaledSize * 0.4075 * cosValue));
                                standard.getElements().add((Object)new LineTo(this.centerX + scaledSize * 0.4575 * sinValue, this.centerY + scaledSize * 0.4575 * cosValue));
                                sinValue = Math.sin(Math.toRadians(valueAngle + pathHalf));
                                cosValue = Math.cos(Math.toRadians(valueAngle + pathHalf));
                                standard.getElements().add((Object)new LineTo(this.centerX + scaledSize * 0.4575 * sinValue, this.centerY + scaledSize * 0.4575 * cosValue));
                                standard.getElements().add((Object)new LineTo(this.centerX + scaledSize * 0.4075 * sinValue, this.centerY + scaledSize * 0.4075 * cosValue));
                                standard.getElements().add((Object)new ClosePath());
                                break block0;
                            }
                        }
                        standard.getElements().add((Object)new MoveTo(this.centerX + scaledSize * 0.465 * sinValue, this.centerY + scaledSize * 0.465 * cosValue));
                        sinValue = Math.sin(Math.toRadians(valueAngle - pathHalf));
                        cosValue = Math.cos(Math.toRadians(valueAngle - pathHalf));
                        standard.getElements().add((Object)new LineTo(this.centerX + scaledSize * 0.436 * sinValue, this.centerY + scaledSize * 0.436 * cosValue));
                        standard.getElements().add((Object)new LineTo(this.centerX + scaledSize * 0.386 * sinValue, this.centerY + scaledSize * 0.386 * cosValue));
                        sinValue = Math.sin(Math.toRadians(valueAngle + pathHalf));
                        cosValue = Math.cos(Math.toRadians(valueAngle + pathHalf));
                        standard.getElements().add((Object)new LineTo(this.centerX + scaledSize * 0.386 * sinValue, this.centerY + scaledSize * 0.386 * cosValue));
                        standard.getElements().add((Object)new LineTo(this.centerX + scaledSize * 0.436 * sinValue, this.centerY + scaledSize * 0.436 * cosValue));
                        standard.getElements().add((Object)new ClosePath());
                    }
                }
                Color markerColor = marker.getColor();
                shape.setFill((Paint)markerColor);
                shape.setStroke((Paint)markerColor.darker());
                shape.setPickOnBounds(false);
                Tooltip markerTooltip = marker.getText().isEmpty() ? new Tooltip(Double.toString(marker.getValue())) : new Tooltip(marker.getText() + "\n(" + Double.toString(marker.getValue()) + ")");
                markerTooltip.setTextAlignment(TextAlignment.CENTER);
                Tooltip.install((Node)shape, (Tooltip)markerTooltip);
                shape.setOnMousePressed(e -> marker.fireMarkerEvent(marker.MARKER_PRESSED_EVENT));
                shape.setOnMouseReleased(e -> marker.fireMarkerEvent(marker.MARKER_RELEASED_EVENT));
            }
        }
        if (((Gauge)this.getSkinnable()).isThresholdVisible()) {
            this.threshold.getElements().clear();
            double thresholdAngle = Gauge.ScaleDirection.CLOCKWISE == scaleDirection ? this.startAngle - (((Gauge)this.getSkinnable()).getThreshold() - this.minValue) * this.angleStep : this.startAngle + (((Gauge)this.getSkinnable()).getThreshold() - this.minValue) * this.angleStep;
            double thresholdSize = Helper.clamp(3.0, 3.5, 0.01 * this.size);
            double sinValue = Math.sin(Math.toRadians(thresholdAngle));
            double cosValue = Math.cos(Math.toRadians(thresholdAngle));
            switch (tickLabelLocation) {
                case OUTSIDE: {
                    this.threshold.getElements().add((Object)new MoveTo(this.centerX + scaledSize * 0.38 * sinValue, this.centerY + scaledSize * 0.38 * cosValue));
                    sinValue = Math.sin(Math.toRadians(thresholdAngle - thresholdSize));
                    cosValue = Math.cos(Math.toRadians(thresholdAngle - thresholdSize));
                    this.threshold.getElements().add((Object)new LineTo(this.centerX + scaledSize * 0.34 * sinValue, this.centerY + scaledSize * 0.34 * cosValue));
                    sinValue = Math.sin(Math.toRadians(thresholdAngle + thresholdSize));
                    cosValue = Math.cos(Math.toRadians(thresholdAngle + thresholdSize));
                    this.threshold.getElements().add((Object)new LineTo(this.centerX + scaledSize * 0.34 * sinValue, this.centerY + scaledSize * 0.34 * cosValue));
                    this.threshold.getElements().add((Object)new ClosePath());
                    break;
                }
                default: {
                    this.threshold.getElements().add((Object)new MoveTo(this.centerX + scaledSize * 0.465 * sinValue, this.centerY + scaledSize * 0.465 * cosValue));
                    sinValue = Math.sin(Math.toRadians(thresholdAngle - thresholdSize));
                    cosValue = Math.cos(Math.toRadians(thresholdAngle - thresholdSize));
                    this.threshold.getElements().add((Object)new LineTo(this.centerX + scaledSize * 0.425 * sinValue, this.centerY + scaledSize * 0.425 * cosValue));
                    sinValue = Math.sin(Math.toRadians(thresholdAngle + thresholdSize));
                    cosValue = Math.cos(Math.toRadians(thresholdAngle + thresholdSize));
                    this.threshold.getElements().add((Object)new LineTo(this.centerX + scaledSize * 0.425 * sinValue, this.centerY + scaledSize * 0.425 * cosValue));
                    this.threshold.getElements().add((Object)new ClosePath());
                }
            }
            this.threshold.setFill((Paint)((Gauge)this.getSkinnable()).getThresholdColor());
            this.threshold.setStroke((Paint)((Gauge)this.getSkinnable()).getTickMarkColor());
        }
    }

    private void updateMarkers() {
        this.markerMap.clear();
        block4: for (Marker marker : ((Gauge)this.getSkinnable()).getMarkers()) {
            switch (marker.getMarkerType()) {
                case TRIANGLE: {
                    this.markerMap.put(marker, (Shape)new Path());
                    continue block4;
                }
                case DOT: {
                    this.markerMap.put(marker, (Shape)new Circle());
                    continue block4;
                }
            }
            this.markerMap.put(marker, (Shape)new Path());
        }
    }

    private void drawKnob(boolean PRESSED) {
        this.knobCanvas.setCache(false);
        double w = this.knobCanvas.getWidth();
        double h = this.knobCanvas.getHeight();
        this.knobCtx.clearRect(0.0, 0.0, w, h);
        Color knobColor = ((Gauge)this.getSkinnable()).getKnobColor();
        double hue = knobColor.getHue();
        double sat = knobColor.getSaturation();
        double alp = knobColor.getOpacity();
        double brg = Color.BLACK.equals((Object)knobColor) ? 0.2 : knobColor.getBrightness();
        switch (((Gauge)this.getSkinnable()).getKnobType()) {
            case PLAIN: {
                this.knobCtx.setFill((Paint)new LinearGradient(0.0, 0.0, 0.0, h, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)180, (int)180, (int)180)), new Stop(0.46, Color.rgb((int)63, (int)63, (int)63)), new Stop(1.0, Color.rgb((int)40, (int)40, (int)40))}));
                this.knobCtx.fillOval(0.0, 0.0, w, h);
                this.knobCtx.setFill((Paint)new LinearGradient(0.0, 0.11764706 * h, 0.0, 0.76470588 * h, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.hsb((double)hue, (double)sat, (double)(PRESSED ? brg * 0.9 : brg * 1.0), (double)alp)), new Stop(0.01, Color.hsb((double)hue, (double)sat, (double)(PRESSED ? brg * 0.75 : brg * 0.85), (double)alp)), new Stop(0.5, Color.hsb((double)hue, (double)sat, (double)(PRESSED ? brg * 0.4 : brg * 0.5), (double)alp)), new Stop(0.51, Color.hsb((double)hue, (double)sat, (double)(PRESSED ? brg * 0.35 : brg * 0.45), (double)alp)), new Stop(1.0, Color.hsb((double)hue, (double)sat, (double)(PRESSED ? brg * 0.7 : brg * 0.8), (double)alp))}));
                this.knobCtx.fillOval(w * 0.11764706, h * 0.11764706, w - w * 0.23529412, h - h * 0.23529412);
                this.knobCtx.setFill((Paint)new RadialGradient(0.0, 0.0, 0.5 * w, 0.47 * h, w * 0.38, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.TRANSPARENT), new Stop(0.76, Color.TRANSPARENT), new Stop(1.0, Color.rgb((int)0, (int)0, (int)0, (double)(PRESSED ? 0.5 : 0.2)))}));
                this.knobCtx.fillOval(w * 0.11764706, h * 0.11764706, w - w * 0.23529412, h - h * 0.23529412);
                break;
            }
            case METAL: {
                this.knobCtx.setFill((Paint)new LinearGradient(0.0, 0.0, 0.0, h, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)92, (int)95, (int)101)), new Stop(0.47, Color.rgb((int)46, (int)49, (int)53)), new Stop(1.0, Color.rgb((int)22, (int)23, (int)26))}));
                this.knobCtx.fillOval(0.0, 0.0, w, h);
                this.knobCtx.setFill((Paint)new LinearGradient(0.0, 0.058823529411764705 * h, 0.0, 0.9411764705882353 * h, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.hsb((double)hue, (double)sat, (double)(PRESSED ? brg * 0.7 : brg * 0.9), (double)alp)), new Stop(0.0, Color.hsb((double)hue, (double)sat, (double)(PRESSED ? brg * 0.3 : brg * 0.5), (double)alp))}));
                this.knobCtx.fillOval(0.05882353 * w, 0.05882353 * h, w * 0.88235294, h * 0.88235294);
                this.knobCtx.beginPath();
                this.knobCtx.moveTo(0.17647058823529413 * w, 0.8235294117647058 * h);
                this.knobCtx.bezierCurveTo(0.29411764705882354 * w, 0.8823529411764706 * h, 0.35294117647058826 * w, 0.9411764705882353 * h, 0.5294117647058824 * w, 0.9411764705882353 * h);
                this.knobCtx.bezierCurveTo(0.6470588235294118 * w, 0.9411764705882353 * h, 0.7058823529411765 * w, 0.8823529411764706 * h, 0.8235294117647058 * w, 0.8235294117647058 * h);
                this.knobCtx.bezierCurveTo(0.7647058823529411 * w, 0.7058823529411765 * h, 0.6470588235294118 * w, 0.5882352941176471 * h, 0.5294117647058824 * w, 0.5882352941176471 * h);
                this.knobCtx.bezierCurveTo(0.35294117647058826 * w, 0.5882352941176471 * h, 0.23529411764705882 * w, 0.7058823529411765 * h, 0.17647058823529413 * w, 0.8235294117647058 * h);
                this.knobCtx.closePath();
                this.knobCtx.setFill((Paint)new RadialGradient(0.0, 0.0, 0.47058823529411764 * w, 0.8823529411764706 * h, 0.3235294117647059 * w, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)255, (int)255, (int)255, (double)(PRESSED ? 0.3 : 0.6))), new Stop(1.0, Color.TRANSPARENT)}));
                this.knobCtx.fill();
                this.knobCtx.beginPath();
                this.knobCtx.moveTo(0.058823529411764705 * w, 0.29411764705882354 * h);
                this.knobCtx.bezierCurveTo(0.17647058823529413 * w, 0.35294117647058826 * h, 0.35294117647058826 * w, 0.35294117647058826 * h, 0.5294117647058824 * w, 0.35294117647058826 * h);
                this.knobCtx.bezierCurveTo(0.6470588235294118 * w, 0.35294117647058826 * h, 0.8235294117647058 * w, 0.35294117647058826 * h, 0.9411764705882353 * w, 0.29411764705882354 * h);
                this.knobCtx.bezierCurveTo(0.8823529411764706 * w, 0.11764705882352941 * h, 0.7058823529411765 * w, 0.0 * h, 0.5294117647058824 * w, 0.0 * h);
                this.knobCtx.bezierCurveTo(0.29411764705882354 * w, 0.0 * h, 0.11764705882352941 * w, 0.11764705882352941 * h, 0.058823529411764705 * w, 0.29411764705882354 * h);
                this.knobCtx.closePath();
                this.knobCtx.setFill((Paint)new RadialGradient(0.0, 0.0, 0.47058823529411764 * w, 0.0, 0.4411764705882353 * w, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)255, (int)255, (int)255, (double)(PRESSED ? 0.45 : 0.75))), new Stop(1.0, Color.TRANSPARENT)}));
                this.knobCtx.fill();
                this.knobCtx.setFill((Paint)new LinearGradient(0.5294117647058824 * w, 0.23529411764705882 * h, 0.5294117647058824 * w, 0.7647058823529411 * h, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.BLACK), new Stop(1.0, Color.rgb((int)204, (int)204, (int)204))}));
                this.knobCtx.fillOval(0.23529412 * w, 0.23529412 * h, 0.52941176 * w, 0.52941176 * h);
                this.knobCtx.setFill((Paint)new LinearGradient(0.5294117647058824 * w, 0.29411764705882354 * h, 0.5294117647058824 * w, 0.7058823529411765 * h, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)1, (int)6, (int)11)), new Stop(1.0, Color.rgb((int)50, (int)52, (int)56))}));
                this.knobCtx.fillOval(0.29411765 * w, 0.29411765 * h, 0.41176471 * w, 0.41176471 * h);
                break;
            }
            case FLAT: {
                double lineWidth = 0.00740741 * this.size;
                double knobSize = w - 2.0 * lineWidth;
                this.knobCtx.setFill((Paint)(PRESSED ? knobColor.darker() : knobColor));
                this.knobCtx.setStroke((Paint)(PRESSED ? Color.WHITE.darker() : Color.WHITE));
                this.knobCtx.setLineWidth(lineWidth);
                this.knobCtx.fillOval(lineWidth, lineWidth, knobSize, knobSize);
                this.knobCtx.strokeOval(lineWidth, lineWidth, knobSize, knobSize);
                break;
            }
            default: {
                this.knobCtx.setFill((Paint)new LinearGradient(0.0, 0.0, 0.0, h, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)133, (int)133, (int)133).brighter().brighter()), new Stop(0.52, Color.rgb((int)133, (int)133, (int)133)), new Stop(1.0, Color.rgb((int)133, (int)133, (int)133).darker().darker())}));
                this.knobCtx.fillOval(0.0, 0.0, w, h);
                double gradTop = PRESSED ? h - this.size * 0.01 : this.size * 0.005;
                double gradBot = PRESSED ? this.size * 0.005 : h - this.size * 0.01;
                this.knobCtx.setFill((Paint)new LinearGradient(0.0, gradTop, 0.0, gradBot, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.hsb((double)hue, (double)sat, (double)(brg * 0.85), (double)alp)), new Stop(0.45, Color.hsb((double)hue, (double)sat, (double)(brg * 0.65), (double)alp)), new Stop(1.0, Color.hsb((double)hue, (double)sat, (double)(brg * 0.4), (double)alp))}));
                this.knobCtx.fillOval(this.size * 0.005, this.size * 0.005, w - this.size * 0.01, h - this.size * 0.01);
            }
        }
        this.knobCanvas.setCache(true);
        this.knobCanvas.setCacheHint(CacheHint.QUALITY);
    }

    private void resizeText() {
        double maxWidth = 0.4 * this.size;
        this.titleText.setFont(Fonts.robotoMedium(this.size * 0.06));
        this.titleText.setText(((Gauge)this.getSkinnable()).getTitle());
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, this.size * 0.06);
        }
        this.unitText.setFont(Fonts.robotoRegular(this.size * 0.05));
        this.unitText.setText(((Gauge)this.getSkinnable()).getUnit());
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, this.size * 0.05);
        }
        maxWidth = 0.25 * this.size;
        this.subTitleText.setFont(Fonts.robotoRegular(this.size * 0.05));
        this.subTitleText.setText(((Gauge)this.getSkinnable()).getSubTitle());
        if (this.subTitleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.subTitleText, maxWidth, this.size * 0.05);
        }
        double offset = this.size * 0.025;
        Pos knobPosition = ((Gauge)this.getSkinnable()).getKnobPosition();
        switch (knobPosition) {
            case BOTTOM_LEFT: {
                this.titleText.relocate(offset, this.size * 0.45);
                this.unitText.relocate(offset, this.size * 0.55);
                this.subTitleText.relocate(offset, this.size * 0.65);
                break;
            }
            case TOP_LEFT: {
                this.titleText.relocate(offset, this.size * 0.3);
                this.unitText.relocate(offset, this.size * 0.4);
                this.subTitleText.relocate(offset, this.size * 0.5);
                break;
            }
            case TOP_RIGHT: {
                this.titleText.relocate(this.size - this.titleText.getLayoutBounds().getWidth() - offset, this.size * 0.3);
                this.unitText.relocate(this.size - this.unitText.getLayoutBounds().getWidth() - offset, this.size * 0.4);
                this.subTitleText.relocate(this.size - this.subTitleText.getLayoutBounds().getWidth() - offset, this.size * 0.5);
                break;
            }
            default: {
                this.titleText.relocate(this.size - this.titleText.getLayoutBounds().getWidth() - offset, this.size * 0.45);
                this.unitText.relocate(this.size - this.unitText.getLayoutBounds().getWidth() - offset, this.size * 0.55);
                this.subTitleText.relocate(this.size - this.subTitleText.getLayoutBounds().getWidth() - offset, this.size * 0.65);
            }
        }
    }

    private void resizeValueText() {
        Pos knobPosition = ((Gauge)this.getSkinnable()).getKnobPosition();
        if (((Gauge)this.getSkinnable()).isLcdVisible()) {
            block0 : switch (((Gauge)this.getSkinnable()).getLcdFont()) {
                case LCD: {
                    this.valueText.setFont(Fonts.digital(0.108 * this.size));
                    switch (knobPosition) {
                        case BOTTOM_LEFT: {
                            this.valueText.setTranslateX(0.545 * this.size - this.valueText.getLayoutBounds().getWidth());
                            this.valueText.setTranslateY(0.87 * this.size);
                            break block0;
                        }
                        case TOP_LEFT: {
                            this.valueText.setTranslateX(0.545 * this.size - this.valueText.getLayoutBounds().getWidth());
                            this.valueText.setTranslateY(0.125 * this.size);
                            break block0;
                        }
                        case TOP_RIGHT: {
                            this.valueText.setTranslateX(0.845 * this.size - this.valueText.getLayoutBounds().getWidth());
                            this.valueText.setTranslateY(0.125 * this.size);
                            break block0;
                        }
                    }
                    this.valueText.setTranslateX(0.845 * this.size - this.valueText.getLayoutBounds().getWidth());
                    this.valueText.setTranslateY(0.87 * this.size);
                    break;
                }
                case DIGITAL: {
                    this.valueText.setFont(Fonts.digitalReadout(0.105 * this.size));
                    switch (knobPosition) {
                        case BOTTOM_LEFT: {
                            this.valueText.setTranslateX(0.545 * this.size - this.valueText.getLayoutBounds().getWidth());
                            this.valueText.setTranslateY(0.89 * this.size);
                            break block0;
                        }
                        case TOP_LEFT: {
                            this.valueText.setTranslateX(0.545 * this.size - this.valueText.getLayoutBounds().getWidth());
                            this.valueText.setTranslateY(0.136 * this.size);
                            break block0;
                        }
                        case TOP_RIGHT: {
                            this.valueText.setTranslateX(0.845 * this.size - this.valueText.getLayoutBounds().getWidth());
                            this.valueText.setTranslateY(0.136 * this.size);
                            break block0;
                        }
                    }
                    this.valueText.setTranslateX(0.845 * this.size - this.valueText.getLayoutBounds().getWidth());
                    this.valueText.setTranslateY(0.89 * this.size);
                    break;
                }
                case DIGITAL_BOLD: {
                    this.valueText.setFont(Fonts.digitalReadoutBold(0.105 * this.size));
                    switch (knobPosition) {
                        case BOTTOM_LEFT: {
                            this.valueText.setTranslateX(0.545 * this.size - this.valueText.getLayoutBounds().getWidth());
                            this.valueText.setTranslateY(0.89 * this.size);
                            break block0;
                        }
                        case TOP_LEFT: {
                            this.valueText.setTranslateX(0.545 * this.size - this.valueText.getLayoutBounds().getWidth());
                            this.valueText.setTranslateY(0.136 * this.size);
                            break block0;
                        }
                        case TOP_RIGHT: {
                            this.valueText.setTranslateX(0.845 * this.size - this.valueText.getLayoutBounds().getWidth());
                            this.valueText.setTranslateY(0.136 * this.size);
                            break block0;
                        }
                    }
                    this.valueText.setTranslateX(0.845 * this.size - this.valueText.getLayoutBounds().getWidth());
                    this.valueText.setTranslateY(0.89 * this.size);
                    break;
                }
                case ELEKTRA: {
                    this.valueText.setFont(Fonts.elektra(0.1116 * this.size));
                    switch (knobPosition) {
                        case BOTTOM_LEFT: {
                            this.valueText.setTranslateX(0.545 * this.size - this.valueText.getLayoutBounds().getWidth());
                            this.valueText.setTranslateY(0.875 * this.size);
                            break block0;
                        }
                        case TOP_LEFT: {
                            this.valueText.setTranslateX(0.545 * this.size - this.valueText.getLayoutBounds().getWidth());
                            this.valueText.setTranslateY(0.1355 * this.size);
                            break block0;
                        }
                        case TOP_RIGHT: {
                            this.valueText.setTranslateX(0.845 * this.size - this.valueText.getLayoutBounds().getWidth());
                            this.valueText.setTranslateY(0.1355 * this.size);
                            break block0;
                        }
                    }
                    this.valueText.setTranslateX(0.845 * this.size - this.valueText.getLayoutBounds().getWidth());
                    this.valueText.setTranslateY(0.875 * this.size);
                    break;
                }
                default: {
                    this.valueText.setFont(Fonts.robotoMedium(0.09 * this.size));
                    switch (knobPosition) {
                        case BOTTOM_LEFT: {
                            this.valueText.setTranslateX(0.545 * this.size - this.valueText.getLayoutBounds().getWidth());
                            this.valueText.setTranslateY(0.87 * this.size);
                            break block0;
                        }
                        case TOP_LEFT: {
                            this.valueText.setTranslateX(0.545 * this.size - this.valueText.getLayoutBounds().getWidth());
                            this.valueText.setTranslateY(0.125 * this.size);
                            break block0;
                        }
                        case TOP_RIGHT: {
                            this.valueText.setTranslateX(0.845 * this.size - this.valueText.getLayoutBounds().getWidth());
                            this.valueText.setTranslateY(0.125 * this.size);
                            break block0;
                        }
                    }
                    this.valueText.setTranslateX(0.845 * this.size - this.valueText.getLayoutBounds().getWidth());
                    this.valueText.setTranslateY(0.87 * this.size);
                    break;
                }
            }
        } else {
            this.valueText.setFont(Fonts.robotoMedium(this.size * 0.1));
            switch (knobPosition) {
                case BOTTOM_LEFT: {
                    this.valueText.setTranslateX(0.43 * this.size - this.valueText.getLayoutBounds().getWidth());
                    this.valueText.setTranslateY(0.88 * this.size);
                    break;
                }
                case TOP_LEFT: {
                    this.valueText.setTranslateX(0.43 * this.size - this.valueText.getLayoutBounds().getWidth());
                    this.valueText.setTranslateY(0.12 * this.size);
                    break;
                }
                case TOP_RIGHT: {
                    this.valueText.setTranslateX(0.78 * this.size - this.valueText.getLayoutBounds().getWidth());
                    this.valueText.setTranslateY(0.12 * this.size);
                    break;
                }
                default: {
                    this.valueText.setTranslateX(0.78 * this.size - this.valueText.getLayoutBounds().getWidth());
                    this.valueText.setTranslateY(0.88 * this.size);
                }
            }
        }
    }

    private void resize() {
        double height;
        double width = ((Gauge)this.getSkinnable()).getWidth() - ((Gauge)this.getSkinnable()).getInsets().getLeft() - ((Gauge)this.getSkinnable()).getInsets().getRight();
        double d = this.size = width < (height = ((Gauge)this.getSkinnable()).getHeight() - ((Gauge)this.getSkinnable()).getInsets().getTop() - ((Gauge)this.getSkinnable()).getInsets().getBottom()) ? width : height;
        if (this.size > 0.0) {
            Pos knobPosition = ((Gauge)this.getSkinnable()).getKnobPosition();
            switch (knobPosition) {
                case BOTTOM_LEFT: {
                    this.centerX = this.size * 0.05;
                    this.centerY = this.size * 0.95;
                    break;
                }
                case TOP_LEFT: {
                    this.centerX = this.size * 0.05;
                    this.centerY = this.size * 0.05;
                    break;
                }
                case TOP_RIGHT: {
                    this.centerX = this.size * 0.95;
                    this.centerY = this.size * 0.05;
                    break;
                }
                default: {
                    this.centerX = this.size * 0.95;
                    this.centerY = this.size * 0.95;
                }
            }
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((((Gauge)this.getSkinnable()).getWidth() - this.size) * 0.5, (((Gauge)this.getSkinnable()).getHeight() - this.size) * 0.5);
            this.dropShadow.setRadius(0.008 * this.size);
            this.dropShadow.setOffsetY(0.008 * this.size);
            this.backgroundInnerShadow.setOffsetX(0.0);
            this.backgroundInnerShadow.setOffsetY(this.size * 0.03);
            this.backgroundInnerShadow.setRadius(this.size * 0.04);
            this.pane.setEffect((Effect)(((Gauge)this.getSkinnable()).isInnerShadowEnabled() ? this.backgroundInnerShadow : null));
            this.sectionsAndAreasCanvas.setWidth(1.95 * this.size);
            this.sectionsAndAreasCanvas.setHeight(1.95 * this.size);
            this.tickMarkCanvas.setWidth(1.95 * this.size);
            this.tickMarkCanvas.setHeight(1.95 * this.size);
            this.markerPane.setPrefSize(0.9 * this.size, 0.9 * this.size);
            boolean isFlatLed = Gauge.LedType.FLAT == ((Gauge)this.getSkinnable()).getLedType();
            this.ledSize = isFlatLed ? 0.05 * this.size : 0.06 * this.size;
            this.ledCanvas.setWidth(this.ledSize);
            this.ledCanvas.setHeight(this.ledSize);
            this.ledOffShadow = isFlatLed ? null : new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 0.07 * this.ledSize, 0.0, 0.0, 0.0);
            InnerShadow innerShadow = this.ledOnShadow = isFlatLed ? null : new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 0.07 * this.ledSize, 0.0, 0.0, 0.0);
            if (!isFlatLed) {
                this.ledOnShadow.setInput((Effect)new DropShadow(BlurType.TWO_PASS_BOX, ((Gauge)this.getSkinnable()).getLedColor(), 0.36 * this.ledSize, 0.0, 0.0, 0.0));
            }
            this.resizeText();
            if (((Gauge)this.getSkinnable()).isLcdVisible()) {
                this.lcd.setWidth(0.4 * this.size);
                this.lcd.setHeight(0.114 * this.size);
                this.lcd.setArcWidth(0.0125 * this.size);
                this.lcd.setArcHeight(0.0125 * this.size);
            }
            this.resizeValueText();
            this.needle.setCache(false);
            switch (((Gauge)this.getSkinnable()).getNeedleType()) {
                case BIG: {
                    double needleWidth = 0.11399999999999999 * this.size;
                    double needleHeight = TickLabelLocation.INSIDE == this.tickLabelLocation ? 0.9452499999999999 * this.size : 0.7885 * this.size;
                    Needle.INSTANCE.getPath(this.needle, needleWidth, needleHeight, Gauge.NeedleType.BIG, this.tickLabelLocation);
                    this.needle.relocate(this.centerX - this.needle.getLayoutBounds().getWidth() * 0.5, this.centerY - this.needle.getLayoutBounds().getHeight() * (TickLabelLocation.INSIDE == this.tickLabelLocation ? 0.93969849 : 0.92771084));
                    this.needleRotate.setPivotX(this.needle.getLayoutBounds().getWidth() * 0.5);
                    this.needleRotate.setPivotY(this.needle.getLayoutBounds().getHeight() * (TickLabelLocation.INSIDE == this.tickLabelLocation ? 0.93969849 : 0.92771084));
                    break;
                }
                case FAT: {
                    double needleWidth = this.size * 0.3;
                    double needleHeight = this.size * 0.505;
                    Needle.INSTANCE.getPath(this.needle, needleWidth, needleHeight, Gauge.NeedleType.FAT, this.tickLabelLocation);
                    this.needle.relocate(this.centerX - this.needle.getLayoutBounds().getWidth() * 0.5, this.centerY - this.needle.getLayoutBounds().getHeight() * 0.7029703);
                    this.needleRotate.setPivotX(this.needle.getLayoutBounds().getWidth() * 0.5);
                    this.needleRotate.setPivotY(this.needle.getLayoutBounds().getHeight() * 0.7029703);
                    break;
                }
                case SCIENTIFIC: {
                    double needleWidth = 0.19 * this.size;
                    double needleHeight = TickLabelLocation.INSIDE == this.tickLabelLocation ? 1.2255 * this.size : 1.0687499999999999 * this.size;
                    Needle.INSTANCE.getPath(this.needle, needleWidth, needleHeight, Gauge.NeedleType.SCIENTIFIC, this.tickLabelLocation);
                    this.needle.relocate(this.centerX - this.needle.getLayoutBounds().getWidth() * 0.5, this.centerY - (TickLabelLocation.INSIDE == this.tickLabelLocation ? this.needle.getLayoutBounds().getHeight() * 0.7248062 : this.needle.getLayoutBounds().getHeight() * 0.68444444));
                    this.needleRotate.setPivotX(this.needle.getLayoutBounds().getWidth() * 0.5);
                    this.needleRotate.setPivotY(this.needle.getLayoutBounds().getHeight() * (TickLabelLocation.INSIDE == this.tickLabelLocation ? 0.7248062 : 0.68444444));
                    break;
                }
                case AVIONIC: {
                    double needleWidth = 0.11399999999999999 * this.size;
                    double needleHeight = TickLabelLocation.INSIDE == this.tickLabelLocation ? 1.13525 * this.size : 0.9784999999999999 * this.size;
                    Needle.INSTANCE.getPath(this.needle, needleWidth, needleHeight, Gauge.NeedleType.AVIONIC, this.tickLabelLocation);
                    this.needle.relocate(this.centerX - this.needle.getLayoutBounds().getWidth() * 0.5, this.centerY - this.needle.getLayoutBounds().getHeight() * (TickLabelLocation.INSIDE == this.tickLabelLocation ? 0.78242678 : 0.74757282));
                    this.needleRotate.setPivotX(this.needle.getLayoutBounds().getWidth() * 0.5);
                    this.needleRotate.setPivotY(this.needle.getLayoutBounds().getHeight() * (TickLabelLocation.INSIDE == this.tickLabelLocation ? 0.78242678 : 0.74757282));
                    break;
                }
                case VARIOMETER: {
                    double needleWidth = this.size * ((Gauge)this.getSkinnable()).getNeedleSize().FACTOR;
                    double needleHeight = TickLabelLocation.INSIDE == this.tickLabelLocation ? 1.9 * this.size * 0.4675 : 1.9 * this.size * 0.385;
                    Needle.INSTANCE.getPath(this.needle, needleWidth, needleHeight, Gauge.NeedleType.VARIOMETER, this.tickLabelLocation);
                    this.needle.relocate(this.centerX - this.needle.getLayoutBounds().getWidth() * 0.5, this.centerY - this.needle.getLayoutBounds().getHeight());
                    this.needleRotate.setPivotX(this.needle.getLayoutBounds().getWidth() * 0.5);
                    this.needleRotate.setPivotY(this.needle.getLayoutBounds().getHeight());
                    break;
                }
                default: {
                    double needleWidth = this.size * ((Gauge)this.getSkinnable()).getNeedleSize().FACTOR;
                    double needleHeight = TickLabelLocation.INSIDE == this.tickLabelLocation ? this.size * 0.9085 : this.size * 0.75;
                    Needle.INSTANCE.getPath(this.needle, needleWidth, needleHeight, Gauge.NeedleType.STANDARD, this.tickLabelLocation);
                    this.needle.relocate(this.centerX - this.needle.getLayoutBounds().getWidth() * 0.5, this.centerY - this.needle.getLayoutBounds().getHeight());
                    this.needleRotate.setPivotX(this.needle.getLayoutBounds().getWidth() * 0.5);
                    this.needleRotate.setPivotY(this.needle.getLayoutBounds().getHeight());
                }
            }
            this.needle.setCache(true);
            this.needle.setCacheHint(CacheHint.ROTATE);
            this.knobCanvas.setWidth(this.size * 0.1);
            this.knobCanvas.setHeight(this.size * 0.1);
            switch (knobPosition) {
                case BOTTOM_LEFT: {
                    this.ledCanvas.relocate(this.size * 0.22, isFlatLed ? this.size * 0.72 : this.size * 0.732);
                    this.lcd.relocate(this.size * 0.15, 0.81 * this.size);
                    this.knobCanvas.relocate(0.0, this.size * 0.9);
                    break;
                }
                case TOP_LEFT: {
                    this.ledCanvas.relocate(this.size * 0.22, this.size * 0.22);
                    this.lcd.relocate(this.size * 0.15, 0.07 * this.size);
                    this.knobCanvas.relocate(0.0, 0.0);
                    break;
                }
                case TOP_RIGHT: {
                    this.ledCanvas.relocate(isFlatLed ? this.size * 0.72 : this.size * 0.732, this.size * 0.22);
                    this.lcd.relocate(this.size * 0.45, 0.07 * this.size);
                    this.knobCanvas.relocate(this.size * 0.9, 0.0);
                    break;
                }
                default: {
                    this.ledCanvas.relocate(isFlatLed ? this.size * 0.72 : this.size * 0.732, isFlatLed ? this.size * 0.72 : this.size * 0.732);
                    this.lcd.relocate(this.size * 0.45, 0.81 * this.size);
                    this.knobCanvas.relocate(this.size * 0.9, this.size * 0.9);
                }
            }
            this.buttonTooltip.setText(((Gauge)this.getSkinnable()).getButtonTooltipText());
        }
    }

    private void redraw() {
        this.locale = ((Gauge)this.getSkinnable()).getLocale();
        this.formatString = "%." + Integer.toString(((Gauge)this.getSkinnable()).getDecimals()) + "f";
        this.shadowGroup.setEffect((Effect)(((Gauge)this.getSkinnable()).isShadowsEnabled() ? this.dropShadow : null));
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Gauge)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(((Gauge)this.getSkinnable()).getBorderWidth() / 250.0 * this.size))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.tickLabelLocation = ((Gauge)this.getSkinnable()).getTickLabelLocation();
        this.scaleDirection = ((Gauge)this.getSkinnable()).getScaleDirection();
        if (((Gauge)this.getSkinnable()).getAreasVisible() | ((Gauge)this.getSkinnable()).getSectionsVisible()) {
            this.sectionsAndAreasCtx.clearRect(0.0, 0.0, this.size * 1.9, this.size * 1.9);
            this.drawAreasAndSections(this.sectionsAndAreasCtx);
        }
        this.tickMarkCanvas.setCache(false);
        this.tickMarkCtx.clearRect(0.0, 0.0, this.size * 1.9, this.size * 1.9);
        if (((Gauge)this.getSkinnable()).isGradientBarEnabled() && ((Gauge)this.getSkinnable()).getGradientLookup() != null) {
            this.drawGradientBar();
        }
        this.drawTickMarks();
        this.tickMarkCanvas.setCache(true);
        this.tickMarkCanvas.setCacheHint(CacheHint.QUALITY);
        if (((Gauge)this.getSkinnable()).isLedVisible()) {
            Color LED_COLOR = ((Gauge)this.getSkinnable()).getLedColor();
            switch (((Gauge)this.getSkinnable()).getLedType()) {
                case FLAT: {
                    this.ledFramePaint = Color.WHITE;
                    this.ledOnPaint = new LinearGradient(0.0, 0.25 * this.ledSize, 0.0, 0.74 * this.ledSize, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, LED_COLOR), new Stop(1.0, LED_COLOR.deriveColor(0.0, 1.0, 0.5, 1.0))});
                    this.ledOffPaint = new LinearGradient(0.0, 0.25 * this.ledSize, 0.0, 0.74 * this.ledSize, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, LED_COLOR.deriveColor(0.0, 1.0, 0.5, 1.0)), new Stop(1.0, LED_COLOR.deriveColor(0.0, 1.0, 0.13, 1.0))});
                    this.ledHighlightPaint = Color.TRANSPARENT;
                    break;
                }
                default: {
                    this.ledFramePaint = new LinearGradient(0.14 * this.ledSize, 0.14 * this.ledSize, 0.84 * this.ledSize, 0.84 * this.ledSize, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)20, (int)20, (int)20, (double)0.65)), new Stop(0.15, Color.rgb((int)20, (int)20, (int)20, (double)0.65)), new Stop(0.26, Color.rgb((int)41, (int)41, (int)41, (double)0.65)), new Stop(0.26, Color.rgb((int)41, (int)41, (int)41, (double)0.64)), new Stop(0.85, Color.rgb((int)200, (int)200, (int)200, (double)0.41)), new Stop(1.0, Color.rgb((int)200, (int)200, (int)200, (double)0.35))});
                    this.ledOnPaint = new LinearGradient(0.25 * this.ledSize, 0.25 * this.ledSize, 0.74 * this.ledSize, 0.74 * this.ledSize, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, LED_COLOR.deriveColor(0.0, 1.0, 0.77, 1.0)), new Stop(0.49, LED_COLOR.deriveColor(0.0, 1.0, 0.5, 1.0)), new Stop(1.0, LED_COLOR)});
                    this.ledOffPaint = new LinearGradient(0.25 * this.ledSize, 0.25 * this.ledSize, 0.74 * this.ledSize, 0.74 * this.ledSize, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, LED_COLOR.deriveColor(0.0, 1.0, 0.2, 1.0)), new Stop(0.49, LED_COLOR.deriveColor(0.0, 1.0, 0.13, 1.0)), new Stop(1.0, LED_COLOR.deriveColor(0.0, 1.0, 0.2, 1.0))});
                    this.ledHighlightPaint = new RadialGradient(0.0, 0.0, 0.3 * this.ledSize, 0.3 * this.ledSize, 0.29 * this.ledSize, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.WHITE), new Stop(1.0, Color.TRANSPARENT)});
                }
            }
            this.drawLed();
        }
        LcdDesign lcdDesign = ((Gauge)this.getSkinnable()).getLcdDesign();
        Color[] lcdColors = lcdDesign.getColors();
        if (((Gauge)this.getSkinnable()).isLcdVisible() && ((Gauge)this.getSkinnable()).isValueVisible()) {
            LinearGradient lcdGradient = new LinearGradient(0.0, 1.0, 0.0, this.lcd.getHeight() - 1.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, lcdColors[0]), new Stop(0.03, lcdColors[1]), new Stop(0.5, lcdColors[2]), new Stop(0.5, lcdColors[3]), new Stop(1.0, lcdColors[4])});
            Object lcdFramePaint = LcdDesign.FLAT_CUSTOM == lcdDesign ? lcdDesign.lcdForegroundColor : new LinearGradient(0.0, 0.0, 0.0, this.lcd.getHeight(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)26, (int)26, (int)26)), new Stop(0.01, Color.rgb((int)77, (int)77, (int)77)), new Stop(0.99, Color.rgb((int)77, (int)77, (int)77)), new Stop(1.0, Color.rgb((int)221, (int)221, (int)221))});
            this.lcd.setFill((Paint)lcdGradient);
            this.lcd.setStroke((Paint)lcdFramePaint);
        }
        this.titleText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.unitText.setFill((Paint)((Gauge)this.getSkinnable()).getUnitColor());
        this.subTitleText.setFill((Paint)((Gauge)this.getSkinnable()).getSubTitleColor());
        this.valueText.setFill((Paint)(((Gauge)this.getSkinnable()).isLcdVisible() ? lcdColors[5] : ((Gauge)this.getSkinnable()).getValueColor()));
        this.resizeText();
        Color needleColor = ((Gauge)this.getSkinnable()).getNeedleColor();
        switch (((Gauge)this.getSkinnable()).getNeedleShape()) {
            case ROUND: {
                this.needlePaint = new LinearGradient(this.needle.getLayoutBounds().getMinX(), 0.0, this.needle.getLayoutBounds().getMaxX(), 0.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, needleColor.darker()), new Stop(0.5, needleColor.brighter().brighter()), new Stop(1.0, needleColor.darker())});
                this.needle.setStrokeWidth(0.0);
                break;
            }
            case FLAT: {
                this.needlePaint = needleColor;
                this.needle.setStrokeWidth(0.0037037 * this.size);
                break;
            }
            default: {
                this.needlePaint = new LinearGradient(this.needle.getLayoutBounds().getMinX(), 0.0, this.needle.getLayoutBounds().getMaxX(), 0.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, needleColor.darker()), new Stop(0.5, needleColor.darker()), new Stop(0.5, needleColor.brighter()), new Stop(1.0, needleColor.brighter())});
                this.needle.setStrokeWidth(0.0);
            }
        }
        if (Gauge.NeedleType.AVIONIC == ((Gauge)this.getSkinnable()).getNeedleType()) {
            this.needlePaint = new LinearGradient(0.0, this.needle.getLayoutBounds().getMinY(), 0.0, this.needle.getLayoutBounds().getMaxY(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, needleColor), new Stop(0.3, needleColor), new Stop(0.3, Color.BLACK), new Stop(1.0, Color.BLACK)});
        }
        this.needle.setFill(this.needlePaint);
        this.needle.setStroke((Paint)((Gauge)this.getSkinnable()).getNeedleBorderColor());
        this.drawKnob(false);
        this.drawMarkers();
        this.thresholdTooltip.setText("Threshold\n(" + String.format(this.locale, this.formatString, ((Gauge)this.getSkinnable()).getThreshold()) + ")");
    }
}

