/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.tools.Helper;
import java.util.List;
import java.util.Locale;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class LevelSkin
extends SkinBase<Gauge>
implements Skin<Gauge> {
    private static final double PREFERRED_WIDTH = 216.0;
    private static final double PREFERRED_HEIGHT = 249.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final double ASPECT_RATIO = 1.15384615;
    private double width;
    private double height;
    private Pane pane;
    private Path tube;
    private Ellipse tubeTop;
    private Ellipse tubeBottom;
    private Path fluidBody;
    private CubicCurveTo fluidUpperLeft;
    private CubicCurveTo fluidUpperCenter;
    private CubicCurveTo fluidUpperRight;
    private Ellipse fluidTop;
    private Text valueText;
    private Text titleText;
    private Tooltip barTooltip;
    private String formatString;
    private Locale locale;
    private List<Section> sections;

    public LevelSkin(Gauge gauge) {
        super((Control)gauge);
        this.formatString = "%." + Integer.toString(gauge.getDecimals()) + "f";
        this.locale = gauge.getLocale();
        this.sections = gauge.getSections();
        this.barTooltip = new Tooltip();
        this.barTooltip.setTextAlignment(TextAlignment.CENTER);
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(((Gauge)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((Gauge)this.getSkinnable()).getPrefWidth() > 0.0 && ((Gauge)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((Gauge)this.getSkinnable()).setPrefSize(((Gauge)this.getSkinnable()).getPrefWidth(), ((Gauge)this.getSkinnable()).getPrefHeight());
            } else {
                ((Gauge)this.getSkinnable()).setPrefSize(216.0, 249.0);
            }
        }
        this.tube = new Path();
        this.tube.setFillRule(FillRule.EVEN_ODD);
        this.tube.setStroke(null);
        Tooltip.install((Node)this.tube, (Tooltip)this.barTooltip);
        this.tubeTop = new Ellipse();
        this.tubeTop.setStroke((Paint)Color.rgb((int)255, (int)255, (int)255, (double)0.5));
        this.tubeTop.setStrokeType(StrokeType.INSIDE);
        this.tubeTop.setStrokeWidth(1.0);
        this.tubeBottom = new Ellipse();
        this.tubeBottom.setStroke(null);
        this.fluidUpperLeft = new CubicCurveTo(47.07692307692308, 60.86666666666667, 0.0, 47.03333333333333, 0.0, 30.433333333333334);
        this.fluidUpperCenter = new CubicCurveTo(216.0, 47.03333333333333, 168.92307692307693, 60.86666666666667, 108.0, 60.86666666666667);
        this.fluidUpperRight = new CubicCurveTo(216.0, 177.06666666666666, 216.0, 30.433333333333334, 216.0, 30.433333333333334);
        this.fluidBody = new Path();
        this.fluidBody.getElements().add((Object)new MoveTo(0.0, 177.06666666666666));
        this.fluidBody.getElements().add((Object)new CubicCurveTo(0.0, 193.66666666666666, 47.07692307692308, 207.5, 108.0, 207.5));
        this.fluidBody.getElements().add((Object)new CubicCurveTo(168.92307692307693, 207.5, 216.0, 193.66666666666666, 216.0, 177.06666666666666));
        this.fluidBody.getElements().add((Object)this.fluidUpperRight);
        this.fluidBody.getElements().add((Object)this.fluidUpperCenter);
        this.fluidBody.getElements().add((Object)this.fluidUpperLeft);
        this.fluidBody.getElements().add((Object)new CubicCurveTo(0.0, 30.433333333333334, 0.0, 177.06666666666666, 0.0, 177.06666666666666));
        this.fluidBody.getElements().add((Object)new ClosePath());
        this.fluidBody.setFillRule(FillRule.EVEN_ODD);
        this.fluidBody.setStroke(null);
        this.fluidTop = new Ellipse();
        this.fluidTop.setStroke(null);
        this.valueText = new Text(String.format(this.locale, "%.0f%%", ((Gauge)this.getSkinnable()).getCurrentValue()));
        this.valueText.setMouseTransparent(true);
        Helper.enableNode((Node)this.valueText, ((Gauge)this.getSkinnable()).isValueVisible());
        this.titleText = new Text(((Gauge)this.getSkinnable()).getTitle());
        Helper.enableNode((Node)this.titleText, !((Gauge)this.getSkinnable()).getTitle().isEmpty());
        this.pane = new Pane(new Node[]{this.tubeBottom, this.fluidBody, this.fluidTop, this.tube, this.tubeTop, this.valueText, this.titleText});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Gauge)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(((Gauge)this.getSkinnable()).getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((Gauge)this.getSkinnable()).widthProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).heightProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).setOnUpdate(e -> this.handleEvents(e.eventType.name()));
        ((Gauge)this.getSkinnable()).currentValueProperty().addListener(e -> this.setBar(((Gauge)this.getSkinnable()).getCurrentValue()));
        this.handleEvents("VISIBILITY");
    }

    protected double computeMinWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return super.computePrefWidth(HEIGHT, TOP, RIGHT, BOTTOM, LEFT);
    }

    protected double computePrefHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return super.computePrefHeight(WIDTH, TOP, RIGHT, BOTTOM, LEFT);
    }

    protected double computeMaxWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 1024.0;
    }

    protected double computeMaxHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 1024.0;
    }

    protected void handleEvents(String EVENT_TYPE) {
        if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
            this.redraw();
        } else if ("REDRAW".equals(EVENT_TYPE)) {
            this.redraw();
        } else if ("RECALC".equals(EVENT_TYPE)) {
            if (((Gauge)this.getSkinnable()).isAutoScale()) {
                ((Gauge)this.getSkinnable()).calcAutoScale();
            }
            this.setBar(((Gauge)this.getSkinnable()).getCurrentValue());
            this.resize();
            this.redraw();
        } else if ("SECTION".equals(EVENT_TYPE)) {
            this.sections = ((Gauge)this.getSkinnable()).getSections();
            this.resize();
            this.redraw();
        } else if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.valueText, ((Gauge)this.getSkinnable()).isValueVisible());
            Helper.enableNode((Node)this.titleText, !((Gauge)this.getSkinnable()).getUnit().isEmpty());
            this.redraw();
        } else if ("FINISHED".equals(EVENT_TYPE)) {
            StringBuilder content = new StringBuilder(String.format(this.locale, this.formatString, ((Gauge)this.getSkinnable()).getValue())).append("\n(").append(this.valueText.getText()).append(")");
            this.barTooltip.setText(content.toString());
        }
    }

    private void setBar(double VALUE) {
        double factor = VALUE / ((Gauge)this.getSkinnable()).getRange();
        if (((Gauge)this.getSkinnable()).isGradientBarEnabled() && !((Gauge)this.getSkinnable()).getGradientBarStops().isEmpty()) {
            Color color = ((Gauge)this.getSkinnable()).getGradientLookup().getColorAt(factor);
            this.fluidBody.setFill((Paint)color);
            this.fluidTop.setFill((Paint)color.darker());
        } else if (((Gauge)this.getSkinnable()).getSectionsVisible() && !this.sections.isEmpty()) {
            int listSize = this.sections.size();
            for (int i = 0; i < listSize; ++i) {
                if (!this.sections.get(i).contains(VALUE)) continue;
                Color color = this.sections.get(i).getColor();
                this.fluidBody.setFill((Paint)color);
                this.fluidTop.setFill((Paint)color.darker());
                break;
            }
        }
        double centerY = this.height * 0.71111111 - factor * 0.58888889 * this.height;
        this.fluidTop.setCenterY(centerY);
        this.fluidUpperRight.setControlY1(centerY + 0.58888889 * this.height);
        this.fluidUpperRight.setControlY2(centerY);
        this.fluidUpperRight.setY(centerY);
        this.fluidUpperCenter.setControlY1(centerY + 0.06666667 * this.height);
        this.fluidUpperCenter.setControlY2(centerY + 0.12222222 * this.height);
        this.fluidUpperCenter.setY(centerY + 0.12222222 * this.height);
        this.fluidUpperLeft.setControlY1(centerY + 0.12222222 * this.height);
        this.fluidUpperLeft.setControlY2(centerY + 0.06666667 * this.height);
        this.fluidUpperLeft.setY(centerY);
        this.valueText.setText(String.format(this.locale, "%.0f%%", factor * 100.0));
        this.valueText.relocate((this.width - this.valueText.getLayoutBounds().getWidth()) * 0.5, (this.height - this.valueText.getLayoutBounds().getHeight()) * 0.5);
    }

    private void resizeText() {
        double fontSize = 0.175 * this.width;
        this.valueText.setFont(Fonts.latoRegular(fontSize));
        this.valueText.relocate((this.width - this.valueText.getLayoutBounds().getWidth()) * 0.5, (this.width - this.valueText.getLayoutBounds().getHeight()) * 0.5);
        fontSize = 0.15384615 * this.width;
        this.titleText.setFont(Fonts.robotoRegular(fontSize));
        this.titleText.setText(((Gauge)this.getSkinnable()).getTitle());
        Helper.adjustTextSize(this.titleText, 0.9 * this.width, fontSize);
        this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, 0.83333333 * this.height);
    }

    private void resize() {
        this.width = ((Gauge)this.getSkinnable()).getWidth() - ((Gauge)this.getSkinnable()).getInsets().getLeft() - ((Gauge)this.getSkinnable()).getInsets().getRight();
        this.height = ((Gauge)this.getSkinnable()).getHeight() - ((Gauge)this.getSkinnable()).getInsets().getTop() - ((Gauge)this.getSkinnable()).getInsets().getBottom();
        if (this.width > 0.0 && this.height > 0.0) {
            if (1.15384615 * this.width > this.height) {
                this.width = 1.0 / (1.15384615 / this.height);
            } else if (1.0 / (1.15384615 / this.height) > this.width) {
                this.height = 1.15384615 * this.width;
            }
            this.pane.setMaxSize(this.width, this.height);
            this.pane.relocate((((Gauge)this.getSkinnable()).getWidth() - this.width) * 0.5, (((Gauge)this.getSkinnable()).getHeight() - this.height) * 0.5);
            this.tubeBottom.setCenterX(this.width * 0.5);
            this.tubeBottom.setCenterY(this.height * 0.71111111);
            this.tubeBottom.setRadiusX(this.width * 0.5);
            this.tubeBottom.setRadiusY(this.height * 0.12222222);
            this.tubeBottom.setFill((Paint)new LinearGradient(0.0, 0.0, this.width, 0.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)0, (int)0, (int)0, (double)0.2)), new Stop(0.45, Color.rgb((int)255, (int)255, (int)255, (double)0.2)), new Stop(1.0, Color.rgb((int)0, (int)0, (int)0, (double)0.2))}));
            this.fluidUpperRight = new CubicCurveTo(this.width, 0.7111111111111111 * this.height, this.width, 0.12222222222222222 * this.height, this.width, 0.12222222222222222 * this.height);
            this.fluidUpperCenter = new CubicCurveTo(this.width, 0.18888888888888888 * this.height, 0.782051282051282 * this.width, 0.24444444444444444 * this.height, 0.5 * this.width, 0.24444444444444444 * this.height);
            this.fluidUpperLeft = new CubicCurveTo(0.21794871794871795 * this.width, 0.24444444444444444 * this.height, 0.0, 0.18888888888888888 * this.height, 0.0, 0.12222222222222222 * this.height);
            this.fluidBody.getElements().clear();
            this.fluidBody.getElements().add((Object)new MoveTo(0.0, 0.7111111111111111 * this.height));
            this.fluidBody.getElements().add((Object)new CubicCurveTo(0.0, 0.7777777777777778 * this.height, 0.21794871794871795 * this.width, 0.8333333333333334 * this.height, 0.5 * this.width, 0.8333333333333334 * this.height));
            this.fluidBody.getElements().add((Object)new CubicCurveTo(0.782051282051282 * this.width, 0.8333333333333334 * this.height, this.width, 0.7777777777777778 * this.height, this.width, 0.7111111111111111 * this.height));
            this.fluidBody.getElements().add((Object)this.fluidUpperRight);
            this.fluidBody.getElements().add((Object)this.fluidUpperCenter);
            this.fluidBody.getElements().add((Object)this.fluidUpperLeft);
            this.fluidBody.getElements().add((Object)new CubicCurveTo(0.0, 0.12222222222222222 * this.height, 0.0, 0.7111111111111111 * this.height, 0.0, 0.7111111111111111 * this.height));
            this.fluidBody.getElements().add((Object)new ClosePath());
            this.fluidTop.setCenterX(this.width * 0.5);
            this.fluidTop.setCenterY(this.height * 0.71111111);
            this.fluidTop.setRadiusX(this.width * 0.5);
            this.fluidTop.setRadiusY(this.height * 0.12222222);
            this.tube.getElements().clear();
            this.tube.getElements().add((Object)new MoveTo(0.0, 0.7111111111111111 * this.height));
            this.tube.getElements().add((Object)new CubicCurveTo(0.0, 0.7777777777777778 * this.height, 0.21794871794871795 * this.width, 0.8333333333333334 * this.height, 0.5 * this.width, 0.8333333333333334 * this.height));
            this.tube.getElements().add((Object)new CubicCurveTo(0.782051282051282 * this.width, 0.8333333333333334 * this.height, this.width, 0.7777777777777778 * this.height, this.width, 0.7111111111111111 * this.height));
            this.tube.getElements().add((Object)new CubicCurveTo(this.width, 0.7111111111111111 * this.height, this.width, 0.12222222222222222 * this.height, this.width, 0.12222222222222222 * this.height));
            this.tube.getElements().add((Object)new CubicCurveTo(this.width, 0.18888888888888888 * this.height, 0.782051282051282 * this.width, 0.24444444444444444 * this.height, 0.5 * this.width, 0.24444444444444444 * this.height));
            this.tube.getElements().add((Object)new CubicCurveTo(0.21794871794871795 * this.width, 0.24444444444444444 * this.height, 0.0, 0.18888888888888888 * this.height, 0.0, 0.12222222222222222 * this.height));
            this.tube.getElements().add((Object)new CubicCurveTo(0.0, 0.12222222222222222 * this.height, 0.0, 0.7111111111111111 * this.height, 0.0, 0.7111111111111111 * this.height));
            this.tube.getElements().add((Object)new ClosePath());
            this.tube.setFill((Paint)new LinearGradient(0.0, 0.0, this.width, 0.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)0, (int)0, (int)0, (double)0.35)), new Stop(0.2, Color.rgb((int)255, (int)255, (int)255, (double)0.15)), new Stop(0.26, Color.rgb((int)255, (int)255, (int)255, (double)0.2)), new Stop(0.33, Color.rgb((int)0, (int)0, (int)0, (double)0.22)), new Stop(0.81, Color.rgb((int)255, (int)255, (int)255, (double)0.2)), new Stop(1.0, Color.rgb((int)0, (int)0, (int)0, (double)0.35))}));
            this.tubeTop.setCenterX(this.width * 0.5);
            this.tubeTop.setCenterY(this.height * 0.12222222);
            this.tubeTop.setRadiusX(this.width * 0.5);
            this.tubeTop.setRadiusY(this.height * 0.12222222);
            this.tubeTop.setFill((Paint)new LinearGradient(0.0, 0.0, this.width, 0.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)0, (int)0, (int)0, (double)0.25)), new Stop(0.52, Color.rgb((int)200, (int)200, (int)200, (double)0.25)), new Stop(1.0, Color.rgb((int)0, (int)0, (int)0, (double)0.25))}));
            this.resizeText();
            this.redraw();
        }
    }

    private void redraw() {
        this.locale = ((Gauge)this.getSkinnable()).getLocale();
        this.formatString = "%." + Integer.toString(((Gauge)this.getSkinnable()).getDecimals()) + "f";
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Gauge)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(((Gauge)this.getSkinnable()).getBorderWidth() / 216.0 * this.width))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.fluidBody.setFill((Paint)((Gauge)this.getSkinnable()).getBarColor());
        this.fluidTop.setFill((Paint)((Gauge)this.getSkinnable()).getBarColor().darker());
        this.valueText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        this.titleText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.resizeText();
        this.setBar(((Gauge)this.getSkinnable()).getCurrentValue());
    }
}

