/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.tools.ConicalGradient;
import eu.hansolo.medusa.tools.Helper;
import java.util.List;
import java.util.Locale;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Arc;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Text;

public class BarSkin
extends SkinBase<Gauge>
implements Skin<Gauge> {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final double ANGLE_RANGE = 360.0;
    private double size;
    private Text titleText;
    private Text valueText;
    private Text unitText;
    private Circle dot;
    private Circle fakeDot;
    private Arc arc;
    private Circle circle;
    private Pane pane;
    private DropShadow shadow;
    private ConicalGradient gradient;
    private double center;
    private double range;
    private double angleStep;
    private String formatString;
    private Locale locale;

    public BarSkin(Gauge gauge) {
        super((Control)gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.range = gauge.getRange();
        this.angleStep = -360.0 / this.range;
        this.formatString = "%." + Integer.toString(gauge.getDecimals()) + "f";
        this.locale = gauge.getLocale();
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(((Gauge)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((Gauge)this.getSkinnable()).getPrefWidth() > 0.0 && ((Gauge)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((Gauge)this.getSkinnable()).setPrefSize(((Gauge)this.getSkinnable()).getPrefWidth(), ((Gauge)this.getSkinnable()).getPrefHeight());
            } else {
                ((Gauge)this.getSkinnable()).setPrefSize(250.0, 250.0);
            }
        }
        Color barColor = ((Gauge)this.getSkinnable()).getBarColor();
        ((Gauge)this.getSkinnable()).setGradientBarStops(new Stop(0.0, barColor), new Stop(0.01, barColor), new Stop(0.75, barColor.deriveColor(-10.0, 1.0, 1.0, 1.0)), new Stop(1.0, barColor.deriveColor(-20.0, 1.0, 1.0, 1.0)));
        this.shadow = new DropShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.45), 2.5, 0.0, 2.5, 0.0);
        this.circle = new Circle();
        this.circle.setFill(null);
        this.arc = new Arc(125.0, 125.0, 240.0, 120.0, 90.0, 0.0);
        this.arc.setStrokeWidth(2.0);
        this.arc.setStrokeType(StrokeType.CENTERED);
        this.arc.setStrokeLineCap(StrokeLineCap.ROUND);
        this.arc.setFill(null);
        this.fakeDot = new Circle();
        this.fakeDot.setStroke(null);
        this.dot = new Circle();
        this.dot.setStroke(null);
        this.dot.setVisible(false);
        this.dot.setEffect((Effect)this.shadow);
        this.titleText = new Text(((Gauge)this.getSkinnable()).getTitle());
        this.titleText.setFont(Fonts.robotoLight(125.0));
        this.titleText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        Helper.enableNode((Node)this.titleText, !((Gauge)this.getSkinnable()).getTitle().isEmpty());
        this.valueText = new Text(String.format(this.locale, this.formatString, ((Gauge)this.getSkinnable()).getCurrentValue()));
        this.valueText.setFont(Fonts.robotoRegular(68.33250000000001));
        this.valueText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        Helper.enableNode((Node)this.valueText, ((Gauge)this.getSkinnable()).isValueVisible());
        this.unitText = new Text(((Gauge)this.getSkinnable()).getUnit());
        this.unitText.setFont(Fonts.robotoLight(20.0));
        this.unitText.setFill((Paint)((Gauge)this.getSkinnable()).getUnitColor());
        Helper.enableNode((Node)this.unitText, !((Gauge)this.getSkinnable()).getUnit().isEmpty());
        this.pane = new Pane(new Node[]{this.circle, this.arc, this.fakeDot, this.dot, this.titleText, this.valueText, this.unitText});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((Gauge)this.getSkinnable()).widthProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).heightProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).setOnUpdate(e -> this.handleEvents(e.eventType.name()));
        ((Gauge)this.getSkinnable()).currentValueProperty().addListener(o -> this.redraw());
        ((Gauge)this.getSkinnable()).barColorProperty().addListener(o -> {
            Color barColor = ((Gauge)this.getSkinnable()).getBarColor();
            ((Gauge)this.getSkinnable()).setGradientBarStops(new Stop(0.0, barColor), new Stop(0.01, barColor), new Stop(0.75, barColor.deriveColor(-10.0, 1.0, 1.0, 1.0)), new Stop(1.0, barColor.deriveColor(-20.0, 1.0, 1.0, 1.0)));
            this.resize();
        });
        ((Gauge)this.getSkinnable()).titleProperty().addListener(o -> {
            this.titleText.setText(((Gauge)this.getSkinnable()).getTitle());
            this.resizeTitleText();
        });
        ((Gauge)this.getSkinnable()).unitProperty().addListener(o -> {
            this.unitText.setText(((Gauge)this.getSkinnable()).getUnit());
            this.resizeUnitText();
        });
    }

    protected double computeMinWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return super.computePrefWidth(HEIGHT, TOP, RIGHT, BOTTOM, LEFT);
    }

    protected double computePrefHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return super.computePrefHeight(WIDTH, TOP, RIGHT, BOTTOM, LEFT);
    }

    protected double computeMaxWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 1024.0;
    }

    protected double computeMaxHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 1024.0;
    }

    private void handleEvents(String EVENT_TYPE) {
        if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
            this.redraw();
        } else if ("REDRAW".equals(EVENT_TYPE)) {
            this.redraw();
        } else if ("RECALC".equals(EVENT_TYPE)) {
            this.range = ((Gauge)this.getSkinnable()).getRange();
            this.angleStep = -360.0 / this.range;
            this.redraw();
        }
    }

    private void resizeTitleText() {
        double maxWidth = 0.48 * this.size;
        double fontSize = 0.08 * this.size;
        this.titleText.setFont(Fonts.robotoLight(fontSize));
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        this.titleText.relocate((this.size - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.25);
    }

    private void resizeValueText() {
        double maxWidth = 0.5 * this.size;
        double fontSize = 0.3 * this.size;
        this.valueText.setFont(Fonts.robotoRegular(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
        this.valueText.relocate((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5, (this.size - this.valueText.getLayoutBounds().getHeight()) * 0.5);
    }

    private void resizeUnitText() {
        double maxWidth = 0.56667 * this.size;
        double fontSize = 0.08 * this.size;
        this.unitText.setFont(Fonts.robotoLight(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        this.unitText.relocate((this.size - this.unitText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.68);
    }

    private void resize() {
        double height;
        double width = ((Gauge)this.getSkinnable()).getWidth() - ((Gauge)this.getSkinnable()).getInsets().getLeft() - ((Gauge)this.getSkinnable()).getInsets().getRight();
        double d = this.size = width < (height = ((Gauge)this.getSkinnable()).getHeight() - ((Gauge)this.getSkinnable()).getInsets().getTop() - ((Gauge)this.getSkinnable()).getInsets().getBottom()) ? width : height;
        if (width > 0.0 && height > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.setPrefSize(this.size, this.size);
            this.pane.relocate((width - this.size) * 0.5, (height - this.size) * 0.5);
            this.locale = ((Gauge)this.getSkinnable()).getLocale();
            this.formatString = "%." + Integer.toString(((Gauge)this.getSkinnable()).getDecimals()) + "f";
            this.center = this.size * 0.5;
            this.circle.setCenterX(this.center);
            this.circle.setCenterY(this.center);
            this.circle.setRadius(this.size * 0.44);
            this.circle.setStrokeWidth(this.size * 0.11);
            this.arc.setCenterX(this.center);
            this.arc.setCenterY(this.center);
            this.arc.setRadiusX(this.size * 0.44);
            this.arc.setRadiusY(this.size * 0.44);
            this.arc.setStrokeWidth(this.size * 0.11);
            this.shadow.setRadius(0.03 * this.size);
            this.shadow.setOffsetX(0.03 * this.size);
            Color barColor = ((Gauge)this.getSkinnable()).getBarColor();
            double currentValue = ((Gauge)this.getSkinnable()).getCurrentValue();
            List<Stop> gradientBarStops = ((Gauge)this.getSkinnable()).getGradientBarStops();
            this.circle.setStroke((Paint)Color.color((double)barColor.getRed(), (double)barColor.getGreen(), (double)barColor.getBlue(), (double)0.13));
            Rectangle bounds = new Rectangle(0.0, 0.0, this.size, this.size);
            this.gradient = new ConicalGradient(this.center, this.center, Gauge.ScaleDirection.CLOCKWISE, gradientBarStops);
            this.arc.setStroke((Paint)this.gradient.getImagePattern(bounds));
            this.arc.setLength(currentValue * this.angleStep);
            this.fakeDot.setRadius(this.size * 0.055);
            this.fakeDot.setFill((Paint)gradientBarStops.get(0).getColor());
            this.dot.setRadius(this.size * 0.055);
            this.dot.setFill((Paint)gradientBarStops.get(3).getColor());
            this.dot.setCenterX(this.center + this.arc.getRadiusX() * Math.sin(Math.toRadians(180.0 - currentValue * this.angleStep)));
            this.dot.setCenterY(this.center + this.arc.getRadiusY() * Math.cos(Math.toRadians(180.0 - currentValue * this.angleStep)));
            this.titleText.setFill((Paint)barColor);
            this.resizeTitleText();
            this.resizeValueText();
            this.resizeUnitText();
            this.redraw();
        }
    }

    private void redraw() {
        double currentValue = ((Gauge)this.getSkinnable()).getCurrentValue();
        double angle = currentValue * this.angleStep;
        double rotate = angle < -360.0 ? angle + 360.0 : 0.0;
        this.arc.setRotate(-rotate);
        this.arc.setLength(Helper.clamp(-360.0, 0.0, angle));
        this.dot.setRotate(-angle);
        this.dot.setVisible(angle < -345.0);
        if (angle < -360.0) {
            this.fakeDot.setCenterX(this.center + this.arc.getRadiusX() * Math.sin(Math.toRadians(180.0 + angle)));
            this.fakeDot.setCenterY(this.center + this.arc.getRadiusY() * Math.cos(Math.toRadians(180.0 + angle)));
        } else {
            this.fakeDot.setCenterX(this.center + this.arc.getRadiusX() * Math.sin(Math.toRadians(180.0)));
            this.fakeDot.setCenterY(this.center + this.arc.getRadiusY() * Math.cos(Math.toRadians(180.0)));
        }
        this.dot.setCenterX(this.center + this.arc.getRadiusX() * Math.sin(Math.toRadians(180.0 + angle)));
        this.dot.setCenterY(this.center + this.arc.getRadiusY() * Math.cos(Math.toRadians(180.0 + angle)));
        this.titleText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.valueText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        this.unitText.setFill((Paint)((Gauge)this.getSkinnable()).getUnitColor());
        this.valueText.setText(String.format(((Gauge)this.getSkinnable()).getLocale(), this.formatString, currentValue));
        this.resizeValueText();
    }
}

