/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Clock;
import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.TickLabelOrientation;
import eu.hansolo.medusa.tools.Helper;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

public class DesignClockSkin
extends SkinBase<Clock>
implements Skin<Clock> {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double size;
    private double rotationRadius;
    private Canvas tickCanvas;
    private GraphicsContext tickCtx;
    private Circle clip;
    private Line needle;
    private Pane pane;
    private Group shadowGroup;
    private DropShadow dropShadow;
    private InnerShadow innerShadow;

    public DesignClockSkin(Clock clock) {
        super((Control)clock);
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(((Clock)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((Clock)this.getSkinnable()).getPrefWidth() > 0.0 && ((Clock)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((Clock)this.getSkinnable()).setPrefSize(((Clock)this.getSkinnable()).getPrefWidth(), ((Clock)this.getSkinnable()).getPrefHeight());
            } else {
                ((Clock)this.getSkinnable()).setPrefSize(250.0, 250.0);
            }
        }
        this.rotationRadius = 312.5;
        this.clip = new Circle(125.0, 125.0, 125.0);
        this.tickCanvas = new Canvas(250.0, 250.0);
        this.tickCanvas.setClip((Node)this.clip);
        this.tickCtx = this.tickCanvas.getGraphicsContext2D();
        this.needle = new Line(125.0, 0.0, 125.0, 250.0);
        this.needle.setFill(null);
        this.needle.setStrokeLineCap(StrokeLineCap.BUTT);
        this.needle.setStroke((Paint)((Clock)this.getSkinnable()).getHourColor());
        this.dropShadow = new DropShadow();
        this.dropShadow = new DropShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.25), 3.75, 0.0, 0.0, 3.75);
        this.shadowGroup = new Group(new Node[]{this.needle});
        this.shadowGroup.setEffect((Effect)(((Clock)this.getSkinnable()).getShadowsEnabled() ? this.dropShadow : null));
        this.innerShadow = new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 4.0, 0.0, 0.0, 1.0);
        this.pane = new Pane(new Node[]{this.tickCanvas, this.shadowGroup});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Clock)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(((Clock)this.getSkinnable()).getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Clock)this.getSkinnable()).getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.pane.setEffect((Effect)this.innerShadow);
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((Clock)this.getSkinnable()).widthProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Clock)this.getSkinnable()).heightProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Clock)this.getSkinnable()).setOnUpdate(e -> this.handleEvents(e.eventType.name()));
        if (((Clock)this.getSkinnable()).isAnimated()) {
            ((Clock)this.getSkinnable()).currentTimeProperty().addListener(o -> this.updateTime(ZonedDateTime.ofInstant(Instant.ofEpochSecond(((Clock)this.getSkinnable()).getCurrentTime()), ZoneId.of(ZoneId.systemDefault().getId()))));
        } else {
            ((Clock)this.getSkinnable()).timeProperty().addListener(o -> this.updateTime(((Clock)this.getSkinnable()).getTime()));
        }
    }

    protected double computeMinWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return super.computePrefWidth(HEIGHT, TOP, RIGHT, BOTTOM, LEFT);
    }

    protected double computePrefHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return super.computePrefHeight(WIDTH, TOP, RIGHT, BOTTOM, LEFT);
    }

    protected double computeMaxWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 1024.0;
    }

    protected double computeMaxHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 1024.0;
    }

    private void handleEvents(String EVENT_TYPE) {
        if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
            this.redraw();
        } else if ("REDRAW".equals(EVENT_TYPE)) {
            this.redraw();
        } else if (!"VISIBILITY".equals(EVENT_TYPE) && "SECTION".equals(EVENT_TYPE)) {
            this.redraw();
        }
    }

    private void drawTicks() {
        double ticksSize = this.size * 2.5;
        double startAngle = 180.0;
        double angleStep = 5.0;
        Point2D center = new Point2D(ticksSize * 0.5, ticksSize * 0.5);
        Color hourTickMarkColor = ((Clock)this.getSkinnable()).getHourTickMarkColor();
        Color minuteTickMarkColor = ((Clock)this.getSkinnable()).getMinuteTickMarkColor();
        Color tickLabelColor = ((Clock)this.getSkinnable()).getTickLabelColor();
        boolean hourTickMarksVisible = ((Clock)this.getSkinnable()).isHourTickMarksVisible();
        boolean minuteTickMarksVisible = ((Clock)this.getSkinnable()).isMinuteTickMarksVisible();
        boolean tickLabelsVisible = ((Clock)this.getSkinnable()).isTickLabelsVisible();
        Font font = Fonts.robotoRegular(ticksSize * 0.084);
        this.tickCtx.clearRect(0.0, 0.0, ticksSize, ticksSize);
        this.tickCtx.setLineCap(StrokeLineCap.ROUND);
        this.tickCtx.setFont(font);
        this.tickCtx.setLineWidth(ticksSize * 0.007);
        double angle = 0.0;
        double counter = 0.0;
        while (Double.compare(counter, 72.0) <= 0) {
            double sinValue = Math.sin(Math.toRadians(angle + startAngle));
            double cosValue = Math.cos(Math.toRadians(angle + startAngle));
            Point2D innerPoint = new Point2D(center.getX() + ticksSize * 0.45 * sinValue, center.getY() + ticksSize * 0.45 * cosValue);
            Point2D innerFiveMinutePoint = new Point2D(center.getX() + ticksSize * 0.47 * sinValue, center.getY() + ticksSize * 0.47 * cosValue);
            Point2D innerMinutePoint = new Point2D(center.getX() + ticksSize * 0.49 * sinValue, center.getY() + ticksSize * 0.49 * cosValue);
            Point2D outerPoint = new Point2D(center.getX() + ticksSize * 0.495 * sinValue, center.getY() + ticksSize * 0.495 * cosValue);
            Point2D textPoint = new Point2D(center.getX() + ticksSize * 0.385 * sinValue, center.getY() + ticksSize * 0.385 * cosValue);
            if (counter % 6.0 == 0.0) {
                this.tickCtx.setStroke((Paint)hourTickMarkColor);
                if (hourTickMarksVisible) {
                    this.tickCtx.strokeLine(innerPoint.getX(), innerPoint.getY(), outerPoint.getX(), outerPoint.getY());
                } else if (minuteTickMarksVisible) {
                    this.tickCtx.strokeLine(innerMinutePoint.getX(), innerMinutePoint.getY(), outerPoint.getX(), outerPoint.getY());
                }
                if (tickLabelsVisible) {
                    this.tickCtx.save();
                    this.tickCtx.translate(textPoint.getX(), textPoint.getY());
                    Helper.rotateContextForText(this.tickCtx, startAngle, angle, TickLabelOrientation.HORIZONTAL);
                    this.tickCtx.setTextAlign(TextAlignment.CENTER);
                    this.tickCtx.setTextBaseline(VPos.CENTER);
                    this.tickCtx.setFill((Paint)tickLabelColor);
                    if (counter == 0.0) {
                        this.tickCtx.fillText("12", 0.0, 0.0);
                    } else {
                        this.tickCtx.fillText(Integer.toString((int)(counter / 6.0)), 0.0, 0.0);
                    }
                    this.tickCtx.restore();
                }
            } else if (counter % 3.0 == 0.0 && minuteTickMarksVisible) {
                this.tickCtx.setStroke((Paint)minuteTickMarkColor);
                this.tickCtx.strokeLine(innerFiveMinutePoint.getX(), innerFiveMinutePoint.getY(), outerPoint.getX(), outerPoint.getY());
            } else if (counter % 1.0 == 0.0 && minuteTickMarksVisible) {
                this.tickCtx.setStroke((Paint)minuteTickMarkColor);
                this.tickCtx.strokeLine(innerMinutePoint.getX(), innerMinutePoint.getY(), outerPoint.getX(), outerPoint.getY());
            }
            angle -= angleStep;
            counter += 1.0;
        }
    }

    public void updateTime(ZonedDateTime TIME) {
        double rotationAngle = 0.5 * ((double)(60 * TIME.getHour() + TIME.getMinute()) + (double)TIME.getSecond() * 0.0166666667 + (double)TIME.get(ChronoField.MILLI_OF_SECOND) * 1.66667E-5);
        double rotationX = this.size * 0.5 + this.rotationRadius * Math.sin(Math.toRadians(rotationAngle + 180.0));
        double rotationY = this.size * 0.5 - this.rotationRadius * Math.cos(Math.toRadians(rotationAngle + 180.0));
        this.tickCanvas.relocate(rotationX - this.tickCanvas.getHeight() * 0.5, rotationY - this.tickCanvas.getHeight() * 0.5);
        this.needle.setRotate(rotationAngle);
        double canvasCenterX = this.tickCanvas.getWidth() * 0.5;
        double canvasCenterY = this.tickCanvas.getHeight() * 0.5;
        double radius = this.tickCanvas.getHeight() * 0.372;
        double rotX = canvasCenterX + radius * Math.sin(Math.toRadians(rotationAngle));
        double rotY = canvasCenterY - radius * Math.cos(Math.toRadians(rotationAngle));
        this.clip.setCenterX(rotX);
        this.clip.setCenterY(rotY);
    }

    private void resize() {
        double height;
        double width = ((Clock)this.getSkinnable()).getWidth() - ((Clock)this.getSkinnable()).getInsets().getLeft() - ((Clock)this.getSkinnable()).getInsets().getRight();
        double d = this.size = width < (height = ((Clock)this.getSkinnable()).getHeight() - ((Clock)this.getSkinnable()).getInsets().getTop() - ((Clock)this.getSkinnable()).getInsets().getBottom()) ? width : height;
        if (this.size > 0.0) {
            this.rotationRadius = this.size * 0.93;
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((((Clock)this.getSkinnable()).getWidth() - this.size) * 0.5, (((Clock)this.getSkinnable()).getHeight() - this.size) * 0.5);
            this.dropShadow.setRadius(0.008 * this.size);
            this.dropShadow.setOffsetY(0.008 * this.size);
            this.innerShadow.setRadius(0.016 * this.size);
            this.innerShadow.setOffsetY(0.004 * this.size);
            this.clip.setRadius(this.size * 0.5);
            this.tickCanvas.setWidth(this.size * 2.5);
            this.tickCanvas.setHeight(this.size * 2.5);
            this.tickCanvas.setClip((Node)this.clip);
            this.needle.setStrokeWidth(this.size * 0.008);
            this.needle.setStartX(this.size * 0.5);
            this.needle.setEndX(this.size * 0.5);
            this.needle.setStartY(0.0);
            this.needle.setEndY(this.size);
        }
    }

    private void redraw() {
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Clock)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(((Clock)this.getSkinnable()).getBorderWidth() / 250.0 * this.size))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Clock)this.getSkinnable()).getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.shadowGroup.setEffect((Effect)(((Clock)this.getSkinnable()).getShadowsEnabled() ? this.dropShadow : null));
        this.tickCanvas.setCache(false);
        this.drawTicks();
        this.tickCanvas.setCache(true);
        this.tickCanvas.setCacheHint(CacheHint.QUALITY);
        this.needle.setStroke((Paint)((Clock)this.getSkinnable()).getHourColor());
        ZonedDateTime time = ((Clock)this.getSkinnable()).getTime();
        this.updateTime(time);
    }
}

