/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.tools.Helper;
import java.util.List;
import javafx.geometry.Insets;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Text;

public class SimpleSectionSkin
extends SkinBase<Gauge>
implements Skin<Gauge> {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final double ANGLE_RANGE = 300.0;
    private double size;
    private Canvas sectionCanvas;
    private GraphicsContext sectionCtx;
    private Arc barBackground;
    private Arc bar;
    private Text titleText;
    private Text valueText;
    private Text unitText;
    private Pane pane;
    private Paint backgroundPaint;
    private Paint borderPaint;
    private double borderWidth;
    private List<Section> sections;
    private String formatString;

    public SimpleSectionSkin(Gauge gauge) {
        super((Control)gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.formatString = "%." + Integer.toString(gauge.getDecimals()) + "f";
        this.sections = gauge.getSections();
        this.init();
        this.initGraphics();
        this.registerListeners();
        this.setBar(gauge.getCurrentValue());
    }

    private void init() {
        if ((Double.compare(((Gauge)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getHeight(), 0.0) <= 0) && ((Gauge)this.getSkinnable()).getPrefWidth() < 0.0 && ((Gauge)this.getSkinnable()).getPrefHeight() < 0.0) {
            ((Gauge)this.getSkinnable()).setPrefSize(250.0, 250.0);
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMinSize(50.0, 50.0);
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.sectionCanvas = new Canvas(250.0, 250.0);
        this.sectionCtx = this.sectionCanvas.getGraphicsContext2D();
        this.barBackground = new Arc(125.0, 125.0, 100.0, 100.0, ((Gauge)this.getSkinnable()).getStartAngle() + 150.0, 300.0);
        this.barBackground.setType(ArcType.OPEN);
        this.barBackground.setStroke((Paint)((Gauge)this.getSkinnable()).getBarBackgroundColor());
        this.barBackground.setStrokeWidth(31.25);
        this.barBackground.setStrokeLineCap(StrokeLineCap.BUTT);
        this.barBackground.setFill(null);
        this.bar = new Arc(125.0, 125.0, 100.0, 100.0, ((Gauge)this.getSkinnable()).getStartAngle() + 90.0, 0.0);
        this.bar.setType(ArcType.OPEN);
        this.bar.setStroke((Paint)((Gauge)this.getSkinnable()).getBarColor());
        this.bar.setStrokeWidth(31.25);
        this.bar.setStrokeLineCap(StrokeLineCap.BUTT);
        this.bar.setFill(null);
        this.titleText = new Text(((Gauge)this.getSkinnable()).getTitle());
        this.titleText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        Helper.enableNode((Node)this.titleText, !((Gauge)this.getSkinnable()).getTitle().isEmpty());
        this.valueText = new Text();
        this.valueText.setStroke(null);
        this.valueText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        Helper.enableNode((Node)this.valueText, ((Gauge)this.getSkinnable()).isValueVisible());
        this.unitText = new Text();
        this.unitText.setStroke(null);
        this.unitText.setFill((Paint)((Gauge)this.getSkinnable()).getUnitColor());
        Helper.enableNode((Node)this.unitText, ((Gauge)this.getSkinnable()).isValueVisible() && !((Gauge)this.getSkinnable()).getUnit().isEmpty());
        this.pane = new Pane(new Node[]{this.barBackground, this.sectionCanvas, this.titleText, this.valueText, this.unitText, this.bar});
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.backgroundPaint, new CornerRadii(1024.0), Insets.EMPTY)}));
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.borderPaint, BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.borderWidth))}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((Gauge)this.getSkinnable()).widthProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).heightProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).decimalsProperty().addListener(o -> this.handleEvents("DECIMALS"));
        ((Gauge)this.getSkinnable()).setOnUpdate(e -> this.handleEvents(e.eventType.name()));
        ((Gauge)this.getSkinnable()).currentValueProperty().addListener(o -> this.setBar(((Gauge)this.getSkinnable()).getCurrentValue()));
        ((Gauge)this.getSkinnable()).decimalsProperty().addListener(o -> this.handleEvents("DECIMALS"));
    }

    private void handleEvents(String EVENT_TYPE) {
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.valueText, ((Gauge)this.getSkinnable()).isValueVisible());
            Helper.enableNode((Node)this.unitText, ((Gauge)this.getSkinnable()).isValueVisible() && !((Gauge)this.getSkinnable()).getUnit().isEmpty());
        } else if ("SECTIONS".equals(EVENT_TYPE)) {
            this.sections = ((Gauge)this.getSkinnable()).getSections();
        } else if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
            this.redraw();
        } else if ("REDRAW".equals(EVENT_TYPE)) {
            this.redraw();
        } else if ("RECALC".equals(EVENT_TYPE)) {
            this.redraw();
        } else if ("DECIMALS".equals(EVENT_TYPE)) {
            this.formatString = "%." + Integer.toString(((Gauge)this.getSkinnable()).getDecimals()) + "f";
        }
    }

    private void setBar(double VALUE) {
        if (((Gauge)this.getSkinnable()).getMinValue() > 0.0) {
            this.bar.setLength((((Gauge)this.getSkinnable()).getMinValue() - VALUE) * ((Gauge)this.getSkinnable()).getAngleStep());
        } else {
            this.bar.setLength(-VALUE * ((Gauge)this.getSkinnable()).getAngleStep());
        }
        if (((Gauge)this.getSkinnable()).getSectionsVisible() && !this.sections.isEmpty()) {
            for (Section section : this.sections) {
                if (!section.contains(VALUE)) continue;
                this.bar.setStroke((Paint)section.getColor());
                break;
            }
        }
        this.valueText.setText(String.format(((Gauge)this.getSkinnable()).getLocale(), this.formatString, VALUE));
        this.valueText.setLayoutX((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5);
    }

    private void drawBackground() {
        this.sectionCanvas.setCache(false);
        this.sectionCtx.setLineCap(StrokeLineCap.BUTT);
        this.sectionCtx.clearRect(0.0, 0.0, this.size, this.size);
        if (((Gauge)this.getSkinnable()).getSectionsVisible() && !this.sections.isEmpty()) {
            double xy = 0.012 * this.size;
            double wh = this.size * 0.976;
            double minValue = ((Gauge)this.getSkinnable()).getMinValue();
            double maxValue = ((Gauge)this.getSkinnable()).getMaxValue();
            double angleStep = ((Gauge)this.getSkinnable()).getAngleStep();
            this.sectionCtx.setLineWidth(this.size * 0.025);
            this.sectionCtx.setLineCap(StrokeLineCap.BUTT);
            for (int i = 0; i < this.sections.size(); ++i) {
                double sectionStartAngle;
                Section section = this.sections.get(i);
                if (Double.compare(section.getStart(), maxValue) > 0 || Double.compare(section.getStop(), minValue) < 0) continue;
                if (Double.compare(section.getStart(), minValue) < 0 && Double.compare(section.getStop(), maxValue) < 0) {
                    sectionStartAngle = 0.0;
                } else {
                    double d = sectionStartAngle = Gauge.ScaleDirection.CLOCKWISE == ((Gauge)this.getSkinnable()).getScaleDirection() ? (section.getStart() - minValue) * angleStep : -(section.getStart() - minValue) * angleStep;
                }
                double sectionAngleExtend = Double.compare(section.getStop(), maxValue) > 0 ? (Gauge.ScaleDirection.CLOCKWISE == ((Gauge)this.getSkinnable()).getScaleDirection() ? (maxValue - section.getStart()) * angleStep : -(maxValue - section.getStart()) * angleStep) : (Double.compare(section.getStart(), minValue) < 0 ? (Gauge.ScaleDirection.CLOCKWISE == ((Gauge)this.getSkinnable()).getScaleDirection() ? (section.getStop() - minValue) * ((Gauge)this.getSkinnable()).getAngleStep() : -(section.getStop() - minValue) * angleStep) : (Gauge.ScaleDirection.CLOCKWISE == ((Gauge)this.getSkinnable()).getScaleDirection() ? (section.getStop() - section.getStart()) * angleStep : -(section.getStop() - section.getStart()) * angleStep));
                this.sectionCtx.save();
                this.sectionCtx.setStroke((Paint)section.getColor());
                this.sectionCtx.strokeArc(xy, xy, wh, wh, -(120.0 + sectionStartAngle), -sectionAngleExtend, ArcType.OPEN);
                this.sectionCtx.restore();
            }
        }
        this.sectionCanvas.setCache(true);
        this.sectionCanvas.setCacheHint(CacheHint.QUALITY);
    }

    private void resizeValueText() {
        double maxWidth = this.size * 0.86466165;
        double fontSize = this.size * 0.2556391;
        this.valueText.setFont(Fonts.latoLight(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
        this.valueText.relocate((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5, (this.size - this.valueText.getLayoutBounds().getHeight()) * 0.5);
    }

    private void resizeStaticText() {
        double maxWidth = this.size * 0.35;
        double fontSize = this.size * 0.08082707;
        this.titleText.setFont(Fonts.latoBold(fontSize));
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        this.titleText.relocate((this.size - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.22180451);
        this.titleText.setFill((Paint)Color.RED);
        this.unitText.setFont(Fonts.latoBold(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        this.unitText.relocate((this.size - this.unitText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.68984962);
    }

    private void resize() {
        double height;
        double width = ((Gauge)this.getSkinnable()).getWidth() - ((Gauge)this.getSkinnable()).getInsets().getLeft() - ((Gauge)this.getSkinnable()).getInsets().getRight();
        double d = this.size = width < (height = ((Gauge)this.getSkinnable()).getHeight() - ((Gauge)this.getSkinnable()).getInsets().getTop() - ((Gauge)this.getSkinnable()).getInsets().getBottom()) ? width : height;
        if (width > 0.0 && height > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.setPrefSize(this.size, this.size);
            this.pane.relocate((((Gauge)this.getSkinnable()).getWidth() - this.size) * 0.5, (((Gauge)this.getSkinnable()).getHeight() - this.size) * 0.5);
            this.sectionCanvas.setWidth(this.size);
            this.sectionCanvas.setHeight(this.size);
            this.barBackground.setCenterX(this.size * 0.5);
            this.barBackground.setCenterY(this.size * 0.5);
            this.barBackground.setRadiusX(this.size * 0.4);
            this.barBackground.setRadiusY(this.size * 0.4);
            this.barBackground.setStrokeWidth(this.size * 0.125);
            this.bar.setCenterX(this.size * 0.5);
            this.bar.setCenterY(this.size * 0.5);
            this.bar.setRadiusX(this.size * 0.4);
            this.bar.setRadiusY(this.size * 0.4);
            this.bar.setStrokeWidth(this.size * 0.125);
            this.resizeValueText();
            this.redraw();
        }
    }

    private void redraw() {
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.backgroundPaint, new CornerRadii(1024.0), Insets.EMPTY)}));
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.borderPaint, BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.borderWidth / 250.0 * this.size))}));
        this.drawBackground();
        this.setBar(((Gauge)this.getSkinnable()).getCurrentValue());
        this.titleText.setText(((Gauge)this.getSkinnable()).getTitle());
        this.unitText.setText(((Gauge)this.getSkinnable()).getUnit());
        this.resizeStaticText();
        this.titleText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.valueText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        this.unitText.setFill((Paint)((Gauge)this.getSkinnable()).getUnitColor());
    }
}

