/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.LcdDesign;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.tools.Helper;
import java.util.List;
import java.util.Locale;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class LinearSkin
extends SkinBase<Gauge>
implements Skin<Gauge> {
    private static final double MINIMUM_WIDTH = 100.0;
    private static final double MINIMUM_HEIGHT = 100.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double preferredWidth = 140.0;
    private double preferredHeight = 350.0;
    private double aspectRatio = 2.5;
    private double size;
    private double width;
    private double height;
    private double stepSize;
    private Pane pane;
    private Orientation orientation;
    private Canvas ticksAndSectionsCanvas;
    private GraphicsContext ticksAndSections;
    private Text unitText;
    private Text titleText;
    private Text valueText;
    private Line barBorder1;
    private Line barBorder2;
    private Rectangle barBackground;
    private Rectangle bar;
    private Rectangle barHighlight;
    private double ledSize;
    private InnerShadow ledOnShadow;
    private InnerShadow ledOffShadow;
    private Paint ledFramePaint;
    private Paint ledOnPaint;
    private Paint ledOffPaint;
    private Paint ledHighlightPaint;
    private Canvas ledCanvas;
    private GraphicsContext led;
    private Rectangle lcd;
    private String formatString;
    private String tickLabelFormatString;
    private Locale locale;
    private double minValuePosition;
    private double maxValuePosition;
    private double zeroPosition;
    private List<Section> sections;
    private List<Section> areas;

    public LinearSkin(Gauge gauge) {
        super((Control)gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.orientation = gauge.getOrientation();
        this.formatString = "%." + Integer.toString(gauge.getDecimals()) + "f";
        this.tickLabelFormatString = "%." + Integer.toString(gauge.getTickLabelDecimals()) + "f";
        this.locale = gauge.getLocale();
        this.sections = gauge.getSections();
        this.areas = gauge.getAreas();
        if (Orientation.VERTICAL == this.orientation) {
            this.preferredWidth = 140.0;
            this.preferredHeight = 350.0;
        } else {
            this.preferredWidth = 350.0;
            this.preferredHeight = 140.0;
        }
        gauge.setPrefSize(this.preferredWidth, this.preferredHeight);
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if ((Double.compare(((Gauge)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getHeight(), 0.0) <= 0) && ((Gauge)this.getSkinnable()).getPrefWidth() < 0.0 && ((Gauge)this.getSkinnable()).getPrefHeight() < 0.0) {
            ((Gauge)this.getSkinnable()).setPrefSize(this.preferredWidth, this.preferredHeight);
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMinSize(100.0, 100.0);
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.barBorder1 = new Line();
        this.barBorder2 = new Line();
        this.barBackground = new Rectangle();
        this.ticksAndSectionsCanvas = new Canvas(this.preferredWidth, this.preferredHeight);
        this.ticksAndSections = this.ticksAndSectionsCanvas.getGraphicsContext2D();
        this.ledCanvas = new Canvas();
        this.led = this.ledCanvas.getGraphicsContext2D();
        Helper.enableNode((Node)this.ledCanvas, ((Gauge)this.getSkinnable()).isLedVisible());
        this.lcd = new Rectangle(0.3 * this.preferredWidth, 0.014 * this.preferredHeight);
        this.lcd.setArcWidth(0.0125 * this.preferredHeight);
        this.lcd.setArcHeight(0.0125 * this.preferredHeight);
        this.lcd.relocate((this.preferredWidth - this.lcd.getWidth()) * 0.5, 0.44 * this.preferredHeight);
        Helper.enableNode((Node)this.lcd, ((Gauge)this.getSkinnable()).isLcdVisible());
        this.bar = new Rectangle();
        this.bar.setStroke(null);
        this.barHighlight = new Rectangle();
        this.barHighlight.setStroke(null);
        Helper.enableNode((Node)this.barHighlight, ((Gauge)this.getSkinnable()).isBarEffectEnabled());
        this.titleText = new Text(((Gauge)this.getSkinnable()).getTitle());
        Helper.enableNode((Node)this.titleText, !((Gauge)this.getSkinnable()).getTitle().isEmpty());
        this.unitText = new Text(((Gauge)this.getSkinnable()).getUnit());
        Helper.enableNode((Node)this.unitText, !((Gauge)this.getSkinnable()).getUnit().isEmpty());
        this.valueText = new Text(String.format(this.locale, this.formatString, ((Gauge)this.getSkinnable()).getCurrentValue()));
        Helper.enableNode((Node)this.valueText, ((Gauge)this.getSkinnable()).isValueVisible());
        this.pane = new Pane(new Node[]{this.barBorder1, this.barBorder2, this.barBackground, this.ticksAndSectionsCanvas, this.titleText, this.unitText, this.ledCanvas, this.lcd, this.valueText, this.bar, this.barHighlight});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Gauge)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(((Gauge)this.getSkinnable()).getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((Gauge)this.getSkinnable()).widthProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).heightProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).setOnUpdate(e -> this.handleEvents(e.eventType.name()));
        ((Gauge)this.getSkinnable()).currentValueProperty().addListener(e -> this.setBar(((Gauge)this.getSkinnable()).getCurrentValue()));
        this.pane.widthProperty().addListener(o -> {
            this.resize();
            this.redraw();
        });
        this.pane.heightProperty().addListener(o -> {
            this.resize();
            this.redraw();
        });
    }

    protected void handleEvents(String EVENT_TYPE) {
        if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
            this.redraw();
        } else if ("FINISHED".equals(EVENT_TYPE)) {
            double d = ((Gauge)this.getSkinnable()).getCurrentValue();
        } else if ("REDRAW".equals(EVENT_TYPE)) {
            this.redraw();
        } else if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.ledCanvas, ((Gauge)this.getSkinnable()).isLedVisible());
            Helper.enableNode((Node)this.titleText, !((Gauge)this.getSkinnable()).getTitle().isEmpty());
            Helper.enableNode((Node)this.unitText, !((Gauge)this.getSkinnable()).getUnit().isEmpty());
            Helper.enableNode((Node)this.valueText, ((Gauge)this.getSkinnable()).isValueVisible());
            Helper.enableNode((Node)this.lcd, ((Gauge)this.getSkinnable()).isLcdVisible() && ((Gauge)this.getSkinnable()).isValueVisible());
            Helper.enableNode((Node)this.barHighlight, ((Gauge)this.getSkinnable()).isBarEffectEnabled());
            this.redraw();
        } else if ("LED".equals(EVENT_TYPE)) {
            if (((Gauge)this.getSkinnable()).isLedVisible()) {
                this.drawLed();
            }
        } else if ("LCD".equals(EVENT_TYPE)) {
            if (((Gauge)this.getSkinnable()).isLcdVisible()) {
                this.redraw();
            }
        } else if ("SECTION".equals(EVENT_TYPE)) {
            this.sections = ((Gauge)this.getSkinnable()).getSections();
            this.areas = ((Gauge)this.getSkinnable()).getAreas();
            this.resize();
            this.redraw();
        } else if ("RECALC".equals(EVENT_TYPE)) {
            if (((Gauge)this.getSkinnable()).isAutoScale()) {
                ((Gauge)this.getSkinnable()).calcAutoScale();
            }
            if (Orientation.VERTICAL == this.orientation) {
                this.width = this.height / this.aspectRatio;
                this.stepSize = Math.abs(0.67143 * this.height / ((Gauge)this.getSkinnable()).getRange());
            } else {
                this.height = this.width / this.aspectRatio;
                this.stepSize = Math.abs(0.75 * this.width / ((Gauge)this.getSkinnable()).getRange());
            }
            this.resize();
            this.redraw();
        }
    }

    private void drawTickMarks(GraphicsContext CTX) {
        double maxPosition;
        double minPosition;
        if (Double.compare(this.stepSize, 0.0) <= 0) {
            return;
        }
        CTX.setFont(Fonts.robotoLight(0.06 * this.size));
        CTX.setStroke((Paint)((Gauge)this.getSkinnable()).getTickMarkColor());
        CTX.setFill((Paint)((Gauge)this.getSkinnable()).getTickLabelColor());
        if (Orientation.VERTICAL == this.orientation) {
            minPosition = this.barBackground.getLayoutY() + this.size * 0.0035;
            maxPosition = this.barBackground.getLayoutY() + this.barBackground.getLayoutBounds().getHeight();
        } else {
            minPosition = this.barBackground.getLayoutX();
            maxPosition = this.barBackground.getLayoutX() + this.barBackground.getLayoutBounds().getWidth();
        }
        double anchorX = this.barBackground.getLayoutX() - 0.075 * this.width;
        double anchorY = this.barBackground.getLayoutY() + this.barBackground.getHeight() + 0.075 * this.height;
        double majorTickSpace = ((Gauge)this.getSkinnable()).getMajorTickSpace();
        double minorTickSpace = ((Gauge)this.getSkinnable()).getMinorTickSpace();
        double minValue = ((Gauge)this.getSkinnable()).getMinValue();
        double maxValue = ((Gauge)this.getSkinnable()).getMaxValue();
        if (((Gauge)this.getSkinnable()).getSectionsVisible()) {
            this.drawSections(CTX);
        }
        int counter = 0;
        double i = minPosition;
        while (Double.compare(i, maxPosition + 1.0) <= 0) {
            Point2D textPoint;
            Point2D outerPoint;
            Point2D innerMinorPoint;
            Point2D innerMediumPoint;
            Point2D innerPoint;
            if (Orientation.VERTICAL == this.orientation) {
                innerPoint = new Point2D(anchorX, i);
                innerMediumPoint = new Point2D(anchorX + 0.015 * this.width, i);
                innerMinorPoint = new Point2D(anchorX + 0.03 * this.width, i);
                outerPoint = new Point2D(anchorX + 0.05 * this.width, i);
                textPoint = new Point2D(anchorX - 0.02 * this.width, i);
            } else {
                innerPoint = new Point2D(i, anchorY);
                innerMediumPoint = new Point2D(i, anchorY - 0.015 * this.height);
                innerMinorPoint = new Point2D(i, anchorY - 0.03 * this.height);
                outerPoint = new Point2D(i, anchorY - 0.05 * this.height);
                textPoint = new Point2D(i, anchorY + 0.05 * this.height);
            }
            if ((double)counter % majorTickSpace == 0.0) {
                CTX.setLineWidth(this.size * 0.007);
                CTX.strokeLine(innerPoint.getX(), innerPoint.getY(), outerPoint.getX(), outerPoint.getY());
                CTX.setTextBaseline(VPos.CENTER);
                if (Orientation.VERTICAL == this.orientation) {
                    CTX.setTextAlign(TextAlignment.RIGHT);
                    CTX.fillText(String.format(this.locale, this.tickLabelFormatString, (maxValue -= majorTickSpace) + majorTickSpace), textPoint.getX(), textPoint.getY());
                } else {
                    CTX.setTextAlign(TextAlignment.CENTER);
                    CTX.fillText(String.format(this.locale, this.tickLabelFormatString, (minValue += majorTickSpace) - majorTickSpace), textPoint.getX(), textPoint.getY());
                }
            } else if (minorTickSpace % 2.0 != 0.0 && counter % 5 == 0) {
                CTX.setLineWidth(this.size * 0.006);
                CTX.strokeLine(innerMediumPoint.getX(), innerMediumPoint.getY(), outerPoint.getX(), outerPoint.getY());
            } else if ((double)counter % minorTickSpace == 0.0) {
                CTX.setLineWidth(this.size * 0.005);
                CTX.strokeLine(innerMinorPoint.getX(), innerMinorPoint.getY(), outerPoint.getX(), outerPoint.getY());
            }
            ++counter;
            i += this.stepSize;
        }
    }

    private void drawSections(GraphicsContext CTX) {
        if (this.sections.isEmpty()) {
            return;
        }
        int listSize = this.sections.size();
        double minValue = ((Gauge)this.getSkinnable()).getMinValue();
        CTX.save();
        if (Orientation.VERTICAL == this.orientation) {
            double minPosition = this.barBackground.getLayoutY() + this.barBackground.getLayoutBounds().getHeight() - this.size * 0.0035;
            double anchorX = this.barBackground.getLayoutX() - 0.079 * this.width;
            for (int i = 0; i < listSize; ++i) {
                Section section = this.sections.get(i);
                double sectionHeight = (section.getStop() - section.getStart()) * this.stepSize;
                CTX.setFill((Paint)section.getColor());
                CTX.fillRect(anchorX, minPosition - sectionHeight - (section.getStart() - minValue) * this.stepSize, 0.057 * this.width, sectionHeight);
            }
        } else {
            double minPosition = this.barBackground.getLayoutX();
            double anchorY = this.barBackground.getLayoutY() + this.barBackground.getHeight() + 0.021 * this.height;
            for (int i = 0; i < listSize; ++i) {
                Section section = this.sections.get(i);
                double sectionWidth = (section.getStop() - section.getStart()) * this.stepSize;
                CTX.setFill((Paint)section.getColor());
                CTX.fillRect(minPosition + (section.getStart() - minValue) * this.stepSize, anchorY, sectionWidth, 0.059 * this.height);
            }
        }
        CTX.restore();
    }

    private void setBar(double VALUE) {
        if (Orientation.VERTICAL == this.orientation) {
            double valueHeight;
            if (((Gauge)this.getSkinnable()).isStartFromZero()) {
                if (VALUE < 0.0) {
                    valueHeight = Math.abs(VALUE) * this.stepSize;
                    this.bar.setLayoutY(0.0);
                    this.barHighlight.setLayoutY(0.0);
                } else {
                    valueHeight = VALUE * this.stepSize;
                    this.bar.setLayoutY(-valueHeight);
                    this.barHighlight.setLayoutY(-valueHeight);
                }
            } else {
                valueHeight = (VALUE - ((Gauge)this.getSkinnable()).getMinValue()) * this.stepSize;
                this.bar.setLayoutY(-valueHeight);
                this.barHighlight.setLayoutY(-valueHeight);
            }
            this.bar.setHeight(valueHeight);
            this.barHighlight.setHeight(valueHeight);
            if (((Gauge)this.getSkinnable()).isLcdVisible()) {
                this.valueText.setText(String.format(this.locale, this.formatString, VALUE));
                this.valueText.setLayoutX(0.88 * this.width - this.valueText.getLayoutBounds().getWidth());
            } else {
                this.valueText.setText(String.format(this.locale, this.formatString, VALUE));
                this.valueText.setLayoutX((this.width - this.valueText.getLayoutBounds().getWidth()) * 0.5);
            }
        } else {
            double valueWidth;
            if (((Gauge)this.getSkinnable()).isStartFromZero()) {
                if (VALUE < 0.0) {
                    valueWidth = Math.abs(VALUE) * this.stepSize;
                    this.bar.setLayoutX(-valueWidth);
                    this.barHighlight.setLayoutX(-valueWidth);
                } else {
                    valueWidth = VALUE * this.stepSize;
                    this.bar.setLayoutX(0.0);
                    this.barHighlight.setLayoutX(0.0);
                }
            } else {
                valueWidth = (VALUE - ((Gauge)this.getSkinnable()).getMinValue()) * this.stepSize;
                this.bar.setLayoutX(0.0);
                this.barHighlight.setLayoutX(0.0);
            }
            this.bar.setWidth(valueWidth);
            this.barHighlight.setWidth(valueWidth);
            this.valueText.setText(String.format(this.locale, this.formatString, VALUE));
            this.valueText.setLayoutX(0.98 * this.width - this.valueText.getLayoutBounds().getWidth());
        }
        this.setBarColor(VALUE);
    }

    private void setBarColor(double VALUE) {
        if (!((Gauge)this.getSkinnable()).getAreasVisible() && !((Gauge)this.getSkinnable()).isGradientBarEnabled()) {
            this.bar.setFill((Paint)((Gauge)this.getSkinnable()).getBarColor());
        } else if (((Gauge)this.getSkinnable()).isGradientBarEnabled() && ((Gauge)this.getSkinnable()).getGradientBarStops().size() > 1) {
            this.bar.setFill((Paint)((Gauge)this.getSkinnable()).getGradientLookup().getColorAt((VALUE - ((Gauge)this.getSkinnable()).getMinValue()) / ((Gauge)this.getSkinnable()).getRange()));
        } else {
            this.bar.setFill((Paint)((Gauge)this.getSkinnable()).getBarColor());
            int listSize = this.areas.size();
            for (int i = 0; i < listSize; ++i) {
                Section area = this.areas.get(i);
                if (!area.contains(VALUE)) continue;
                this.bar.setFill((Paint)area.getColor());
                break;
            }
        }
    }

    private void drawLed() {
        boolean isFlatLed;
        this.led.clearRect(0.0, 0.0, this.ledSize, this.ledSize);
        boolean bl = isFlatLed = Gauge.LedType.FLAT == ((Gauge)this.getSkinnable()).getLedType();
        if (!isFlatLed) {
            this.led.setFill(this.ledFramePaint);
            this.led.fillOval(0.0, 0.0, this.ledSize, this.ledSize);
        } else {
            double lineWidth = 0.0037037 * this.size;
            this.led.setStroke(this.ledFramePaint);
            this.led.setLineWidth(lineWidth);
            this.led.strokeOval(lineWidth, lineWidth, this.ledSize - 2.0 * lineWidth, this.ledSize - 2.0 * lineWidth);
        }
        this.led.save();
        if (((Gauge)this.getSkinnable()).isLedOn()) {
            this.led.setEffect((Effect)this.ledOnShadow);
            this.led.setFill(this.ledOnPaint);
        } else {
            this.led.setEffect((Effect)this.ledOffShadow);
            this.led.setFill(this.ledOffPaint);
        }
        if (isFlatLed) {
            this.led.fillOval(0.2 * this.ledSize, 0.2 * this.ledSize, 0.6 * this.ledSize, 0.6 * this.ledSize);
        } else {
            this.led.fillOval(0.14 * this.ledSize, 0.14 * this.ledSize, 0.72 * this.ledSize, 0.72 * this.ledSize);
        }
        this.led.restore();
        this.led.setFill(this.ledHighlightPaint);
        this.led.fillOval(0.21 * this.ledSize, 0.21 * this.ledSize, 0.58 * this.ledSize, 0.58 * this.ledSize);
    }

    private void resizeText() {
        if (Orientation.VERTICAL == this.orientation) {
            this.titleText.setFont(Fonts.robotoRegular(0.13 * this.width));
            this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, 0.0);
            this.unitText.setFont(Fonts.robotoRegular(0.08 * this.width));
            this.unitText.relocate((this.width - this.unitText.getLayoutBounds().getWidth()) * 0.5, 0.075 * this.height);
            if (((Gauge)this.getSkinnable()).isLcdVisible()) {
                switch (((Gauge)this.getSkinnable()).getLcdFont()) {
                    case LCD: {
                        this.valueText.setFont(Fonts.digital(0.24 * this.width));
                        this.valueText.relocate(0.88 * this.width - this.valueText.getLayoutBounds().getWidth(), 0.877 * this.height);
                        break;
                    }
                    case DIGITAL: {
                        this.valueText.setFont(Fonts.digitalReadout(0.225 * this.width));
                        this.valueText.relocate(0.88 * this.width - this.valueText.getLayoutBounds().getWidth(), 0.875 * this.height);
                        break;
                    }
                    case DIGITAL_BOLD: {
                        this.valueText.setFont(Fonts.digitalReadoutBold(0.225 * this.width));
                        this.valueText.relocate(0.88 * this.width - this.valueText.getLayoutBounds().getWidth(), 0.875 * this.height);
                        break;
                    }
                    case ELEKTRA: {
                        this.valueText.setFont(Fonts.elektra(0.24 * this.width));
                        this.valueText.relocate(0.88 * this.width - this.valueText.getLayoutBounds().getWidth(), 0.867 * this.height);
                        break;
                    }
                    default: {
                        this.valueText.setFont(Fonts.robotoMedium(0.22 * this.width));
                        this.valueText.relocate(0.88 * this.width - this.valueText.getLayoutBounds().getWidth(), 0.855 * this.height);
                        break;
                    }
                }
            } else {
                this.valueText.setFont(Fonts.robotoRegular(0.17 * this.width));
                this.valueText.relocate((this.width - this.valueText.getLayoutBounds().getWidth()) * 0.5, this.height * 0.877);
            }
        } else {
            this.titleText.setFont(Fonts.robotoRegular(0.15 * this.height));
            this.titleText.relocate(0.03571429 * this.height, 0.03571429 * this.height);
            this.unitText.setFont(Fonts.robotoRegular(0.1 * this.height));
            this.unitText.relocate((this.width - this.unitText.getLayoutBounds().getWidth()) * 0.5, 0.8 * this.height);
            if (((Gauge)this.getSkinnable()).isLcdVisible()) {
                switch (((Gauge)this.getSkinnable()).getLcdFont()) {
                    case LCD: {
                        this.valueText.setFont(Fonts.digital(0.24 * this.height));
                        this.valueText.relocate(0.98 * this.width - this.valueText.getLayoutBounds().getWidth(), 0.052 * this.height);
                        break;
                    }
                    case DIGITAL: {
                        this.valueText.setFont(Fonts.digitalReadout(0.225 * this.height));
                        this.valueText.relocate(0.98 * this.width - this.valueText.getLayoutBounds().getWidth(), 0.05 * this.height);
                        break;
                    }
                    case DIGITAL_BOLD: {
                        this.valueText.setFont(Fonts.digitalReadoutBold(0.225 * this.height));
                        this.valueText.relocate(0.98 * this.width - this.valueText.getLayoutBounds().getWidth(), 0.05 * this.height);
                        break;
                    }
                    case ELEKTRA: {
                        this.valueText.setFont(Fonts.elektra(0.24 * this.height));
                        this.valueText.relocate(0.98 * this.width - this.valueText.getLayoutBounds().getWidth(), 0.042 * this.height);
                        break;
                    }
                    default: {
                        this.valueText.setFont(Fonts.robotoMedium(0.22 * this.height));
                        this.valueText.relocate(0.98 * this.width - this.valueText.getLayoutBounds().getWidth(), 0.03 * this.height);
                        break;
                    }
                }
            } else {
                this.valueText.setFont(Fonts.robotoRegular(0.17 * this.height));
                this.valueText.relocate(0.98 * this.width - this.valueText.getLayoutBounds().getWidth(), 0.03 * this.height);
            }
        }
    }

    private void resize() {
        this.width = ((Gauge)this.getSkinnable()).getWidth() - ((Gauge)this.getSkinnable()).getInsets().getLeft() - ((Gauge)this.getSkinnable()).getInsets().getRight();
        this.height = ((Gauge)this.getSkinnable()).getHeight() - ((Gauge)this.getSkinnable()).getInsets().getTop() - ((Gauge)this.getSkinnable()).getInsets().getBottom();
        if (this.width > 0.0 && this.height > 0.0) {
            boolean isFlatLed;
            this.orientation = ((Gauge)this.getSkinnable()).getOrientation();
            double currentValue = ((Gauge)this.getSkinnable()).getCurrentValue();
            Color tickMarkColor = ((Gauge)this.getSkinnable()).getTickMarkColor();
            Color barBorderColor = Color.color((double)tickMarkColor.getRed(), (double)tickMarkColor.getGreen(), (double)tickMarkColor.getBlue(), (double)0.5);
            boolean bl = isFlatLed = Gauge.LedType.FLAT == ((Gauge)this.getSkinnable()).getLedType();
            if (Orientation.VERTICAL == this.orientation) {
                this.width = this.height / this.aspectRatio;
                this.size = this.width < this.height ? this.width : this.height;
                this.stepSize = Math.abs(0.66793 * this.height / ((Gauge)this.getSkinnable()).getRange());
                this.pane.setMaxSize(this.width, this.height);
                this.pane.relocate((((Gauge)this.getSkinnable()).getWidth() - this.width) * 0.5, (((Gauge)this.getSkinnable()).getHeight() - this.height) * 0.5);
                this.width = this.pane.getLayoutBounds().getWidth();
                this.height = this.pane.getLayoutBounds().getHeight();
                this.barBackground.setWidth(0.14286 * this.width);
                this.barBackground.setHeight(0.67143 * this.height);
                this.barBackground.relocate((this.width - this.barBackground.getWidth()) * 0.5, (this.height - this.barBackground.getHeight()) * 0.5);
                this.barBackground.setStroke(null);
                this.barBackground.setFill((Paint)new LinearGradient(0.0, this.barBackground.getLayoutBounds().getMinY(), 0.0, this.barBackground.getLayoutBounds().getMaxY(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)255, (int)255, (int)255, (double)0.05)), new Stop(0.5, Color.rgb((int)255, (int)255, (int)255, (double)0.15)), new Stop(1.0, Color.rgb((int)255, (int)255, (int)255, (double)0.05))}));
                this.minValuePosition = this.barBackground.getLayoutY() + this.barBackground.getLayoutBounds().getHeight();
                this.maxValuePosition = this.barBackground.getLayoutY();
                this.zeroPosition = this.minValuePosition + ((Gauge)this.getSkinnable()).getMinValue() * this.stepSize;
                this.zeroPosition = this.zeroPosition > this.minValuePosition ? this.minValuePosition : this.zeroPosition;
                this.barBorder1.setStartX(this.barBackground.getLayoutX() - 1.0);
                this.barBorder1.setStartY(this.maxValuePosition);
                this.barBorder1.setEndX(this.barBackground.getLayoutX() - 1.0);
                this.barBorder1.setEndY(this.minValuePosition);
                this.barBorder2.setStartX(this.barBackground.getLayoutX() + this.barBackground.getLayoutBounds().getWidth() + 1.0);
                this.barBorder2.setStartY(this.maxValuePosition);
                this.barBorder2.setEndX(this.barBackground.getLayoutX() + this.barBackground.getLayoutBounds().getWidth() + 1.0);
                this.barBorder2.setEndY(this.minValuePosition);
                this.barBorder1.setStroke((Paint)barBorderColor);
                this.barBorder2.setStroke((Paint)barBorderColor);
                this.bar.setWidth(0.14286 * this.width);
                this.bar.setTranslateX((this.width - this.bar.getWidth()) * 0.5);
                this.bar.setTranslateY(((Gauge)this.getSkinnable()).isStartFromZero() ? this.zeroPosition : this.minValuePosition);
                this.barHighlight.setWidth(this.bar.getWidth());
                this.barHighlight.setTranslateX(this.bar.getTranslateX());
                this.barHighlight.setTranslateY(this.bar.getTranslateY());
                this.setBar(currentValue);
                this.ticksAndSectionsCanvas.setCache(false);
                this.ticksAndSectionsCanvas.setWidth(this.height / this.aspectRatio);
                this.ticksAndSectionsCanvas.setHeight(this.height);
                this.ticksAndSections.clearRect(0.0, 0.0, this.ticksAndSectionsCanvas.getWidth(), this.ticksAndSectionsCanvas.getHeight());
                this.drawTickMarks(this.ticksAndSections);
                this.ticksAndSectionsCanvas.setCache(true);
                this.ticksAndSectionsCanvas.setCacheHint(CacheHint.QUALITY);
                this.ledSize = isFlatLed ? 0.08 * this.width : 0.09 * this.width;
                this.ledCanvas.setWidth(this.ledSize);
                this.ledCanvas.setHeight(this.ledSize);
                this.ledCanvas.relocate((this.width - this.ledSize) * 0.5, 0.12 * this.height);
                this.ledOffShadow = isFlatLed ? null : new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 0.07 * this.ledSize, 0.0, 0.0, 0.0);
                InnerShadow innerShadow = this.ledOnShadow = isFlatLed ? null : new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 0.07 * this.ledSize, 0.0, 0.0, 0.0);
                if (!isFlatLed) {
                    this.ledOnShadow.setInput((Effect)new DropShadow(BlurType.TWO_PASS_BOX, ((Gauge)this.getSkinnable()).getLedColor(), 0.36 * this.ledSize, 0.0, 0.0, 0.0));
                }
                this.lcd.setWidth(0.8 * this.width);
                this.lcd.setHeight(0.22 * this.width);
                this.lcd.setArcWidth(0.0125 * this.size);
                this.lcd.setArcHeight(0.0125 * this.size);
                this.lcd.relocate((this.width - this.lcd.getWidth()) * 0.5, 0.87 * this.height);
            } else {
                this.height = this.width / this.aspectRatio;
                this.size = this.width < this.height ? this.width : this.height;
                this.stepSize = Math.abs(0.9 * this.width / ((Gauge)this.getSkinnable()).getRange());
                this.pane.setMaxSize(this.width, this.height);
                this.pane.relocate((((Gauge)this.getSkinnable()).getWidth() - this.width) * 0.5, (((Gauge)this.getSkinnable()).getHeight() - this.height) * 0.5);
                this.width = this.pane.getLayoutBounds().getWidth();
                this.height = this.pane.getLayoutBounds().getHeight();
                this.barBackground.setWidth(0.9 * this.width);
                this.barBackground.setHeight(0.14286 * this.height);
                this.barBackground.relocate((this.width - this.barBackground.getWidth()) * 0.5, (this.height - this.barBackground.getHeight()) * 0.5);
                this.barBackground.setStroke(null);
                this.barBackground.setFill((Paint)new LinearGradient(this.barBackground.getLayoutBounds().getMinX(), 0.0, this.barBackground.getLayoutBounds().getMaxX(), 0.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)255, (int)255, (int)255, (double)0.05)), new Stop(0.5, Color.rgb((int)255, (int)255, (int)255, (double)0.15)), new Stop(1.0, Color.rgb((int)255, (int)255, (int)255, (double)0.05))}));
                this.minValuePosition = this.barBackground.getLayoutX();
                this.maxValuePosition = this.barBackground.getLayoutX() + this.barBackground.getLayoutBounds().getWidth();
                this.zeroPosition = this.minValuePosition - ((Gauge)this.getSkinnable()).getMinValue() * this.stepSize;
                this.zeroPosition = this.zeroPosition < this.minValuePosition ? this.minValuePosition : this.zeroPosition;
                this.barBorder1.setStartX(this.minValuePosition);
                this.barBorder1.setStartY(this.barBackground.getLayoutY() - 1.0);
                this.barBorder1.setEndX(this.maxValuePosition);
                this.barBorder1.setEndY(this.barBackground.getLayoutY() - 1.0);
                this.barBorder2.setStartX(this.minValuePosition);
                this.barBorder2.setStartY(this.barBackground.getLayoutY() + this.barBackground.getLayoutBounds().getHeight() + 1.0);
                this.barBorder2.setEndX(this.maxValuePosition);
                this.barBorder2.setEndY(this.barBackground.getLayoutY() + this.barBackground.getLayoutBounds().getHeight() + 1.0);
                this.barBorder1.setStroke((Paint)barBorderColor);
                this.barBorder2.setStroke((Paint)barBorderColor);
                this.bar.setHeight(0.14286 * this.height);
                this.bar.setTranslateX(((Gauge)this.getSkinnable()).isStartFromZero() ? this.zeroPosition : this.minValuePosition);
                this.bar.setTranslateY((this.height - this.bar.getHeight()) * 0.5);
                this.barHighlight.setHeight(this.bar.getHeight());
                this.barHighlight.setTranslateX(this.bar.getTranslateX());
                this.barHighlight.setTranslateY(this.bar.getTranslateY());
                this.setBar(currentValue);
                this.ticksAndSectionsCanvas.setCache(false);
                this.ticksAndSectionsCanvas.setWidth(this.width);
                this.ticksAndSectionsCanvas.setHeight(this.height);
                this.ticksAndSections.clearRect(0.0, 0.0, this.ticksAndSectionsCanvas.getWidth(), this.ticksAndSectionsCanvas.getHeight());
                this.drawTickMarks(this.ticksAndSections);
                this.ticksAndSectionsCanvas.setCache(true);
                this.ticksAndSectionsCanvas.setCacheHint(CacheHint.QUALITY);
                this.ledSize = isFlatLed ? 0.08 * this.height : 0.09 * this.height;
                this.ledCanvas.setWidth(this.ledSize);
                this.ledCanvas.setHeight(this.ledSize);
                this.ledCanvas.relocate(0.955 * this.width, (this.height - this.ledSize) * 0.5);
                this.ledOffShadow = isFlatLed ? null : new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 0.07 * this.ledSize, 0.0, 0.0, 0.0);
                InnerShadow innerShadow = this.ledOnShadow = isFlatLed ? null : new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 0.07 * this.ledSize, 0.0, 0.0, 0.0);
                if (!isFlatLed) {
                    this.ledOnShadow.setInput((Effect)new DropShadow(BlurType.TWO_PASS_BOX, ((Gauge)this.getSkinnable()).getLedColor(), 0.36 * this.ledSize, 0.0, 0.0, 0.0));
                }
                this.lcd.setWidth(0.3 * this.width);
                this.lcd.setHeight(0.22 * this.height);
                this.lcd.setArcWidth(0.0125 * this.size);
                this.lcd.setArcHeight(0.0125 * this.size);
                this.lcd.relocate(this.width - this.lcd.getWidth() - 0.03571429 * this.height, 0.03571429 * this.height);
            }
            this.resizeText();
        }
    }

    private void redraw() {
        this.locale = ((Gauge)this.getSkinnable()).getLocale();
        this.formatString = "%." + Integer.toString(((Gauge)this.getSkinnable()).getDecimals()) + "f";
        this.tickLabelFormatString = "%." + Integer.toString(((Gauge)this.getSkinnable()).getTickLabelDecimals()) + "f";
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Gauge)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(Orientation.HORIZONTAL == this.orientation ? ((Gauge)this.getSkinnable()).getBorderWidth() / this.preferredHeight * this.height : ((Gauge)this.getSkinnable()).getBorderWidth() / this.preferredWidth * this.width))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        Color barColor = ((Gauge)this.getSkinnable()).getBarColor();
        this.bar.setFill((Paint)barColor);
        if (Orientation.VERTICAL == this.orientation) {
            this.barHighlight.setFill((Paint)new LinearGradient(this.barHighlight.getLayoutX(), 0.0, this.barHighlight.getLayoutX() + this.barHighlight.getWidth(), 0.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)255, (int)255, (int)255, (double)0.65)), new Stop(0.92, Color.TRANSPARENT), new Stop(1.0, Color.rgb((int)0, (int)0, (int)0, (double)0.2))}));
        } else {
            this.barHighlight.setFill((Paint)new LinearGradient(0.0, this.barHighlight.getLayoutY(), 0.0, this.barHighlight.getLayoutY() + this.barHighlight.getHeight(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)255, (int)255, (int)255, (double)0.65)), new Stop(0.92, Color.TRANSPARENT), new Stop(1.0, Color.rgb((int)0, (int)0, (int)0, (double)0.2))}));
        }
        if (((Gauge)this.getSkinnable()).isLedVisible()) {
            Color LED_COLOR = ((Gauge)this.getSkinnable()).getLedColor();
            switch (((Gauge)this.getSkinnable()).getLedType()) {
                case FLAT: {
                    this.ledFramePaint = Color.WHITE;
                    this.ledOnPaint = new LinearGradient(0.0, 0.25 * this.ledSize, 0.0, 0.74 * this.ledSize, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, LED_COLOR), new Stop(1.0, LED_COLOR.deriveColor(0.0, 1.0, 0.5, 1.0))});
                    this.ledOffPaint = new LinearGradient(0.0, 0.25 * this.ledSize, 0.0, 0.74 * this.ledSize, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, LED_COLOR.deriveColor(0.0, 1.0, 0.5, 1.0)), new Stop(1.0, LED_COLOR.deriveColor(0.0, 1.0, 0.13, 1.0))});
                    this.ledHighlightPaint = Color.TRANSPARENT;
                    break;
                }
                default: {
                    this.ledFramePaint = new LinearGradient(0.14 * this.ledSize, 0.14 * this.ledSize, 0.84 * this.ledSize, 0.84 * this.ledSize, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)20, (int)20, (int)20, (double)0.65)), new Stop(0.15, Color.rgb((int)20, (int)20, (int)20, (double)0.65)), new Stop(0.26, Color.rgb((int)41, (int)41, (int)41, (double)0.65)), new Stop(0.26, Color.rgb((int)41, (int)41, (int)41, (double)0.64)), new Stop(0.85, Color.rgb((int)200, (int)200, (int)200, (double)0.41)), new Stop(1.0, Color.rgb((int)200, (int)200, (int)200, (double)0.35))});
                    this.ledOnPaint = new LinearGradient(0.25 * this.ledSize, 0.25 * this.ledSize, 0.74 * this.ledSize, 0.74 * this.ledSize, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, LED_COLOR.deriveColor(0.0, 1.0, 0.77, 1.0)), new Stop(0.49, LED_COLOR.deriveColor(0.0, 1.0, 0.5, 1.0)), new Stop(1.0, LED_COLOR)});
                    this.ledOffPaint = new LinearGradient(0.25 * this.ledSize, 0.25 * this.ledSize, 0.74 * this.ledSize, 0.74 * this.ledSize, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, LED_COLOR.deriveColor(0.0, 1.0, 0.2, 1.0)), new Stop(0.49, LED_COLOR.deriveColor(0.0, 1.0, 0.13, 1.0)), new Stop(1.0, LED_COLOR.deriveColor(0.0, 1.0, 0.2, 1.0))});
                    this.ledHighlightPaint = new RadialGradient(0.0, 0.0, 0.3 * this.ledSize, 0.3 * this.ledSize, 0.29 * this.ledSize, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.WHITE), new Stop(1.0, Color.TRANSPARENT)});
                }
            }
            this.drawLed();
        }
        this.ticksAndSectionsCanvas.setCache(false);
        this.ticksAndSections.clearRect(0.0, 0.0, this.ticksAndSectionsCanvas.getWidth(), this.ticksAndSectionsCanvas.getHeight());
        this.drawTickMarks(this.ticksAndSections);
        this.ticksAndSectionsCanvas.setCache(true);
        this.ticksAndSectionsCanvas.setCacheHint(CacheHint.QUALITY);
        LcdDesign lcdDesign = ((Gauge)this.getSkinnable()).getLcdDesign();
        Color[] lcdColors = lcdDesign.getColors();
        if (((Gauge)this.getSkinnable()).isLcdVisible() && ((Gauge)this.getSkinnable()).isValueVisible()) {
            LinearGradient lcdGradient = new LinearGradient(0.0, 1.0, 0.0, this.lcd.getHeight() - 1.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, lcdColors[0]), new Stop(0.03, lcdColors[1]), new Stop(0.5, lcdColors[2]), new Stop(0.5, lcdColors[3]), new Stop(1.0, lcdColors[4])});
            Object lcdFramePaint = LcdDesign.FLAT_CUSTOM == lcdDesign ? lcdDesign.lcdForegroundColor : new LinearGradient(0.0, 0.0, 0.0, this.lcd.getHeight(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)26, (int)26, (int)26)), new Stop(0.01, Color.rgb((int)77, (int)77, (int)77)), new Stop(0.99, Color.rgb((int)77, (int)77, (int)77)), new Stop(1.0, Color.rgb((int)221, (int)221, (int)221))});
            this.lcd.setFill((Paint)lcdGradient);
            this.lcd.setStroke((Paint)lcdFramePaint);
        }
        this.titleText.setText(((Gauge)this.getSkinnable()).getTitle());
        this.titleText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.unitText.setFill((Paint)((Gauge)this.getSkinnable()).getUnitColor());
        this.unitText.setText(((Gauge)this.getSkinnable()).getUnit());
        this.valueText.setFill((Paint)(((Gauge)this.getSkinnable()).isLcdVisible() ? lcdColors[5] : ((Gauge)this.getSkinnable()).getValueColor()));
        this.resizeText();
    }
}

