/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Clock;
import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.tools.Helper;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextAlignment;

public class DigitalClockSkin
extends SkinBase<Clock>
implements Skin<Clock> {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 100.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 20.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final DateTimeFormatter HHMM_FORMATTER = DateTimeFormatter.ofPattern("HH:mm");
    private static final DateTimeFormatter HHMMSS_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static final DateTimeFormatter AMPM_HHMM_FORMATTER = DateTimeFormatter.ofPattern("hh:mm a");
    private static final DateTimeFormatter AMPM_HHMMSS_FORMATTER = DateTimeFormatter.ofPattern("hh:mm:ss a");
    private double aspectRatio = 0.4;
    private double width;
    private double height;
    private double centerX;
    private double centerY;
    private DateTimeFormatter dateFormat;
    private Pane pane;
    private Canvas canvas;
    private GraphicsContext ctx;
    private Color textColor;
    private Color dateColor;
    private Color alarmColor;

    public DigitalClockSkin(Clock clock) {
        super((Control)clock);
        this.textColor = clock.getTextColor();
        this.dateColor = clock.getDateColor();
        this.alarmColor = clock.getAlarmColor();
        this.dateFormat = Helper.getDateFormat(clock.getLocale());
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if ((Double.compare(((Clock)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getHeight(), 0.0) <= 0) && ((Clock)this.getSkinnable()).getPrefWidth() < 0.0 && ((Clock)this.getSkinnable()).getPrefHeight() < 0.0) {
            ((Clock)this.getSkinnable()).setPrefSize(250.0, 100.0);
        }
        if (Double.compare(((Clock)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((Clock)this.getSkinnable()).setMinSize(50.0, 20.0);
        }
        if (Double.compare(((Clock)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((Clock)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.canvas = new Canvas(250.0, 100.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.pane = new Pane(new Node[]{this.canvas});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Clock)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(((Clock)this.getSkinnable()).getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Clock)this.getSkinnable()).getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((Clock)this.getSkinnable()).widthProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Clock)this.getSkinnable()).heightProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Clock)this.getSkinnable()).setOnUpdate(e -> this.handleEvents(e.eventType.name()));
        if (((Clock)this.getSkinnable()).isAnimated()) {
            ((Clock)this.getSkinnable()).currentTimeProperty().addListener(o -> this.updateTime(ZonedDateTime.ofInstant(Instant.ofEpochSecond(((Clock)this.getSkinnable()).getCurrentTime()), ZoneId.of(ZoneId.systemDefault().getId()))));
        } else {
            ((Clock)this.getSkinnable()).timeProperty().addListener(o -> this.updateTime(((Clock)this.getSkinnable()).getTime()));
        }
    }

    private void handleEvents(String EVENT_TYPE) {
        if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
            this.redraw();
        } else if ("REDRAW".equals(EVENT_TYPE)) {
            this.redraw();
        } else if (!"VISIBILITY".equals(EVENT_TYPE) && "SECTION".equals(EVENT_TYPE)) {
            this.redraw();
        }
    }

    private void drawTime(ZonedDateTime TIME) {
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        if (((Clock)this.getSkinnable()).isTextVisible()) {
            this.ctx.setFill((Paint)this.textColor);
            this.ctx.setTextBaseline(VPos.CENTER);
            this.ctx.setTextAlign(TextAlignment.CENTER);
            if (Locale.US == ((Clock)this.getSkinnable()).getLocale()) {
                this.ctx.setFont(Fonts.digital(0.5 * this.height));
                this.ctx.fillText(((Clock)this.getSkinnable()).isSecondsVisible() ? AMPM_HHMMSS_FORMATTER.format(TIME) : AMPM_HHMM_FORMATTER.format(TIME), this.centerX, ((Clock)this.getSkinnable()).isDateVisible() ? this.height * 0.35 : this.centerY);
            } else {
                this.ctx.setFont(Fonts.digital(0.6 * this.height));
                this.ctx.fillText(((Clock)this.getSkinnable()).isSecondsVisible() ? HHMMSS_FORMATTER.format(TIME) : HHMM_FORMATTER.format(TIME), this.centerX, ((Clock)this.getSkinnable()).isDateVisible() ? this.height * 0.3 : this.centerY);
            }
        }
        if (((Clock)this.getSkinnable()).isDateVisible()) {
            this.ctx.setFill((Paint)this.dateColor);
            this.ctx.setFont(Fonts.digital(0.34 * this.height));
            this.ctx.fillText(this.dateFormat.format(TIME), this.centerX, this.height * 0.77);
        }
        if (((Clock)this.getSkinnable()).isAlarmsEnabled() && ((Clock)this.getSkinnable()).getAlarms().size() > 0) {
            this.ctx.setFill((Paint)this.alarmColor);
        }
    }

    private void updateTime(ZonedDateTime TIME) {
        this.drawTime(TIME);
    }

    private void resize() {
        this.width = ((Clock)this.getSkinnable()).getWidth() - ((Clock)this.getSkinnable()).getInsets().getLeft() - ((Clock)this.getSkinnable()).getInsets().getRight();
        this.height = ((Clock)this.getSkinnable()).getHeight() - ((Clock)this.getSkinnable()).getInsets().getTop() - ((Clock)this.getSkinnable()).getInsets().getBottom();
        if (this.aspectRatio * this.width > this.height) {
            this.width = 1.0 / (this.aspectRatio / this.height);
        } else if (1.0 / (this.aspectRatio / this.height) > this.width) {
            this.height = this.aspectRatio * this.width;
        }
        this.centerX = this.width * 0.5;
        this.centerY = this.height * 0.5;
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.relocate((((Clock)this.getSkinnable()).getWidth() - this.height) * 0.5, (((Clock)this.getSkinnable()).getHeight() - this.height) * 0.5);
            this.canvas.setWidth(this.width);
            this.canvas.setHeight(this.height);
        }
    }

    private void redraw() {
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Clock)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(((Clock)this.getSkinnable()).getBorderWidth() / 250.0 * this.height))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Clock)this.getSkinnable()).getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        ZonedDateTime time = ((Clock)this.getSkinnable()).getTime();
        this.textColor = ((Clock)this.getSkinnable()).getTextColor();
        this.dateColor = ((Clock)this.getSkinnable()).getDateColor();
        this.alarmColor = ((Clock)this.getSkinnable()).getAlarmColor();
        this.drawTime(time);
    }
}

