/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.tools.Helper;
import java.util.Locale;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.text.Text;

public class SpaceXSkin
extends SkinBase<Gauge>
implements Skin<Gauge> {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 290.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final double ASPECT_RATIO = 1.1625;
    private static final double ANGLE_RANGE = 270.0;
    private double size;
    private double width;
    private double height;
    private double centerX;
    private double centerY;
    private double range;
    private double angleStep;
    private double currentValueAngle;
    private double thresholdAngle;
    private double barWidth;
    private Pane pane;
    private Text unitText;
    private Text titleText;
    private Text valueText;
    private Path barBackground;
    private MoveTo barBackgroundStart;
    private ArcTo barBackgroundOuterArc;
    private LineTo barBackgroundLineToInnerArc;
    private ArcTo barBackgroundInnerArc;
    private Path thresholdBar;
    private MoveTo thresholdBarStart;
    private ArcTo thresholdBarOuterArc;
    private LineTo thresholdBarLineToInnerArc;
    private ArcTo thresholdBarInnerArc;
    private Path dataBar;
    private MoveTo dataBarStart;
    private ArcTo dataBarOuterArc;
    private LineTo dataBarLineToInnerArc;
    private ArcTo dataBarInnerArc;
    private Path dataBarThreshold;
    private MoveTo dataBarThresholdStart;
    private ArcTo dataBarThresholdOuterArc;
    private LineTo dataBarThresholdLineToInnerArc;
    private ArcTo dataBarThresholdInnerArc;
    private Color barColor;
    private Color thresholdColor;
    private Color barBackgroundColor;
    private Color thresholdBackgroundColor;
    private double minValue;
    private String formatString;
    private Locale locale;

    public SpaceXSkin(Gauge gauge) {
        super((Control)gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.range = gauge.getRange();
        this.angleStep = 270.0 / this.range;
        this.minValue = gauge.getMinValue();
        this.currentValueAngle = 0.0;
        this.formatString = "%." + Integer.toString(gauge.getDecimals()) + "f";
        this.locale = gauge.getLocale();
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(((Gauge)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((Gauge)this.getSkinnable()).getPrefWidth() > 0.0 && ((Gauge)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((Gauge)this.getSkinnable()).setPrefSize(((Gauge)this.getSkinnable()).getPrefWidth(), ((Gauge)this.getSkinnable()).getPrefHeight());
            } else {
                ((Gauge)this.getSkinnable()).setPrefSize(250.0, 290.0);
            }
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMinSize(50.0, 50.0);
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.barColor = ((Gauge)this.getSkinnable()).getBarColor();
        this.thresholdColor = ((Gauge)this.getSkinnable()).getThresholdColor();
        this.barBackgroundColor = ((Gauge)this.getSkinnable()).getBarBackgroundColor();
        this.thresholdBackgroundColor = Color.color((double)this.thresholdColor.getRed(), (double)this.thresholdColor.getGreen(), (double)this.thresholdColor.getBlue(), (double)0.25);
        this.unitText = new Text(((Gauge)this.getSkinnable()).getUnit());
        this.unitText.setTextOrigin(VPos.CENTER);
        this.unitText.setFill((Paint)((Gauge)this.getSkinnable()).getUnitColor());
        Helper.enableNode((Node)this.unitText, !((Gauge)this.getSkinnable()).getUnit().isEmpty());
        this.titleText = new Text(((Gauge)this.getSkinnable()).getTitle());
        this.titleText.setTextOrigin(VPos.CENTER);
        this.titleText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        Helper.enableNode((Node)this.titleText, !((Gauge)this.getSkinnable()).getTitle().isEmpty());
        this.valueText = new Text(String.format(this.locale, this.formatString, ((Gauge)this.getSkinnable()).getValue()));
        this.valueText.setTextOrigin(VPos.CENTER);
        this.valueText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        Helper.enableNode((Node)this.valueText, ((Gauge)this.getSkinnable()).isValueVisible());
        this.barBackgroundStart = new MoveTo();
        this.barBackgroundOuterArc = new ArcTo(195.75, 195.75, 0.0, 250.0, 195.75, true, true);
        this.barBackgroundLineToInnerArc = new LineTo();
        this.barBackgroundInnerArc = new ArcTo(87.0, 87.0, 0.0, 69.44500000000001, 195.75, true, false);
        this.barBackground = new Path();
        this.barBackground.setFillRule(FillRule.EVEN_ODD);
        this.barBackground.getElements().add((Object)this.barBackgroundStart);
        this.barBackground.getElements().add((Object)this.barBackgroundOuterArc);
        this.barBackground.getElements().add((Object)this.barBackgroundLineToInnerArc);
        this.barBackground.getElements().add((Object)this.barBackgroundInnerArc);
        this.barBackground.getElements().add((Object)new ClosePath());
        this.barBackground.setFill((Paint)this.barBackgroundColor);
        this.barBackground.setStroke((Paint)Color.TRANSPARENT);
        this.thresholdBarStart = new MoveTo();
        this.thresholdBarOuterArc = new ArcTo(195.75, 195.75, 0.0, 250.0, 195.75, false, true);
        this.thresholdBarLineToInnerArc = new LineTo();
        this.thresholdBarInnerArc = new ArcTo(87.0, 87.0, 0.0, 69.44500000000001, 195.75, false, false);
        this.thresholdBar = new Path();
        this.thresholdBar.setFillRule(FillRule.EVEN_ODD);
        this.thresholdBar.getElements().add((Object)this.thresholdBarStart);
        this.thresholdBar.getElements().add((Object)this.thresholdBarOuterArc);
        this.thresholdBar.getElements().add((Object)this.thresholdBarLineToInnerArc);
        this.thresholdBar.getElements().add((Object)this.thresholdBarInnerArc);
        this.thresholdBar.getElements().add((Object)new ClosePath());
        this.thresholdBar.setFill((Paint)this.thresholdBackgroundColor);
        this.thresholdBar.setStroke((Paint)Color.TRANSPARENT);
        this.dataBarStart = new MoveTo();
        this.dataBarOuterArc = new ArcTo(250.0, 145.0, 0.0, 0.0, 0.0, true, true);
        this.dataBarLineToInnerArc = new LineTo();
        this.dataBarInnerArc = new ArcTo(125.0, 274.375, 0.0, 0.0, 0.0, true, false);
        this.dataBar = new Path();
        this.dataBar.setFillRule(FillRule.EVEN_ODD);
        this.dataBar.getElements().add((Object)this.dataBarStart);
        this.dataBar.getElements().add((Object)this.dataBarOuterArc);
        this.dataBar.getElements().add((Object)this.dataBarLineToInnerArc);
        this.dataBar.getElements().add((Object)this.dataBarInnerArc);
        this.dataBar.getElements().add((Object)new ClosePath());
        this.dataBar.setFill((Paint)this.barColor);
        this.dataBar.setStroke(((Gauge)this.getSkinnable()).getBorderPaint());
        this.dataBarThresholdStart = new MoveTo();
        this.dataBarThresholdOuterArc = new ArcTo(250.0, 145.0, 0.0, 0.0, 0.0, false, true);
        this.dataBarThresholdLineToInnerArc = new LineTo();
        this.dataBarThresholdInnerArc = new ArcTo(125.0, 274.375, 0.0, 0.0, 0.0, false, false);
        this.dataBarThreshold = new Path();
        this.dataBarThreshold.setFillRule(FillRule.EVEN_ODD);
        this.dataBarThreshold.getElements().add((Object)this.dataBarThresholdStart);
        this.dataBarThreshold.getElements().add((Object)this.dataBarThresholdOuterArc);
        this.dataBarThreshold.getElements().add((Object)this.dataBarThresholdLineToInnerArc);
        this.dataBarThreshold.getElements().add((Object)this.dataBarThresholdInnerArc);
        this.dataBarThreshold.getElements().add((Object)new ClosePath());
        this.dataBarThreshold.setFill((Paint)this.thresholdColor);
        this.dataBarThreshold.setStroke(((Gauge)this.getSkinnable()).getBorderPaint());
        this.pane = new Pane(new Node[]{this.titleText, this.valueText, this.unitText, this.barBackground, this.thresholdBar, this.dataBar, this.dataBarThreshold});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Gauge)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(((Gauge)this.getSkinnable()).getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((Gauge)this.getSkinnable()).widthProperty().addListener(o -> this.resize());
        ((Gauge)this.getSkinnable()).heightProperty().addListener(o -> this.resize());
        ((Gauge)this.getSkinnable()).setOnUpdate(e -> this.handleEvents(e.eventType.name()));
        ((Gauge)this.getSkinnable()).currentValueProperty().addListener(o -> this.setBar(((Gauge)this.getSkinnable()).getCurrentValue()));
    }

    protected void handleEvents(String EVENT_TYPE) {
        if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
            this.redraw();
        } else if ("REDRAW".equals(EVENT_TYPE)) {
            this.redraw();
        } else if ("RECALC".equals(EVENT_TYPE)) {
            this.range = ((Gauge)this.getSkinnable()).getRange();
            this.angleStep = 270.0 / this.range;
            this.minValue = ((Gauge)this.getSkinnable()).getMinValue();
            this.resize();
            this.redraw();
        } else if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.valueText, ((Gauge)this.getSkinnable()).isValueVisible());
            Helper.enableNode((Node)this.titleText, !((Gauge)this.getSkinnable()).getTitle().isEmpty());
            Helper.enableNode((Node)this.unitText, !((Gauge)this.getSkinnable()).getUnit().isEmpty());
        }
    }

    private void setBar(double VALUE) {
        this.currentValueAngle = (VALUE - this.minValue) * this.angleStep;
        this.thresholdAngle = (((Gauge)this.getSkinnable()).getThreshold() - this.minValue) * this.angleStep;
        double valueAngle = this.currentValueAngle > this.thresholdAngle ? this.thresholdAngle : this.currentValueAngle;
        this.dataBarOuterArc.setLargeArcFlag(valueAngle > 180.0);
        this.dataBarInnerArc.setLargeArcFlag(valueAngle > 180.0);
        this.dataBarOuterArc.setX(this.centerX + this.centerX * Math.sin(-Math.toRadians(valueAngle)));
        this.dataBarOuterArc.setY(this.centerY + this.centerX * Math.cos(-Math.toRadians(valueAngle)));
        this.dataBarLineToInnerArc.setX(this.centerX + (this.centerX - this.barWidth) * Math.sin(-Math.toRadians(valueAngle)));
        this.dataBarLineToInnerArc.setY(this.centerY + (this.centerX - this.barWidth) * Math.cos(-Math.toRadians(valueAngle)));
        double dataBarThresholdAngle = VALUE > ((Gauge)this.getSkinnable()).getThreshold() ? this.currentValueAngle : this.thresholdAngle;
        this.dataBarThresholdOuterArc.setLargeArcFlag(dataBarThresholdAngle > 180.0 + this.thresholdAngle);
        this.dataBarThresholdInnerArc.setLargeArcFlag(dataBarThresholdAngle > 180.0 + this.thresholdAngle);
        this.dataBarThresholdOuterArc.setX(this.centerX + this.centerX * Math.sin(-Math.toRadians(dataBarThresholdAngle)));
        this.dataBarThresholdOuterArc.setY(this.centerY + this.centerX * Math.cos(-Math.toRadians(dataBarThresholdAngle)));
        this.dataBarThresholdLineToInnerArc.setX(this.centerX + (this.centerX - this.barWidth) * Math.sin(-Math.toRadians(dataBarThresholdAngle)));
        this.dataBarThresholdLineToInnerArc.setY(this.centerY + (this.centerX - this.barWidth) * Math.cos(-Math.toRadians(dataBarThresholdAngle)));
        this.dataBarThresholdInnerArc.setX(this.centerX + (this.centerX - this.barWidth) * Math.sin(-Math.toRadians(this.thresholdAngle)));
        this.dataBarThresholdInnerArc.setY(this.centerY + (this.centerX - this.barWidth) * Math.cos(-Math.toRadians(this.thresholdAngle)));
        this.valueText.setText(String.format(this.locale, this.formatString, VALUE));
        if (this.valueText.getLayoutBounds().getWidth() > 0.64 * this.width) {
            Helper.adjustTextSize(this.valueText, this.width, 0.21 * this.width);
        }
        this.valueText.relocate(this.width - this.valueText.getLayoutBounds().getWidth(), 0.58064516 * this.height);
    }

    private void resize() {
        this.width = ((Gauge)this.getSkinnable()).getWidth() - ((Gauge)this.getSkinnable()).getInsets().getLeft() - ((Gauge)this.getSkinnable()).getInsets().getRight();
        this.height = ((Gauge)this.getSkinnable()).getHeight() - ((Gauge)this.getSkinnable()).getInsets().getTop() - ((Gauge)this.getSkinnable()).getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (1.1625 * this.width > this.height) {
            this.width = 1.0 / (1.1625 / this.height);
        } else if (1.0 / (1.1625 / this.height) > this.width) {
            this.height = 1.1625 * this.width;
        }
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.relocate((((Gauge)this.getSkinnable()).getWidth() - this.width) * 0.5, (((Gauge)this.getSkinnable()).getHeight() - this.height) * 0.5);
            this.centerX = 0.5 * this.width;
            this.centerY = 0.56989247 * this.height;
            this.barWidth = 0.125 * this.width;
            this.titleText.setFont(Fonts.robotoMedium(0.13 * this.width));
            if (this.titleText.getLayoutBounds().getWidth() > this.width) {
                Helper.adjustTextSize(this.titleText, this.width, 0.13 * this.width);
            }
            this.titleText.relocate(0.0, 0.0);
            this.valueText.setFont(Fonts.robotoRegular(0.21 * this.width));
            if (this.valueText.getLayoutBounds().getWidth() > 0.64 * this.width) {
                Helper.adjustTextSize(this.valueText, this.width, 0.21 * this.width);
            }
            this.valueText.relocate(this.width - this.valueText.getLayoutBounds().getWidth(), 0.58064516 * this.height);
            this.unitText.setFont(Fonts.robotoLight(0.11 * this.width));
            if (this.unitText.getLayoutBounds().getWidth() > 0.4 * this.width) {
                Helper.adjustTextSize(this.unitText, this.width, 0.11 * this.width);
            }
            this.unitText.relocate(this.width - this.unitText.getLayoutBounds().getWidth(), 0.79 * this.height);
            this.thresholdAngle = (((Gauge)this.getSkinnable()).getThreshold() - this.minValue) * this.angleStep;
            this.currentValueAngle = (((Gauge)this.getSkinnable()).getCurrentValue() - this.minValue) * this.angleStep;
            this.barBackgroundOuterArc.setLargeArcFlag(this.thresholdAngle > 180.0);
            this.barBackgroundInnerArc.setLargeArcFlag(this.thresholdAngle > 180.0);
            this.barBackgroundStart.setX(this.centerX);
            this.barBackgroundStart.setY(this.height);
            this.barBackgroundOuterArc.setRadiusX(this.centerX);
            this.barBackgroundOuterArc.setRadiusY(this.centerX);
            this.barBackgroundOuterArc.setX(this.centerX + this.centerX * Math.sin(-Math.toRadians(this.thresholdAngle)));
            this.barBackgroundOuterArc.setY(this.centerY + this.centerX * Math.cos(-Math.toRadians(this.thresholdAngle)));
            this.barBackgroundLineToInnerArc.setX(this.centerX + (this.centerX - this.barWidth) * Math.sin(-Math.toRadians(this.thresholdAngle)));
            this.barBackgroundLineToInnerArc.setY(this.centerY + (this.centerX - this.barWidth) * Math.cos(-Math.toRadians(this.thresholdAngle)));
            this.barBackgroundInnerArc.setRadiusX(0.375 * this.width);
            this.barBackgroundInnerArc.setRadiusY(0.375 * this.width);
            this.barBackgroundInnerArc.setX(this.centerX);
            this.barBackgroundInnerArc.setY(this.height - this.barWidth);
            this.thresholdBarOuterArc.setLargeArcFlag(this.thresholdAngle < 180.0);
            this.thresholdBarInnerArc.setLargeArcFlag(this.thresholdAngle < 180.0);
            this.thresholdBarStart.setX(this.centerX + this.centerX * Math.sin(-Math.toRadians(this.thresholdAngle)));
            this.thresholdBarStart.setY(this.centerY + this.centerX * Math.cos(-Math.toRadians(this.thresholdAngle)));
            this.thresholdBarOuterArc.setRadiusX(this.centerX);
            this.thresholdBarOuterArc.setRadiusY(this.centerX);
            this.thresholdBarOuterArc.setX(this.width);
            this.thresholdBarOuterArc.setY(this.centerY);
            this.thresholdBarLineToInnerArc.setX(this.width - this.barWidth);
            this.thresholdBarLineToInnerArc.setY(this.centerY);
            this.thresholdBarInnerArc.setRadiusX(0.375 * this.width);
            this.thresholdBarInnerArc.setRadiusY(0.375 * this.width);
            this.thresholdBarInnerArc.setX(this.centerX + (this.centerX - this.barWidth) * Math.sin(-Math.toRadians(this.thresholdAngle)));
            this.thresholdBarInnerArc.setY(this.centerY + (this.centerX - this.barWidth) * Math.cos(-Math.toRadians(this.thresholdAngle)));
            this.dataBarOuterArc.setLargeArcFlag(this.currentValueAngle > 180.0);
            this.dataBarInnerArc.setLargeArcFlag(this.currentValueAngle > 180.0);
            this.dataBarStart.setX(this.centerX);
            this.dataBarStart.setY(this.height);
            this.dataBarOuterArc.setRadiusX(this.centerX);
            this.dataBarOuterArc.setRadiusY(this.centerX);
            this.dataBarOuterArc.setX(this.centerX + this.centerX * Math.sin(-Math.toRadians(this.currentValueAngle)));
            this.dataBarOuterArc.setY(this.centerY + this.centerX * Math.cos(-Math.toRadians(this.currentValueAngle)));
            this.dataBarLineToInnerArc.setX(this.centerX + (this.centerX - this.barWidth) * Math.sin(-Math.toRadians(this.currentValueAngle)));
            this.dataBarLineToInnerArc.setY(this.centerY + (this.centerX - this.barWidth) * Math.cos(-Math.toRadians(this.currentValueAngle)));
            this.dataBarInnerArc.setRadiusX(0.375 * this.width);
            this.dataBarInnerArc.setRadiusY(0.375 * this.width);
            this.dataBarInnerArc.setX(this.centerX);
            this.dataBarInnerArc.setY(this.height - this.barWidth);
            double dataBarThresholdAngle = ((Gauge)this.getSkinnable()).getCurrentValue() > ((Gauge)this.getSkinnable()).getThreshold() ? this.currentValueAngle : this.thresholdAngle;
            this.dataBarThresholdStart.setX(this.centerX + this.centerX * Math.sin(-Math.toRadians(this.thresholdAngle)));
            this.dataBarThresholdStart.setY(this.centerY + this.centerX * Math.cos(-Math.toRadians(this.thresholdAngle)));
            this.dataBarThresholdOuterArc.setRadiusX(this.centerX);
            this.dataBarThresholdOuterArc.setRadiusY(this.centerX);
            this.dataBarThresholdOuterArc.setX(this.centerX + this.centerX * Math.sin(-Math.toRadians(dataBarThresholdAngle)));
            this.dataBarThresholdOuterArc.setY(this.centerY + this.centerX * Math.cos(-Math.toRadians(dataBarThresholdAngle)));
            this.dataBarThresholdLineToInnerArc.setX(this.centerX + (this.centerX - this.barWidth) * Math.sin(-Math.toRadians(dataBarThresholdAngle)));
            this.dataBarThresholdLineToInnerArc.setY(this.centerY + (this.centerX - this.barWidth) * Math.cos(-Math.toRadians(dataBarThresholdAngle)));
            this.dataBarThresholdInnerArc.setRadiusX(0.375 * this.width);
            this.dataBarThresholdInnerArc.setRadiusY(0.375 * this.width);
            this.dataBarThresholdInnerArc.setX(this.centerX + (this.centerX - this.barWidth) * Math.sin(-Math.toRadians(this.thresholdAngle)));
            this.dataBarThresholdInnerArc.setY(this.centerY + (this.centerX - this.barWidth) * Math.cos(-Math.toRadians(this.thresholdAngle)));
        }
    }

    private void redraw() {
        this.locale = ((Gauge)this.getSkinnable()).getLocale();
        this.formatString = "%." + Integer.toString(((Gauge)this.getSkinnable()).getDecimals()) + "f";
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Gauge)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(((Gauge)this.getSkinnable()).getBorderWidth() / 250.0 * this.width))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.barColor = ((Gauge)this.getSkinnable()).getBarColor();
        this.thresholdColor = ((Gauge)this.getSkinnable()).getThresholdColor();
        this.barBackgroundColor = ((Gauge)this.getSkinnable()).getBarBackgroundColor();
        this.thresholdBackgroundColor = Color.color((double)this.thresholdColor.getRed(), (double)this.thresholdColor.getGreen(), (double)this.thresholdColor.getBlue(), (double)0.25);
        this.barBackground.setFill((Paint)this.barBackgroundColor);
        this.thresholdBar.setFill((Paint)this.thresholdBackgroundColor);
        this.dataBar.setFill((Paint)this.barColor);
        this.dataBarThreshold.setFill((Paint)this.thresholdColor);
        this.titleText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.titleText.setText(((Gauge)this.getSkinnable()).getTitle());
        this.valueText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        this.valueText.setText(String.format(this.locale, this.formatString, ((Gauge)this.getSkinnable()).getCurrentValue()));
        this.valueText.relocate(this.width - this.valueText.getLayoutBounds().getWidth(), 0.58064516 * this.height);
        this.unitText.setFill((Paint)((Gauge)this.getSkinnable()).getUnitColor());
        this.unitText.setText(((Gauge)this.getSkinnable()).getUnit());
        this.unitText.relocate(this.width - this.unitText.getLayoutBounds().getWidth(), 0.79 * this.height);
    }
}

