/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.tools.Helper;
import java.util.List;
import java.util.Locale;
import javafx.geometry.Insets;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class SimpleDigitalSkin
extends SkinBase<Gauge>
implements Skin<Gauge> {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final double ANGLE_RANGE = 300.0;
    private double size;
    private double center;
    private Pane pane;
    private Canvas backgroundCanvas;
    private GraphicsContext backgroundCtx;
    private Canvas barCanvas;
    private GraphicsContext barCtx;
    private Text valueBkgText;
    private Text valueText;
    private Color barColor;
    private Color valueColor;
    private Color unitColor;
    private double minValue;
    private double maxValue;
    private double range;
    private double angleStep;
    private boolean isStartFromZero;
    private double barWidth;
    private String formatString;
    private Locale locale;
    private boolean sectionsVisible;
    private List<Section> sections;
    private boolean thresholdVisible;
    private Color thresholdColor;

    public SimpleDigitalSkin(Gauge gauge) {
        super((Control)gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.minValue = gauge.getMinValue();
        this.maxValue = gauge.getMaxValue();
        this.range = gauge.getRange();
        this.angleStep = 300.0 / this.range;
        this.formatString = "%." + Integer.toString(gauge.getDecimals()) + "f";
        this.locale = gauge.getLocale();
        this.barColor = gauge.getBarColor();
        this.valueColor = gauge.getValueColor();
        this.unitColor = gauge.getUnitColor();
        this.isStartFromZero = gauge.isStartFromZero();
        this.sectionsVisible = gauge.getSectionsVisible();
        this.sections = gauge.getSections();
        this.thresholdVisible = gauge.isThresholdVisible();
        this.thresholdColor = gauge.getThresholdColor();
        this.init();
        this.initGraphics();
        this.registerListeners();
        this.setBar(gauge.getCurrentValue());
    }

    private void init() {
        if ((Double.compare(((Gauge)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getHeight(), 0.0) <= 0) && ((Gauge)this.getSkinnable()).getPrefWidth() < 0.0 && ((Gauge)this.getSkinnable()).getPrefHeight() < 0.0) {
            ((Gauge)this.getSkinnable()).setPrefSize(250.0, 250.0);
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMinSize(50.0, 50.0);
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.backgroundCanvas = new Canvas(250.0, 250.0);
        this.backgroundCtx = this.backgroundCanvas.getGraphicsContext2D();
        this.barCanvas = new Canvas(250.0, 250.0);
        this.barCtx = this.barCanvas.getGraphicsContext2D();
        this.valueBkgText = new Text();
        this.valueBkgText.setStroke(null);
        this.valueBkgText.setFill((Paint)Helper.getTranslucentColorFrom(this.valueColor, 0.1));
        Helper.enableNode((Node)this.valueBkgText, ((Gauge)this.getSkinnable()).isValueVisible());
        this.valueText = new Text();
        this.valueText.setStroke(null);
        this.valueText.setFill((Paint)this.valueColor);
        Helper.enableNode((Node)this.valueText, ((Gauge)this.getSkinnable()).isValueVisible());
        this.pane = new Pane(new Node[]{this.backgroundCanvas, this.barCanvas, this.valueBkgText, this.valueText});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Gauge)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(((Gauge)this.getSkinnable()).getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((Gauge)this.getSkinnable()).widthProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).heightProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).setOnUpdate(e -> this.handleEvents(e.eventType.name()));
        ((Gauge)this.getSkinnable()).currentValueProperty().addListener(o -> this.setBar(((Gauge)this.getSkinnable()).getCurrentValue()));
    }

    private void handleEvents(String EVENT_TYPE) {
        if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
            this.redraw();
        } else if ("REDRAW".equals(EVENT_TYPE)) {
            this.redraw();
        } else if ("RECALC".equals(EVENT_TYPE)) {
            this.minValue = ((Gauge)this.getSkinnable()).getMinValue();
            this.maxValue = ((Gauge)this.getSkinnable()).getMaxValue();
            this.range = ((Gauge)this.getSkinnable()).getRange();
            this.angleStep = 300.0 / this.range;
            this.redraw();
        } else if ("SECTIONS".equals(EVENT_TYPE)) {
            this.sections = ((Gauge)this.getSkinnable()).getSections();
        } else if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.valueBkgText, ((Gauge)this.getSkinnable()).isValueVisible());
            Helper.enableNode((Node)this.valueText, ((Gauge)this.getSkinnable()).isValueVisible());
            this.sectionsVisible = ((Gauge)this.getSkinnable()).getSectionsVisible();
            this.thresholdVisible = ((Gauge)this.getSkinnable()).isThresholdVisible();
        }
    }

    private void setBar(double VALUE) {
        this.barCtx.clearRect(0.0, 0.0, this.size, this.size);
        this.barCtx.setLineCap(StrokeLineCap.BUTT);
        this.barCtx.setStroke((Paint)this.barColor);
        this.barCtx.setLineWidth(this.barWidth);
        if (this.sectionsVisible) {
            int listSize = this.sections.size();
            for (int i = 0; i < listSize; ++i) {
                Section section = this.sections.get(i);
                if (!section.contains(VALUE)) continue;
                this.barCtx.setStroke((Paint)section.getColor());
                break;
            }
        }
        if (this.thresholdVisible && VALUE > ((Gauge)this.getSkinnable()).getThreshold()) {
            this.barCtx.setStroke((Paint)this.thresholdColor);
        }
        double v = (VALUE - this.minValue) * this.angleStep;
        int minValueAngle = (int)(-this.minValue * this.angleStep);
        if (!this.isStartFromZero) {
            for (int i = 0; i < 280; ++i) {
                if (i % 10 != 0 || !((double)i < v)) continue;
                this.barCtx.strokeArc(this.barWidth * 0.5 + this.barWidth * 0.1, this.barWidth * 0.5 + this.barWidth * 0.1, this.size - this.barWidth - this.barWidth * 0.2, this.size - this.barWidth - this.barWidth * 0.2, (double)(-i - 139), 9.2, ArcType.OPEN);
            }
        } else if (Double.compare(VALUE, 0.0) != 0) {
            if (VALUE < 0.0) {
                for (int i = minValueAngle - 1; i >= 0; --i) {
                    if (i % 10 != 0 || !((double)i > v - 6.0)) continue;
                    this.barCtx.strokeArc(this.barWidth * 0.5 + this.barWidth * 0.1, this.barWidth * 0.5 + this.barWidth * 0.1, this.size - this.barWidth - this.barWidth * 0.2, this.size - this.barWidth - this.barWidth * 0.2, (double)(-i - 139), 9.2, ArcType.OPEN);
                }
            } else {
                for (int i = minValueAngle; i <= 300; ++i) {
                    if (i % 10 != 0 || !((double)i < v)) continue;
                    this.barCtx.strokeArc(this.barWidth * 0.5 + this.barWidth * 0.1, this.barWidth * 0.5 + this.barWidth * 0.1, this.size - this.barWidth - this.barWidth * 0.2, this.size - this.barWidth - this.barWidth * 0.2, (double)(-i - 139), 9.2, ArcType.OPEN);
                }
            }
        }
        this.valueText.setText(String.format(this.locale, this.formatString, VALUE));
        this.valueText.setLayoutX(this.valueBkgText.getLayoutBounds().getMaxX() - this.valueText.getLayoutBounds().getWidth());
    }

    private void drawBackground() {
        this.backgroundCanvas.setCache(false);
        this.backgroundCtx.setLineCap(StrokeLineCap.BUTT);
        this.backgroundCtx.clearRect(0.0, 0.0, this.size, this.size);
        this.backgroundCtx.setStroke((Paint)Color.rgb((int)0, (int)12, (int)6, (double)0.1));
        Color bColor = Helper.getTranslucentColorFrom(this.barColor, 0.1);
        for (int i = -50; i < 230; ++i) {
            this.backgroundCtx.save();
            if (i % 10 == 0) {
                this.backgroundCtx.setStroke((Paint)bColor);
                this.backgroundCtx.setLineWidth(this.barWidth);
                this.backgroundCtx.strokeArc(this.barWidth * 0.5 + this.barWidth * 0.1, this.barWidth * 0.5 + this.barWidth * 0.1, this.size - this.barWidth - this.barWidth * 0.2, this.size - this.barWidth - this.barWidth * 0.2, (double)(i + 1), 9.2, ArcType.OPEN);
            }
            this.backgroundCtx.restore();
        }
        if (!((Gauge)this.getSkinnable()).getUnit().isEmpty()) {
            this.backgroundCtx.setTextAlign(TextAlignment.CENTER);
            this.backgroundCtx.setFont(Fonts.robotoBold(0.09 * this.size));
            this.backgroundCtx.setFill((Paint)this.unitColor);
            this.backgroundCtx.fillText(((Gauge)this.getSkinnable()).getUnit(), this.center, this.size * 0.75, this.size * 0.4);
        }
        this.backgroundCanvas.setCache(true);
        this.backgroundCanvas.setCacheHint(CacheHint.QUALITY);
        if (((Gauge)this.getSkinnable()).isValueVisible()) {
            int i;
            StringBuilder valueBkg = new StringBuilder();
            int len = String.valueOf((int)((Gauge)this.getSkinnable()).getMaxValue()).length();
            if (((Gauge)this.getSkinnable()).getMinValue() < 0.0) {
                ++len;
            }
            for (i = 0; i < len; ++i) {
                valueBkg.append("8");
            }
            if (((Gauge)this.getSkinnable()).getDecimals() > 0) {
                valueBkg.append(".");
                len = ((Gauge)this.getSkinnable()).getDecimals();
                for (i = 0; i < len; ++i) {
                    valueBkg.append("8");
                }
            }
            this.valueBkgText.setText(valueBkg.toString());
            this.valueBkgText.setX((this.size - this.valueBkgText.getLayoutBounds().getWidth()) * 0.5);
        }
    }

    private void resize() {
        double height;
        double width = ((Gauge)this.getSkinnable()).getWidth() - ((Gauge)this.getSkinnable()).getInsets().getLeft() - ((Gauge)this.getSkinnable()).getInsets().getRight();
        double d = this.size = width < (height = ((Gauge)this.getSkinnable()).getHeight() - ((Gauge)this.getSkinnable()).getInsets().getTop() - ((Gauge)this.getSkinnable()).getInsets().getBottom()) ? width : height;
        if (width > 0.0 && height > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((width - this.size) * 0.5, (height - this.size) * 0.5);
            this.center = this.size * 0.5;
            this.barWidth = this.size * 0.125;
            this.backgroundCanvas.setWidth(this.size);
            this.backgroundCanvas.setHeight(this.size);
            this.barCanvas.setWidth(this.size);
            this.barCanvas.setHeight(this.size);
            this.valueBkgText.setFont(Fonts.digitalReadoutBold(0.25 * this.size));
            this.valueBkgText.setY(this.center + this.valueBkgText.getLayoutBounds().getHeight() * 0.325);
            this.valueText.setFont(Fonts.digitalReadoutBold(0.25 * this.size));
            this.valueText.setY(this.center + this.valueText.getLayoutBounds().getHeight() * 0.325);
            this.drawBackground();
            this.setBar(((Gauge)this.getSkinnable()).getCurrentValue());
        }
    }

    private void redraw() {
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Gauge)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(((Gauge)this.getSkinnable()).getBorderWidth() / 250.0 * this.size))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.locale = ((Gauge)this.getSkinnable()).getLocale();
        this.formatString = "%." + Integer.toString(((Gauge)this.getSkinnable()).getDecimals()) + "f";
        this.barColor = ((Gauge)this.getSkinnable()).getBarColor();
        this.valueColor = ((Gauge)this.getSkinnable()).getValueColor();
        this.unitColor = ((Gauge)this.getSkinnable()).getUnitColor();
        this.drawBackground();
        this.setBar(((Gauge)this.getSkinnable()).getCurrentValue());
        this.valueBkgText.setFill((Paint)Helper.getTranslucentColorFrom(this.valueColor, 0.1));
        this.valueText.setFill((Paint)this.valueColor);
    }
}

