/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.Section;
import java.util.List;
import java.util.Locale;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.text.Text;

public class BatterySkin
extends SkinBase<Gauge>
implements Skin<Gauge> {
    private static final double PREFERRED_WIDTH = 160.0;
    private static final double PREFERRED_HEIGHT = 160.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private Orientation orientation;
    private double size;
    private Pane pane;
    private Path batteryBackground;
    private Path battery;
    private LinearGradient batteryPaint;
    private Text valueText;
    private List<Section> sections;
    private Locale locale;

    public BatterySkin(Gauge gauge) {
        super((Control)gauge);
        this.orientation = gauge.getOrientation();
        this.sections = gauge.getSections();
        this.locale = gauge.getLocale();
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if ((Double.compare(((Gauge)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getHeight(), 0.0) <= 0) && ((Gauge)this.getSkinnable()).getPrefWidth() < 0.0 && ((Gauge)this.getSkinnable()).getPrefHeight() < 0.0) {
            ((Gauge)this.getSkinnable()).setPrefSize(160.0, 160.0);
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMinSize(50.0, 50.0);
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.batteryBackground = new Path();
        this.batteryBackground.setFillRule(FillRule.EVEN_ODD);
        this.batteryBackground.setStroke(null);
        this.battery = new Path();
        this.battery.setFillRule(FillRule.EVEN_ODD);
        this.battery.setStroke(null);
        this.valueText = new Text(String.format(this.locale, "%.0f%%", ((Gauge)this.getSkinnable()).getCurrentValue()));
        this.valueText.setVisible(((Gauge)this.getSkinnable()).isValueVisible());
        this.valueText.setManaged(((Gauge)this.getSkinnable()).isValueVisible());
        this.pane = new Pane();
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Gauge)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(1.0))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.pane.getChildren().setAll((Object[])new Node[]{this.batteryBackground, this.battery, this.valueText});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((Gauge)this.getSkinnable()).widthProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).heightProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).setOnUpdate(e -> this.handleEvents(e.eventType.name()));
        ((Gauge)this.getSkinnable()).currentValueProperty().addListener(e -> this.setBar(((Gauge)this.getSkinnable()).getCurrentValue()));
        this.handleEvents("VISIBILITY");
    }

    protected void handleEvents(String EVENT_TYPE) {
        if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
            this.redraw();
        } else if ("REDRAW".equals(EVENT_TYPE)) {
            this.redraw();
        } else if ("RECALC".equals(EVENT_TYPE)) {
            if (((Gauge)this.getSkinnable()).isAutoScale()) {
                ((Gauge)this.getSkinnable()).calcAutoScale();
            }
            this.setBar(((Gauge)this.getSkinnable()).getCurrentValue());
            this.resize();
            this.redraw();
        } else if ("SECTION".equals(EVENT_TYPE)) {
            this.sections = ((Gauge)this.getSkinnable()).getSections();
            this.resize();
            this.redraw();
        } else if ("VISIBILITY".equals(EVENT_TYPE)) {
            this.valueText.setVisible(((Gauge)this.getSkinnable()).isValueVisible());
            this.valueText.setManaged(((Gauge)this.getSkinnable()).isValueVisible());
            this.redraw();
        }
    }

    private void setBar(double VALUE) {
        double factor = VALUE / ((Gauge)this.getSkinnable()).getRange();
        Color barColor = ((Gauge)this.getSkinnable()).getBarColor();
        if (((Gauge)this.getSkinnable()).isGradientBarEnabled() && !((Gauge)this.getSkinnable()).getGradientBarStops().isEmpty()) {
            barColor = ((Gauge)this.getSkinnable()).getGradientLookup().getColorAt(factor);
        } else if (((Gauge)this.getSkinnable()).getSectionsVisible() && !this.sections.isEmpty()) {
            int listSize = this.sections.size();
            for (int i = 0; i < listSize; ++i) {
                if (!this.sections.get(i).contains(VALUE)) continue;
                barColor = this.sections.get(i).getColor();
                break;
            }
        }
        this.batteryPaint = Orientation.HORIZONTAL == this.orientation ? new LinearGradient(0.0, 0.0, this.size, 0.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, barColor), new Stop(factor, barColor), new Stop(factor, Color.TRANSPARENT), new Stop(1.0, Color.TRANSPARENT)}) : new LinearGradient(0.0, 0.0, 0.0, this.size, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.TRANSPARENT), new Stop(1.0 - factor, Color.TRANSPARENT), new Stop(1.0 - factor, barColor), new Stop(1.0, barColor)});
        this.battery.setFill((Paint)this.batteryPaint);
        this.valueText.setText(String.format(this.locale, "%.0f%%", factor * 100.0));
        this.valueText.relocate((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5, (this.size - this.valueText.getLayoutBounds().getHeight()) * 0.5);
    }

    private Path createVerticalBattery(Path PATH) {
        PATH.getElements().clear();
        PATH.getElements().add((Object)new MoveTo(0.25 * this.size, 0.175 * this.size));
        PATH.getElements().add((Object)new CubicCurveTo(0.25 * this.size, 0.175 * this.size, 0.25 * this.size, 0.925 * this.size, 0.25 * this.size, 0.925 * this.size));
        PATH.getElements().add((Object)new CubicCurveTo(0.25 * this.size, 0.96875 * this.size, 0.28125 * this.size, this.size, 0.325 * this.size, this.size));
        PATH.getElements().add((Object)new CubicCurveTo(0.325 * this.size, this.size, 0.675 * this.size, this.size, 0.675 * this.size, this.size));
        PATH.getElements().add((Object)new CubicCurveTo(0.71875 * this.size, this.size, 0.75 * this.size, 0.96875 * this.size, 0.75 * this.size, 0.925 * this.size));
        PATH.getElements().add((Object)new CubicCurveTo(0.75 * this.size, 0.925 * this.size, 0.75 * this.size, 0.175 * this.size, 0.75 * this.size, 0.175 * this.size));
        PATH.getElements().add((Object)new CubicCurveTo(0.75 * this.size, 0.13125 * this.size, 0.71875 * this.size, 0.1 * this.size, 0.675 * this.size, 0.1 * this.size));
        PATH.getElements().add((Object)new CubicCurveTo(0.675 * this.size, 0.1 * this.size, 0.6 * this.size, 0.1 * this.size, 0.6 * this.size, 0.1 * this.size));
        PATH.getElements().add((Object)new LineTo(0.6 * this.size, 0.0));
        PATH.getElements().add((Object)new LineTo(0.4 * this.size, 0.0));
        PATH.getElements().add((Object)new LineTo(0.4 * this.size, 0.1 * this.size));
        PATH.getElements().add((Object)new CubicCurveTo(0.4 * this.size, 0.1 * this.size, 0.325 * this.size, 0.1 * this.size, 0.325 * this.size, 0.1 * this.size));
        PATH.getElements().add((Object)new CubicCurveTo(0.28125 * this.size, 0.1 * this.size, 0.25 * this.size, 0.13125 * this.size, 0.25 * this.size, 0.175 * this.size));
        PATH.getElements().add((Object)new ClosePath());
        return PATH;
    }

    private Path createHorizontalBattery(Path PATH) {
        PATH.getElements().clear();
        PATH.getElements().add((Object)new MoveTo(0.825 * this.size, 0.25 * this.size));
        PATH.getElements().add((Object)new CubicCurveTo(0.825 * this.size, 0.25 * this.size, 0.075 * this.size, 0.25 * this.size, 0.075 * this.size, 0.25 * this.size));
        PATH.getElements().add((Object)new CubicCurveTo(0.03125 * this.size, 0.25 * this.size, 0.0, 0.28125 * this.size, 0.0, 0.325 * this.size));
        PATH.getElements().add((Object)new CubicCurveTo(0.0, 0.325 * this.size, 0.0, 0.675 * this.size, 0.0, 0.675 * this.size));
        PATH.getElements().add((Object)new CubicCurveTo(0.0, 0.71875 * this.size, 0.03125 * this.size, 0.75 * this.size, 0.075 * this.size, 0.75 * this.size));
        PATH.getElements().add((Object)new CubicCurveTo(0.075 * this.size, 0.75 * this.size, 0.825 * this.size, 0.75 * this.size, 0.825 * this.size, 0.75 * this.size));
        PATH.getElements().add((Object)new CubicCurveTo(0.86875 * this.size, 0.75 * this.size, 0.9 * this.size, 0.71875 * this.size, 0.9 * this.size, 0.675 * this.size));
        PATH.getElements().add((Object)new CubicCurveTo(0.9 * this.size, 0.675 * this.size, 0.9 * this.size, 0.6 * this.size, 0.9 * this.size, 0.6 * this.size));
        PATH.getElements().add((Object)new LineTo(this.size, 0.6 * this.size));
        PATH.getElements().add((Object)new LineTo(this.size, 0.4 * this.size));
        PATH.getElements().add((Object)new LineTo(0.9 * this.size, 0.4 * this.size));
        PATH.getElements().add((Object)new CubicCurveTo(0.9 * this.size, 0.4 * this.size, 0.9 * this.size, 0.325 * this.size, 0.9 * this.size, 0.325 * this.size));
        PATH.getElements().add((Object)new CubicCurveTo(0.9 * this.size, 0.28125 * this.size, 0.86875 * this.size, 0.25 * this.size, 0.825 * this.size, 0.25 * this.size));
        PATH.getElements().add((Object)new ClosePath());
        return PATH;
    }

    private void resize() {
        double height;
        double width = ((Gauge)this.getSkinnable()).getWidth() - ((Gauge)this.getSkinnable()).getInsets().getLeft() - ((Gauge)this.getSkinnable()).getInsets().getRight();
        double d = this.size = width < (height = ((Gauge)this.getSkinnable()).getHeight() - ((Gauge)this.getSkinnable()).getInsets().getTop() - ((Gauge)this.getSkinnable()).getInsets().getBottom()) ? width : height;
        if (this.size > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((((Gauge)this.getSkinnable()).getWidth() - this.size) * 0.5, (((Gauge)this.getSkinnable()).getHeight() - this.size) * 0.5);
            this.valueText.setFont(Fonts.latoLight(0.175 * this.size));
            this.valueText.relocate((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5, (this.size - this.valueText.getLayoutBounds().getHeight()) * 0.5);
            this.orientation = ((Gauge)this.getSkinnable()).getOrientation();
            if (Orientation.VERTICAL == this.orientation) {
                this.createVerticalBattery(this.batteryBackground);
                this.createVerticalBattery(this.battery);
            } else {
                this.createHorizontalBattery(this.batteryBackground);
                this.createHorizontalBattery(this.battery);
            }
            this.redraw();
        }
    }

    private void redraw() {
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Gauge)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(1.0))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.locale = ((Gauge)this.getSkinnable()).getLocale();
        Color barBackgroundColor = ((Gauge)this.getSkinnable()).getBarBackgroundColor();
        this.batteryBackground.setFill((Paint)Color.color((double)barBackgroundColor.getRed(), (double)barBackgroundColor.getGreen(), (double)barBackgroundColor.getBlue(), (double)0.3));
        this.valueText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        this.setBar(((Gauge)this.getSkinnable()).getCurrentValue());
    }
}

