/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.tools.Helper;
import java.util.List;
import java.util.Locale;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class DashboardSkin
extends SkinBase<Gauge>
implements Skin<Gauge> {
    private static final double PREFERRED_WIDTH = 200.0;
    private static final double PREFERRED_HEIGHT = 148.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final double ASPECT_RATIO = 0.74;
    private static final double ANGLE_RANGE = 180.0;
    private double size;
    private double width;
    private double height;
    private double centerX;
    private double currentValueAngle;
    private Pane pane;
    private Text unitText;
    private Text titleText;
    private Text valueText;
    private Text minText;
    private Text maxText;
    private Path barBackground;
    private MoveTo barBackgroundStart;
    private ArcTo barBackgroundOuterArc;
    private LineTo barBackgroundLineToInnerArc;
    private ArcTo barBackgroundInnerArc;
    private Path dataBar;
    private MoveTo dataBarStart;
    private ArcTo dataBarOuterArc;
    private LineTo dataBarLineToInnerArc;
    private ArcTo dataBarInnerArc;
    private Line threshold;
    private Text thresholdText;
    private InnerShadow innerShadow;
    private Font smallFont;
    private Font bigFont;
    private double range;
    private double angleStep;
    private boolean colorGradientEnabled;
    private int noOfGradientStops;
    private boolean sectionsVisible;
    private List<Section> sections;
    private String formatString;
    private String otherFormatString;
    private Locale locale;
    private double minValue;

    public DashboardSkin(Gauge gauge) {
        super((Control)gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.range = gauge.getRange();
        this.angleStep = 180.0 / this.range;
        this.colorGradientEnabled = gauge.isGradientBarEnabled();
        this.noOfGradientStops = gauge.getGradientBarStops().size();
        this.sectionsVisible = gauge.getSectionsVisible();
        this.sections = gauge.getSections();
        this.currentValueAngle = 0.0;
        this.formatString = "%." + Integer.toString(gauge.getDecimals()) + "f";
        this.otherFormatString = "%." + Integer.toString(gauge.getTickLabelDecimals()) + "f";
        this.locale = gauge.getLocale();
        this.init();
        this.initGraphics();
        this.registerListeners();
        this.setBar(gauge.getValue());
    }

    private void init() {
        if (Double.compare(((Gauge)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((Gauge)this.getSkinnable()).getPrefWidth() > 0.0 && ((Gauge)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((Gauge)this.getSkinnable()).setPrefSize(((Gauge)this.getSkinnable()).getPrefWidth(), ((Gauge)this.getSkinnable()).getPrefHeight());
            } else {
                ((Gauge)this.getSkinnable()).setPrefSize(200.0, 148.0);
            }
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMinSize(50.0, 50.0);
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.unitText = new Text(((Gauge)this.getSkinnable()).getUnit());
        this.unitText.setTextOrigin(VPos.CENTER);
        this.unitText.setFill((Paint)((Gauge)this.getSkinnable()).getUnitColor());
        boolean isUnitVisible = !((Gauge)this.getSkinnable()).getUnit().isEmpty();
        this.unitText.setVisible(isUnitVisible);
        this.unitText.setManaged(isUnitVisible);
        this.titleText = new Text(((Gauge)this.getSkinnable()).getTitle());
        this.titleText.setTextOrigin(VPos.CENTER);
        this.titleText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        boolean isTitleVisible = !((Gauge)this.getSkinnable()).getTitle().isEmpty();
        this.unitText.setVisible(isTitleVisible);
        this.unitText.setManaged(isTitleVisible);
        this.valueText = new Text(String.format(this.locale, this.formatString, ((Gauge)this.getSkinnable()).getValue()));
        this.valueText.setTextOrigin(VPos.CENTER);
        this.valueText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        boolean isValueVisible = ((Gauge)this.getSkinnable()).isValueVisible();
        this.valueText.setVisible(isValueVisible);
        this.valueText.setManaged(isValueVisible);
        this.minValue = ((Gauge)this.getSkinnable()).getMinValue();
        this.minText = new Text(String.format(this.locale, this.otherFormatString, this.minValue));
        this.minText.setTextOrigin(VPos.CENTER);
        this.minText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        this.maxText = new Text(String.format(this.locale, this.otherFormatString, ((Gauge)this.getSkinnable()).getMaxValue()));
        this.maxText.setTextOrigin(VPos.CENTER);
        this.maxText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        boolean tickLabelsVisible = ((Gauge)this.getSkinnable()).getTickLabelsVisible();
        this.minText.setVisible(tickLabelsVisible);
        this.minText.setManaged(tickLabelsVisible);
        this.maxText.setVisible(tickLabelsVisible);
        this.maxText.setManaged(tickLabelsVisible);
        this.innerShadow = new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.3), 30.0, 0.0, 0.0, 10.0);
        this.barBackgroundStart = new MoveTo(0.0, 99.9);
        this.barBackgroundOuterArc = new ArcTo(99.9, 99.9, 0.0, 200.0, 99.9, true, true);
        this.barBackgroundLineToInnerArc = new LineTo(144.444, 99.9);
        this.barBackgroundInnerArc = new ArcTo(44.4, 44.4, 0.0, 55.556000000000004, 99.9, false, false);
        this.barBackground = new Path();
        this.barBackground.setFillRule(FillRule.EVEN_ODD);
        this.barBackground.getElements().add((Object)this.barBackgroundStart);
        this.barBackground.getElements().add((Object)this.barBackgroundOuterArc);
        this.barBackground.getElements().add((Object)this.barBackgroundLineToInnerArc);
        this.barBackground.getElements().add((Object)this.barBackgroundInnerArc);
        this.barBackground.getElements().add((Object)new ClosePath());
        this.barBackground.setFill((Paint)((Gauge)this.getSkinnable()).getBarBackgroundColor());
        this.barBackground.setStroke(((Gauge)this.getSkinnable()).getBorderPaint());
        this.barBackground.setEffect((Effect)(((Gauge)this.getSkinnable()).isShadowsEnabled() ? this.innerShadow : null));
        this.dataBarStart = new MoveTo(0.0, 99.9);
        this.dataBarOuterArc = new ArcTo(99.9, 99.9, 0.0, 0.0, 0.0, false, true);
        this.dataBarLineToInnerArc = new LineTo(55.556000000000004, 99.9);
        this.dataBarInnerArc = new ArcTo(44.4, 44.4, 0.0, 0.0, 0.0, false, false);
        this.dataBar = new Path();
        this.dataBar.setFillRule(FillRule.EVEN_ODD);
        this.dataBar.getElements().add((Object)this.dataBarStart);
        this.dataBar.getElements().add((Object)this.dataBarOuterArc);
        this.dataBar.getElements().add((Object)this.dataBarLineToInnerArc);
        this.dataBar.getElements().add((Object)this.dataBarInnerArc);
        this.dataBar.getElements().add((Object)new ClosePath());
        this.dataBar.setFill((Paint)((Gauge)this.getSkinnable()).getBarColor());
        this.dataBar.setStroke(((Gauge)this.getSkinnable()).getBorderPaint());
        this.dataBar.setEffect((Effect)(((Gauge)this.getSkinnable()).isShadowsEnabled() ? this.innerShadow : null));
        this.threshold = new Line();
        this.threshold.setStrokeLineCap(StrokeLineCap.BUTT);
        this.threshold.setVisible(((Gauge)this.getSkinnable()).isThresholdVisible());
        this.threshold.setManaged(((Gauge)this.getSkinnable()).isThresholdVisible());
        this.thresholdText = new Text(String.format(this.locale, this.formatString, ((Gauge)this.getSkinnable()).getThreshold()));
        this.thresholdText.setVisible(((Gauge)this.getSkinnable()).isThresholdVisible());
        this.thresholdText.setManaged(((Gauge)this.getSkinnable()).isThresholdVisible());
        this.pane = new Pane(new Node[]{this.unitText, this.titleText, this.valueText, this.minText, this.maxText, this.barBackground, this.dataBar, this.threshold, this.thresholdText});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Gauge)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(((Gauge)this.getSkinnable()).getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((Gauge)this.getSkinnable()).widthProperty().addListener(o -> this.resize());
        ((Gauge)this.getSkinnable()).heightProperty().addListener(o -> this.resize());
        ((Gauge)this.getSkinnable()).setOnUpdate(e -> this.handleEvents(e.eventType.name()));
        ((Gauge)this.getSkinnable()).currentValueProperty().addListener(o -> this.setBar(((Gauge)this.getSkinnable()).getCurrentValue()));
    }

    protected void handleEvents(String EVENT_TYPE) {
        if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
            this.redraw();
        } else if ("REDRAW".equals(EVENT_TYPE)) {
            this.redraw();
        } else if ("RECALC".equals(EVENT_TYPE)) {
            this.range = ((Gauge)this.getSkinnable()).getRange();
            this.angleStep = 180.0 / this.range;
            this.minValue = ((Gauge)this.getSkinnable()).getMinValue();
            this.sections = ((Gauge)this.getSkinnable()).getSections();
            this.resize();
            this.redraw();
        } else if ("VISBILITY".equals(EVENT_TYPE)) {
            boolean isTitleVisible = !((Gauge)this.getSkinnable()).getTitle().isEmpty();
            this.titleText.setVisible(isTitleVisible);
            this.titleText.setManaged(isTitleVisible);
            boolean isUnitVisible = !((Gauge)this.getSkinnable()).getUnit().isEmpty();
            this.unitText.setVisible(isUnitVisible);
            this.unitText.setManaged(isUnitVisible);
            boolean isValueVisible = ((Gauge)this.getSkinnable()).isValueVisible();
            this.valueText.setVisible(isValueVisible);
            this.valueText.setManaged(isValueVisible);
            boolean tickLabelsVisible = ((Gauge)this.getSkinnable()).getTickLabelsVisible();
            this.minText.setVisible(tickLabelsVisible);
            this.minText.setManaged(tickLabelsVisible);
            this.maxText.setVisible(tickLabelsVisible);
            this.maxText.setManaged(tickLabelsVisible);
            boolean isThresholdVisible = ((Gauge)this.getSkinnable()).isThresholdVisible();
            this.threshold.setVisible(isThresholdVisible);
            this.threshold.setManaged(isThresholdVisible);
            this.thresholdText.setVisible(isThresholdVisible);
            this.thresholdText.setManaged(isThresholdVisible);
            this.redraw();
        }
    }

    private void setBar(double VALUE) {
        this.currentValueAngle = Helper.clamp(90.0, 270.0, (VALUE - this.minValue) * this.angleStep + 90.0);
        this.dataBarOuterArc.setX(this.centerX + 0.675 * this.height * Math.sin(-Math.toRadians(this.currentValueAngle)));
        this.dataBarOuterArc.setY(this.centerX + 0.675 * this.height * Math.cos(-Math.toRadians(this.currentValueAngle)));
        this.dataBarLineToInnerArc.setX(this.centerX + 0.3 * this.height * Math.sin(-Math.toRadians(this.currentValueAngle)));
        this.dataBarLineToInnerArc.setY(this.centerX + 0.3 * this.height * Math.cos(-Math.toRadians(this.currentValueAngle)));
        this.setBarColor(VALUE);
        this.valueText.setText(String.format(this.locale, this.formatString, VALUE));
        if (this.valueText.getLayoutBounds().getWidth() > 0.28 * this.width) {
            Helper.adjustTextSize(this.valueText, 0.28 * this.width, this.size * 0.24);
        }
        this.valueText.relocate((this.width - this.valueText.getLayoutBounds().getWidth()) * 0.5, 0.615 * this.height + (0.3 * this.height - this.valueText.getLayoutBounds().getHeight()) * 0.5);
    }

    private void setBarColor(double VALUE) {
        if (!this.sectionsVisible && !this.colorGradientEnabled) {
            this.dataBar.setFill((Paint)((Gauge)this.getSkinnable()).getBarColor());
        } else if (this.colorGradientEnabled && this.noOfGradientStops > 1) {
            this.dataBar.setFill((Paint)((Gauge)this.getSkinnable()).getGradientLookup().getColorAt((VALUE - this.minValue) / this.range));
        } else {
            for (Section section : this.sections) {
                if (!section.contains(VALUE)) continue;
                this.dataBar.setFill((Paint)section.getColor());
                break;
            }
        }
    }

    private void resize() {
        this.width = ((Gauge)this.getSkinnable()).getWidth() - ((Gauge)this.getSkinnable()).getInsets().getLeft() - ((Gauge)this.getSkinnable()).getInsets().getRight();
        this.height = ((Gauge)this.getSkinnable()).getHeight() - ((Gauge)this.getSkinnable()).getInsets().getTop() - ((Gauge)this.getSkinnable()).getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (0.74 * this.width > this.height) {
            this.width = 1.0 / (0.74 / this.height);
        } else if (1.0 / (0.74 / this.height) > this.width) {
            this.height = 0.74 * this.width;
        }
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.relocate((((Gauge)this.getSkinnable()).getWidth() - this.width) * 0.5, (((Gauge)this.getSkinnable()).getHeight() - this.height) * 0.5);
            this.centerX = this.width * 0.5;
            this.smallFont = Fonts.robotoThin(0.12 * this.height);
            this.bigFont = Fonts.robotoRegular(0.24 * this.height);
            this.unitText.setFont(this.smallFont);
            this.unitText.relocate((this.width - this.unitText.getLayoutBounds().getWidth()) * 0.5, 0.5 * this.height);
            double maxWidth = 0.95 * this.width;
            this.titleText.setFont(this.smallFont);
            if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
                Helper.adjustTextSize(this.titleText, maxWidth, this.size * 0.12);
            }
            this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, 0.88 * this.height);
            maxWidth = 0.28 * this.width;
            this.valueText.setFont(this.bigFont);
            if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
                Helper.adjustTextSize(this.valueText, maxWidth, this.size * 0.24);
            }
            this.valueText.relocate((this.width - this.valueText.getLayoutBounds().getWidth()) * 0.5, 0.615 * this.height + (0.3 * this.height - this.valueText.getLayoutBounds().getHeight()) * 0.5);
            maxWidth = 0.27 * this.width;
            this.minText.setText(String.format(this.locale, this.otherFormatString, this.minValue));
            this.minText.setFont(this.smallFont);
            if (this.minText.getLayoutBounds().getWidth() > maxWidth) {
                Helper.adjustTextSize(this.minText, maxWidth, this.size * 0.12);
            }
            this.minText.relocate((0.27778 * this.width - this.minText.getLayoutBounds().getWidth()) * 0.5, 0.7 * this.height);
            this.maxText.setText(String.format(this.locale, this.otherFormatString, ((Gauge)this.getSkinnable()).getMaxValue()));
            this.maxText.setFont(this.smallFont);
            if (this.maxText.getLayoutBounds().getWidth() > maxWidth) {
                Helper.adjustTextSize(this.maxText, maxWidth, this.size * 0.12);
            }
            this.maxText.relocate((0.27778 * this.width - this.maxText.getLayoutBounds().getWidth()) * 0.5 + 0.72222 * this.width, 0.7 * this.height);
            if (((Gauge)this.getSkinnable()).isShadowsEnabled()) {
                this.innerShadow.setRadius(0.075 * this.height);
                this.innerShadow.setOffsetY(0.025 * this.height);
            }
            this.barBackgroundStart.setX(0.0);
            this.barBackgroundStart.setY(0.675 * this.height);
            this.barBackgroundOuterArc.setRadiusX(0.675 * this.height);
            this.barBackgroundOuterArc.setRadiusY(0.675 * this.height);
            this.barBackgroundOuterArc.setX(this.width);
            this.barBackgroundOuterArc.setY(0.675 * this.height);
            this.barBackgroundLineToInnerArc.setX(0.72222 * this.width);
            this.barBackgroundLineToInnerArc.setY(0.675 * this.height);
            this.barBackgroundInnerArc.setRadiusX(0.3 * this.height);
            this.barBackgroundInnerArc.setRadiusY(0.3 * this.height);
            this.barBackgroundInnerArc.setX(0.27778 * this.width);
            this.barBackgroundInnerArc.setY(0.675 * this.height);
            this.currentValueAngle = Helper.clamp(90.0, 270.0, (((Gauge)this.getSkinnable()).getCurrentValue() - this.minValue) * this.angleStep + 90.0);
            this.dataBarStart.setX(0.0);
            this.dataBarStart.setY(0.675 * this.height);
            this.dataBarOuterArc.setRadiusX(0.675 * this.height);
            this.dataBarOuterArc.setRadiusY(0.675 * this.height);
            this.dataBarOuterArc.setX(this.centerX + 0.675 * this.height * Math.sin(-Math.toRadians(this.currentValueAngle)));
            this.dataBarOuterArc.setY(this.centerX + 0.675 * this.height * Math.cos(-Math.toRadians(this.currentValueAngle)));
            this.dataBarLineToInnerArc.setX(this.centerX + 0.3 * this.height * Math.sin(-Math.toRadians(this.currentValueAngle)));
            this.dataBarLineToInnerArc.setY(this.centerX + 0.3 * this.height * Math.cos(-Math.toRadians(this.currentValueAngle)));
            this.dataBarInnerArc.setRadiusX(0.3 * this.height);
            this.dataBarInnerArc.setRadiusY(0.3 * this.height);
            this.dataBarInnerArc.setX(0.27778 * this.width);
            this.dataBarInnerArc.setY(0.675 * this.height);
            this.threshold.setStroke((Paint)((Gauge)this.getSkinnable()).getThresholdColor());
            this.threshold.setStrokeWidth(Helper.clamp(1.0, 2.0, 0.00675676 * this.height).doubleValue());
            double thresholdInnerRadius = 0.3 * this.height;
            double thresholdOuterRadius = 0.675 * this.height;
            double thresholdAngle = Helper.clamp(90.0, 270.0, (((Gauge)this.getSkinnable()).getThreshold() - this.minValue) * this.angleStep + 90.0);
            this.threshold.setStartX(this.centerX + thresholdInnerRadius * Math.sin(-Math.toRadians(thresholdAngle)));
            this.threshold.setStartY(this.centerX + thresholdInnerRadius * Math.cos(-Math.toRadians(thresholdAngle)));
            this.threshold.setEndX(this.centerX + thresholdOuterRadius * Math.sin(-Math.toRadians(thresholdAngle)));
            this.threshold.setEndY(this.centerX + thresholdOuterRadius * Math.cos(-Math.toRadians(thresholdAngle)));
            double thresholdTextRadius = 0.26 * this.height;
            this.thresholdText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
            this.thresholdText.setText(String.format(this.locale, this.formatString, ((Gauge)this.getSkinnable()).getThreshold()));
            this.thresholdText.setFont(Fonts.robotoBold(this.size * 0.047));
            this.thresholdText.setRotate(thresholdAngle + 180.0);
            this.thresholdText.relocate(this.centerX - this.thresholdText.getLayoutBounds().getWidth() * 0.5 + thresholdTextRadius * Math.sin(-Math.toRadians(thresholdAngle)), this.centerX - this.thresholdText.getLayoutBounds().getWidth() * 0.5 + thresholdTextRadius * Math.cos(-Math.toRadians(thresholdAngle)));
        }
    }

    private void redraw() {
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Gauge)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(((Gauge)this.getSkinnable()).getBorderWidth() / 250.0 * this.size))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.colorGradientEnabled = ((Gauge)this.getSkinnable()).isGradientBarEnabled();
        this.noOfGradientStops = ((Gauge)this.getSkinnable()).getGradientBarStops().size();
        this.sectionsVisible = ((Gauge)this.getSkinnable()).getSectionsVisible();
        this.barBackground.setFill((Paint)((Gauge)this.getSkinnable()).getBarBackgroundColor());
        this.barBackground.setEffect((Effect)(((Gauge)this.getSkinnable()).isShadowsEnabled() ? this.innerShadow : null));
        this.setBarColor(((Gauge)this.getSkinnable()).getCurrentValue());
        this.dataBar.setEffect((Effect)(((Gauge)this.getSkinnable()).isShadowsEnabled() ? this.innerShadow : null));
        this.threshold.setStroke((Paint)((Gauge)this.getSkinnable()).getThresholdColor());
        double thresholdInnerRadius = 0.3 * this.height;
        double thresholdOuterRadius = 0.675 * this.height;
        double thresholdAngle = Helper.clamp(90.0, 270.0, (((Gauge)this.getSkinnable()).getThreshold() - this.minValue) * this.angleStep + 90.0);
        this.threshold.setStartX(this.centerX + thresholdInnerRadius * Math.sin(-Math.toRadians(thresholdAngle)));
        this.threshold.setStartY(this.centerX + thresholdInnerRadius * Math.cos(-Math.toRadians(thresholdAngle)));
        this.threshold.setEndX(this.centerX + thresholdOuterRadius * Math.sin(-Math.toRadians(thresholdAngle)));
        this.threshold.setEndY(this.centerX + thresholdOuterRadius * Math.cos(-Math.toRadians(thresholdAngle)));
        this.redrawText();
    }

    private void redrawText() {
        this.locale = ((Gauge)this.getSkinnable()).getLocale();
        this.formatString = "%." + Integer.toString(((Gauge)this.getSkinnable()).getDecimals()) + "f";
        this.otherFormatString = "%." + Integer.toString(((Gauge)this.getSkinnable()).getTickLabelDecimals()) + "f";
        this.titleText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.titleText.setText(((Gauge)this.getSkinnable()).getTitle());
        this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, 0.88 * this.height);
        this.valueText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        this.valueText.setText(String.format(this.locale, this.formatString, ((Gauge)this.getSkinnable()).getCurrentValue()));
        this.valueText.relocate((this.width - this.valueText.getLayoutBounds().getWidth()) * 0.5, 0.615 * this.height + (0.3 * this.height - this.valueText.getLayoutBounds().getHeight()) * 0.5);
        this.minText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        this.minText.setText(String.format(this.locale, this.otherFormatString, ((Gauge)this.getSkinnable()).getMinValue()));
        this.minText.relocate((0.27778 * this.width - this.minText.getLayoutBounds().getWidth()) * 0.5, 0.7 * this.height);
        this.maxText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        this.maxText.setText(String.format(this.locale, this.otherFormatString, ((Gauge)this.getSkinnable()).getMaxValue()));
        this.maxText.relocate((0.27778 * this.width - this.maxText.getLayoutBounds().getWidth()) * 0.5 + 0.72222 * this.width, 0.7 * this.height);
        this.unitText.setFill((Paint)((Gauge)this.getSkinnable()).getUnitColor());
        this.unitText.setText(((Gauge)this.getSkinnable()).getUnit());
        this.unitText.relocate((this.width - this.unitText.getLayoutBounds().getWidth()) * 0.5, 0.5 * this.height);
        double thresholdAngle = Helper.clamp(90.0, 270.0, (((Gauge)this.getSkinnable()).getThreshold() - this.minValue) * this.angleStep + 90.0);
        double thresholdTextRadius = 0.26 * this.height;
        this.thresholdText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        this.thresholdText.setText(String.format(this.locale, this.formatString, ((Gauge)this.getSkinnable()).getThreshold()));
        this.thresholdText.setFont(Fonts.robotoBold(this.size * 0.047));
        this.thresholdText.setRotate(thresholdAngle + 180.0);
        this.thresholdText.relocate(this.centerX - this.thresholdText.getLayoutBounds().getWidth() * 0.5 + thresholdTextRadius * Math.sin(-Math.toRadians(thresholdAngle)), this.centerX - this.thresholdText.getLayoutBounds().getWidth() * 0.5 + thresholdTextRadius * Math.cos(-Math.toRadians(thresholdAngle)));
    }
}

