/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa;

import eu.hansolo.medusa.LcdDesign;
import eu.hansolo.medusa.LcdFont;
import eu.hansolo.medusa.Marker;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.TickLabelLocation;
import eu.hansolo.medusa.TickLabelOrientation;
import eu.hansolo.medusa.TickMarkType;
import eu.hansolo.medusa.events.UpdateEvent;
import eu.hansolo.medusa.events.UpdateEventListener;
import eu.hansolo.medusa.skins.AmpSkin;
import eu.hansolo.medusa.skins.BarSkin;
import eu.hansolo.medusa.skins.BatterySkin;
import eu.hansolo.medusa.skins.BulletChartSkin;
import eu.hansolo.medusa.skins.ChargeSkin;
import eu.hansolo.medusa.skins.DashboardSkin;
import eu.hansolo.medusa.skins.DigitalSkin;
import eu.hansolo.medusa.skins.FlatSkin;
import eu.hansolo.medusa.skins.GaugeSkin;
import eu.hansolo.medusa.skins.HSkin;
import eu.hansolo.medusa.skins.IndicatorSkin;
import eu.hansolo.medusa.skins.KpiSkin;
import eu.hansolo.medusa.skins.LcdSkin;
import eu.hansolo.medusa.skins.LevelSkin;
import eu.hansolo.medusa.skins.LinearSkin;
import eu.hansolo.medusa.skins.ModernSkin;
import eu.hansolo.medusa.skins.QuarterSkin;
import eu.hansolo.medusa.skins.SectionSkin;
import eu.hansolo.medusa.skins.SimpleDigitalSkin;
import eu.hansolo.medusa.skins.SimpleSkin;
import eu.hansolo.medusa.skins.SlimSkin;
import eu.hansolo.medusa.skins.SpaceXSkin;
import eu.hansolo.medusa.skins.TinySkin;
import eu.hansolo.medusa.skins.VSkin;
import eu.hansolo.medusa.skins.WhiteSkin;
import eu.hansolo.medusa.tools.GradientLookup;
import eu.hansolo.medusa.tools.Helper;
import eu.hansolo.medusa.tools.MarkerComparator;
import eu.hansolo.medusa.tools.SectionComparator;
import java.text.NumberFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.util.Duration;

public class Gauge
extends Control {
    public static final Color DARK_COLOR = Color.rgb((int)36, (int)36, (int)36);
    public static final Color BRIGHT_COLOR = Color.rgb((int)223, (int)223, (int)223);
    private static final long LED_BLINK_INTERVAL = 500L;
    private static final int MAX_NO_OF_DECIMALS = 3;
    public final ButtonEvent BTN_PRESSED_EVENT = new ButtonEvent(ButtonEvent.BTN_PRESSED);
    public final ButtonEvent BTN_RELEASED_EVENT = new ButtonEvent(ButtonEvent.BTN_RELEASED);
    private final ThresholdEvent EXCEEDED_EVENT = new ThresholdEvent(ThresholdEvent.THRESHOLD_EXCEEDED);
    private final ThresholdEvent UNDERRUN_EVENT = new ThresholdEvent(ThresholdEvent.THRESHOLD_UNDERRUN);
    private final UpdateEvent RECALC_EVENT = new UpdateEvent((Object)this, UpdateEvent.EventType.RECALC);
    private final UpdateEvent REDRAW_EVENT = new UpdateEvent((Object)this, UpdateEvent.EventType.REDRAW);
    private final UpdateEvent RESIZE_EVENT = new UpdateEvent((Object)this, UpdateEvent.EventType.RESIZE);
    private final UpdateEvent LED_EVENT = new UpdateEvent((Object)this, UpdateEvent.EventType.LED);
    private final UpdateEvent LCD_EVENT = new UpdateEvent((Object)this, UpdateEvent.EventType.LCD);
    private final UpdateEvent VISIBILITY_EVENT = new UpdateEvent((Object)this, UpdateEvent.EventType.VISIBILITY);
    private final UpdateEvent INTERACTIVITY_EVENT = new UpdateEvent((Object)this, UpdateEvent.EventType.INTERACTIVITY);
    private final UpdateEvent FINISHED_EVENT = new UpdateEvent((Object)this, UpdateEvent.EventType.FINISHED);
    private final UpdateEvent SECTION_EVENT = new UpdateEvent((Object)this, UpdateEvent.EventType.SECTION);
    private static volatile Future blinkFuture;
    private static ScheduledExecutorService blinkService;
    private static volatile Callable<Void> blinkTask;
    private List<UpdateEventListener> listenerList = new CopyOnWriteArrayList<UpdateEventListener>();
    private DoubleProperty value;
    private DoubleProperty oldValue;
    private DoubleProperty currentValue;
    private DoubleProperty formerValue;
    private double _minValue;
    private DoubleProperty minValue;
    private double _maxValue;
    private DoubleProperty maxValue;
    private double _range;
    private DoubleProperty range;
    private double _threshold;
    private DoubleProperty threshold;
    private String _title;
    private StringProperty title;
    private String _subTitle;
    private StringProperty subTitle;
    private String _unit;
    private StringProperty unit;
    private ObservableList<Section> sections;
    private ObservableList<Section> areas;
    private ObservableList<Section> tickMarkSections;
    private ObservableList<Section> tickLabelSections;
    private ObservableList<Marker> markers;
    private SkinType skinType;
    private boolean _startFromZero;
    private BooleanProperty startFromZero;
    private boolean _returnToZero;
    private BooleanProperty returnToZero;
    private Color _zeroColor;
    private ObjectProperty<Color> zeroColor;
    private double _minMeasuredValue;
    private DoubleProperty minMeasuredValue;
    private double _maxMeasuredValue;
    private DoubleProperty maxMeasuredValue;
    private boolean _minMeasuredValueVisible;
    private BooleanProperty minMeasuredValueVisible;
    private boolean _maxMeasuredValueVisible;
    private BooleanProperty maxMeasuredValueVisible;
    private boolean _oldValueVisible;
    private BooleanProperty oldValueVisible;
    private boolean _valueVisible;
    private BooleanProperty valueVisible;
    private Paint _backgroundPaint;
    private ObjectProperty<Paint> backgroundPaint;
    private Paint _borderPaint;
    private ObjectProperty<Paint> borderPaint;
    private double _borderWidth;
    private DoubleProperty borderWidth;
    private Paint _foregroundPaint;
    private ObjectProperty<Paint> foregroundPaint;
    private Color _knobColor;
    private ObjectProperty<Color> knobColor;
    private KnobType _knobType;
    private ObjectProperty<KnobType> knobType;
    private Pos _knobPosition;
    private ObjectProperty<Pos> knobPosition;
    private boolean _knobVisible;
    private BooleanProperty knobVisible;
    private boolean _animated;
    private BooleanProperty animated;
    private long animationDuration;
    private double _startAngle;
    private DoubleProperty startAngle;
    private double _angleRange;
    private DoubleProperty angleRange;
    private double _angleStep;
    private DoubleProperty angleStep;
    private boolean _autoScale;
    private BooleanProperty autoScale;
    private boolean _shadowsEnabled;
    private BooleanProperty shadowsEnabled;
    private boolean _barEffectEnabled;
    private BooleanProperty barEffectEnabled;
    private ScaleDirection _scaleDirection;
    private ObjectProperty<ScaleDirection> scaleDirection;
    private TickLabelLocation _tickLabelLocation;
    private ObjectProperty<TickLabelLocation> tickLabelLocation;
    private TickLabelOrientation _tickLabelOrientation;
    private ObjectProperty<TickLabelOrientation> tickLabelOrientation;
    private Color _tickLabelColor;
    private ObjectProperty<Color> tickLabelColor;
    private Color _tickMarkColor;
    private ObjectProperty<Color> tickMarkColor;
    private Color _majorTickMarkColor;
    private ObjectProperty<Color> majorTickMarkColor;
    private double _majorTickMarkLengthFactor;
    private DoubleProperty majorTickMarkLengthFactor;
    private double _majorTickMarkWidthFactor;
    private DoubleProperty majorTickMarkWidthFactor;
    private Color _mediumTickMarkColor;
    private ObjectProperty<Color> mediumTickMarkColor;
    private double _mediumTickMarkLengthFactor;
    private DoubleProperty mediumTickMarkLengthFactor;
    private double _mediumTickMarkWidthFactor;
    private DoubleProperty mediumTickMarkWidthFactor;
    private Color _minorTickMarkColor;
    private ObjectProperty<Color> minorTickMarkColor;
    private double _minorTickMarkLengthFactor;
    private DoubleProperty minorTickMarkLengthFactor;
    private double _minorTickMarkWidthFactor;
    private DoubleProperty minorTickMarkWidthFactor;
    private TickMarkType _majorTickMarkType;
    private ObjectProperty<TickMarkType> majorTickMarkType;
    private TickMarkType _mediumTickMarkType;
    private ObjectProperty<TickMarkType> mediumTickMarkType;
    private TickMarkType _minorTickMarkType;
    private ObjectProperty<TickMarkType> minorTickMarkType;
    private Locale _locale;
    private ObjectProperty<Locale> locale;
    private NumberFormat _numberFormat;
    private ObjectProperty<NumberFormat> numberFormat;
    private int _decimals;
    private IntegerProperty decimals;
    private int _tickLabelDecimals;
    private IntegerProperty tickLabelDecimals;
    private NeedleType _needleType;
    private ObjectProperty<NeedleType> needleType;
    private NeedleShape _needleShape;
    private ObjectProperty<NeedleShape> needleShape;
    private NeedleSize _needleSize;
    private ObjectProperty<NeedleSize> needleSize;
    private NeedleBehavior _needleBehavior;
    private ObjectProperty<NeedleBehavior> needleBehavior;
    private Color _needleColor;
    private ObjectProperty<Color> needleColor;
    private Color _needleBorderColor;
    private ObjectProperty<Color> needleBorderColor;
    private Color _barColor;
    private ObjectProperty<Color> barColor;
    private Color _barBorderColor;
    private ObjectProperty<Color> barBorderColor;
    private Color _barBackgroundColor;
    private ObjectProperty<Color> barBackgroundColor;
    private LcdDesign _lcdDesign;
    private ObjectProperty<LcdDesign> lcdDesign;
    private LcdFont _lcdFont;
    private ObjectProperty<LcdFont> lcdFont;
    private Color _ledColor;
    private ObjectProperty<Color> ledColor;
    private LedType _ledType;
    private ObjectProperty<LedType> ledType;
    private Color _titleColor;
    private ObjectProperty<Color> titleColor;
    private Color _subTitleColor;
    private ObjectProperty<Color> subTitleColor;
    private Color _unitColor;
    private ObjectProperty<Color> unitColor;
    private Color _valueColor;
    private ObjectProperty<Color> valueColor;
    private Color _thresholdColor;
    private ObjectProperty<Color> thresholdColor;
    private boolean _checkSectionsForValue;
    private BooleanProperty checkSectionsForValue;
    private boolean _checkAreasForValue;
    private BooleanProperty checkAreasForValue;
    private boolean _checkThreshold;
    private BooleanProperty checkThreshold;
    private boolean _innerShadowEnabled;
    private BooleanProperty innerShadowEnabled;
    private boolean _thresholdVisible;
    private BooleanProperty thresholdVisible;
    private boolean _sectionsVisible;
    private BooleanProperty sectionsVisible;
    private boolean _sectionsAlwaysVisible;
    private BooleanProperty sectionsAlwaysVisible;
    private boolean _sectionTextVisible;
    private BooleanProperty sectionTextVisible;
    private boolean _sectionIconsVisible;
    private BooleanProperty sectionIconsVisible;
    private boolean _highlightSections;
    private BooleanProperty highlightSections;
    private boolean _areasVisible;
    private BooleanProperty areasVisible;
    private boolean _areaTextVisible;
    private BooleanProperty areaTextVisible;
    private boolean _areaIconsVisible;
    private BooleanProperty areaIconsVisible;
    private boolean _highlightAreas;
    private BooleanProperty highlightAreas;
    private boolean _tickMarkSectionsVisible;
    private BooleanProperty tickMarkSectionsVisible;
    private boolean _tickLabelSectionsVisible;
    private BooleanProperty tickLabelSectionsVisible;
    private boolean _markersVisible;
    private BooleanProperty markersVisible;
    private boolean _majorTickMarksVisible;
    private BooleanProperty majorTickMarksVisible;
    private boolean _mediumTickMarksVisible;
    private BooleanProperty mediumTickMarksVisible;
    private boolean _minorTickMarksVisible;
    private BooleanProperty minorTickMarksVisible;
    private boolean _tickMarkRingVisible;
    private BooleanProperty tickMarkRingVisible;
    private boolean _tickLabelsVisible;
    private BooleanProperty tickLabelsVisible;
    private boolean _onlyFirstAndLastTickLabelVisible;
    private BooleanProperty onlyFirstAndLastTickLabelVisible;
    private double _majorTickSpace;
    private DoubleProperty majorTickSpace;
    private double _minorTickSpace;
    private DoubleProperty minorTickSpace;
    private boolean _lcdVisible;
    private BooleanProperty lcdVisible;
    private boolean _lcdCrystalEnabled;
    private BooleanProperty lcdCrystalEnabled;
    private boolean _ledVisible;
    private BooleanProperty ledVisible;
    private boolean _ledOn;
    private BooleanProperty ledOn;
    private boolean _ledBlinking;
    private BooleanProperty ledBlinking;
    private Orientation _orientation;
    private ObjectProperty<Orientation> orientation;
    private boolean _gradientBarEnabled;
    private BooleanProperty gradientBarEnabled;
    private GradientLookup gradientLookup;
    private boolean _customTickLabelsEnabled;
    private BooleanProperty customTickLabelsEnabled;
    private ObservableList<String> customTickLabels;
    private double _customTickLabelFontSize;
    private DoubleProperty customTickLabelFontSize;
    private boolean _interactive;
    private BooleanProperty interactive;
    private String _buttonTooltipText;
    private StringProperty buttonTooltipText;
    private boolean _keepAspect;
    private BooleanProperty keepAspect;
    private double originalMinValue;
    private double originalMaxValue;
    private double originalThreshold;
    private Timeline timeline;
    private Instant lastCall;
    private boolean withinSpeedLimit;

    public Gauge() {
        this(SkinType.GAUGE);
    }

    public Gauge(SkinType SKIN) {
        this.skinType = SKIN;
        this.getStyleClass().add((Object)"gauge");
        this.init();
        this.registerListeners();
    }

    private void init() {
        this._minValue = 0.0;
        this._maxValue = 100.0;
        this.value = new DoublePropertyBase(this._minValue){

            protected void invalidated() {
                double VALUE = this.get();
                Gauge.this.withinSpeedLimit = !Instant.now().minusMillis(Gauge.this.getAnimationDuration()).isBefore(Gauge.this.lastCall);
                Gauge.this.lastCall = Instant.now();
                if (Gauge.this.isAnimated() && Gauge.this.withinSpeedLimit) {
                    KeyValue KEY_VALUE;
                    long animationDuration = Gauge.this.isReturnToZero() ? (long)(0.2 * (double)Gauge.this.getAnimationDuration()) : Gauge.this.getAnimationDuration();
                    Gauge.this.timeline.stop();
                    if (NeedleBehavior.STANDARD == Gauge.this.getNeedleBehavior()) {
                        KEY_VALUE = new KeyValue((WritableValue)Gauge.this.currentValue, (Object)VALUE, Interpolator.SPLINE((double)0.5, (double)0.4, (double)0.4, (double)1.0));
                    } else {
                        double ov = Gauge.this.getOldValue();
                        double min = Gauge.this.getMinValue();
                        double max = Gauge.this.getMaxValue();
                        double cv = Gauge.this.getCurrentValue();
                        if (Math.abs(VALUE - ov) > Gauge.this.getRange() * 0.5) {
                            double tmpValue = ov < VALUE ? min - max + VALUE : ov + max - ov + min + VALUE - Gauge.this.getRange();
                            KEY_VALUE = new KeyValue((WritableValue)Gauge.this.currentValue, (Object)tmpValue, Interpolator.SPLINE((double)0.5, (double)0.4, (double)0.4, (double)1.0));
                        } else {
                            if (cv < min) {
                                Gauge.this.currentValue.set(max + cv);
                            }
                            KEY_VALUE = new KeyValue((WritableValue)Gauge.this.currentValue, (Object)VALUE, Interpolator.SPLINE((double)0.5, (double)0.4, (double)0.4, (double)1.0));
                        }
                    }
                    KeyFrame KEY_FRAME = new KeyFrame(Duration.millis((double)animationDuration), new KeyValue[]{KEY_VALUE});
                    Gauge.this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{KEY_FRAME});
                    Gauge.this.timeline.play();
                } else {
                    Gauge.this.currentValue.set(VALUE);
                    Gauge.this.fireUpdateEvent(Gauge.this.FINISHED_EVENT);
                }
                Gauge.this.oldValue.set(this.get());
            }

            public Object getBean() {
                return Gauge.this;
            }

            public String getName() {
                return "value";
            }
        };
        this.oldValue = new SimpleDoubleProperty((Object)this, "oldValue", this.value.get());
        this.currentValue = new DoublePropertyBase(this.value.get()){

            protected void invalidated() {
                double VALUE = this.get();
                if (Gauge.this.isCheckThreshold()) {
                    double thrshld = Gauge.this.getThreshold();
                    if (Gauge.this.formerValue.get() < thrshld && VALUE > thrshld) {
                        Gauge.this.fireEvent(Gauge.this.EXCEEDED_EVENT);
                    } else if (Gauge.this.formerValue.get() > thrshld && VALUE < thrshld) {
                        Gauge.this.fireEvent(Gauge.this.UNDERRUN_EVENT);
                    }
                }
                if (VALUE < Gauge.this.getMinMeasuredValue()) {
                    Gauge.this.setMinMeasuredValue(VALUE);
                } else if (VALUE > Gauge.this.getMaxMeasuredValue()) {
                    Gauge.this.setMaxMeasuredValue(VALUE);
                }
                Gauge.this.formerValue.set(VALUE);
            }

            public void set(double VALUE) {
                super.set(VALUE);
            }

            public Object getBean() {
                return Gauge.this;
            }

            public String getName() {
                return "currentValue";
            }
        };
        this.formerValue = new SimpleDoubleProperty((Object)this, "formerValue", this.value.get());
        this._range = this._maxValue - this._minValue;
        this._threshold = this._maxValue;
        this._title = "";
        this._subTitle = "";
        this._unit = "";
        this.sections = FXCollections.observableArrayList();
        this.areas = FXCollections.observableArrayList();
        this.tickMarkSections = FXCollections.observableArrayList();
        this.tickLabelSections = FXCollections.observableArrayList();
        this.markers = FXCollections.observableArrayList();
        this._startFromZero = false;
        this._returnToZero = false;
        this._zeroColor = DARK_COLOR;
        this._minMeasuredValue = this._maxValue;
        this._maxMeasuredValue = this._minValue;
        this._minMeasuredValueVisible = false;
        this._maxMeasuredValueVisible = false;
        this._oldValueVisible = false;
        this._valueVisible = true;
        this._backgroundPaint = Color.TRANSPARENT;
        this._borderPaint = Color.TRANSPARENT;
        this._borderWidth = 1.0;
        this._foregroundPaint = Color.TRANSPARENT;
        this._knobColor = Color.rgb((int)204, (int)204, (int)204);
        this._knobType = KnobType.STANDARD;
        this._knobPosition = Pos.CENTER;
        this._knobVisible = true;
        this._animated = false;
        this.animationDuration = 800L;
        this._startAngle = 320.0;
        this._angleRange = 280.0;
        this._angleStep = this._angleRange / this._range;
        this._autoScale = true;
        this._shadowsEnabled = false;
        this._barEffectEnabled = false;
        this._scaleDirection = ScaleDirection.CLOCKWISE;
        this._tickLabelLocation = TickLabelLocation.INSIDE;
        this._tickLabelOrientation = TickLabelOrientation.HORIZONTAL;
        this._tickLabelColor = DARK_COLOR;
        this._tickMarkColor = DARK_COLOR;
        this._majorTickMarkColor = DARK_COLOR;
        this._majorTickMarkLengthFactor = 0.42;
        this._majorTickMarkWidthFactor = 0.275;
        this._mediumTickMarkColor = DARK_COLOR;
        this._mediumTickMarkLengthFactor = 0.41;
        this._mediumTickMarkWidthFactor = 0.175;
        this._minorTickMarkColor = DARK_COLOR;
        this._minorTickMarkLengthFactor = 0.4;
        this._minorTickMarkWidthFactor = 0.1125;
        this._majorTickMarkType = TickMarkType.LINE;
        this._mediumTickMarkType = TickMarkType.LINE;
        this._minorTickMarkType = TickMarkType.LINE;
        this._locale = Locale.US;
        this._numberFormat = NumberFormat.getInstance(this._locale);
        this._decimals = 1;
        this._tickLabelDecimals = 0;
        this._needleType = NeedleType.STANDARD;
        this._needleShape = NeedleShape.ANGLED;
        this._needleSize = NeedleSize.STANDARD;
        this._needleBehavior = NeedleBehavior.STANDARD;
        this._needleColor = Color.rgb((int)200, (int)0, (int)0);
        this._needleBorderColor = Color.TRANSPARENT;
        this._barColor = BRIGHT_COLOR;
        this._barBorderColor = Color.TRANSPARENT;
        this._barBackgroundColor = DARK_COLOR;
        this._lcdDesign = LcdDesign.STANDARD;
        this._lcdFont = LcdFont.DIGITAL_BOLD;
        this._ledColor = Color.RED;
        this._ledType = LedType.STANDARD;
        this._titleColor = DARK_COLOR;
        this._subTitleColor = DARK_COLOR;
        this._unitColor = DARK_COLOR;
        this._valueColor = DARK_COLOR;
        this._thresholdColor = Color.CRIMSON;
        this._checkSectionsForValue = false;
        this._checkAreasForValue = false;
        this._checkThreshold = false;
        this._innerShadowEnabled = false;
        this._thresholdVisible = false;
        this._sectionsVisible = false;
        this._sectionsAlwaysVisible = false;
        this._sectionTextVisible = false;
        this._sectionIconsVisible = false;
        this._highlightSections = false;
        this._areasVisible = false;
        this._areaTextVisible = false;
        this._areaIconsVisible = false;
        this._highlightAreas = false;
        this._tickMarkSectionsVisible = false;
        this._tickLabelSectionsVisible = false;
        this._markersVisible = false;
        this._tickLabelsVisible = true;
        this._onlyFirstAndLastTickLabelVisible = false;
        this._majorTickMarksVisible = true;
        this._mediumTickMarksVisible = true;
        this._minorTickMarksVisible = true;
        this._tickMarkRingVisible = false;
        this._majorTickSpace = 10.0;
        this._minorTickSpace = 1.0;
        this._lcdVisible = false;
        this._lcdCrystalEnabled = false;
        this._ledVisible = false;
        this._ledOn = false;
        this._ledBlinking = false;
        this._orientation = Orientation.HORIZONTAL;
        this._gradientBarEnabled = false;
        this._customTickLabelsEnabled = false;
        this.customTickLabels = FXCollections.observableArrayList();
        this._customTickLabelFontSize = 18.0;
        this._interactive = false;
        this._buttonTooltipText = "";
        this._keepAspect = true;
        this.originalMinValue = -1.7976931348623157E308;
        this.originalMaxValue = Double.MAX_VALUE;
        this.originalThreshold = Double.MAX_VALUE;
        this.lastCall = Instant.now();
        this.timeline = new Timeline();
        this.timeline.setOnFinished(e -> {
            if (this.isReturnToZero() && (double)Double.compare(this.currentValue.get(), 0.0) != 0.0) {
                KeyValue KEY_VALUE2 = new KeyValue((WritableValue)this.value, (Object)0, Interpolator.SPLINE((double)0.5, (double)0.4, (double)0.4, (double)1.0));
                KeyFrame KEY_FRAME2 = new KeyFrame(Duration.millis((double)((long)(0.8 * (double)this.getAnimationDuration()))), new KeyValue[]{KEY_VALUE2});
                this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{KEY_FRAME2});
                this.timeline.play();
            }
            this.fireUpdateEvent(this.FINISHED_EVENT);
        });
    }

    private void registerListeners() {
        this.disabledProperty().addListener(o -> this.setOpacity(this.isDisabled() ? 0.4 : 1.0));
    }

    public double getValue() {
        return this.value.get();
    }

    public void setValue(double VALUE) {
        this.value.set(VALUE);
    }

    public DoubleProperty valueProperty() {
        return this.value;
    }

    public double getCurrentValue() {
        return this.currentValue.get();
    }

    public ReadOnlyDoubleProperty currentValueProperty() {
        return this.currentValue;
    }

    public double getOldValue() {
        return this.oldValue.get();
    }

    public ReadOnlyDoubleProperty oldValueProperty() {
        return this.oldValue;
    }

    public double getFormerValue() {
        return this.formerValue.get();
    }

    public ReadOnlyDoubleProperty formerValueProperty() {
        return this.formerValue;
    }

    public double getMinValue() {
        return null == this.minValue ? this._minValue : this.minValue.get();
    }

    public void setMinValue(double VALUE) {
        if (null == this.minValue) {
            if (VALUE > this.getMaxValue()) {
                this.setMaxValue(VALUE);
            }
            this._minValue = Helper.clamp(-1.7976931348623157E308, this.getMaxValue(), VALUE);
            this.setRange(this.getMaxValue() - this._minValue);
            if (Double.compare(this.originalMinValue, -1.7976931348623157E308) == 0) {
                this.originalMinValue = this._minValue;
            }
            if (this.isStartFromZero() && this._minValue < 0.0) {
                this.setValue(0.0);
            }
            if (Double.compare(this.originalThreshold, this.getThreshold()) < 0) {
                this.setThreshold(Helper.clamp(this._minValue, this.getMaxValue(), this.originalThreshold));
            }
            this.fireUpdateEvent(this.RECALC_EVENT);
            this.setValue(Helper.clamp(this.getMinValue(), this.getMaxValue(), this.getValue()));
        } else {
            this.minValue.set(VALUE);
        }
    }

    public DoubleProperty minValueProperty() {
        if (null == this.minValue) {
            this.minValue = new DoublePropertyBase(this._minValue){

                protected void invalidated() {
                    double VALUE = this.get();
                    if (VALUE > Gauge.this.getMaxValue()) {
                        Gauge.this.setMaxValue(VALUE);
                    }
                    Gauge.this.setRange(Gauge.this.getMaxValue() - VALUE);
                    if (Double.compare(Gauge.this.originalMinValue, -1.7976931348623157E308) == 0) {
                        Gauge.this.originalMinValue = VALUE;
                    }
                    if (Gauge.this.isStartFromZero() && Gauge.this._minValue < 0.0) {
                        Gauge.this.setValue(0.0);
                    }
                    if (Double.compare(Gauge.this.originalThreshold, Gauge.this.getThreshold()) < 0) {
                        Gauge.this.setThreshold(Helper.clamp(VALUE, Gauge.this.getMaxValue(), Gauge.this.originalThreshold));
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.RECALC_EVENT);
                    Gauge.this.setValue(Helper.clamp(Gauge.this.getMinValue(), Gauge.this.getMaxValue(), Gauge.this.getValue()));
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "minValue";
                }
            };
        }
        return this.minValue;
    }

    public double getMaxValue() {
        return null == this.maxValue ? this._maxValue : this.maxValue.get();
    }

    public void setMaxValue(double VALUE) {
        if (null == this.maxValue) {
            if (VALUE < this.getMinValue()) {
                this.setMinValue(VALUE);
            }
            this._maxValue = Helper.clamp(this.getMinValue(), Double.MAX_VALUE, VALUE);
            this.setRange(this._maxValue - this.getMinValue());
            if (Double.compare(this.originalMaxValue, Double.MAX_VALUE) == 0) {
                this.originalMaxValue = this._maxValue;
            }
            if (Double.compare(this.originalThreshold, this.getThreshold()) > 0) {
                this.setThreshold(Helper.clamp(this.getMinValue(), this._maxValue, this.originalThreshold));
            }
            this.fireUpdateEvent(this.RECALC_EVENT);
            this.setValue(Helper.clamp(this.getMinValue(), this.getMaxValue(), this.getValue()));
        } else {
            this.maxValue.set(VALUE);
        }
    }

    public DoubleProperty maxValueProperty() {
        if (null == this.maxValue) {
            this.maxValue = new DoublePropertyBase(this._maxValue){

                protected void invalidated() {
                    double VALUE = this.get();
                    if (VALUE < Gauge.this.getMinValue()) {
                        Gauge.this.setMinValue(VALUE);
                    }
                    Gauge.this.setRange(VALUE - Gauge.this.getMinValue());
                    if (Double.compare(Gauge.this.originalMaxValue, Double.MAX_VALUE) == 0) {
                        Gauge.this.originalMaxValue = VALUE;
                    }
                    if (Double.compare(Gauge.this.originalThreshold, Gauge.this.getThreshold()) > 0) {
                        Gauge.this.setThreshold(Helper.clamp(Gauge.this.getMinValue(), VALUE, Gauge.this.originalThreshold));
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.RECALC_EVENT);
                    Gauge.this.setValue(Helper.clamp(Gauge.this.getMinValue(), Gauge.this.getMaxValue(), Gauge.this.getValue()));
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "maxValue";
                }
            };
        }
        return this.maxValue;
    }

    public double getRange() {
        return null == this.range ? this._range : this.range.get();
    }

    private void setRange(double RANGE) {
        if (null == this.range) {
            this._range = RANGE;
            this.setAngleStep(this.getAngleRange() / RANGE);
        } else {
            this.range.set(RANGE);
        }
    }

    public ReadOnlyDoubleProperty rangeProperty() {
        if (null == this.range) {
            this.range = new DoublePropertyBase(this.getMaxValue() - this.getMinValue()){

                protected void invalidated() {
                    Gauge.this.setAngleStep(Gauge.this.getAngleRange() / this.get());
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "range";
                }
            };
        }
        return this.range;
    }

    public double getThreshold() {
        return null == this.threshold ? this._threshold : this.threshold.get();
    }

    public void setThreshold(double THRESHOLD) {
        this.originalThreshold = THRESHOLD;
        if (null == this.threshold) {
            this._threshold = Helper.clamp(this.getMinValue(), this.getMaxValue(), THRESHOLD);
            this.fireUpdateEvent(this.RESIZE_EVENT);
        } else {
            this.threshold.set(THRESHOLD);
        }
    }

    public DoubleProperty tresholdProperty() {
        if (null == this.threshold) {
            this.threshold = new DoublePropertyBase(this._threshold){

                protected void invalidated() {
                    double THRESHOLD = this.get();
                    if (THRESHOLD < Gauge.this.getMinValue() || THRESHOLD > Gauge.this.getMaxValue()) {
                        this.set(Helper.clamp(Gauge.this.getMinValue(), Gauge.this.getMaxValue(), THRESHOLD));
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.RESIZE_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "threshold";
                }
            };
        }
        return this.threshold;
    }

    public String getTitle() {
        return null == this.title ? this._title : (String)this.title.get();
    }

    public void setTitle(String TITLE) {
        if (null == this.title) {
            this._title = TITLE;
            this.fireUpdateEvent(this.VISIBILITY_EVENT);
        } else {
            this.title.set((Object)TITLE);
        }
    }

    public StringProperty titleProperty() {
        if (null == this.title) {
            this.title = new StringPropertyBase(this._title){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.VISIBILITY_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "title";
                }
            };
            this._title = null;
        }
        return this.title;
    }

    public String getSubTitle() {
        return null == this.subTitle ? this._subTitle : (String)this.subTitle.get();
    }

    public void setSubTitle(String SUBTITLE) {
        if (null == this.subTitle) {
            this._subTitle = SUBTITLE;
            this.fireUpdateEvent(this.VISIBILITY_EVENT);
        } else {
            this.subTitle.set((Object)SUBTITLE);
        }
    }

    public StringProperty subTitleProperty() {
        if (null == this.subTitle) {
            this.subTitle = new StringPropertyBase(this._subTitle){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.VISIBILITY_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "subTitle";
                }
            };
            this._subTitle = null;
        }
        return this.subTitle;
    }

    public String getUnit() {
        return null == this.unit ? this._unit : (String)this.unit.get();
    }

    public void setUnit(String UNIT) {
        if (null == this.unit) {
            this._unit = UNIT;
            this.fireUpdateEvent(this.VISIBILITY_EVENT);
        } else {
            this.unit.set((Object)UNIT);
        }
    }

    public StringProperty unitProperty() {
        if (null == this.unit) {
            this.unit = new StringPropertyBase(this._unit){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.VISIBILITY_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "unit";
                }
            };
            this._unit = null;
        }
        return this.unit;
    }

    public ObservableList<Section> getSections() {
        return this.sections;
    }

    public void setSections(List<Section> SECTIONS) {
        this.sections.setAll(SECTIONS);
        Collections.sort(this.sections, new SectionComparator());
        this.fireUpdateEvent(this.SECTION_EVENT);
    }

    public void setSections(Section ... SECTIONS) {
        this.setSections(Arrays.asList(SECTIONS));
    }

    public void addSection(Section SECTION) {
        if (null == SECTION) {
            return;
        }
        this.sections.add((Object)SECTION);
        Collections.sort(this.sections, new SectionComparator());
        this.fireUpdateEvent(this.SECTION_EVENT);
    }

    public void removeSection(Section SECTION) {
        if (null == SECTION) {
            return;
        }
        this.sections.remove((Object)SECTION);
        Collections.sort(this.sections, new SectionComparator());
        this.fireUpdateEvent(this.SECTION_EVENT);
    }

    public void clearSections() {
        this.sections.clear();
        this.fireUpdateEvent(this.SECTION_EVENT);
    }

    public ObservableList<Section> getAreas() {
        return this.areas;
    }

    public void setAreas(List<Section> AREAS) {
        this.areas.setAll(AREAS);
        Collections.sort(this.areas, new SectionComparator());
        this.fireUpdateEvent(this.SECTION_EVENT);
    }

    public void setAreas(Section ... AREAS) {
        this.setAreas(Arrays.asList(AREAS));
    }

    public void addArea(Section AREA) {
        if (null == AREA) {
            return;
        }
        this.areas.add((Object)AREA);
        Collections.sort(this.areas, new SectionComparator());
        this.fireUpdateEvent(this.SECTION_EVENT);
    }

    public void removeArea(Section AREA) {
        if (null == AREA) {
            return;
        }
        this.areas.remove((Object)AREA);
        Collections.sort(this.areas, new SectionComparator());
        this.fireUpdateEvent(this.SECTION_EVENT);
    }

    public void clearAreas() {
        this.areas.clear();
        this.fireUpdateEvent(this.SECTION_EVENT);
    }

    public ObservableList<Section> getTickMarkSections() {
        return this.tickMarkSections;
    }

    public void setTickMarkSections(List<Section> SECTIONS) {
        this.tickMarkSections.setAll(SECTIONS);
        Collections.sort(this.tickMarkSections, new SectionComparator());
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public void setTickMarkSections(Section ... SECTIONS) {
        this.setTickMarkSections(Arrays.asList(SECTIONS));
    }

    public void addTickMarkSection(Section SECTION) {
        if (null == SECTION) {
            return;
        }
        this.tickMarkSections.add((Object)SECTION);
        Collections.sort(this.tickMarkSections, new SectionComparator());
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public void removeTickMarkSection(Section SECTION) {
        if (null == SECTION) {
            return;
        }
        this.tickMarkSections.remove((Object)SECTION);
        Collections.sort(this.tickMarkSections, new SectionComparator());
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public void clearTickMarkSections() {
        this.tickMarkSections.clear();
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public ObservableList<Section> getTickLabelSections() {
        return this.tickLabelSections;
    }

    public void setTickLabelSections(List<Section> SECTIONS) {
        this.tickLabelSections.setAll(SECTIONS);
        Collections.sort(this.tickLabelSections, new SectionComparator());
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public void setTickLabelSections(Section ... SECTIONS) {
        this.setTickLabelSections(Arrays.asList(SECTIONS));
    }

    public void addTickLabelSection(Section SECTION) {
        if (null == SECTION) {
            return;
        }
        this.tickLabelSections.add((Object)SECTION);
        Collections.sort(this.tickLabelSections, new SectionComparator());
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public void removeTickLabelSection(Section SECTION) {
        if (null == SECTION) {
            return;
        }
        this.tickLabelSections.remove((Object)SECTION);
        Collections.sort(this.tickLabelSections, new SectionComparator());
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public void clearTickLabelSections() {
        this.tickLabelSections.clear();
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public ObservableList<Marker> getMarkers() {
        return this.markers;
    }

    public void setMarkers(List<Marker> MARKERS) {
        this.markers.setAll(MARKERS);
        Collections.sort(this.markers, new MarkerComparator());
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public void setMarkers(Marker ... MARKERS) {
        this.setMarkers(Arrays.asList(MARKERS));
    }

    public void addMarker(Marker MARKER) {
        if (null == MARKER) {
            return;
        }
        this.markers.add((Object)MARKER);
        Collections.sort(this.markers, new MarkerComparator());
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public void removeMarker(Marker MARKER) {
        if (null == MARKER) {
            return;
        }
        this.markers.remove((Object)MARKER);
        Collections.sort(this.markers, new MarkerComparator());
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public void clearMarkers() {
        this.markers.clear();
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public void setForegroundBaseColor(Color COLOR) {
        if (null == this.titleColor) {
            this._titleColor = COLOR;
        } else {
            this.titleColor.set((Object)COLOR);
        }
        if (null == this.subTitleColor) {
            this._subTitleColor = COLOR;
        } else {
            this.subTitleColor.set((Object)COLOR);
        }
        if (null == this.unitColor) {
            this._unitColor = COLOR;
        } else {
            this.unitColor.set((Object)COLOR);
        }
        if (null == this.valueColor) {
            this._valueColor = COLOR;
        } else {
            this.valueColor.set((Object)COLOR);
        }
        if (null == this.tickLabelColor) {
            this._tickLabelColor = COLOR;
        } else {
            this.tickLabelColor.set((Object)COLOR);
        }
        if (null == this.zeroColor) {
            this._zeroColor = COLOR;
        } else {
            this.zeroColor.set((Object)COLOR);
        }
        if (null == this.tickMarkColor) {
            this._tickMarkColor = COLOR;
        } else {
            this.tickMarkColor.set((Object)COLOR);
        }
        if (null == this.majorTickMarkColor) {
            this._majorTickMarkColor = COLOR;
        } else {
            this.majorTickMarkColor.set((Object)COLOR);
        }
        if (null == this.mediumTickMarkColor) {
            this._mediumTickMarkColor = COLOR;
        } else {
            this.mediumTickMarkColor.set((Object)COLOR);
        }
        if (null == this.minorTickMarkColor) {
            this._minorTickMarkColor = COLOR;
        } else {
            this.minorTickMarkColor.set((Object)COLOR);
        }
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public boolean isStartFromZero() {
        return null == this.startFromZero ? this._startFromZero : this.startFromZero.get();
    }

    public void setStartFromZero(boolean IS_TRUE) {
        if (null == this.startFromZero) {
            this._startFromZero = IS_TRUE;
            this.setValue(IS_TRUE && this.getMinValue() < 0.0 ? 0.0 : this.getMinValue());
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.startFromZero.set(IS_TRUE);
        }
    }

    public BooleanProperty startFromZeroProperty() {
        if (null == this.startFromZero) {
            this.startFromZero = new BooleanPropertyBase(this._startFromZero){

                protected void invalidated() {
                    Gauge.this.setValue(this.get() && Gauge.this.getMinValue() < 0.0 ? 0.0 : Gauge.this.getMinValue());
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "startFromZero";
                }
            };
        }
        return this.startFromZero;
    }

    public boolean isReturnToZero() {
        return null == this.returnToZero ? this._returnToZero : this.returnToZero.get();
    }

    public void setReturnToZero(boolean IS_TRUE) {
        if (null == this.returnToZero) {
            this._returnToZero = Double.compare(this.getMinValue(), 0.0) <= 0 ? IS_TRUE : false;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.returnToZero.set(IS_TRUE);
        }
    }

    public BooleanProperty returnToZeroProperty() {
        if (null == this.returnToZero) {
            this.returnToZero = new BooleanPropertyBase(this._returnToZero){

                protected void invalidated() {
                    if (Double.compare(Gauge.this.getMaxValue(), 0.0) > 0) {
                        this.set(false);
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "returnToZero";
                }
            };
        }
        return this.returnToZero;
    }

    public Color getZeroColor() {
        return null == this.zeroColor ? this._zeroColor : (Color)this.zeroColor.get();
    }

    public void setZeroColor(Color COLOR) {
        if (null == this.zeroColor) {
            this._zeroColor = COLOR;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.zeroColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> zeroColorProperty() {
        if (null == this.zeroColor) {
            this.zeroColor = new ObjectPropertyBase<Color>(this._zeroColor){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "zeroColor";
                }
            };
            this._zeroColor = null;
        }
        return this.zeroColor;
    }

    public double getMinMeasuredValue() {
        return null == this.minMeasuredValue ? this._minMeasuredValue : this.minMeasuredValue.get();
    }

    public void setMinMeasuredValue(double MIN_MEASURED_VALUE) {
        if (null == this.minMeasuredValue) {
            this._minMeasuredValue = MIN_MEASURED_VALUE;
        } else {
            this.minMeasuredValue.set(MIN_MEASURED_VALUE);
        }
    }

    public ReadOnlyDoubleProperty minMeasuredValueProperty() {
        if (null == this.minMeasuredValue) {
            this.minMeasuredValue = new SimpleDoubleProperty((Object)this, "minMeasuredValue", this._minMeasuredValue);
        }
        return this.minMeasuredValue;
    }

    public double getMaxMeasuredValue() {
        return null == this.maxMeasuredValue ? this._maxMeasuredValue : this.maxMeasuredValue.get();
    }

    public void setMaxMeasuredValue(double MAX_MEASURED_VALUE) {
        if (null == this.maxMeasuredValue) {
            this._maxMeasuredValue = MAX_MEASURED_VALUE;
        } else {
            this.maxMeasuredValue.set(MAX_MEASURED_VALUE);
        }
    }

    public ReadOnlyDoubleProperty maxMeasuredValueProperty() {
        if (null == this.maxMeasuredValue) {
            this.maxMeasuredValue = new SimpleDoubleProperty((Object)this, "maxMeasuredValue", this._maxMeasuredValue);
        }
        return this.maxMeasuredValue;
    }

    public void resetMeasuredValues() {
        this.setMinMeasuredValue(this.getValue());
        this.setMaxMeasuredValue(this.getValue());
    }

    public boolean isMinMeasuredValueVisible() {
        return null == this.minMeasuredValueVisible ? this._minMeasuredValueVisible : this.minMeasuredValueVisible.get();
    }

    public void setMinMeasuredValueVisible(boolean VISIBLE) {
        if (null == this.minMeasuredValueVisible) {
            this._minMeasuredValueVisible = VISIBLE;
            this.fireUpdateEvent(this.VISIBILITY_EVENT);
        } else {
            this.minMeasuredValueVisible.set(VISIBLE);
        }
    }

    public BooleanProperty minMeasuredValueVisibleProperty() {
        if (null == this.minMeasuredValueVisible) {
            this.minMeasuredValueVisible = new BooleanPropertyBase(this._minMeasuredValueVisible){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.VISIBILITY_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "minMeasuredValueVisible";
                }
            };
        }
        return this.minMeasuredValueVisible;
    }

    public boolean isMaxMeasuredValueVisible() {
        return null == this.maxMeasuredValueVisible ? this._maxMeasuredValueVisible : this.maxMeasuredValueVisible.get();
    }

    public void setMaxMeasuredValueVisible(boolean VISIBLE) {
        if (null == this.maxMeasuredValueVisible) {
            this._maxMeasuredValueVisible = VISIBLE;
            this.fireUpdateEvent(this.VISIBILITY_EVENT);
        } else {
            this.maxMeasuredValueVisible.set(VISIBLE);
        }
    }

    public BooleanProperty maxMeasuredValueVisibleProperty() {
        if (null == this.maxMeasuredValueVisible) {
            this.maxMeasuredValueVisible = new BooleanPropertyBase(this._maxMeasuredValueVisible){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.VISIBILITY_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "maxMeasuredValueVisible";
                }
            };
        }
        return this.maxMeasuredValueVisible;
    }

    public boolean isOldValueVisible() {
        return null == this.oldValueVisible ? this._oldValueVisible : this.oldValueVisible.get();
    }

    public void setOldValueVisible(boolean VISIBLE) {
        if (null == this.oldValueVisible) {
            this._oldValueVisible = VISIBLE;
            this.fireUpdateEvent(this.VISIBILITY_EVENT);
        } else {
            this.oldValueVisible.set(VISIBLE);
        }
    }

    public BooleanProperty oldValueVisibleProperty() {
        if (null == this.oldValueVisible) {
            this.oldValueVisible = new BooleanPropertyBase(this._oldValueVisible){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.VISIBILITY_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "oldValueVisible";
                }
            };
        }
        return this.oldValueVisible;
    }

    public boolean isValueVisible() {
        return null == this.valueVisible ? this._valueVisible : this.valueVisible.get();
    }

    public void setValueVisible(boolean VISIBLE) {
        if (null == this.valueVisible) {
            this._valueVisible = VISIBLE;
            this.fireUpdateEvent(this.VISIBILITY_EVENT);
        } else {
            this.valueVisible.set(VISIBLE);
        }
    }

    public BooleanProperty valueVisibleProperty() {
        if (null == this.valueVisible) {
            this.valueVisible = new BooleanPropertyBase(this._valueVisible){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.VISIBILITY_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "valueVisible";
                }
            };
        }
        return this.valueVisible;
    }

    public Paint getBackgroundPaint() {
        return null == this.backgroundPaint ? this._backgroundPaint : (Paint)this.backgroundPaint.get();
    }

    public void setBackgroundPaint(Paint PAINT) {
        if (null == this.backgroundPaint) {
            this._backgroundPaint = PAINT;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.backgroundPaint.set((Object)PAINT);
        }
    }

    public ObjectProperty<Paint> backgroundPaintProperty() {
        if (null == this.backgroundPaint) {
            this.backgroundPaint = new ObjectPropertyBase<Paint>(this._backgroundPaint){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "backgroundPaint";
                }
            };
            this._backgroundPaint = null;
        }
        return this.backgroundPaint;
    }

    public Paint getBorderPaint() {
        return null == this.borderPaint ? this._borderPaint : (Paint)this.borderPaint.get();
    }

    public void setBorderPaint(Paint PAINT) {
        if (null == this.borderPaint) {
            this._borderPaint = PAINT;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.borderPaint.set((Object)PAINT);
        }
    }

    public ObjectProperty<Paint> borderPaintProperty() {
        if (null == this.borderPaint) {
            this.borderPaint = new ObjectPropertyBase<Paint>(this._borderPaint){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "borderPaint";
                }
            };
            this._borderPaint = null;
        }
        return this.borderPaint;
    }

    public double getBorderWidth() {
        return null == this.borderWidth ? this._borderWidth : this.borderWidth.get();
    }

    public void setBorderWidth(double WIDTH) {
        if (null == this.borderWidth) {
            this._borderWidth = Helper.clamp(0.0, 50.0, WIDTH);
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.borderWidth.set(WIDTH);
        }
    }

    public DoubleProperty borderWidthProperty() {
        if (null == this.borderWidth) {
            this.borderWidth = new DoublePropertyBase(this._borderWidth){

                protected void invalidated() {
                    double WIDTH = this.get();
                    if (WIDTH < 0.0 || WIDTH > 50.0) {
                        this.set(Helper.clamp(0.0, 50.0, WIDTH));
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "borderWidth";
                }
            };
        }
        return this.borderWidth;
    }

    public Paint getForegroundPaint() {
        return null == this.foregroundPaint ? this._foregroundPaint : (Paint)this.foregroundPaint.get();
    }

    public void setForegroundPaint(Paint PAINT) {
        if (null == this.foregroundPaint) {
            this._foregroundPaint = PAINT;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.foregroundPaint.set((Object)PAINT);
        }
    }

    public ObjectProperty<Paint> foregroundPaintProperty() {
        if (null == this.foregroundPaint) {
            this.foregroundPaint = new ObjectPropertyBase<Paint>(this._foregroundPaint){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "foregroundPaint";
                }
            };
            this._foregroundPaint = null;
        }
        return this.foregroundPaint;
    }

    public Color getKnobColor() {
        return null == this.knobColor ? this._knobColor : (Color)this.knobColor.get();
    }

    public void setKnobColor(Color COLOR) {
        if (null == this.knobColor) {
            this._knobColor = COLOR;
            this.fireUpdateEvent(this.RESIZE_EVENT);
        } else {
            this.knobColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> knobColorProperty() {
        if (null == this.knobColor) {
            this.knobColor = new ObjectPropertyBase<Color>(this._knobColor){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.RESIZE_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "knobColor";
                }
            };
            this._knobColor = null;
        }
        return this.knobColor;
    }

    public KnobType getKnobType() {
        return null == this.knobType ? this._knobType : (KnobType)((Object)this.knobType.get());
    }

    public void setKnobType(KnobType TYPE) {
        if (null == this.knobType) {
            this._knobType = null == TYPE ? KnobType.STANDARD : TYPE;
            this.fireUpdateEvent(this.RESIZE_EVENT);
        } else {
            this.knobType.set((Object)TYPE);
        }
    }

    public ObjectProperty<KnobType> knobTypeProperty() {
        if (null == this.knobType) {
            this.knobType = new ObjectPropertyBase<KnobType>(this._knobType){

                protected void invalidated() {
                    if (null == this.get()) {
                        this.set((Object)KnobType.STANDARD);
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.RESIZE_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "knobType";
                }
            };
            this._knobType = null;
        }
        return this.knobType;
    }

    public Pos getKnobPosition() {
        return null == this.knobPosition ? this._knobPosition : (Pos)this.knobPosition.get();
    }

    public void setKnobPosition(Pos POSITION) {
        if (null == this.knobPosition) {
            this._knobPosition = POSITION;
            this.fireUpdateEvent(this.RESIZE_EVENT);
        } else {
            this.knobPosition.set((Object)POSITION);
        }
    }

    public ObjectProperty<Pos> knobPositionProperty() {
        if (null == this.knobPosition) {
            this.knobPosition = new ObjectPropertyBase<Pos>(this._knobPosition){

                protected void invalidated() {
                    Pos POSITION = (Pos)this.get();
                    if (null == POSITION) {
                        switch (Gauge.this.skinType) {
                            case HORIZONTAL: {
                                super.set((Object)Pos.CENTER_RIGHT);
                                break;
                            }
                            case VERTICAL: {
                                super.set((Object)Pos.BOTTOM_CENTER);
                                break;
                            }
                            case QUARTER: {
                                super.set((Object)Pos.BOTTOM_RIGHT);
                                break;
                            }
                            default: {
                                super.set((Object)Pos.CENTER);
                            }
                        }
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.RESIZE_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "knobPosition";
                }
            };
            this._knobPosition = null;
        }
        return this.knobPosition;
    }

    public boolean isKnobVisible() {
        return null == this.knobVisible ? this._knobVisible : this.knobVisible.get();
    }

    public void setKnobVisible(boolean VISIBLE) {
        if (null == this.knobVisible) {
            this._knobVisible = VISIBLE;
            this.fireUpdateEvent(this.VISIBILITY_EVENT);
        } else {
            this.knobVisible.set(VISIBLE);
        }
    }

    public BooleanProperty knobVisibleProperty() {
        if (null == this.knobVisible) {
            this.knobVisible = new BooleanPropertyBase(this._knobVisible){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.VISIBILITY_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "knobVisible";
                }
            };
        }
        return this.knobVisible;
    }

    public boolean isAnimated() {
        return null == this.animated ? this._animated : this.animated.get();
    }

    public void setAnimated(boolean ANIMATED) {
        if (null == this.animated) {
            this._animated = ANIMATED;
        } else {
            this.animated.set(ANIMATED);
        }
    }

    public BooleanProperty animatedProperty() {
        if (null == this.animated) {
            this.animated = new SimpleBooleanProperty((Object)this, "animated", this._animated);
        }
        return this.animated;
    }

    public long getAnimationDuration() {
        return this.animationDuration;
    }

    public void setAnimationDuration(long ANIMATION_DURATION) {
        this.animationDuration = Helper.clamp(10L, 10000L, ANIMATION_DURATION);
    }

    public double getStartAngle() {
        return null == this.startAngle ? this._startAngle : this.startAngle.get();
    }

    public void setStartAngle(double ANGLE) {
        if (null == this.startAngle) {
            this._startAngle = Helper.clamp(0.0, 360.0, ANGLE);
            this.fireUpdateEvent(this.RECALC_EVENT);
        } else {
            this.startAngle.set(ANGLE);
        }
    }

    public DoubleProperty startAngleProperty() {
        if (null == this.startAngle) {
            this.startAngle = new DoublePropertyBase(this._startAngle){

                protected void invalidated() {
                    double ANGLE = this.get();
                    if (ANGLE < 0.0 || ANGLE > 360.0) {
                        this.set(Helper.clamp(0.0, 360.0, ANGLE));
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.RECALC_EVENT);
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "startAngle";
                }
            };
        }
        return this.startAngle;
    }

    public double getAngleRange() {
        return null == this.angleRange ? this._angleRange : this.angleRange.get();
    }

    public void setAngleRange(double RANGE) {
        double tmpAngleRange = Helper.clamp(0.0, 360.0, RANGE);
        if (null == this.angleRange) {
            this._angleRange = tmpAngleRange;
            this.setAngleStep(tmpAngleRange / this.getRange());
            this.fireUpdateEvent(this.RECALC_EVENT);
        } else {
            this.angleRange.set(tmpAngleRange);
        }
    }

    public DoubleProperty angleRangeProperty() {
        if (null == this.angleRange) {
            this.angleRange = new DoublePropertyBase(this._angleRange){

                protected void invalidated() {
                    double ANGLE_RANGE = this.get();
                    if (ANGLE_RANGE < 0.0 || ANGLE_RANGE > 360.0) {
                        this.set(Helper.clamp(0.0, 360.0, ANGLE_RANGE));
                    }
                    Gauge.this.setAngleStep(this.get() / Gauge.this.getRange());
                    Gauge.this.fireUpdateEvent(Gauge.this.RECALC_EVENT);
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "angleRange";
                }
            };
        }
        return this.angleRange;
    }

    public double getAngleStep() {
        return null == this.angleStep ? this._angleStep : this.angleStep.get();
    }

    private void setAngleStep(double STEP) {
        if (null == this.angleStep) {
            this._angleStep = STEP;
        } else {
            this.angleStep.set(STEP);
        }
    }

    public ReadOnlyDoubleProperty angleStepProperty() {
        if (null == this.angleStep) {
            this.angleStep = new SimpleDoubleProperty((Object)this, "angleStep", this._angleStep);
        }
        return this.angleStep;
    }

    public boolean isAutoScale() {
        return null == this.autoScale ? this._autoScale : this.autoScale.get();
    }

    public void setAutoScale(boolean AUTO_SCALE) {
        if (null == this.autoScale) {
            this._autoScale = AUTO_SCALE;
            if (this._autoScale) {
                this.calcAutoScale();
            } else {
                this.setMinValue(this.originalMinValue);
                this.setMaxValue(this.originalMaxValue);
            }
            this.fireUpdateEvent(this.RECALC_EVENT);
        } else {
            this.autoScale.set(AUTO_SCALE);
        }
    }

    public BooleanProperty autoScaleProperty() {
        if (null == this.autoScale) {
            this.autoScale = new BooleanPropertyBase(this._autoScale){

                protected void invalidated() {
                    if (this.get()) {
                        Gauge.this.calcAutoScale();
                    } else {
                        Gauge.this.setMinValue(Gauge.this.originalMinValue);
                        Gauge.this.setMaxValue(Gauge.this.originalMaxValue);
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.RECALC_EVENT);
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "autoScale";
                }
            };
        }
        return this.autoScale;
    }

    public boolean isShadowsEnabled() {
        return null == this.shadowsEnabled ? this._shadowsEnabled : this.shadowsEnabled.get();
    }

    public void setShadowsEnabled(boolean ENABLED) {
        if (null == this.shadowsEnabled) {
            this._shadowsEnabled = ENABLED;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.shadowsEnabled.set(ENABLED);
        }
    }

    public BooleanProperty shadowsEnabledProperty() {
        if (null == this.shadowsEnabled) {
            this.shadowsEnabled = new BooleanPropertyBase(this._shadowsEnabled){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "shadowsEnabled";
                }
            };
        }
        return this.shadowsEnabled;
    }

    public boolean isBarEffectEnabled() {
        return null == this.barEffectEnabled ? this._barEffectEnabled : this.barEffectEnabled.get();
    }

    public void setBarEffectEnabled(boolean ENABLED) {
        if (null == this.barEffectEnabled) {
            this._barEffectEnabled = ENABLED;
        } else {
            this.barEffectEnabled.set(ENABLED);
        }
    }

    public BooleanProperty barEffectEnabledProperty() {
        if (null == this.barEffectEnabled) {
            this.barEffectEnabled = new BooleanPropertyBase(this._barEffectEnabled){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.VISIBILITY_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "barEffectEnabled";
                }
            };
        }
        return this.barEffectEnabled;
    }

    public ScaleDirection getScaleDirection() {
        return null == this.scaleDirection ? this._scaleDirection : (ScaleDirection)((Object)this.scaleDirection.get());
    }

    public void setScaleDirection(ScaleDirection DIRECTION) {
        if (null == this.scaleDirection) {
            this._scaleDirection = null == DIRECTION ? ScaleDirection.CLOCKWISE : DIRECTION;
            this.fireUpdateEvent(this.RECALC_EVENT);
        } else {
            this.scaleDirection.set((Object)DIRECTION);
        }
    }

    public ObjectProperty<ScaleDirection> scaleDirectionProperty() {
        if (null == this.scaleDirection) {
            this.scaleDirection = new ObjectPropertyBase<ScaleDirection>(this._scaleDirection){

                protected void invalidated() {
                    if (null == this.get()) {
                        this.set((Object)ScaleDirection.CLOCKWISE);
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.RECALC_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "scaleDirection";
                }
            };
            this._scaleDirection = null;
        }
        return this.scaleDirection;
    }

    public TickLabelLocation getTickLabelLocation() {
        return null == this.tickLabelLocation ? this._tickLabelLocation : (TickLabelLocation)((Object)this.tickLabelLocation.get());
    }

    public void setTickLabelLocation(TickLabelLocation LOCATION) {
        if (null == this.tickLabelLocation) {
            this._tickLabelLocation = null == LOCATION ? TickLabelLocation.INSIDE : LOCATION;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.tickLabelLocation.set((Object)LOCATION);
        }
    }

    public ObjectProperty<TickLabelLocation> tickLabelLocationProperty() {
        if (null == this.tickLabelLocation) {
            this.tickLabelLocation = new ObjectPropertyBase<TickLabelLocation>(this._tickLabelLocation){

                protected void invalidated() {
                    if (null == this.get()) {
                        this.set((Object)TickLabelLocation.INSIDE);
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "tickLabelLocation";
                }
            };
            this._tickLabelLocation = null;
        }
        return this.tickLabelLocation;
    }

    public TickLabelOrientation getTickLabelOrientation() {
        return null == this.tickLabelOrientation ? this._tickLabelOrientation : (TickLabelOrientation)((Object)this.tickLabelOrientation.get());
    }

    public void setTickLabelOrientation(TickLabelOrientation ORIENTATION) {
        if (null == this.tickLabelOrientation) {
            this._tickLabelOrientation = null == ORIENTATION ? TickLabelOrientation.HORIZONTAL : ORIENTATION;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.tickLabelOrientation.set((Object)ORIENTATION);
        }
    }

    public ObjectProperty<TickLabelOrientation> tickLabelOrientationProperty() {
        if (null == this.tickLabelOrientation) {
            this.tickLabelOrientation = new ObjectPropertyBase<TickLabelOrientation>(this._tickLabelOrientation){

                protected void invalidated() {
                    if (null == this.get()) {
                        this.set((Object)TickLabelOrientation.HORIZONTAL);
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "tickLabelOrientation";
                }
            };
            this._tickLabelOrientation = null;
        }
        return this.tickLabelOrientation;
    }

    public Color getTickLabelColor() {
        return null == this.tickLabelColor ? this._tickLabelColor : (Color)this.tickLabelColor.get();
    }

    public void setTickLabelColor(Color COLOR) {
        if (null == this.tickLabelColor) {
            this._tickLabelColor = COLOR;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.tickLabelColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> tickLabelColorProperty() {
        if (null == this.tickLabelColor) {
            this.tickLabelColor = new ObjectPropertyBase<Color>(this._tickLabelColor){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "tickLabelColor";
                }
            };
            this._tickLabelColor = null;
        }
        return this.tickLabelColor;
    }

    public Color getTickMarkColor() {
        return null == this.tickMarkColor ? this._tickMarkColor : (Color)this.tickMarkColor.get();
    }

    public void setTickMarkColor(Color COLOR) {
        if (null == this.tickMarkColor) {
            this._tickMarkColor = COLOR;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.tickMarkColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> tickMarkColorProperty() {
        if (null == this.tickMarkColor) {
            this.tickMarkColor = new ObjectPropertyBase<Color>(this._tickMarkColor){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "tickMarkColor";
                }
            };
            this._tickMarkColor = null;
        }
        return this.tickMarkColor;
    }

    public Color getMajorTickMarkColor() {
        return null == this.majorTickMarkColor ? this._majorTickMarkColor : (Color)this.majorTickMarkColor.get();
    }

    public void setMajorTickMarkColor(Color COLOR) {
        if (null == this.majorTickMarkColor) {
            this._majorTickMarkColor = COLOR;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.majorTickMarkColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> majorTickMarkColorProperty() {
        if (null == this.majorTickMarkColor) {
            this.majorTickMarkColor = new ObjectPropertyBase<Color>(this._majorTickMarkColor){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "majorTickMarkColor";
                }
            };
            this._majorTickMarkColor = null;
        }
        return this.majorTickMarkColor;
    }

    public double getMajorTickMarkLengthFactor() {
        return null == this.majorTickMarkLengthFactor ? this._majorTickMarkLengthFactor : this.majorTickMarkLengthFactor.get();
    }

    public void setMajorTickMarkLengthFactor(double FACTOR) {
        if (null == this.majorTickMarkLengthFactor) {
            this._majorTickMarkLengthFactor = Helper.clamp(0.0, 1.0, FACTOR);
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.majorTickMarkLengthFactor.set(FACTOR);
        }
    }

    public DoubleProperty majorTickMarkLengthFactorProperty() {
        if (null == this.majorTickMarkLengthFactor) {
            this.majorTickMarkLengthFactor = new DoublePropertyBase(this._majorTickMarkLengthFactor){

                protected void invalidated() {
                    double VALUE = this.get();
                    if (VALUE < 0.0 || VALUE > 1.0) {
                        this.set(Helper.clamp(0.0, 1.0, VALUE));
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "majorTickMarkLengthFactor";
                }
            };
        }
        return this.majorTickMarkLengthFactor;
    }

    public double getMajorTickMarkWidthFactor() {
        return null == this.majorTickMarkWidthFactor ? this._majorTickMarkWidthFactor : this.majorTickMarkWidthFactor.get();
    }

    public void setMajorTickMarkWidthFactor(double FACTOR) {
        if (null == this.majorTickMarkWidthFactor) {
            this._majorTickMarkWidthFactor = Helper.clamp(0.0, 1.0, FACTOR);
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.majorTickMarkWidthFactor.set(FACTOR);
        }
    }

    public DoubleProperty majorTickMarkWidthFactorProperty() {
        if (null == this.majorTickMarkWidthFactor) {
            this.majorTickMarkWidthFactor = new DoublePropertyBase(this._majorTickMarkWidthFactor){

                protected void invalidated() {
                    double VALUE = this.get();
                    if (VALUE < 0.0 || VALUE > 1.0) {
                        this.set(Helper.clamp(0.0, 1.0, VALUE));
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "majorTickMarkWidthFactor";
                }
            };
        }
        return this.majorTickMarkWidthFactor;
    }

    public Color getMediumTickMarkColor() {
        return null == this.mediumTickMarkColor ? this._mediumTickMarkColor : (Color)this.mediumTickMarkColor.get();
    }

    public void setMediumTickMarkColor(Color COLOR) {
        if (null == this.mediumTickMarkColor) {
            this._mediumTickMarkColor = COLOR;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.mediumTickMarkColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> mediumTickMarkColorProperty() {
        if (null == this.mediumTickMarkColor) {
            this.mediumTickMarkColor = new ObjectPropertyBase<Color>(this._mediumTickMarkColor){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "mediumTickMarkColor";
                }
            };
            this._mediumTickMarkColor = null;
        }
        return this.mediumTickMarkColor;
    }

    public double getMediumTickMarkLengthFactor() {
        return null == this.mediumTickMarkLengthFactor ? this._mediumTickMarkLengthFactor : this.mediumTickMarkLengthFactor.get();
    }

    public void setMediumTickMarkLengthFactor(double FACTOR) {
        if (null == this.mediumTickMarkLengthFactor) {
            this._mediumTickMarkLengthFactor = Helper.clamp(0.0, 1.0, FACTOR);
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.mediumTickMarkLengthFactor.set(FACTOR);
        }
    }

    public DoubleProperty mediumTickMarkLengthFactorProperty() {
        if (null == this.mediumTickMarkLengthFactor) {
            this.mediumTickMarkLengthFactor = new DoublePropertyBase(this._mediumTickMarkLengthFactor){

                protected void invalidated() {
                    double VALUE = this.get();
                    if (VALUE < 0.0 || VALUE > 1.0) {
                        this.set(Helper.clamp(0.0, 1.0, VALUE));
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "mediumTickMarkLengthFactor";
                }
            };
        }
        return this.mediumTickMarkLengthFactor;
    }

    public double getMediumTickMarkWidthFactor() {
        return null == this.mediumTickMarkWidthFactor ? this._mediumTickMarkWidthFactor : this.mediumTickMarkWidthFactor.get();
    }

    public void setMediumTickMarkWidthFactor(double FACTOR) {
        if (null == this.mediumTickMarkWidthFactor) {
            this._mediumTickMarkWidthFactor = Helper.clamp(0.0, 1.0, FACTOR);
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.mediumTickMarkWidthFactor.set(FACTOR);
        }
    }

    public DoubleProperty mediumTickMarkWidthFactorProperty() {
        if (null == this.mediumTickMarkWidthFactor) {
            this.mediumTickMarkWidthFactor = new DoublePropertyBase(this._mediumTickMarkWidthFactor){

                protected void invalidated() {
                    double VALUE = this.get();
                    if (VALUE < 0.0 || VALUE > 1.0) {
                        this.set(Helper.clamp(0.0, 1.0, VALUE));
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "mediumTickMarkWidthFactor";
                }
            };
        }
        return this.mediumTickMarkWidthFactor;
    }

    public Color getMinorTickMarkColor() {
        return null == this.minorTickMarkColor ? this._minorTickMarkColor : (Color)this.minorTickMarkColor.get();
    }

    public void setMinorTickMarkColor(Color COLOR) {
        if (null == this.minorTickMarkColor) {
            this._minorTickMarkColor = COLOR;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.minorTickMarkColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> minorTickMarkColorProperty() {
        if (null == this.minorTickMarkColor) {
            this.minorTickMarkColor = new ObjectPropertyBase<Color>(this._minorTickMarkColor){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "minorTickMarkColor";
                }
            };
            this._minorTickMarkColor = null;
        }
        return this.minorTickMarkColor;
    }

    public double getMinorTickMarkLengthFactor() {
        return null == this.minorTickMarkLengthFactor ? this._minorTickMarkLengthFactor : this.minorTickMarkLengthFactor.get();
    }

    public void setMinorTickMarkLengthFactor(double FACTOR) {
        if (null == this.minorTickMarkLengthFactor) {
            this._minorTickMarkLengthFactor = Helper.clamp(0.0, 1.0, FACTOR);
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.minorTickMarkLengthFactor.set(FACTOR);
        }
    }

    public DoubleProperty minorTickMarkLengthFactorProperty() {
        if (null == this.minorTickMarkLengthFactor) {
            this.minorTickMarkLengthFactor = new DoublePropertyBase(this._minorTickMarkLengthFactor){

                protected void invalidated() {
                    double VALUE = this.get();
                    if (VALUE < 0.0 || VALUE > 1.0) {
                        this.set(Helper.clamp(0.0, 1.0, VALUE));
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "minorTickMarkLengthFactor";
                }
            };
        }
        return this.minorTickMarkLengthFactor;
    }

    public double getMinorTickMarkWidthFactor() {
        return null == this.minorTickMarkWidthFactor ? this._minorTickMarkWidthFactor : this.minorTickMarkWidthFactor.get();
    }

    public void setMinorTickMarkWidthFactor(double FACTOR) {
        if (null == this.minorTickMarkWidthFactor) {
            this._minorTickMarkWidthFactor = Helper.clamp(0.0, 1.0, FACTOR);
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.minorTickMarkWidthFactor.set(FACTOR);
        }
    }

    public DoubleProperty minorTickMarkWidthFactorProperty() {
        if (null == this.minorTickMarkWidthFactor) {
            this.minorTickMarkWidthFactor = new DoublePropertyBase(this._minorTickMarkWidthFactor){

                protected void invalidated() {
                    double VALUE = this.get();
                    if (VALUE < 0.0 || VALUE > 1.0) {
                        this.set(Helper.clamp(0.0, 1.0, VALUE));
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "minorTickMarkWidthFactor";
                }
            };
        }
        return this.minorTickMarkWidthFactor;
    }

    public TickMarkType getMajorTickMarkType() {
        return null == this.majorTickMarkType ? this._majorTickMarkType : (TickMarkType)((Object)this.majorTickMarkType.get());
    }

    public void setMajorTickMarkType(TickMarkType TYPE) {
        if (null == this.majorTickMarkType) {
            this._majorTickMarkType = null == TYPE ? TickMarkType.LINE : TYPE;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.majorTickMarkType.set((Object)TYPE);
        }
    }

    public ObjectProperty<TickMarkType> majorTickMarkTypeProperty() {
        if (null == this.majorTickMarkType) {
            this.majorTickMarkType = new ObjectPropertyBase<TickMarkType>(this._majorTickMarkType){

                protected void invalidated() {
                    if (null == this.get()) {
                        this.set((Object)TickMarkType.LINE);
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "majorTickMarkType";
                }
            };
            this._majorTickMarkType = null;
        }
        return this.majorTickMarkType;
    }

    public TickMarkType getMediumTickMarkType() {
        return null == this.mediumTickMarkType ? this._mediumTickMarkType : (TickMarkType)((Object)this.mediumTickMarkType.get());
    }

    public void setMediumTickMarkType(TickMarkType TYPE) {
        if (null == this.mediumTickMarkType) {
            this._mediumTickMarkType = null == TYPE ? TickMarkType.LINE : TYPE;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.mediumTickMarkType.set((Object)TYPE);
        }
    }

    public ObjectProperty<TickMarkType> mediumTickMarkTypeProperty() {
        if (null == this.mediumTickMarkType) {
            this.mediumTickMarkType = new ObjectPropertyBase<TickMarkType>(this._mediumTickMarkType){

                protected void invalidated() {
                    if (null == this.get()) {
                        this.set((Object)TickMarkType.LINE);
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "mediumTickMarkType";
                }
            };
            this._mediumTickMarkType = null;
        }
        return this.mediumTickMarkType;
    }

    public TickMarkType getMinorTickMarkType() {
        return null == this.minorTickMarkType ? this._minorTickMarkType : (TickMarkType)((Object)this.minorTickMarkType.get());
    }

    public void setMinorTickMarkType(TickMarkType TYPE) {
        if (null == this.minorTickMarkType) {
            this._minorTickMarkType = null == TYPE ? TickMarkType.LINE : TYPE;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.minorTickMarkType.set((Object)TYPE);
        }
    }

    public ObjectProperty<TickMarkType> minorTickMarkTypeProperty() {
        if (null == this.minorTickMarkType) {
            this.minorTickMarkType = new ObjectPropertyBase<TickMarkType>(this._minorTickMarkType){

                protected void invalidated() {
                    if (null == this.get()) {
                        this.set((Object)TickMarkType.LINE);
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "minorTickMarkType";
                }
            };
            this._minorTickMarkType = null;
        }
        return this.minorTickMarkType;
    }

    public Locale getLocale() {
        return null == this.locale ? this._locale : (Locale)this.locale.get();
    }

    public void setLocale(Locale LOCALE) {
        if (null == this.locale) {
            this._locale = null == LOCALE ? Locale.US : LOCALE;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.locale.set((Object)LOCALE);
        }
    }

    public ObjectProperty<Locale> localeProperty() {
        if (null == this.locale) {
            this.locale = new ObjectPropertyBase<Locale>(this._locale){

                protected void invalidated() {
                    if (null == this.get()) {
                        this.set(Locale.US);
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "locale";
                }
            };
            this._locale = null;
        }
        return this.locale;
    }

    public NumberFormat getNumberFormat() {
        return null == this.numberFormat ? this._numberFormat : (NumberFormat)this.numberFormat.get();
    }

    public void setNumberFormat(NumberFormat FORMAT) {
        if (null == this.numberFormat) {
            this._numberFormat = null == FORMAT ? NumberFormat.getInstance(this.getLocale()) : FORMAT;
            this.fireUpdateEvent(this.RESIZE_EVENT);
        } else {
            this.numberFormat.set((Object)FORMAT);
        }
    }

    public ObjectProperty<NumberFormat> numberFormatProperty() {
        if (null == this.numberFormat) {
            this.numberFormat = new ObjectPropertyBase<NumberFormat>(this._numberFormat){

                protected void invalidated() {
                    if (null == this.get()) {
                        this.set(NumberFormat.getInstance(Gauge.this.getLocale()));
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.RESIZE_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "numberFormat";
                }
            };
            this._numberFormat = null;
        }
        return this.numberFormat;
    }

    public int getDecimals() {
        return null == this.decimals ? this._decimals : this.decimals.get();
    }

    public void setDecimals(int DECIMALS) {
        if (null == this.decimals) {
            this._decimals = Helper.clamp(0, 3, DECIMALS);
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.decimals.set(DECIMALS);
        }
    }

    public IntegerProperty decimalsProperty() {
        if (null == this.decimals) {
            this.decimals = new IntegerPropertyBase(this._decimals){

                protected void invalidated() {
                    int VALUE = this.get();
                    if (VALUE < 0 || VALUE > 3) {
                        this.set(Helper.clamp(0, 3, VALUE));
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "decimals";
                }
            };
        }
        return this.decimals;
    }

    public int getTickLabelDecimals() {
        return null == this.tickLabelDecimals ? this._tickLabelDecimals : this.tickLabelDecimals.get();
    }

    public void setTickLabelDecimals(int DECIMALS) {
        if (null == this.tickLabelDecimals) {
            this._tickLabelDecimals = Helper.clamp(0, 3, DECIMALS);
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.tickLabelDecimals.set(DECIMALS);
        }
    }

    public IntegerProperty tickLabelDecimalsProperty() {
        if (null == this.tickLabelDecimals) {
            this.tickLabelDecimals = new IntegerPropertyBase(this._tickLabelDecimals){

                protected void invalidated() {
                    int VALUE = this.get();
                    if (VALUE < 0 || VALUE > 3) {
                        this.set(Helper.clamp(0, 3, VALUE));
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "tickLabelDecimals";
                }
            };
        }
        return this.tickLabelDecimals;
    }

    public NeedleType getNeedleType() {
        return null == this.needleType ? this._needleType : (NeedleType)((Object)this.needleType.get());
    }

    public void setNeedleType(NeedleType TYPE) {
        if (null == this.needleType) {
            this._needleType = TYPE == null ? NeedleType.STANDARD : TYPE;
            this.fireUpdateEvent(this.RESIZE_EVENT);
        } else {
            this.needleType.set((Object)TYPE);
        }
    }

    public ObjectProperty<NeedleType> needleTypeProperty() {
        if (null == this.needleType) {
            this.needleType = new ObjectPropertyBase<NeedleType>(this._needleType){

                protected void invalidated() {
                    if (null == this.get()) {
                        this.set((Object)NeedleType.STANDARD);
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.RESIZE_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "needleType";
                }
            };
            this._needleType = null;
        }
        return this.needleType;
    }

    public NeedleShape getNeedleShape() {
        return null == this.needleShape ? this._needleShape : (NeedleShape)((Object)this.needleShape.get());
    }

    public void setNeedleShape(NeedleShape SHAPE) {
        if (null == this.needleShape) {
            this._needleShape = null == SHAPE ? NeedleShape.ANGLED : SHAPE;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.needleShape.set((Object)SHAPE);
        }
    }

    public ObjectProperty<NeedleShape> needleShapeProperty() {
        if (null == this.needleShape) {
            this.needleShape = new ObjectPropertyBase<NeedleShape>(this._needleShape){

                protected void invalidated() {
                    if (null == this.get()) {
                        this.set((Object)NeedleShape.ANGLED);
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "needleShape";
                }
            };
            this._needleShape = null;
        }
        return this.needleShape;
    }

    public NeedleSize getNeedleSize() {
        return null == this.needleSize ? this._needleSize : (NeedleSize)((Object)this.needleSize.get());
    }

    public void setNeedleSize(NeedleSize SIZE) {
        if (null == this.needleSize) {
            this._needleSize = null == SIZE ? NeedleSize.STANDARD : SIZE;
            this.fireUpdateEvent(this.RESIZE_EVENT);
        } else {
            this.needleSize.set((Object)SIZE);
        }
    }

    public ObjectProperty<NeedleSize> needleSizeProperty() {
        if (null == this.needleSize) {
            this.needleSize = new ObjectPropertyBase<NeedleSize>(this._needleSize){

                protected void invalidated() {
                    if (null == this.get()) {
                        this.set((Object)NeedleSize.STANDARD);
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.RESIZE_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "needleSize";
                }
            };
            this._needleSize = null;
        }
        return this.needleSize;
    }

    public NeedleBehavior getNeedleBehavior() {
        return null == this.needleBehavior ? this._needleBehavior : (NeedleBehavior)((Object)this.needleBehavior.get());
    }

    public void setNeedleBehavior(NeedleBehavior BEHAVIOR) {
        if (null == this.needleBehavior) {
            this._needleBehavior = null == BEHAVIOR ? NeedleBehavior.STANDARD : BEHAVIOR;
        } else {
            this.needleBehavior.set((Object)BEHAVIOR);
        }
    }

    public ObjectProperty<NeedleBehavior> needleBehaviorProperty() {
        if (null == this.needleBehavior) {
            this.needleBehavior = new ObjectPropertyBase<NeedleBehavior>(this._needleBehavior){

                protected void invalidated() {
                    if (null == this.get()) {
                        this.set((Object)NeedleBehavior.STANDARD);
                    }
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "needleBehavior";
                }
            };
            this._needleBehavior = null;
        }
        return this.needleBehavior;
    }

    public Color getNeedleColor() {
        return null == this.needleColor ? this._needleColor : (Color)this.needleColor.get();
    }

    public void setNeedleColor(Color COLOR) {
        if (null == this.needleColor) {
            this._needleColor = COLOR;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.needleColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> needleColorProperty() {
        if (null == this.needleColor) {
            this.needleColor = new ObjectPropertyBase<Color>(this._needleColor){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "needleColor";
                }
            };
            this._needleColor = null;
        }
        return this.needleColor;
    }

    public Color getNeedleBorderColor() {
        return null == this.needleBorderColor ? this._needleBorderColor : (Color)this.needleBorderColor.get();
    }

    public void setNeedleBorderColor(Color COLOR) {
        if (null == this.needleBorderColor) {
            this._needleBorderColor = null == COLOR ? Color.TRANSPARENT : COLOR;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.needleBorderColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> needleBorderColorProperty() {
        if (null == this.needleBorderColor) {
            this.needleBorderColor = new ObjectPropertyBase<Color>(this._needleBorderColor){

                protected void invalidated() {
                    if (null == this.get()) {
                        this.set(Color.TRANSPARENT);
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "needleBorderColor";
                }
            };
            this._needleBorderColor = null;
        }
        return this.needleBorderColor;
    }

    public Color getBarColor() {
        return null == this.barColor ? this._barColor : (Color)this.barColor.get();
    }

    public void setBarColor(Color COLOR) {
        if (null == this.barColor) {
            this._barColor = COLOR;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.barColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> barColorProperty() {
        if (null == this.barColor) {
            this.barColor = new ObjectPropertyBase<Color>(this._barColor){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "barColor";
                }
            };
            this._barColor = null;
        }
        return this.barColor;
    }

    public Color getBarBorderColor() {
        return null == this.barBorderColor ? this._barBorderColor : (Color)this.barBorderColor.get();
    }

    public void setBarBorderColor(Color COLOR) {
        if (null == this.barBorderColor) {
            this._barBorderColor = null == COLOR ? Color.TRANSPARENT : COLOR;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.barBorderColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> barBorderColorProperty() {
        if (null == this.barBorderColor) {
            this.barBorderColor = new ObjectPropertyBase<Color>(this._barBorderColor){

                protected void invalidated() {
                    if (null == this.get()) {
                        this.set(Color.TRANSPARENT);
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "barBorderColor";
                }
            };
            this._barBorderColor = null;
        }
        return this.barBorderColor;
    }

    public Color getBarBackgroundColor() {
        return null == this.barBackgroundColor ? this._barBackgroundColor : (Color)this.barBackgroundColor.get();
    }

    public void setBarBackgroundColor(Color COLOR) {
        if (null == this.barBackgroundColor) {
            this._barBackgroundColor = COLOR;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.barBackgroundColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> barBackgroundColorProperty() {
        if (null == this.barBackgroundColor) {
            this.barBackgroundColor = new ObjectPropertyBase<Color>(this._barBackgroundColor){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "barBackgroundColor";
                }
            };
            this._barBackgroundColor = null;
        }
        return this.barBackgroundColor;
    }

    public LcdDesign getLcdDesign() {
        return null == this.lcdDesign ? this._lcdDesign : (LcdDesign)((Object)this.lcdDesign.get());
    }

    public void setLcdDesign(LcdDesign DESIGN) {
        if (null == this.lcdDesign) {
            this._lcdDesign = null == DESIGN ? LcdDesign.STANDARD : DESIGN;
            this.fireUpdateEvent(this.LCD_EVENT);
        } else {
            this.lcdDesign.set((Object)DESIGN);
        }
    }

    public ObjectProperty<LcdDesign> lcdDesignProperty() {
        if (null == this.lcdDesign) {
            this.lcdDesign = new ObjectPropertyBase<LcdDesign>(this._lcdDesign){

                protected void invalidated() {
                    if (null == this.get()) {
                        this.set((Object)LcdDesign.STANDARD);
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.LCD_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "lcdDesign";
                }
            };
            this._lcdDesign = null;
        }
        return this.lcdDesign;
    }

    public LcdFont getLcdFont() {
        return null == this.lcdFont ? this._lcdFont : (LcdFont)((Object)this.lcdFont.get());
    }

    public void setLcdFont(LcdFont FONT) {
        if (null == this.lcdFont) {
            this._lcdFont = null == FONT ? LcdFont.DIGITAL_BOLD : FONT;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.lcdFont.set((Object)FONT);
        }
    }

    public ObjectProperty<LcdFont> lcdFontProperty() {
        if (null == this.lcdFont) {
            this.lcdFont = new ObjectPropertyBase<LcdFont>(this._lcdFont){

                protected void invalidated() {
                    if (null == this.get()) {
                        this.set((Object)LcdFont.DIGITAL_BOLD);
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "lcdFont";
                }
            };
            this._lcdFont = null;
        }
        return this.lcdFont;
    }

    public Color getLedColor() {
        return null == this.ledColor ? this._ledColor : (Color)this.ledColor.get();
    }

    public void setLedColor(Color COLOR) {
        if (null == this.ledColor) {
            this._ledColor = null == COLOR ? Color.RED : COLOR;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.ledColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> ledColorProperty() {
        if (null == this.ledColor) {
            this.ledColor = new ObjectPropertyBase<Color>(this._ledColor){

                protected void invalidated() {
                    if (null == this.get()) {
                        this.set(Color.RED);
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "ledColor";
                }
            };
            this._ledColor = null;
        }
        return this.ledColor;
    }

    public LedType getLedType() {
        return null == this.ledType ? this._ledType : (LedType)((Object)this.ledType.get());
    }

    public void setLedType(LedType TYPE) {
        if (null == this.ledType) {
            this._ledType = null == TYPE ? LedType.STANDARD : TYPE;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.ledType.set((Object)TYPE);
        }
    }

    public ObjectProperty<LedType> ledTypeProperty() {
        if (null == this.ledType) {
            this.ledType = new ObjectPropertyBase<LedType>(this._ledType){

                protected void invalidated() {
                    if (null == this.get()) {
                        this.set((Object)LedType.STANDARD);
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "ledType";
                }
            };
            this._ledType = null;
        }
        return this.ledType;
    }

    public Color getTitleColor() {
        return null == this.titleColor ? this._titleColor : (Color)this.titleColor.get();
    }

    public void setTitleColor(Color COLOR) {
        if (null == this.titleColor) {
            this._titleColor = COLOR;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.titleColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> titleColorProperty() {
        if (null == this.titleColor) {
            this.titleColor = new ObjectPropertyBase<Color>(this._titleColor){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "titleColor";
                }
            };
            this._titleColor = null;
        }
        return this.titleColor;
    }

    public Color getSubTitleColor() {
        return null == this.subTitleColor ? this._subTitleColor : (Color)this.subTitleColor.get();
    }

    public void setSubTitleColor(Color COLOR) {
        if (null == this.subTitleColor) {
            this._subTitleColor = COLOR;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.subTitleColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> subTitleColorProperty() {
        if (null == this.subTitleColor) {
            this.subTitleColor = new ObjectPropertyBase<Color>(this._subTitleColor){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "subTitleColor";
                }
            };
            this._subTitleColor = null;
        }
        return this.subTitleColor;
    }

    public Color getUnitColor() {
        return null == this.unitColor ? this._unitColor : (Color)this.unitColor.get();
    }

    public void setUnitColor(Color COLOR) {
        if (null == this.unitColor) {
            this._unitColor = COLOR;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.unitColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> unitColorProperty() {
        if (null == this.unitColor) {
            this.unitColor = new ObjectPropertyBase<Color>(this._unitColor){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "unitColor";
                }
            };
            this._unitColor = null;
        }
        return this.unitColor;
    }

    public Color getValueColor() {
        return null == this.valueColor ? this._valueColor : (Color)this.valueColor.get();
    }

    public void setValueColor(Color COLOR) {
        if (null == this.valueColor) {
            this._valueColor = COLOR;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.valueColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> valueColorProperty() {
        if (null == this.valueColor) {
            this.valueColor = new ObjectPropertyBase<Color>(this._valueColor){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "valueColor";
                }
            };
            this._valueColor = null;
        }
        return this.valueColor;
    }

    public Color getThresholdColor() {
        return null == this.thresholdColor ? this._thresholdColor : (Color)this.thresholdColor.get();
    }

    public void setThresholdColor(Color COLOR) {
        if (null == this.thresholdColor) {
            this._thresholdColor = COLOR;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.thresholdColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> thresholdColorProperty() {
        if (null == this.thresholdColor) {
            this.thresholdColor = new ObjectPropertyBase<Color>(this._thresholdColor){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "thresholdColor";
                }
            };
            this._thresholdColor = null;
        }
        return this.thresholdColor;
    }

    public boolean getCheckSectionsForValue() {
        return null == this.checkSectionsForValue ? this._checkSectionsForValue : this.checkSectionsForValue.get();
    }

    public void setCheckSectionsForValue(boolean CHECK) {
        if (null == this.checkSectionsForValue) {
            this._checkSectionsForValue = CHECK;
        } else {
            this.checkSectionsForValue.set(CHECK);
        }
    }

    public BooleanProperty checkSectionsForValueProperty() {
        if (null == this.checkSectionsForValue) {
            this.checkSectionsForValue = new SimpleBooleanProperty((Object)this, "checkSectionsForValue", this._checkSectionsForValue);
        }
        return this.checkSectionsForValue;
    }

    public boolean getCheckAreasForValue() {
        return null == this.checkAreasForValue ? this._checkAreasForValue : this.checkAreasForValue.get();
    }

    public void setCheckAreasForValue(boolean CHECK) {
        if (null == this.checkAreasForValue) {
            this._checkAreasForValue = CHECK;
        } else {
            this.checkAreasForValue.set(CHECK);
        }
    }

    public BooleanProperty checkAreasForValueProperty() {
        if (null == this.checkAreasForValue) {
            this.checkAreasForValue = new SimpleBooleanProperty((Object)this, "checkAreasForValue", this._checkAreasForValue);
        }
        return this.checkAreasForValue;
    }

    public boolean isCheckThreshold() {
        return null == this.checkThreshold ? this._checkThreshold : this.checkThreshold.get();
    }

    public void setCheckThreshold(boolean CHECK) {
        if (null == this.checkThreshold) {
            this._checkThreshold = CHECK;
        } else {
            this.checkThreshold.set(CHECK);
        }
    }

    public BooleanProperty checkThresholdProperty() {
        if (null == this.checkThreshold) {
            this.checkThreshold = new SimpleBooleanProperty((Object)this, "checkThreshold", this._checkThreshold);
        }
        return this.checkThreshold;
    }

    public boolean isInnerShadowEnabled() {
        return null == this.innerShadowEnabled ? this._innerShadowEnabled : this.innerShadowEnabled.get();
    }

    public void setInnerShadowEnabled(boolean ENABLED) {
        if (null == this.innerShadowEnabled) {
            this._innerShadowEnabled = ENABLED;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.innerShadowEnabled.set(ENABLED);
        }
    }

    public BooleanProperty innerShadowEnabledProperty() {
        if (null == this.innerShadowEnabled) {
            this.innerShadowEnabled = new BooleanPropertyBase(this._innerShadowEnabled){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "innerShadowEnabled";
                }
            };
        }
        return this.innerShadowEnabled;
    }

    public boolean isThresholdVisible() {
        return null == this.thresholdVisible ? this._thresholdVisible : this.thresholdVisible.get();
    }

    public void setThresholdVisible(boolean VISIBLE) {
        if (null == this.thresholdVisible) {
            this._thresholdVisible = VISIBLE;
            this.fireUpdateEvent(this.VISIBILITY_EVENT);
        } else {
            this.thresholdVisible.set(VISIBLE);
        }
    }

    public BooleanProperty thresholdVisibleProperty() {
        if (null == this.thresholdVisible) {
            this.thresholdVisible = new BooleanPropertyBase(this._thresholdVisible){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.VISIBILITY_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "thresholdVisible";
                }
            };
        }
        return this.thresholdVisible;
    }

    public boolean getSectionsVisible() {
        return null == this.sectionsVisible ? this._sectionsVisible : this.sectionsVisible.get();
    }

    public void setSectionsVisible(boolean VISIBLE) {
        if (null == this.sectionsVisible) {
            this._sectionsVisible = VISIBLE;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.sectionsVisible.set(VISIBLE);
        }
    }

    public BooleanProperty sectionsVisibleProperty() {
        if (null == this.sectionsVisible) {
            this.sectionsVisible = new BooleanPropertyBase(this._sectionsVisible){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "sectionsVisible";
                }
            };
        }
        return this.sectionsVisible;
    }

    public boolean getSectionsAlwaysVisible() {
        return null == this.sectionsAlwaysVisible ? this._sectionsAlwaysVisible : this.sectionsAlwaysVisible.get();
    }

    public void setSectionsAlwaysVisible(boolean VISIBLE) {
        if (null == this.sectionsAlwaysVisible) {
            this._sectionsAlwaysVisible = VISIBLE;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.sectionsAlwaysVisible.set(VISIBLE);
        }
    }

    public BooleanProperty sectionsAlwaysVisibleProperty() {
        if (null == this.sectionsAlwaysVisible) {
            this.sectionsAlwaysVisible = new BooleanPropertyBase(this._sectionsAlwaysVisible){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "sectionsAlwaysVisible";
                }
            };
        }
        return this.sectionsAlwaysVisible;
    }

    public boolean isSectionTextVisible() {
        return null == this.sectionTextVisible ? this._sectionTextVisible : this.sectionTextVisible.get();
    }

    public void setSectionTextVisible(boolean VISIBLE) {
        if (null == this.sectionTextVisible) {
            this._sectionTextVisible = VISIBLE;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.sectionTextVisible.set(VISIBLE);
        }
    }

    public BooleanProperty sectionTextVisibleProperty() {
        if (null == this.sectionTextVisible) {
            this.sectionTextVisible = new BooleanPropertyBase(this._sectionTextVisible){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "sectionTextVisible";
                }
            };
        }
        return this.sectionTextVisible;
    }

    public boolean getSectionIconsVisible() {
        return null == this.sectionIconsVisible ? this._sectionIconsVisible : this.sectionIconsVisible.get();
    }

    public void setSectionIconsVisible(boolean VISIBLE) {
        if (null == this.sectionIconsVisible) {
            this._sectionIconsVisible = VISIBLE;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.sectionIconsVisible.set(VISIBLE);
        }
    }

    public BooleanProperty sectionIconsVisibleProperty() {
        if (null == this.sectionIconsVisible) {
            this.sectionIconsVisible = new BooleanPropertyBase(this._sectionIconsVisible){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "sectionIconsVisible";
                }
            };
        }
        return this.sectionIconsVisible;
    }

    public boolean isHighlightSections() {
        return null == this.highlightSections ? this._highlightSections : this.highlightSections.get();
    }

    public void setHighlightSections(boolean HIGHLIGHT) {
        if (null == this.highlightSections) {
            this._highlightSections = HIGHLIGHT;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.highlightSections.set(HIGHLIGHT);
        }
    }

    public BooleanProperty highlightSectionsProperty() {
        if (null == this.highlightSections) {
            this.highlightSections = new BooleanPropertyBase(this._highlightSections){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "highlightSections";
                }
            };
        }
        return this.highlightSections;
    }

    public boolean getAreasVisible() {
        return null == this.areasVisible ? this._areasVisible : this.areasVisible.get();
    }

    public void setAreasVisible(boolean VISIBLE) {
        if (null == this.areasVisible) {
            this._areasVisible = VISIBLE;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.areasVisible.set(VISIBLE);
        }
    }

    public BooleanProperty areasVisibleProperty() {
        if (null == this.areasVisible) {
            this.areasVisible = new BooleanPropertyBase(this._areasVisible){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "areasVisible";
                }
            };
        }
        return this.areasVisible;
    }

    public boolean isAreaTextVisible() {
        return null == this.areaTextVisible ? this._areaTextVisible : this.areaTextVisible.get();
    }

    public void setAreaTextVisible(boolean VISIBLE) {
        if (null == this.areaTextVisible) {
            this._areaTextVisible = VISIBLE;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.areaTextVisible.set(VISIBLE);
        }
    }

    public BooleanProperty areaTextVisibleProperty() {
        if (null == this.areaTextVisible) {
            this.areaTextVisible = new BooleanPropertyBase(this._areaTextVisible){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "areaTextVisible";
                }
            };
        }
        return this.areaTextVisible;
    }

    public boolean getAreaIconsVisible() {
        return null == this.areaIconsVisible ? this._areaIconsVisible : this.areaIconsVisible.get();
    }

    public void setAreaIconsVisible(boolean VISIBLE) {
        if (null == this.areaIconsVisible) {
            this._areaIconsVisible = VISIBLE;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.areaIconsVisible.set(VISIBLE);
        }
    }

    public BooleanProperty areaIconsVisibleProperty() {
        if (null == this.areaIconsVisible) {
            this.areaIconsVisible = new BooleanPropertyBase(this._areaIconsVisible){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "areaIconsVisible";
                }
            };
        }
        return this.areaIconsVisible;
    }

    public boolean isHighlightAreas() {
        return null == this.highlightAreas ? this._highlightAreas : this.highlightAreas.get();
    }

    public void setHighlightAreas(boolean HIGHLIGHT) {
        if (null == this.highlightAreas) {
            this._highlightAreas = HIGHLIGHT;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.highlightAreas.set(HIGHLIGHT);
        }
    }

    public BooleanProperty highlightAreasProperty() {
        if (null == this.highlightAreas) {
            this.highlightAreas = new BooleanPropertyBase(this._highlightAreas){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "highlightAreas";
                }
            };
        }
        return this.highlightAreas;
    }

    public boolean getTickMarkSectionsVisible() {
        return null == this.tickMarkSectionsVisible ? this._tickMarkSectionsVisible : this.tickMarkSectionsVisible.get();
    }

    public void setTickMarkSectionsVisible(boolean VISIBLE) {
        if (null == this.tickMarkSectionsVisible) {
            this._tickMarkSectionsVisible = VISIBLE;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.tickMarkSectionsVisible.set(VISIBLE);
        }
    }

    public BooleanProperty TickMarkSectionsVisibleProperty() {
        if (null == this.tickMarkSectionsVisible) {
            this.tickMarkSectionsVisible = new BooleanPropertyBase(this._tickMarkSectionsVisible){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "tickMarkSectionsVisible";
                }
            };
        }
        return this.tickMarkSectionsVisible;
    }

    public boolean getTickLabelSectionsVisible() {
        return null == this.tickLabelSectionsVisible ? this._tickLabelSectionsVisible : this.tickLabelSectionsVisible.get();
    }

    public void setTickLabelSectionsVisible(boolean VISIBLE) {
        if (null == this.tickLabelSectionsVisible) {
            this._tickLabelSectionsVisible = VISIBLE;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.tickLabelSectionsVisible.set(VISIBLE);
        }
    }

    public BooleanProperty TickLabelSectionsVisibleProperty() {
        if (null == this.tickLabelSectionsVisible) {
            this.tickLabelSectionsVisible = new BooleanPropertyBase(this._tickLabelSectionsVisible){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "tickLabelSectionsVisible";
                }
            };
        }
        return this.tickLabelSectionsVisible;
    }

    public boolean getMarkersVisible() {
        return null == this.markersVisible ? this._markersVisible : this.markersVisible.get();
    }

    public void setMarkersVisible(boolean VISIBLE) {
        if (null == this.markersVisible) {
            this._markersVisible = VISIBLE;
            this.fireUpdateEvent(this.VISIBILITY_EVENT);
        } else {
            this.markersVisible.set(VISIBLE);
        }
    }

    public BooleanProperty markersVisibleProperty() {
        if (null == this.markersVisible) {
            this.markersVisible = new BooleanPropertyBase(this._markersVisible){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.VISIBILITY_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "markersVisible";
                }
            };
        }
        return this.markersVisible;
    }

    public boolean getTickLabelsVisible() {
        return null == this.tickLabelsVisible ? this._tickLabelsVisible : this.tickLabelsVisible.get();
    }

    public void setTickLabelsVisible(boolean VISIBLE) {
        if (null == this.tickLabelsVisible) {
            this._tickLabelsVisible = VISIBLE;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.tickLabelsVisible.set(VISIBLE);
        }
    }

    public BooleanProperty tickLabelsVisibleProperty() {
        if (null == this.tickLabelsVisible) {
            this.tickLabelsVisible = new BooleanPropertyBase(this._tickLabelsVisible){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "tickLabelsVisible";
                }
            };
        }
        return this.tickLabelsVisible;
    }

    public boolean isOnlyFirstAndLastTickLabelVisible() {
        return null == this.onlyFirstAndLastTickLabelVisible ? this._onlyFirstAndLastTickLabelVisible : this.onlyFirstAndLastTickLabelVisible.get();
    }

    public void setOnlyFirstAndLastTickLabelVisible(boolean VISIBLE) {
        if (null == this.onlyFirstAndLastTickLabelVisible) {
            this._onlyFirstAndLastTickLabelVisible = VISIBLE;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.onlyFirstAndLastTickLabelVisible.set(VISIBLE);
        }
    }

    public BooleanProperty onlyFirstAndLastTickLabelVisibleProperty() {
        if (null == this.onlyFirstAndLastTickLabelVisible) {
            this.onlyFirstAndLastTickLabelVisible = new BooleanPropertyBase(this._onlyFirstAndLastTickLabelVisible){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "onlyFirstAndLastTickLabelVisible";
                }
            };
        }
        return this.onlyFirstAndLastTickLabelVisible;
    }

    public boolean getMajorTickMarksVisible() {
        return null == this.majorTickMarksVisible ? this._majorTickMarksVisible : this.majorTickMarksVisible.get();
    }

    public void setMajorTickMarksVisible(boolean VISIBLE) {
        if (null == this.majorTickMarksVisible) {
            this._majorTickMarksVisible = VISIBLE;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.majorTickMarksVisible.set(VISIBLE);
        }
    }

    public BooleanProperty majorTickMarksVisibleProperty() {
        if (null == this.majorTickMarksVisible) {
            this.majorTickMarksVisible = new BooleanPropertyBase(this._majorTickMarksVisible){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "majorTickMarksVisible";
                }
            };
        }
        return this.majorTickMarksVisible;
    }

    public boolean getMediumTickMarksVisible() {
        return null == this.mediumTickMarksVisible ? this._mediumTickMarksVisible : this.mediumTickMarksVisible.get();
    }

    public void setMediumTickMarksVisible(boolean VISIBLE) {
        if (null == this.mediumTickMarksVisible) {
            this._mediumTickMarksVisible = VISIBLE;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.mediumTickMarksVisible.set(VISIBLE);
        }
    }

    public BooleanProperty mediumTickMarksVisibleProperty() {
        if (null == this.mediumTickMarksVisible) {
            this.mediumTickMarksVisible = new BooleanPropertyBase(this._mediumTickMarksVisible){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "mediumTickMarksVisible";
                }
            };
        }
        return this.mediumTickMarksVisible;
    }

    public boolean getMinorTickMarksVisible() {
        return null == this.minorTickMarksVisible ? this._minorTickMarksVisible : this.minorTickMarksVisible.get();
    }

    public void setMinorTickMarksVisible(boolean VISIBLE) {
        if (null == this.minorTickMarksVisible) {
            this._minorTickMarksVisible = VISIBLE;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.minorTickMarksVisible.set(VISIBLE);
        }
    }

    public BooleanProperty MinorTickMarksVisibleProperty() {
        if (null == this.minorTickMarksVisible) {
            this.minorTickMarksVisible = new BooleanPropertyBase(this._minorTickMarksVisible){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "minorTickMarksVisible";
                }
            };
        }
        return this.minorTickMarksVisible;
    }

    public boolean isTickMarkRingVisible() {
        return null == this.tickMarkRingVisible ? this._tickMarkRingVisible : this.tickMarkRingVisible.get();
    }

    public void setTickMarkRingVisible(boolean VISIBLE) {
        if (null == this.tickMarkRingVisible) {
            this._tickMarkRingVisible = VISIBLE;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.tickMarkRingVisible.set(VISIBLE);
        }
    }

    public BooleanProperty tickMarkRingVisibleProperty() {
        if (null == this.tickMarkRingVisible) {
            this.tickMarkRingVisible = new BooleanPropertyBase(this._tickMarkRingVisible){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "tickMarkRingVisible";
                }
            };
        }
        return this.tickMarkRingVisible;
    }

    public double getMajorTickSpace() {
        return null == this.majorTickSpace ? this._majorTickSpace : this.majorTickSpace.get();
    }

    public void setMajorTickSpace(double SPACE) {
        if (null == this.majorTickSpace) {
            this._majorTickSpace = SPACE;
            this.fireUpdateEvent(this.RECALC_EVENT);
        } else {
            this.majorTickSpace.set(SPACE);
        }
    }

    public DoubleProperty majorTickSpaceProperty() {
        if (null == this.majorTickSpace) {
            this.majorTickSpace = new DoublePropertyBase(this._majorTickSpace){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.RECALC_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "majorTickSpace";
                }
            };
        }
        return this.majorTickSpace;
    }

    public double getMinorTickSpace() {
        return null == this.minorTickSpace ? this._minorTickSpace : this.minorTickSpace.get();
    }

    public void setMinorTickSpace(double SPACE) {
        if (null == this.minorTickSpace) {
            this._minorTickSpace = SPACE;
            this.fireUpdateEvent(this.RECALC_EVENT);
        } else {
            this.minorTickSpace.set(SPACE);
        }
    }

    public DoubleProperty minorTickSpaceProperty() {
        if (null == this.minorTickSpace) {
            this.minorTickSpace = new DoublePropertyBase(this._minorTickSpace){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.RECALC_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "minorTickSpace";
                }
            };
        }
        return this.minorTickSpace;
    }

    public boolean isLcdVisible() {
        return null == this.lcdVisible ? this._lcdVisible : this.lcdVisible.get();
    }

    public void setLcdVisible(boolean VISIBLE) {
        if (null == this.lcdVisible) {
            this._lcdVisible = VISIBLE;
            this.fireUpdateEvent(this.VISIBILITY_EVENT);
        } else {
            this.lcdVisible.set(VISIBLE);
        }
    }

    public BooleanProperty lcdVisibleProperty() {
        if (null == this.lcdVisible) {
            this.lcdVisible = new BooleanPropertyBase(this._lcdVisible){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.VISIBILITY_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "lcdVisible";
                }
            };
        }
        return this.lcdVisible;
    }

    public boolean isLcdCrystalEnabled() {
        return null == this.lcdCrystalEnabled ? this._lcdCrystalEnabled : this.lcdCrystalEnabled.get();
    }

    public void setLcdCrystalEnabled(boolean ENABLED) {
        if (null == this.lcdCrystalEnabled) {
            this._lcdCrystalEnabled = ENABLED;
            this.fireUpdateEvent(this.VISIBILITY_EVENT);
        } else {
            this.lcdCrystalEnabled.set(ENABLED);
        }
    }

    public BooleanProperty lcdCrystalEnabledProperty() {
        if (null == this.lcdCrystalEnabled) {
            this.lcdCrystalEnabled = new BooleanPropertyBase(this._lcdCrystalEnabled){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.VISIBILITY_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "lcdCrystalEnabled";
                }
            };
        }
        return this.lcdCrystalEnabled;
    }

    public boolean isLedVisible() {
        return null == this.ledVisible ? this._ledVisible : this.ledVisible.get();
    }

    public void setLedVisible(boolean VISIBLE) {
        if (null == this.ledVisible) {
            this._ledVisible = VISIBLE;
            this.fireUpdateEvent(this.VISIBILITY_EVENT);
        } else {
            this.ledVisible.set(VISIBLE);
        }
    }

    public BooleanProperty ledVisibleProperty() {
        if (null == this.ledVisible) {
            this.ledVisible = new BooleanPropertyBase(this._ledVisible){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.VISIBILITY_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "ledVisible";
                }
            };
        }
        return this.ledVisible;
    }

    public boolean isLedOn() {
        return null == this.ledOn ? this._ledOn : this.ledOn.get();
    }

    public void setLedOn(boolean ON) {
        if (null == this.ledOn) {
            this._ledOn = ON;
            this.fireUpdateEvent(this.LED_EVENT);
        } else {
            this.ledOn.set(ON);
        }
    }

    public BooleanProperty ledOnProperty() {
        if (null == this.ledOn) {
            this.ledOn = new BooleanPropertyBase(this._ledOn){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.LED_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "ledOn";
                }
            };
        }
        return this.ledOn;
    }

    public boolean isLedBlinking() {
        return null == this.ledBlinking ? this._ledBlinking : this.ledBlinking.get();
    }

    public void setLedBlinking(boolean BLINKING) {
        if (null == this.ledBlinking) {
            this._ledBlinking = BLINKING;
            if (this._ledBlinking) {
                this.startBlinkExecutorService();
            } else {
                if (null != blinkFuture) {
                    blinkFuture.cancel(true);
                }
                this.setLedOn(false);
            }
        } else {
            this.ledBlinking.set(BLINKING);
        }
    }

    public BooleanProperty ledBlinkingProperty() {
        if (null == this.ledBlinking) {
            this.ledBlinking = new BooleanPropertyBase(this._ledBlinking){

                protected void invalidated() {
                    if (this.get()) {
                        Gauge.this.startBlinkExecutorService();
                    } else {
                        if (null != blinkFuture) {
                            blinkFuture.cancel(true);
                        }
                        Gauge.this.setLedOn(false);
                    }
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "ledBlinking";
                }
            };
        }
        return this.ledBlinking;
    }

    public Orientation getOrientation() {
        return null == this.orientation ? this._orientation : (Orientation)this.orientation.get();
    }

    public void setOrientation(Orientation ORIENTATION) {
        if (null == this.orientation) {
            this._orientation = ORIENTATION;
            this.fireUpdateEvent(this.RESIZE_EVENT);
        } else {
            this.orientation.set((Object)ORIENTATION);
        }
    }

    public ObjectProperty<Orientation> orientationProperty() {
        if (null == this.orientation) {
            this.orientation = new ObjectPropertyBase<Orientation>(this._orientation){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.RESIZE_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "orientation";
                }
            };
            this._orientation = null;
        }
        return this.orientation;
    }

    public boolean isGradientBarEnabled() {
        return null == this.gradientBarEnabled ? this._gradientBarEnabled : this.gradientBarEnabled.get();
    }

    public void setGradientBarEnabled(boolean ENABLED) {
        if (null == this.gradientBarEnabled) {
            this._gradientBarEnabled = ENABLED;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.gradientBarEnabled.set(ENABLED);
        }
    }

    public BooleanProperty gradientBarEnabledProperty() {
        if (null == this.gradientBarEnabled) {
            this.gradientBarEnabled = new BooleanPropertyBase(this._gradientBarEnabled){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "gradientBarEnabled";
                }
            };
        }
        return this.gradientBarEnabled;
    }

    public GradientLookup getGradientLookup() {
        if (null == this.gradientLookup) {
            this.gradientLookup = new GradientLookup();
        }
        return this.gradientLookup;
    }

    public void setGradientLookup(GradientLookup GRADIENT_LOOKUP) {
        this.gradientLookup = GRADIENT_LOOKUP;
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public List<Stop> getGradientBarStops() {
        return this.getGradientLookup().getStops();
    }

    public void setGradientBarStops(Stop ... STOPS) {
        this.setGradientBarStops(Arrays.asList(STOPS));
    }

    public void setGradientBarStops(List<Stop> STOPS) {
        this.getGradientLookup().setStops(STOPS);
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public boolean getCustomTickLabelsEnabled() {
        return null == this.customTickLabelsEnabled ? this._customTickLabelsEnabled : this.customTickLabelsEnabled.get();
    }

    public void setCustomTickLabelsEnabled(boolean ENABLED) {
        if (null == this.customTickLabelsEnabled) {
            this._customTickLabelsEnabled = ENABLED;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.customTickLabelsEnabled.set(ENABLED);
        }
    }

    public BooleanProperty getCustomTickLabelsEnabledProperty() {
        if (null == this.customTickLabelsEnabled) {
            this.customTickLabelsEnabled = new BooleanPropertyBase(this._customTickLabelsEnabled){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "customTickLabelsEnabled";
                }
            };
        }
        return this.customTickLabelsEnabled;
    }

    public List<String> getCustomTickLabels() {
        return this.customTickLabels;
    }

    public void setCustomTickLabels(List<String> TICK_LABELS) {
        this.customTickLabels.setAll(TICK_LABELS);
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public void setCustomTickLabels(String ... TICK_LABELS) {
        this.setCustomTickLabels(Arrays.asList(TICK_LABELS));
    }

    public void addCustomTickLabel(String TICK_LABEL) {
        if (null == TICK_LABEL) {
            return;
        }
        if (!this.customTickLabels.contains((Object)TICK_LABEL)) {
            this.customTickLabels.add((Object)TICK_LABEL);
        }
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public void removeCustomTickLabel(String TICK_LABEL) {
        if (null == TICK_LABEL) {
            return;
        }
        if (this.customTickLabels.contains((Object)TICK_LABEL)) {
            this.customTickLabels.remove((Object)TICK_LABEL);
        }
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public void clearCustomTickLabels() {
        this.customTickLabels.clear();
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public double getCustomTickLabelFontSize() {
        return null == this.customTickLabelFontSize ? this._customTickLabelFontSize : this.customTickLabelFontSize.get();
    }

    public void setCustomTickLabelFontSize(double SIZE) {
        if (null == this.customTickLabelFontSize) {
            this._customTickLabelFontSize = Helper.clamp(0.0, 72.0, SIZE);
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.customTickLabelFontSize.set(SIZE);
        }
    }

    public DoubleProperty customTickLabelFontSizeProperty() {
        if (null == this.customTickLabelFontSize) {
            this.customTickLabelFontSize = new DoublePropertyBase(this._customTickLabelFontSize){

                protected void invalidated() {
                    double SIZE = this.get();
                    if (SIZE < 0.0 || SIZE > 72.0) {
                        this.set(Helper.clamp(0.0, 72.0, SIZE));
                    }
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "customTickLabelFontSize";
                }
            };
        }
        return this.customTickLabelFontSize;
    }

    public boolean isInteractive() {
        return null == this.interactive ? this._interactive : this.interactive.get();
    }

    public void setInteractive(boolean INTERACTIVE) {
        if (null == this.interactive) {
            this._interactive = INTERACTIVE;
            this.fireUpdateEvent(this.INTERACTIVITY_EVENT);
        } else {
            this.interactive.set(INTERACTIVE);
        }
    }

    public BooleanProperty interactiveProperty() {
        if (null == this.interactive) {
            this.interactive = new BooleanPropertyBase(this._interactive){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.INTERACTIVITY_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "interactive";
                }
            };
        }
        return this.interactive;
    }

    public String getButtonTooltipText() {
        return null == this.buttonTooltipText ? this._buttonTooltipText : (String)this.buttonTooltipText.get();
    }

    public void setButtonTooltipText(String TEXT) {
        if (null == this.buttonTooltipText) {
            this._buttonTooltipText = TEXT;
            this.fireUpdateEvent(this.REDRAW_EVENT);
        } else {
            this.buttonTooltipText.set((Object)TEXT);
        }
    }

    public StringProperty buttonTooltipTextProperty() {
        if (null == this.buttonTooltipText) {
            this.buttonTooltipText = new StringPropertyBase(this._buttonTooltipText){

                protected void invalidated() {
                    Gauge.this.fireUpdateEvent(Gauge.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "buttonTooltipText";
                }
            };
            this._buttonTooltipText = null;
        }
        return this.buttonTooltipText;
    }

    public boolean isKeepAspect() {
        return null == this.keepAspect ? this._keepAspect : this.keepAspect.get();
    }

    public void setKeepAspect(boolean KEEP) {
        if (null == this.keepAspect) {
            this._keepAspect = KEEP;
        } else {
            this.keepAspect.set(KEEP);
        }
    }

    public BooleanProperty keepAspectProperty() {
        if (null == this.keepAspect) {
            this.keepAspect = new SimpleBooleanProperty((Object)this, "keepAspect", this._keepAspect);
        }
        return this.keepAspect;
    }

    public void calcAutoScale() {
        double maxNoOfMajorTicks = 10.0;
        double maxNoOfMinorTicks = 10.0;
        double niceRange = Helper.calcNiceNumber(this.getRange(), false);
        this.setMajorTickSpace(Helper.calcNiceNumber(niceRange / (maxNoOfMajorTicks - 1.0), true));
        double niceMinValue = Math.floor(this.getMinValue() / this.getMajorTickSpace()) * this.getMajorTickSpace();
        double niceMaxValue = Math.ceil(this.getMaxValue() / this.getMajorTickSpace()) * this.getMajorTickSpace();
        this.setMinorTickSpace(Helper.calcNiceNumber(this.getMajorTickSpace() / (maxNoOfMinorTicks - 1.0), true));
        this.setMinValue(niceMinValue);
        this.setMaxValue(niceMaxValue);
    }

    private synchronized void createBlinkTask() {
        blinkTask = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    Gauge.this.setLedOn(!Gauge.this.isLedOn());
                }
                finally {
                    if (!Thread.currentThread().isInterrupted()) {
                        blinkFuture = blinkService.schedule(this, 500L, TimeUnit.MILLISECONDS);
                    }
                }
                return null;
            }
        };
    }

    private synchronized void startBlinkExecutorService() {
        if (null == blinkTask) {
            this.createBlinkTask();
        }
        if (null == blinkService) {
            blinkService = new ScheduledThreadPoolExecutor(1, Helper.getThreadFactory("BlinkTask", false));
        }
        blinkFuture = blinkService.schedule(blinkTask, 500L, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        this.setLedOn(false);
        if (null != blinkFuture) {
            blinkFuture.cancel(true);
        }
        if (null != blinkService) {
            blinkService.shutdownNow();
        }
    }

    private void createShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.stop()));
    }

    public String toString() {
        return "{" + "\"title\":" + "\"" + this.getTitle() + "\"," + "\"subTitle\":" + "\"" + this.getTitle() + "\"," + "\"unit\":" + "\"" + this.getUnit() + "\"," + "\"value\":" + this.getValue() + "," + "\"minValue\":" + this.getMinValue() + "," + "\"maxValue\":" + this.getMaxValue() + "," + "\"threshold\":" + this.getThreshold() + "," + "\"minMeasuredValue\":" + this.getMinMeasuredValue() + "," + "\"maxMeasuredValue\":" + this.getMaxMeasuredValue() + "}";
    }

    protected Skin createDefaultSkin() {
        switch (this.skinType) {
            case AMP: {
                return new AmpSkin(this);
            }
            case BULLET_CHART: {
                return new BulletChartSkin(this);
            }
            case DASHBOARD: {
                return new DashboardSkin(this);
            }
            case FLAT: {
                return new FlatSkin(this);
            }
            case INDICATOR: {
                return new IndicatorSkin(this);
            }
            case KPI: {
                return new KpiSkin(this);
            }
            case MODERN: {
                return new ModernSkin(this);
            }
            case SIMPLE: {
                return new SimpleSkin(this);
            }
            case SLIM: {
                return new SlimSkin(this);
            }
            case SPACE_X: {
                return new SpaceXSkin(this);
            }
            case QUARTER: {
                return new QuarterSkin(this);
            }
            case HORIZONTAL: {
                return new HSkin(this);
            }
            case VERTICAL: {
                return new VSkin(this);
            }
            case LCD: {
                return new LcdSkin(this);
            }
            case TINY: {
                return new TinySkin(this);
            }
            case BATTERY: {
                return new BatterySkin(this);
            }
            case LEVEL: {
                return new LevelSkin(this);
            }
            case LINEAR: {
                return new LinearSkin(this);
            }
            case DIGITAL: {
                return new DigitalSkin(this);
            }
            case SIMPLE_DIGITAL: {
                return new SimpleDigitalSkin(this);
            }
            case SECTION: {
                return new SectionSkin(this);
            }
            case BAR: {
                return new BarSkin(this);
            }
            case WHITE: {
                return new WhiteSkin(this);
            }
            case CHARGE: {
                return new ChargeSkin(this);
            }
        }
        return new GaugeSkin(this);
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("gauge.css").toExternalForm();
    }

    public SkinType getSkinType() {
        return this.skinType;
    }

    public void setSkinType(SkinType SKIN_TYPE) {
        this.skinType = SKIN_TYPE;
        switch (SKIN_TYPE) {
            case AMP: {
                this.setKnobPosition(Pos.BOTTOM_CENTER);
                this.setTitleColor(Color.WHITE);
                this.setLedVisible(true);
                this.setBackgroundPaint((Paint)Color.WHITE);
                this.setForegroundPaint((Paint)Color.BLACK);
                this.setLcdVisible(true);
                this.setShadowsEnabled(true);
                super.setSkin((Skin)new AmpSkin(this));
                break;
            }
            case BULLET_CHART: {
                this.setKnobPosition(Pos.CENTER);
                this.setBarColor(Color.BLACK);
                this.setThresholdColor(Color.BLACK);
                super.setSkin((Skin)new BulletChartSkin(this));
                break;
            }
            case DASHBOARD: {
                this.setKnobPosition(Pos.BOTTOM_CENTER);
                this.setDecimals(0);
                this.setBarBackgroundColor(Color.LIGHTGRAY);
                this.setBarColor(Color.rgb((int)93, (int)190, (int)205));
                super.setSkin((Skin)new DashboardSkin(this));
                break;
            }
            case FLAT: {
                this.setKnobPosition(Pos.CENTER);
                this.setBarColor(Color.CYAN);
                this.setBackgroundPaint((Paint)Color.TRANSPARENT);
                this.setTitleColor(DARK_COLOR);
                this.setValueColor(DARK_COLOR);
                this.setUnitColor(DARK_COLOR);
                this.setBorderPaint((Paint)Color.rgb((int)208, (int)208, (int)208));
                this.setDecimals(0);
                super.setSkin((Skin)new FlatSkin(this));
                break;
            }
            case INDICATOR: {
                this.setKnobPosition(Pos.BOTTOM_CENTER);
                this.setValueVisible(false);
                this.setGradientBarEnabled(false);
                this.setGradientBarStops(new Stop(0.0, Color.rgb((int)34, (int)180, (int)11)), new Stop(0.5, Color.rgb((int)255, (int)146, (int)0)), new Stop(1.0, Color.rgb((int)255, (int)0, (int)39)));
                this.setTickLabelsVisible(false);
                this.setNeedleColor(Color.rgb((int)71, (int)71, (int)71));
                this.setBarBackgroundColor(Color.rgb((int)232, (int)231, (int)223));
                this.setBarColor(Color.rgb((int)255, (int)0, (int)39));
                this.setAngleRange(180.0);
                super.setSkin((Skin)new IndicatorSkin(this));
                break;
            }
            case KPI: {
                this.setKnobPosition(Pos.BOTTOM_CENTER);
                this.setDecimals(0);
                this.setForegroundBaseColor(Color.rgb((int)126, (int)126, (int)127));
                this.setBarColor(Color.rgb((int)168, (int)204, (int)254));
                this.setThresholdVisible(true);
                this.setThresholdColor(Color.rgb((int)45, (int)86, (int)184));
                this.setNeedleColor(Color.rgb((int)74, (int)74, (int)74));
                this.setAngleRange(128.0);
                super.setSkin((Skin)new KpiSkin(this));
                break;
            }
            case MODERN: {
                this.setKnobPosition(Pos.CENTER);
                this.setDecimals(0);
                this.setValueColor(Color.WHITE);
                this.setTitleColor(Color.WHITE);
                this.setSubTitleColor(Color.WHITE);
                this.setUnitColor(Color.WHITE);
                this.setBarColor(Color.rgb((int)0, (int)214, (int)215));
                this.setNeedleColor(Color.WHITE);
                this.setThresholdColor(Color.rgb((int)204, (int)0, (int)0));
                this.setTickLabelColor(Color.rgb((int)151, (int)151, (int)151));
                this.setTickMarkColor(Color.BLACK);
                this.setTickLabelOrientation(TickLabelOrientation.ORTHOGONAL);
                super.setSkin((Skin)new ModernSkin(this));
                break;
            }
            case SIMPLE: {
                this.setKnobPosition(Pos.CENTER);
                this.setBorderPaint((Paint)Color.WHITE);
                this.setNeedleBorderColor(Color.WHITE);
                this.setBackgroundPaint((Paint)Color.DARKGRAY);
                this.setDecimals(0);
                this.setTickLabelColor(Color.WHITE);
                this.setNeedleColor(Color.web((String)"#5a615f"));
                this.setValueColor(Color.WHITE);
                this.setTitleColor(Color.WHITE);
                this.setSubTitleColor(Color.WHITE);
                super.setSkin((Skin)new SimpleSkin(this));
                break;
            }
            case SLIM: {
                this.setKnobPosition(Pos.CENTER);
                this.setDecimals(2);
                this.setBarBackgroundColor(Color.rgb((int)62, (int)67, (int)73));
                this.setBarColor(Color.rgb((int)93, (int)190, (int)205));
                this.setTitleColor(Color.rgb((int)142, (int)147, (int)151));
                this.setValueColor(Color.rgb((int)228, (int)231, (int)238));
                this.setUnitColor(Color.rgb((int)142, (int)147, (int)151));
                super.setSkin((Skin)new SlimSkin(this));
                break;
            }
            case SPACE_X: {
                this.setKnobPosition(Pos.CENTER);
                this.setDecimals(0);
                this.setThresholdColor(Color.rgb((int)180, (int)0, (int)0));
                this.setBarBackgroundColor(Color.rgb((int)169, (int)169, (int)169, (double)0.25));
                this.setBarColor(Color.rgb((int)169, (int)169, (int)169));
                this.setTitleColor(Color.WHITE);
                this.setValueColor(Color.WHITE);
                this.setUnitColor(Color.WHITE);
                super.setSkin((Skin)new SpaceXSkin(this));
                break;
            }
            case QUARTER: {
                this.setKnobPosition(Pos.BOTTOM_RIGHT);
                this.setAngleRange(90.0);
                super.setSkin((Skin)new QuarterSkin(this));
                break;
            }
            case HORIZONTAL: {
                this.setKnobPosition(Pos.BOTTOM_CENTER);
                this.setAngleRange(180.0);
                super.setSkin((Skin)new HSkin(this));
                break;
            }
            case VERTICAL: {
                this.setKnobPosition(Pos.CENTER_RIGHT);
                this.setAngleRange(180.0);
                super.setSkin((Skin)new VSkin(this));
                break;
            }
            case LCD: {
                this.setDecimals(1);
                this.setTickLabelDecimals(1);
                this.setMinMeasuredValueVisible(true);
                this.setMaxMeasuredValueVisible(true);
                this.setOldValueVisible(true);
                this.setBorderPaint((Paint)Color.WHITE);
                this.setForegroundPaint((Paint)Color.WHITE);
                super.setSkin((Skin)new LcdSkin(this));
                break;
            }
            case TINY: {
                this.setBorderWidth(24.0);
                this.setBackgroundPaint((Paint)Color.rgb((int)216, (int)216, (int)216));
                this.setBorderPaint((Paint)Color.rgb((int)76, (int)76, (int)76));
                this.setBarBackgroundColor(Color.rgb((int)76, (int)76, (int)76, (double)0.2));
                this.setNeedleColor(Color.rgb((int)76, (int)76, (int)76));
                this.setSectionsVisible(true);
                this.setMajorTickMarksVisible(true);
                this.setMajorTickMarkColor(Color.WHITE);
                super.setSkin((Skin)new TinySkin(this));
                break;
            }
            case BATTERY: {
                this.setBarBackgroundColor(Color.BLACK);
                this.setBarColor(Color.BLACK);
                this.setValueColor(Color.WHITE);
                super.setSkin((Skin)new BatterySkin(this));
                break;
            }
            case LEVEL: {
                this.setValueColor(Color.WHITE);
                this.setBarColor(Color.CYAN);
                super.setSkin((Skin)new LevelSkin(this));
                break;
            }
            case LINEAR: {
                this.setOrientation(Orientation.VERTICAL);
                this.setBarColor(DARK_COLOR);
                this.setBarEffectEnabled(true);
                super.setSkin((Skin)new LinearSkin(this));
                break;
            }
            case DIGITAL: {
                this.setBarColor(DARK_COLOR);
                super.setSkin((Skin)new DigitalSkin(this));
                break;
            }
            case SIMPLE_DIGITAL: {
                this.setBarColor(DARK_COLOR);
                super.setSkin((Skin)new SimpleDigitalSkin(this));
                break;
            }
            case SECTION: {
                this.setBackgroundPaint((Paint)DARK_COLOR);
                this.setAutoScale(false);
                this.setValueVisible(false);
                this.setKnobColor(Color.rgb((int)82, (int)82, (int)84));
                this.setSectionsVisible(true);
                this.setSectionTextVisible(true);
                super.setSkin((Skin)new SectionSkin(this));
                break;
            }
            case BAR: {
                Color barColor = this.getBarColor();
                this.setAnimated(true);
                this.setAnimationDuration(1000L);
                this.setMinValue(0.0);
                this.setMaxValue(100.0);
                this.setGradientBarEnabled(true);
                this.setGradientBarStops(new Stop(0.0, barColor), new Stop(0.01, barColor), new Stop(0.75, barColor.deriveColor(-10.0, 1.0, 1.0, 1.0)), new Stop(1.0, barColor.deriveColor(-20.0, 1.0, 1.0, 1.0)));
                super.setSkin((Skin)new BarSkin(this));
                break;
            }
            case WHITE: {
                this.setAnimated(true);
                this.setAnimationDuration(1000L);
                this.setAngleRange(360.0);
                this.setMinValue(0.0);
                this.setMaxValue(100.0);
                this.setBarColor(Color.WHITE);
                this.setValueColor(Color.WHITE);
                this.setUnitColor(Color.WHITE);
                super.setSkin((Skin)new WhiteSkin(this));
                break;
            }
            case CHARGE: {
                this.setAnimated(true);
                this.setMinValue(0.0);
                this.setMaxValue(1.0);
                super.setSkin((Skin)new ChargeSkin(this));
                break;
            }
            default: {
                super.setSkin((Skin)new GaugeSkin(this));
            }
        }
    }

    public void setOnUpdate(UpdateEventListener LISTENER) {
        this.addUpdateEventListener(LISTENER);
    }

    public void addUpdateEventListener(UpdateEventListener LISTENER) {
        if (!this.listenerList.contains(LISTENER)) {
            this.listenerList.add(LISTENER);
        }
    }

    public void removeUpdateEventListener(UpdateEventListener LISTENER) {
        if (this.listenerList.contains(LISTENER)) {
            this.listenerList.remove(LISTENER);
        }
    }

    public void fireUpdateEvent(UpdateEvent EVENT) {
        int listSize = this.listenerList.size();
        for (int i = 0; i < listSize; ++i) {
            this.listenerList.get(i).onUpdateEvent(EVENT);
        }
    }

    public void setOnButtonPressed(EventHandler<ButtonEvent> HANDLER) {
        this.addEventHandler(ButtonEvent.BTN_PRESSED, HANDLER);
    }

    public void removeOnButtonPressed(EventHandler<ButtonEvent> HANDLER) {
        this.removeEventHandler(ButtonEvent.BTN_PRESSED, HANDLER);
    }

    public void setOnButtonReleased(EventHandler<ButtonEvent> HANDLER) {
        this.addEventHandler(ButtonEvent.BTN_RELEASED, HANDLER);
    }

    public void removeOnButtonReleased(EventHandler<ButtonEvent> HANDLER) {
        this.removeEventHandler(ButtonEvent.BTN_RELEASED, HANDLER);
    }

    public void setOnThresholdExceeded(EventHandler<ThresholdEvent> HANDLER) {
        this.addEventHandler(ThresholdEvent.THRESHOLD_EXCEEDED, HANDLER);
    }

    public void removeOnThresholdExceeded(EventHandler<ThresholdEvent> HANDLER) {
        this.removeEventHandler(ThresholdEvent.THRESHOLD_EXCEEDED, HANDLER);
    }

    public void setOnThresholdUnderrun(EventHandler<ThresholdEvent> HANDLER) {
        this.addEventHandler(ThresholdEvent.THRESHOLD_UNDERRUN, HANDLER);
    }

    public void removeOnThresholdUnderrun(EventHandler<ThresholdEvent> HANDLER) {
        this.removeEventHandler(ThresholdEvent.THRESHOLD_UNDERRUN, HANDLER);
    }

    static {
        blinkService = new ScheduledThreadPoolExecutor(1, Helper.getThreadFactory("BlinkTask", false));
    }

    public static class ThresholdEvent
    extends Event {
        public static final EventType<ThresholdEvent> THRESHOLD_EXCEEDED = new EventType(ANY, "THRESHOLD_EXCEEDED");
        public static final EventType<ThresholdEvent> THRESHOLD_UNDERRUN = new EventType(ANY, "THRESHOLD_UNDERRUN");

        public ThresholdEvent(EventType<ThresholdEvent> TYPE) {
            super(TYPE);
        }

        public ThresholdEvent(Object SOURCE, EventTarget TARGET, EventType<ThresholdEvent> TYPE) {
            super(SOURCE, TARGET, TYPE);
        }
    }

    public static class ButtonEvent
    extends Event {
        public static final EventType<ButtonEvent> BTN_PRESSED = new EventType(ANY, "BTN_PRESSED");
        public static final EventType<ButtonEvent> BTN_RELEASED = new EventType(ANY, "BTN_RELEASED");

        public ButtonEvent(EventType<ButtonEvent> TYPE) {
            super(TYPE);
        }

        public ButtonEvent(Object SOURCE, EventTarget TARGET, EventType<ButtonEvent> TYPE) {
            super(SOURCE, TARGET, TYPE);
        }
    }

    public static enum SkinType {
        AMP,
        BULLET_CHART,
        DASHBOARD,
        FLAT,
        GAUGE,
        INDICATOR,
        KPI,
        MODERN,
        SIMPLE,
        SLIM,
        SPACE_X,
        QUARTER,
        HORIZONTAL,
        VERTICAL,
        LCD,
        TINY,
        BATTERY,
        LEVEL,
        LINEAR,
        DIGITAL,
        SIMPLE_DIGITAL,
        SECTION,
        BAR,
        WHITE,
        CHARGE;

    }

    public static enum ScaleDirection {
        CLOCKWISE,
        COUNTER_CLOCKWISE,
        LEFT_TO_RIGHT,
        RIGHT_TO_LEFT,
        BOTTOM_TO_TOP,
        TOP_TO_BOTTOM;

    }

    public static enum LedType {
        STANDARD,
        FLAT;

    }

    public static enum KnobType {
        STANDARD,
        PLAIN,
        METAL,
        FLAT;

    }

    public static enum NeedleBehavior {
        STANDARD,
        OPTIMIZED;

    }

    public static enum NeedleSize {
        THIN(0.015),
        STANDARD(0.025),
        THICK(0.05);

        public final double FACTOR;

        private NeedleSize(double FACTOR) {
            this.FACTOR = FACTOR;
        }
    }

    public static enum NeedleShape {
        ANGLED,
        ROUND,
        FLAT;

    }

    public static enum NeedleType {
        BIG,
        FAT,
        STANDARD,
        SCIENTIFIC,
        AVIONIC,
        VARIOMETER;

    }
}

