/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.Marker;
import eu.hansolo.medusa.Needle;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.TickLabelLocation;
import eu.hansolo.medusa.tools.AngleConicalGradient;
import eu.hansolo.medusa.tools.Helper;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;

public class VSkin
extends SkinBase<Gauge>
implements Skin<Gauge> {
    private static final double PREFERRED_WIDTH = 125.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final double ASPECT_RATIO = 2.0;
    private Map<Marker, Shape> markerMap = new ConcurrentHashMap<Marker, Shape>();
    private double oldValue;
    private double width;
    private double height;
    private Pane pane;
    private InnerShadow backgroundInnerShadow;
    private Canvas sectionsAndAreasCanvas;
    private GraphicsContext sectionsAndAreasCtx;
    private Canvas tickMarkCanvas;
    private GraphicsContext tickMarkCtx;
    private double ledSize;
    private InnerShadow ledOnShadow;
    private InnerShadow ledOffShadow;
    private Paint ledFramePaint;
    private Paint ledOnPaint;
    private Paint ledOffPaint;
    private Paint ledHighlightPaint;
    private Canvas ledCanvas;
    private GraphicsContext ledCtx;
    private Pane markerPane;
    private Path threshold;
    private Path needle;
    private Rotate needleRotate;
    private Paint needlePaint;
    private Canvas knobCanvas;
    private GraphicsContext knobCtx;
    private Group shadowGroup;
    private DropShadow dropShadow;
    private Text titleText;
    private Text unitText;
    private Text valueText;
    private double startAngle;
    private double angleRange;
    private double angleStep;
    private EventHandler<MouseEvent> mouseHandler;
    private Tooltip buttonTooltip;
    private Tooltip thresholdTooltip;
    private String formatString;
    private Locale locale;
    private double minValue;
    private double maxValue;
    private List<Section> sections;
    private boolean highlightSections;
    private boolean sectionsVisible;
    private List<Section> areas;
    private boolean highlightAreas;
    private boolean areasVisible;
    private TickLabelLocation tickLabelLocation;
    private Gauge.ScaleDirection scaleDirection;

    public VSkin(Gauge gauge) {
        super((Control)gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.angleRange = Helper.clamp(90.0, 180.0, gauge.getAngleRange());
        this.startAngle = this.getStartAngle();
        this.angleStep = this.angleRange / gauge.getRange();
        this.oldValue = gauge.getValue();
        this.minValue = gauge.getMinValue();
        this.maxValue = gauge.getMaxValue();
        this.formatString = "%." + Integer.toString(gauge.getDecimals()) + "f";
        this.locale = gauge.getLocale();
        this.sections = gauge.getSections();
        this.highlightSections = gauge.isHighlightSections();
        this.sectionsVisible = gauge.getSectionsVisible();
        this.areas = gauge.getAreas();
        this.highlightAreas = gauge.isHighlightAreas();
        this.areasVisible = gauge.getAreasVisible();
        this.tickLabelLocation = gauge.getTickLabelLocation();
        this.scaleDirection = gauge.getScaleDirection();
        this.mouseHandler = event -> this.handleMouseEvent((MouseEvent)event);
        this.updateMarkers();
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if ((Double.compare(((Gauge)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getHeight(), 0.0) <= 0) && ((Gauge)this.getSkinnable()).getPrefWidth() < 0.0 && ((Gauge)this.getSkinnable()).getPrefHeight() < 0.0) {
            ((Gauge)this.getSkinnable()).setPrefSize(125.0, 250.0);
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMinSize(50.0, 50.0);
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.backgroundInnerShadow = new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)10, (int)10, (int)10, (double)0.45), 8.0, 0.0, 8.0, 0.0);
        this.sectionsAndAreasCanvas = new Canvas();
        this.sectionsAndAreasCtx = this.sectionsAndAreasCanvas.getGraphicsContext2D();
        Helper.enableNode((Node)this.sectionsAndAreasCanvas, this.areasVisible | this.sectionsVisible);
        this.tickMarkCanvas = new Canvas();
        this.tickMarkCtx = this.tickMarkCanvas.getGraphicsContext2D();
        this.ledCanvas = new Canvas();
        this.ledCtx = this.ledCanvas.getGraphicsContext2D();
        Helper.enableNode((Node)this.ledCanvas, ((Gauge)this.getSkinnable()).isLedVisible());
        this.thresholdTooltip = new Tooltip("Threshold\n(" + String.format(this.locale, this.formatString, ((Gauge)this.getSkinnable()).getThreshold()) + ")");
        this.thresholdTooltip.setTextAlignment(TextAlignment.CENTER);
        this.threshold = new Path();
        Helper.enableNode((Node)this.threshold, ((Gauge)this.getSkinnable()).isThresholdVisible());
        Tooltip.install((Node)this.threshold, (Tooltip)this.thresholdTooltip);
        this.markerPane = new Pane();
        this.needleRotate = new Rotate(180.0 - this.startAngle);
        this.needleRotate.setAngle(this.needleRotate.getAngle() + (((Gauge)this.getSkinnable()).getValue() - this.oldValue - this.minValue) * this.angleStep);
        this.needle = new Path();
        this.needle.setFillRule(FillRule.EVEN_ODD);
        this.needle.getTransforms().setAll((Object[])new Transform[]{this.needleRotate});
        this.needle.setStrokeType(StrokeType.INSIDE);
        this.needle.setStroke((Paint)Color.TRANSPARENT);
        this.buttonTooltip = new Tooltip();
        this.buttonTooltip.setTextAlignment(TextAlignment.CENTER);
        this.knobCanvas = new Canvas();
        this.knobCtx = this.knobCanvas.getGraphicsContext2D();
        this.knobCanvas.setPickOnBounds(false);
        Helper.enableNode((Node)this.knobCanvas, ((Gauge)this.getSkinnable()).isKnobVisible());
        this.dropShadow = new DropShadow();
        this.dropShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.25));
        this.dropShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.dropShadow.setRadius(1.875);
        this.dropShadow.setOffsetY(1.875);
        this.shadowGroup = new Group(new Node[]{this.needle, this.knobCanvas});
        this.shadowGroup.setEffect((Effect)(((Gauge)this.getSkinnable()).isShadowsEnabled() ? this.dropShadow : null));
        this.titleText = new Text(((Gauge)this.getSkinnable()).getTitle());
        this.titleText.setTextOrigin(VPos.CENTER);
        this.titleText.setMouseTransparent(true);
        this.unitText = new Text(((Gauge)this.getSkinnable()).getUnit());
        this.unitText.setMouseTransparent(true);
        this.unitText.setTextOrigin(VPos.CENTER);
        this.unitText.setMouseTransparent(true);
        this.valueText = new Text(String.format(this.locale, this.formatString, ((Gauge)this.getSkinnable()).getValue()));
        this.valueText.setMouseTransparent(true);
        this.valueText.setTextOrigin(VPos.CENTER);
        this.valueText.setMouseTransparent(true);
        double targetAngle = 180.0 - this.startAngle + (((Gauge)this.getSkinnable()).getCurrentValue() - this.minValue) * this.angleStep;
        targetAngle = Helper.clamp(180.0 - this.startAngle, 180.0 - this.startAngle + this.angleRange, targetAngle);
        this.needleRotate.setAngle(targetAngle);
        this.pane = new Pane(new Node[]{this.sectionsAndAreasCanvas, this.tickMarkCanvas, this.markerPane, this.ledCanvas, this.titleText, this.unitText, this.valueText, this.shadowGroup});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Gauge)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(((Gauge)this.getSkinnable()).getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((Gauge)this.getSkinnable()).widthProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).heightProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).getMarkers().addListener(c -> {
            this.updateMarkers();
            this.redraw();
        });
        ((Gauge)this.getSkinnable()).setOnUpdate(e -> this.handleEvents(e.eventType.name()));
        ((Gauge)this.getSkinnable()).currentValueProperty().addListener(e -> this.rotateNeedle(((Gauge)this.getSkinnable()).getCurrentValue()));
        this.handleEvents("INTERACTIVITY");
        this.handleEvents("VISIBILITY");
    }

    protected void handleEvents(String EVENT_TYPE) {
        if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
            this.redraw();
        } else if ("FINISHED".equals(EVENT_TYPE)) {
            int i;
            int listSize;
            double currentValue = ((Gauge)this.getSkinnable()).getCurrentValue();
            if (((Gauge)this.getSkinnable()).getCheckSectionsForValue()) {
                listSize = this.sections.size();
                for (i = 0; i < listSize; ++i) {
                    this.sections.get(i).checkForValue(currentValue);
                }
            }
            if (((Gauge)this.getSkinnable()).getCheckAreasForValue()) {
                listSize = this.areas.size();
                for (i = 0; i < listSize; ++i) {
                    this.areas.get(i).checkForValue(currentValue);
                }
            }
            if (this.highlightSections | this.highlightAreas) {
                this.sectionsAndAreasCtx.clearRect(0.0, 0.0, this.height, this.height);
                this.drawAreasAndSections(this.sectionsAndAreasCtx);
            }
        } else if ("REDRAW".equals(EVENT_TYPE)) {
            this.redraw();
        } else if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.ledCanvas, ((Gauge)this.getSkinnable()).isLedVisible());
            Helper.enableNode((Node)this.titleText, !((Gauge)this.getSkinnable()).getTitle().isEmpty());
            Helper.enableNode((Node)this.unitText, !((Gauge)this.getSkinnable()).getUnit().isEmpty());
            Helper.enableNode((Node)this.valueText, ((Gauge)this.getSkinnable()).isValueVisible());
            Helper.enableNode((Node)this.knobCanvas, ((Gauge)this.getSkinnable()).isKnobVisible());
            Helper.enableNode((Node)this.threshold, ((Gauge)this.getSkinnable()).isThresholdVisible());
            Helper.enableNode((Node)this.sectionsAndAreasCanvas, this.areasVisible | this.sectionsVisible);
            boolean markersVisible = ((Gauge)this.getSkinnable()).getMarkersVisible();
            for (Shape shape : this.markerMap.values()) {
                Helper.enableNode((Node)shape, markersVisible);
            }
            this.redraw();
        } else if ("LED".equals(EVENT_TYPE)) {
            if (((Gauge)this.getSkinnable()).isLedVisible()) {
                this.drawLed();
            }
        } else if ("RECALC".equals(EVENT_TYPE)) {
            if (((Gauge)this.getSkinnable()).isAutoScale()) {
                ((Gauge)this.getSkinnable()).calcAutoScale();
            }
            this.angleRange = Helper.clamp(90.0, 180.0, ((Gauge)this.getSkinnable()).getAngleRange());
            this.startAngle = this.getStartAngle();
            this.minValue = ((Gauge)this.getSkinnable()).getMinValue();
            this.maxValue = ((Gauge)this.getSkinnable()).getMaxValue();
            this.angleStep = this.angleRange / ((Gauge)this.getSkinnable()).getRange();
            this.needleRotate.setAngle(180.0 - this.startAngle + (((Gauge)this.getSkinnable()).getValue() - this.minValue) * this.angleStep);
            if (((Gauge)this.getSkinnable()).getValue() < this.minValue) {
                ((Gauge)this.getSkinnable()).setValue(this.minValue);
                this.oldValue = this.minValue;
            }
            if (((Gauge)this.getSkinnable()).getValue() > this.maxValue) {
                ((Gauge)this.getSkinnable()).setValue(this.maxValue);
                this.oldValue = this.maxValue;
            }
            this.resize();
            this.redraw();
        } else if ("SECTION".equals(EVENT_TYPE)) {
            this.sections = ((Gauge)this.getSkinnable()).getSections();
            this.highlightSections = ((Gauge)this.getSkinnable()).isHighlightSections();
            this.sectionsVisible = ((Gauge)this.getSkinnable()).getSectionsVisible();
            this.areas = ((Gauge)this.getSkinnable()).getAreas();
            this.highlightAreas = ((Gauge)this.getSkinnable()).isHighlightAreas();
            this.areasVisible = ((Gauge)this.getSkinnable()).getAreasVisible();
            this.resize();
            this.redraw();
        } else if ("INTERACTIVITY".equals(EVENT_TYPE)) {
            if (((Gauge)this.getSkinnable()).isInteractive()) {
                this.knobCanvas.setOnMousePressed(this.mouseHandler);
                this.knobCanvas.setOnMouseReleased(this.mouseHandler);
                if (!((Gauge)this.getSkinnable()).getButtonTooltipText().isEmpty()) {
                    this.buttonTooltip.setText(((Gauge)this.getSkinnable()).getButtonTooltipText());
                    Tooltip.install((Node)this.knobCanvas, (Tooltip)this.buttonTooltip);
                }
            } else {
                this.knobCanvas.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
                this.knobCanvas.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseHandler);
                Tooltip.uninstall((Node)this.knobCanvas, (Tooltip)this.buttonTooltip);
            }
        }
    }

    public void handleMouseEvent(MouseEvent EVENT) {
        if (((Gauge)this.getSkinnable()).isDisabled()) {
            return;
        }
        EventType TYPE = EVENT.getEventType();
        if (MouseEvent.MOUSE_PRESSED == TYPE) {
            ((Gauge)this.getSkinnable()).fireEvent(((Gauge)this.getSkinnable()).BTN_PRESSED_EVENT);
            this.drawKnob(true);
        } else if (MouseEvent.MOUSE_RELEASED == TYPE) {
            ((Gauge)this.getSkinnable()).fireEvent(((Gauge)this.getSkinnable()).BTN_RELEASED_EVENT);
            this.drawKnob(false);
        }
    }

    private double getStartAngle() {
        Gauge.ScaleDirection scaleDirection = ((Gauge)this.getSkinnable()).getScaleDirection();
        Pos knobPosition = ((Gauge)this.getSkinnable()).getKnobPosition();
        switch (knobPosition) {
            case CENTER_LEFT: {
                return Gauge.ScaleDirection.CLOCKWISE == scaleDirection ? this.angleRange * 0.5 + 90.0 : 90.0 - this.angleRange * 0.5;
            }
        }
        return Gauge.ScaleDirection.CLOCKWISE == scaleDirection ? this.angleRange * 0.5 - 90.0 : 270.0 - this.angleRange * 0.5;
    }

    private void rotateNeedle(double VALUE) {
        double targetAngle;
        double startOffsetAngle = 180.0 - this.startAngle;
        if (Gauge.ScaleDirection.CLOCKWISE == ((Gauge)this.getSkinnable()).getScaleDirection()) {
            targetAngle = startOffsetAngle + (VALUE - this.minValue) * this.angleStep;
            targetAngle = Helper.clamp(startOffsetAngle, startOffsetAngle + this.angleRange, targetAngle);
        } else {
            targetAngle = startOffsetAngle - (VALUE - this.minValue) * this.angleStep;
            targetAngle = Helper.clamp(startOffsetAngle - this.angleRange, startOffsetAngle, targetAngle);
        }
        this.needleRotate.setAngle(targetAngle);
        this.valueText.setText(String.format(this.locale, this.formatString, VALUE));
        this.valueText.setTranslateX(Pos.CENTER_LEFT == ((Gauge)this.getSkinnable()).getKnobPosition() ? this.width * 0.6 - this.valueText.getLayoutBounds().getWidth() : this.width * 0.9 - this.valueText.getLayoutBounds().getWidth());
    }

    private void drawGradientBar() {
        TickLabelLocation tickLabelLocation = ((Gauge)this.getSkinnable()).getTickLabelLocation();
        double scaledHeight = this.height * 0.9;
        double xy = TickLabelLocation.OUTSIDE == tickLabelLocation ? 0.1705 * scaledHeight : 0.107 * scaledHeight;
        double wh = TickLabelLocation.OUTSIDE == tickLabelLocation ? scaledHeight * 0.77 : scaledHeight * 0.897;
        double offset = 90.0 - this.startAngle;
        double offsetX = -0.1 * this.width;
        double knobPositionOffsetCW = Pos.CENTER_LEFT == ((Gauge)this.getSkinnable()).getKnobPosition() ? 90.0 : 270.0;
        double knobPositionOffsetCCW = Pos.CENTER_LEFT == ((Gauge)this.getSkinnable()).getKnobPosition() ? 180.0 : 0.0;
        Gauge.ScaleDirection scaleDirection = ((Gauge)this.getSkinnable()).getScaleDirection();
        List<Stop> stops = ((Gauge)this.getSkinnable()).getGradientBarStops();
        HashMap<Double, Color> stopAngleMap = new HashMap<Double, Color>(stops.size());
        for (Stop stop : stops) {
            stopAngleMap.put(stop.getOffset() * this.angleRange, stop.getColor());
        }
        double offsetFactor = Gauge.ScaleDirection.CLOCKWISE == scaleDirection ? knobPositionOffsetCW - this.angleRange * 0.5 : this.angleRange - this.angleRange / 180.0 * this.angleRange + knobPositionOffsetCCW;
        AngleConicalGradient gradient = new AngleConicalGradient(this.width * 0.5, this.width * 0.5, offsetFactor, stopAngleMap, ((Gauge)this.getSkinnable()).getScaleDirection());
        double barStartAngle = Gauge.ScaleDirection.CLOCKWISE == scaleDirection ? -this.minValue * this.angleStep : this.minValue * this.angleStep;
        double barAngleExtend = Gauge.ScaleDirection.CLOCKWISE == scaleDirection ? ((Gauge)this.getSkinnable()).getRange() * this.angleStep : -((Gauge)this.getSkinnable()).getRange() * this.angleStep;
        this.tickMarkCtx.save();
        this.tickMarkCtx.setStroke((Paint)gradient.getImagePattern(new Rectangle(xy - 0.026 * this.height + offsetX, xy - 0.026 * this.height, wh + 0.052 * this.height, wh + 0.052 * this.height)));
        this.tickMarkCtx.setLineWidth(scaledHeight * 0.052);
        this.tickMarkCtx.setLineCap(StrokeLineCap.BUTT);
        this.tickMarkCtx.strokeArc(xy + offsetX, xy, wh, wh, -(offset + barStartAngle), -barAngleExtend, ArcType.OPEN);
        this.tickMarkCtx.restore();
    }

    private void drawAreasAndSections(GraphicsContext CTX) {
        int listSize;
        double wh;
        double xy;
        if (this.areas.isEmpty() && this.sections.isEmpty()) {
            return;
        }
        double value = ((Gauge)this.getSkinnable()).getCurrentValue();
        double scaledHeight = this.height * 0.9;
        double offset = 90.0 - this.startAngle;
        double offsetX = -0.1 * this.width;
        double offsetY = 0.1 * this.width;
        if (this.areasVisible && !this.areas.isEmpty()) {
            xy = TickLabelLocation.OUTSIDE == this.tickLabelLocation ? 0.0895 * scaledHeight : 0.025 * scaledHeight;
            wh = TickLabelLocation.OUTSIDE == this.tickLabelLocation ? scaledHeight * 0.821 : scaledHeight * 0.95;
            listSize = this.areas.size();
            for (int i = 0; i < listSize; ++i) {
                double areaStartAngle;
                Section area = this.areas.get(i);
                if (Double.compare(area.getStart(), this.maxValue) > 0 || Double.compare(area.getStop(), this.minValue) < 0) continue;
                if (area.getStart() < this.minValue && area.getStop() < this.maxValue) {
                    areaStartAngle = 0.0;
                } else {
                    double d = areaStartAngle = Gauge.ScaleDirection.CLOCKWISE == this.scaleDirection ? (area.getStart() - this.minValue) * this.angleStep : -(area.getStart() - this.minValue) * this.angleStep;
                }
                double areaAngleExtend = area.getStop() > this.maxValue ? (Gauge.ScaleDirection.CLOCKWISE == this.scaleDirection ? (this.maxValue - area.getStart()) * this.angleStep : -(this.maxValue - area.getStart()) * this.angleStep) : (Double.compare(area.getStart(), this.minValue) < 0 ? (Gauge.ScaleDirection.CLOCKWISE == this.scaleDirection ? (area.getStop() - this.minValue) * this.angleStep : -(area.getStop() - this.minValue) * this.angleStep) : (Gauge.ScaleDirection.CLOCKWISE == this.scaleDirection ? (area.getStop() - area.getStart()) * this.angleStep : -(area.getStop() - area.getStart()) * this.angleStep));
                CTX.save();
                if (this.highlightAreas) {
                    CTX.setFill((Paint)(area.contains(value) ? area.getHighlightColor() : area.getColor()));
                } else {
                    CTX.setFill((Paint)area.getColor());
                }
                CTX.fillArc(xy, xy + offsetY, wh, wh, -(offset + areaStartAngle), -areaAngleExtend, ArcType.ROUND);
                CTX.restore();
            }
        }
        if (this.sectionsVisible && !this.sections.isEmpty()) {
            TickLabelLocation tickLabelLocation = ((Gauge)this.getSkinnable()).getTickLabelLocation();
            xy = TickLabelLocation.OUTSIDE == tickLabelLocation ? 0.1705 * scaledHeight : 0.107 * scaledHeight;
            wh = TickLabelLocation.OUTSIDE == tickLabelLocation ? scaledHeight * 0.77 : scaledHeight * 0.897;
            listSize = this.sections.size();
            CTX.setLineWidth(scaledHeight * 0.052);
            CTX.setLineCap(StrokeLineCap.BUTT);
            for (int i = 0; i < listSize; ++i) {
                double sectionStartAngle;
                Section section = this.sections.get(i);
                if (Double.compare(section.getStart(), this.maxValue) > 0 || Double.compare(section.getStop(), this.minValue) < 0) continue;
                if (Double.compare(section.getStart(), this.minValue) < 0 && Double.compare(section.getStop(), this.maxValue) < 0) {
                    sectionStartAngle = 0.0;
                } else {
                    double d = sectionStartAngle = Gauge.ScaleDirection.CLOCKWISE == this.scaleDirection ? (section.getStart() - this.minValue) * this.angleStep : -(section.getStart() - this.minValue) * this.angleStep;
                }
                double sectionAngleExtend = Double.compare(section.getStop(), this.maxValue) > 0 ? (Gauge.ScaleDirection.CLOCKWISE == this.scaleDirection ? (this.maxValue - section.getStart()) * this.angleStep : -(this.maxValue - section.getStart()) * this.angleStep) : (Double.compare(section.getStart(), this.minValue) < 0 ? (Gauge.ScaleDirection.CLOCKWISE == this.scaleDirection ? (section.getStop() - this.minValue) * this.angleStep : -(section.getStop() - this.minValue) * this.angleStep) : (Gauge.ScaleDirection.CLOCKWISE == this.scaleDirection ? (section.getStop() - section.getStart()) * this.angleStep : -(section.getStop() - section.getStart()) * this.angleStep));
                CTX.save();
                if (this.highlightSections) {
                    CTX.setStroke((Paint)(section.contains(value) ? section.getHighlightColor() : section.getColor()));
                } else {
                    CTX.setStroke((Paint)section.getColor());
                }
                CTX.strokeArc(xy + offsetX, xy, wh, wh, -(offset + sectionStartAngle), -sectionAngleExtend, ArcType.OPEN);
                CTX.restore();
            }
        }
    }

    private void drawLed() {
        boolean isFlatLed;
        this.ledCtx.clearRect(0.0, 0.0, this.ledSize, this.ledSize);
        boolean bl = isFlatLed = Gauge.LedType.FLAT == ((Gauge)this.getSkinnable()).getLedType();
        if (!isFlatLed) {
            this.ledCtx.setFill(this.ledFramePaint);
            this.ledCtx.fillOval(0.0, 0.0, this.ledSize, this.ledSize);
        } else {
            double lineWidth = 0.0037037 * this.width;
            this.ledCtx.setStroke(this.ledFramePaint);
            this.ledCtx.setLineWidth(lineWidth);
            this.ledCtx.strokeOval(lineWidth, lineWidth, this.ledSize - 2.0 * lineWidth, this.ledSize - 2.0 * lineWidth);
        }
        this.ledCtx.save();
        if (((Gauge)this.getSkinnable()).isLedOn()) {
            this.ledCtx.setEffect((Effect)this.ledOnShadow);
            this.ledCtx.setFill(this.ledOnPaint);
        } else {
            this.ledCtx.setEffect((Effect)this.ledOffShadow);
            this.ledCtx.setFill(this.ledOffPaint);
        }
        if (isFlatLed) {
            this.ledCtx.fillOval(0.2 * this.ledSize, 0.2 * this.ledSize, 0.6 * this.ledSize, 0.6 * this.ledSize);
        } else {
            this.ledCtx.fillOval(0.14 * this.ledSize, 0.14 * this.ledSize, 0.72 * this.ledSize, 0.72 * this.ledSize);
        }
        this.ledCtx.restore();
        this.ledCtx.setFill(this.ledHighlightPaint);
        this.ledCtx.fillOval(0.21 * this.ledSize, 0.21 * this.ledSize, 0.58 * this.ledSize, 0.58 * this.ledSize);
    }

    private void drawMarkers() {
        this.markerPane.getChildren().setAll(this.markerMap.values());
        this.markerPane.getChildren().add((Object)this.threshold);
        TickLabelLocation tickLabelLocation = ((Gauge)this.getSkinnable()).getTickLabelLocation();
        double markerSize = TickLabelLocation.OUTSIDE == tickLabelLocation ? 0.0125 * this.height : 0.015 * this.height;
        double pathHalf = markerSize * 0.3;
        double scaledHeight = this.height * 0.9;
        double centerX = Pos.CENTER_LEFT == ((Gauge)this.getSkinnable()).getKnobPosition() ? this.width * 0.1 : this.width * 0.9;
        double centerY = this.height * 0.5;
        Gauge.ScaleDirection scaleDirection = ((Gauge)this.getSkinnable()).getScaleDirection();
        if (((Gauge)this.getSkinnable()).getMarkersVisible()) {
            for (Map.Entry<Marker, Shape> entry : this.markerMap.entrySet()) {
                Marker marker = entry.getKey();
                Shape shape = entry.getValue();
                double valueAngle = Gauge.ScaleDirection.CLOCKWISE == scaleDirection ? this.startAngle - (marker.getValue() - this.minValue) * this.angleStep : this.startAngle + (marker.getValue() - this.minValue) * this.angleStep;
                double sinValue = Math.sin(Math.toRadians(valueAngle));
                double cosValue = Math.cos(Math.toRadians(valueAngle));
                block0 : switch (marker.getMarkerType()) {
                    case TRIANGLE: {
                        Path triangle = (Path)shape;
                        triangle.getElements().clear();
                        switch (tickLabelLocation) {
                            case OUTSIDE: {
                                triangle.getElements().add((Object)new MoveTo(centerX + scaledHeight * 0.38 * sinValue, centerY + scaledHeight * 0.38 * cosValue));
                                sinValue = Math.sin(Math.toRadians(valueAngle - pathHalf));
                                cosValue = Math.cos(Math.toRadians(valueAngle - pathHalf));
                                triangle.getElements().add((Object)new LineTo(centerX + scaledHeight * 0.4075 * sinValue, centerY + scaledHeight * 0.4075 * cosValue));
                                sinValue = Math.sin(Math.toRadians(valueAngle + pathHalf));
                                cosValue = Math.cos(Math.toRadians(valueAngle + pathHalf));
                                triangle.getElements().add((Object)new LineTo(centerX + scaledHeight * 0.4075 * sinValue, centerY + scaledHeight * 0.4075 * cosValue));
                                triangle.getElements().add((Object)new ClosePath());
                                break block0;
                            }
                        }
                        triangle.getElements().add((Object)new MoveTo(centerX + scaledHeight * 0.465 * sinValue, centerY + scaledHeight * 0.465 * cosValue));
                        sinValue = Math.sin(Math.toRadians(valueAngle - pathHalf));
                        cosValue = Math.cos(Math.toRadians(valueAngle - pathHalf));
                        triangle.getElements().add((Object)new LineTo(centerX + scaledHeight * 0.436 * sinValue, centerY + scaledHeight * 0.436 * cosValue));
                        sinValue = Math.sin(Math.toRadians(valueAngle + pathHalf));
                        cosValue = Math.cos(Math.toRadians(valueAngle + pathHalf));
                        triangle.getElements().add((Object)new LineTo(centerX + scaledHeight * 0.436 * sinValue, centerY + scaledHeight * 0.436 * cosValue));
                        triangle.getElements().add((Object)new ClosePath());
                        break;
                    }
                    case DOT: {
                        Circle dot = (Circle)shape;
                        dot.setRadius(markerSize);
                        switch (tickLabelLocation) {
                            case OUTSIDE: {
                                dot.setCenterX(centerX + scaledHeight * 0.3945 * sinValue);
                                dot.setCenterY(centerY + scaledHeight * 0.3945 * cosValue);
                                break block0;
                            }
                        }
                        dot.setCenterX(centerX + scaledHeight * 0.449 * sinValue);
                        dot.setCenterY(centerY + scaledHeight * 0.449 * cosValue);
                        break;
                    }
                    default: {
                        Path standard = (Path)shape;
                        standard.getElements().clear();
                        switch (tickLabelLocation) {
                            case OUTSIDE: {
                                standard.getElements().add((Object)new MoveTo(centerX + scaledHeight * 0.38 * sinValue, centerY + scaledHeight * 0.38 * cosValue));
                                sinValue = Math.sin(Math.toRadians(valueAngle - pathHalf));
                                cosValue = Math.cos(Math.toRadians(valueAngle - pathHalf));
                                standard.getElements().add((Object)new LineTo(centerX + scaledHeight * 0.4075 * sinValue, centerY + scaledHeight * 0.4075 * cosValue));
                                standard.getElements().add((Object)new LineTo(centerX + scaledHeight * 0.4575 * sinValue, centerY + scaledHeight * 0.4575 * cosValue));
                                sinValue = Math.sin(Math.toRadians(valueAngle + pathHalf));
                                cosValue = Math.cos(Math.toRadians(valueAngle + pathHalf));
                                standard.getElements().add((Object)new LineTo(centerX + scaledHeight * 0.4575 * sinValue, centerY + scaledHeight * 0.4575 * cosValue));
                                standard.getElements().add((Object)new LineTo(centerX + scaledHeight * 0.4075 * sinValue, centerY + scaledHeight * 0.4075 * cosValue));
                                standard.getElements().add((Object)new ClosePath());
                                break block0;
                            }
                        }
                        standard.getElements().add((Object)new MoveTo(centerX + scaledHeight * 0.465 * sinValue, centerY + scaledHeight * 0.465 * cosValue));
                        sinValue = Math.sin(Math.toRadians(valueAngle - pathHalf));
                        cosValue = Math.cos(Math.toRadians(valueAngle - pathHalf));
                        standard.getElements().add((Object)new LineTo(centerX + scaledHeight * 0.436 * sinValue, centerY + scaledHeight * 0.436 * cosValue));
                        standard.getElements().add((Object)new LineTo(centerX + scaledHeight * 0.386 * sinValue, centerY + scaledHeight * 0.386 * cosValue));
                        sinValue = Math.sin(Math.toRadians(valueAngle + pathHalf));
                        cosValue = Math.cos(Math.toRadians(valueAngle + pathHalf));
                        standard.getElements().add((Object)new LineTo(centerX + scaledHeight * 0.386 * sinValue, centerY + scaledHeight * 0.386 * cosValue));
                        standard.getElements().add((Object)new LineTo(centerX + scaledHeight * 0.436 * sinValue, centerY + scaledHeight * 0.436 * cosValue));
                        standard.getElements().add((Object)new ClosePath());
                    }
                }
                Color markerColor = marker.getColor();
                shape.setFill((Paint)markerColor);
                shape.setStroke((Paint)markerColor.darker());
                shape.setPickOnBounds(false);
                Tooltip markerTooltip = marker.getText().isEmpty() ? new Tooltip(Double.toString(marker.getValue())) : new Tooltip(marker.getText() + "\n(" + Double.toString(marker.getValue()) + ")");
                markerTooltip.setTextAlignment(TextAlignment.CENTER);
                Tooltip.install((Node)shape, (Tooltip)markerTooltip);
                shape.setOnMousePressed(e -> marker.fireMarkerEvent(marker.MARKER_PRESSED_EVENT));
                shape.setOnMouseReleased(e -> marker.fireMarkerEvent(marker.MARKER_RELEASED_EVENT));
            }
        }
        if (((Gauge)this.getSkinnable()).isThresholdVisible()) {
            this.threshold.getElements().clear();
            double thresholdAngle = Gauge.ScaleDirection.CLOCKWISE == scaleDirection ? this.startAngle - (((Gauge)this.getSkinnable()).getThreshold() - this.minValue) * this.angleStep : this.startAngle + (((Gauge)this.getSkinnable()).getThreshold() - this.minValue) * this.angleStep;
            double thresholdSize = Helper.clamp(3.0, 3.5, 0.01 * scaledHeight);
            double sinValue = Math.sin(Math.toRadians(thresholdAngle));
            double cosValue = Math.cos(Math.toRadians(thresholdAngle));
            switch (tickLabelLocation) {
                case OUTSIDE: {
                    this.threshold.getElements().add((Object)new MoveTo(centerX + scaledHeight * 0.38 * sinValue, centerY + scaledHeight * 0.38 * cosValue));
                    sinValue = Math.sin(Math.toRadians(thresholdAngle - thresholdSize));
                    cosValue = Math.cos(Math.toRadians(thresholdAngle - thresholdSize));
                    this.threshold.getElements().add((Object)new LineTo(centerX + scaledHeight * 0.34 * sinValue, centerY + scaledHeight * 0.34 * cosValue));
                    sinValue = Math.sin(Math.toRadians(thresholdAngle + thresholdSize));
                    cosValue = Math.cos(Math.toRadians(thresholdAngle + thresholdSize));
                    this.threshold.getElements().add((Object)new LineTo(centerX + scaledHeight * 0.34 * sinValue, centerY + scaledHeight * 0.34 * cosValue));
                    this.threshold.getElements().add((Object)new ClosePath());
                    break;
                }
                default: {
                    this.threshold.getElements().add((Object)new MoveTo(centerX + scaledHeight * 0.465 * sinValue, centerY + scaledHeight * 0.465 * cosValue));
                    sinValue = Math.sin(Math.toRadians(thresholdAngle - thresholdSize));
                    cosValue = Math.cos(Math.toRadians(thresholdAngle - thresholdSize));
                    this.threshold.getElements().add((Object)new LineTo(centerX + scaledHeight * 0.425 * sinValue, centerY + scaledHeight * 0.425 * cosValue));
                    sinValue = Math.sin(Math.toRadians(thresholdAngle + thresholdSize));
                    cosValue = Math.cos(Math.toRadians(thresholdAngle + thresholdSize));
                    this.threshold.getElements().add((Object)new LineTo(centerX + scaledHeight * 0.425 * sinValue, centerY + scaledHeight * 0.425 * cosValue));
                    this.threshold.getElements().add((Object)new ClosePath());
                }
            }
            this.threshold.setFill((Paint)((Gauge)this.getSkinnable()).getThresholdColor());
            this.threshold.setStroke((Paint)((Gauge)this.getSkinnable()).getTickMarkColor());
        }
    }

    private void updateMarkers() {
        this.markerMap.clear();
        block4: for (Marker marker : ((Gauge)this.getSkinnable()).getMarkers()) {
            switch (marker.getMarkerType()) {
                case TRIANGLE: {
                    this.markerMap.put(marker, (Shape)new Path());
                    continue block4;
                }
                case DOT: {
                    this.markerMap.put(marker, (Shape)new Circle());
                    continue block4;
                }
            }
            this.markerMap.put(marker, (Shape)new Path());
        }
    }

    private void drawKnob(boolean PRESSED) {
        this.knobCanvas.setCache(false);
        double w = this.knobCanvas.getWidth();
        double h = this.knobCanvas.getHeight();
        this.knobCtx.clearRect(0.0, 0.0, w, h);
        Color knobColor = ((Gauge)this.getSkinnable()).getKnobColor();
        double hue = knobColor.getHue();
        double sat = knobColor.getSaturation();
        double alp = knobColor.getOpacity();
        double brg = Color.BLACK.equals((Object)knobColor) ? 0.2 : knobColor.getBrightness();
        switch (((Gauge)this.getSkinnable()).getKnobType()) {
            case PLAIN: {
                this.knobCtx.setFill((Paint)new LinearGradient(0.0, 0.0, 0.0, h, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)180, (int)180, (int)180)), new Stop(0.46, Color.rgb((int)63, (int)63, (int)63)), new Stop(1.0, Color.rgb((int)40, (int)40, (int)40))}));
                this.knobCtx.fillOval(0.0, 0.0, w, h);
                this.knobCtx.setFill((Paint)new LinearGradient(0.0, 0.11764706 * h, 0.0, 0.76470588 * h, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.hsb((double)hue, (double)sat, (double)(PRESSED ? brg * 0.9 : brg * 1.0), (double)alp)), new Stop(0.01, Color.hsb((double)hue, (double)sat, (double)(PRESSED ? brg * 0.75 : brg * 0.85), (double)alp)), new Stop(0.5, Color.hsb((double)hue, (double)sat, (double)(PRESSED ? brg * 0.4 : brg * 0.5), (double)alp)), new Stop(0.51, Color.hsb((double)hue, (double)sat, (double)(PRESSED ? brg * 0.35 : brg * 0.45), (double)alp)), new Stop(1.0, Color.hsb((double)hue, (double)sat, (double)(PRESSED ? brg * 0.7 : brg * 0.8), (double)alp))}));
                this.knobCtx.fillOval(w * 0.11764706, h * 0.11764706, w - w * 0.23529412, h - h * 0.23529412);
                this.knobCtx.setFill((Paint)new RadialGradient(0.0, 0.0, 0.5 * w, 0.47 * h, w * 0.38, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.TRANSPARENT), new Stop(0.76, Color.TRANSPARENT), new Stop(1.0, Color.rgb((int)0, (int)0, (int)0, (double)(PRESSED ? 0.5 : 0.2)))}));
                this.knobCtx.fillOval(w * 0.11764706, h * 0.11764706, w - w * 0.23529412, h - h * 0.23529412);
                break;
            }
            case METAL: {
                this.knobCtx.setFill((Paint)new LinearGradient(0.0, 0.0, 0.0, h, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)92, (int)95, (int)101)), new Stop(0.47, Color.rgb((int)46, (int)49, (int)53)), new Stop(1.0, Color.rgb((int)22, (int)23, (int)26))}));
                this.knobCtx.fillOval(0.0, 0.0, w, h);
                this.knobCtx.setFill((Paint)new LinearGradient(0.0, 0.058823529411764705 * h, 0.0, 0.9411764705882353 * h, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.hsb((double)hue, (double)sat, (double)(PRESSED ? brg * 0.7 : brg * 0.9), (double)alp)), new Stop(0.0, Color.hsb((double)hue, (double)sat, (double)(PRESSED ? brg * 0.3 : brg * 0.5), (double)alp))}));
                this.knobCtx.fillOval(0.05882353 * w, 0.05882353 * h, w * 0.88235294, h * 0.88235294);
                this.knobCtx.beginPath();
                this.knobCtx.moveTo(0.17647058823529413 * w, 0.8235294117647058 * h);
                this.knobCtx.bezierCurveTo(0.29411764705882354 * w, 0.8823529411764706 * h, 0.35294117647058826 * w, 0.9411764705882353 * h, 0.5294117647058824 * w, 0.9411764705882353 * h);
                this.knobCtx.bezierCurveTo(0.6470588235294118 * w, 0.9411764705882353 * h, 0.7058823529411765 * w, 0.8823529411764706 * h, 0.8235294117647058 * w, 0.8235294117647058 * h);
                this.knobCtx.bezierCurveTo(0.7647058823529411 * w, 0.7058823529411765 * h, 0.6470588235294118 * w, 0.5882352941176471 * h, 0.5294117647058824 * w, 0.5882352941176471 * h);
                this.knobCtx.bezierCurveTo(0.35294117647058826 * w, 0.5882352941176471 * h, 0.23529411764705882 * w, 0.7058823529411765 * h, 0.17647058823529413 * w, 0.8235294117647058 * h);
                this.knobCtx.closePath();
                this.knobCtx.setFill((Paint)new RadialGradient(0.0, 0.0, 0.47058823529411764 * w, 0.8823529411764706 * h, 0.3235294117647059 * w, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)255, (int)255, (int)255, (double)(PRESSED ? 0.3 : 0.6))), new Stop(1.0, Color.TRANSPARENT)}));
                this.knobCtx.fill();
                this.knobCtx.beginPath();
                this.knobCtx.moveTo(0.058823529411764705 * w, 0.29411764705882354 * h);
                this.knobCtx.bezierCurveTo(0.17647058823529413 * w, 0.35294117647058826 * h, 0.35294117647058826 * w, 0.35294117647058826 * h, 0.5294117647058824 * w, 0.35294117647058826 * h);
                this.knobCtx.bezierCurveTo(0.6470588235294118 * w, 0.35294117647058826 * h, 0.8235294117647058 * w, 0.35294117647058826 * h, 0.9411764705882353 * w, 0.29411764705882354 * h);
                this.knobCtx.bezierCurveTo(0.8823529411764706 * w, 0.11764705882352941 * h, 0.7058823529411765 * w, 0.0 * h, 0.5294117647058824 * w, 0.0 * h);
                this.knobCtx.bezierCurveTo(0.29411764705882354 * w, 0.0 * h, 0.11764705882352941 * w, 0.11764705882352941 * h, 0.058823529411764705 * w, 0.29411764705882354 * h);
                this.knobCtx.closePath();
                this.knobCtx.setFill((Paint)new RadialGradient(0.0, 0.0, 0.47058823529411764 * w, 0.0, 0.4411764705882353 * w, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)255, (int)255, (int)255, (double)(PRESSED ? 0.45 : 0.75))), new Stop(1.0, Color.TRANSPARENT)}));
                this.knobCtx.fill();
                this.knobCtx.setFill((Paint)new LinearGradient(0.5294117647058824 * w, 0.23529411764705882 * h, 0.5294117647058824 * w, 0.7647058823529411 * h, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.BLACK), new Stop(1.0, Color.rgb((int)204, (int)204, (int)204))}));
                this.knobCtx.fillOval(0.23529412 * w, 0.23529412 * h, 0.52941176 * w, 0.52941176 * h);
                this.knobCtx.setFill((Paint)new LinearGradient(0.5294117647058824 * w, 0.29411764705882354 * h, 0.5294117647058824 * w, 0.7058823529411765 * h, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)1, (int)6, (int)11)), new Stop(1.0, Color.rgb((int)50, (int)52, (int)56))}));
                this.knobCtx.fillOval(0.29411765 * w, 0.29411765 * h, 0.41176471 * w, 0.41176471 * h);
                break;
            }
            case FLAT: {
                double lineWidth = 0.00740741 * this.width;
                double knobSize = w - 2.0 * lineWidth;
                this.knobCtx.setFill((Paint)(PRESSED ? knobColor.darker() : knobColor));
                this.knobCtx.setStroke((Paint)(PRESSED ? Color.WHITE.darker() : Color.WHITE));
                this.knobCtx.setLineWidth(lineWidth);
                this.knobCtx.fillOval(lineWidth, lineWidth, knobSize, knobSize);
                this.knobCtx.strokeOval(lineWidth, lineWidth, knobSize, knobSize);
                break;
            }
            default: {
                this.knobCtx.setFill((Paint)new LinearGradient(0.0, 0.0, 0.0, h, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)133, (int)133, (int)133).brighter().brighter()), new Stop(0.52, Color.rgb((int)133, (int)133, (int)133)), new Stop(1.0, Color.rgb((int)133, (int)133, (int)133).darker().darker())}));
                this.knobCtx.fillOval(0.0, 0.0, w, h);
                double gradTop = PRESSED ? h - this.width * 0.01 : this.width * 0.005;
                double gradBot = PRESSED ? this.width * 0.005 : h - this.width * 0.01;
                this.knobCtx.setFill((Paint)new LinearGradient(0.0, gradTop, 0.0, gradBot, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.hsb((double)hue, (double)sat, (double)(brg * 0.85), (double)alp)), new Stop(0.45, Color.hsb((double)hue, (double)sat, (double)(brg * 0.65), (double)alp)), new Stop(1.0, Color.hsb((double)hue, (double)sat, (double)(brg * 0.4), (double)alp))}));
                this.knobCtx.fillOval(this.width * 0.005, this.width * 0.005, w - this.width * 0.01, h - this.width * 0.01);
            }
        }
        this.knobCanvas.setCache(true);
        this.knobCanvas.setCacheHint(CacheHint.QUALITY);
    }

    private void resizeText() {
        double scaledHeight = this.height * 0.9;
        Pos knobPosition = ((Gauge)this.getSkinnable()).getKnobPosition();
        double maxWidth = 0.4 * this.width;
        double fontSize = 0.06 * scaledHeight;
        this.titleText.setFont(Fonts.robotoMedium(fontSize));
        this.titleText.setText(((Gauge)this.getSkinnable()).getTitle());
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        this.titleText.relocate(Pos.CENTER_LEFT == knobPosition ? this.width * 0.6 - this.titleText.getLayoutBounds().getWidth() : this.width * 0.4, (this.height - this.titleText.getLayoutBounds().getHeight()) * 0.5);
        fontSize = 0.04 * scaledHeight;
        this.unitText.setFont(Fonts.robotoRegular(fontSize));
        this.unitText.setText(((Gauge)this.getSkinnable()).getUnit());
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        this.unitText.relocate(Pos.CENTER_LEFT == knobPosition ? this.width * 0.6 - this.unitText.getLayoutBounds().getWidth() : this.width * 0.4, (this.height - this.unitText.getLayoutBounds().getHeight()) * 0.38);
    }

    private void resize() {
        this.width = ((Gauge)this.getSkinnable()).getWidth() - ((Gauge)this.getSkinnable()).getInsets().getLeft() - ((Gauge)this.getSkinnable()).getInsets().getRight();
        this.height = ((Gauge)this.getSkinnable()).getHeight() - ((Gauge)this.getSkinnable()).getInsets().getTop() - ((Gauge)this.getSkinnable()).getInsets().getBottom();
        if (2.0 * this.width > this.height) {
            this.width = 1.0 / (2.0 / this.height);
        } else if (1.0 / (2.0 / this.height) > this.width) {
            this.height = 2.0 * this.width;
        }
        if (this.width > 0.0 && this.height > 0.0) {
            Pos knobPosition = ((Gauge)this.getSkinnable()).getKnobPosition();
            double centerX = Pos.CENTER_LEFT == knobPosition ? this.width * 0.1 : this.width * 0.9;
            double centerY = this.height * 0.5;
            double scaledHeight = this.height * 0.9;
            this.pane.setMaxSize(this.width, this.height);
            this.pane.relocate((((Gauge)this.getSkinnable()).getWidth() - this.width) * 0.5, (((Gauge)this.getSkinnable()).getHeight() - this.height) * 0.5);
            this.dropShadow.setRadius(0.008 * scaledHeight);
            this.dropShadow.setOffsetY(0.008 * scaledHeight);
            this.backgroundInnerShadow.setOffsetX(0.0);
            this.backgroundInnerShadow.setOffsetY(scaledHeight * 0.03);
            this.backgroundInnerShadow.setRadius(scaledHeight * 0.04);
            this.pane.setEffect((Effect)(((Gauge)this.getSkinnable()).isInnerShadowEnabled() ? this.backgroundInnerShadow : null));
            this.sectionsAndAreasCanvas.setWidth(this.height);
            this.sectionsAndAreasCanvas.setHeight(this.height);
            this.sectionsAndAreasCanvas.relocate(Pos.CENTER_LEFT == ((Gauge)this.getSkinnable()).getKnobPosition() ? -this.width * 0.8 : 0.0, 0.0);
            this.tickMarkCanvas.setWidth(this.height);
            this.tickMarkCanvas.setHeight(this.height);
            this.tickMarkCanvas.relocate(Pos.CENTER_LEFT == ((Gauge)this.getSkinnable()).getKnobPosition() ? -this.width * 0.8 : 0.0, 0.0);
            this.markerPane.setPrefSize(this.height, this.height);
            boolean isFlatLed = Gauge.LedType.FLAT == ((Gauge)this.getSkinnable()).getLedType();
            this.ledSize = isFlatLed ? 0.05 * scaledHeight : 0.06 * scaledHeight;
            this.ledCanvas.setWidth(this.ledSize);
            this.ledCanvas.setHeight(this.ledSize);
            this.ledCanvas.relocate(Pos.CENTER_LEFT == knobPosition ? 0.025 * this.height : 0.425 * this.height, 0.35 * this.height);
            this.ledOffShadow = isFlatLed ? null : new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 0.07 * this.ledSize, 0.0, 0.0, 0.0);
            InnerShadow innerShadow = this.ledOnShadow = isFlatLed ? null : new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 0.07 * this.ledSize, 0.0, 0.0, 0.0);
            if (!isFlatLed) {
                this.ledOnShadow.setInput((Effect)new DropShadow(BlurType.TWO_PASS_BOX, ((Gauge)this.getSkinnable()).getLedColor(), 0.36 * this.ledSize, 0.0, 0.0, 0.0));
            }
            this.resizeText();
            this.valueText.setFont(Fonts.robotoMedium(scaledHeight * 0.1));
            this.valueText.setTranslateX(Pos.CENTER_LEFT == ((Gauge)this.getSkinnable()).getKnobPosition() ? this.width * 0.6 - this.valueText.getLayoutBounds().getWidth() : this.width * 0.9 - this.valueText.getLayoutBounds().getWidth());
            this.valueText.setTranslateY(this.height * 0.6);
            this.needle.setCache(false);
            switch (((Gauge)this.getSkinnable()).getNeedleType()) {
                case BIG: {
                    double needleWidth = 0.06 * scaledHeight;
                    double needleHeight = TickLabelLocation.INSIDE == this.tickLabelLocation ? 0.4975 * scaledHeight : 0.415 * scaledHeight;
                    Needle.INSTANCE.getPath(this.needle, needleWidth, needleHeight, Gauge.NeedleType.BIG, this.tickLabelLocation);
                    this.needle.relocate(centerX - this.needle.getLayoutBounds().getWidth() * 0.5, centerY - this.needle.getLayoutBounds().getHeight() * (TickLabelLocation.INSIDE == this.tickLabelLocation ? 0.93969849 : 0.92771084));
                    this.needleRotate.setPivotX(this.needle.getLayoutBounds().getWidth() * 0.5);
                    this.needleRotate.setPivotY(this.needle.getLayoutBounds().getHeight() * (TickLabelLocation.INSIDE == this.tickLabelLocation ? 0.93969849 : 0.92771084));
                    break;
                }
                case FAT: {
                    double needleWidth = scaledHeight * 0.3;
                    double needleHeight = scaledHeight * 0.505;
                    Needle.INSTANCE.getPath(this.needle, needleWidth, needleHeight, Gauge.NeedleType.FAT, this.tickLabelLocation);
                    this.needle.relocate(centerX - this.needle.getLayoutBounds().getWidth() * 0.5, centerY - this.needle.getLayoutBounds().getHeight() * 0.7029703);
                    this.needleRotate.setPivotX(this.needle.getLayoutBounds().getWidth() * 0.5);
                    this.needleRotate.setPivotY(this.needle.getLayoutBounds().getHeight() * 0.7029703);
                    break;
                }
                case SCIENTIFIC: {
                    double needleWidth = 0.1 * scaledHeight;
                    double needleHeight = TickLabelLocation.INSIDE == this.tickLabelLocation ? 0.645 * scaledHeight : 0.5625 * scaledHeight;
                    Needle.INSTANCE.getPath(this.needle, needleWidth, needleHeight, Gauge.NeedleType.SCIENTIFIC, this.tickLabelLocation);
                    this.needle.relocate(centerX - this.needle.getLayoutBounds().getWidth() * 0.5, centerY - (TickLabelLocation.INSIDE == this.tickLabelLocation ? this.needle.getLayoutBounds().getHeight() * 0.7248062 : this.needle.getLayoutBounds().getHeight() * 0.68444444));
                    this.needleRotate.setPivotX(this.needle.getLayoutBounds().getWidth() * 0.5);
                    this.needleRotate.setPivotY(this.needle.getLayoutBounds().getHeight() * (TickLabelLocation.INSIDE == this.tickLabelLocation ? 0.7248062 : 0.68444444));
                    break;
                }
                case AVIONIC: {
                    double needleWidth = 0.06 * scaledHeight;
                    double needleHeight = TickLabelLocation.INSIDE == this.tickLabelLocation ? 0.5975 * scaledHeight : 0.515 * scaledHeight;
                    Needle.INSTANCE.getPath(this.needle, needleWidth, needleHeight, Gauge.NeedleType.AVIONIC, this.tickLabelLocation);
                    this.needle.relocate(centerX - this.needle.getLayoutBounds().getWidth() * 0.5, centerY - this.needle.getLayoutBounds().getHeight() * (TickLabelLocation.INSIDE == this.tickLabelLocation ? 0.78242678 : 0.74757282));
                    this.needleRotate.setPivotX(this.needle.getLayoutBounds().getWidth() * 0.5);
                    this.needleRotate.setPivotY(this.needle.getLayoutBounds().getHeight() * (TickLabelLocation.INSIDE == this.tickLabelLocation ? 0.78242678 : 0.74757282));
                    break;
                }
                case VARIOMETER: {
                    double needleWidth = scaledHeight * ((Gauge)this.getSkinnable()).getNeedleSize().FACTOR;
                    double needleHeight = TickLabelLocation.INSIDE == this.tickLabelLocation ? scaledHeight * 0.4675 : scaledHeight * 0.385;
                    Needle.INSTANCE.getPath(this.needle, needleWidth, needleHeight, Gauge.NeedleType.VARIOMETER, this.tickLabelLocation);
                    this.needle.relocate(centerX - this.needle.getLayoutBounds().getWidth() * 0.5, centerY - this.needle.getLayoutBounds().getHeight());
                    this.needleRotate.setPivotX(this.needle.getLayoutBounds().getWidth() * 0.5);
                    this.needleRotate.setPivotY(this.needle.getLayoutBounds().getHeight());
                    break;
                }
                default: {
                    double needleWidth = scaledHeight * ((Gauge)this.getSkinnable()).getNeedleSize().FACTOR;
                    double needleHeight = TickLabelLocation.OUTSIDE == this.tickLabelLocation ? scaledHeight * 0.3965 : scaledHeight * 0.455;
                    Needle.INSTANCE.getPath(this.needle, needleWidth, needleHeight, Gauge.NeedleType.STANDARD, this.tickLabelLocation);
                    this.needle.relocate(centerX - this.needle.getLayoutBounds().getWidth() * 0.5, centerY - this.needle.getLayoutBounds().getHeight());
                    this.needleRotate.setPivotX(this.needle.getLayoutBounds().getWidth() * 0.5);
                    this.needleRotate.setPivotY(this.needle.getLayoutBounds().getHeight());
                }
            }
            this.needle.setCache(true);
            this.needle.setCacheHint(CacheHint.ROTATE);
            this.knobCanvas.setWidth(this.height * 0.1);
            this.knobCanvas.setHeight(this.height * 0.1);
            this.knobCanvas.relocate(centerX - this.height * 0.05, centerY - this.height * 0.05);
            this.buttonTooltip.setText(((Gauge)this.getSkinnable()).getButtonTooltipText());
        }
    }

    private void redraw() {
        this.locale = ((Gauge)this.getSkinnable()).getLocale();
        this.formatString = "%." + Integer.toString(((Gauge)this.getSkinnable()).getDecimals()) + "f";
        this.shadowGroup.setEffect((Effect)(((Gauge)this.getSkinnable()).isShadowsEnabled() ? this.dropShadow : null));
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Gauge)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(((Gauge)this.getSkinnable()).getBorderWidth() / 125.0 * this.width))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.tickLabelLocation = ((Gauge)this.getSkinnable()).getTickLabelLocation();
        this.scaleDirection = ((Gauge)this.getSkinnable()).getScaleDirection();
        if (((Gauge)this.getSkinnable()).getAreasVisible() | ((Gauge)this.getSkinnable()).getSectionsVisible()) {
            this.sectionsAndAreasCtx.clearRect(0.0, 0.0, this.height, this.height);
            this.drawAreasAndSections(this.sectionsAndAreasCtx);
        }
        this.tickMarkCanvas.setCache(false);
        this.tickMarkCtx.clearRect(0.0, 0.0, this.height, this.height);
        if (((Gauge)this.getSkinnable()).isGradientBarEnabled() && ((Gauge)this.getSkinnable()).getGradientLookup() != null) {
            this.drawGradientBar();
        }
        Helper.drawRadialTickMarks((Gauge)this.getSkinnable(), this.tickMarkCtx, this.minValue, this.maxValue, this.startAngle, this.angleRange, this.angleStep, this.width * 0.9, this.height * 0.5, this.height * 0.9);
        this.tickMarkCanvas.setCache(true);
        this.tickMarkCanvas.setCacheHint(CacheHint.QUALITY);
        if (((Gauge)this.getSkinnable()).isLedVisible()) {
            Color LED_COLOR = ((Gauge)this.getSkinnable()).getLedColor();
            switch (((Gauge)this.getSkinnable()).getLedType()) {
                case FLAT: {
                    this.ledFramePaint = Color.WHITE;
                    this.ledOnPaint = new LinearGradient(0.0, 0.25 * this.ledSize, 0.0, 0.74 * this.ledSize, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, LED_COLOR), new Stop(1.0, LED_COLOR.deriveColor(0.0, 1.0, 0.5, 1.0))});
                    this.ledOffPaint = new LinearGradient(0.0, 0.25 * this.ledSize, 0.0, 0.74 * this.ledSize, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, LED_COLOR.deriveColor(0.0, 1.0, 0.5, 1.0)), new Stop(1.0, LED_COLOR.deriveColor(0.0, 1.0, 0.13, 1.0))});
                    this.ledHighlightPaint = Color.TRANSPARENT;
                    break;
                }
                default: {
                    this.ledFramePaint = new LinearGradient(0.14 * this.ledSize, 0.14 * this.ledSize, 0.84 * this.ledSize, 0.84 * this.ledSize, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)20, (int)20, (int)20, (double)0.65)), new Stop(0.15, Color.rgb((int)20, (int)20, (int)20, (double)0.65)), new Stop(0.26, Color.rgb((int)41, (int)41, (int)41, (double)0.65)), new Stop(0.26, Color.rgb((int)41, (int)41, (int)41, (double)0.64)), new Stop(0.85, Color.rgb((int)200, (int)200, (int)200, (double)0.41)), new Stop(1.0, Color.rgb((int)200, (int)200, (int)200, (double)0.35))});
                    this.ledOnPaint = new LinearGradient(0.25 * this.ledSize, 0.25 * this.ledSize, 0.74 * this.ledSize, 0.74 * this.ledSize, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, LED_COLOR.deriveColor(0.0, 1.0, 0.77, 1.0)), new Stop(0.49, LED_COLOR.deriveColor(0.0, 1.0, 0.5, 1.0)), new Stop(1.0, LED_COLOR)});
                    this.ledOffPaint = new LinearGradient(0.25 * this.ledSize, 0.25 * this.ledSize, 0.74 * this.ledSize, 0.74 * this.ledSize, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, LED_COLOR.deriveColor(0.0, 1.0, 0.2, 1.0)), new Stop(0.49, LED_COLOR.deriveColor(0.0, 1.0, 0.13, 1.0)), new Stop(1.0, LED_COLOR.deriveColor(0.0, 1.0, 0.2, 1.0))});
                    this.ledHighlightPaint = new RadialGradient(0.0, 0.0, 0.3 * this.ledSize, 0.3 * this.ledSize, 0.29 * this.ledSize, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.WHITE), new Stop(1.0, Color.TRANSPARENT)});
                }
            }
            this.drawLed();
        }
        this.titleText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.unitText.setFill((Paint)((Gauge)this.getSkinnable()).getUnitColor());
        this.valueText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        this.resizeText();
        Color needleColor = ((Gauge)this.getSkinnable()).getNeedleColor();
        switch (((Gauge)this.getSkinnable()).getNeedleShape()) {
            case ROUND: {
                this.needlePaint = new LinearGradient(this.needle.getLayoutBounds().getMinX(), 0.0, this.needle.getLayoutBounds().getMaxX(), 0.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, needleColor.darker()), new Stop(0.5, needleColor.brighter().brighter()), new Stop(1.0, needleColor.darker())});
                this.needle.setStrokeWidth(0.0);
                break;
            }
            case FLAT: {
                this.needlePaint = needleColor;
                this.needle.setStrokeWidth(0.0037037 * this.width);
                break;
            }
            default: {
                this.needlePaint = new LinearGradient(this.needle.getLayoutBounds().getMinX(), 0.0, this.needle.getLayoutBounds().getMaxX(), 0.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, needleColor.darker()), new Stop(0.5, needleColor.darker()), new Stop(0.5, needleColor.brighter()), new Stop(1.0, needleColor.brighter())});
                this.needle.setStrokeWidth(0.0);
            }
        }
        if (Gauge.NeedleType.AVIONIC == ((Gauge)this.getSkinnable()).getNeedleType()) {
            this.needlePaint = new LinearGradient(0.0, this.needle.getLayoutBounds().getMinY(), 0.0, this.needle.getLayoutBounds().getMaxY(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, needleColor), new Stop(0.3, needleColor), new Stop(0.3, Color.BLACK), new Stop(1.0, Color.BLACK)});
        }
        this.needle.setFill(this.needlePaint);
        this.needle.setStroke((Paint)((Gauge)this.getSkinnable()).getNeedleBorderColor());
        this.drawKnob(false);
        this.drawMarkers();
        this.thresholdTooltip.setText("Threshold\n(" + String.format(this.locale, this.formatString, ((Gauge)this.getSkinnable()).getThreshold()) + ")");
    }
}

