/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.tools.Helper;
import java.util.List;
import java.util.Locale;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Text;

public class FlatSkin
extends SkinBase<Gauge>
implements Skin<Gauge> {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final double ANGLE_RANGE = 360.0;
    private double size;
    private Circle colorRing;
    private Arc bar;
    private Line separator;
    private Text titleText;
    private Text valueText;
    private Text unitText;
    private Pane pane;
    private double minValue;
    private double range;
    private double angleStep;
    private boolean colorGradientEnabled;
    private int noOfGradientStops;
    private boolean sectionsVisible;
    private List<Section> sections;
    private String formatString;
    private Locale locale;

    public FlatSkin(Gauge gauge) {
        super((Control)gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.minValue = gauge.getMinValue();
        this.range = gauge.getRange();
        this.angleStep = 360.0 / this.range;
        this.colorGradientEnabled = gauge.isGradientBarEnabled();
        this.noOfGradientStops = gauge.getGradientBarStops().size();
        this.sectionsVisible = gauge.getSectionsVisible();
        this.sections = gauge.getSections();
        this.formatString = "%." + Integer.toString(gauge.getDecimals()) + "f";
        this.locale = gauge.getLocale();
        this.init();
        this.initGraphics();
        this.registerListeners();
        this.setBar(gauge.getCurrentValue());
    }

    private void init() {
        if ((Double.compare(((Gauge)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getHeight(), 0.0) <= 0) && ((Gauge)this.getSkinnable()).getPrefWidth() < 0.0 && ((Gauge)this.getSkinnable()).getPrefHeight() < 0.0) {
            ((Gauge)this.getSkinnable()).setPrefSize(250.0, 250.0);
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMinSize(50.0, 50.0);
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.colorRing = new Circle(125.0, 125.0, 125.0);
        this.colorRing.setFill((Paint)Color.TRANSPARENT);
        this.colorRing.setStrokeWidth(1.875);
        this.colorRing.setStroke((Paint)((Gauge)this.getSkinnable()).getBarColor());
        this.bar = new Arc(125.0, 125.0, 117.0, 117.0, 90.0, 0.0);
        this.bar.setType(ArcType.OPEN);
        this.bar.setStroke((Paint)((Gauge)this.getSkinnable()).getBarColor());
        this.bar.setStrokeWidth(37.5);
        this.bar.setStrokeLineCap(StrokeLineCap.BUTT);
        this.bar.setFill(null);
        this.separator = new Line(125.0, 1.0, 125.0, 41.667500000000004);
        this.separator.setStroke(((Gauge)this.getSkinnable()).getBorderPaint());
        this.separator.setFill((Paint)Color.TRANSPARENT);
        this.titleText = new Text(((Gauge)this.getSkinnable()).getTitle());
        this.titleText.setFont(Fonts.robotoLight(20.0));
        this.titleText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.valueText = new Text(String.format(this.locale, this.formatString, ((Gauge)this.getSkinnable()).getCurrentValue()));
        this.valueText.setFont(Fonts.robotoRegular(68.33250000000001));
        this.valueText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        this.unitText = new Text(((Gauge)this.getSkinnable()).getUnit());
        this.unitText.setFont(Fonts.robotoLight(20.0));
        this.unitText.setFill((Paint)((Gauge)this.getSkinnable()).getUnitColor());
        this.pane = new Pane(new Node[]{this.colorRing, this.bar, this.separator, this.titleText, this.valueText, this.unitText});
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Gauge)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(((Gauge)this.getSkinnable()).getBorderWidth()))}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((Gauge)this.getSkinnable()).widthProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).heightProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).setOnUpdate(e -> this.handleEvents(e.eventType.name()));
        ((Gauge)this.getSkinnable()).currentValueProperty().addListener(o -> this.setBar(((Gauge)this.getSkinnable()).getCurrentValue()));
    }

    private void handleEvents(String EVENT_TYPE) {
        if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
            this.redraw();
        } else if ("REDRAW".equals(EVENT_TYPE)) {
            this.redraw();
        } else if ("RECALC".equals(EVENT_TYPE)) {
            this.minValue = ((Gauge)this.getSkinnable()).getMinValue();
            this.range = ((Gauge)this.getSkinnable()).getRange();
            this.angleStep = 360.0 / this.range;
            this.sections = ((Gauge)this.getSkinnable()).getSections();
            this.redraw();
        }
    }

    private void setBar(double VALUE) {
        if (this.minValue > 0.0) {
            this.bar.setLength((this.minValue - VALUE) * this.angleStep);
        } else {
            this.bar.setLength(-VALUE * this.angleStep);
        }
        this.setBarColor(VALUE);
        this.valueText.setText(String.format(this.locale, this.formatString, VALUE));
        this.resizeValueText();
    }

    private void setBarColor(double VALUE) {
        if (!this.sectionsVisible && !this.colorGradientEnabled) {
            this.bar.setStroke((Paint)((Gauge)this.getSkinnable()).getBarColor());
            this.colorRing.setStroke((Paint)((Gauge)this.getSkinnable()).getBarColor());
        } else if (this.colorGradientEnabled && this.noOfGradientStops > 1) {
            Color dynamicColor = ((Gauge)this.getSkinnable()).getGradientLookup().getColorAt((VALUE - this.minValue) / this.range);
            this.bar.setStroke((Paint)dynamicColor);
            this.colorRing.setStroke((Paint)dynamicColor);
        } else {
            for (Section section : this.sections) {
                if (!section.contains(VALUE)) continue;
                this.bar.setStroke((Paint)section.getColor());
                this.colorRing.setStroke((Paint)section.getColor());
                break;
            }
        }
    }

    private void resizeTitleText() {
        double maxWidth = 0.56667 * this.size;
        double fontSize = 0.08 * this.size;
        this.titleText.setFont(Fonts.robotoLight(fontSize));
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        this.titleText.relocate((this.size - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.225);
    }

    private void resizeValueText() {
        double maxWidth = 0.5 * this.size;
        double fontSize = 0.3 * this.size;
        this.valueText.setFont(Fonts.robotoRegular(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
        this.valueText.relocate((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5, (this.size - this.valueText.getLayoutBounds().getHeight()) * 0.5);
    }

    private void resizeUnitText() {
        double maxWidth = 0.56667 * this.size;
        double fontSize = 0.08 * this.size;
        this.unitText.setFont(Fonts.robotoLight(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        this.unitText.relocate((this.size - this.unitText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.66);
    }

    private void resize() {
        double height;
        double width = ((Gauge)this.getSkinnable()).getWidth() - ((Gauge)this.getSkinnable()).getInsets().getLeft() - ((Gauge)this.getSkinnable()).getInsets().getRight();
        double d = this.size = width < (height = ((Gauge)this.getSkinnable()).getHeight() - ((Gauge)this.getSkinnable()).getInsets().getTop() - ((Gauge)this.getSkinnable()).getInsets().getBottom()) ? width : height;
        if (width > 0.0 && height > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((width - this.size) * 0.5, (height - this.size) * 0.5);
            this.colorRing.setCenterX(this.size * 0.5);
            this.colorRing.setCenterY(this.size * 0.5);
            this.colorRing.setRadius(this.size * 0.5);
            this.colorRing.setStrokeWidth(this.size * 0.0075);
            this.colorRing.setStrokeType(StrokeType.INSIDE);
            this.bar.setCenterX(this.size * 0.5);
            this.bar.setCenterY(this.size * 0.5);
            this.bar.setRadiusX(this.size * 0.4135);
            this.bar.setRadiusY(this.size * 0.4135);
            this.bar.setStrokeWidth(this.size * 0.12);
            this.separator.setStartX(this.size * 0.5);
            this.separator.setStartY(this.size * 0.0275);
            this.separator.setEndX(this.size * 0.5);
            this.separator.setEndY(this.size * 0.145);
            this.resizeTitleText();
            this.resizeValueText();
            this.resizeUnitText();
        }
    }

    private void redraw() {
        this.locale = ((Gauge)this.getSkinnable()).getLocale();
        this.formatString = "%." + Integer.toString(((Gauge)this.getSkinnable()).getDecimals()) + "f";
        this.colorGradientEnabled = ((Gauge)this.getSkinnable()).isGradientBarEnabled();
        this.noOfGradientStops = ((Gauge)this.getSkinnable()).getGradientBarStops().size();
        this.sectionsVisible = ((Gauge)this.getSkinnable()).getSectionsVisible();
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Gauge)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(((Gauge)this.getSkinnable()).getBorderWidth() / 250.0 * this.size))}));
        this.setBarColor(((Gauge)this.getSkinnable()).getCurrentValue());
        this.valueText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        this.unitText.setFill((Paint)((Gauge)this.getSkinnable()).getUnitColor());
        this.titleText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.separator.setStroke(((Gauge)this.getSkinnable()).getBorderPaint());
        this.titleText.setText(((Gauge)this.getSkinnable()).getTitle());
        this.resizeTitleText();
        this.unitText.setText(((Gauge)this.getSkinnable()).getUnit());
        this.resizeUnitText();
    }
}

