/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.tools.Helper;
import java.math.BigDecimal;
import java.util.Locale;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class BulletChartSkin
extends SkinBase<Gauge>
implements Skin<Gauge> {
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double preferredWidth = 400.0;
    private double preferredHeight = 64.0;
    private Pane pane;
    private double width;
    private double height;
    private double aspectRatio;
    private Orientation orientation;
    private Canvas tickMarkCanvas;
    private GraphicsContext tickMarksCtx;
    private Canvas sectionsCanvas;
    private GraphicsContext sectionsCtx;
    private Text titleText;
    private Text unitText;
    private Rectangle barRect;
    private Rectangle thresholdRect;
    private double stepSize;
    private Tooltip barTooltip;
    private Tooltip thresholdTooltip;
    private String formatString;
    private Locale locale;

    public BulletChartSkin(Gauge gauge) {
        super((Control)gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.orientation = gauge.getOrientation();
        this.barTooltip = new Tooltip();
        this.thresholdTooltip = new Tooltip();
        this.formatString = "%." + Integer.toString(gauge.getDecimals()) + "f";
        this.locale = gauge.getLocale();
        if (Orientation.VERTICAL == this.orientation) {
            this.preferredWidth = 64.0;
            this.preferredHeight = 400.0;
        } else {
            this.preferredWidth = 400.0;
            this.preferredHeight = 64.0;
        }
        gauge.setPrefSize(this.preferredWidth, this.preferredHeight);
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(((Gauge)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((Gauge)this.getSkinnable()).getPrefWidth() > 0.0 && ((Gauge)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((Gauge)this.getSkinnable()).setPrefSize(((Gauge)this.getSkinnable()).getPrefWidth(), ((Gauge)this.getSkinnable()).getPrefHeight());
            } else {
                ((Gauge)this.getSkinnable()).setPrefSize(this.preferredWidth, this.preferredHeight);
            }
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMinSize(50.0, 50.0);
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        Orientation orientation = ((Gauge)this.getSkinnable()).getOrientation();
        this.aspectRatio = this.preferredHeight / this.preferredWidth;
        this.titleText = new Text(((Gauge)this.getSkinnable()).getTitle());
        this.titleText.setTextOrigin(VPos.CENTER);
        this.unitText = new Text(((Gauge)this.getSkinnable()).getUnit());
        this.unitText.setTextOrigin(VPos.CENTER);
        this.tickMarkCanvas = new Canvas(0.79699248 * this.preferredWidth, 0.08333333 * this.preferredHeight);
        this.tickMarksCtx = this.tickMarkCanvas.getGraphicsContext2D();
        this.sectionsCanvas = new Canvas(0.79699248 * this.preferredWidth, 0.5 * this.preferredHeight);
        this.sectionsCtx = this.sectionsCanvas.getGraphicsContext2D();
        this.barRect = new Rectangle();
        Tooltip.install((Node)this.barRect, (Tooltip)this.barTooltip);
        this.thresholdRect = new Rectangle();
        Tooltip.install((Node)this.thresholdRect, (Tooltip)this.thresholdTooltip);
        this.pane = new Pane(new Node[]{this.titleText, this.unitText, this.tickMarkCanvas, this.sectionsCanvas, this.barRect, this.thresholdRect});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Gauge)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(((Gauge)this.getSkinnable()).getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((Gauge)this.getSkinnable()).widthProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).heightProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).getSections().addListener(c -> this.redraw());
        ((Gauge)this.getSkinnable()).getTickMarkSections().addListener(c -> this.redraw());
        ((Gauge)this.getSkinnable()).getTickLabelSections().addListener(c -> this.redraw());
        ((Gauge)this.getSkinnable()).getMarkers().addListener(c -> this.redraw());
        ((Gauge)this.getSkinnable()).setOnUpdate(e -> this.handleEvents(e.eventType.name()));
        ((Gauge)this.getSkinnable()).currentValueProperty().addListener(o -> this.updateBar());
    }

    protected void handleEvents(String EVENT_TYPE) {
        if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
            this.redraw();
        } else if ("REDRAW".equals(EVENT_TYPE)) {
            this.redraw();
        } else if ("VISIBILITY".equals(EVENT_TYPE)) {
            if (((Gauge)this.getSkinnable()).getTitle().isEmpty()) {
                this.titleText.setVisible(false);
                this.titleText.setManaged(false);
            } else {
                this.titleText.setManaged(true);
                this.titleText.setVisible(true);
            }
            if (((Gauge)this.getSkinnable()).getUnit().isEmpty()) {
                this.unitText.setVisible(false);
                this.unitText.setManaged(false);
            } else {
                this.unitText.setManaged(true);
                this.unitText.setVisible(true);
            }
            this.redraw();
        } else if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
        } else if ("RECALC".equals(EVENT_TYPE)) {
            if (((Gauge)this.getSkinnable()).isAutoScale()) {
                ((Gauge)this.getSkinnable()).calcAutoScale();
            }
            if (Orientation.VERTICAL == this.orientation) {
                this.width = this.height / this.aspectRatio;
                this.stepSize = 0.79699248 * this.height / ((Gauge)this.getSkinnable()).getRange();
            } else {
                this.height = this.width / this.aspectRatio;
                this.stepSize = 0.79699248 * this.width / ((Gauge)this.getSkinnable()).getRange();
            }
            this.resize();
            this.redraw();
        } else if ("FINISHED".equals(EVENT_TYPE)) {
            this.barTooltip.setText(String.format(this.locale, this.formatString, ((Gauge)this.getSkinnable()).getValue()));
        }
    }

    private void drawTickMarks(GraphicsContext CTX) {
        this.tickMarkCanvas.setCache(false);
        CTX.clearRect(0.0, 0.0, this.tickMarkCanvas.getWidth(), this.tickMarkCanvas.getHeight());
        CTX.setFill((Paint)((Gauge)this.getSkinnable()).getMajorTickMarkColor());
        ObservableList<Section> tickMarkSections = ((Gauge)this.getSkinnable()).getTickMarkSections();
        ObservableList<Section> tickLabelSections = ((Gauge)this.getSkinnable()).getTickLabelSections();
        Color majorTickMarkColor = ((Gauge)this.getSkinnable()).getTickMarkColor();
        Color tickLabelColor = ((Gauge)this.getSkinnable()).getTickLabelColor();
        boolean smallRange = Double.compare(((Gauge)this.getSkinnable()).getRange(), 10.0) <= 0;
        double minValue = ((Gauge)this.getSkinnable()).getMinValue();
        double maxValue = ((Gauge)this.getSkinnable()).getMaxValue();
        double tmpStepSize = smallRange ? this.stepSize / 10.0 : this.stepSize;
        Font tickLabelFont = Fonts.robotoRegular(0.15 * (Orientation.VERTICAL == this.orientation ? this.width : this.height));
        boolean tickMarkSectionsVisible = ((Gauge)this.getSkinnable()).getTickMarkSectionsVisible();
        boolean tickLabelSectionsVisible = ((Gauge)this.getSkinnable()).getTickLabelSectionsVisible();
        double offsetX = 0.18345865 * this.width;
        double offsetY = 0.1 * this.height;
        double innerPointX = 0.0;
        double innerPointY = 0.0;
        double outerPointX = 0.07 * this.width;
        double outerPointY = 0.08 * this.height;
        double textPointX = 0.55 * this.tickMarkCanvas.getWidth();
        double textPointY = 0.7 * this.tickMarkCanvas.getHeight();
        BigDecimal minorTickSpaceBD = BigDecimal.valueOf(((Gauge)this.getSkinnable()).getMinorTickSpace());
        BigDecimal majorTickSpaceBD = BigDecimal.valueOf(((Gauge)this.getSkinnable()).getMajorTickSpace());
        BigDecimal counterBD = BigDecimal.valueOf(((Gauge)this.getSkinnable()).getMinValue());
        double counter = minValue;
        double range = ((Gauge)this.getSkinnable()).getRange();
        double i = 0.0;
        while (Double.compare(i, range) <= 0) {
            if (Orientation.VERTICAL == this.orientation) {
                outerPointY = innerPointY = counter * tmpStepSize + offsetY;
                textPointY = innerPointY;
            } else {
                outerPointX = innerPointX = counter * tmpStepSize + offsetX;
                textPointX = innerPointX;
            }
            CTX.setStroke((Paint)((Gauge)this.getSkinnable()).getTickMarkColor());
            if (Double.compare(counterBD.remainder(majorTickSpaceBD).doubleValue(), 0.0) == 0) {
                if (((Gauge)this.getSkinnable()).getMajorTickMarksVisible()) {
                    CTX.setFill((Paint)(tickMarkSectionsVisible ? Helper.getColorOfSection(tickMarkSections, counter, majorTickMarkColor) : majorTickMarkColor));
                    CTX.setStroke((Paint)(tickMarkSectionsVisible ? Helper.getColorOfSection(tickMarkSections, counter, majorTickMarkColor) : majorTickMarkColor));
                    CTX.setLineWidth(1.0);
                    CTX.strokeLine(innerPointX, innerPointY, outerPointX, outerPointY);
                }
                if (((Gauge)this.getSkinnable()).getTickLabelsVisible()) {
                    CTX.save();
                    CTX.translate(textPointX, textPointY);
                    CTX.setFont(tickLabelFont);
                    CTX.setTextAlign(TextAlignment.CENTER);
                    CTX.setTextBaseline(VPos.CENTER);
                    CTX.setFill((Paint)(tickLabelSectionsVisible ? Helper.getColorOfSection(tickLabelSections, counter, tickLabelColor) : tickLabelColor));
                    if (Orientation.VERTICAL == this.orientation) {
                        CTX.fillText(Integer.toString((int)(maxValue - counter)), 0.0, 0.0);
                    } else {
                        CTX.fillText(Integer.toString((int)counter), 0.0, 0.0);
                    }
                    CTX.restore();
                }
            }
            if ((counter = (counterBD = counterBD.add(minorTickSpaceBD)).doubleValue()) > maxValue) break;
            i += 1.0;
        }
        this.tickMarkCanvas.setCache(true);
        this.tickMarkCanvas.setCacheHint(CacheHint.QUALITY);
    }

    private void drawSections(GraphicsContext CTX) {
        this.sectionsCanvas.setCache(false);
        CTX.clearRect(0.0, 0.0, this.sectionsCanvas.getWidth(), this.sectionsCanvas.getHeight());
        CTX.setFill(((Gauge)this.getSkinnable()).getBackgroundPaint());
        if (Orientation.VERTICAL == this.orientation) {
            CTX.fillRect(0.0, 0.0, 0.5 * this.width, 0.89 * this.height);
        } else {
            CTX.fillRect(0.0, 0.0, 0.79699248 * this.width, 0.5 * this.height);
        }
        double minValue = ((Gauge)this.getSkinnable()).getMinValue();
        double maxValue = ((Gauge)this.getSkinnable()).getMaxValue();
        int listSize = ((Gauge)this.getSkinnable()).getSections().size();
        for (int i = 0; i < listSize; ++i) {
            Section SECTION = (Section)((Gauge)this.getSkinnable()).getSections().get(i);
            if (Double.compare(SECTION.getStart(), maxValue) > 0 || Double.compare(SECTION.getStop(), minValue) < 0) continue;
            double SECTION_START = Double.compare(SECTION.getStart(), minValue) < 0 && Double.compare(SECTION.getStop(), maxValue) < 0 ? minValue * this.stepSize : (SECTION.getStart() - minValue) * this.stepSize;
            double SECTION_SIZE = Double.compare(SECTION.getStop(), maxValue) > 0 ? (maxValue - SECTION.getStart()) * this.stepSize : (SECTION.getStop() - SECTION.getStart()) * this.stepSize;
            CTX.save();
            CTX.setFill((Paint)SECTION.getColor());
            if (Orientation.VERTICAL == this.orientation) {
                CTX.fillRect(0.0, 0.89 * this.height - SECTION_START - SECTION_SIZE, 0.5 * this.width, SECTION_SIZE);
            } else {
                CTX.fillRect(SECTION_START, 0.0, SECTION_SIZE, 0.5 * this.height);
            }
            CTX.restore();
        }
        this.sectionsCanvas.setCache(true);
        this.sectionsCanvas.setCacheHint(CacheHint.QUALITY);
    }

    private void updateBar() {
        double currentValue = ((Gauge)this.getSkinnable()).getCurrentValue();
        if (Orientation.VERTICAL == this.orientation) {
            this.barRect.setY(this.height - 0.06 * this.width - currentValue * this.stepSize);
            this.barRect.setHeight(currentValue * this.stepSize);
            this.thresholdRect.setY(this.height - ((Gauge)this.getSkinnable()).getThreshold() * this.stepSize - 0.08625 * this.width);
        } else {
            this.barRect.setWidth(currentValue * this.stepSize);
            this.thresholdRect.setX(((Gauge)this.getSkinnable()).getThreshold() * this.stepSize - 0.03125 * this.height + 0.1835 * this.width);
        }
    }

    private void adjustTextSize(Text TEXT, double MAX_WIDTH, double DECREMENT_FACTOR) {
        double size;
        double decrement = 0.0;
        double d = size = this.width < this.height ? this.width : this.height;
        while (TEXT.getLayoutBounds().getWidth() > MAX_WIDTH && TEXT.getFont().getSize() > 0.0) {
            TEXT.setFont(Fonts.robotoMedium(size * (DECREMENT_FACTOR - decrement)));
            decrement += 0.01;
        }
    }

    private void resize() {
        this.width = ((Gauge)this.getSkinnable()).getWidth() - ((Gauge)this.getSkinnable()).getInsets().getLeft() - ((Gauge)this.getSkinnable()).getInsets().getRight();
        this.height = ((Gauge)this.getSkinnable()).getHeight() - ((Gauge)this.getSkinnable()).getInsets().getTop() - ((Gauge)this.getSkinnable()).getInsets().getBottom();
        double currentValue = ((Gauge)this.getSkinnable()).getCurrentValue();
        this.formatString = "%." + Integer.toString(((Gauge)this.getSkinnable()).getDecimals()) + "f";
        this.orientation = ((Gauge)this.getSkinnable()).getOrientation();
        if (Orientation.VERTICAL == this.orientation) {
            this.width = this.height / this.aspectRatio;
            this.stepSize = 0.89 * this.height / ((Gauge)this.getSkinnable()).getRange();
            this.pane.setMaxSize(this.width, this.height);
            this.pane.relocate((((Gauge)this.getSkinnable()).getWidth() - this.width) * 0.5, (((Gauge)this.getSkinnable()).getHeight() - this.height) * 0.5);
            this.tickMarkCanvas.setWidth(0.39 * this.width);
            this.tickMarkCanvas.setHeight(this.height);
            this.tickMarkCanvas.relocate(0.578125 * this.width, 0.0);
            this.sectionsCanvas.setWidth(0.5 * this.width);
            this.sectionsCanvas.setHeight(0.89 * this.height);
            this.sectionsCanvas.relocate(0.078125 * this.width, 0.1 * this.height);
            this.barRect.setWidth(0.16666667 * this.width);
            this.barRect.setHeight(currentValue * this.stepSize);
            this.barRect.setX(0.078125 * this.width + (0.5 * this.width - this.barRect.getWidth()) * 0.5);
            this.barRect.setY(this.height - currentValue * this.stepSize);
            this.thresholdRect.setX(0.16145833 * this.width);
            this.thresholdRect.setY(this.height - ((Gauge)this.getSkinnable()).getThreshold() * this.stepSize - 0.03125 * this.width);
            this.thresholdRect.setWidth(0.33333333 * this.width);
            this.thresholdRect.setHeight(0.0625 * this.width);
            double maxTextWidth = this.width;
            this.titleText.setFont(Fonts.robotoRegular(0.24 * this.width));
            if (this.titleText.getLayoutBounds().getWidth() > maxTextWidth) {
                this.adjustTextSize(this.titleText, maxTextWidth, 0.3);
            }
            this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, 0.03 * this.width);
            this.unitText.setFont(Fonts.robotoRegular(0.15 * this.width));
            if (this.unitText.getLayoutBounds().getWidth() > maxTextWidth) {
                this.adjustTextSize(this.unitText, maxTextWidth, 0.2);
            }
            this.unitText.relocate((this.width - this.unitText.getLayoutBounds().getWidth()) * 0.5, 0.35 * this.width);
        } else {
            this.height = this.width * this.aspectRatio;
            this.stepSize = 0.79699248 * this.width / ((Gauge)this.getSkinnable()).getRange();
            this.pane.setMaxSize(this.width, this.height);
            this.pane.relocate((((Gauge)this.getSkinnable()).getWidth() - this.width) * 0.5, (((Gauge)this.getSkinnable()).getHeight() - this.height) * 0.5);
            this.tickMarkCanvas.setWidth(this.width);
            this.tickMarkCanvas.setHeight(0.29166667 * this.height);
            this.tickMarkCanvas.relocate(0.0, 0.60416667 * this.height);
            this.sectionsCanvas.setWidth(0.79699248 * this.width);
            this.sectionsCanvas.setHeight(0.5 * this.height);
            this.sectionsCanvas.relocate(0.18345865 * this.width, 0.10416667 * this.height);
            this.barRect.setWidth(currentValue * this.stepSize);
            this.barRect.setHeight(0.16666667 * this.height);
            this.barRect.setX(0.18345865 * this.width);
            this.barRect.setY(0.10416667 * this.height + (0.5 * this.height - this.barRect.getHeight()) * 0.5);
            this.thresholdRect.setX(((Gauge)this.getSkinnable()).getThreshold() * this.stepSize - 0.03125 * this.height + 0.20300752 * this.width);
            this.thresholdRect.setY(0.1875 * this.height);
            this.thresholdRect.setWidth(0.0625 * this.height);
            this.thresholdRect.setHeight(0.33333333 * this.height);
            double maxTextWidth = 0.20300752 * this.width;
            this.titleText.setFont(Fonts.robotoMedium(0.24 * this.height));
            if (this.titleText.getLayoutBounds().getWidth() > maxTextWidth) {
                this.adjustTextSize(this.titleText, maxTextWidth, 0.3);
            }
            this.titleText.relocate(0.17593985 * this.width - this.titleText.getLayoutBounds().getWidth(), 0.075 * this.height);
            this.unitText.setFont(Fonts.robotoRegular(0.15 * this.height));
            if (this.unitText.getLayoutBounds().getWidth() > maxTextWidth) {
                this.adjustTextSize(this.unitText, maxTextWidth, 0.2);
            }
            this.unitText.relocate(0.17593985 * this.width - this.unitText.getLayoutBounds().getWidth(), 0.4 * this.height);
        }
        this.redraw();
    }

    private void redraw() {
        this.locale = ((Gauge)this.getSkinnable()).getLocale();
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Gauge)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(((Gauge)this.getSkinnable()).getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.drawTickMarks(this.tickMarksCtx);
        this.drawSections(this.sectionsCtx);
        this.thresholdRect.setFill((Paint)((Gauge)this.getSkinnable()).getThresholdColor());
        this.thresholdTooltip.setText(String.format(this.locale, this.formatString, ((Gauge)this.getSkinnable()).getThreshold()));
        this.barRect.setFill((Paint)((Gauge)this.getSkinnable()).getBarColor());
        this.titleText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.unitText.setFill((Paint)((Gauge)this.getSkinnable()).getUnitColor());
        this.updateBar();
    }
}

