/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa;

import eu.hansolo.medusa.Clock;
import eu.hansolo.medusa.ClockBuilder;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.GaugeBuilder;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Random;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Stop;
import javafx.stage.Stage;

public class Test
extends Application {
    private static final Random RND = new Random();
    private static int noOfNodes = 0;
    private Gauge gauge;
    private Clock clock;
    private long lastTimerCall;
    private AnimationTimer timer;
    private DoubleProperty value;
    private BooleanProperty toggle;

    public void init() {
        NumberFormat numberFormat = NumberFormat.getInstance(new Locale("da", "DK"));
        numberFormat.setRoundingMode(RoundingMode.HALF_DOWN);
        numberFormat.setMinimumIntegerDigits(3);
        numberFormat.setMaximumIntegerDigits(3);
        numberFormat.setMinimumFractionDigits(0);
        numberFormat.setMaximumFractionDigits(0);
        this.value = new SimpleDoubleProperty(0.0);
        this.toggle = new SimpleBooleanProperty(false);
        this.gauge = ((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)GaugeBuilder.create().skinType(Gauge.SkinType.CHARGE)).prefSize(400.0, 400.0)).animated(true)).checkThreshold(true)).onThresholdExceeded((EventHandler<Gauge.ThresholdEvent>)((EventHandler)e -> System.out.println("threshold exceeded")))).threshold(50.0)).lcdVisible(true)).locale(Locale.GERMANY)).numberFormat(numberFormat)).build();
        this.gauge.valueProperty().bind((ObservableValue)this.value);
        this.clock = ((ClockBuilder)((ClockBuilder)((ClockBuilder)ClockBuilder.create().skinType(Clock.ClockSkinType.MINIMAL)).discreteSeconds(false)).secondsVisible(true)).build();
        this.lastTimerCall = System.nanoTime();
        this.timer = new AnimationTimer(){

            public void handle(long now) {
                if (now > Test.this.lastTimerCall + 3000000000L) {
                    double v = RND.nextDouble() * Test.this.gauge.getRange() + Test.this.gauge.getMinValue();
                    Test.this.value.set(v);
                    Test.this.lastTimerCall = now;
                }
            }
        };
    }

    public void start(Stage stage) {
        StackPane pane = new StackPane(new Node[]{this.gauge});
        pane.setPadding(new Insets(20.0));
        LinearGradient gradient = new LinearGradient(0.0, 0.0, 0.0, pane.getLayoutBounds().getHeight(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)38, (int)38, (int)38)), new Stop(1.0, Color.rgb((int)15, (int)15, (int)15))});
        Scene scene = new Scene((Parent)pane);
        stage.setTitle("Medusa");
        stage.setScene(scene);
        stage.show();
        Test.calcNoOfNodes((Node)pane);
        System.out.println(noOfNodes + " Nodes in SceneGraph");
        this.timer.start();
    }

    public void stop() {
        System.exit(0);
    }

    private static void calcNoOfNodes(Node node) {
        if (node instanceof Parent && ((Parent)node).getChildrenUnmodifiable().size() != 0) {
            ObservableList tempChildren = ((Parent)node).getChildrenUnmodifiable();
            noOfNodes += tempChildren.size();
            for (Node n : tempChildren) {
                Test.calcNoOfNodes(n);
            }
        }
    }

    public static void main(String[] args) {
        Test.launch((String[])args);
    }
}

