/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Alarm;
import eu.hansolo.medusa.Clock;
import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.TimeSection;
import eu.hansolo.medusa.tools.Helper;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Text;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;

public class DBClockSkin
extends SkinBase<Clock>
implements Skin<Clock> {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("EEEE\ndd.MM.YYYY\nHH:mm:ss");
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm");
    private Map<Alarm, Circle> alarmMap = new ConcurrentHashMap<Alarm, Circle>();
    private double size;
    private Canvas sectionsAndAreasCanvas;
    private GraphicsContext sectionsAndAreasCtx;
    private Canvas tickCanvas;
    private GraphicsContext tickCtx;
    private Rectangle hour;
    private Rectangle minute;
    private Path second;
    private Circle knob;
    private Text title;
    private Text text;
    private Pane pane;
    private Pane alarmPane;
    private Rotate hourRotate;
    private Rotate minuteRotate = new Rotate();
    private Rotate secondRotate;
    private Group shadowGroup;
    private DropShadow dropShadow;
    private List<TimeSection> sections;
    private List<TimeSection> areas;
    private boolean sectionsVisible;
    private boolean highlightSections;
    private boolean areasVisible;
    private boolean highlightAreas;

    public DBClockSkin(Clock clock) {
        super((Control)clock);
        this.hourRotate = new Rotate();
        this.secondRotate = new Rotate();
        this.sections = clock.getSections();
        this.areas = clock.getAreas();
        this.sections = clock.getSections();
        this.highlightSections = clock.isHighlightSections();
        this.sectionsVisible = clock.getSectionsVisible();
        this.areas = clock.getAreas();
        this.highlightAreas = clock.isHighlightAreas();
        this.areasVisible = clock.getAreasVisible();
        this.updateAlarms();
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if ((Double.compare(((Clock)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getHeight(), 0.0) <= 0) && ((Clock)this.getSkinnable()).getPrefWidth() < 0.0 && ((Clock)this.getSkinnable()).getPrefHeight() < 0.0) {
            ((Clock)this.getSkinnable()).setPrefSize(250.0, 250.0);
        }
        if (Double.compare(((Clock)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((Clock)this.getSkinnable()).setMinSize(50.0, 50.0);
        }
        if (Double.compare(((Clock)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((Clock)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.sectionsAndAreasCanvas = new Canvas(250.0, 250.0);
        this.sectionsAndAreasCtx = this.sectionsAndAreasCanvas.getGraphicsContext2D();
        this.tickCanvas = new Canvas(250.0, 250.0);
        this.tickCtx = this.tickCanvas.getGraphicsContext2D();
        this.alarmPane = new Pane();
        this.hour = new Rectangle(3.0, 60.0);
        this.hour.setArcHeight(3.0);
        this.hour.setArcWidth(3.0);
        this.hour.setStroke(null);
        this.hour.setFill((Paint)((Clock)this.getSkinnable()).getHourColor());
        this.hour.getTransforms().setAll((Object[])new Transform[]{this.hourRotate});
        this.minute = new Rectangle(3.0, 96.0);
        this.minute.setArcHeight(3.0);
        this.minute.setArcWidth(3.0);
        this.minute.setStroke(null);
        this.minute.setFill((Paint)((Clock)this.getSkinnable()).getMinuteColor());
        this.minute.getTransforms().setAll((Object[])new Transform[]{this.minuteRotate});
        this.second = new Path();
        this.second.setFillRule(FillRule.EVEN_ODD);
        this.second.setStroke(null);
        this.second.setFill((Paint)((Clock)this.getSkinnable()).getSecondColor());
        this.second.getTransforms().setAll((Object[])new Transform[]{this.secondRotate});
        this.second.setVisible(((Clock)this.getSkinnable()).isSecondsVisible());
        this.second.setManaged(((Clock)this.getSkinnable()).isSecondsVisible());
        this.knob = new Circle(125.0, 125.0, 4.5);
        this.knob.setStroke(null);
        this.knob.setFill((Paint)((Clock)this.getSkinnable()).getKnobColor());
        this.dropShadow = new DropShadow();
        this.dropShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.25));
        this.dropShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.dropShadow.setRadius(3.75);
        this.dropShadow.setOffsetY(3.75);
        this.shadowGroup = new Group(new Node[]{this.hour, this.minute, this.second, this.knob});
        this.shadowGroup.setEffect((Effect)(((Clock)this.getSkinnable()).getShadowsEnabled() ? this.dropShadow : null));
        this.title = new Text("");
        this.title.setVisible(((Clock)this.getSkinnable()).isTitleVisible());
        this.title.setManaged(((Clock)this.getSkinnable()).isTitleVisible());
        this.text = new Text("");
        this.text.setVisible(((Clock)this.getSkinnable()).isTextVisible());
        this.text.setManaged(((Clock)this.getSkinnable()).isTextVisible());
        this.pane = new Pane(new Node[]{this.sectionsAndAreasCanvas, this.tickCanvas, this.alarmPane, this.title, this.text, this.shadowGroup});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Clock)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(((Clock)this.getSkinnable()).getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Clock)this.getSkinnable()).getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((Clock)this.getSkinnable()).widthProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Clock)this.getSkinnable()).heightProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Clock)this.getSkinnable()).setOnUpdate(e -> this.handleEvents(e.eventType.name()));
        if (((Clock)this.getSkinnable()).isAnimated()) {
            ((Clock)this.getSkinnable()).currentTimeProperty().addListener(o -> this.updateTime(ZonedDateTime.ofInstant(Instant.ofEpochSecond(((Clock)this.getSkinnable()).getCurrentTime()), ZoneId.of(ZoneId.systemDefault().getId()))));
        } else {
            ((Clock)this.getSkinnable()).timeProperty().addListener(o -> this.updateTime(((Clock)this.getSkinnable()).getTime()));
        }
        ((Clock)this.getSkinnable()).getAlarms().addListener(c -> {
            this.updateAlarms();
            this.redraw();
        });
    }

    private void handleEvents(String EVENT_TYPE) {
        if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
            this.redraw();
        } else if ("REDRAW".equals(EVENT_TYPE)) {
            this.redraw();
        } else if ("VISIBILITY".equals(EVENT_TYPE)) {
            this.title.setVisible(((Clock)this.getSkinnable()).isTitleVisible());
            this.title.setManaged(((Clock)this.getSkinnable()).isTitleVisible());
            this.text.setVisible(((Clock)this.getSkinnable()).isTextVisible());
            this.text.setManaged(((Clock)this.getSkinnable()).isTextVisible());
            this.second.setVisible(((Clock)this.getSkinnable()).isSecondsVisible());
            this.second.setManaged(((Clock)this.getSkinnable()).isSecondsVisible());
        } else if ("SECTION".equals(EVENT_TYPE)) {
            this.sections = ((Clock)this.getSkinnable()).getSections();
            this.highlightSections = ((Clock)this.getSkinnable()).isHighlightSections();
            this.sectionsVisible = ((Clock)this.getSkinnable()).getSectionsVisible();
            this.areas = ((Clock)this.getSkinnable()).getAreas();
            this.highlightAreas = ((Clock)this.getSkinnable()).isHighlightAreas();
            this.areasVisible = ((Clock)this.getSkinnable()).getAreasVisible();
            this.redraw();
        }
    }

    private void drawTicks() {
        double startAngle = 180.0;
        double angleStep = 6.0;
        Point2D center = new Point2D(this.size * 0.5, this.size * 0.5);
        Color hourTickMarkColor = ((Clock)this.getSkinnable()).getHourTickMarkColor();
        Color minuteTickMarkColor = ((Clock)this.getSkinnable()).getMinuteTickMarkColor();
        boolean hourTickMarksVisible = ((Clock)this.getSkinnable()).isHourTickMarksVisible();
        boolean minuteTickMarksVisible = ((Clock)this.getSkinnable()).isMinuteTickMarksVisible();
        this.tickCtx.clearRect(0.0, 0.0, this.size, this.size);
        this.tickCtx.setLineCap(StrokeLineCap.BUTT);
        double angle = 0.0;
        double counter = 0.0;
        while (Double.compare(counter, 59.0) <= 0) {
            double sinValue = Math.sin(Math.toRadians(angle + startAngle));
            double cosValue = Math.cos(Math.toRadians(angle + startAngle));
            Point2D innerMainPoint = new Point2D(center.getX() + this.size * 0.335 * sinValue, center.getY() + this.size * 0.335 * cosValue);
            Point2D innerPoint = new Point2D(center.getX() + this.size * 0.365 * sinValue, center.getY() + this.size * 0.365 * cosValue);
            Point2D innerMinutePoint = new Point2D(center.getX() + this.size * 0.425 * sinValue, center.getY() + this.size * 0.425 * cosValue);
            Point2D outerPoint = new Point2D(center.getX() + this.size * 0.465 * sinValue, center.getY() + this.size * 0.465 * cosValue);
            if (counter % 5.0 == 0.0 && counter % 3.0 == 0.0) {
                this.tickCtx.setStroke((Paint)hourTickMarkColor);
                if (hourTickMarksVisible) {
                    this.tickCtx.setLineWidth(this.size * 0.0375);
                    this.tickCtx.strokeLine(innerMainPoint.getX(), innerMainPoint.getY(), outerPoint.getX(), outerPoint.getY());
                } else if (minuteTickMarksVisible) {
                    this.tickCtx.setLineWidth(this.size * 0.02);
                    this.tickCtx.strokeLine(innerMinutePoint.getX(), innerMinutePoint.getY(), outerPoint.getX(), outerPoint.getY());
                }
            } else if (counter % 5.0 == 0.0) {
                this.tickCtx.setStroke((Paint)hourTickMarkColor);
                if (hourTickMarksVisible) {
                    this.tickCtx.setLineWidth(this.size * 0.0375);
                    this.tickCtx.strokeLine(innerPoint.getX(), innerPoint.getY(), outerPoint.getX(), outerPoint.getY());
                } else if (minuteTickMarksVisible) {
                    this.tickCtx.setLineWidth(this.size * 0.02);
                    this.tickCtx.strokeLine(innerMinutePoint.getX(), innerMinutePoint.getY(), outerPoint.getX(), outerPoint.getY());
                }
            } else if (counter % 1.0 == 0.0 && minuteTickMarksVisible) {
                this.tickCtx.setStroke((Paint)minuteTickMarkColor);
                this.tickCtx.setLineWidth(this.size * 0.02);
                this.tickCtx.strokeLine(innerMinutePoint.getX(), innerMinutePoint.getY(), outerPoint.getX(), outerPoint.getY());
            }
            angle -= angleStep;
            counter += 1.0;
        }
    }

    private void updateAlarms() {
        this.alarmMap.clear();
        for (Alarm alarm : ((Clock)this.getSkinnable()).getAlarms()) {
            this.alarmMap.put(alarm, new Circle());
        }
    }

    private void createSecondPointer() {
        double width = this.size * 0.11866667;
        double height = this.size * 0.46266667;
        this.second.setCache(false);
        this.second.getElements().clear();
        this.second.getElements().add((Object)new MoveTo(0.1348314606741573 * width, 0.4365994236311239 * height));
        this.second.getElements().add((Object)new CubicCurveTo(0.1348314606741573 * width, 0.38328530259365995 * height, 0.29775280898876405 * width, 0.3414985590778098 * height, 0.5 * width, 0.3414985590778098 * height));
        this.second.getElements().add((Object)new CubicCurveTo(0.702247191011236 * width, 0.3414985590778098 * height, 0.8651685393258427 * width, 0.38328530259365995 * height, 0.8651685393258427 * width, 0.4365994236311239 * height));
        this.second.getElements().add((Object)new CubicCurveTo(0.8651685393258427 * width, 0.4884726224783862 * height, 0.702247191011236 * width, 0.5302593659942363 * height, 0.5 * width, 0.5302593659942363 * height));
        this.second.getElements().add((Object)new CubicCurveTo(0.29775280898876405 * width, 0.5302593659942363 * height, 0.1348314606741573 * width, 0.4884726224783862 * height, 0.1348314606741573 * width, 0.4365994236311239 * height));
        this.second.getElements().add((Object)new ClosePath());
        this.second.getElements().add((Object)new MoveTo(0.0, 0.4365994236311239 * height));
        this.second.getElements().add((Object)new CubicCurveTo(0.0, 0.5 * height, 0.1853932584269663 * width, 0.553314121037464 * height, 0.42134831460674155 * width, 0.5634005763688761 * height));
        this.second.getElements().add((Object)new CubicCurveTo(0.42134831460674155 * width, 0.5634005763688761 * height, 0.398876404494382 * width, height, 0.398876404494382 * width, height));
        this.second.getElements().add((Object)new LineTo(0.601123595505618 * width, height));
        this.second.getElements().add((Object)new CubicCurveTo(0.601123595505618 * width, height, 0.5786516853932584 * width, 0.5634005763688761 * height, 0.5786516853932584 * width, 0.5634005763688761 * height));
        this.second.getElements().add((Object)new CubicCurveTo(0.8146067415730337 * width, 0.553314121037464 * height, width, 0.5 * height, width, 0.4365994236311239 * height));
        this.second.getElements().add((Object)new CubicCurveTo(width, 0.3703170028818444 * height, 0.8089887640449438 * width, 0.3170028818443804 * height, 0.5617977528089888 * width, 0.30835734870317005 * height));
        this.second.getElements().add((Object)new CubicCurveTo(0.5617977528089888 * width, 0.30835734870317005 * height, 0.5449438202247191 * width, 0.0, 0.5449438202247191 * width, 0.0));
        this.second.getElements().add((Object)new LineTo(0.4550561797752809 * width, 0.0));
        this.second.getElements().add((Object)new CubicCurveTo(0.4550561797752809 * width, 0.0, 0.43820224719101125 * width, 0.30835734870317005 * height, 0.43820224719101125 * width, 0.30835734870317005 * height));
        this.second.getElements().add((Object)new CubicCurveTo(0.19101123595505617 * width, 0.3170028818443804 * height, 0.0, 0.3703170028818444 * height, 0.0, 0.4365994236311239 * height));
        this.second.getElements().add((Object)new ClosePath());
        this.second.setCache(true);
        this.second.setCacheHint(CacheHint.ROTATE);
    }

    public void updateTime(ZonedDateTime TIME) {
        if (((Clock)this.getSkinnable()).isDiscreteMinutes()) {
            this.minuteRotate.setAngle((double)(TIME.getMinute() * 6));
        } else {
            this.minuteRotate.setAngle((double)(TIME.getMinute() * 6) + (double)TIME.getSecond() * 0.1);
        }
        if (((Clock)this.getSkinnable()).isDiscreteSeconds() && this.second.isVisible()) {
            this.secondRotate.setAngle((double)(TIME.getSecond() * 6));
        } else {
            this.secondRotate.setAngle((double)(TIME.getSecond() * 6) + (double)TIME.get(ChronoField.MILLI_OF_SECOND) * 0.006);
        }
        if (((Clock)this.getSkinnable()).isDiscreteHours()) {
            this.hourRotate.setAngle((double)(TIME.getHour() * 30));
        } else {
            this.hourRotate.setAngle(0.5 * (double)(60 * TIME.getHour() + TIME.getMinute()));
        }
        if (this.text.isVisible()) {
            this.text.setText(TIME_FORMATTER.format(TIME));
            Helper.adjustTextSize(this.text, 0.6 * this.size, this.size * 0.12);
            this.text.relocate((this.size - this.text.getLayoutBounds().getWidth()) * 0.5, this.size * 0.6);
        }
        if (TIME.getMinute() == 0 && TIME.getSecond() == 0) {
            Helper.drawAlarms((Clock)this.getSkinnable(), this.size, 0.02, 0.445, this.alarmMap, DATE_TIME_FORMATTER, TIME);
        }
        if (this.highlightAreas | this.highlightSections) {
            this.sectionsAndAreasCtx.clearRect(0.0, 0.0, this.size, this.size);
            if (this.areasVisible) {
                Helper.drawTimeAreas((Clock)this.getSkinnable(), this.sectionsAndAreasCtx, this.areas, this.size, 0.035, 0.035, 0.93, 0.93);
            }
            if (this.sectionsVisible) {
                Helper.drawTimeSections((Clock)this.getSkinnable(), this.sectionsAndAreasCtx, this.sections, this.size, 0.056, 0.056, 0.89, 0.89, 0.0395);
            }
        }
    }

    private void resize() {
        double height;
        double width = ((Clock)this.getSkinnable()).getWidth() - ((Clock)this.getSkinnable()).getInsets().getLeft() - ((Clock)this.getSkinnable()).getInsets().getRight();
        double d = this.size = width < (height = ((Clock)this.getSkinnable()).getHeight() - ((Clock)this.getSkinnable()).getInsets().getTop() - ((Clock)this.getSkinnable()).getInsets().getBottom()) ? width : height;
        if (this.size > 0.0) {
            double center = this.size * 0.5;
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((((Clock)this.getSkinnable()).getWidth() - this.size) * 0.5, (((Clock)this.getSkinnable()).getHeight() - this.size) * 0.5);
            this.dropShadow.setRadius(0.008 * this.size);
            this.dropShadow.setOffsetY(0.008 * this.size);
            this.sectionsAndAreasCanvas.setWidth(this.size);
            this.sectionsAndAreasCanvas.setHeight(this.size);
            this.tickCanvas.setWidth(this.size);
            this.tickCanvas.setHeight(this.size);
            this.alarmPane.setMaxSize(this.size, this.size);
            this.hour.setFill((Paint)((Clock)this.getSkinnable()).getHourColor());
            this.hour.setCache(false);
            this.hour.setWidth(this.size * 0.05);
            this.hour.setHeight(this.size * 0.3125);
            this.hour.setCache(true);
            this.hour.setCacheHint(CacheHint.ROTATE);
            this.hour.relocate((this.size - this.hour.getWidth()) * 0.5, center - this.size * 0.3125);
            this.minute.setFill((Paint)((Clock)this.getSkinnable()).getMinuteColor());
            this.minute.setCache(false);
            this.minute.setWidth(this.size * 0.038);
            this.minute.setHeight(this.size * 0.4375);
            this.minute.setCache(true);
            this.minute.setCacheHint(CacheHint.ROTATE);
            this.minute.relocate((this.size - this.minute.getWidth()) * 0.5, center - this.size * 0.4375);
            this.createSecondPointer();
            this.second.setFill((Paint)((Clock)this.getSkinnable()).getSecondColor());
            this.second.relocate((this.size - this.second.getLayoutBounds().getWidth()) * 0.5, center - this.second.getLayoutBounds().getHeight());
            this.knob.setFill((Paint)((Clock)this.getSkinnable()).getKnobColor());
            this.knob.setRadius(this.size * 0.05);
            this.knob.setCenterX(center);
            this.knob.setCenterY(center);
            this.title.setFill((Paint)((Clock)this.getSkinnable()).getTextColor());
            this.title.setFont(Fonts.latoLight(this.size * 0.12));
            this.title.relocate((this.size - this.title.getLayoutBounds().getWidth()) * 0.5, this.size * 0.25);
            this.text.setFill((Paint)((Clock)this.getSkinnable()).getTextColor());
            this.text.setFont(Fonts.latoLight(this.size * 0.12));
            this.text.relocate((this.size - this.text.getLayoutBounds().getWidth()) * 0.5, this.size * 0.6);
            this.minuteRotate.setPivotX(this.minute.getWidth() * 0.5);
            this.minuteRotate.setPivotY(this.minute.getHeight());
            this.hourRotate.setPivotX(this.hour.getWidth() * 0.5);
            this.hourRotate.setPivotY(this.hour.getHeight());
            this.secondRotate.setPivotX(this.second.getLayoutBounds().getWidth() * 0.5);
            this.secondRotate.setPivotY(this.second.getLayoutBounds().getHeight());
        }
    }

    private void redraw() {
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Clock)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(((Clock)this.getSkinnable()).getBorderWidth() / 250.0 * this.size))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Clock)this.getSkinnable()).getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.shadowGroup.setEffect((Effect)(((Clock)this.getSkinnable()).getShadowsEnabled() ? this.dropShadow : null));
        this.sectionsAndAreasCtx.clearRect(0.0, 0.0, this.size, this.size);
        if (this.areasVisible) {
            Helper.drawTimeAreas((Clock)this.getSkinnable(), this.sectionsAndAreasCtx, this.areas, this.size, 0.035, 0.035, 0.93, 0.93);
        }
        if (this.sectionsVisible) {
            Helper.drawTimeSections((Clock)this.getSkinnable(), this.sectionsAndAreasCtx, this.sections, this.size, 0.056, 0.056, 0.89, 0.89, 0.0395);
        }
        this.tickCanvas.setCache(false);
        this.drawTicks();
        this.tickCanvas.setCache(true);
        this.tickCanvas.setCacheHint(CacheHint.QUALITY);
        ZonedDateTime time = ((Clock)this.getSkinnable()).getTime();
        this.updateTime(time);
        this.title.setText(((Clock)this.getSkinnable()).getTitle());
        Helper.adjustTextSize(this.title, 0.6 * this.size, this.size * 0.12);
        this.title.relocate((this.size - this.title.getLayoutBounds().getWidth()) * 0.5, this.size * 0.25);
        this.text.setText(TIME_FORMATTER.format(time));
        Helper.adjustTextSize(this.text, 0.6 * this.size, this.size * 0.12);
        this.text.relocate((this.size - this.text.getLayoutBounds().getWidth()) * 0.5, this.size * 0.6);
        this.alarmPane.getChildren().setAll(this.alarmMap.values());
        Helper.drawAlarms((Clock)this.getSkinnable(), this.size, 0.02, 0.445, this.alarmMap, DATE_TIME_FORMATTER, time);
    }
}

