/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.tools.Helper;
import java.util.List;
import java.util.Locale;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;

public class IndicatorSkin
extends SkinBase<Gauge>
implements Skin<Gauge> {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 165.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final double ASPECT_RATIO = 0.59375;
    private double width;
    private double height;
    private double oldValue;
    private Arc barBackground;
    private Arc bar;
    private Path needle;
    private MoveTo needleMoveTo1;
    private CubicCurveTo needleCubicCurveTo2;
    private CubicCurveTo needleCubicCurveTo3;
    private CubicCurveTo needleCubicCurveTo4;
    private CubicCurveTo needleCubicCurveTo5;
    private CubicCurveTo needleCubicCurveTo6;
    private CubicCurveTo needleCubicCurveTo7;
    private ClosePath needleClosePath8;
    private Rotate needleRotate;
    private Text minValueText;
    private Text maxValueText;
    private Pane pane;
    private double angleRange;
    private double minValue;
    private double range;
    private double angleStep;
    private double startAngle;
    private boolean colorGradientEnabled;
    private int noOfGradientStops;
    private boolean sectionsVisible;
    private List<Section> sections;
    private Tooltip needleTooltip;
    private String formatString;
    private Color barColor;

    public IndicatorSkin(Gauge gauge) {
        super((Control)gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.angleRange = Helper.clamp(90.0, 180.0, gauge.getAngleRange());
        this.startAngle = this.getStartAngle();
        this.oldValue = gauge.getValue();
        this.minValue = gauge.getMinValue();
        this.range = gauge.getRange();
        this.angleStep = this.angleRange / this.range;
        this.colorGradientEnabled = gauge.isGradientBarEnabled();
        this.noOfGradientStops = gauge.getGradientBarStops().size();
        this.sectionsVisible = gauge.getSectionsVisible();
        this.sections = gauge.getSections();
        this.formatString = "%." + Integer.toString(gauge.getDecimals()) + "f";
        this.barColor = gauge.getBarColor();
        this.init();
        this.initGraphics();
        this.registerListeners();
        this.rotateNeedle(gauge.getCurrentValue());
    }

    private void init() {
        if ((Double.compare(((Gauge)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getHeight(), 0.0) <= 0) && ((Gauge)this.getSkinnable()).getPrefWidth() < 0.0 && ((Gauge)this.getSkinnable()).getPrefHeight() < 0.0) {
            ((Gauge)this.getSkinnable()).setPrefSize(250.0, 165.0);
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMinSize(50.0, 50.0);
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.barBackground = new Arc(125.0, 114.83999999999999, 68.75, 68.75, this.angleRange * 0.5 + 90.0, -this.angleRange);
        this.barBackground.setType(ArcType.OPEN);
        this.barBackground.setStroke((Paint)((Gauge)this.getSkinnable()).getBarBackgroundColor());
        this.barBackground.setStrokeWidth(14.097745);
        this.barBackground.setStrokeLineCap(StrokeLineCap.BUTT);
        this.barBackground.setFill(null);
        this.bar = new Arc(125.0, 114.83999999999999, 68.75, 68.75, this.angleRange * 0.5 + 90.0, 0.0);
        this.bar.setType(ArcType.OPEN);
        this.bar.setStroke((Paint)((Gauge)this.getSkinnable()).getBarColor());
        this.bar.setStrokeWidth(14.097745);
        this.bar.setStrokeLineCap(StrokeLineCap.BUTT);
        this.bar.setFill(null);
        this.needleRotate = new Rotate((((Gauge)this.getSkinnable()).getValue() - this.oldValue - this.minValue) * this.angleStep);
        this.needleMoveTo1 = new MoveTo();
        this.needleCubicCurveTo2 = new CubicCurveTo();
        this.needleCubicCurveTo3 = new CubicCurveTo();
        this.needleCubicCurveTo4 = new CubicCurveTo();
        this.needleCubicCurveTo5 = new CubicCurveTo();
        this.needleCubicCurveTo6 = new CubicCurveTo();
        this.needleCubicCurveTo7 = new CubicCurveTo();
        this.needleClosePath8 = new ClosePath();
        this.needle = new Path(new PathElement[]{this.needleMoveTo1, this.needleCubicCurveTo2, this.needleCubicCurveTo3, this.needleCubicCurveTo4, this.needleCubicCurveTo5, this.needleCubicCurveTo6, this.needleCubicCurveTo7, this.needleClosePath8});
        this.needle.setFillRule(FillRule.EVEN_ODD);
        this.needle.getTransforms().setAll((Object[])new Transform[]{this.needleRotate});
        this.needle.setFill((Paint)((Gauge)this.getSkinnable()).getNeedleColor());
        this.needle.setStrokeType(StrokeType.INSIDE);
        this.needle.setStrokeWidth(1.0);
        this.needle.setStroke(((Gauge)this.getSkinnable()).getBackgroundPaint());
        this.needleTooltip = new Tooltip(String.format(Locale.US, this.formatString, ((Gauge)this.getSkinnable()).getValue()));
        this.needleTooltip.setTextAlignment(TextAlignment.CENTER);
        Tooltip.install((Node)this.needle, (Tooltip)this.needleTooltip);
        this.minValueText = new Text(String.format(Locale.US, "%." + ((Gauge)this.getSkinnable()).getTickLabelDecimals() + "f", ((Gauge)this.getSkinnable()).getMinValue()));
        this.minValueText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.minValueText.setVisible(((Gauge)this.getSkinnable()).getTickLabelsVisible());
        this.maxValueText = new Text(String.format(Locale.US, "%." + ((Gauge)this.getSkinnable()).getTickLabelDecimals() + "f", ((Gauge)this.getSkinnable()).getMaxValue()));
        this.maxValueText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.maxValueText.setVisible(((Gauge)this.getSkinnable()).getTickLabelsVisible());
        this.pane = new Pane(new Node[]{this.barBackground, this.bar, this.needle, this.minValueText, this.maxValueText});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Gauge)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(((Gauge)this.getSkinnable()).getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((Gauge)this.getSkinnable()).widthProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).heightProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).setOnUpdate(e -> this.handleEvents(e.eventType.name()));
        ((Gauge)this.getSkinnable()).currentValueProperty().addListener(o -> this.rotateNeedle(((Gauge)this.getSkinnable()).getCurrentValue()));
    }

    private void handleEvents(String EVENT_TYPE) {
        if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
            this.redraw();
        } else if ("REDRAW".equals(EVENT_TYPE)) {
            this.redraw();
        } else if ("RECALC".equals(EVENT_TYPE)) {
            this.angleRange = Helper.clamp(90.0, 180.0, ((Gauge)this.getSkinnable()).getAngleRange());
            this.startAngle = this.getStartAngle();
            this.minValue = ((Gauge)this.getSkinnable()).getMinValue();
            this.range = ((Gauge)this.getSkinnable()).getRange();
            this.sections = ((Gauge)this.getSkinnable()).getSections();
            this.angleStep = this.angleRange / this.range;
            this.redraw();
        } else if ("FINISHED".equals(EVENT_TYPE)) {
            this.needleTooltip.setText(String.format(Locale.US, this.formatString, ((Gauge)this.getSkinnable()).getValue()));
            if (((Gauge)this.getSkinnable()).isValueVisible()) {
                Bounds bounds = this.pane.localToScreen(this.pane.getBoundsInLocal());
                double value = ((Gauge)this.getSkinnable()).getValue();
                double xFactor = value > ((Gauge)this.getSkinnable()).getRange() * 0.8 ? 0.0 : 0.25;
                double tooltipAngle = value * this.angleStep;
                double sinValue = Math.sin(Math.toRadians(180.0 + this.angleRange * 0.5 - tooltipAngle));
                double cosValue = Math.cos(Math.toRadians(180.0 + this.angleRange * 0.5 - tooltipAngle));
                double needleTipX = bounds.getMinX() + this.width * 0.5 + this.height * sinValue;
                double needleTipY = bounds.getMinY() + this.height * 0.72 + this.height * cosValue;
                this.needleTooltip.show((Node)this.needle, needleTipX, needleTipY);
                this.needleTooltip.setAnchorX(this.needleTooltip.getX() - this.needleTooltip.getWidth() * xFactor);
            }
        }
    }

    private double getStartAngle() {
        Gauge.ScaleDirection scaleDirection = ((Gauge)this.getSkinnable()).getScaleDirection();
        switch (scaleDirection) {
            default: 
        }
        return 180.0 + this.angleRange * 0.5;
    }

    private void rotateNeedle(double VALUE) {
        double needleStartAngle = this.angleRange * 0.5;
        double targetAngle = (VALUE - this.minValue) * this.angleStep - needleStartAngle;
        targetAngle = Helper.clamp(-needleStartAngle, -needleStartAngle + this.angleRange, targetAngle);
        this.needleRotate.setAngle(targetAngle);
        this.bar.setLength(-(((Gauge)this.getSkinnable()).getCurrentValue() - this.minValue) * this.angleStep);
        this.setBarColor(VALUE);
    }

    private void setBarColor(double VALUE) {
        if (!this.sectionsVisible && !this.colorGradientEnabled) {
            this.bar.setStroke((Paint)this.barColor);
        } else if (this.colorGradientEnabled && this.noOfGradientStops > 1) {
            this.bar.setStroke((Paint)((Gauge)this.getSkinnable()).getGradientLookup().getColorAt((VALUE - this.minValue) / this.range));
        } else {
            this.bar.setStroke((Paint)this.barColor);
            for (Section section : this.sections) {
                if (!section.contains(VALUE)) continue;
                this.bar.setStroke((Paint)section.getColor());
                break;
            }
        }
    }

    private void resizeStaticText() {
        double maxWidth = this.width * 0.28472222;
        double fontSize = this.height * 0.12631579;
        this.minValueText.setFont(Fonts.latoRegular(fontSize));
        if (this.minValueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.minValueText, maxWidth, fontSize);
        }
        this.minValueText.relocate(this.width * 0.28472222 - this.minValueText.getLayoutBounds().getWidth(), this.height * 0.885);
        this.maxValueText.setFont(Fonts.latoRegular(fontSize));
        if (this.maxValueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.maxValueText, maxWidth, fontSize);
        }
        this.maxValueText.relocate(this.width * 0.71527778, this.height * 0.885);
    }

    private void resize() {
        this.width = ((Gauge)this.getSkinnable()).getWidth() - ((Gauge)this.getSkinnable()).getInsets().getLeft() - ((Gauge)this.getSkinnable()).getInsets().getRight();
        this.height = ((Gauge)this.getSkinnable()).getHeight() - ((Gauge)this.getSkinnable()).getInsets().getTop() - ((Gauge)this.getSkinnable()).getInsets().getBottom();
        if (0.59375 * this.width > this.height) {
            this.width = 1.0 / (0.59375 / this.height);
        } else if (1.0 / (0.59375 / this.height) > this.width) {
            this.height = 0.59375 * this.width;
        }
        if (this.width > 0.0 && this.height > 0.0) {
            double centerX = this.width * 0.5;
            double centerY = this.height * 0.85;
            double barRadius = this.height * 0.54210526;
            double barWidth = this.width * 0.28472222;
            this.pane.setMaxSize(this.width, this.height);
            this.pane.relocate((((Gauge)this.getSkinnable()).getWidth() - this.width) * 0.5, (((Gauge)this.getSkinnable()).getHeight() - this.height) * 0.5);
            this.barBackground.setCenterX(centerX);
            this.barBackground.setCenterY(centerY);
            this.barBackground.setRadiusX(barRadius);
            this.barBackground.setRadiusY(barRadius);
            this.barBackground.setStrokeWidth(barWidth);
            this.barBackground.setStartAngle(this.angleRange * 0.5 + 90.0);
            this.barBackground.setLength(-this.angleRange);
            this.bar.setCenterX(centerX);
            this.bar.setCenterY(centerY);
            this.bar.setRadiusX(barRadius);
            this.bar.setRadiusY(barRadius);
            this.bar.setStrokeWidth(barWidth);
            this.bar.setStartAngle(this.angleRange * 0.5 + 90.0);
            this.bar.setLength(-(((Gauge)this.getSkinnable()).getCurrentValue() - this.minValue) * this.angleStep);
            double needleWidth = this.height * 0.13157895;
            double needleHeight = this.height * 0.91315789;
            this.needle.setCache(true);
            this.needleMoveTo1.setX(0.0);
            this.needleMoveTo1.setY(0.927953890489914 * needleHeight);
            this.needleCubicCurveTo2.setControlX1(0.0);
            this.needleCubicCurveTo2.setControlY1(0.968299711815562 * needleHeight);
            this.needleCubicCurveTo2.setControlX2(0.22 * needleWidth);
            this.needleCubicCurveTo2.setControlY2(needleHeight);
            this.needleCubicCurveTo2.setX(0.5 * needleWidth);
            this.needleCubicCurveTo2.setY(needleHeight);
            this.needleCubicCurveTo3.setControlX1(0.78 * needleWidth);
            this.needleCubicCurveTo3.setControlY1(needleHeight);
            this.needleCubicCurveTo3.setControlX2(needleWidth);
            this.needleCubicCurveTo3.setControlY2(0.968299711815562 * needleHeight);
            this.needleCubicCurveTo3.setX(needleWidth);
            this.needleCubicCurveTo3.setY(0.927953890489914 * needleHeight);
            this.needleCubicCurveTo4.setControlX1(needleWidth);
            this.needleCubicCurveTo4.setControlY1(0.92507204610951 * needleHeight);
            this.needleCubicCurveTo4.setControlX2(0.6 * needleWidth);
            this.needleCubicCurveTo4.setControlY2(0.0144092219020173 * needleHeight);
            this.needleCubicCurveTo4.setX(0.6 * needleWidth);
            this.needleCubicCurveTo4.setY(0.0144092219020173 * needleHeight);
            this.needleCubicCurveTo5.setControlX1(0.6 * needleWidth);
            this.needleCubicCurveTo5.setControlY1(0.0144092219020173 * needleHeight);
            this.needleCubicCurveTo5.setControlX2(0.58 * needleWidth);
            this.needleCubicCurveTo5.setControlY2(0.0);
            this.needleCubicCurveTo5.setX(0.5 * needleWidth);
            this.needleCubicCurveTo5.setY(0.0);
            this.needleCubicCurveTo6.setControlX1(0.42 * needleWidth);
            this.needleCubicCurveTo6.setControlY1(0.0);
            this.needleCubicCurveTo6.setControlX2(0.4 * needleWidth);
            this.needleCubicCurveTo6.setControlY2(0.0144092219020173 * needleHeight);
            this.needleCubicCurveTo6.setX(0.4 * needleWidth);
            this.needleCubicCurveTo6.setY(0.0144092219020173 * needleHeight);
            this.needleCubicCurveTo7.setControlX1(0.4 * needleWidth);
            this.needleCubicCurveTo7.setControlY1(0.0144092219020173 * needleHeight);
            this.needleCubicCurveTo7.setControlX2(0.0);
            this.needleCubicCurveTo7.setControlY2(0.92507204610951 * needleHeight);
            this.needleCubicCurveTo7.setX(0.0);
            this.needleCubicCurveTo7.setY(0.927953890489914 * needleHeight);
            this.needle.setCache(true);
            this.needle.setCacheHint(CacheHint.ROTATE);
            this.needle.relocate((this.width - this.needle.getLayoutBounds().getWidth()) * 0.5, centerY - this.needle.getLayoutBounds().getHeight() + this.needle.getLayoutBounds().getWidth() * 0.5);
            this.needleRotate.setPivotX(this.needle.getLayoutBounds().getWidth() * 0.5);
            this.needleRotate.setPivotY(this.needle.getLayoutBounds().getHeight() - this.needle.getLayoutBounds().getWidth() * 0.5);
            this.resizeStaticText();
        }
    }

    private void redraw() {
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Gauge)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(((Gauge)this.getSkinnable()).getBorderWidth() / 165.0 * this.height))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.barColor = ((Gauge)this.getSkinnable()).getBarColor();
        this.formatString = "%." + Integer.toString(((Gauge)this.getSkinnable()).getDecimals()) + "f";
        this.colorGradientEnabled = ((Gauge)this.getSkinnable()).isGradientBarEnabled();
        this.noOfGradientStops = ((Gauge)this.getSkinnable()).getGradientBarStops().size();
        this.sectionsVisible = ((Gauge)this.getSkinnable()).getSectionsVisible();
        this.minValueText.setText(String.format(Locale.US, "%." + ((Gauge)this.getSkinnable()).getTickLabelDecimals() + "f", ((Gauge)this.getSkinnable()).getMinValue()));
        this.maxValueText.setText(String.format(Locale.US, "%." + ((Gauge)this.getSkinnable()).getTickLabelDecimals() + "f", ((Gauge)this.getSkinnable()).getMaxValue()));
        this.resizeStaticText();
        this.barBackground.setStroke((Paint)((Gauge)this.getSkinnable()).getBarBackgroundColor());
        this.bar.setStroke((Paint)((Gauge)this.getSkinnable()).getBarColor());
        this.needle.setFill((Paint)((Gauge)this.getSkinnable()).getNeedleColor());
        this.minValueText.setVisible(((Gauge)this.getSkinnable()).getTickLabelsVisible());
        this.maxValueText.setVisible(((Gauge)this.getSkinnable()).getTickLabelsVisible());
        this.minValueText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.maxValueText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
    }
}

