/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.TickLabelOrientation;
import eu.hansolo.medusa.tools.Helper;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class DigitalSkin
extends SkinBase<Gauge>
implements Skin<Gauge> {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final double START_ANGLE = -30.0;
    private static final double ANGLE_RANGE = 300.0;
    private double size;
    private double center;
    private Pane pane;
    private Canvas backgroundCanvas;
    private GraphicsContext backgroundCtx;
    private Canvas barCanvas;
    private GraphicsContext barCtx;
    private Text valueBkgText;
    private Text valueText;
    private Color barColor;
    private Color valueColor;
    private Color titleColor;
    private Color subTitleColor;
    private Color unitColor;
    private double minValue;
    private double maxValue;
    private double range;
    private double angleStep;
    private boolean isStartFromZero;
    private double barWidth;
    private String formatString;
    private boolean sectionsVisible;
    private List<Section> sections;
    private boolean thresholdVisible;
    private Color thresholdColor;

    public DigitalSkin(Gauge gauge) {
        super((Control)gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.minValue = gauge.getMinValue();
        this.maxValue = gauge.getMaxValue();
        this.range = gauge.getRange();
        this.angleStep = 300.0 / this.range;
        this.formatString = "%." + Integer.toString(gauge.getDecimals()) + "f";
        this.barColor = gauge.getBarColor();
        this.valueColor = gauge.getValueColor();
        this.titleColor = gauge.getTitleColor();
        this.subTitleColor = gauge.getSubTitleColor();
        this.unitColor = gauge.getUnitColor();
        this.isStartFromZero = gauge.isStartFromZero();
        this.sectionsVisible = gauge.getSectionsVisible();
        this.sections = gauge.getSections();
        this.thresholdVisible = gauge.isThresholdVisible();
        this.thresholdColor = gauge.getThresholdColor();
        this.init();
        this.initGraphics();
        this.registerListeners();
        this.setBar(gauge.getCurrentValue());
    }

    private void init() {
        if ((Double.compare(((Gauge)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getHeight(), 0.0) <= 0) && ((Gauge)this.getSkinnable()).getPrefWidth() < 0.0 && ((Gauge)this.getSkinnable()).getPrefHeight() < 0.0) {
            ((Gauge)this.getSkinnable()).setPrefSize(250.0, 250.0);
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMinSize(50.0, 50.0);
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.backgroundCanvas = new Canvas(250.0, 250.0);
        this.backgroundCtx = this.backgroundCanvas.getGraphicsContext2D();
        this.barCanvas = new Canvas(250.0, 250.0);
        this.barCtx = this.barCanvas.getGraphicsContext2D();
        this.valueBkgText = new Text();
        this.valueBkgText.setStroke(null);
        this.valueBkgText.setFill((Paint)Helper.getTranslucentColorFrom(this.valueColor, 0.1));
        this.valueText = new Text();
        this.valueText.setStroke(null);
        this.valueText.setFill((Paint)this.valueColor);
        this.pane = new Pane(new Node[]{this.backgroundCanvas, this.barCanvas, this.valueBkgText, this.valueText});
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Gauge)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(((Gauge)this.getSkinnable()).getBorderWidth()))}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((Gauge)this.getSkinnable()).widthProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).heightProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).setOnUpdate(e -> this.handleEvents(e.eventType.name()));
        ((Gauge)this.getSkinnable()).currentValueProperty().addListener(o -> this.setBar(((Gauge)this.getSkinnable()).getCurrentValue()));
    }

    private void handleEvents(String EVENT_TYPE) {
        if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
            this.redraw();
        } else if ("REDRAW".equals(EVENT_TYPE)) {
            this.redraw();
        } else if ("RECALC".equals(EVENT_TYPE)) {
            this.minValue = ((Gauge)this.getSkinnable()).getMinValue();
            this.maxValue = ((Gauge)this.getSkinnable()).getMaxValue();
            this.range = ((Gauge)this.getSkinnable()).getRange();
            this.angleStep = 300.0 / this.range;
            this.redraw();
        } else if ("SECTIONS".equals(EVENT_TYPE)) {
            this.sections = ((Gauge)this.getSkinnable()).getSections();
        } else if ("VISIBILITY".equals(EVENT_TYPE)) {
            this.sectionsVisible = ((Gauge)this.getSkinnable()).getSectionsVisible();
            this.thresholdVisible = ((Gauge)this.getSkinnable()).isThresholdVisible();
            this.thresholdVisible = ((Gauge)this.getSkinnable()).isThresholdVisible();
        }
    }

    private void setBar(double VALUE) {
        this.barCtx.clearRect(0.0, 0.0, this.size, this.size);
        this.barCtx.setLineCap(StrokeLineCap.BUTT);
        this.barCtx.setStroke((Paint)this.barColor);
        this.barCtx.setLineWidth(this.barWidth);
        if (this.sectionsVisible) {
            int listSize = this.sections.size();
            for (int i = 0; i < listSize; ++i) {
                Section section = this.sections.get(i);
                if (!section.contains(VALUE)) continue;
                this.barCtx.setStroke((Paint)section.getColor());
                break;
            }
        }
        if (this.thresholdVisible && VALUE > ((Gauge)this.getSkinnable()).getThreshold()) {
            this.barCtx.setStroke((Paint)this.thresholdColor);
        }
        double v = (VALUE - this.minValue) * this.angleStep;
        int minValueAngle = (int)(-this.minValue * this.angleStep);
        if (!this.isStartFromZero) {
            for (int i = 0; i < 300; ++i) {
                if (i % 6 != 0 || !((double)i < v)) continue;
                this.barCtx.strokeArc(this.barWidth * 0.5 + this.barWidth * 0.3, this.barWidth * 0.5 + this.barWidth * 0.3, this.size - this.barWidth - this.barWidth * 0.6, this.size - this.barWidth - this.barWidth * 0.6, (double)(-i - 125), 4.6, ArcType.OPEN);
            }
        } else if (Double.compare(VALUE, 0.0) != 0) {
            if (VALUE < 0.0) {
                for (int i = minValueAngle - 1; i >= 0; --i) {
                    if (i % 6 != 0 || !((double)i > v - 6.0)) continue;
                    this.barCtx.strokeArc(this.barWidth * 0.5 + this.barWidth * 0.3, this.barWidth * 0.5 + this.barWidth * 0.3, this.size - this.barWidth - this.barWidth * 0.6, this.size - this.barWidth - this.barWidth * 0.6, (double)(-i - 125), 4.6, ArcType.OPEN);
                }
            } else {
                for (int i = minValueAngle; i <= 300; ++i) {
                    if (i % 6 != 0 || !((double)i < v)) continue;
                    this.barCtx.strokeArc(this.barWidth * 0.5 + this.barWidth * 0.3, this.barWidth * 0.5 + this.barWidth * 0.3, this.size - this.barWidth - this.barWidth * 0.6, this.size - this.barWidth - this.barWidth * 0.6, (double)(-i - 125), 4.6, ArcType.OPEN);
                }
            }
        }
        this.valueText.setText(String.format(Locale.US, this.formatString, VALUE));
        this.valueText.setLayoutX(this.valueBkgText.getLayoutBounds().getMaxX() - this.valueText.getLayoutBounds().getWidth());
    }

    private void drawBackground() {
        this.backgroundCanvas.setCache(false);
        double outerBarWidth = this.size * 0.006;
        this.backgroundCtx.setLineCap(StrokeLineCap.BUTT);
        this.backgroundCtx.clearRect(0.0, 0.0, this.size, this.size);
        this.backgroundCtx.setStroke((Paint)Color.rgb((int)0, (int)12, (int)6, (double)0.1));
        Color bColor = Helper.getTranslucentColorFrom(this.barColor, 0.1);
        for (int i = -60; i < 240; ++i) {
            this.backgroundCtx.save();
            if (i % 6 == 0) {
                this.backgroundCtx.setStroke((Paint)bColor);
                this.backgroundCtx.setLineWidth(this.barWidth);
                this.backgroundCtx.strokeArc(this.barWidth * 0.5 + this.barWidth * 0.3, this.barWidth * 0.5 + this.barWidth * 0.3, this.size - this.barWidth - this.barWidth * 0.6, this.size - this.barWidth - this.barWidth * 0.6, (double)(i + 1), 4.6, ArcType.OPEN);
                this.backgroundCtx.setStroke((Paint)this.barColor);
                this.backgroundCtx.setLineWidth(outerBarWidth);
                this.backgroundCtx.strokeArc(outerBarWidth, outerBarWidth, this.size - 2.0 * outerBarWidth, this.size - 2.0 * outerBarWidth, (double)(i + 1), 4.6, ArcType.OPEN);
            }
            this.backgroundCtx.restore();
        }
        if (!((Gauge)this.getSkinnable()).getTitle().isEmpty()) {
            String title = ((Gauge)this.getSkinnable()).getTitle();
            char[] bkgTitleChrs = new char[title.length()];
            Arrays.fill(bkgTitleChrs, '8');
            this.backgroundCtx.setFill((Paint)Helper.getTranslucentColorFrom(this.titleColor, 0.1));
            this.backgroundCtx.setFont(Fonts.digitalReadoutBold(0.09 * this.size));
            this.backgroundCtx.setTextBaseline(VPos.CENTER);
            this.backgroundCtx.setTextAlign(TextAlignment.CENTER);
            this.backgroundCtx.fillText(new String(bkgTitleChrs), this.center, this.size * 0.35, this.size * 0.55);
            this.backgroundCtx.setFill((Paint)this.titleColor);
            this.backgroundCtx.fillText(title, this.center, this.size * 0.35, this.size * 0.55);
        }
        if (!((Gauge)this.getSkinnable()).getSubTitle().isEmpty()) {
            String subTitle = ((Gauge)this.getSkinnable()).getSubTitle();
            char[] bkgSubTitleChrs = new char[subTitle.length()];
            Arrays.fill(bkgSubTitleChrs, '8');
            this.backgroundCtx.setFill((Paint)Helper.getTranslucentColorFrom(this.subTitleColor, 0.1));
            this.backgroundCtx.setFont(Fonts.digital(0.09 * this.size));
            this.backgroundCtx.fillText(new String(bkgSubTitleChrs), this.center, this.size * 0.66);
            this.backgroundCtx.setFill((Paint)this.subTitleColor);
            this.backgroundCtx.fillText(subTitle, this.center, this.size * 0.66);
        }
        if (!((Gauge)this.getSkinnable()).getUnit().isEmpty()) {
            String unit = ((Gauge)this.getSkinnable()).getUnit();
            char[] bkgUnitChrs = new char[unit.length()];
            Arrays.fill(bkgUnitChrs, '8');
            this.backgroundCtx.setFill((Paint)Helper.getTranslucentColorFrom(this.unitColor, 0.1));
            this.backgroundCtx.setFont(Fonts.digital(0.09 * this.size));
            this.backgroundCtx.fillText(new String(bkgUnitChrs), this.center, this.size * 0.88);
            this.backgroundCtx.setFill((Paint)this.unitColor);
            this.backgroundCtx.fillText(unit, this.center, this.size * 0.88);
        }
        this.drawTickMarks();
        this.backgroundCanvas.setCache(true);
        this.backgroundCanvas.setCacheHint(CacheHint.QUALITY);
        if (((Gauge)this.getSkinnable()).isValueVisible()) {
            int i;
            StringBuilder valueBkg = new StringBuilder();
            int len = String.valueOf((int)((Gauge)this.getSkinnable()).getMaxValue()).length();
            if (((Gauge)this.getSkinnable()).getMinValue() < 0.0) {
                ++len;
            }
            for (i = 0; i < len; ++i) {
                valueBkg.append("8");
            }
            if (((Gauge)this.getSkinnable()).getDecimals() > 0) {
                valueBkg.append(".");
                len = ((Gauge)this.getSkinnable()).getDecimals();
                for (i = 0; i < len; ++i) {
                    valueBkg.append("8");
                }
            }
            this.valueBkgText.setText(valueBkg.toString());
            this.valueBkgText.setX((this.size - this.valueBkgText.getLayoutBounds().getWidth()) * 0.5);
        }
    }

    private void drawTickMarks() {
        double centerX = this.center;
        double centerY = this.center;
        int tickLabelDecimals = ((Gauge)this.getSkinnable()).getTickLabelDecimals();
        String tickLabelFormatString = "%." + tickLabelDecimals + "f";
        double minorTickSpace = ((Gauge)this.getSkinnable()).getMinorTickSpace();
        double tmpAngleStep = this.angleStep * minorTickSpace;
        BigDecimal minorTickSpaceBD = BigDecimal.valueOf(minorTickSpace);
        BigDecimal majorTickSpaceBD = BigDecimal.valueOf(((Gauge)this.getSkinnable()).getMajorTickSpace());
        BigDecimal counterBD = BigDecimal.valueOf(this.minValue);
        double counter = this.minValue;
        Color tickMarkColor = ((Gauge)this.getSkinnable()).getTickMarkColor();
        Color majorTickMarkColor = ((Gauge)this.getSkinnable()).getMajorTickMarkColor().equals((Object)tickMarkColor) ? tickMarkColor : ((Gauge)this.getSkinnable()).getMajorTickMarkColor();
        Color tickLabelColor = ((Gauge)this.getSkinnable()).getTickLabelColor();
        Color zeroColor = ((Gauge)this.getSkinnable()).getZeroColor();
        boolean isNotZero = true;
        boolean majorTickMarksVisible = ((Gauge)this.getSkinnable()).getMajorTickMarksVisible();
        boolean tickLabelsVisible = ((Gauge)this.getSkinnable()).getTickLabelsVisible();
        boolean onlyFirstAndLastLabelVisible = ((Gauge)this.getSkinnable()).isOnlyFirstAndLastTickLabelVisible();
        double customFontSizeFactor = ((Gauge)this.getSkinnable()).getCustomTickLabelFontSize() / 400.0;
        boolean fullRange = this.minValue < 0.0 && this.maxValue > 0.0;
        double tickLabelOrientationFactor = 0.8;
        double tickLabelFontSize = tickLabelDecimals == 0 ? 0.051 * this.size : 0.048 * this.size;
        tickLabelFontSize = ((Gauge)this.getSkinnable()).getCustomTickLabelsEnabled() ? customFontSizeFactor * this.size : tickLabelFontSize;
        Font tickLabelFont = Fonts.robotoCondensedRegular(tickLabelFontSize * tickLabelOrientationFactor);
        Font tickLabelZeroFont = fullRange ? Fonts.robotoCondensedBold(tickLabelFontSize * tickLabelOrientationFactor) : tickLabelFont;
        this.backgroundCtx.setStroke((Paint)tickMarkColor);
        this.backgroundCtx.strokeArc(0.0875 * this.size, 0.0875 * this.size, 0.825 * this.size, 0.825 * this.size, 300.0, 300.0, ArcType.OPEN);
        BigDecimal tmpStepBD = new BigDecimal(tmpAngleStep);
        tmpStepBD = tmpStepBD.setScale(3, 4);
        double tmpStep = tmpStepBD.doubleValue();
        double angle = 0.0;
        double i = 0.0;
        while (Double.compare(-300.0 - tmpStep, i) <= 0) {
            double sinValue = Math.sin(Math.toRadians(angle + -30.0));
            double cosValue = Math.cos(Math.toRadians(angle + -30.0));
            double innerPointX = centerX + this.size * 0.395 * sinValue;
            double innerPointY = centerY + this.size * 0.395 * cosValue;
            double triangleOuterAngle1 = Math.toRadians(angle - 1.2 + -30.0);
            double triangleOuterAngle2 = Math.toRadians(angle + 1.2 + -30.0);
            double triangleOuterPoint1X = centerX + this.size * 0.4125 * Math.sin(triangleOuterAngle1);
            double triangleOuterPoint1Y = centerY + this.size * 0.4125 * Math.cos(triangleOuterAngle1);
            double triangleOuterPoint2X = centerX + this.size * 0.4125 * Math.sin(triangleOuterAngle2);
            double triangleOuterPoint2Y = centerY + this.size * 0.4125 * Math.cos(triangleOuterAngle2);
            double textPointX = centerX + this.size * 0.365 * sinValue;
            double textPointY = centerY + this.size * 0.365 * cosValue;
            this.backgroundCtx.setStroke((Paint)tickMarkColor);
            this.backgroundCtx.setFill((Paint)tickMarkColor);
            this.backgroundCtx.setLineCap(StrokeLineCap.BUTT);
            if (Double.compare(counterBD.remainder(majorTickSpaceBD).doubleValue(), 0.0) == 0) {
                boolean bl = isNotZero = Double.compare(0.0, counter) != 0;
                if (majorTickMarksVisible) {
                    this.backgroundCtx.setFill((Paint)majorTickMarkColor);
                    this.backgroundCtx.setStroke((Paint)majorTickMarkColor);
                    this.backgroundCtx.setLineWidth(this.size * 0.0055);
                    this.backgroundCtx.setLineCap(StrokeLineCap.BUTT);
                }
                if (fullRange && !isNotZero) {
                    this.backgroundCtx.setFill((Paint)zeroColor);
                    this.backgroundCtx.setStroke((Paint)zeroColor);
                }
                if (majorTickMarksVisible) {
                    Helper.drawTriangle(this.backgroundCtx, innerPointX, innerPointY, triangleOuterPoint1X, triangleOuterPoint1Y, triangleOuterPoint2X, triangleOuterPoint2Y);
                }
                if (tickLabelsVisible) {
                    this.backgroundCtx.save();
                    this.backgroundCtx.translate(textPointX, textPointY);
                    Helper.rotateContextForText(this.backgroundCtx, -30.0, angle, TickLabelOrientation.HORIZONTAL);
                    this.backgroundCtx.setFont(isNotZero ? tickLabelFont : tickLabelZeroFont);
                    this.backgroundCtx.setTextAlign(TextAlignment.CENTER);
                    this.backgroundCtx.setTextBaseline(VPos.CENTER);
                    if (!onlyFirstAndLastLabelVisible) {
                        if (isNotZero) {
                            this.backgroundCtx.setFill((Paint)tickLabelColor);
                        } else {
                            this.backgroundCtx.setFill((Paint)(fullRange ? zeroColor : tickLabelColor));
                        }
                    } else if (Double.compare(counter, this.minValue) == 0 || Double.compare(counter, this.maxValue) == 0) {
                        if (isNotZero) {
                            this.backgroundCtx.setFill((Paint)tickLabelColor);
                        } else {
                            this.backgroundCtx.setFill((Paint)(fullRange ? zeroColor : tickLabelColor));
                        }
                    } else {
                        this.backgroundCtx.setFill((Paint)Color.TRANSPARENT);
                    }
                    this.backgroundCtx.fillText(String.format(Locale.US, tickLabelFormatString, counter), 0.0, 0.0);
                    this.backgroundCtx.restore();
                }
            }
            if ((counter = (counterBD = counterBD.add(minorTickSpaceBD)).doubleValue()) > this.maxValue) break;
            angle -= tmpAngleStep;
            i -= tmpStep;
        }
    }

    private void redraw() {
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Gauge)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(((Gauge)this.getSkinnable()).getBorderWidth() / 250.0 * this.size))}));
        this.formatString = "%." + Integer.toString(((Gauge)this.getSkinnable()).getDecimals()) + "f";
        this.barColor = ((Gauge)this.getSkinnable()).getBarColor();
        this.valueColor = ((Gauge)this.getSkinnable()).getValueColor();
        this.titleColor = ((Gauge)this.getSkinnable()).getTitleColor();
        this.subTitleColor = ((Gauge)this.getSkinnable()).getSubTitleColor();
        this.unitColor = ((Gauge)this.getSkinnable()).getUnitColor();
        this.drawBackground();
        this.setBar(((Gauge)this.getSkinnable()).getCurrentValue());
        this.valueBkgText.setFill((Paint)Helper.getTranslucentColorFrom(this.valueColor, 0.1));
        this.valueText.setFill((Paint)this.valueColor);
    }

    private void resize() {
        double height;
        double width = ((Gauge)this.getSkinnable()).getWidth() - ((Gauge)this.getSkinnable()).getInsets().getLeft() - ((Gauge)this.getSkinnable()).getInsets().getRight();
        double d = this.size = width < (height = ((Gauge)this.getSkinnable()).getHeight() - ((Gauge)this.getSkinnable()).getInsets().getTop() - ((Gauge)this.getSkinnable()).getInsets().getBottom()) ? width : height;
        if (width > 0.0 && height > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((width - this.size) * 0.5, (height - this.size) * 0.5);
            this.center = this.size * 0.5;
            this.barWidth = this.size * 0.06;
            this.backgroundCanvas.setWidth(this.size);
            this.backgroundCanvas.setHeight(this.size);
            this.barCanvas.setWidth(this.size);
            this.barCanvas.setHeight(this.size);
            this.valueBkgText.setFont(Fonts.digital(0.2 * this.size));
            this.valueBkgText.setY(this.center + this.valueBkgText.getLayoutBounds().getHeight() * 0.5);
            this.valueText.setFont(Fonts.digital(0.2 * this.size));
            this.valueText.setY(this.center + this.valueText.getLayoutBounds().getHeight() * 0.5);
            this.drawBackground();
            this.setBar(((Gauge)this.getSkinnable()).getCurrentValue());
        }
    }
}

