/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa;

import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.paint.Color;

public class Marker
implements Comparable<Marker> {
    private static final Color DEFAULT_MARKER_COLOR = Color.rgb((int)123, (int)30, (int)202);
    public final MarkerEvent MARKER_PRESSED_EVENT = new MarkerEvent(this, null, MarkerEvent.MARKER_PRESSED);
    public final MarkerEvent MARKER_RELEASED_EVENT = new MarkerEvent(this, null, MarkerEvent.MARKER_RELEASED);
    public final MarkerEvent VALUE_CHANGED_EVENT = new MarkerEvent(this, null, MarkerEvent.VALUE_CHANGED);
    public final MarkerEvent COLOR_CHANGED_EVENT = new MarkerEvent(this, null, MarkerEvent.COLOR_CHANGED);
    public final MarkerEvent TEXT_CHANGED_EVENT = new MarkerEvent(this, null, MarkerEvent.TEXT_CHANGED);
    public final MarkerEvent TYPE_CHANGED_EVENT = new MarkerEvent(this, null, MarkerEvent.TYPE_CHANGED);
    public final MarkerEvent EXCEEDED_EVENT = new MarkerEvent(this, null, MarkerEvent.MARKER_EXCEEDED);
    public final MarkerEvent UNDERRUN_EVENT = new MarkerEvent(this, null, MarkerEvent.MARKER_UNDERRUN);
    private double _value;
    private DoubleProperty value;
    private String _text;
    private StringProperty text;
    private Color _color;
    private ObjectProperty<Color> color;
    private MarkerType _markerType;
    private ObjectProperty<MarkerType> markerType;
    private double checkedValue;
    private ObjectProperty<EventHandler<MarkerEvent>> onMarkerExceeded = new SimpleObjectProperty((Object)this, "onMarkerExceeded");
    private ObjectProperty<EventHandler<MarkerEvent>> onMarkerUnderrun = new SimpleObjectProperty((Object)this, "onMarkerUnderrun");
    private ObjectProperty<EventHandler<MarkerEvent>> onValueChanged = new SimpleObjectProperty((Object)this, "onValueChanged");
    private ObjectProperty<EventHandler<MarkerEvent>> onColorChanged = new SimpleObjectProperty((Object)this, "onColorChanged");
    private ObjectProperty<EventHandler<MarkerEvent>> onTextChanged = new SimpleObjectProperty((Object)this, "onTextChanged");
    private ObjectProperty<EventHandler<MarkerEvent>> onTypeChanged = new SimpleObjectProperty((Object)this, "onTypeChanged");
    private ObjectProperty<EventHandler<MarkerEvent>> onMarkerPressed = new SimpleObjectProperty((Object)this, "onMarkerPressed");
    private ObjectProperty<EventHandler<MarkerEvent>> onMarkerReleased = new SimpleObjectProperty((Object)this, "onMarkerReleased");

    public Marker() {
        this(0.0, "", DEFAULT_MARKER_COLOR, MarkerType.STANDARD);
    }

    public Marker(double VALUE, String TEXT) {
        this(VALUE, TEXT, DEFAULT_MARKER_COLOR, MarkerType.STANDARD);
    }

    public Marker(double VALUE, Color COLOR) {
        this(VALUE, "", COLOR, MarkerType.STANDARD);
    }

    public Marker(double VALUE, MarkerType TYPE) {
        this(VALUE, "", DEFAULT_MARKER_COLOR, TYPE);
    }

    public Marker(double VALUE, Color COLOR, MarkerType TYPE) {
        this(VALUE, "", COLOR, TYPE);
    }

    public Marker(double VALUE, String TEXT, MarkerType TYPE) {
        this(VALUE, TEXT, DEFAULT_MARKER_COLOR, TYPE);
    }

    public Marker(double VALUE, String TEXT, Color COLOR) {
        this(VALUE, TEXT, COLOR, MarkerType.STANDARD);
    }

    public Marker(double VALUE, String TEXT, Color COLOR, MarkerType TYPE) {
        this._value = VALUE;
        this._text = TEXT;
        this._color = COLOR;
        this._markerType = null == TYPE ? MarkerType.STANDARD : TYPE;
        this.checkedValue = -1.7976931348623157E308;
    }

    public double getValue() {
        return null == this.value ? this._value : this.value.get();
    }

    public void setValue(double VALUE) {
        if (null == this.value) {
            this._value = VALUE;
        } else {
            this.value.set(VALUE);
        }
        this.fireMarkerEvent(this.VALUE_CHANGED_EVENT);
    }

    public DoubleProperty valueProperty() {
        if (null == this.value) {
            this.value = new SimpleDoubleProperty((Object)this, "value", this._value);
        }
        return this.value;
    }

    public String getText() {
        return null == this.text ? this._text : (String)this.text.get();
    }

    public void setText(String TEXT) {
        if (null == this.text) {
            this._text = TEXT;
        } else {
            this.text.set((Object)TEXT);
        }
        this.fireMarkerEvent(this.TEXT_CHANGED_EVENT);
    }

    public StringProperty textProperty() {
        if (null == this.text) {
            this.text = new SimpleStringProperty((Object)this, "text", this._text);
        }
        return this.text;
    }

    public Color getColor() {
        return null == this.color ? this._color : (Color)this.color.get();
    }

    public void setColor(Color COLOR) {
        if (null == this.color) {
            this._color = COLOR;
        } else {
            this.color.set((Object)COLOR);
        }
        this.fireMarkerEvent(this.COLOR_CHANGED_EVENT);
    }

    public ObjectProperty<Color> colorProperty() {
        if (null == this.color) {
            this.color = new SimpleObjectProperty((Object)this, "color", (Object)this._color);
        }
        return this.color;
    }

    public MarkerType getMarkerType() {
        return null == this.markerType ? this._markerType : (MarkerType)((Object)this.markerType.get());
    }

    public void setMarkerType(MarkerType TYPE) {
        if (null == this.markerType) {
            this._markerType = null == TYPE ? MarkerType.STANDARD : TYPE;
        } else {
            this.markerType.set((Object)TYPE);
        }
        this.fireMarkerEvent(this.TYPE_CHANGED_EVENT);
    }

    public ObjectProperty<MarkerType> markerTypeProperty() {
        if (null == this.markerType) {
            this.markerType = new ObjectPropertyBase<MarkerType>(this._markerType){

                public void set(MarkerType TYPE) {
                    super.set((Object)(null == TYPE ? MarkerType.STANDARD : TYPE));
                }

                public Object getBean() {
                    return Marker.this;
                }

                public String getName() {
                    return "markerType";
                }
            };
        }
        return this.markerType;
    }

    public boolean equals(Marker MARKER) {
        return Double.compare(MARKER.getValue(), this.getValue()) == 0 && MARKER.getText().equals(this.getText());
    }

    public void checkForValue(double VALUE) {
        boolean isSmaller;
        boolean wasSmaller = Double.compare(this.checkedValue, VALUE) < 0;
        boolean wasBigger = Double.compare(this.checkedValue, VALUE) > 0;
        boolean isBigger = Double.compare(VALUE, this.checkedValue) > 0;
        boolean bl = isSmaller = Double.compare(VALUE, this.checkedValue) < 0;
        if (wasSmaller && isBigger) {
            this.fireMarkerEvent(this.EXCEEDED_EVENT);
        } else if (wasBigger && isSmaller) {
            this.fireMarkerEvent(this.UNDERRUN_EVENT);
        }
        this.checkedValue = VALUE;
    }

    @Override
    public int compareTo(Marker MARKER) {
        if (Double.compare(this.getValue(), MARKER.getValue()) < 0) {
            return -1;
        }
        if (Double.compare(this.getValue(), MARKER.getValue()) > 0) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "{\n" + "\"value\":" + this.getValue() + ",\n" + "\"text\":\"" + this.getText() + "\",\n" + "\"color\":\n" + this.getColor().toString().substring(0, 8).replace("0x", "#") + "\",\n" + "\"type\":\"" + this.getMarkerType().name() + "\"\n" + "}";
    }

    public final ObjectProperty<EventHandler<MarkerEvent>> onMarkerExceededProperty() {
        return this.onMarkerExceeded;
    }

    public final void setOnMarkerExceeded(EventHandler<MarkerEvent> value) {
        this.onMarkerExceededProperty().set(value);
    }

    public final EventHandler<MarkerEvent> getOnMarkerExceeded() {
        return (EventHandler)this.onMarkerExceededProperty().get();
    }

    public final ObjectProperty<EventHandler<MarkerEvent>> onMarkerUnderrunProperty() {
        return this.onMarkerUnderrun;
    }

    public final void setOnMarkerUnderrun(EventHandler<MarkerEvent> value) {
        this.onMarkerUnderrunProperty().set(value);
    }

    public final EventHandler<MarkerEvent> getOnMarkerUnderrun() {
        return (EventHandler)this.onMarkerUnderrunProperty().get();
    }

    public final ObjectProperty<EventHandler<MarkerEvent>> onValueChangedProperty() {
        return this.onValueChanged;
    }

    public final void setOnValueChanged(EventHandler<MarkerEvent> value) {
        this.onValueChangedProperty().set(value);
    }

    public final EventHandler<MarkerEvent> getOnValueChanged() {
        return (EventHandler)this.onValueChangedProperty().get();
    }

    public final ObjectProperty<EventHandler<MarkerEvent>> onColorChangedProperty() {
        return this.onColorChanged;
    }

    public final void setOnColorChanged(EventHandler<MarkerEvent> value) {
        this.onColorChangedProperty().set(value);
    }

    public final EventHandler<MarkerEvent> getOnColorChanged() {
        return (EventHandler)this.onColorChangedProperty().get();
    }

    public final ObjectProperty<EventHandler<MarkerEvent>> onTextChangedProperty() {
        return this.onTextChanged;
    }

    public final void setOnTextChanged(EventHandler<MarkerEvent> value) {
        this.onTextChangedProperty().set(value);
    }

    public final EventHandler<MarkerEvent> getOnTextChanged() {
        return (EventHandler)this.onTextChangedProperty().get();
    }

    public final ObjectProperty<EventHandler<MarkerEvent>> onTypeChangedProperty() {
        return this.onTypeChanged;
    }

    public final void setOnTypeChanged(EventHandler<MarkerEvent> value) {
        this.onTypeChangedProperty().set(value);
    }

    public final EventHandler<MarkerEvent> getOnTypeChanged() {
        return (EventHandler)this.onTypeChangedProperty().get();
    }

    public final ObjectProperty<EventHandler<MarkerEvent>> onMarkerPressedProperty() {
        return this.onMarkerPressed;
    }

    public final void setOnMarkerPressed(EventHandler<MarkerEvent> value) {
        this.onMarkerPressedProperty().set(value);
    }

    public final EventHandler<MarkerEvent> getOnMarkerPressed() {
        return (EventHandler)this.onMarkerPressedProperty().get();
    }

    public final ObjectProperty<EventHandler<MarkerEvent>> onMarkerReleasedProperty() {
        return this.onMarkerReleased;
    }

    public final void setOnMarkerReleased(EventHandler<MarkerEvent> value) {
        this.onMarkerReleasedProperty().set(value);
    }

    public final EventHandler<MarkerEvent> getOnMarkerReleased() {
        return (EventHandler)this.onMarkerReleasedProperty().get();
    }

    public void fireMarkerEvent(MarkerEvent EVENT) {
        EventType TYPE = EVENT.getEventType();
        Object HANDLER = MarkerEvent.MARKER_PRESSED == TYPE ? this.getOnMarkerPressed() : (MarkerEvent.MARKER_RELEASED == TYPE ? this.getOnMarkerReleased() : (MarkerEvent.VALUE_CHANGED == TYPE ? this.getOnValueChanged() : (MarkerEvent.COLOR_CHANGED == TYPE ? this.getOnColorChanged() : (MarkerEvent.TEXT_CHANGED == TYPE ? this.getOnTextChanged() : (MarkerEvent.TYPE_CHANGED == TYPE ? this.getOnTypeChanged() : (MarkerEvent.MARKER_EXCEEDED == TYPE ? this.getOnMarkerExceeded() : (MarkerEvent.MARKER_UNDERRUN == TYPE ? this.getOnMarkerUnderrun() : null)))))));
        if (null == HANDLER) {
            return;
        }
        Platform.runLater(() -> HANDLER.handle((Event)EVENT));
    }

    public static class MarkerEvent
    extends Event {
        public static final EventType<MarkerEvent> MARKER_EXCEEDED = new EventType(ANY, "MARKER_EXCEEDED");
        public static final EventType<MarkerEvent> MARKER_UNDERRUN = new EventType(ANY, "MARKER_UNDER_RUN");
        public static final EventType<MarkerEvent> MARKER_PRESSED = new EventType(ANY, "MARKER_PRESSED");
        public static final EventType<MarkerEvent> MARKER_RELEASED = new EventType(ANY, "MARKER_RELEASED");
        public static final EventType<MarkerEvent> VALUE_CHANGED = new EventType(ANY, "VALUE_CHANGED");
        public static final EventType<MarkerEvent> COLOR_CHANGED = new EventType(ANY, "COLOR_CHANGED");
        public static final EventType<MarkerEvent> TEXT_CHANGED = new EventType(ANY, "TEXT_CHANGED");
        public static final EventType<MarkerEvent> TYPE_CHANGED = new EventType(ANY, "TYPE_CHANGED");

        public MarkerEvent(Object SOURCE, EventTarget TARGET, EventType<MarkerEvent> TYPE) {
            super(SOURCE, TARGET, TYPE);
        }
    }

    public static enum MarkerType {
        STANDARD,
        DOT,
        TRIANGLE;

    }
}

