/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa;

import eu.hansolo.medusa.Alarm;
import eu.hansolo.medusa.LcdDesign;
import eu.hansolo.medusa.LcdFont;
import eu.hansolo.medusa.TickLabelLocation;
import eu.hansolo.medusa.TimeSection;
import eu.hansolo.medusa.events.AlarmEvent;
import eu.hansolo.medusa.events.AlarmEventListener;
import eu.hansolo.medusa.events.TimeEvent;
import eu.hansolo.medusa.events.TimeEventListener;
import eu.hansolo.medusa.events.UpdateEvent;
import eu.hansolo.medusa.events.UpdateEventListener;
import eu.hansolo.medusa.skins.ClockSkin;
import eu.hansolo.medusa.skins.DBClockSkin;
import eu.hansolo.medusa.skins.FatClockSkin;
import eu.hansolo.medusa.skins.LcdClockSkin;
import eu.hansolo.medusa.skins.PearClockSkin;
import eu.hansolo.medusa.skins.PlainClockSkin;
import eu.hansolo.medusa.skins.RoundLcdClockSkin;
import eu.hansolo.medusa.skins.SlimClockSkin;
import eu.hansolo.medusa.tools.Helper;
import eu.hansolo.medusa.tools.TimeSectionComparator;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyLongProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public class Clock
extends Control {
    public static final int SHORT_INTERVAL = 20;
    public static final int LONG_INTERVAL = 1000;
    public static final Color DARK_COLOR = Color.rgb((int)36, (int)36, (int)36);
    public static final Color BRIGHT_COLOR = Color.rgb((int)223, (int)223, (int)223);
    private final UpdateEvent REDRAW_EVENT = new UpdateEvent((Object)this, UpdateEvent.EventType.REDRAW);
    private final UpdateEvent VISIBILITY_EVENT = new UpdateEvent((Object)this, UpdateEvent.EventType.VISIBILITY);
    private final UpdateEvent LCD_EVENT = new UpdateEvent((Object)this, UpdateEvent.EventType.LCD);
    private final UpdateEvent RECALC_EVENT = new UpdateEvent((Object)this, UpdateEvent.EventType.RECALC);
    private final UpdateEvent SECTION_EVENT = new UpdateEvent((Object)this, UpdateEvent.EventType.SECTION);
    private final UpdateEvent FINISHED_EVENT = new UpdateEvent((Object)this, UpdateEvent.EventType.FINISHED);
    private volatile ScheduledFuture<?> periodicTickTask;
    private static ScheduledExecutorService periodicTickExecutorService;
    private List<UpdateEventListener> listenerList = new CopyOnWriteArrayList<UpdateEventListener>();
    private List<AlarmEventListener> alarmListenerList = new CopyOnWriteArrayList<AlarmEventListener>();
    private List<TimeEventListener> timeEventListenerList = new CopyOnWriteArrayList<TimeEventListener>();
    private ObjectProperty<ZonedDateTime> time;
    private LongProperty currentTime;
    private Timeline timeline;
    private int updateInterval;
    private ClockSkinType skinType;
    private String _title;
    private StringProperty title;
    private boolean _checkSectionsForValue;
    private BooleanProperty checkSectionsForValue;
    private boolean _checkAreasForValue;
    private BooleanProperty checkAreasForValue;
    private ObservableList<TimeSection> sections;
    private boolean _sectionsVisible;
    private BooleanProperty sectionsVisible;
    private boolean _highlightSections;
    private BooleanProperty highlightSections;
    private ObservableList<TimeSection> areas;
    private boolean _areasVisible;
    private BooleanProperty areasVisible;
    private boolean _highlightAreas;
    private BooleanProperty highlightAreas;
    private String _text;
    private StringProperty text;
    private boolean _discreteSeconds;
    private BooleanProperty discreteSeconds;
    private boolean _discreteMinutes;
    private BooleanProperty discreteMinutes;
    private boolean _discreteHours;
    private BooleanProperty discreteHours;
    private boolean _secondsVisible;
    private BooleanProperty secondsVisible;
    private boolean _titleVisible;
    private BooleanProperty titleVisible;
    private boolean _textVisible;
    private BooleanProperty textVisible;
    private boolean _dateVisible;
    private BooleanProperty dateVisible;
    private boolean _nightMode;
    private BooleanProperty nightMode;
    private boolean _running;
    private BooleanProperty running;
    private boolean _autoNightMode;
    private BooleanProperty autoNightMode;
    private Paint _backgroundPaint;
    private ObjectProperty<Paint> backgroundPaint;
    private Paint _borderPaint;
    private ObjectProperty<Paint> borderPaint;
    private double _borderWidth;
    private DoubleProperty borderWidth;
    private Paint _foregroundPaint;
    private ObjectProperty<Paint> foregroundPaint;
    private Color _titleColor;
    private ObjectProperty<Color> titleColor;
    private Color _textColor;
    private ObjectProperty<Color> textColor;
    private Color _dateColor;
    private ObjectProperty<Color> dateColor;
    private Color _hourTickMarkColor;
    private ObjectProperty<Color> hourTickMarkColor;
    private Color _minuteTickMarkColor;
    private ObjectProperty<Color> minuteTickMarkColor;
    private Color _tickLabelColor;
    private ObjectProperty<Color> tickLabelColor;
    private Color _alarmColor;
    private ObjectProperty<Color> alarmColor;
    private boolean _hourTickMarksVisible;
    private BooleanProperty hourTickMarksVisible;
    private boolean _minuteTickMarksVisible;
    private BooleanProperty minuteTickMarksVisible;
    private boolean _tickLabelsVisible;
    private BooleanProperty tickLabelsVisible;
    private Color _hourColor;
    private ObjectProperty<Color> hourColor;
    private Color _minuteColor;
    private ObjectProperty<Color> minuteColor;
    private Color _secondColor;
    private ObjectProperty<Color> secondColor;
    private Color _knobColor;
    private ObjectProperty<Color> knobColor;
    private LcdDesign _lcdDesign;
    private ObjectProperty<LcdDesign> lcdDesign;
    private boolean _alarmsEnabled;
    private BooleanProperty alarmsEnabled;
    private boolean _alarmsVisible;
    private BooleanProperty alarmsVisible;
    private ObservableList<Alarm> alarms;
    private List<Alarm> alarmsToRemove;
    private boolean _lcdCrystalEnabled;
    private BooleanProperty lcdCrystalEnabled;
    private boolean _shadowsEnabled;
    private BooleanProperty shadowsEnabled;
    private LcdFont _lcdFont;
    private ObjectProperty<LcdFont> lcdFont;
    private Locale _locale;
    private ObjectProperty<Locale> locale;
    private TickLabelLocation _tickLabelLocation;
    private ObjectProperty<TickLabelLocation> tickLabelLocation;
    private boolean _animated;
    private BooleanProperty animated;
    private long animationDuration;

    public Clock() {
        this(ClockSkinType.CLOCK, ZonedDateTime.now());
    }

    public Clock(ClockSkinType SKIN) {
        this(SKIN, ZonedDateTime.now());
    }

    public Clock(ZonedDateTime TIME) {
        this(ClockSkinType.CLOCK, TIME);
    }

    public Clock(ClockSkinType SKIN, ZonedDateTime TIME) {
        this.skinType = SKIN;
        this.getStyleClass().add((Object)"clock");
        this.init(TIME);
    }

    private void init(ZonedDateTime TIME) {
        this.time = new ObjectPropertyBase<ZonedDateTime>(TIME){

            public void set(ZonedDateTime TIME) {
                super.set((Object)TIME);
                if (!Clock.this.isRunning() && Clock.this.isAnimated()) {
                    long animationDuration = Clock.this.getAnimationDuration();
                    Clock.this.timeline.stop();
                    KeyValue KEY_VALUE = new KeyValue((WritableValue)Clock.this.currentTime, (Object)TIME.toEpochSecond());
                    KeyFrame KEY_FRAME = new KeyFrame(Duration.millis((double)animationDuration), new KeyValue[]{KEY_VALUE});
                    Clock.this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{KEY_FRAME});
                    Clock.this.timeline.setOnFinished(e -> Clock.this.fireUpdateEvent(Clock.this.FINISHED_EVENT));
                    Clock.this.timeline.play();
                } else {
                    Clock.this.currentTime.set(TIME.toEpochSecond());
                    Clock.this.fireUpdateEvent(Clock.this.FINISHED_EVENT);
                }
            }

            public Object getBean() {
                return Clock.this;
            }

            public String getName() {
                return "time";
            }
        };
        this.currentTime = new SimpleLongProperty((Object)this, "currentTime", ((ZonedDateTime)this.time.get()).toEpochSecond());
        this.timeline = new Timeline();
        this.timeline.setOnFinished(e -> this.fireUpdateEvent(this.FINISHED_EVENT));
        this.updateInterval = 1000;
        this._checkSectionsForValue = false;
        this._checkAreasForValue = false;
        this.sections = FXCollections.observableArrayList();
        this._secondsVisible = false;
        this._highlightSections = false;
        this.areas = FXCollections.observableArrayList();
        this._areasVisible = false;
        this._highlightAreas = false;
        this._text = "";
        this._discreteSeconds = true;
        this._discreteMinutes = true;
        this._discreteHours = false;
        this._secondsVisible = false;
        this._titleVisible = false;
        this._textVisible = false;
        this._dateVisible = false;
        this._nightMode = false;
        this._running = false;
        this._autoNightMode = false;
        this._backgroundPaint = Color.TRANSPARENT;
        this._borderPaint = Color.TRANSPARENT;
        this._borderWidth = 1.0;
        this._foregroundPaint = Color.TRANSPARENT;
        this._titleColor = DARK_COLOR;
        this._textColor = DARK_COLOR;
        this._dateColor = DARK_COLOR;
        this._hourTickMarkColor = DARK_COLOR;
        this._minuteTickMarkColor = DARK_COLOR;
        this._tickLabelColor = DARK_COLOR;
        this._alarmColor = DARK_COLOR;
        this._hourTickMarksVisible = true;
        this._minuteTickMarksVisible = true;
        this._tickLabelsVisible = true;
        this._hourColor = DARK_COLOR;
        this._minuteColor = DARK_COLOR;
        this._secondColor = DARK_COLOR;
        this._knobColor = DARK_COLOR;
        this._lcdDesign = LcdDesign.STANDARD;
        this._alarmsEnabled = false;
        this._alarmsVisible = false;
        this.alarms = FXCollections.observableArrayList();
        this.alarmsToRemove = new ArrayList<Alarm>();
        this._lcdCrystalEnabled = false;
        this._shadowsEnabled = false;
        this._lcdFont = LcdFont.DIGITAL_BOLD;
        this._locale = Locale.US;
        this._tickLabelLocation = TickLabelLocation.INSIDE;
        this._animated = false;
        this.animationDuration = 10000L;
    }

    public ZonedDateTime getTime() {
        return (ZonedDateTime)this.time.get();
    }

    public void setTime(ZonedDateTime TIME) {
        this.time.set((Object)TIME);
    }

    public ObjectProperty<ZonedDateTime> timeProperty() {
        return this.time;
    }

    public long getCurrentTime() {
        return this.currentTime.get();
    }

    public ReadOnlyLongProperty currentTimeProperty() {
        return this.currentTime;
    }

    public String getTitle() {
        return null == this.title ? this._title : (String)this.title.get();
    }

    public void setTitle(String TITLE) {
        if (null == this.title) {
            this._title = TITLE;
        } else {
            this.title.set((Object)TITLE);
        }
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public StringProperty titleProperty() {
        if (null == this.title) {
            this.title = new SimpleStringProperty((Object)this, "title", this._title);
        }
        return this.title;
    }

    public String getText() {
        return null == this.text ? this._text : (String)this.text.get();
    }

    public void setText(String TEXT) {
        if (null == this.text) {
            this._text = TEXT;
        } else {
            this.text.set((Object)TEXT);
        }
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public StringProperty textProperty() {
        if (null == this.text) {
            this.text = new SimpleStringProperty((Object)this, "text", this._text);
        }
        return this.text;
    }

    public boolean getCheckSectionsForValue() {
        return null == this.checkSectionsForValue ? this._checkSectionsForValue : this.checkSectionsForValue.get();
    }

    public void setCheckSectionsForValue(boolean CHECK) {
        if (null == this.checkSectionsForValue) {
            this._checkSectionsForValue = CHECK;
        } else {
            this.checkSectionsForValue.set(CHECK);
        }
    }

    public BooleanProperty checkSectionsForValueProperty() {
        if (null == this.checkSectionsForValue) {
            this.checkSectionsForValue = new SimpleBooleanProperty((Object)this, "checkSectionsForValue", this._checkSectionsForValue);
        }
        return this.checkSectionsForValue;
    }

    public boolean getCheckAreasForValue() {
        return null == this.checkAreasForValue ? this._checkAreasForValue : this.checkAreasForValue.get();
    }

    public void setCheckAreasForValue(boolean CHECK) {
        if (null == this.checkAreasForValue) {
            this._checkAreasForValue = CHECK;
        } else {
            this.checkAreasForValue.set(CHECK);
        }
    }

    public BooleanProperty checkAreasForValueProperty() {
        if (null == this.checkAreasForValue) {
            this.checkAreasForValue = new SimpleBooleanProperty((Object)this, "checkAreasForValue", this._checkAreasForValue);
        }
        return this.checkAreasForValue;
    }

    public ObservableList<TimeSection> getSections() {
        return this.sections;
    }

    public void setSections(List<TimeSection> SECTIONS) {
        this.sections.setAll(SECTIONS);
        Collections.sort(this.sections, new TimeSectionComparator());
        this.fireUpdateEvent(this.SECTION_EVENT);
    }

    public void setSections(TimeSection ... SECTIONS) {
        this.setSections(Arrays.asList(SECTIONS));
    }

    public void addSection(TimeSection SECTION) {
        if (null == SECTION) {
            return;
        }
        this.sections.add((Object)SECTION);
        Collections.sort(this.sections, new TimeSectionComparator());
        this.fireUpdateEvent(this.SECTION_EVENT);
    }

    public void removeSection(TimeSection SECTION) {
        if (null == SECTION) {
            return;
        }
        this.sections.remove((Object)SECTION);
        Collections.sort(this.sections, new TimeSectionComparator());
        this.fireUpdateEvent(this.SECTION_EVENT);
    }

    public void clearSections() {
        this.sections.clear();
        this.fireUpdateEvent(this.SECTION_EVENT);
    }

    public boolean getSectionsVisible() {
        return null == this.sectionsVisible ? this._sectionsVisible : this.sectionsVisible.get();
    }

    public void setSectionsVisible(boolean VISIBLE) {
        if (null == this.sectionsVisible) {
            this._sectionsVisible = VISIBLE;
        } else {
            this.sectionsVisible.set(VISIBLE);
        }
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public BooleanProperty sectionsVisibleProperty() {
        if (null == this.sectionsVisible) {
            this.sectionsVisible = new SimpleBooleanProperty((Object)this, "sectionsVisible", this._sectionsVisible);
        }
        return this.sectionsVisible;
    }

    public boolean isHighlightSections() {
        return null == this.highlightSections ? this._highlightSections : this.highlightSections.get();
    }

    public void setHighlightSections(boolean HIGHLIGHT) {
        if (null == this.highlightSections) {
            this._highlightSections = HIGHLIGHT;
        } else {
            this.highlightSections.set(HIGHLIGHT);
        }
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public BooleanProperty highlightSectionsProperty() {
        if (null == this.highlightSections) {
            this.highlightSections = new SimpleBooleanProperty((Object)this, "highlightSections", this._highlightSections);
        }
        return this.highlightSections;
    }

    public ObservableList<TimeSection> getAreas() {
        return this.areas;
    }

    public void setAreas(List<TimeSection> AREAS) {
        this.areas.setAll(AREAS);
        Collections.sort(this.areas, new TimeSectionComparator());
        this.fireUpdateEvent(this.SECTION_EVENT);
    }

    public void setAreas(TimeSection ... AREAS) {
        this.setAreas(Arrays.asList(AREAS));
    }

    public void addArea(TimeSection AREA) {
        if (null == AREA) {
            return;
        }
        this.areas.add((Object)AREA);
        Collections.sort(this.areas, new TimeSectionComparator());
        this.fireUpdateEvent(this.SECTION_EVENT);
    }

    public void removeArea(TimeSection AREA) {
        if (null == AREA) {
            return;
        }
        this.areas.remove((Object)AREA);
        Collections.sort(this.areas, new TimeSectionComparator());
        this.fireUpdateEvent(this.SECTION_EVENT);
    }

    public void clearAreas() {
        this.areas.clear();
        this.fireUpdateEvent(this.SECTION_EVENT);
    }

    public boolean getAreasVisible() {
        return null == this.areasVisible ? this._areasVisible : this.areasVisible.get();
    }

    public void setAreasVisible(boolean VISIBLE) {
        if (null == this.areasVisible) {
            this._areasVisible = VISIBLE;
        } else {
            this.areasVisible.set(VISIBLE);
        }
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public BooleanProperty areasVisibleProperty() {
        if (null == this.areasVisible) {
            this.areasVisible = new SimpleBooleanProperty((Object)this, "areasVisible", this._areasVisible);
        }
        return this.areasVisible;
    }

    public boolean isHighlightAreas() {
        return null == this.highlightAreas ? this._highlightAreas : this.highlightAreas.get();
    }

    public void setHighlightAreas(boolean HIGHLIGHT) {
        if (null == this.highlightAreas) {
            this._highlightAreas = HIGHLIGHT;
        } else {
            this.highlightAreas.set(HIGHLIGHT);
        }
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public BooleanProperty highlightAreasProperty() {
        if (null == this.highlightAreas) {
            this.highlightAreas = new SimpleBooleanProperty((Object)this, "highlightAreas", this._highlightAreas);
        }
        return this.highlightAreas;
    }

    public boolean isDiscreteSeconds() {
        return null == this.discreteSeconds ? this._discreteSeconds : this.discreteSeconds.get();
    }

    public void setDiscreteSeconds(boolean DISCRETE) {
        if (null == this.discreteSeconds) {
            this._discreteSeconds = DISCRETE;
            this.stopTask(this.periodicTickTask);
            if (this.isAnimated()) {
                return;
            }
            this.scheduleTickTask();
        } else {
            this.discreteSeconds.set(DISCRETE);
        }
    }

    public BooleanProperty discreteSecondsProperty() {
        if (null == this.discreteSeconds) {
            this.discreteSeconds = new BooleanPropertyBase(){

                public void set(boolean DISCRETE) {
                    super.set(DISCRETE);
                    Clock.this.stopTask(Clock.this.periodicTickTask);
                    if (Clock.this.isAnimated()) {
                        return;
                    }
                    Clock.this.scheduleTickTask();
                }

                public Object getBean() {
                    return Clock.this;
                }

                public String getName() {
                    return "discreteSeconds";
                }
            };
        }
        return this.discreteSeconds;
    }

    public boolean isDiscreteMinutes() {
        return null == this.discreteMinutes ? this._discreteMinutes : this.discreteMinutes.get();
    }

    public void setDiscreteMinutes(boolean DISCRETE) {
        if (null == this.discreteMinutes) {
            this._discreteMinutes = DISCRETE;
            this.stopTask(this.periodicTickTask);
            if (this.isAnimated()) {
                return;
            }
            this.scheduleTickTask();
        } else {
            this.discreteMinutes.set(DISCRETE);
        }
    }

    public BooleanProperty discreteMinutesProperty() {
        if (null == this.discreteMinutes) {
            this.discreteMinutes = new BooleanPropertyBase(){

                public void set(boolean DISCRETE) {
                    super.set(DISCRETE);
                    Clock.this.stopTask(Clock.this.periodicTickTask);
                    if (Clock.this.isAnimated()) {
                        return;
                    }
                    Clock.this.scheduleTickTask();
                }

                public Object getBean() {
                    return Clock.this;
                }

                public String getName() {
                    return "discreteMinutes";
                }
            };
        }
        return this.discreteMinutes;
    }

    public boolean isDiscreteHours() {
        return null == this.discreteHours ? this._discreteHours : this.discreteHours.get();
    }

    public void setDiscreteHours(boolean DISCRETE) {
        if (null == this.discreteHours) {
            this._discreteHours = DISCRETE;
        } else {
            this.discreteHours.set(DISCRETE);
        }
    }

    public BooleanProperty discreteHoursProperty() {
        if (null == this.discreteHours) {
            this.discreteHours = new SimpleBooleanProperty((Object)this, "discreteHours", this._discreteHours);
        }
        return this.discreteHours;
    }

    public boolean isSecondsVisible() {
        return null == this.secondsVisible ? this._secondsVisible : this.secondsVisible.get();
    }

    public void setSecondsVisible(boolean VISIBLE) {
        if (null == this.secondsVisible) {
            this._secondsVisible = VISIBLE;
        } else {
            this.secondsVisible.set(VISIBLE);
        }
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public BooleanProperty secondsVisibleProperty() {
        if (null == this.secondsVisible) {
            this.secondsVisible = new SimpleBooleanProperty((Object)this, "secondsVisible", this._secondsVisible);
        }
        return this.secondsVisible;
    }

    public boolean isTitleVisible() {
        return null == this.titleVisible ? this._titleVisible : this.titleVisible.get();
    }

    public void setTitleVisible(boolean VISIBLE) {
        if (null == this.titleVisible) {
            this._titleVisible = VISIBLE;
        } else {
            this.titleVisible.set(VISIBLE);
        }
        this.fireUpdateEvent(this.VISIBILITY_EVENT);
    }

    public BooleanProperty titleVisibleProperty() {
        if (null == this.titleVisible) {
            this.titleVisible = new SimpleBooleanProperty((Object)this, "titleVisible", this._titleVisible);
        }
        return this.titleVisible;
    }

    public boolean isTextVisible() {
        return null == this.textVisible ? this._textVisible : this.textVisible.get();
    }

    public void setTextVisible(boolean VISIBLE) {
        if (null == this.textVisible) {
            this._textVisible = VISIBLE;
        } else {
            this.textVisible.set(VISIBLE);
        }
        this.fireUpdateEvent(this.VISIBILITY_EVENT);
    }

    public BooleanProperty textVisibleProperty() {
        if (null == this.textVisible) {
            this.textVisible = new SimpleBooleanProperty((Object)this, "textVisible", this._textVisible);
        }
        return this.textVisible;
    }

    public boolean isDateVisible() {
        return null == this.dateVisible ? this._dateVisible : this.dateVisible.get();
    }

    public void setDateVisible(boolean VISIBLE) {
        if (null == this.dateVisible) {
            this._dateVisible = VISIBLE;
        } else {
            this.dateVisible.set(VISIBLE);
        }
        this.fireUpdateEvent(this.VISIBILITY_EVENT);
    }

    public BooleanProperty dateVisibleProperty() {
        if (null == this.dateVisible) {
            this.dateVisible = new SimpleBooleanProperty((Object)this, "dateVisible", this._dateVisible);
        }
        return this.dateVisible;
    }

    public boolean isNightMode() {
        return null == this.nightMode ? this._nightMode : this.nightMode.get();
    }

    public void setNightMode(boolean MODE) {
        if (null == this.nightMode) {
            this._nightMode = MODE;
        } else {
            this.nightMode.set(MODE);
        }
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public BooleanProperty nightModeProperty() {
        if (null == this.nightMode) {
            this.nightMode = new SimpleBooleanProperty((Object)this, "nightMode", this._nightMode);
        }
        return this.nightMode;
    }

    public boolean isRunning() {
        return null == this.running ? this._running : this.running.get();
    }

    public void setRunning(boolean RUNNING) {
        if (null == this.running) {
            this._running = RUNNING;
            if (RUNNING && !this.isAnimated()) {
                this.scheduleTickTask();
            } else {
                this.stopTask(this.periodicTickTask);
            }
        } else {
            this.running.set(RUNNING);
        }
    }

    public BooleanProperty runningProperty() {
        if (null == this.running) {
            new BooleanPropertyBase(this._running){

                public void set(boolean RUNNING) {
                    super.set(RUNNING);
                    if (RUNNING && !Clock.this.isAnimated()) {
                        Clock.this.scheduleTickTask();
                    } else {
                        Clock.this.stopTask(Clock.this.periodicTickTask);
                    }
                }

                public Object getBean() {
                    return Clock.this;
                }

                public String getName() {
                    return "running";
                }
            };
        }
        return this.running;
    }

    public boolean isAutoNightMode() {
        return null == this.autoNightMode ? this._autoNightMode : this.autoNightMode.get();
    }

    public void setAutoNightMode(boolean MODE) {
        if (null == this.autoNightMode) {
            this._autoNightMode = MODE;
        } else {
            this.autoNightMode.set(MODE);
        }
    }

    public BooleanProperty autoNightModeProperty() {
        if (null == this.autoNightMode) {
            this.autoNightMode = new SimpleBooleanProperty((Object)this, "autoNightMode", this._autoNightMode);
        }
        return this.autoNightMode;
    }

    public Paint getBackgroundPaint() {
        return null == this.backgroundPaint ? this._backgroundPaint : (Paint)this.backgroundPaint.get();
    }

    public void setBackgroundPaint(Paint PAINT) {
        if (null == this.backgroundPaint) {
            this._backgroundPaint = PAINT;
        } else {
            this.backgroundPaint.set((Object)PAINT);
        }
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public ObjectProperty<Paint> backgroundPaintProperty() {
        if (null == this.backgroundPaint) {
            this.backgroundPaint = new SimpleObjectProperty((Object)this, "backgroundPaint", (Object)this._backgroundPaint);
        }
        return this.backgroundPaint;
    }

    public Paint getBorderPaint() {
        return null == this.borderPaint ? this._borderPaint : (Paint)this.borderPaint.get();
    }

    public void setBorderPaint(Paint PAINT) {
        if (null == this.borderPaint) {
            this._borderPaint = PAINT;
        } else {
            this.borderPaint.set((Object)PAINT);
        }
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public ObjectProperty<Paint> borderPaintProperty() {
        if (null == this.borderPaint) {
            this.borderPaint = new SimpleObjectProperty((Object)this, "borderPaint", (Object)this._borderPaint);
        }
        return this.borderPaint;
    }

    public double getBorderWidth() {
        return null == this.borderWidth ? this._borderWidth : this.borderWidth.get();
    }

    public void setBorderWidth(double WIDTH) {
        if (null == this.borderWidth) {
            this._borderWidth = Helper.clamp(0.0, 50.0, WIDTH);
        } else {
            this.borderWidth.set(WIDTH);
        }
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public DoubleProperty borderWidthProperty() {
        if (null == this.borderWidth) {
            this.borderWidth = new DoublePropertyBase(this._borderWidth){

                public void set(double WIDTH) {
                    super.set(Helper.clamp(0.0, 50.0, WIDTH).doubleValue());
                }

                public Object getBean() {
                    return Clock.this;
                }

                public String getName() {
                    return "borderWidth";
                }
            };
        }
        return this.borderWidth;
    }

    public Paint getForegroundPaint() {
        return null == this.foregroundPaint ? this._foregroundPaint : (Paint)this.foregroundPaint.get();
    }

    public void setForegroundPaint(Paint PAINT) {
        if (null == this.foregroundPaint) {
            this._foregroundPaint = PAINT;
        } else {
            this.foregroundPaint.set((Object)PAINT);
        }
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public ObjectProperty<Paint> foregroundPaintProperty() {
        if (null == this.foregroundPaint) {
            this.foregroundPaint = new SimpleObjectProperty((Object)this, "foregroundPaint", (Object)this._foregroundPaint);
        }
        return this.foregroundPaint;
    }

    public Color getTitleColor() {
        return null == this.titleColor ? this._titleColor : (Color)this.titleColor.get();
    }

    public void setTitleColor(Color COLOR) {
        if (null == this.titleColor) {
            this._titleColor = COLOR;
        } else {
            this.titleColor.set((Object)COLOR);
        }
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public ObjectProperty<Color> titleColorProperty() {
        if (null == this.titleColor) {
            this.titleColor = new SimpleObjectProperty((Object)this, "titleColor", (Object)this._titleColor);
        }
        return this.titleColor;
    }

    public Color getTextColor() {
        return null == this.textColor ? this._textColor : (Color)this.textColor.get();
    }

    public void setTextColor(Color COLOR) {
        if (null == this.textColor) {
            this._textColor = COLOR;
        } else {
            this.textColor.set((Object)COLOR);
        }
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public ObjectProperty<Color> textColorProperty() {
        if (null == this.textColor) {
            this.textColor = new SimpleObjectProperty((Object)this, "textColor", (Object)this._textColor);
        }
        return this.textColor;
    }

    public Color getDateColor() {
        return null == this.dateColor ? this._dateColor : (Color)this.dateColor.get();
    }

    public void setDateColor(Color COLOR) {
        if (null == this.dateColor) {
            this._dateColor = COLOR;
        } else {
            this.dateColor.set((Object)COLOR);
        }
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public ObjectProperty<Color> dateColorProperty() {
        if (null == this.dateColor) {
            this.dateColor = new SimpleObjectProperty((Object)this, "dateColor", (Object)this._dateColor);
        }
        return this.dateColor;
    }

    public Color getHourTickMarkColor() {
        return null == this.hourTickMarkColor ? this._hourTickMarkColor : (Color)this.hourTickMarkColor.get();
    }

    public void setHourTickMarkColor(Color COLOR) {
        if (null == this.hourTickMarkColor) {
            this._hourTickMarkColor = COLOR;
        } else {
            this.hourTickMarkColor.set((Object)COLOR);
        }
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public ObjectProperty<Color> hourTickMarkColorProperty() {
        if (null == this.hourTickMarkColor) {
            this.hourTickMarkColor = new SimpleObjectProperty((Object)this, "hourTickMarkColor", (Object)this._hourTickMarkColor);
        }
        return this.hourTickMarkColor;
    }

    public Color getMinuteTickMarkColor() {
        return null == this.minuteTickMarkColor ? this._minuteTickMarkColor : (Color)this.minuteTickMarkColor.get();
    }

    public void setMinuteTickMarkColor(Color COLOR) {
        if (null == this.minuteTickMarkColor) {
            this._minuteTickMarkColor = COLOR;
        } else {
            this.minuteTickMarkColor.set((Object)COLOR);
        }
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public ObjectProperty<Color> minuteTickMarkColorProperty() {
        if (null == this.minuteTickMarkColor) {
            this.minuteTickMarkColor = new SimpleObjectProperty((Object)this, "minuteTickMarkColor", (Object)this._minuteTickMarkColor);
        }
        return this.minuteTickMarkColor;
    }

    public Color getTickLabelColor() {
        return null == this.tickLabelColor ? this._tickLabelColor : (Color)this.tickLabelColor.get();
    }

    public void setTickLabelColor(Color COLOR) {
        if (null == this.tickLabelColor) {
            this._tickLabelColor = COLOR;
        } else {
            this.tickLabelColor.set((Object)COLOR);
        }
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public ObjectProperty<Color> tickLabelColorProperty() {
        if (null == this.tickLabelColor) {
            this.tickLabelColor = new SimpleObjectProperty((Object)this, "tickLabelColor", (Object)this._tickLabelColor);
        }
        return this.tickLabelColor;
    }

    public Color getAlarmColor() {
        return null == this.alarmColor ? this._alarmColor : (Color)this.alarmColor.get();
    }

    public void setAlarmColor(Color COLOR) {
        if (null == this.alarmColor) {
            this._alarmColor = COLOR;
        } else {
            this.alarmColor.set((Object)COLOR);
        }
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public ObjectProperty<Color> alarmColorProperty() {
        if (null == this.alarmColor) {
            this.alarmColor = new SimpleObjectProperty((Object)this, "alarmColor", (Object)this._alarmColor);
        }
        return this.alarmColor;
    }

    public boolean isHourTickMarksVisible() {
        return null == this.hourTickMarksVisible ? this._hourTickMarksVisible : this.hourTickMarksVisible.get();
    }

    public void setHourTickMarksVisible(boolean VISIBLE) {
        if (null == this.hourTickMarksVisible) {
            this._hourTickMarksVisible = VISIBLE;
        } else {
            this.hourTickMarksVisible.set(VISIBLE);
        }
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public BooleanProperty hourTickMarksVisibleProperty() {
        if (null == this.hourTickMarksVisible) {
            this.hourTickMarksVisible = new SimpleBooleanProperty((Object)this, "hourTickMarksVisible", this._hourTickMarksVisible);
        }
        return this.hourTickMarksVisible;
    }

    public boolean isMinuteTickMarksVisible() {
        return null == this.minuteTickMarksVisible ? this._minuteTickMarksVisible : this.minuteTickMarksVisible.get();
    }

    public void setMinuteTickMarksVisible(boolean VISIBLE) {
        if (null == this.minuteTickMarksVisible) {
            this._minuteTickMarksVisible = VISIBLE;
        } else {
            this.minuteTickMarksVisible.set(VISIBLE);
        }
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public BooleanProperty minuteTickMarksVisibleProperty() {
        if (null == this.minuteTickMarksVisible) {
            this.minuteTickMarksVisible = new SimpleBooleanProperty((Object)this, "minuteTickMarksVisible", this._minuteTickMarksVisible);
        }
        return this.minuteTickMarksVisible;
    }

    public boolean isTickLabelsVisible() {
        return null == this.tickLabelsVisible ? this._tickLabelsVisible : this.tickLabelsVisible.get();
    }

    public void setTickLabelsVisible(boolean VISIBLE) {
        if (null == this.tickLabelsVisible) {
            this._tickLabelsVisible = VISIBLE;
        } else {
            this.tickLabelsVisible.set(VISIBLE);
        }
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public BooleanProperty tickLabelsVisibleProperty() {
        if (null == this.tickLabelsVisible) {
            this.tickLabelsVisible = new SimpleBooleanProperty((Object)this, "tickLabelsVisible", this._tickLabelsVisible);
        }
        return this.tickLabelsVisible;
    }

    public Color getHourColor() {
        return null == this.hourColor ? this._hourColor : (Color)this.hourColor.get();
    }

    public void setHourColor(Color COLOR) {
        if (null == this.hourColor) {
            this._hourColor = COLOR;
        } else {
            this.hourColor.set((Object)COLOR);
        }
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public ObjectProperty<Color> hourColorProperty() {
        if (null == this.hourColor) {
            this.hourColor = new SimpleObjectProperty((Object)this, "hourColor", (Object)this._hourColor);
        }
        return this.hourColor;
    }

    public Color getMinuteColor() {
        return null == this.minuteColor ? this._minuteColor : (Color)this.minuteColor.get();
    }

    public void setMinuteColor(Color COLOR) {
        if (null == this.minuteColor) {
            this._minuteColor = COLOR;
        } else {
            this.minuteColor.set((Object)COLOR);
        }
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public ObjectProperty<Color> minuteColorProperty() {
        if (null == this.minuteColor) {
            this.minuteColor = new SimpleObjectProperty((Object)this, "minuteColor", (Object)this._minuteColor);
        }
        return this.minuteColor;
    }

    public Color getSecondColor() {
        return null == this.secondColor ? this._secondColor : (Color)this.secondColor.get();
    }

    public void setSecondColor(Color COLOR) {
        if (null == this.secondColor) {
            this._secondColor = COLOR;
        } else {
            this.secondColor.set((Object)COLOR);
        }
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public ObjectProperty<Color> secondColorProperty() {
        if (null == this.secondColor) {
            this.secondColor = new SimpleObjectProperty((Object)this, "secondColor", (Object)this._secondColor);
        }
        return this.secondColor;
    }

    public Color getKnobColor() {
        return null == this.knobColor ? this._knobColor : (Color)this.knobColor.get();
    }

    public void setKnobColor(Color COLOR) {
        if (null == this.knobColor) {
            this._knobColor = COLOR;
        } else {
            this.knobColor.set((Object)COLOR);
        }
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public ObjectProperty<Color> knobColorProperty() {
        if (null == this.knobColor) {
            this.knobColor = new SimpleObjectProperty((Object)this, "knobColor", (Object)this._knobColor);
        }
        return this.knobColor;
    }

    public LcdDesign getLcdDesign() {
        return null == this.lcdDesign ? this._lcdDesign : (LcdDesign)((Object)this.lcdDesign.get());
    }

    public void setLcdDesign(LcdDesign DESIGN) {
        if (null == this.lcdDesign) {
            this._lcdDesign = DESIGN;
        } else {
            this.lcdDesign.set((Object)DESIGN);
        }
        this.fireUpdateEvent(this.LCD_EVENT);
    }

    public ObjectProperty<LcdDesign> lcdDesignProperty() {
        if (null == this.lcdDesign) {
            this.lcdDesign = new SimpleObjectProperty((Object)this, "lcdDesign", (Object)this._lcdDesign);
        }
        return this.lcdDesign;
    }

    public boolean isAlarmsEnabled() {
        return null == this.alarmsEnabled ? this._alarmsEnabled : this.alarmsEnabled.get();
    }

    public void setAlarmsEnabled(boolean CHECK) {
        if (null == this.alarmsEnabled) {
            this._alarmsEnabled = CHECK;
        } else {
            this.alarmsEnabled.set(CHECK);
        }
        this.fireUpdateEvent(this.VISIBILITY_EVENT);
    }

    public BooleanProperty alarmsEnabledProperty() {
        if (null == this.alarmsEnabled) {
            this.alarmsEnabled = new SimpleBooleanProperty((Object)this, "alarmsEnabled", this._alarmsEnabled);
        }
        return this.alarmsEnabled;
    }

    public boolean isAlarmsVisible() {
        return null == this.alarmsVisible ? this._alarmsVisible : this.alarmsVisible.get();
    }

    public void setAlarmsVisible(boolean VISIBLE) {
        if (null == this.alarmsVisible) {
            this._alarmsVisible = VISIBLE;
        } else {
            this.alarmsVisible.set(VISIBLE);
        }
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public BooleanProperty alarmsVisibleProperty() {
        if (null == this.alarmsVisible) {
            this.alarmsVisible = new SimpleBooleanProperty((Object)this, "alarmsVisible", this._alarmsVisible);
        }
        return this.alarmsVisible;
    }

    public ObservableList<Alarm> getAlarms() {
        return this.alarms;
    }

    public void setAlarms(List<Alarm> ALARMS) {
        this.alarms.setAll(ALARMS);
    }

    public void setAlarms(Alarm ... ALARMS) {
        this.setAlarms(Arrays.asList(ALARMS));
    }

    public void addAlarm(Alarm ALARM) {
        if (!this.alarms.contains((Object)ALARM)) {
            this.alarms.add((Object)ALARM);
        }
    }

    public void removeAlarm(Alarm ALARM) {
        if (this.alarms.contains((Object)ALARM)) {
            this.alarms.remove((Object)ALARM);
        }
    }

    public void clearAlarms() {
        this.alarms.clear();
    }

    public boolean isLcdCrystalEnabled() {
        return null == this.lcdCrystalEnabled ? this._lcdCrystalEnabled : this.lcdCrystalEnabled.get();
    }

    public void setLcdCrystalEnabled(boolean ENABLED) {
        if (null == this.lcdCrystalEnabled) {
            this._lcdCrystalEnabled = ENABLED;
        } else {
            this.lcdCrystalEnabled.set(ENABLED);
        }
        this.fireUpdateEvent(this.VISIBILITY_EVENT);
    }

    public BooleanProperty lcdCrystalEnabledProperty() {
        if (null == this.lcdCrystalEnabled) {
            this.lcdCrystalEnabled = new SimpleBooleanProperty((Object)this, "lcdCrystalEnabled", this._lcdCrystalEnabled);
        }
        return this.lcdCrystalEnabled;
    }

    public boolean getShadowsEnabled() {
        return null == this.shadowsEnabled ? this._shadowsEnabled : this.shadowsEnabled.get();
    }

    public void setShadowsEnabled(boolean ENABLED) {
        if (null == this.shadowsEnabled) {
            this._shadowsEnabled = ENABLED;
        } else {
            this.shadowsEnabled.set(ENABLED);
        }
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public BooleanProperty shadowsEnabledProperty() {
        if (null == this.shadowsEnabled) {
            this.shadowsEnabled = new SimpleBooleanProperty((Object)this, "shadowsEnabled", this._shadowsEnabled);
        }
        return this.shadowsEnabled;
    }

    public LcdFont getLcdFont() {
        return null == this.lcdFont ? this._lcdFont : (LcdFont)((Object)this.lcdFont.get());
    }

    public void setLcdFont(LcdFont FONT) {
        if (null == this.lcdFont) {
            this._lcdFont = FONT;
        } else {
            this.lcdFont.set((Object)FONT);
        }
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public ObjectProperty<LcdFont> lcdFontProperty() {
        if (null == this.lcdFont) {
            this.lcdFont = new SimpleObjectProperty((Object)this, "lcdFont", (Object)this._lcdFont);
        }
        return this.lcdFont;
    }

    public Locale getLocale() {
        return null == this.locale ? this._locale : (Locale)this.locale.get();
    }

    public void setLocale(Locale LOCALE) {
        if (null == this.locale) {
            this._locale = LOCALE;
        } else {
            this.locale.set((Object)LOCALE);
        }
        this.fireUpdateEvent(this.RECALC_EVENT);
    }

    public ObjectProperty<Locale> localeProperty() {
        if (null == this.locale) {
            this.locale = new SimpleObjectProperty((Object)this, "locale", (Object)this._locale);
        }
        return this.locale;
    }

    public TickLabelLocation getTickLabelLocation() {
        return null == this.tickLabelLocation ? this._tickLabelLocation : (TickLabelLocation)((Object)this.tickLabelLocation.get());
    }

    public void setTickLabelLocation(TickLabelLocation LOCATION) {
        if (null == this.tickLabelLocation) {
            this._tickLabelLocation = LOCATION;
        } else {
            this.tickLabelLocation.set((Object)LOCATION);
        }
        this.fireUpdateEvent(this.REDRAW_EVENT);
    }

    public ObjectProperty<TickLabelLocation> tickLabelLocationProperty() {
        if (null == this.tickLabelLocation) {
            this.tickLabelLocation = new SimpleObjectProperty((Object)this, "tickLabelLocation", (Object)this._tickLabelLocation);
        }
        return this.tickLabelLocation;
    }

    public boolean isAnimated() {
        return null == this.animated ? this._animated : this.animated.get();
    }

    public void setAnimated(boolean ANIMATED) {
        if (null == this.animated) {
            this._animated = ANIMATED;
        } else {
            this.animated.set(ANIMATED);
        }
    }

    public BooleanProperty animatedProperty() {
        if (null == this.animated) {
            this.animated = new SimpleBooleanProperty((Object)this, "animated", this._animated);
        }
        return this.animated;
    }

    public long getAnimationDuration() {
        return this.animationDuration;
    }

    public void setAnimationDuration(long ANIMATION_DURATION) {
        this.animationDuration = Helper.clamp(10L, 20000L, ANIMATION_DURATION);
    }

    private void checkAlarms(ZonedDateTime TIME) {
        this.alarmsToRemove.clear();
        for (Alarm alarm : this.alarms) {
            ZonedDateTime ALARM_TIME = alarm.getTime();
            switch (alarm.getRepetition()) {
                case ONCE: {
                    if (!TIME.isAfter(ALARM_TIME)) break;
                    if (alarm.isArmed()) {
                        this.fireAlarmEvent(new AlarmEvent((Object)this, alarm));
                        alarm.executeCommand();
                    }
                    this.alarmsToRemove.add(alarm);
                    break;
                }
                case HALF_HOURLY: {
                    if (ALARM_TIME.getMinute() != TIME.getMinute() && ALARM_TIME.plusMinutes(30L).getMinute() != TIME.getMinute() || ALARM_TIME.getSecond() != TIME.getSecond() || !alarm.isArmed()) break;
                    this.fireAlarmEvent(new AlarmEvent((Object)this, alarm));
                    alarm.executeCommand();
                    break;
                }
                case HOURLY: {
                    if (ALARM_TIME.getMinute() != TIME.getMinute() || ALARM_TIME.getSecond() != TIME.getSecond() || !alarm.isArmed()) break;
                    this.fireAlarmEvent(new AlarmEvent((Object)this, alarm));
                    alarm.executeCommand();
                    break;
                }
                case DAILY: {
                    if (ALARM_TIME.getHour() != TIME.getHour() || ALARM_TIME.getMinute() != TIME.getMinute() || ALARM_TIME.getSecond() != TIME.getSecond() || !alarm.isArmed()) break;
                    this.fireAlarmEvent(new AlarmEvent((Object)this, alarm));
                    alarm.executeCommand();
                    break;
                }
                case WEEKLY: {
                    if (ALARM_TIME.getDayOfWeek() != TIME.getDayOfWeek() || ALARM_TIME.getHour() != TIME.getHour() || ALARM_TIME.getMinute() != TIME.getMinute() || ALARM_TIME.getSecond() != TIME.getSecond() || !alarm.isArmed()) break;
                    this.fireAlarmEvent(new AlarmEvent((Object)this, alarm));
                    alarm.executeCommand();
                }
            }
        }
        for (Alarm alarm : this.alarmsToRemove) {
            this.removeAlarm(alarm);
        }
    }

    private void checkForNight(ZonedDateTime TIME) {
        int hour = TIME.getHour();
        int minute = TIME.getMinute();
        if (0 <= hour && minute >= 0 && hour <= 5 && minute <= 59 || 17 <= hour && minute <= 59 && hour <= 23 && minute <= 59) {
            if (this.isNightMode()) {
                return;
            }
            this.setNightMode(true);
        } else {
            if (!this.isNightMode()) {
                return;
            }
            this.setNightMode(false);
        }
    }

    private void tick() {
        Platform.runLater(() -> {
            int i;
            int listSize;
            if (this.isAnimated()) {
                return;
            }
            ZonedDateTime oldTime = this.getTime();
            this.setTime(this.getTime().plus(java.time.Duration.ofMillis(this.updateInterval)));
            ZonedDateTime now = (ZonedDateTime)this.time.get();
            if (this.isAlarmsEnabled()) {
                this.checkAlarms(now);
            }
            if (this.isAutoNightMode()) {
                this.checkForNight(now);
            }
            if (this.getCheckSectionsForValue()) {
                listSize = this.sections.size();
                for (i = 0; i < listSize; ++i) {
                    ((TimeSection)this.sections.get(i)).checkForValue(LocalTime.from(now));
                }
            }
            if (this.getCheckAreasForValue()) {
                listSize = this.areas.size();
                for (i = 0; i < listSize; ++i) {
                    ((TimeSection)this.areas.get(i)).checkForValue(LocalTime.from(now));
                }
            }
            if (this.timeEventListenerList.isEmpty()) {
                return;
            }
            if (oldTime.getSecond() != now.getSecond()) {
                this.fireTimeEvent(new TimeEvent((Object)this, now, TimeEvent.TimeEventType.SECOND));
            }
            if (oldTime.getMinute() != now.getMinute()) {
                this.fireTimeEvent(new TimeEvent((Object)this, now, TimeEvent.TimeEventType.MINUTE));
            }
            if (oldTime.getHour() != now.getHour()) {
                this.fireTimeEvent(new TimeEvent((Object)this, now, TimeEvent.TimeEventType.HOUR));
            }
        });
    }

    private static synchronized void enableTickExecutorService() {
        if (null == periodicTickExecutorService) {
            periodicTickExecutorService = new ScheduledThreadPoolExecutor(1, Clock.getThreadFactory("ClockTick", false));
        }
    }

    private synchronized void scheduleTickTask() {
        Clock.enableTickExecutorService();
        this.stopTask(this.periodicTickTask);
        this.updateInterval = this.isDiscreteMinutes() && this.isDiscreteSeconds() ? 1000 : 20;
        this.periodicTickTask = periodicTickExecutorService.scheduleAtFixedRate(() -> this.tick(), 0L, this.updateInterval, TimeUnit.MILLISECONDS);
    }

    private static ThreadFactory getThreadFactory(String THREAD_NAME, boolean IS_DAEMON) {
        return runnable -> {
            Thread thread = new Thread(runnable, THREAD_NAME);
            thread.setDaemon(IS_DAEMON);
            return thread;
        };
    }

    private void stopTask(ScheduledFuture<?> task) {
        if (null == task) {
            return;
        }
        task.cancel(true);
        task = null;
    }

    public void stop() {
        if (null != this.periodicTickTask) {
            this.stopTask(this.periodicTickTask);
        }
        if (null != periodicTickExecutorService) {
            periodicTickExecutorService.shutdownNow();
        }
    }

    private void createShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.stop()));
    }

    protected Skin createDefaultSkin() {
        switch (this.skinType) {
            case YOTA2: {
                return new ClockSkin(this);
            }
            case LCD: {
                return new LcdClockSkin(this);
            }
            case PEAR: {
                return new PearClockSkin(this);
            }
            case PLAIN: {
                return new PlainClockSkin(this);
            }
            case DB: {
                return new DBClockSkin(this);
            }
            case FAT: {
                return new FatClockSkin(this);
            }
            case ROUND_LCD: {
                return new RoundLcdClockSkin(this);
            }
            case SLIM: {
                return new SlimClockSkin(this);
            }
        }
        return new ClockSkin(this);
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("clock.css").toExternalForm();
    }

    public ClockSkinType getSkinType() {
        return this.skinType;
    }

    public void setSkinType(ClockSkinType SKIN) {
        this.skinType = SKIN;
        switch (SKIN) {
            case YOTA2: {
                this.setBackgroundPaint((Paint)Color.rgb((int)40, (int)42, (int)48));
                this.setHourTickMarkColor(Color.rgb((int)255, (int)255, (int)255));
                this.setMinuteTickMarkColor(Color.rgb((int)255, (int)255, (int)255, (double)0.5));
                this.setHourColor(Color.WHITE);
                this.setMinuteColor(Color.WHITE);
                this.setKnobColor(Color.WHITE);
                super.setSkin((Skin)new ClockSkin(this));
                break;
            }
            case LCD: {
                this.setBorderPaint((Paint)Color.WHITE);
                this.setForegroundPaint((Paint)Color.WHITE);
                super.setSkin((Skin)new LcdClockSkin(this));
                break;
            }
            case PEAR: {
                this.setBackgroundPaint((Paint)Color.BLACK);
                this.setHourColor(Color.WHITE);
                this.setMinuteColor(Color.WHITE);
                this.setSecondColor(Color.rgb((int)255, (int)165, (int)24));
                this.setHourTickMarkColor(Color.WHITE);
                this.setMinuteTickMarkColor(Color.rgb((int)115, (int)115, (int)115));
                this.setTickLabelColor(Color.WHITE);
                this.setDateColor(Color.WHITE);
                this.setDateVisible(true);
                this.setSecondsVisible(true);
                this.setTextVisible(false);
                this.setTitleVisible(false);
                super.setSkin((Skin)new PearClockSkin(this));
                break;
            }
            case PLAIN: {
                this.setBackgroundPaint((Paint)Color.rgb((int)29, (int)29, (int)29));
                this.setHourColor(Color.rgb((int)190, (int)190, (int)190));
                this.setMinuteColor(Color.rgb((int)190, (int)190, (int)190));
                this.setSecondColor(Color.rgb((int)0, (int)244, (int)0));
                this.setDateColor(Color.rgb((int)190, (int)190, (int)190));
                this.setSecondsVisible(true);
                this.setHourTickMarkColor(Color.rgb((int)240, (int)240, (int)240));
                this.setMinuteTickMarkColor(Color.rgb((int)240, (int)240, (int)240));
                super.setSkin((Skin)new PlainClockSkin(this));
                break;
            }
            case DB: {
                this.setDiscreteSeconds(false);
                this.setDiscreteMinutes(true);
                this.setSecondColor(Color.rgb((int)167, (int)0, (int)0));
                this.setSecondsVisible(true);
                break;
            }
            case FAT: {
                this.setDiscreteMinutes(true);
                break;
            }
            case ROUND_LCD: {
                this.setTextVisible(true);
                this.setDateVisible(true);
                break;
            }
            case SLIM: {
                this.setSecondsVisible(true);
                this.setDateVisible(true);
                this.setHourColor(Color.WHITE);
                this.setMinuteColor(Color.rgb((int)0, (int)191, (int)255));
                this.setSecondColor(Color.WHITE);
                this.setDateColor(Color.WHITE);
            }
            default: {
                super.setSkin((Skin)new ClockSkin(this));
            }
        }
    }

    public void setOnUpdate(UpdateEventListener LISTENER) {
        this.addUpdateEventListener(LISTENER);
    }

    public void addUpdateEventListener(UpdateEventListener LISTENER) {
        this.listenerList.add(LISTENER);
    }

    public void removeUpdateEventListener(UpdateEventListener LISTENER) {
        this.listenerList.remove(LISTENER);
    }

    public void fireUpdateEvent(UpdateEvent EVENT) {
        int listSize = this.listenerList.size();
        for (int i = 0; i < listSize; ++i) {
            this.listenerList.get(i).onUpdateEvent(EVENT);
        }
    }

    public void setOnAlarm(AlarmEventListener LISTENER) {
        this.addAlarmEventListener(LISTENER);
    }

    public void addAlarmEventListener(AlarmEventListener LISTENER) {
        this.alarmListenerList.add(LISTENER);
    }

    public void removeAlarmEventListener(AlarmEventListener LISTENER) {
        this.alarmListenerList.remove(LISTENER);
    }

    public void fireAlarmEvent(AlarmEvent EVENT) {
        int listSize = this.alarmListenerList.size();
        for (int i = 0; i < listSize; ++i) {
            this.alarmListenerList.get(i).onAlarmEvent(EVENT);
        }
    }

    public void setOnTimeEvent(TimeEventListener LISTENER) {
        this.addTimeEventListener(LISTENER);
    }

    public void addTimeEventListener(TimeEventListener LISTENER) {
        this.timeEventListenerList.add(LISTENER);
    }

    public void removeTimeEventListener(TimeEventListener LISTENER) {
        this.timeEventListenerList.remove(LISTENER);
    }

    public void fireTimeEvent(TimeEvent EVENT) {
        int listSize = this.timeEventListenerList.size();
        for (int i = 0; i < listSize; ++i) {
            this.timeEventListenerList.get(i).onTimeEvent(EVENT);
        }
    }

    public static enum ClockSkinType {
        CLOCK,
        YOTA2,
        LCD,
        PEAR,
        PLAIN,
        DB,
        FAT,
        ROUND_LCD,
        SLIM;

    }
}

