/**
 *
 * Copyright 2014 Florian Schmaus
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package eu.geekplace.javapinning.pin;

import java.util.Arrays;

public class Sha256Pin extends PublicKeyPin {

	protected Sha256Pin(String pinHexString) {
		super(pinHexString);
		if (sha256md == null) {
			throw new IllegalStateException("Can not create sha256 pins");
		}
	}

	@Override
	protected boolean pinsCertificate(byte[] pubkey) {
		byte[] digest;
		synchronized (sha256md) {
			digest = sha256md.digest(pubkey);
		}
		return Arrays.equals(pinBytes, digest);
	}

}
