/*
 * Decompiled with CFR 0.152.
 */
package nl.siegmann.epublib.epub;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import nl.siegmann.epublib.domain.Book;
import nl.siegmann.epublib.domain.CreatorContributor;
import nl.siegmann.epublib.domain.Identifier;
import nl.siegmann.epublib.domain.Resource;
import nl.siegmann.epublib.domain.TOCReference;
import nl.siegmann.epublib.domain.TableOfContents;
import nl.siegmann.epublib.epub.DOMUtil;
import nl.siegmann.epublib.epub.Epub2Writer;
import nl.siegmann.epublib.epub.EpubProcessorSupport;
import nl.siegmann.epublib.epub.EpubReader;
import nl.siegmann.epublib.service.MediatypeService;
import nl.siegmann.epublib.util.ResourceUtil;
import nl.siegmann.epublib.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmlpull.v1.XmlSerializer;

public class NavDocument {
    public static final String NAMESPACE_NCX = "http://www.daisy.org/z3986/2005/ncx/";
    public static final String NAMESPACE_EPUB = "http://www.idpf.org/2007/ops";
    public static final String PREFIX_NCX = "ncx";
    public static final String NCX_ITEM_ID = "ncx";
    public static final String DEFAULT_NAV_HREF = "toc.xhtml";
    public static final String PREFIX_DTB = "dtb";
    private static final Logger log = LoggerFactory.getLogger(NavDocument.class);

    public static Resource read(Book book, EpubReader epubReader) {
        Resource ncxResource = null;
        if (book.getSpine().getTocResource() == null) {
            log.error("Book does not contain a table of contents file");
            return ncxResource;
        }
        try {
            ncxResource = book.getSpine().getTocResource();
            if (ncxResource == null) {
                return ncxResource;
            }
            Document ncxDocument = ResourceUtil.getAsDocument(ncxResource);
            Element navMapElement = DOMUtil.getFirstElementByTagNameNS(ncxDocument.getDocumentElement(), NAMESPACE_NCX, "navMap");
            TableOfContents tableOfContents = new TableOfContents(NavDocument.readTOCReferences(navMapElement.getChildNodes(), book));
            book.setTableOfContents(tableOfContents);
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return ncxResource;
    }

    private static List<TOCReference> readTOCReferences(NodeList navpoints, Book book) {
        if (navpoints == null) {
            return new ArrayList<TOCReference>();
        }
        ArrayList<TOCReference> result = new ArrayList<TOCReference>(navpoints.getLength());
        for (int i = 0; i < navpoints.getLength(); ++i) {
            Node node = navpoints.item(i);
            if (node.getNodeType() != 1 || !node.getLocalName().equals("navPoint")) continue;
            TOCReference tocReference = NavDocument.readTOCReference((Element)node, book);
            result.add(tocReference);
        }
        return result;
    }

    private static TOCReference readTOCReference(Element navpointElement, Book book) {
        String label = NavDocument.readNavLabel(navpointElement);
        String tocResourceRoot = StringUtil.substringBeforeLast(book.getSpine().getTocResource().getHref(), '/');
        tocResourceRoot = tocResourceRoot.length() == book.getSpine().getTocResource().getHref().length() ? "" : tocResourceRoot + "/";
        String reference = StringUtil.collapsePathDots(tocResourceRoot + NavDocument.readNavReference(navpointElement));
        String href = StringUtil.substringBefore(reference, '#');
        String fragmentId = StringUtil.substringAfter(reference, '#');
        Resource resource = book.getResources().getByHref(href);
        if (resource == null) {
            log.error("Resource with href " + href + " in NCX document not found");
        }
        TOCReference result = new TOCReference(label, resource, fragmentId);
        NavDocument.readTOCReferences(navpointElement.getChildNodes(), book);
        result.setChildren(NavDocument.readTOCReferences(navpointElement.getChildNodes(), book));
        return result;
    }

    private static String readNavReference(Element navpointElement) {
        Element contentElement = DOMUtil.getFirstElementByTagNameNS(navpointElement, NAMESPACE_NCX, "content");
        String result = DOMUtil.getAttribute(contentElement, NAMESPACE_NCX, "src");
        try {
            result = URLDecoder.decode(result, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage());
        }
        return result;
    }

    private static String readNavLabel(Element navpointElement) {
        Element navLabel = DOMUtil.getFirstElementByTagNameNS(navpointElement, NAMESPACE_NCX, "navLabel");
        return DOMUtil.getTextChildrenContent(DOMUtil.getFirstElementByTagNameNS(navLabel, NAMESPACE_NCX, "text"));
    }

    public static void write(Epub2Writer epubWriter, Book book, ZipOutputStream resultStream) throws IOException {
        resultStream.putNextEntry(new ZipEntry(book.getSpine().getTocResource().getHref()));
        XmlSerializer out = EpubProcessorSupport.createXmlSerializer(resultStream);
        NavDocument.write(out, book);
        out.flush();
    }

    public static void write(XmlSerializer xmlSerializer, Book book) throws IllegalArgumentException, IllegalStateException, IOException {
        NavDocument.write(xmlSerializer, book.getMetadata().getIdentifiers(), book.getTitle(), book.getMetadata().getAuthors(), book.getTableOfContents());
    }

    public static Resource createNavResource(Book book) throws IllegalArgumentException, IllegalStateException, IOException {
        return NavDocument.createNavResource(book.getMetadata().getIdentifiers(), book.getTitle(), book.getMetadata().getAuthors(), book.getTableOfContents());
    }

    public static Resource createNavResource(List<Identifier> identifiers, String title, List<CreatorContributor> authors, TableOfContents tableOfContents) throws IllegalArgumentException, IllegalStateException, IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        XmlSerializer out = EpubProcessorSupport.createXmlSerializer(data);
        NavDocument.write(out, identifiers, title, authors, tableOfContents);
        Resource resource = new Resource("ncx", data.toByteArray(), DEFAULT_NAV_HREF, MediatypeService.NCX);
        return resource;
    }

    public static void write(XmlSerializer serializer, List<Identifier> identifiers, String title, List<CreatorContributor> authors, TableOfContents tableOfContents) throws IllegalArgumentException, IllegalStateException, IOException {
        serializer.startDocument("UTF-8", false);
        serializer.startTag(null, "html");
        serializer.attribute(null, "xmlns", "http://www.w3.org/1999/xhtml");
        NavDocument.writeHead(serializer, title);
        NavDocument.writeBody(serializer, tableOfContents);
        serializer.endTag(null, "html");
        serializer.endDocument();
    }

    private static void writeHead(XmlSerializer serializer, String title) throws IOException {
        serializer.startTag(null, "head");
        serializer.startTag(null, "title");
        serializer.text(title);
        serializer.endTag(null, "title");
        serializer.endTag(null, "head");
    }

    private static void writeBody(XmlSerializer serializer, TableOfContents tableOfContents) throws IOException {
        serializer.startTag(null, "body");
        serializer.attribute(NAMESPACE_EPUB, "type", "frontmatter");
        serializer.startTag(null, "nav");
        serializer.attribute(NAMESPACE_EPUB, "type", "toc");
        serializer.startTag(null, "ol");
        for (TOCReference ref : tableOfContents.getTocReferences()) {
            NavDocument.writeTOCReference(serializer, ref);
        }
        serializer.endTag(null, "ol");
        serializer.endTag(null, "nav");
        serializer.endTag(null, "body");
    }

    private static void writeTOCReference(XmlSerializer serializer, TOCReference ref) throws IOException {
        Resource resource = ref.getResource();
        serializer.startTag(null, "li");
        serializer.startTag(null, "a");
        serializer.attribute(null, "href", resource.getTocHref().replace(resource.getOriginalHref(), resource.getHref()));
        serializer.text(ref.getTitle());
        serializer.endTag(null, "a");
        if (!ref.getChildren().isEmpty()) {
            serializer.startTag(null, "ol");
            for (TOCReference subRef : ref.getChildren()) {
                NavDocument.writeTOCReference(serializer, subRef);
            }
            serializer.endTag(null, "ol");
        }
        serializer.endTag(null, "li");
    }

    private static interface NCXAttributes {
        public static final String src = "src";
        public static final String name = "name";
        public static final String content = "content";
        public static final String id = "id";
        public static final String playOrder = "playOrder";
        public static final String clazz = "class";
        public static final String version = "version";
    }

    private static interface EPUBTags {
        public static final String type = "type";
    }

    private static interface NCXTags {
        public static final String ncx = "ncx";
        public static final String meta = "meta";
        public static final String navPoint = "navPoint";
        public static final String navMap = "navMap";
        public static final String navLabel = "navLabel";
        public static final String content = "content";
        public static final String text = "text";
        public static final String docTitle = "docTitle";
        public static final String docAuthor = "docAuthor";
        public static final String head = "head";
    }
}

