/*
 * Decompiled with CFR 0.152.
 */
package nl.siegmann.epublib.epub;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import nl.siegmann.epublib.domain.Book;
import nl.siegmann.epublib.domain.Resource;
import nl.siegmann.epublib.domain.Spine;
import nl.siegmann.epublib.domain.SpineReference;
import nl.siegmann.epublib.epub.Epub3PackageDocumentMetadataWriter;
import nl.siegmann.epublib.epub.Epub3Writer;
import nl.siegmann.epublib.epub.PackageDocumentBase;
import nl.siegmann.epublib.service.MediatypeService;
import nl.siegmann.epublib.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xmlpull.v1.XmlSerializer;

public class Epub3PackageDocumentWriter
extends PackageDocumentBase {
    private static final Logger log = LoggerFactory.getLogger(Epub3PackageDocumentWriter.class);

    public static void write(Epub3Writer epubWriter, XmlSerializer serializer, Book book) throws IOException, IllegalArgumentException, IllegalStateException, ParserConfigurationException, SAXException {
        try {
            serializer.startDocument("UTF-8", false);
            serializer.setPrefix("dc", "http://purl.org/dc/elements/1.1/");
            serializer.startTag(null, "package");
            serializer.attribute("", "xmlns", "http://www.idpf.org/2007/opf");
            serializer.attribute("", "version", "3.0");
            serializer.attribute("", "unique-identifier", "BookId");
            Epub3PackageDocumentMetadataWriter.writeMetaData(book, serializer);
            Epub3PackageDocumentWriter.writeManifest(book, epubWriter, serializer);
            Epub3PackageDocumentWriter.writeSpine(book, epubWriter, serializer);
            serializer.endTag(null, "package");
            serializer.endDocument();
            serializer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void writeSpine(Book book, Epub3Writer epubWriter, XmlSerializer serializer) throws IllegalArgumentException, IllegalStateException, IOException {
        serializer.startTag(null, "spine");
        if (book.getCoverPage() != null && book.getSpine().findFirstResourceById(book.getCoverPage().getId()) < 0) {
            serializer.startTag(null, "itemref");
            serializer.attribute("", "idref", book.getCoverPage().getId());
            serializer.attribute("", "linear", "no");
            serializer.endTag(null, "itemref");
        }
        Epub3PackageDocumentWriter.writeSpineItems(book.getSpine(), serializer);
        serializer.endTag(null, "spine");
    }

    private static void writeManifest(Book book, Epub3Writer epubWriter, XmlSerializer serializer) throws IllegalArgumentException, IllegalStateException, IOException, ParserConfigurationException, SAXException {
        serializer.startTag(null, "manifest");
        for (Resource resource : Epub3PackageDocumentWriter.removeDuplicateResources(Epub3PackageDocumentWriter.getAllResourcesSortById(book))) {
            Epub3PackageDocumentWriter.writeItem(book, resource, serializer);
        }
        Epub3PackageDocumentWriter.writeNavItem(book, serializer);
        serializer.endTag(null, "manifest");
    }

    private static List<Resource> getAllResourcesSortById(Book book) {
        ArrayList<Resource> allResources = new ArrayList<Resource>(book.getResources().getAll());
        Collections.sort(allResources, new Comparator<Resource>(){

            @Override
            public int compare(Resource resource1, Resource resource2) {
                return resource1.getId().compareToIgnoreCase(resource2.getId());
            }
        });
        return allResources;
    }

    private static List<Resource> removeDuplicateResources(List<Resource> resources) {
        ArrayList<Resource> temp = new ArrayList<Resource>();
        for (Resource r : resources) {
            if (Epub3PackageDocumentWriter.containsDuplicate(temp, r)) continue;
            temp.add(r);
        }
        return temp;
    }

    private static boolean containsDuplicate(List<Resource> resources, Resource resource) {
        int index;
        for (index = 0; index < resources.size() && !resources.get(index).getHref().equals(resource.getHref()); ++index) {
        }
        return index < resources.size();
    }

    private static void writeItem(Book book, Resource resource, XmlSerializer serializer) throws IllegalArgumentException, IllegalStateException, IOException, ParserConfigurationException, SAXException {
        if (resource == null || resource.getMediaType() == MediatypeService.NCX && book.getSpine().getTocResource() != null) {
            return;
        }
        if (StringUtil.isBlank(resource.getId())) {
            log.error("resource id must not be empty (href: " + resource.getHref() + ", mediatype:" + resource.getMediaType() + ")");
            return;
        }
        if (StringUtil.isBlank(resource.getHref())) {
            log.error("resource href must not be empty (id: " + resource.getId() + ", mediatype:" + resource.getMediaType() + ")");
            return;
        }
        if (resource.getMediaType() == null) {
            log.error("resource mediatype must not be empty (id: " + resource.getId() + ", href:" + resource.getHref() + ")");
            return;
        }
        boolean isScripted = false;
        if (resource.getMediaType() == MediatypeService.XHTML) {
            System.out.println(resource.getHref());
            Document d = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(resource.getInputStream());
            NodeList l = d.getElementsByTagName("script");
            isScripted = l.getLength() > 0;
        }
        boolean isCoverImage = resource.equals(book.getCoverImage());
        serializer.startTag(null, "item");
        serializer.attribute("", "id", resource.getId());
        serializer.attribute("", "href", resource.getHref());
        serializer.attribute("", "media-type", resource.getMediaType().getName());
        String properties = null;
        if (isScripted) {
            properties = "scripted";
        }
        if (isCoverImage) {
            properties = properties == null ? "cover-image" : properties + " cover-image";
        }
        if (properties != null) {
            serializer.attribute("", "properties", properties);
        }
        serializer.endTag(null, "item");
    }

    private static void writeNavItem(Book book, XmlSerializer serializer) throws IOException {
        serializer.startTag(null, "item");
        serializer.attribute(null, "id", "toc");
        serializer.attribute(null, "properties", "nav");
        serializer.attribute(null, "href", "toc.xhtml");
        serializer.attribute(null, "media-type", "application/xhtml+xml");
        serializer.endTag(null, "item");
    }

    private static void writeSpineItems(Spine spine, XmlSerializer serializer) throws IllegalArgumentException, IllegalStateException, IOException {
        for (SpineReference spineReference : spine.getSpineReferences()) {
            serializer.startTag(null, "itemref");
            serializer.attribute("", "idref", spineReference.getResourceId());
            if (!spineReference.isLinear()) {
                serializer.attribute("", "linear", "no");
            }
            serializer.endTag(null, "itemref");
        }
    }
}

