/*
 * Decompiled with CFR 0.152.
 */
package nl.siegmann.epublib.epub;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import nl.siegmann.epublib.domain.Book;
import nl.siegmann.epublib.domain.CreatorContributor;
import nl.siegmann.epublib.domain.Date;
import nl.siegmann.epublib.domain.Identifier;
import nl.siegmann.epublib.domain.Relator;
import nl.siegmann.epublib.epub.PackageDocumentBase;
import nl.siegmann.epublib.util.StringUtil;
import org.xmlpull.v1.XmlSerializer;

public class Epub3PackageDocumentMetadataWriter
extends PackageDocumentBase {
    public static void writeMetaData(Book book, XmlSerializer serializer) throws IllegalArgumentException, IllegalStateException, IOException {
        int i;
        serializer.startTag(null, "metadata");
        serializer.setPrefix("dc", "http://purl.org/dc/elements/1.1/");
        Epub3PackageDocumentMetadataWriter.writeIdentifiers(book.getMetadata().getIdentifiers(), serializer);
        Epub3PackageDocumentMetadataWriter.writeSimpleMetdataElements("title", book.getMetadata().getTitles(), serializer);
        Epub3PackageDocumentMetadataWriter.writeSimpleMetdataElements("subject", book.getMetadata().getSubjects(), serializer);
        Epub3PackageDocumentMetadataWriter.writeSimpleMetdataElements("description", book.getMetadata().getDescriptions(), serializer);
        Epub3PackageDocumentMetadataWriter.writeSimpleMetdataElements("publisher", book.getMetadata().getPublishers(), serializer);
        Epub3PackageDocumentMetadataWriter.writeSimpleMetdataElements("type", book.getMetadata().getTypes(), serializer);
        Epub3PackageDocumentMetadataWriter.writeSimpleMetdataElements("rights", book.getMetadata().getRights(), serializer);
        Epub3PackageDocumentMetadataWriter.writeSimpleMetdataElements("coverage", book.getMetadata().getCoverages(), serializer);
        Epub3PackageDocumentMetadataWriter.writeSimpleMetdataElements("relation", book.getMetadata().getRelations(), serializer);
        Epub3PackageDocumentMetadataWriter.writeSimpleMetdataElements("source", book.getMetadata().getSources(), serializer);
        GregorianCalendar today = new GregorianCalendar();
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-mm-dd");
        SimpleDateFormat df2 = new SimpleDateFormat("hh:mm:ss");
        serializer.startTag(null, "meta");
        serializer.attribute(null, "property", "dcterms:modified");
        serializer.text(df1.format(today.getTime()) + "T" + df2.format(today.getTime()) + "Z");
        serializer.endTag(null, "meta");
        ArrayList<String> list = new ArrayList<String>();
        list.add(book.getMetadata().getLanguage());
        Epub3PackageDocumentMetadataWriter.writeSimpleMetdataElements("language", list, serializer);
        for (i = 0; i < book.getMetadata().getCreators().size(); ++i) {
            CreatorContributor creatorContributor = book.getMetadata().getCreators().get(i);
            serializer.startTag("http://purl.org/dc/elements/1.1/", "creator");
            serializer.attribute(null, "id", "cre" + i);
            serializer.text(creatorContributor.getFirstname() + " " + creatorContributor.getLastname());
            serializer.endTag("http://purl.org/dc/elements/1.1/", "creator");
            for (Relator relator : creatorContributor.getRelators()) {
                serializer.startTag(null, "meta");
                serializer.attribute(null, "refines", "#cre" + i);
                serializer.attribute(null, "property", "role");
                serializer.attribute(null, "scheme", "marc:relators");
                serializer.text(relator.getCode());
                serializer.endTag(null, "meta");
            }
            serializer.startTag(null, "meta");
            serializer.attribute(null, "refines", "#cre" + i);
            serializer.attribute(null, "property", "file-as");
            serializer.text(creatorContributor.getLastname() + ", " + creatorContributor.getFirstname());
            serializer.endTag(null, "meta");
        }
        for (i = 0; i < book.getMetadata().getContributors().size(); ++i) {
            CreatorContributor creatorContributor = book.getMetadata().getContributors().get(i);
            serializer.startTag("http://purl.org/dc/elements/1.1/", "contributor");
            serializer.attribute(null, "id", "con" + i);
            serializer.text(creatorContributor.getFirstname() + " " + creatorContributor.getLastname());
            serializer.endTag("http://purl.org/dc/elements/1.1/", "contributor");
            for (Relator relator : creatorContributor.getRelators()) {
                serializer.startTag(null, "meta");
                serializer.attribute(null, "refines", "#con" + i);
                serializer.attribute(null, "property", "role");
                serializer.attribute(null, "scheme", "marc:relators");
                serializer.text(relator.getCode());
                serializer.endTag(null, "meta");
            }
            serializer.startTag(null, "meta");
            serializer.attribute(null, "refines", "#con" + i);
            serializer.attribute(null, "property", "file-as");
            serializer.text(creatorContributor.getLastname() + ", " + creatorContributor.getFirstname());
            serializer.endTag(null, "meta");
        }
        for (Date date : book.getMetadata().getDates()) {
            serializer.startTag("http://purl.org/dc/elements/1.1/", "date");
            if (date.getEvent() != null) {
                serializer.attribute("http://www.idpf.org/2007/opf", "event", date.getEvent().toString());
            }
            serializer.text(date.getValue());
            serializer.endTag("http://purl.org/dc/elements/1.1/", "date");
        }
        if (StringUtil.isNotBlank(book.getMetadata().getLanguage())) {
            serializer.startTag("http://purl.org/dc/elements/1.1/", "language");
            serializer.text(book.getMetadata().getLanguage());
            serializer.endTag("http://purl.org/dc/elements/1.1/", "language");
        }
        if (book.getMetadata().getOtherProperties() != null) {
            for (Map.Entry entry : book.getMetadata().getOtherProperties().entrySet()) {
                serializer.startTag(((QName)entry.getKey()).getNamespaceURI(), ((QName)entry.getKey()).getLocalPart());
                serializer.text((String)entry.getValue());
                serializer.endTag(((QName)entry.getKey()).getNamespaceURI(), ((QName)entry.getKey()).getLocalPart());
            }
        }
        if (book.getCoverImage() != null) {
            serializer.startTag("http://www.idpf.org/2007/opf", "meta");
            serializer.attribute("", "name", "cover");
            serializer.attribute("", "content", book.getCoverImage().getId());
            serializer.endTag("http://www.idpf.org/2007/opf", "meta");
        }
        serializer.startTag("http://www.idpf.org/2007/opf", "meta");
        serializer.attribute("", "name", "generator");
        serializer.attribute("", "content", "EPUBLib version 3.0");
        serializer.endTag("http://www.idpf.org/2007/opf", "meta");
        serializer.endTag(null, "metadata");
    }

    private static void writeSimpleMetdataElements(String tagName, List<String> values, XmlSerializer serializer) throws IllegalArgumentException, IllegalStateException, IOException {
        for (String value : values) {
            if (StringUtil.isBlank(value)) continue;
            serializer.startTag("http://purl.org/dc/elements/1.1/", tagName);
            serializer.text(value);
            serializer.endTag("http://purl.org/dc/elements/1.1/", tagName);
        }
    }

    private static void writeIdentifiers(List<Identifier> identifiers, XmlSerializer serializer) throws IllegalArgumentException, IllegalStateException, IOException {
        Identifier bookIdIdentifier = Identifier.getBookIdIdentifier(identifiers);
        if (bookIdIdentifier == null) {
            return;
        }
        serializer.startTag("http://purl.org/dc/elements/1.1/", "identifier");
        serializer.attribute("", "id", "BookId");
        serializer.text(bookIdIdentifier.getValue());
        serializer.endTag("http://purl.org/dc/elements/1.1/", "identifier");
        for (Identifier identifier : identifiers.subList(1, identifiers.size())) {
            if (identifier == bookIdIdentifier) continue;
            serializer.startTag("http://purl.org/dc/elements/1.1/", "identifier");
            serializer.text(identifier.getValue());
            serializer.endTag("http://purl.org/dc/elements/1.1/", "identifier");
        }
    }
}

