/*
 * Decompiled with CFR 0.152.
 */
package nl.siegmann.epublib.epub;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import nl.siegmann.epublib.domain.Book;
import nl.siegmann.epublib.domain.Resource;
import nl.siegmann.epublib.epub.AbstractEpubWriter;
import nl.siegmann.epublib.epub.BookProcessor;
import nl.siegmann.epublib.epub.Epub2PackageDocumentWriter;
import nl.siegmann.epublib.epub.EpubProcessorSupport;
import nl.siegmann.epublib.epub.NCXDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlSerializer;

public class Epub2Writer
extends AbstractEpubWriter {
    private static final Logger log = LoggerFactory.getLogger(Epub2Writer.class);

    public Epub2Writer() {
    }

    public Epub2Writer(BookProcessor bookProcessor) {
        super(bookProcessor);
    }

    @Override
    public void write(Book book, OutputStream out) throws IOException {
        book = this.processBook(book);
        ZipOutputStream resultStream = new ZipOutputStream(out);
        this.writeMimeType(resultStream);
        this.writeContainer(resultStream);
        this.initTOCResource(book);
        this.writeResources(book, resultStream);
        this.writePackageDocument(book, resultStream);
        resultStream.close();
    }

    private void initTOCResource(Book book) {
        try {
            Resource tocResource = NCXDocument.createNCXResource(book);
            this.initTOCResource(book, tocResource);
        }
        catch (Exception e) {
            log.error("Error writing table of contents: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private void writePackageDocument(Book book, ZipOutputStream resultStream) throws IOException {
        resultStream.putNextEntry(new ZipEntry("OEBPS/content.opf"));
        XmlSerializer xmlSerializer = EpubProcessorSupport.createXmlSerializer(resultStream);
        Epub2PackageDocumentWriter.write(this, xmlSerializer, book);
        xmlSerializer.flush();
    }

    public String getNcxId() {
        return "ncx";
    }

    public String getNcxHref() {
        return "toc.ncx";
    }

    public String getNcxMediaType() {
        return "application/x-dtbncx+xml";
    }
}

