/*
 * Decompiled with CFR 0.152.
 */
package nl.siegmann.epublib.epub;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import nl.siegmann.epublib.domain.Book;
import nl.siegmann.epublib.domain.CreatorContributor;
import nl.siegmann.epublib.domain.Date;
import nl.siegmann.epublib.domain.Identifier;
import nl.siegmann.epublib.domain.Relator;
import nl.siegmann.epublib.epub.PackageDocumentBase;
import nl.siegmann.epublib.util.StringUtil;
import org.xmlpull.v1.XmlSerializer;

public class Epub2PackageDocumentMetadataWriter
extends PackageDocumentBase {
    public static void writeMetaData(Book book, XmlSerializer serializer) throws IllegalArgumentException, IllegalStateException, IOException {
        serializer.startTag("http://www.idpf.org/2007/opf", "metadata");
        serializer.setPrefix("dc", "http://purl.org/dc/elements/1.1/");
        serializer.setPrefix("opf", "http://www.idpf.org/2007/opf");
        Epub2PackageDocumentMetadataWriter.writeIdentifiers(book.getMetadata().getIdentifiers(), serializer);
        Epub2PackageDocumentMetadataWriter.writeSimpleMetdataElements("title", book.getMetadata().getTitles(), serializer);
        Epub2PackageDocumentMetadataWriter.writeSimpleMetdataElements("subject", book.getMetadata().getSubjects(), serializer);
        Epub2PackageDocumentMetadataWriter.writeSimpleMetdataElements("description", book.getMetadata().getDescriptions(), serializer);
        Epub2PackageDocumentMetadataWriter.writeSimpleMetdataElements("publisher", book.getMetadata().getPublishers(), serializer);
        Epub2PackageDocumentMetadataWriter.writeSimpleMetdataElements("type", book.getMetadata().getTypes(), serializer);
        Epub2PackageDocumentMetadataWriter.writeSimpleMetdataElements("rights", book.getMetadata().getRights(), serializer);
        for (CreatorContributor creatorContributor : book.getMetadata().getAuthors()) {
            serializer.startTag("http://purl.org/dc/elements/1.1/", "creator");
            serializer.attribute("http://www.idpf.org/2007/opf", "role", Relator.AUTHOR.getCode());
            serializer.attribute("http://www.idpf.org/2007/opf", "file-as", creatorContributor.getLastname() + ", " + creatorContributor.getFirstname());
            serializer.text(creatorContributor.getFirstname() + " " + creatorContributor.getLastname());
            serializer.endTag("http://purl.org/dc/elements/1.1/", "creator");
        }
        for (CreatorContributor creatorContributor : book.getMetadata().getContributors()) {
            serializer.startTag("http://purl.org/dc/elements/1.1/", "contributor");
            serializer.attribute("http://www.idpf.org/2007/opf", "role", creatorContributor.getRelators().get(0).getCode());
            serializer.attribute("http://www.idpf.org/2007/opf", "file-as", creatorContributor.getLastname() + ", " + creatorContributor.getFirstname());
            serializer.text(creatorContributor.getFirstname() + " " + creatorContributor.getLastname());
            serializer.endTag("http://purl.org/dc/elements/1.1/", "contributor");
        }
        for (Date date : book.getMetadata().getDates()) {
            serializer.startTag("http://purl.org/dc/elements/1.1/", "date");
            if (date.getEvent() != null) {
                serializer.attribute("http://www.idpf.org/2007/opf", "event", date.getEvent().toString());
            }
            serializer.text(date.getValue());
            serializer.endTag("http://purl.org/dc/elements/1.1/", "date");
        }
        if (StringUtil.isNotBlank(book.getMetadata().getLanguage())) {
            serializer.startTag("http://purl.org/dc/elements/1.1/", "language");
            serializer.text(book.getMetadata().getLanguage());
            serializer.endTag("http://purl.org/dc/elements/1.1/", "language");
        }
        if (book.getMetadata().getOtherProperties() != null) {
            for (Map.Entry entry : book.getMetadata().getOtherProperties().entrySet()) {
                serializer.startTag(((QName)entry.getKey()).getNamespaceURI(), ((QName)entry.getKey()).getLocalPart());
                serializer.text((String)entry.getValue());
                serializer.endTag(((QName)entry.getKey()).getNamespaceURI(), ((QName)entry.getKey()).getLocalPart());
            }
        }
        if (book.getCoverImage() != null) {
            serializer.startTag("http://www.idpf.org/2007/opf", "meta");
            serializer.attribute("", "name", "cover");
            serializer.attribute("", "content", book.getCoverImage().getId());
            serializer.endTag("http://www.idpf.org/2007/opf", "meta");
        }
        serializer.startTag("http://www.idpf.org/2007/opf", "meta");
        serializer.attribute("", "name", "generator");
        serializer.attribute("", "content", "EPUBLib version 3.0");
        serializer.endTag("http://www.idpf.org/2007/opf", "meta");
        serializer.endTag("http://www.idpf.org/2007/opf", "metadata");
    }

    private static void writeSimpleMetdataElements(String tagName, List<String> values, XmlSerializer serializer) throws IllegalArgumentException, IllegalStateException, IOException {
        for (String value : values) {
            if (StringUtil.isBlank(value)) continue;
            serializer.startTag("http://purl.org/dc/elements/1.1/", tagName);
            serializer.text(value);
            serializer.endTag("http://purl.org/dc/elements/1.1/", tagName);
        }
    }

    private static void writeIdentifiers(List<Identifier> identifiers, XmlSerializer serializer) throws IllegalArgumentException, IllegalStateException, IOException {
        Identifier bookIdIdentifier = Identifier.getBookIdIdentifier(identifiers);
        if (bookIdIdentifier == null) {
            return;
        }
        serializer.startTag("http://purl.org/dc/elements/1.1/", "identifier");
        serializer.attribute("", "id", "BookId");
        serializer.attribute("http://www.idpf.org/2007/opf", "scheme", bookIdIdentifier.getScheme());
        serializer.text(bookIdIdentifier.getValue());
        serializer.endTag("http://purl.org/dc/elements/1.1/", "identifier");
        for (Identifier identifier : identifiers.subList(1, identifiers.size())) {
            if (identifier == bookIdIdentifier) continue;
            serializer.startTag("http://purl.org/dc/elements/1.1/", "identifier");
            serializer.attribute("http://www.idpf.org/2007/opf", "scheme", identifier.getScheme());
            serializer.text(identifier.getValue());
            serializer.endTag("http://purl.org/dc/elements/1.1/", "identifier");
        }
    }
}

