/*
 * Decompiled with CFR 0.152.
 */
package nl.siegmann.epublib.domain;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import nl.siegmann.epublib.domain.MediaType;
import nl.siegmann.epublib.service.MediatypeService;
import nl.siegmann.epublib.util.IOUtil;
import nl.siegmann.epublib.util.StringUtil;
import nl.siegmann.epublib.util.commons.io.XmlStreamReader;

public class Resource
implements Serializable {
    private static final long serialVersionUID = 1043946707835004037L;
    private String id;
    private String title;
    private String href;
    protected String originalHref;
    private String tocHref;
    private MediaType mediaType;
    private String inputEncoding = "UTF-8";
    protected byte[] data;

    public Resource(String href) {
        this(null, new byte[0], href, MediatypeService.determineMediaType(href));
    }

    public Resource(byte[] data, MediaType mediaType) {
        this(null, data, null, mediaType);
    }

    public Resource(byte[] data, String href) {
        this(null, data, href, MediatypeService.determineMediaType(href), "UTF-8");
    }

    public Resource(Reader in, String href) throws IOException {
        this(null, IOUtil.toByteArray(in, "UTF-8"), href, MediatypeService.determineMediaType(href), "UTF-8");
    }

    public Resource(InputStream in, String href) throws IOException {
        this(null, IOUtil.toByteArray(in), href, MediatypeService.determineMediaType(href));
    }

    public Resource(InputStream in, String href, String tocHref) throws IOException {
        this(null, IOUtil.toByteArray(in), href, MediatypeService.determineMediaType(href));
        this.tocHref = tocHref;
    }

    public Resource(String id, byte[] data, String href, MediaType mediaType) {
        this(id, data, href, mediaType, "UTF-8");
    }

    public Resource(String id, byte[] data, String href, MediaType mediaType, String inputEncoding) {
        this.id = id;
        this.href = href;
        this.originalHref = href;
        this.tocHref = href;
        this.mediaType = mediaType;
        this.inputEncoding = inputEncoding;
        this.data = data;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.getData());
    }

    public byte[] getData() throws IOException {
        return this.data;
    }

    public void close() {
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public long getSize() {
        return this.data.length;
    }

    public String getTitle() {
        return this.title;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getInputEncoding() {
        return this.inputEncoding;
    }

    public void setInputEncoding(String encoding) {
        this.inputEncoding = encoding;
    }

    public Reader getReader() throws IOException {
        return new XmlStreamReader((InputStream)new ByteArrayInputStream(this.getData()), this.getInputEncoding());
    }

    public int hashCode() {
        return this.href.hashCode();
    }

    public boolean equals(Object resourceObject) {
        if (!(resourceObject instanceof Resource)) {
            return false;
        }
        return this.href.equals(((Resource)resourceObject).getHref());
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String toString() {
        return StringUtil.toString("id", this.id, "title", this.title, "encoding", this.inputEncoding, "mediaType", this.mediaType, "href", this.href, "size", this.data == null ? 0 : this.data.length);
    }

    public String getTocHref() {
        return this.tocHref;
    }

    public void setTocHref(String tocHref) {
        this.tocHref = tocHref;
    }

    public String getOriginalHref() {
        return this.originalHref;
    }
}

