/*
 * Decompiled with CFR 0.152.
 */
package nl.siegmann.epublib.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import nl.siegmann.epublib.domain.CreatorContributor;
import nl.siegmann.epublib.domain.Date;
import nl.siegmann.epublib.domain.Identifier;
import nl.siegmann.epublib.domain.Relator;
import nl.siegmann.epublib.service.MediatypeService;
import nl.siegmann.epublib.util.StringUtil;

public class Metadata
implements Serializable {
    private static final long serialVersionUID = -2437262888962149444L;
    public static final String DEFAULT_LANGUAGE = "en";
    private boolean autoGeneratedId = true;
    private List<CreatorContributor> contributors = new ArrayList<CreatorContributor>();
    private List<CreatorContributor> creators = new ArrayList<CreatorContributor>();
    private List<Date> dates = new ArrayList<Date>();
    private String language = "en";
    private Map<QName, String> otherProperties = new HashMap<QName, String>();
    private List<String> rights = new ArrayList<String>();
    private List<String> titles = new ArrayList<String>();
    private List<Identifier> identifiers = new ArrayList<Identifier>();
    private List<String> subjects = new ArrayList<String>();
    private String format = MediatypeService.EPUB.getName();
    private List<String> types = new ArrayList<String>();
    private List<String> descriptions = new ArrayList<String>();
    private List<String> publishers = new ArrayList<String>();
    private Map<String, String> metaAttributes = new HashMap<String, String>();
    private List<String> coverages = new ArrayList<String>();
    private List<String> relations = new ArrayList<String>();
    private List<String> sources = new ArrayList<String>();

    public Metadata() {
        this.identifiers.add(new Identifier());
        this.autoGeneratedId = true;
    }

    public boolean isAutoGeneratedId() {
        return this.autoGeneratedId;
    }

    public Map<QName, String> getOtherProperties() {
        return this.otherProperties;
    }

    public void setOtherProperties(Map<QName, String> otherProperties) {
        this.otherProperties = otherProperties;
    }

    public Date addDate(Date date) {
        this.dates.add(date);
        return date;
    }

    public List<Date> getDates() {
        return this.dates;
    }

    public void setDates(List<Date> dates) {
        this.dates = dates;
    }

    public CreatorContributor addContributor(CreatorContributor contributor) {
        this.contributors.add(contributor);
        return contributor;
    }

    public List<CreatorContributor> getContributors() {
        return this.contributors;
    }

    public void setContributors(List<CreatorContributor> contributors) {
        this.contributors = contributors;
    }

    public CreatorContributor addCreator(CreatorContributor creator) {
        this.creators.add(creator);
        return creator;
    }

    public List<CreatorContributor> getCreators() {
        return this.creators;
    }

    public void setCreators(List<CreatorContributor> creators) {
        this.creators = creators;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public List<String> getSubjects() {
        return this.subjects;
    }

    public void setSubjects(List<String> subjects) {
        this.subjects = subjects;
    }

    public void setRights(List<String> rights) {
        this.rights = rights;
    }

    public List<String> getRights() {
        return this.rights;
    }

    public String getFirstTitle() {
        if (this.titles == null || this.titles.isEmpty()) {
            return "";
        }
        for (String title : this.titles) {
            if (!StringUtil.isNotBlank(title)) continue;
            return title;
        }
        return "";
    }

    public String addTitle(String title) {
        this.titles.add(title);
        return title;
    }

    public void setTitles(List<String> titles) {
        this.titles = titles;
    }

    public List<String> getTitles() {
        return this.titles;
    }

    public String addPublisher(String publisher) {
        this.publishers.add(publisher);
        return publisher;
    }

    public void setPublishers(List<String> publishers) {
        this.publishers = publishers;
    }

    public List<String> getPublishers() {
        return this.publishers;
    }

    public String addDescription(String description) {
        this.descriptions.add(description);
        return description;
    }

    public void setDescriptions(List<String> descriptions) {
        this.descriptions = descriptions;
    }

    public List<String> getDescriptions() {
        return this.descriptions;
    }

    public Identifier addIdentifier(Identifier identifier) {
        if (this.autoGeneratedId && !this.identifiers.isEmpty()) {
            this.identifiers.set(0, identifier);
        } else {
            this.identifiers.add(identifier);
        }
        this.autoGeneratedId = false;
        return identifier;
    }

    public void setIdentifiers(List<Identifier> identifiers) {
        this.identifiers = identifiers;
        this.autoGeneratedId = false;
    }

    public List<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public String addType(String type) {
        this.types.add(type);
        return type;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public void setTypes(List<String> types) {
        this.types = types;
    }

    public String getMetaAttribute(String name) {
        return this.metaAttributes.get(name);
    }

    public void setMetaAttributes(Map<String, String> metaAttributes) {
        this.metaAttributes = metaAttributes;
    }

    public List<CreatorContributor> getAuthors() {
        ArrayList<CreatorContributor> authors = new ArrayList<CreatorContributor>();
        for (CreatorContributor c : this.creators) {
            if (!c.getRelators().contains((Object)Relator.AUTHOR)) continue;
            authors.add(c);
        }
        for (CreatorContributor c : this.contributors) {
            if (!c.getRelators().contains((Object)Relator.AUTHOR)) continue;
            authors.add(c);
        }
        return authors;
    }

    public List<String> getCoverages() {
        return this.coverages;
    }

    public void setCoverages(List<String> coverages) {
        this.coverages = coverages;
    }

    public List<String> getRelations() {
        return this.relations;
    }

    public void setRelations(List<String> relations) {
        this.relations = relations;
    }

    public List<String> getSources() {
        return this.sources;
    }

    public void setSources(List<String> sources) {
        this.sources = sources;
    }
}

