/*
 * Decompiled with CFR 0.152.
 */
package nl.siegmann.epublib.domain;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import nl.siegmann.epublib.domain.Resource;
import nl.siegmann.epublib.domain.ResourceInputStream;
import nl.siegmann.epublib.service.MediatypeService;
import nl.siegmann.epublib.util.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyResource
extends Resource {
    private static final long serialVersionUID = 5089400472352002866L;
    private String filename;
    private long cachedSize;
    private static final Logger LOG = LoggerFactory.getLogger(LazyResource.class);

    public LazyResource(String filename, long size, String href) {
        super(null, null, href, MediatypeService.determineMediaType(href));
        this.filename = filename;
        this.cachedSize = size;
    }

    public LazyResource(InputStream in, String filename, int length, String href) throws IOException {
        super(null, IOUtil.toByteArray(in, length), href, MediatypeService.determineMediaType(href));
        this.filename = filename;
        this.cachedSize = length;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.isInitialized()) {
            return new ByteArrayInputStream(this.getData());
        }
        return this.getResourceStream();
    }

    public void initialize() throws IOException {
        this.getData();
    }

    @Override
    public byte[] getData() throws IOException {
        if (this.data == null) {
            LOG.debug("Initializing lazy resource " + this.filename + "#" + this.getHref());
            InputStream in = this.getResourceStream();
            byte[] readData = IOUtil.toByteArray(in, (int)this.cachedSize);
            if (readData == null) {
                throw new IOException("Could not load the contents of entry " + this.getHref() + " from epub file " + this.filename);
            }
            this.data = readData;
            in.close();
        }
        return this.data;
    }

    private InputStream getResourceStream() throws FileNotFoundException, IOException {
        ZipFile zipFile = new ZipFile(this.filename);
        ZipEntry zipEntry = zipFile.getEntry(this.originalHref);
        if (zipEntry == null) {
            zipFile.close();
            throw new IllegalStateException("Cannot find entry " + this.originalHref + " in epub file " + this.filename);
        }
        return new ResourceInputStream(zipFile.getInputStream(zipEntry), zipFile);
    }

    @Override
    public void close() {
        if (this.filename != null) {
            this.data = null;
        }
    }

    public boolean isInitialized() {
        return this.data != null;
    }

    @Override
    public long getSize() {
        if (this.data != null) {
            return this.data.length;
        }
        return this.cachedSize;
    }
}

