/*
 * Decompiled with CFR 0.152.
 */
package nl.siegmann.epublib.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import nl.siegmann.epublib.domain.Relator;
import nl.siegmann.epublib.util.StringUtil;

public class CreatorContributor
implements Serializable {
    private static final long serialVersionUID = 6663408501416574200L;
    private String firstname;
    private String lastname;
    private ArrayList<Relator> relators = new ArrayList();

    public CreatorContributor(String singleName) {
        this("", singleName);
    }

    public CreatorContributor(String firstname, String lastname) {
        this(firstname, lastname, "author");
    }

    public CreatorContributor(String firstname, String lastname, String roleName) {
        this.firstname = firstname;
        this.lastname = lastname;
        this.addRoleByName(roleName);
    }

    public CreatorContributor(String firstname, String lastname, List<String> roleNames) {
        this.firstname = firstname;
        this.lastname = lastname;
        for (String roleName : roleNames) {
            this.addRoleByName(roleName);
        }
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public String getLastname() {
        return this.lastname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public String toString() {
        return this.lastname + ", " + this.firstname;
    }

    public int hashCode() {
        return StringUtil.hashCode(this.firstname, this.lastname);
    }

    public boolean equals(Object authorObject) {
        if (!(authorObject instanceof CreatorContributor)) {
            return false;
        }
        CreatorContributor other = (CreatorContributor)authorObject;
        return StringUtil.equals(this.firstname, other.firstname) && StringUtil.equals(this.lastname, other.lastname);
    }

    public Relator addRoleByCode(String code) {
        Relator result = Relator.byCode(code);
        if (result == null) {
            result = Relator.AUTHOR;
        }
        this.relators.add(result);
        return result;
    }

    public Relator addRoleByName(String name) {
        Relator result = Relator.byName(name);
        if (result == null) {
            result = Relator.AUTHOR;
        }
        this.relators.add(result);
        return result;
    }

    public List<Relator> getRelators() {
        return this.relators;
    }

    public void setRelators(ArrayList<Relator> relators) {
        this.relators = relators;
    }
}

