/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto;

import java.io.IOException;
import jodd.lagarto.LagartoException;
import jodd.lagarto.Scanner;
import jodd.lagarto.Tag;
import jodd.lagarto.TagType;
import jodd.lagarto.TagUtil;
import jodd.util.ArraysUtil;
import jodd.util.HtmlEncoder;

class ParsedTag
implements Tag {
    private static final char[] ATTR_NAME_ID = new char[]{'i', 'd'};
    private boolean caseSensitive;
    private boolean rawTag;
    private CharSequence name;
    private int idNdx;
    private TagType type;
    private int attributesCount;
    private CharSequence[] attrNames = new CharSequence[10];
    private CharSequence[] attrValues = new CharSequence[10];
    private int tagStartIndex;
    private int tagLength;
    private String position;
    private int deepLevel;
    private boolean modified;

    ParsedTag() {
    }

    public void init(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void start(int startIndex) {
        this.tagStartIndex = startIndex;
        this.name = null;
        this.idNdx = -1;
        this.attributesCount = 0;
        this.tagLength = 0;
        this.modified = false;
        this.type = TagType.START;
        this.rawTag = false;
    }

    void end(int endIndex) {
        this.tagLength = endIndex - this.tagStartIndex;
        this.modified = false;
    }

    void increaseDeepLevel() {
        ++this.deepLevel;
    }

    void decreaseDeepLevel() {
        --this.deepLevel;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isRawTag() {
        return this.rawTag;
    }

    public void setRawTag(boolean isRawTag) {
        this.rawTag = isRawTag;
    }

    public CharSequence getName() {
        return this.name;
    }

    public CharSequence getId() {
        if (this.idNdx == -1) {
            return null;
        }
        return this.attrValues[this.idNdx];
    }

    public TagType getType() {
        return this.type;
    }

    public int getDeepLevel() {
        return this.deepLevel;
    }

    public int getAttributeCount() {
        return this.attributesCount;
    }

    public CharSequence getAttributeName(int index) {
        if (index >= this.attributesCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.attrNames[index];
    }

    public CharSequence getAttributeValue(int index) {
        if (index >= this.attributesCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.attrValues[index];
    }

    public CharSequence getAttributeValue(CharSequence name) {
        for (int i = 0; i < this.attributesCount; ++i) {
            CharSequence current = this.attrNames[i];
            if (!(this.caseSensitive ? current.equals(name) : TagUtil.equalsIgnoreCase(current, name))) continue;
            return this.attrValues[i];
        }
        return null;
    }

    public CharSequence getAttributeValue(char[] name) {
        for (int i = 0; i < this.attributesCount; ++i) {
            CharSequence current = this.attrNames[i];
            if (!(this.caseSensitive ? TagUtil.equals(current, name) : TagUtil.equalsIgnoreCase(current, name))) continue;
            return this.attrValues[i];
        }
        return null;
    }

    public int getAttributeIndex(CharSequence name) {
        for (int i = 0; i < this.attributesCount; ++i) {
            CharSequence current = this.attrNames[i];
            if (!(this.caseSensitive ? current.equals(name) : TagUtil.equalsIgnoreCase(current, name))) continue;
            return i;
        }
        return -1;
    }

    public int getAttributeIndex(char[] name) {
        for (int i = 0; i < this.attributesCount; ++i) {
            CharSequence current = this.attrNames[i];
            if (!(this.caseSensitive ? TagUtil.equals(current, name) : TagUtil.equalsIgnoreCase(current, name))) continue;
            return i;
        }
        return -1;
    }

    public boolean hasAttribute(CharSequence name) {
        return this.getAttributeIndex(name) > -1;
    }

    public int getTagPosition() {
        return this.tagStartIndex;
    }

    public int getTagLength() {
        return this.tagLength;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(Scanner.Position position) {
        this.position = position.toString();
    }

    public void setName(CharSequence tagName) {
        this.name = tagName;
        this.modified = true;
    }

    public void setType(TagType type) {
        this.type = type;
        this.modified = true;
    }

    public void addAttribute(CharSequence name, CharSequence value) {
        this.ensureLength();
        this.attrNames[this.attributesCount] = name;
        this.setAttrVal(this.attributesCount, name, value);
        ++this.attributesCount;
        this.modified = true;
    }

    public void setAttribute(CharSequence name, CharSequence value) {
        int index = this.getAttributeIndex(name);
        if (index == -1) {
            this.addAttribute(name, value);
        } else {
            this.setAttrVal(index, name, value);
        }
        this.modified = true;
    }

    public void setAttributeValue(int index, CharSequence value) {
        if (index >= this.attributesCount) {
            throw new IndexOutOfBoundsException();
        }
        this.setAttrVal(index, value);
        this.modified = true;
    }

    public void setAttributeValue(CharSequence name, CharSequence value) {
        int index = this.getAttributeIndex(name);
        if (index != -1) {
            this.setAttrVal(index, name, value);
            this.modified = true;
        }
    }

    public void setAttributeName(int index, CharSequence name) {
        if (index >= this.attributesCount) {
            throw new IndexOutOfBoundsException();
        }
        this.attrNames[index] = name;
        this.modified = true;
    }

    public void removeAttribute(int index) {
        if (index >= this.attributesCount) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.attrNames, index + 1, this.attrNames, index, this.attributesCount - index);
        System.arraycopy(this.attrValues, index + 1, this.attrValues, index, this.attributesCount - index);
        --this.attributesCount;
        this.modified = true;
    }

    public void removeAttribute(CharSequence name) {
        int index = this.getAttributeIndex(name);
        if (index != -1) {
            this.removeAttribute(index);
        }
        this.modified = true;
    }

    public void removeAttributes() {
        this.attributesCount = 0;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean nameEquals(char[] chars) {
        return this.caseSensitive ? TagUtil.equals(this.name, chars) : TagUtil.equalsIgnoreCase(this.name, chars);
    }

    public boolean nameEquals(CharSequence charSequence) {
        return this.caseSensitive ? TagUtil.equals(this.name, charSequence) : TagUtil.equalsIgnoreCase(this.name, charSequence);
    }

    public boolean matchTagName(char[] tagNameLowercase) {
        return TagUtil.equalsToLowercase(this.name, tagNameLowercase);
    }

    public boolean matchTagNamePrefix(char[] tagNamePrefixLowercase) {
        return TagUtil.startsWithLowercase(this.name, tagNamePrefixLowercase);
    }

    private void ensureLength() {
        if (this.attributesCount + 1 >= this.attrNames.length) {
            this.attrNames = ArraysUtil.resize(this.attrNames, this.attributesCount * 2);
            this.attrValues = ArraysUtil.resize(this.attrValues, this.attributesCount * 2);
        }
    }

    private void setAttrVal(int index, CharSequence name, CharSequence value) {
        if (this.idNdx == -1 && TagUtil.equalsToLowercase(name, ATTR_NAME_ID)) {
            this.idNdx = index;
        }
        this.attrValues[index] = value;
    }

    private void setAttrVal(int index, CharSequence value) {
        this.attrValues[index] = value;
    }

    private void appendTo(Appendable out) {
        try {
            out.append(this.type.getStartString());
            out.append(this.name);
            if (this.attributesCount > 0) {
                for (int i = 0; i < this.attributesCount; ++i) {
                    out.append(' ');
                    out.append(this.attrNames[i]);
                    CharSequence value = this.attrValues[i];
                    if (value == null) continue;
                    out.append('=').append('\"');
                    out.append(HtmlEncoder.attributeDoubleQuoted(value));
                    out.append('\"');
                }
            }
            out.append(this.type.getEndString());
        }
        catch (IOException ioex) {
            throw new LagartoException(ioex);
        }
    }

    public void writeTo(Appendable out) throws IOException {
        this.appendTo(out);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendTo(sb);
        return sb.toString();
    }
}

