/**
 * Copyright (C) 2013 FIspace (info@fispace.eu)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package eu.fispace.api;

import eu.agrosense.api.platform.PostCapability;
import eu.fispace.api.pi.ShipmentMessage;
import javax.ws.rs.core.Response;

/**
 *
 * @author Timon Veenstra <timon@agrosense.eu>
 */
public class DomainRetail {
    public static final String DOMAIN = "retail";
    //PushShipmentMessage
    public static final PostCapability<ShipmentMessage, Response> RECEIVE_SHIPMENT_MESSAGE = (PostCapability<ShipmentMessage, Response>)new PostCapability<ShipmentMessage, Response>()
            .withDomain(DOMAIN)
            .withName("push shipment message")
            .withResource("PushShipmentMessage")
            .withRequestMessageClass(ShipmentMessage.class);          
}
