/**
 * Copyright (C) 2013 FIspace (info@fispace.eu)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package eu.fispace.api;

import eu.limetri.ygg.api.CapabilityType;
import eu.limetri.ygg.api.CapabilityTypeRegistration;
import eu.limetri.ygg.api.Messages;
import eu.limetri.ygg.api.ResourceAvailableNotification;
import eu.limetri.ygg.api.TextNotificationMessage;

/**
 *
 * @author Timon Veenstra <timon@limetri.eu>
 */
public class DomainCommon {
    public static final String DOMAIN = "common";
    public static final String SCHEMA = "classpath:/schema/domain/common/CommonMessages.xsd";
    
    // as long as common objects do not extend the ygg objects we can use the ygg context path
    // otherwise switch to package name of generated common classes
    public static final String CONTEXT_PATH = "eu.limetri.ygg.api";
    
    /**
     * Capability to receive text notifications
     * 
     * @since 0.7.0
     * @see TextNotificationMessage
     */
    @CapabilityTypeRegistration
    public static final CapabilityType RECEIVE_TEXT_NOTIFICATION = new CapabilityType()
            .withName("receive text notification")
            .withSchemaLocation(SCHEMA)
            .withContextPath(CONTEXT_PATH)
            .withRequestMessageType(TextNotificationMessage.class.getSimpleName())
            .withResponseMessageType(Messages.Untyped.class.getSimpleName());   
    
}
