/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.svm;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import eu.fbk.utils.svm.LabelledVector;
import eu.fbk.utils.svm.Vector;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class FeatureStats
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Ordering<FeatureStats> FSCORE_COMPARATOR = new Ordering<FeatureStats>(){

        public int compare(FeatureStats first, FeatureStats second) {
            return -Float.compare(first.getFScore(), second.getFScore());
        }
    };
    private final String name;
    private final int[] counts;
    private final int[] countsNonZero;
    private final float[] mins;
    private final float[] maxs;
    private final float[] means;
    private final float[] squareMeans;

    private FeatureStats(String name, int[] counts, int[] countsNonZero, float[] mins, float[] maxs, float[] means, float[] squareMeans) {
        this.name = name;
        this.counts = counts;
        this.countsNonZero = countsNonZero;
        this.mins = mins;
        this.maxs = maxs;
        this.means = means;
        this.squareMeans = squareMeans;
    }

    public static Map<String, FeatureStats> forVectors(int numLabels, Iterable<? extends Vector> vectors, @Nullable Predicate<String> selector) {
        LinkedHashMap builders = Maps.newLinkedHashMap();
        for (Vector vector : vectors) {
            for (String feature : vector.getFeatures()) {
                if (feature.length() > 0 && feature.charAt(0) == '_' || selector != null && !selector.apply((Object)feature) || builders.containsKey(feature)) continue;
                builders.put(feature, FeatureStats.builder(numLabels));
            }
        }
        int[] counts = new int[numLabels];
        for (Vector vector : vectors) {
            int label;
            int size = vector.size();
            int n = label = vector instanceof LabelledVector ? ((LabelledVector)vector).getLabel() : 0;
            counts[n] = counts[n] + 1;
            for (int i = 0; i < size; ++i) {
                String feature = vector.getFeature(i);
                Builder builder = (Builder)builders.get(feature);
                if (builder == null) continue;
                builder.add(vector.getValue(i), label);
            }
        }
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        for (String feature : Ordering.natural().sortedCopy(builders.keySet())) {
            linkedHashMap.put(feature, ((Builder)builders.get(feature)).build(feature, counts));
        }
        return linkedHashMap;
    }

    public String getName() {
        return this.name;
    }

    public int getCount() {
        int count = 0;
        for (int i = 0; i < this.counts.length; ++i) {
            count += this.counts[i];
        }
        return count;
    }

    public int getCount(int label) {
        return this.counts[label];
    }

    public int getCountNonZero() {
        int countNonZero = 0;
        for (int i = 0; i < this.countsNonZero.length; ++i) {
            countNonZero += this.countsNonZero[i];
        }
        return countNonZero;
    }

    public int getCountNonZero(int label) {
        return this.countsNonZero[label];
    }

    public float getMin() {
        float result = Float.MAX_VALUE;
        for (int i = 0; i < this.mins.length; ++i) {
            result = Math.min(result, this.mins[i]);
        }
        return result;
    }

    public float getMin(int label) {
        return this.mins[label];
    }

    public float getMax() {
        float result = Float.MIN_VALUE;
        for (int i = 0; i < this.maxs.length; ++i) {
            result = Math.max(result, this.maxs[i]);
        }
        return result;
    }

    public float getMax(int label) {
        return this.maxs[label];
    }

    public float getMean() {
        double sum = 0.0;
        int count = 0;
        for (int i = 0; i < this.means.length; ++i) {
            sum += (double)(this.means[i] * (float)this.counts[i]);
            count += this.counts[i];
        }
        return (float)(sum / (double)count);
    }

    public float getMean(int label) {
        return this.means[label];
    }

    public float getVariance() {
        double count = 0.0;
        double sum = 0.0;
        double squareSum = 0.0;
        for (int i = 0; i < this.means.length; ++i) {
            sum += (double)(this.means[i] * (float)this.counts[i]);
            squareSum += (double)(this.squareMeans[i] * (float)this.counts[i]);
            count += (double)this.counts[i];
        }
        double mean = sum / count;
        double squareMean = squareSum / count;
        return (float)(count / (count - 1.0) * (squareMean - mean * mean));
    }

    public float getVariance(int label) {
        double mean = this.means[label];
        double squareMean = this.squareMeans[label];
        double count = this.counts[label];
        return (float)(count / (count - 1.0) * (squareMean - mean * mean));
    }

    public float getFScore() {
        double num = 0.0;
        double den = 0.0;
        double mean = this.getMean();
        for (int i = 0; i < this.counts.length; ++i) {
            num += Math.pow((double)this.getMean(i) - mean, 2.0);
            den += (double)this.getVariance(i);
        }
        return den == 0.0 ? Float.NaN : (float)(num / den);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FeatureStats)) {
            return false;
        }
        FeatureStats other = (FeatureStats)object;
        return this.name.equals(other.name) && Arrays.equals(this.counts, other.counts) && Arrays.equals(this.countsNonZero, other.countsNonZero) && Arrays.equals(this.mins, other.mins) && Arrays.equals(this.maxs, other.maxs) && Arrays.equals(this.means, other.means) && Arrays.equals(this.squareMeans, other.squareMeans);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, Arrays.hashCode(this.counts), Arrays.hashCode(this.countsNonZero), Arrays.hashCode(this.mins), Arrays.hashCode(this.maxs), Arrays.hashCode(this.means), Arrays.hashCode(this.squareMeans)});
    }

    public <T extends Appendable> T toString(T out) throws IOException {
        out.append(String.format("%-20s", this.name));
        this.toStringHelper(out, "count!=0");
        out.append(", ");
        this.toStringHelper(out, "min");
        out.append(", ");
        this.toStringHelper(out, "avg");
        out.append(", ");
        this.toStringHelper(out, "max");
        out.append(", ");
        this.toStringHelper(out, "std");
        out.append(", fscore ").append(String.format("%.3f", Float.valueOf(this.getFScore())));
        return out;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        try {
            this.toString(builder);
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
        return builder.toString();
    }

    public static String toString(Iterable<FeatureStats> fss, int maxFeaturesDisplayed) {
        StringBuilder builder = new StringBuilder();
        ArrayList uselessFeatures = Lists.newArrayList();
        int i = 0;
        for (FeatureStats fs : FSCORE_COMPARATOR.immutableSortedCopy(fss)) {
            if (++i <= maxFeaturesDisplayed) {
                builder.append(fs).append("\n");
            }
            if (fs.getMin() != fs.getMax()) continue;
            uselessFeatures.add(fs.getName());
        }
        if (i > maxFeaturesDisplayed) {
            builder.append("... [truncated] ...\n");
        }
        if (!uselessFeatures.isEmpty()) {
            builder.append("USELESS FEATURES: ");
            Joiner.on((String)", ").appendTo(builder, (Iterable)uselessFeatures);
            builder.append("\n");
        }
        return builder.toString();
    }

    private void toStringHelper(Appendable out, String field) throws IOException {
        out.append(field).append(' ');
        if (field == "count") {
            out.append(Integer.toString(this.getCount()));
        } else if (field == "count!=0") {
            out.append(Integer.toString(this.getCountNonZero()));
        } else if (field == "min") {
            out.append(String.format("%.3f", Float.valueOf(this.getMin())));
        } else if (field == "avg") {
            out.append(String.format("%.3f", Float.valueOf(this.getMean())));
        } else if (field == "max") {
            out.append(String.format("%.3f", Float.valueOf(this.getMax())));
        } else if (field == "std") {
            out.append(String.format("%.3f", Math.sqrt(this.getVariance())));
        }
        if (this.counts.length > 1) {
            out.append(" (");
            for (int i = 0; i < this.counts.length; ++i) {
                if (i > 0) {
                    out.append(' ');
                }
                out.append(Integer.toString(i));
                out.append(':');
                if (field == "count") {
                    out.append(Integer.toString(this.counts[i]));
                    continue;
                }
                if (field == "count!=0") {
                    out.append(Integer.toString(this.countsNonZero[i]));
                    continue;
                }
                if (field == "min") {
                    out.append(String.format("%.3f", Float.valueOf(this.getMin(i))));
                    continue;
                }
                if (field == "avg") {
                    out.append(String.format("%.3f", Float.valueOf(this.getMean(i))));
                    continue;
                }
                if (field == "max") {
                    out.append(String.format("%.3f", Float.valueOf(this.getMax(i))));
                    continue;
                }
                if (field != "std") continue;
                out.append(String.format("%.3f", Math.sqrt(this.getVariance(i))));
            }
            out.append(')');
        }
    }

    public static Builder builder(int numLabels) {
        return new Builder(numLabels);
    }

    public static final class Builder {
        private final int[] countsNonZero;
        private final float[] mins;
        private final float[] maxs;
        private final float[] sums;
        private final float[] squareSums;

        private Builder(int numLabels) {
            this.countsNonZero = new int[numLabels];
            this.mins = new float[numLabels];
            this.maxs = new float[numLabels];
            this.sums = new float[numLabels];
            this.squareSums = new float[numLabels];
        }

        public Builder add(float value) {
            return this.add(value, 0);
        }

        public Builder add(float value, int label) {
            if (value != 0.0f) {
                int n = label;
                this.countsNonZero[n] = this.countsNonZero[n] + 1;
            }
            this.mins[label] = Math.min(this.mins[label], value);
            this.maxs[label] = Math.max(this.maxs[label], value);
            int n = label;
            this.sums[n] = this.sums[n] + value;
            int n2 = label;
            this.squareSums[n2] = this.squareSums[n2] + value * value;
            return this;
        }

        public Builder add(float value, int label, int repetitions) {
            if (value != 0.0f) {
                int n = label;
                this.countsNonZero[n] = this.countsNonZero[n] + repetitions;
            }
            this.mins[label] = Math.min(this.mins[label], value);
            this.maxs[label] = Math.max(this.maxs[label], value);
            int n = label;
            this.sums[n] = this.sums[n] + value * (float)repetitions;
            int n2 = label;
            this.squareSums[n2] = this.squareSums[n2] + value * value * (float)repetitions;
            return this;
        }

        public FeatureStats build(String name, int ... counts) {
            Preconditions.checkArgument((counts.length == this.sums.length ? 1 : 0) != 0);
            float[] mins = (float[])this.mins.clone();
            float[] maxs = (float[])this.maxs.clone();
            float[] means = new float[this.sums.length];
            float[] squareMeans = new float[this.sums.length];
            for (int i = 0; i < this.sums.length; ++i) {
                means[i] = this.sums[i] / (float)counts[i];
                squareMeans[i] = this.squareSums[i] / (float)counts[i];
                if (counts[i] <= this.countsNonZero[i]) continue;
                mins[i] = Math.min(mins[i], 0.0f);
                maxs[i] = Math.max(maxs[i], 0.0f);
            }
            return new FeatureStats(name, (int[])counts.clone(), (int[])this.countsNonZero.clone(), mins, maxs, means, squareMeans);
        }
    }
}

