/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.svm;

import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import de.bwaldvogel.liblinear.Feature;
import de.bwaldvogel.liblinear.FeatureNode;
import de.bwaldvogel.liblinear.Linear;
import de.bwaldvogel.liblinear.Model;
import de.bwaldvogel.liblinear.Parameter;
import de.bwaldvogel.liblinear.Problem;
import de.bwaldvogel.liblinear.SolverType;
import eu.fbk.utils.core.Conversion;
import eu.fbk.utils.core.Dictionary;
import eu.fbk.utils.core.Environment;
import eu.fbk.utils.core.Hash;
import eu.fbk.utils.core.IO;
import eu.fbk.utils.eval.ConfusionMatrix;
import eu.fbk.utils.svm.LabelledVector;
import eu.fbk.utils.svm.Util;
import eu.fbk.utils.svm.Vector;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import libsvm.svm;
import libsvm.svm_model;
import libsvm.svm_node;
import libsvm.svm_parameter;
import libsvm.svm_print_interface;
import libsvm.svm_problem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Classifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(Classifier.class);
    private final Parameters parameters;
    private final String modelHash;

    private Classifier(Parameters parameters, String modelHash) {
        this.parameters = parameters;
        this.modelHash = modelHash;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public final LabelledVector predict(boolean withProbabilities, Vector vector) {
        if (!this.getParameters().getAlgorithm().supportsProbabilities()) {
            throw new IllegalArgumentException("Probabilities not supported by algorithm " + (Object)((Object)this.getParameters().getAlgorithm()));
        }
        return this.doPredict(withProbabilities, vector);
    }

    public final List<LabelledVector> predict(boolean withProbabilities, Iterable<? extends Vector> vectors) {
        if (withProbabilities && !this.getParameters().getAlgorithm().supportsProbabilities()) {
            throw new IllegalArgumentException("Probabilities not supported by algorithm " + (Object)((Object)this.getParameters().getAlgorithm()));
        }
        return this.doPredict(withProbabilities, vectors);
    }

    abstract LabelledVector doPredict(boolean var1, Vector var2);

    List<LabelledVector> doPredict(boolean withProbabilities, Iterable<? extends Vector> vectors) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Vector vector : vectors) {
            builder.add((Object)this.doPredict(withProbabilities, vector));
        }
        return builder.build();
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        Classifier other = (Classifier)object;
        return this.modelHash.equals(other.modelHash);
    }

    public final int hashCode() {
        return this.modelHash.hashCode();
    }

    public final String toString() {
        return this.parameters.getNumLabels() + "-classes " + this.getClass().getSimpleName() + ", model " + this.modelHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeTo(Path path) throws IOException {
        Path p = Util.openVFS(path, true);
        try {
            Properties properties = this.parameters.toProperties(null, null);
            try (BufferedWriter writer = Files.newBufferedWriter(p.resolve("parameters"), new OpenOption[0]);){
                properties.store(writer, "");
            }
            this.doWrite(p);
        }
        finally {
            Util.closeVFS(p);
        }
    }

    void doWrite(Path path) throws IOException {
    }

    public static Classifier readFrom(Path path) throws IOException {
        Path p = Util.openVFS(path, false);
        try {
            Properties properties = new Properties();
            try (BufferedReader reader = Files.newBufferedReader(p.resolve("parameters"));){
                properties.load(reader);
            }
            Parameters parameters = Parameters.forProperties(properties, null);
            Class<? extends Classifier> implementationClass = Classifier.implementationFor(parameters);
            if (implementationClass.equals(LibLinearClassifier.class)) {
                Classifier classifier = LibLinearClassifier.doRead(parameters, p);
                return classifier;
            }
            if (implementationClass.equals(LibSvmClassifier.class)) {
                Classifier classifier = LibSvmClassifier.doRead(parameters, p);
                return classifier;
            }
            throw new IllegalArgumentException("No suitable implementation for parameters " + parameters);
        }
        finally {
            Util.closeVFS(p);
        }
    }

    public static Classifier train(Parameters parameters, Iterable<LabelledVector> trainingSet) throws IOException {
        Preconditions.checkArgument((Iterables.size(trainingSet) > 0 ? 1 : 0) != 0, (Object)"No training examples");
        Class<? extends Classifier> implementationClass = Classifier.implementationFor(parameters);
        if (implementationClass.equals(LibLinearClassifier.class)) {
            return LibLinearClassifier.doTrain(parameters, trainingSet);
        }
        if (implementationClass.equals(LibSvmClassifier.class)) {
            return LibSvmClassifier.doTrain(parameters, trainingSet);
        }
        throw new IllegalArgumentException("No suitable implementation for parameters " + parameters);
    }

    public static Classifier train(Iterable<Parameters> parametersGrid, Iterable<LabelledVector> trainingSet, Comparator<ConfusionMatrix> comparator, int maxVectors) throws IOException {
        Preconditions.checkArgument((Iterables.size(trainingSet) > 0 ? 1 : 0) != 0, (Object)"No training examples");
        List<List<LabelledVector>> partitions = Vector.split(trainingSet, 3, maxVectors);
        ImmutableList parametersList = ImmutableList.copyOf(parametersGrid);
        HashMap map = Maps.newHashMap();
        final AtomicInteger index = new AtomicInteger(0);
        ArrayList futures = Lists.newArrayList();
        ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Environment.getPool());
        for (int i = 0; i < Environment.getCores() / 2; ++i) {
            futures.add(executor.submit((Callable)new Callable<Object>((List)parametersList, partitions, (Map)map){
                final /* synthetic */ List val$parametersList;
                final /* synthetic */ List val$partitions;
                final /* synthetic */ Map val$map;
                {
                    this.val$parametersList = list;
                    this.val$partitions = list2;
                    this.val$map = map;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object call() throws IOException {
                    int i;
                    while ((i = index.getAndIncrement()) < this.val$parametersList.size()) {
                        Parameters parameters = (Parameters)this.val$parametersList.get(i);
                        ConfusionMatrix matrix = Classifier.crossValidate(parameters, this.val$partitions);
                        Map map = this.val$map;
                        synchronized (map) {
                            this.val$map.put(matrix, parameters);
                        }
                        LOGGER.debug("Performances for parameters combination {}/{} - {}:\n{}", new Object[]{i + 1, this.val$parametersList.size(), parameters, matrix});
                    }
                    return null;
                }
            }));
        }
        Futures.getChecked((Future)Futures.allAsList((Iterable)futures), IOException.class);
        ConfusionMatrix bestMatrix = (ConfusionMatrix)Ordering.from(comparator).min(map.keySet());
        Parameters bestParameters = (Parameters)map.get(bestMatrix);
        LOGGER.debug("Best parameter combination: {}", (Object)bestParameters);
        Classifier bestClassifier = Classifier.train(bestParameters, (Iterable<LabelledVector>)Ordering.natural().immutableSortedCopy(trainingSet));
        return bestClassifier;
    }

    public static ConfusionMatrix crossValidate(Parameters parameters, Iterable<LabelledVector> trainingSet, int numPartitions) throws IOException {
        return Classifier.crossValidate(parameters, trainingSet, numPartitions, null);
    }

    public static ConfusionMatrix crossValidate(Parameters parameters, Iterable<LabelledVector> trainingSet, int numPartitions, @Nullable Map<String, Integer> results) throws IOException {
        return Classifier.crossValidate(parameters, trainingSet, numPartitions, results, Integer.MAX_VALUE);
    }

    public static ConfusionMatrix crossValidate(Parameters parameters, Iterable<LabelledVector> trainingSet, int numPartitions, int maxVectors) throws IOException {
        return Classifier.crossValidate(parameters, trainingSet, numPartitions, null, maxVectors);
    }

    public static ConfusionMatrix crossValidate(Parameters parameters, Iterable<LabelledVector> trainingSet, int numPartitions, @Nullable Map<String, Integer> results, int maxVectors) throws IOException {
        Preconditions.checkArgument((numPartitions >= 2 ? 1 : 0) != 0);
        Preconditions.checkArgument((Iterables.size(trainingSet) > 0 ? 1 : 0) != 0, (Object)"No training examples");
        return Classifier.crossValidate(parameters, Vector.split(trainingSet, numPartitions, maxVectors), results);
    }

    public static ConfusionMatrix crossValidate(Parameters parameters, Iterable<? extends Iterable<LabelledVector>> partitions) throws IOException {
        return Classifier.crossValidate(parameters, partitions, null);
    }

    public static ConfusionMatrix crossValidate(Parameters parameters, Iterable<? extends Iterable<LabelledVector>> partitions, @Nullable Map<String, Integer> results) throws IOException {
        int size = 0;
        for (Iterable<LabelledVector> iterable : partitions) {
            size += Iterables.size(iterable);
        }
        ImmutableList partitionList = ImmutableList.copyOf(partitions);
        ArrayList arrayList = Lists.newArrayList();
        ListeningExecutorService executor = size > 200000 ? MoreExecutors.newDirectExecutorService() : MoreExecutors.listeningDecorator((ExecutorService)Environment.getPool());
        int i = 0;
        while (i < partitionList.size()) {
            int index = i++;
            arrayList.add(executor.submit((Callable)new Callable<ConfusionMatrix>((List)partitionList, index, parameters, results){
                final /* synthetic */ List val$partitionList;
                final /* synthetic */ int val$index;
                final /* synthetic */ Parameters val$parameters;
                final /* synthetic */ Map val$results;
                {
                    this.val$partitionList = list;
                    this.val$index = n;
                    this.val$parameters = parameters;
                    this.val$results = map;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ConfusionMatrix call() throws IOException {
                    Iterable testSet = (Iterable)this.val$partitionList.get(this.val$index);
                    ArrayList trainingSet = Lists.newArrayList();
                    for (int j = 0; j < this.val$partitionList.size(); ++j) {
                        if (j == this.val$index) continue;
                        Iterables.addAll((Collection)trainingSet, (Iterable)((Iterable)this.val$partitionList.get(j)));
                    }
                    Classifier classifier = Classifier.train(this.val$parameters, trainingSet);
                    List<LabelledVector> predictedSet = classifier.predict(false, testSet);
                    if (this.val$results != null) {
                        for (LabelledVector predictedVector : predictedSet) {
                            String vectorID = predictedVector.getId();
                            if (vectorID == null) continue;
                            Map map = this.val$results;
                            synchronized (map) {
                                this.val$results.put(vectorID, predictedVector.getLabel());
                            }
                        }
                    }
                    return LabelledVector.evaluate(testSet, predictedSet, this.val$parameters.getNumLabels());
                }
            }));
        }
        return ConfusionMatrix.sum((Iterable)((Iterable)Futures.getChecked((Future)Futures.allAsList((Iterable)arrayList), IOException.class)));
    }

    @Nullable
    private static Class<? extends Classifier> implementationFor(Parameters parameters) {
        if (parameters.getAlgorithm().isLinear()) {
            return LibLinearClassifier.class;
        }
        if (parameters.getAlgorithm().isSVM()) {
            return LibSvmClassifier.class;
        }
        return null;
    }

    private static String computeHash(Dictionary<String> dictionary, String modelString) {
        StringBuilder builder = new StringBuilder(modelString);
        for (String feature : dictionary) {
            builder.append('\n').append(feature);
        }
        return Hash.murmur3((CharSequence[])new CharSequence[]{builder}).toString();
    }

    private static boolean testNative(String program, String successMessage) {
        try {
            Classifier.invokeNative(program, (Iterable<String>)ImmutableList.of(), true);
            LOGGER.info(successMessage);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Float> invokeNative(final String program, Iterable<String> args, boolean suppressOutput) throws IOException {
        ArrayList<String> command = new ArrayList<String>(Arrays.asList(Environment.getProperty((String)("cmd." + program.replace('-', '.')), (String)program).split("\\s+")));
        Iterables.addAll(command, args);
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        final Process process = processBuilder.start();
        try {
            String line;
            Environment.getPool().submit(new Runnable(){

                @Override
                public void run() {
                    BufferedReader in = new BufferedReader(new InputStreamReader(process.getErrorStream(), Charset.forName("UTF-8")));
                    try {
                        String line;
                        while ((line = in.readLine()) != null) {
                            LOGGER.error("[{}] {}", (Object)program, (Object)line);
                        }
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        IO.closeQuietly((Object)in);
                    }
                }
            });
            HashMap result = Maps.newHashMap();
            BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.forName("UTF-8")));
            while ((line = in.readLine()) != null) {
                if (!suppressOutput) {
                    LOGGER.debug("[{}] {}", (Object)program, (Object)line);
                }
                try {
                    int startIndex = -1;
                    int equalIndex = -1;
                    for (int i = 0; i < line.length(); ++i) {
                        char c = line.charAt(i);
                        if (equalIndex >= 0) {
                            boolean nonDigit;
                            boolean last = i == line.length() - 1;
                            boolean bl = nonDigit = c != ' ' && c != '.' && c != '-' && !Character.isDigit(c);
                            if (!last && !nonDigit) continue;
                            int endIndex = last && !nonDigit ? i + 1 : i;
                            String key = line.substring(startIndex, equalIndex).trim();
                            float value = Float.parseFloat(line.substring(equalIndex + 1, endIndex).trim());
                            result.put(key, Float.valueOf(value));
                            startIndex = -1;
                            equalIndex = -1;
                            continue;
                        }
                        if (c == '=' && i > 0 && line.charAt(i - 1) != '<' && line.charAt(i - 1) != '=') {
                            equalIndex = i;
                            continue;
                        }
                        if (c == ',') {
                            startIndex = -1;
                            continue;
                        }
                        if (startIndex >= 0) continue;
                        startIndex = i;
                    }
                }
                catch (Throwable ex) {
                    LOGGER.warn("Could not parse output line:\n" + line, ex);
                }
            }
            HashMap hashMap = result;
            return hashMap;
        }
        finally {
            process.destroy();
        }
    }

    static /* synthetic */ boolean access$100(String x0, String x1) {
        return Classifier.testNative(x0, x1);
    }

    private static class LibSvmClassifier
    extends Classifier {
        private static final Ordering<svm_node> NODE_ORDERING = new Ordering<svm_node>(){

            public int compare(svm_node left, svm_node right) {
                return left.index - right.index;
            }
        };
        private static final boolean NATIVE_LIB_AVAILABLE = Classifier.access$100("svm-train", "Using native LIBSVM tools");
        private static final int SHRINKING = 1;
        private final Dictionary<String> dictionary;
        private final svm_model model;

        private LibSvmClassifier(Parameters parameters, String modelHash, Dictionary<String> dictionary, svm_model model) {
            super(parameters, modelHash);
            this.dictionary = dictionary.freeze();
            this.model = model;
        }

        @Override
        LabelledVector doPredict(boolean withProbabilities, Vector vector) {
            svm_node[] nodes = LibSvmClassifier.encodeVector(this.dictionary, vector);
            if (withProbabilities) {
                int numLabels = this.getParameters().getNumLabels();
                double[] p = new double[numLabels];
                int label = (int)svm.svm_predict_probability((svm_model)this.model, (svm_node[])nodes, (double[])p);
                float[] probabilities = new float[numLabels];
                for (int i = 0; i < p.length; ++i) {
                    int labelIndex = this.model.label[i];
                    probabilities[labelIndex] = (float)p[i];
                }
                return vector.label(label, probabilities);
            }
            int label = (int)svm.svm_predict((svm_model)this.model, (svm_node[])nodes);
            return vector.label(label, new float[0]);
        }

        @Override
        void doWrite(Path path) throws IOException {
            this.dictionary.writeTo(path.resolve("dictionary"));
            File tmpFile = File.createTempFile("svm", ".bin");
            tmpFile.deleteOnExit();
            svm.svm_save_model((String)tmpFile.getAbsolutePath(), (svm_model)this.model);
            String modelString = com.google.common.io.Files.toString((File)tmpFile, (Charset)Charset.defaultCharset());
            tmpFile.delete();
            Files.write(path.resolve("model"), modelString.getBytes(Charsets.UTF_8), new OpenOption[0]);
        }

        static Classifier doRead(Parameters parameters, Path path) throws IOException {
            Dictionary dictionary = Dictionary.readFrom(String.class, (Path)path.resolve("dictionary"));
            String modelString = new String(Files.readAllBytes(path.resolve("model")), Charsets.UTF_8);
            svm_model model = svm.svm_load_model((BufferedReader)new BufferedReader(new StringReader(modelString)));
            String modelHash = Classifier.computeHash((Dictionary<String>)dictionary, modelString);
            return new LibSvmClassifier(parameters, modelHash, (Dictionary<String>)dictionary, model);
        }

        static Classifier doTrain(Parameters parameters, Iterable<LabelledVector> trainingSet) throws IOException {
            if (NATIVE_LIB_AVAILABLE) {
                return LibSvmClassifier.trainNative(parameters, trainingSet);
            }
            return LibSvmClassifier.trainJava(parameters, trainingSet);
        }

        private static Classifier trainJava(Parameters parameters, Iterable<LabelledVector> trainingSet) throws IOException {
            svm_parameter parameter = LibSvmClassifier.encodeParameters(parameters);
            Dictionary dictionary = Dictionary.create();
            svm_problem problem = LibSvmClassifier.encodeProblem((Dictionary<String>)dictionary, trainingSet);
            svm_model model = svm.svm_train((svm_problem)problem, (svm_parameter)parameter);
            File tmpFile = File.createTempFile("svm", ".bin");
            tmpFile.deleteOnExit();
            svm.svm_save_model((String)tmpFile.getAbsolutePath(), (svm_model)model);
            String modelString = com.google.common.io.Files.toString((File)tmpFile, (Charset)Charset.defaultCharset());
            String modelHash = Classifier.computeHash((Dictionary<String>)dictionary, modelString);
            svm_model reloadedModel = svm.svm_load_model((BufferedReader)new BufferedReader(new StringReader(modelString)));
            tmpFile.delete();
            return new LibSvmClassifier(parameters, modelHash, (Dictionary<String>)dictionary, reloadedModel);
        }

        private static Classifier trainNative(Parameters parameters, Iterable<LabelledVector> trainingSet) throws IOException {
            Preconditions.checkNotNull((Object)parameters);
            Preconditions.checkNotNull(trainingSet);
            Preconditions.checkArgument((Iterables.size(trainingSet) >= 2 ? 1 : 0) != 0);
            Dictionary dictionary = Dictionary.create();
            File trainingFile = File.createTempFile("svmdata.", ".txt");
            trainingFile.deleteOnExit();
            try (Writer writer = IO.utf8Writer((OutputStream)IO.buffer((OutputStream)IO.write((String)trainingFile.getAbsolutePath())));){
                Vector.write(trainingSet, (Dictionary<String>)dictionary, writer);
            }
            File modelFile = new File(trainingFile.getAbsolutePath() + ".model");
            ImmutableList.Builder argBuilder = ImmutableList.builder();
            argBuilder.add((Object)"-c").add((Object)Double.toString(parameters.getC()));
            if (parameters.getWeights() != null) {
                for (int i = 0; i < parameters.getWeights().length; ++i) {
                    argBuilder.add((Object)("-w" + i)).add((Object)Float.toString(parameters.getWeights()[i]));
                }
            }
            argBuilder.add((Object)"-h").add((Object)Integer.toString(1));
            argBuilder.add((Object)"-b").add((Object)"1");
            if (parameters.getGamma() != null) {
                argBuilder.add((Object)"-g").add((Object)parameters.getGamma().toString());
            }
            if (parameters.getCoeff() != null) {
                argBuilder.add((Object)"-r").add((Object)parameters.getCoeff().toString());
            }
            if (parameters.getDegree() != null) {
                argBuilder.add((Object)"-d").add((Object)parameters.getDegree().toString());
            }
            argBuilder.add((Object)"-s").add((Object)"0");
            switch (parameters.getAlgorithm()) {
                case SVM_LINEAR_KERNEL: {
                    argBuilder.add((Object)"-t").add((Object)"0");
                    break;
                }
                case SVM_RBF_KERNEL: {
                    argBuilder.add((Object)"-t").add((Object)"2");
                    break;
                }
                case SVM_SIGMOID_KERNEL: {
                    argBuilder.add((Object)"-t").add((Object)"3");
                    break;
                }
                case SVM_POLY_KERNEL: {
                    argBuilder.add((Object)"-t").add((Object)"1");
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            argBuilder.add((Object)trainingFile.getAbsolutePath());
            argBuilder.add((Object)modelFile.getAbsolutePath());
            Classifier.invokeNative("svm-train", (Iterable)argBuilder.build(), false);
            String modelString = com.google.common.io.Files.toString((File)modelFile, (Charset)Charset.defaultCharset());
            String modelHash = Classifier.computeHash((Dictionary<String>)dictionary, modelString);
            svm_model model = svm.svm_load_model((BufferedReader)new BufferedReader(new StringReader(modelString)));
            trainingFile.delete();
            modelFile.delete();
            return new LibSvmClassifier(parameters, modelHash, (Dictionary<String>)dictionary, model);
        }

        private static svm_parameter encodeParameters(Parameters parameters) {
            svm_parameter param = new svm_parameter();
            param.svm_type = 0;
            param.eps = 0.001;
            param.shrinking = 1;
            param.probability = 1;
            param.cache_size = Math.min(1024.0, (double)(Runtime.getRuntime().maxMemory() / 2L));
            param.C = parameters.getC();
            switch (parameters.getAlgorithm()) {
                case SVM_LINEAR_KERNEL: {
                    param.kernel_type = 0;
                    break;
                }
                case SVM_RBF_KERNEL: {
                    param.kernel_type = 2;
                    param.gamma = parameters.getGamma().floatValue();
                    break;
                }
                case SVM_SIGMOID_KERNEL: {
                    param.kernel_type = 3;
                    param.gamma = parameters.getGamma().floatValue();
                    param.coef0 = parameters.getCoeff().floatValue();
                    break;
                }
                case SVM_POLY_KERNEL: {
                    param.kernel_type = 1;
                    param.gamma = parameters.getGamma().floatValue();
                    param.coef0 = parameters.getCoeff().floatValue();
                    param.degree = parameters.getDegree();
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            float[] weights = parameters.getWeights();
            if (weights != null) {
                param.nr_weight = weights.length;
                param.weight_label = new int[weights.length];
                param.weight = new double[weights.length];
                for (int i = 0; i < weights.length; ++i) {
                    param.weight_label[i] = i;
                    param.weight[i] = weights[i];
                }
            }
            return param;
        }

        private static svm_problem encodeProblem(Dictionary<String> dictionary, Iterable<LabelledVector> vectors) {
            int size = Iterables.size(vectors);
            svm_problem problem = new svm_problem();
            problem.l = size;
            problem.x = new svm_node[size][];
            problem.y = new double[size];
            int index = 0;
            for (LabelledVector vector : vectors) {
                problem.x[index] = LibSvmClassifier.encodeVector(dictionary, vector);
                problem.y[index] = vector.getLabel();
                ++index;
            }
            return problem;
        }

        private static svm_node[] encodeVector(Dictionary<String> dictionary, Vector vector) {
            int size = vector.size();
            svm_node[] nodes = new svm_node[size];
            int index = 0;
            for (int i = 0; i < size; ++i) {
                Integer featureIndex;
                String feature = vector.getFeature(i);
                if (feature.charAt(0) == '_' || (featureIndex = dictionary.indexFor((Object)vector.getFeature(i))) == null) continue;
                svm_node node = new svm_node();
                node.index = featureIndex;
                node.value = vector.getValue(i);
                nodes[index++] = node;
            }
            if (index < size) {
                nodes = Arrays.copyOfRange(nodes, 0, index);
            }
            Arrays.sort(nodes, NODE_ORDERING);
            return nodes;
        }

        static {
            svm.svm_set_print_string_function((svm_print_interface)new svm_print_interface(){

                public void print(String s) {
                    if (!".".equals(s) && !"*".equals(s)) {
                        LOGGER.debug("LIBSVM: " + s.replace('\n', ' ').trim());
                    }
                }
            });
        }
    }

    private static class LibLinearClassifier
    extends Classifier {
        private static final Ordering<Feature> FEATURE_ORDERING = new Ordering<Feature>(){

            public int compare(Feature left, Feature right) {
                return left.getIndex() - right.getIndex();
            }
        };
        private static final boolean NATIVE_LIB_AVAILABLE = Classifier.access$100("train", "Using native LIBLINEAR tools");
        private final Dictionary<String> dictionary;
        private final Model model;

        private LibLinearClassifier(Parameters parameters, String modelHash, Dictionary<String> dictionary, Model model) {
            super(parameters, modelHash);
            this.dictionary = (Dictionary)Preconditions.checkNotNull(dictionary);
            this.model = model;
        }

        @Override
        LabelledVector doPredict(boolean withProbabilities, Vector vector) {
            Feature[] features = LibLinearClassifier.encodeVector(this.dictionary, vector);
            if (withProbabilities) {
                int numLabels = this.getParameters().getNumLabels();
                double[] p = new double[numLabels];
                int label = (int)Linear.predictProbability((Model)this.model, (Feature[])features, (double[])p);
                float[] probabilities = new float[numLabels];
                for (int i = 0; i < p.length; ++i) {
                    int labelIndex = this.model.getLabels()[i];
                    probabilities[labelIndex] = (float)p[i];
                }
                return vector.label(label, probabilities);
            }
            double label = Linear.predict((Model)this.model, (Feature[])features);
            return vector.label((int)label, new float[0]);
        }

        @Override
        void doWrite(Path path) throws IOException {
            this.dictionary.writeTo(path.resolve("dictionary"));
            try (BufferedWriter writer = Files.newBufferedWriter(path.resolve("model"), new OpenOption[0]);){
                Linear.saveModel((Writer)writer, (Model)this.model);
            }
        }

        static Classifier doRead(Parameters parameters, Path path) throws IOException {
            Dictionary dictionary = Dictionary.readFrom(String.class, (Path)path.resolve("dictionary"));
            String modelString = new String(Files.readAllBytes(path.resolve("model")), Charsets.UTF_8);
            Model model = Model.load((Reader)new StringReader(modelString));
            String modelHash = Classifier.computeHash((Dictionary<String>)dictionary, modelString);
            return new LibLinearClassifier(parameters, modelHash, (Dictionary<String>)dictionary, model);
        }

        static Classifier doTrain(Parameters parameters, Iterable<LabelledVector> trainingSet) throws IOException {
            if (NATIVE_LIB_AVAILABLE) {
                return LibLinearClassifier.trainNative(parameters, trainingSet);
            }
            return LibLinearClassifier.trainJava(parameters, trainingSet);
        }

        private static Classifier trainJava(Parameters parameters, Iterable<LabelledVector> trainingSet) throws IOException {
            Parameter parameter = LibLinearClassifier.encodeParameters(parameters);
            parameter.setEps((double)(LibLinearClassifier.getDefaultEpsilon(parameters) * 0.1f));
            Dictionary dictionary = Dictionary.create();
            dictionary.indexFor((Object)"_unused");
            Problem problem = LibLinearClassifier.encodeProblem((Dictionary<String>)dictionary, trainingSet, parameters);
            Model model = Linear.train((Problem)problem, (Parameter)parameter);
            StringWriter writer = new StringWriter();
            Linear.saveModel((Writer)writer, (Model)model);
            String modelString = writer.toString();
            String modelHash = Classifier.computeHash((Dictionary<String>)dictionary, modelString);
            return new LibLinearClassifier(parameters, modelHash, (Dictionary<String>)dictionary, model);
        }

        private static Classifier trainNative(Parameters parameters, Iterable<LabelledVector> trainingSet) throws IOException {
            Preconditions.checkNotNull((Object)parameters);
            Preconditions.checkNotNull(trainingSet);
            Preconditions.checkArgument((Iterables.size(trainingSet) >= 2 ? 1 : 0) != 0);
            Dictionary dictionary = Dictionary.create();
            dictionary.indexFor((Object)"_unused");
            File trainingFile = File.createTempFile("training.", ".txt");
            trainingFile.deleteOnExit();
            try (Writer writer = IO.utf8Writer((OutputStream)IO.buffer((OutputStream)IO.write((String)trainingFile.getAbsolutePath())));){
                Vector.write(trainingSet, (Dictionary<String>)dictionary, writer);
            }
            File modelFile = new File(trainingFile.getAbsolutePath() + ".model");
            ImmutableList.Builder argBuilder = ImmutableList.builder();
            argBuilder.add((Object)"-c").add((Object)Double.toString(parameters.getC()));
            if (parameters.getWeights() != null) {
                for (int i = 0; i < parameters.getWeights().length; ++i) {
                    argBuilder.add((Object)("-w" + i)).add((Object)Float.toString(parameters.getWeights()[i]));
                }
            }
            if (parameters.getBias() != null) {
                argBuilder.add((Object)"-B").add((Object)parameters.getBias().toString());
            }
            argBuilder.add((Object)"-s");
            switch (parameters.getAlgorithm()) {
                case LINEAR_LRLOSS_L1REG: {
                    argBuilder.add((Object)"6");
                    break;
                }
                case LINEAR_LRLOSS_L2REG: {
                    argBuilder.add((Object)(parameters.getDual() != false ? "7" : "0"));
                    break;
                }
                case LINEAR_L2LOSS_L1REG: {
                    argBuilder.add((Object)"5");
                    break;
                }
                case LINEAR_L2LOSS_L2REG: {
                    argBuilder.add((Object)(parameters.getDual() != false ? "1" : "2"));
                    break;
                }
                case LINEAR_L1LOSS_L2REG: {
                    argBuilder.add((Object)"3");
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            argBuilder.add((Object)"-e").add((Object)Float.toString(LibLinearClassifier.getDefaultEpsilon(parameters) * 0.1f));
            argBuilder.add((Object)trainingFile.getAbsolutePath());
            argBuilder.add((Object)modelFile.getAbsolutePath());
            Classifier.invokeNative("train", (Iterable)argBuilder.build(), false);
            String modelString = com.google.common.io.Files.toString((File)modelFile, (Charset)Charset.defaultCharset());
            String modelHash = Classifier.computeHash((Dictionary<String>)dictionary, modelString);
            Model model = Model.load((Reader)new StringReader(modelString));
            trainingFile.delete();
            modelFile.delete();
            return new LibLinearClassifier(parameters, modelHash, (Dictionary<String>)dictionary, model);
        }

        private static float getDefaultEpsilon(Parameters parameters) {
            Algorithm alg = parameters.getAlgorithm();
            boolean dual = Boolean.TRUE.equals(parameters.getDual());
            if (alg == Algorithm.LINEAR_LRLOSS_L2REG && !dual || alg == Algorithm.LINEAR_L2LOSS_L2REG && !dual || alg == Algorithm.LINEAR_L2LOSS_L1REG || alg == Algorithm.LINEAR_LRLOSS_L1REG) {
                return 0.01f;
            }
            if (alg == Algorithm.LINEAR_L2LOSS_L2REG && dual || alg == Algorithm.LINEAR_L1LOSS_L2REG || alg == Algorithm.LINEAR_LRLOSS_L2REG && dual) {
                return 0.1f;
            }
            throw new IllegalArgumentException("Invalid parameters " + parameters);
        }

        private static Parameter encodeParameters(Parameters parameters) {
            Parameter parameter;
            Boolean dual = parameters.getDual();
            float c = parameters.getC();
            switch (parameters.getAlgorithm()) {
                case LINEAR_LRLOSS_L1REG: {
                    parameter = new Parameter(SolverType.L1R_LR, (double)c, (double)0.01f);
                    break;
                }
                case LINEAR_LRLOSS_L2REG: {
                    parameter = new Parameter(dual != false ? SolverType.L2R_LR_DUAL : SolverType.L2R_LR, (double)c, dual != false ? (double)0.1f : (double)0.01f);
                    break;
                }
                case LINEAR_L2LOSS_L1REG: {
                    parameter = new Parameter(SolverType.L1R_L2LOSS_SVC, (double)c, (double)0.01f);
                    break;
                }
                case LINEAR_L2LOSS_L2REG: {
                    parameter = new Parameter(dual != false ? SolverType.L2R_L2LOSS_SVC_DUAL : SolverType.L2R_L2LOSS_SVC, (double)c, dual != false ? (double)0.1f : (double)0.01f);
                    break;
                }
                case LINEAR_L1LOSS_L2REG: {
                    parameter = new Parameter(SolverType.L2R_L1LOSS_SVC_DUAL, (double)c, (double)0.1f);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            float[] weights = parameters.getWeights();
            if (weights != null) {
                double[] weightValues = new double[weights.length];
                int[] weightLabels = new int[weights.length];
                for (int i = 0; i < weights.length; ++i) {
                    weightLabels[i] = i;
                    weightValues[i] = weights[i];
                }
                parameter.setWeights(weightValues, weightLabels);
            }
            return parameter;
        }

        private static Problem encodeProblem(Dictionary<String> dictionary, Iterable<LabelledVector> vectors, Parameters parameters) {
            int size = Iterables.size(vectors);
            Problem problem = new Problem();
            problem.l = size;
            problem.bias = ((Float)MoreObjects.firstNonNull((Object)parameters.getBias(), (Object)Float.valueOf(-1.0f))).doubleValue();
            problem.x = new Feature[size][];
            problem.y = new double[size];
            int index = 0;
            Set features = Sets.newIdentityHashSet();
            for (LabelledVector vector : vectors) {
                problem.x[index] = LibLinearClassifier.encodeVector(dictionary, vector);
                problem.y[index] = vector.getLabel();
                ++index;
                for (int i = 0; i < vector.size(); ++i) {
                    String feature = vector.getFeature(i);
                    if (feature.charAt(0) == '_') continue;
                    features.add(feature);
                }
            }
            problem.n = features.size() + (problem.bias >= 0.0 ? 1 : 0);
            return problem;
        }

        private static Feature[] encodeVector(Dictionary<String> dictionary, Vector vector) {
            int size = vector.size();
            Feature[] features = new Feature[size];
            int index = 0;
            for (int i = 0; i < size; ++i) {
                Integer featureIndex;
                String feature = vector.getFeature(i);
                if (feature.charAt(0) == '_' || (featureIndex = dictionary.indexFor((Object)vector.getFeature(i))) == null) continue;
                features[index++] = new FeatureNode(featureIndex.intValue(), (double)vector.getValue(i));
            }
            if (index < size) {
                features = Arrays.copyOfRange(features, 0, index);
            }
            Arrays.sort(features, FEATURE_ORDERING);
            return features;
        }

        static {
            Linear.disableDebugOutput();
        }
    }

    public static enum Algorithm {
        LINEAR_LRLOSS_L1REG(true, true, false),
        LINEAR_LRLOSS_L2REG(true, true, false),
        LINEAR_L2LOSS_L1REG(false, true, false),
        LINEAR_L2LOSS_L2REG(false, true, false),
        LINEAR_L1LOSS_L2REG(false, true, false),
        SVM_LINEAR_KERNEL(true, false, true),
        SVM_RBF_KERNEL(true, false, true),
        SVM_SIGMOID_KERNEL(true, false, true),
        SVM_POLY_KERNEL(true, false, true);

        private boolean supportsProbabilities;
        private boolean linear;
        private boolean svm;

        private Algorithm(boolean supportsProbabilities, boolean linear, boolean svm2) {
            this.supportsProbabilities = supportsProbabilities;
            this.linear = linear;
            this.svm = svm2;
        }

        public boolean supportsProbabilities() {
            return this.supportsProbabilities;
        }

        public boolean isLinear() {
            return this.linear;
        }

        public boolean isSVM() {
            return this.svm;
        }
    }

    public static final class Parameters {
        private static final Float DEFAULT_C = Float.valueOf(1.0f);
        private static final Float DEFAULT_BIAS = Float.valueOf(-1.0f);
        private static final Boolean DEFAULT_DUAL = Boolean.TRUE;
        private static final Float DEFAULT_COEFF = Float.valueOf(0.0f);
        private static final Integer DEFAULT_DEGREE = 3;
        private static final Float DEFAULT_GAMMA = Float.valueOf(1.0f);
        private final Algorithm algorithm;
        private final int numLabels;
        @Nullable
        private final float[] weights;
        private final float c;
        @Nullable
        private final Float bias;
        @Nullable
        private final Boolean dual;
        @Nullable
        private final Float gamma;
        @Nullable
        private final Float coeff;
        @Nullable
        private final Integer degree;

        private Parameters(Algorithm algorithm, int numLabels, @Nullable float[] weights, @Nullable Float c, @Nullable Float bias, @Nullable Boolean dual, @Nullable Float gamma, @Nullable Float coeff, @Nullable Integer degree) {
            Preconditions.checkNotNull((Object)((Object)algorithm));
            Preconditions.checkArgument((numLabels >= 2 ? 1 : 0) != 0);
            Preconditions.checkArgument((weights == null || weights.length == numLabels ? 1 : 0) != 0);
            Preconditions.checkArgument((c == null || c.floatValue() > 0.0f ? 1 : 0) != 0);
            Preconditions.checkArgument((degree == null || degree >= 1 ? 1 : 0) != 0);
            this.algorithm = algorithm;
            this.numLabels = numLabels;
            this.weights = weights;
            this.c = (c != null ? c : DEFAULT_C).floatValue();
            Float f = algorithm.isLinear() ? (bias != null ? bias : DEFAULT_BIAS) : (this.bias = null);
            Boolean bl = algorithm == Algorithm.LINEAR_L2LOSS_L2REG || algorithm == Algorithm.LINEAR_LRLOSS_L2REG ? (dual != null ? dual : DEFAULT_DUAL) : (this.dual = null);
            Float f2 = algorithm == Algorithm.SVM_POLY_KERNEL || algorithm == Algorithm.SVM_RBF_KERNEL || algorithm == Algorithm.SVM_SIGMOID_KERNEL ? (gamma != null ? gamma : DEFAULT_GAMMA) : (this.gamma = null);
            Float f3 = algorithm == Algorithm.SVM_POLY_KERNEL || algorithm == Algorithm.SVM_SIGMOID_KERNEL ? (coeff != null ? coeff : DEFAULT_COEFF) : (this.coeff = null);
            this.degree = algorithm == Algorithm.SVM_POLY_KERNEL ? (degree != null ? degree : DEFAULT_DEGREE) : null;
        }

        public static Parameters forLinearLRLossL1Reg(int numLabels, @Nullable float[] weights, @Nullable Float c, @Nullable Float bias) {
            return new Parameters(Algorithm.LINEAR_LRLOSS_L1REG, numLabels, weights, c, bias, null, null, null, null);
        }

        public static Parameters forLinearLRLossL2Reg(int numLabels, @Nullable float[] weights, @Nullable Float c, @Nullable Float bias, @Nullable Boolean dual) {
            return new Parameters(Algorithm.LINEAR_LRLOSS_L2REG, numLabels, weights, c, bias, dual, null, null, null);
        }

        public static Parameters forLinearL2LossL1Reg(int numLabels, @Nullable float[] weights, @Nullable Float c, @Nullable Float bias) {
            return new Parameters(Algorithm.LINEAR_L2LOSS_L1REG, numLabels, weights, c, bias, null, null, null, null);
        }

        public static Parameters forLinearL2LossL2Reg(int numLabels, @Nullable float[] weights, @Nullable Float c, @Nullable Float bias, @Nullable Boolean dual) {
            return new Parameters(Algorithm.LINEAR_L2LOSS_L2REG, numLabels, weights, c, bias, dual, null, null, null);
        }

        public static Parameters forLinearL1LossL2Reg(int numLabels, @Nullable float[] weights, @Nullable Float c, @Nullable Float bias) {
            return new Parameters(Algorithm.LINEAR_L1LOSS_L2REG, numLabels, weights, c, bias, null, null, null, null);
        }

        public static Parameters forSVMLinearKernel(int numLabels, @Nullable float[] weights, @Nullable Float c) {
            return new Parameters(Algorithm.SVM_LINEAR_KERNEL, numLabels, weights, c, null, null, null, null, null);
        }

        public static Parameters forSVMRBFKernel(int numLabels, @Nullable float[] weights, @Nullable Float c, @Nullable Float gamma) {
            return new Parameters(Algorithm.SVM_RBF_KERNEL, numLabels, weights, c, null, null, gamma, null, null);
        }

        public static Parameters forSVMSigmoidKernel(int numLabels, @Nullable float[] weights, @Nullable Float c, @Nullable Float gamma, @Nullable Float coeff) {
            return new Parameters(Algorithm.SVM_RBF_KERNEL, numLabels, weights, c, null, null, gamma, coeff, null);
        }

        public static Parameters forSVMPolyKernel(int numLabels, @Nullable float[] weights, @Nullable Float c, @Nullable Float gamma, @Nullable Float coeff, @Nullable Integer degree) {
            return new Parameters(Algorithm.SVM_RBF_KERNEL, numLabels, weights, c, null, null, gamma, coeff, degree);
        }

        public static Parameters forProperties(Properties properties, @Nullable String prefix) {
            Properties p = properties;
            String pr = prefix != null ? prefix : "";
            Algorithm algorithm = Algorithm.valueOf(p.getProperty(pr + "algorithm").toUpperCase());
            int numLabels = Integer.parseInt(p.getProperty(pr + "numLabels"));
            float c = Float.parseFloat(p.getProperty(pr + "c"));
            Float bias = (Float)Conversion.convert((Object)p.getProperty(pr + "bias"), Float.class);
            Boolean dual = (Boolean)Conversion.convert((Object)p.getProperty(pr + "dual"), Boolean.class);
            Float gamma = (Float)Conversion.convert((Object)p.getProperty(pr + "gamma"), Float.class);
            Float coeff = (Float)Conversion.convert((Object)p.getProperty(pr + "coeff"), Float.class);
            Integer degree = (Integer)Conversion.convert((Object)p.getProperty(pr + "degree"), Integer.class);
            float[] weights = null;
            if (p.containsKey(pr + "weight.0")) {
                weights = new float[numLabels];
                for (int i = 0; i < numLabels; ++i) {
                    weights[i] = ((Float)Conversion.convert((Object)p.getProperty(pr + "weight." + i), Float.class)).floatValue();
                }
            }
            return new Parameters(algorithm, numLabels, weights, Float.valueOf(c), bias, dual, gamma, coeff, degree);
        }

        public Algorithm getAlgorithm() {
            return this.algorithm;
        }

        public int getNumLabels() {
            return this.numLabels;
        }

        @Nullable
        public float[] getWeights() {
            return this.weights == null ? null : (float[])this.weights.clone();
        }

        public float getC() {
            return this.c;
        }

        @Nullable
        public Float getBias() {
            return this.bias;
        }

        @Nullable
        public Boolean getDual() {
            return this.dual;
        }

        @Nullable
        public Float getGamma() {
            return this.gamma;
        }

        @Nullable
        public Integer getDegree() {
            return this.degree;
        }

        @Nullable
        public Float getCoeff() {
            return this.coeff;
        }

        public List<Parameters> grid(int maxCombinations, float multiplier) {
            float m;
            int nc = this.gamma == null && (this.bias == null || this.bias.floatValue() < 0.0f) ? maxCombinations : (int)Math.sqrt(maxCombinations);
            ArrayList cs = Lists.newArrayList((Object[])new Float[]{Float.valueOf(this.c)});
            for (m = multiplier; cs.size() < nc && m <= 1.0E7f; m *= 10.0f) {
                if (this.c * m <= 100000.0f) {
                    cs.add(Float.valueOf(this.c * m));
                }
                if (cs.size() >= nc || !((double)(this.c / m) >= 0.01)) continue;
                cs.add(Float.valueOf(this.c / m));
            }
            ArrayList biases = Lists.newArrayList((Object[])new Float[]{this.bias});
            if (this.bias != null && this.bias.floatValue() > 0.0f) {
                int nbias = maxCombinations / cs.size();
                for (m = 10.0f; biases.size() < nbias && m <= 1000000.0f; m *= 10.0f) {
                    if (this.bias.floatValue() * m <= 1000.0f) {
                        biases.add(Float.valueOf(this.bias.floatValue() * m));
                    }
                    if (biases.size() >= nbias || !(this.bias.floatValue() / m >= 0.001f)) continue;
                    biases.add(Float.valueOf(this.bias.floatValue() / m));
                }
            }
            ArrayList gammas = Lists.newArrayList((Object[])new Float[]{this.gamma});
            if (this.gamma != null) {
                int ngamma = maxCombinations / cs.size();
                for (m = 10.0f; gammas.size() < ngamma && m <= 1000000.0f; m *= 10.0f) {
                    if (this.gamma.floatValue() * m <= 10.0f) {
                        gammas.add(Float.valueOf(this.gamma.floatValue() * m));
                    }
                    if (gammas.size() >= ngamma || !(this.gamma.floatValue() / m >= 1.0E-5f)) continue;
                    gammas.add(Float.valueOf(this.gamma.floatValue() / m));
                }
            }
            ArrayList result = Lists.newArrayList((Object[])new Parameters[]{this});
            Iterator iterator = cs.iterator();
            while (iterator.hasNext()) {
                float c = ((Float)iterator.next()).floatValue();
                for (Float bias : biases) {
                    for (Float gamma : gammas) {
                        result.add(new Parameters(this.algorithm, this.numLabels, this.weights, Float.valueOf(c), bias, this.dual, gamma, this.coeff, this.degree));
                    }
                }
            }
            return result;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Parameters)) {
                return false;
            }
            Parameters other = (Parameters)object;
            return this.algorithm == other.algorithm && this.numLabels == other.numLabels && Arrays.equals(this.weights, other.weights) && this.c == other.c && Objects.equal((Object)this.bias, (Object)other.bias) && Objects.equal((Object)this.dual, (Object)other.dual) && Objects.equal((Object)this.gamma, (Object)other.gamma) && Objects.equal((Object)this.coeff, (Object)other.coeff) && Objects.equal((Object)this.degree, (Object)other.degree);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.algorithm, this.numLabels, Arrays.hashCode(this.weights), Float.valueOf(this.c), this.bias, this.dual, this.gamma, this.coeff, this.degree});
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)(this.algorithm.toString().toLowerCase() + " classifier")).omitNullValues().add("#labels", this.numLabels).add("weights", (Object)Arrays.toString(this.weights)).add("C", this.c).add("bias", (Object)this.bias).add("dual", (Object)this.dual).add("gamma", (Object)this.gamma).add("coeff", (Object)this.coeff).add("degree", (Object)this.degree).toString();
        }

        public Properties toProperties(@Nullable Properties properties, @Nullable String prefix) {
            Properties p = properties != null ? properties : new Properties();
            String pr = prefix != null ? prefix : "";
            p.setProperty(pr + "algorithm", this.algorithm.toString());
            p.setProperty(pr + "numLabels", Integer.toString(this.numLabels));
            p.setProperty(pr + "c", Float.toString(this.c));
            for (int i = 0; i < (this.weights == null ? 0 : this.weights.length); ++i) {
                p.setProperty(pr + "weight." + i, Float.toString(this.weights[i]));
            }
            if (this.bias != null) {
                p.setProperty(pr + "bias", Float.toString(this.bias.floatValue()));
            }
            if (this.dual != null) {
                p.setProperty(pr + "dual", Boolean.toString(this.dual));
            }
            if (this.gamma != null) {
                p.setProperty(pr + "gamma", Float.toString(this.gamma.floatValue()));
            }
            if (this.coeff != null) {
                p.setProperty(pr + "coeff", Float.toString(this.coeff.floatValue()));
            }
            if (this.degree != null) {
                p.setProperty(pr + "degree", Integer.toString(this.degree));
            }
            return p;
        }
    }
}

