/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.differentiation;

import org.apache.commons.math3.analysis.MultivariateMatrixFunction;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.MultivariateDifferentiableVectorFunction;

public class JacobianFunction
implements MultivariateMatrixFunction {
    private final MultivariateDifferentiableVectorFunction f;

    public JacobianFunction(MultivariateDifferentiableVectorFunction f) {
        this.f = f;
    }

    public double[][] value(double[] point2) {
        DerivativeStructure[] dsX = new DerivativeStructure[point2.length];
        for (int i = 0; i < point2.length; ++i) {
            dsX[i] = new DerivativeStructure(point2.length, 1, i, point2[i]);
        }
        DerivativeStructure[] dsY = this.f.value(dsX);
        double[][] y = new double[dsY.length][point2.length];
        int[] orders = new int[point2.length];
        for (int i = 0; i < dsY.length; ++i) {
            for (int j = 0; j < point2.length; ++j) {
                orders[j] = 1;
                y[i][j] = dsY[i].getPartialDerivative(orders);
                orders[j] = 0;
            }
        }
        return y;
    }
}

